/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: WorkingMemory.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_WORKING_MEMORY_HPP_
#define _TOPS_WORKING_MEMORY_HPP_

#include "tops/WMElement.hpp"
#include "tops/common/Printable.hpp"

#include "tops/utilities/CloseContainer.hpp"
#include "tops/utilities/Iterator/MapIterator.hpp"
#include "tops/utilities/Iterator/SharedToPointerIterator.hpp"

#include <string>

namespace tops {

	/**
	 * [LOłB
	 *
	 * @author gDC[
	 */
	class WorkingMemory : public Printable {
	private:
		typedef Utility::CloseMultiMap<std::string, WMElementPtr> ElementMap;
		typedef ElementMap::iterator InnerMapIterator;
		typedef ElementMap::const_iterator ConstInnerMapIterator;

		typedef Utility::MapIteratorSecond<InnerMapIterator, WMElementPtr> MapSecondIterator;
		typedef Utility::ConstMapIteratorSecond<ConstInnerMapIterator, WMElementPtr> ConstMapSecondIterator;

		typedef Utility::CloseList<WMElementPtr> ElementList;
		typedef ElementList::iterator InnerIterator;
		typedef ElementList::const_iterator ConstInnerIterator;

	public:
		typedef Utility::SharedToPointerIterator<MapSecondIterator, WMElement> MapIterator;
		typedef Utility::ConstSharedToPointerIterator<ConstMapSecondIterator, WMElement> ConstMapIterator;

		typedef Utility::SharedToPointerIterator<InnerIterator, WMElement> iterator;
		typedef Utility::ConstSharedToPointerIterator<ConstInnerIterator, WMElement> const_iterator;

	private:
		/**
		 * OŌ\ȃ[LOvfłB
		 */
		ElementMap m_namedElements;

		/**
		 * }Ƀ\[eBOꂽ[LOvfłB
		 */
		ElementList m_orderedElements;

		/**
		 * JE^łB
		 */
		unsigned long m_count;

	public:
		/**
		 * [LO\z܂B
		 */
		WorkingMemory() : m_count(1) {
		}

		/**
		 * [LOj܂B
		 */
		~WorkingMemory();

	private:
		WMElement* createWMElement(const FactPtr& fact);

	public:
		/**
		 * ǉ܂
		 *
		 * @param fact ǉ鎖w肵܂B
		 *
		 * @return
		 * ǉꍇ́Aǉꂽ[LOvfԂ܂B
		 * ȊȌꍇNULLԂ܂B
		 */
		WMElement* add(const FactPtr& fact);

	public:
		/**
		 * ɑ݂邩ǂ𔻒f܂B
		 *
		 * @return ݂ꍇ͑Ή郏[LOvfA݂ȂꍇNULLԂ܂B
		 */
		WMElement* searchFact(const FactPtr& target) const;

	public:
		/**
		 * 󂩂ǂ𔻒f܂B
		 *
		 * @return 󂾂trueA󂶂ȂfalseԂ܂B
		 */
		bool empty() const;

		/**
		 * TCY擾܂B
		 */
		size_t size() const;

		/**
		 * w肵Ovf̃TCY擾܂B
		 */
		size_t size(const std::string& name) const;

	public:
		/**
		 * Svf̐擪q擾܂B
		 */
		iterator begin();

		/**
		 * Svf̐擪q擾܂B
		 */
		const_iterator begin() const;

		/**
		 * Svf̖q擾܂B
		 */
		iterator end();

		/**
		 * Svf̖q擾܂B
		 */
		const_iterator end() const;

	public:
		/**
		 * w肵Oŏ̗vf擾܂B
		 */
		ConstMapIterator lower_bound(const std::string& name) const;

		/**
		 * Svf̖q擾܂B
		 */
		ConstMapIterator endMap() const;

	public:
		/**
		 * Oŗvfi荞݂܂B
		 *
		 * @param name i荞ނ߂Ɏgp閼Ow肵܂B
		 */
		std::pair<MapIterator, MapIterator> range(const std::string& name);

		/**
		 * Oŗvfi荞݂܂B
		 *
		 * @param name i荞ނ߂Ɏgp閼Ow肵܂B
		 */
		std::pair<ConstMapIterator, ConstMapIterator> range(const std::string& name) const;

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
