/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: AttributesOfCondition.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_ATTRIBUTES_OF_CONDITION_HPP_
#define _TOPS_ATTRIBUTES_OF_CONDITION_HPP_

#include "tops/attribute/AttributeOfCondition.hpp"
#include "tops/attribute/Attributes.hpp"

#include <string>
#include <vector>

namespace tops {

	class AttributeOfFact;
	class AttributesOfFact;
	class UnificatedAttributes;
	typedef boost::shared_ptr<UnificatedAttributes> UnificatedAttributesPtr;
	class Value;
	typedef boost::shared_ptr<Value> ValuePtr;
	class Variables;

	/**
	 * ̑łB
	 *
	 * @author gDC[
	 */
	class AttributesOfCondition : public Attributes {
	private:
		typedef std::vector<AttributeOfCondition> AttributeVector;
		typedef AttributeVector::iterator iterator;
		typedef AttributeVector::const_iterator const_iterator;

		/**
		 * łB
		 */
		AttributeVector m_attributes;

	public:
		/**
		 * TCY擾܂B
		 */
		size_t size() const {
			return m_attributes.size();
		}

		/**
		 * 擾܂B
		 */
		const AttributeOfCondition& operator[](size_t index) const;

		/**
		 * ǉ܂B
		 * ɓ̑o^Ăꍇ͎s܂B
		 *
		 * @param name w肵܂B
		 * @param value lƂȂϐw肵܂B
		 *
		 * @return ̒ǉɐꍇ͂̑AsꍇNULLԂ܂B
		 */
		bool add(const std::string& name, const ValuePtr& value);

	public:
		/**
		 * w肳ꂽԍɑ΂āAw肳ꂽ̑ƒPꉻs܂B
		 *
		 * @param index ԍw肵܂B
		 * @param attributes PꉻΏۂƂȂ鎖̑w肵܂B
		 * @param variables PꉻɎgpϐ\w肵܂B
		 *
		 * @return Pꉻɐꍇ͒PꉻΏۂƂȂAsNULLԂ܂B
		 */
		AttributeOfFact* unificate(size_t index, const AttributesOfFact& attributes, Variables& variables);

	public:
		/**
		 * w肳ꂽ̑ƒPꉻs܂B
		 *
		 * @param attributes PꉻΏۂƂȂ鎖̑w肵܂B
		 * @param variables PꉻɎgpϐ\w肵܂B
		 *
		 * @return Pꉻɐꍇ͒PꉻςݑAsꍇNULLԂ܂B
		 */
		UnificatedAttributesPtr unificate(const AttributesOfFact& attributes, Variables& variables);

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
