/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: AttributesOfFact.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_ATTRIBUTES_OF_FACT_HPP_
#define _TOPS_ATTRIBUTES_OF_FACT_HPP_

#include "tops/attribute/AttributeOfFact.hpp"
#include "tops/attribute/Attributes.hpp"

#include "tops/utilities/CloseContainer.hpp"
#include "tops/utilities/Iterator/MapIterator.hpp"
#include "tops/utilities/Iterator/SharedToPointerIterator.hpp"

#include <map>
#include <string>

#include <boost/shared_ptr.hpp>

namespace tops {

	class Constant;
	typedef boost::shared_ptr<Constant> ConstantPtr;
	class Value;
	typedef boost::shared_ptr<Value> ValuePtr;
	class Variables;

	class AttributesOfFact;
	typedef boost::shared_ptr<AttributesOfFact> AttributesOfFactPtr;

	/**
	 * ̑łB
	 *
	 * @author gDC[
	 */
	class AttributesOfFact : public Attributes {
	private:
		typedef Utility::CloseMap<std::string, AttributeOfFactPtr> AttributeMap;

		/**
		 * łB
		 */
		AttributeMap m_attributes;

	public:
		typedef AttributeMap::iterator InnerMapIterator;
		typedef AttributeMap::const_iterator ConstInnerMapIterator;

		typedef Utility::MapIteratorSecond<InnerMapIterator, AttributeOfFactPtr> MapSecondIterator;
		typedef Utility::ConstMapIteratorSecond<ConstInnerMapIterator, AttributeOfFactPtr> ConstMapSecondIterator;

		typedef Utility::SharedToPointerIterator<MapSecondIterator, AttributeOfFact> MapIterator;
		typedef Utility::ConstSharedToPointerIterator<ConstMapSecondIterator, AttributeOfFact> ConstMapIterator;

	public:
		/**
		 * TCY擾܂B
		 */
		size_t size() const {
			return m_attributes.size();
		}

		/**
		 * 擪̑ւ̔q擾܂B
		 */
		MapIterator begin() {
			return m_attributes.begin();
		}

		/**
		 * 擪̑ւ̒萔q擾܂B
		 */
		ConstMapIterator begin() const {
			return m_attributes.begin();
		}

		/**
		 * ̑ւ̔q擾܂B
		 */
		MapIterator end() {
			return m_attributes.end();
		}

		/**
		 * ̑ւ̒萔q擾܂B
		 */
		ConstMapIterator end() const {
			return m_attributes.end();
		}

		/**
		 * ǉ܂B
		 * ɓ̑o^Ăꍇ͎s܂B
		 *
		 * @param name w肵܂B
		 * @param constant lƂȂ萔w肵܂B
		 *
		 * @return ̒ǉɐꍇ͂̑AsꍇNULLԂ܂B
		 */
		AttributeOfFact* add(const std::string& name, const ConstantPtr& constant);

		/**
		 * O瑮l擾܂B
		 *
		 * @param name w肵܂B
		 * @param result lԂ܂B
		 *
		 * @return ^ꂽOꍇ͂̑AłȂꍇNULLԂ܂B
		 */
		AttributeOfFact* find(const std::string& name) const;

	private:
		/**
		 * ݂̑𔻒f܂B
		 *
		 * @param name w肵܂B
		 * @param constant lw肵܂B
		 */
		bool exists(const std::string& name, const ConstantPtr& constant) const;

	public:
		/**
		 * Pꉻs܂B
		 *
		 * @param name ̖Ow肵܂B
		 * @param value PꉻΏۂƂȂϐw肵܂B
		 * @param variables PꉻɎgpϐ\w肵܂B
		 *
		 * @return Pꉻɐꍇ͂̑AsꍇNULLԂ܂B
		 */
		AttributeOfFact* unificate(const std::string& name, const ValuePtr& value, Variables& variables) const;

	public:
		/**
		 * lfs܂B
		 *
		 * @param attributes lfΏۂƂȂ鎖̑w肵܂B
		 *
		 * @return lȂtrueAȂȂfalseԂ܂B
		 */
		bool equals(const AttributesOfFact& attributes) const;

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
