/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Condition.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_CONDITION_HPP_
#define _TOPS_CONDITION_HPP_

#include "tops/attribute/AttributesOfCondition.hpp"
#include "tops/object/Object.hpp"

#include <boost/shared_ptr.hpp>

namespace tops {

	class Condition;
	typedef boost::shared_ptr<Condition> ConditionPtr;
	class Fact;

	/**
	 * łB
	 *
	 * @author gDC[
	 */
	class Condition : public Object {
	private:
		/**
		 * xłB
		 */
		std::string m_label;

		/**
		 * łB
		 */
		AttributesOfCondition m_attributes;

	public:
		/**
		 * ̖\z܂B
		 *
		 * @param name ̖Ow肵܂B
		 * @param label xw肵܂B
		 */
		Condition(const std::string& name, const std::string& label=std::string()) :
		Object(name), m_label(label) {
		}

		/**
		 * \z܂B
		 *
		 * @param name ̖Ow肵܂B
		 * @param attributes ƂȂ鑮w肵܂B
		 * @param label xw肵܂B
		 */
		Condition(const std::string& name,
		          const AttributesOfCondition& attributes,
		          const std::string& label=std::string()) :
		Object(name), m_label(label), m_attributes(attributes) {
		}

	public:
		/**
		 * xtĂ邩ǂ𔻒f܂B
		 *
		 * @return xtĂꍇtrueAĂȂꍇfalseԂ܂B
		 */
		bool isLabeled() const {
			return !m_label.empty();
		}

		/**
		 * x擾܂B
		 */
		const std::string& getLabel() const {
			return m_label;
		}

	public:
		/**
		 * w肳ꂽƒPꉻs܂B
		 *
		 * @param fact PꉻΏۂƂȂ鎖w肵܂B
		 * @param element Pꉻςݗvfw肵܂B
		 * @param variables PꉻɎgpϐ\w肵܂B
		 *
		 * @return Pꉻɐꍇ͒PꉻςݑAsꍇNULLԂ܂B
		 */
		UnificatedAttributesPtr unificate(const Fact& fact, Variables& variables);

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
