/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: AParser.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef INC_AParser_hpp_
#define INC_AParser_hpp_

#include <antlr/config.hpp>
/* $ANTLR 2.7.7 (20060930): "parser.g" -> "AParser.hpp"$ */
#include <antlr/TokenStream.hpp>
#include <antlr/TokenBuffer.hpp>
#include "ATreeParserTokenTypes.hpp"
#include <antlr/LLkParser.hpp>

#line 1 "parser.g"

#include "ATreeParserTokenTypes.hpp"

#include "tops/ActionPart.hpp"
#include "tops/ConditionPart.hpp"
#include "tops/FactOrRule.hpp"
#include "tops/Rule.hpp"

#include "tops/action/AddAttributeAction.hpp"
#include "tops/action/MakeAction.hpp"

#include "tops/attribute/AllAttributes.hpp"
#include "tops/object/AllObjects.hpp"
#include "tops/value/AllValues.hpp"

#include "tops/parser/VariableAllocator.hpp"

using namespace tops;

#line 32 "AParser.hpp"
class CUSTOM_API AParser : public ANTLR_USE_NAMESPACE(antlr)LLkParser, public ATreeParserTokenTypes
{
#line 1 "parser.g"
#line 36 "AParser.hpp"
public:
	void initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& factory );
protected:
	AParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf, int k);
public:
	AParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf);
protected:
	AParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer, int k);
public:
	AParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer);
	AParser(const ANTLR_USE_NAMESPACE(antlr)ParserSharedInputState& state);
	int getNumTokens() const
	{
		return AParser::NUM_TOKENS;
	}
	const char* getTokenName( int type ) const
	{
		if( type > getNumTokens() ) return 0;
		return AParser::tokenNames[type];
	}
	const char* const* getTokenNames() const
	{
		return AParser::tokenNames;
	}
	public: void factOrRule();
	public: void rule();
	public: void fact();
	public: void condition();
	public: void action();
	public: void makeAction();
	public: void add_attrAction();
	public: void objectInAction();
	public: void attributeOfObjectInAction();
	public: void attributeOfFact();
	public: void constant();
	public: void lhs();
	public: void attributeOfCondition();
	public: void value();
	public: void instantiableValue();
	public: void conditionalVariable();
	public: void variable();
	public: void comparator();
	public: void computeValue();
	public: void atom();
	public: void integer();
	public: void sign();
	public: void expr();
	public: void expr_1();
	public: void expr_2();
	public: void expr_3();
	public: void expr_atom();
	public: void expr_integer();
	public: void expr_variable();
	public: void expr_paren();
	public: void expr_sign();
public:
	ANTLR_USE_NAMESPACE(antlr)RefAST getAST()
	{
		return returnAST;
	}
	
protected:
	ANTLR_USE_NAMESPACE(antlr)RefAST returnAST;
private:
	static const char* tokenNames[];
#ifndef NO_STATIC_CONSTS
	static const int NUM_TOKENS = 64;
#else
	enum {
		NUM_TOKENS = 64
	};
#endif
	
	static const unsigned long _tokenSet_0_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_0;
};

#endif /*INC_AParser_hpp_*/
