/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: ATreeParser.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef INC_ATreeParser_hpp_
#define INC_ATreeParser_hpp_

#include <antlr/config.hpp>
#include "ATreeParserTokenTypes.hpp"
/* $ANTLR 2.7.7 (20060930): "parser.g" -> "ATreeParser.hpp"$ */
#include <antlr/TreeParser.hpp>

#line 1 "parser.g"

#include "ATreeParserTokenTypes.hpp"

#include "tops/ActionPart.hpp"
#include "tops/ConditionPart.hpp"
#include "tops/FactOrRule.hpp"
#include "tops/Rule.hpp"

#include "tops/action/AddAttributeAction.hpp"
#include "tops/action/MakeAction.hpp"

#include "tops/attribute/AllAttributes.hpp"
#include "tops/object/AllObjects.hpp"
#include "tops/value/AllValues.hpp"

#include "tops/parser/VariableAllocator.hpp"

using namespace tops;

#line 30 "ATreeParser.hpp"
class CUSTOM_API ATreeParser : public ANTLR_USE_NAMESPACE(antlr)TreeParser, public ATreeParserTokenTypes
{
#line 1 "parser.g"
#line 34 "ATreeParser.hpp"
public:
	ATreeParser();
	static void initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& factory );
	int getNumTokens() const
	{
		return ATreeParser::NUM_TOKENS;
	}
	const char* getTokenName( int type ) const
	{
		if( type > getNumTokens() ) return 0;
		return ATreeParser::tokenNames[type];
	}
	const char* const* getTokenNames() const
	{
		return ATreeParser::tokenNames;
	}
	public: FactOrRule  factOrRule(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
	public: FactPtr  fact(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
	public: RulePtr  rule(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
	public: void lhs(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		ConditionPart& conditions, VariableAllocator& vAllocator
	);
	public: void rhs(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		ActionPart& actions, VariableAllocator& vAllocator
	);
	public: ConditionPtr  condition(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		VariableAllocator& vAllocator
	);
	public: ActionPtr  action(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		VariableAllocator& vAllocator
	);
	public: ActionPtr  makeAction(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		VariableAllocator& vAllocator
	);
	public: ActionPtr  add_attrAction(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		VariableAllocator& vAllocator
	);
	public: ObjectInActionPtr  objectInAction(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		VariableAllocator& vAllocator
	);
	public: void attributeOfObjectInAction(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		AttributesOfObjectInAction& attributes, VariableAllocator& vAllocator
	);
	public: void attributeOfFact(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		AttributesOfFact& attributes
	);
	public: ConstantPtr  constant(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
	public: void attributeOfCondition(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		AttributesOfCondition& attributes, VariableAllocator& vAllocator
	);
	public: ValuePtr  value(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		VariableAllocator& vAllocator
	);
	public: ValuePtr  instantiableValue(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		VariableAllocator& vAllocator
	);
	public: void conditionalVariable(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		ValuePtr& result, VariableAllocator& vAllocator
	);
	public: VariablePtr  variable(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		VariableAllocator& vAllocator
	);
	public: COMPARATOR_ID  comparator(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
	public: ValuePtr  computeValue(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		VariableAllocator& vAllocator
	);
	public: void atom(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		ConstantPtr& result
	);
	public: void integer(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		ConstantPtr& result
	);
	public: int  sign(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
	public: std::string  expr(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		VariableAllocator& vAllocator
	);
	public: std::string  expr_variable(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		VariableAllocator& vAllocator
	);
	public: int  expr_integer(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
	public: int  expr_sign(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
public:
	ANTLR_USE_NAMESPACE(antlr)RefAST getAST()
	{
		return returnAST;
	}
	
protected:
	ANTLR_USE_NAMESPACE(antlr)RefAST returnAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST _retTree;
private:
	static const char* tokenNames[];
#ifndef NO_STATIC_CONSTS
	static const int NUM_TOKENS = 64;
#else
	enum {
		NUM_TOKENS = 64
	};
#endif
	
};

#endif /*INC_ATreeParser_hpp_*/
