/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: PSParser.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_PS_PARSER_HPP_
#define _TOPS_PS_PARSER_HPP_

#include <iostream>
#include <string>

#include <boost/shared_ptr.hpp>

namespace tops {

	class ConditionPart;
	class FactOrRule;
	class Fact;
	typedef boost::shared_ptr<Fact> FactPtr;
	class Rule;
	typedef boost::shared_ptr<Rule> RulePtr;

	class PSParserImpl;

	/**
	 * @߂ĊẽIuWFNg\zp[TłB
	 *
	 * @author gDC[
	 */
	class PSParser {
	private:
		PSParserImpl* m_this;

	public:
		PSParser();
		~PSParser();

	private:
		PSParser(const PSParser&);
		const PSParser& operator=(const PSParser&);

	public:
		/**
		 * v_NV[擾܂B
		 */
		bool getFactOrRule(std::istream& stream, FactOrRule& result);

		/**
		 * v_NV[擾܂B
		 */
		bool getFactOrRule(const std::string& buffer, FactOrRule& result);

		/**
		 * 擾܂B
		 */
		FactPtr getFact(std::istream& stream);

		/**
		 * 擾܂B
		 */
		FactPtr getFact(const std::string& buffer);

		/**
		 * v_NV[擾܂B
		 */
		RulePtr getRule(std::istream& stream);

		/**
		 * v_NV[擾܂B
		 */
		RulePtr getRule(const std::string& buffer);

	public:
		/**
		 * 擾܂B
		 */
		ConditionPart getConditionPart(std::istream& stream);

		/**
		 * 擾܂B
		 */
		ConditionPart getConditionPart(const std::string& stream);

	public:
		/**
		 * G[bZ[W擾܂B
		 */
		const std::string& getErrorMessage() const;
	};

}  // namespace tops

#endif
