/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: ProgressiveRule.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_PROGRESSIVE_RULE_HPP_
#define _TOPS_PROGRESSIVE_RULE_HPP_

#include "tops/common/Printable.hpp"
#include "tops/system/progressive/ProgressiveHistory.hpp"

#include "tops/utilities/CloseContainer.hpp"

#include <string>

#include <boost/shared_ptr.hpp>

namespace tops {

	class Condition;
	typedef boost::shared_ptr<Condition> ConditionPtr;
	class Instance;
	typedef boost::shared_ptr<Instance> InstancePtr;
	class ProductionRule;
	class ProgressiveProductionSystem;
	class UnificatedAttributes;
	class UnificationState;
	typedef boost::shared_ptr<UnificationState> UnificationStatePtr;
	typedef boost::shared_ptr<UnificatedAttributes> UnificatedAttributesPtr;
	class Variables;
	class WMElement;

	class ProgressiveRule;
	typedef boost::shared_ptr<ProgressiveRule> ProgressiveRulePtr;

	/**
	 * isv_NV[łB
	 *
	 * @author gDC[
	 */
	class ProgressiveRule : public Printable, public Utility::CloseContainerElement {
	private:
		ProgressiveProductionSystem& m_system;

		ProgressiveHistory m_history;

		ProductionRule& m_rule;
		unsigned int m_progression;
		bool m_misfire;
		bool m_fired;
		UnificationStatePtr m_state;

	public:
		/**
		 * S΂ĂȂԂŐisv_NV[\z܂B
		 */
		ProgressiveRule(ProgressiveProductionSystem& system, ProductionRule& rule);

		/**
		 * ΏԂisisv_NV[\z܂B
		 */
		ProgressiveRule(
				ProgressiveProductionSystem& system,
				ProgressiveRule& parent,
				const UnificatedElementPtr& lastElement,
				const Variables& variables);

	public:
		/**
		 * v_NV[擾܂B
		 */
		ProductionRule& getProductionRule() const;

		/**
		 * ΏԂ̕ϐ\擾܂B
		 */
		const Variables& getVariables() const;

		/**
		 * ΐis҂Ă擾܂B
		 */
		const ConditionPtr& getCondition() const;

		/**
		 * ΂Ă邩ǂ𔻒f܂B
		 */
		bool isFire() const;

		/**
		 * ΂Ɏsǂ擾܂B
		 */
		bool isMisfire() const;

	public:
		/**
		 * w肳ꂽƒPꉻs܂B
		 *
		 * @param element PꉻΏۂƂȂ郏[LOvfw肵܂B
		 * @param variables PꉻɎgpϐ\w肵܂B
		 *
		 * @return Pꉻɐꍇ͒PꉻςݑAsꍇNULLԂ܂B
		 */
		UnificatedAttributesPtr unificate(WMElement& element, Variables& variables);

		/**
		 * CX^X𐶐܂B
		 */
		InstancePtr instantiate() const;

		/**
		 * ΂܂B
		 */
		bool fire();

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
