/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: CloseContainerElement.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _UTILITY_CLOSE_CONTAINER_ELEMENT_HPP_
#define _UTILITY_CLOSE_CONTAINER_ELEMENT_HPP_

#include <boost/noncopyable.hpp>
#include <boost/shared_ptr.hpp>

namespace Utility {

	class CloseRelation;
	class RelationController;
	typedef boost::shared_ptr<RelationController> RelationControllerPtr;
	class RelationPolicy;

	/**
	 * SĂ̖Reivf̃[gNXłB
	 * ReiƖ֘ASĂ̖Reivf́ÃNXpKv܂B
	 *
	 * @author gDC[
	 */
	class CloseContainerElement : public boost::noncopyable {
		friend class CloseContainer;

	private:
		RelationControllerPtr m_controller;

	public:
		/**
		 * Reivf\z܂B
		 *
		 * @param controller ֘ARg[Bnull sB
		 */
		CloseContainerElement(const RelationControllerPtr& controller);

		/**
		 * Reivf\z܂B
		 *
		 * @param policy ֘A|V[B
		 */
		CloseContainerElement(RelationPolicy& policy);

		/**
		 * Reivfj܂B
		 */
		virtual ~CloseContainerElement();

	private:
		/**
		 * ReiƂ̊֘Aǉ܂B
		 * ̃\bh́AReî݌Ăяo܂B
		 *
		 * @param relation ֘ABnull sB
		 */
		void addRelation(const boost::shared_ptr<CloseRelation>& relation);

	public:
		/**
		 * ֘AĂ邩ǂ𔻒f܂B
		 *
		 * @return ֘AĂꍇ trueAȊȌꍇ falseB
		 */
		bool isOwned() const;

		/**
		 * ΏۖReiw肵āA֘AĂ邩ǂ𔻒f܂B
		 *
		 * @param owner ReiB
		 * @return ΏۖReiƖ֘AĂꍇ trueAȊȌꍇ falseB
		 */
		bool isOwned(CloseContainer& owner) const;

		/**
		 * ֘A܂B֘AĂȂꍇ͉܂B
		 */
		void release();

		/**
		 * ΏۖReiw肵Ė֘A܂B
		 * ΏۖReiƖ֘AĂȂꍇ͉܂B
		 *
		 * @param from ReiB
		 */
		void release(CloseContainer& from);
	};

}  // namespace Utility

#endif
