/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: CloseList.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _UTILITY_CLOSE_LIST_HPP_
#define _UTILITY_CLOSE_LIST_HPP_

#include "tops/utilities/CloseContainer/CloseContainer.hpp"
#include "tops/utilities/CloseContainer/CloseRelationImpl.hpp"

#include <list>

namespace Utility {

	/**
	 * Xgev[głB
	 * ̃ev[ǵA^ɖReivf̃|C^^iX}[g|C^jKvƂ܂B
	 * Reivf̃|C^^ɕKvƂȂ鐫ȉɎ܂B
     *
     * 1. CloseContainerElement ̃|C^i̓X}[g|C^jł邱ƁB
	 *
	 * ̖Xgev[ǵA STL  std::list 𗘗pĂ܂B
	 *
	 * @author Yutaka Ito
	 */
	template<typename PtrType>
	class CloseList : public CloseContainer {
	private:
		typedef std::list<PtrType> ElementList;
		ElementList m_elements;

	public:
		/**
		 * ʏOq^łB
		 */
		typedef typename ElementList::iterator iterator;

		/**
		 * 萔Oq^łB
		 */
		typedef typename ElementList::const_iterator const_iterator;

	public:
		/**
		 * Xg\z܂B
		 */
		CloseList() {
		}

		/**
		 * Xgj܂B
		 */
		~CloseList() {
			clear();
		}

	public:
		/**
		 * 󂩂ǂ𔻒f܂B
		 *
		 * @return ̏ꍇ trueAȊȌꍇ falseB
		 */
		bool empty() const {
			return m_elements.empty();
		}

		/**
		 * TCY擾܂B
		 *
		 * @return TCYB
		 */
		size_t size() const {
			return m_elements.size();
		}

		/**
		 * vf̐擪q擾܂B
		 *
		 * @return qB
		 */
		iterator begin() {
			return m_elements.begin();
		}

		/**
		 * vf̐擪萔q擾܂B
		 *
		 * @return 萔qB
		 */
		const_iterator begin() const {
			return m_elements.begin();
		}

		/**
		 * vf̖q擾܂B
		 *
		 * @return qB
		 */
		iterator end() {
			return m_elements.end();
		}

		/**
		 * vf̖萔q擾܂B
		 *
		 * @return 萔qB
		 */
		const_iterator end() const {
			return m_elements.end();
		}

	public:
		/**
		 * 擪̗vf擾܂B
		 *
		 * @return vfB
		 */
		const PtrType& front() {
			return m_elements.front();
		}

		/**
		 * ̗vf擾܂B
		 *
		 * @return vfB
		 */
		const PtrType& back () {
			return m_elements.back ();
		}

	public:
		/**
		 * vfǉ܂B
		 *
		 * @param i ǉʒuwqB
		 * @param element vfB
		 */
		void insert(iterator i, const PtrType& element) {
			if (element) {
				addRelation(*element, CloseRelationPtr(new CloseRelationImpl<ElementList>(
				                                           m_elements, m_elements.insert(i, element), this)));
			} else {
				m_elements.insert(i, element);
			}
		}

		/**
		 * 擪ɗvfǉ܂B
		 *
		 * @param element vfB
		 */
		void push_front(const PtrType& element) {
			insert(begin(), element);
		}

		/**
		 * ɗvfǉ܂B
		 *
		 * @param element vfB
		 */
		void push_back (const PtrType& element) {
			insert(end(), element);
		}

	public:
		/**
		 * SĂ̗vf폜܂B
		 */
		void clear() {
			while (!empty()) {
				const PtrType& element = front();
				if (element) {
					element->release(*this);
				}
			}
		}
	};

}  // namespace Utility

#endif
