/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: CloseRelationImpl.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _UTILITY_CLOSE_RELATION_IMPL_HPP_
#define _UTILITY_CLOSE_RELATION_IMPL_HPP_

#include "tops/utilities/CloseContainer/CloseRelation.hpp"

namespace Utility {

	/**
	 * ֘ANX邽߂ɎgpłʓIȖ֘Aev[głB
	 * ̃ev[ǵA^ɃReǐ^iFlistjKvƂ܂B
	 * Reǐ^ɕKvƂȂ鐫ȉɎ܂B
	 *
	 * 1. Reił邱ƁB
	 * 2. iterator ^Ă邱ƁB
	 * 3. 2  iterator ^s̔qł邱ƁB
	 * 4. 2  iterator ^Ƃ erase \bhĂ邱ƁB
	 *    ܂A erase \bh͔qvfRei폜ʂƁB
	 *
	 * @author gDC[
	 */
	template<typename ContainerType>
	class CloseRelationImpl : public CloseRelation {
	private:
		ContainerType& m_container;
		typename ContainerType::iterator m_iterator;
		CloseContainer* m_owner;

	public:
		/**
		 * ֘A\z܂B
		 *
		 * @param container ReiB
		 * @param iterator ֘AɎgp锽qB
		 * @param owner ReiBnull sB
		 */
		CloseRelationImpl(
		    ContainerType& container,
		    const typename ContainerType::iterator& iterator,
		    CloseContainer* owner) :
		m_container(container), m_iterator(iterator), m_owner(owner) {
		}

	public:
		/**
		 * 閧Rei擾܂B
		 *
		 * @return ֘AĂꍇ͏閧ReiAȊȌꍇ NULLB
		 */
		CloseContainer* getOwner() {
			return m_owner;
		}

		/**
		 * ֘AĂ邩ǂ𔻒f܂B
		 *
		 * @return ֘AĂꍇ trueAȊȌꍇ falseB
		 */
		bool isOwned() const {
			return m_owner != 0;
		}

		/**
		 * ΏۖReiw肵āA֘AĂ邩ǂ𔻒f܂B
		 *
		 * @param owner ReiB
		 * @return ΏۖReiƖ֘AĂꍇ trueAȊȌꍇ falseB
		 */
		bool isOwned(CloseContainer& owner) const {
			return m_owner == &owner;
		}

		/**
		 * ֘A܂B֘AĂȂꍇ͉܂B
		 */
		void release() {
			if (m_owner) {
				CloseContainer* owner = m_owner;
				m_owner = 0;
				m_container.erase(m_iterator);
			}
		}
	};

}  // namespace Utility

#endif
