/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: MapIterator.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _UTILITY_MAP_ITERATOR_HPP_
#define _UTILITY_MAP_ITERATOR_HPP_

namespace Utility {

	/**
	 * map::iteratorfirstwqłB
	 *
	 * @author gDC[
	 */
	template<class Iterator, class ValueType>
	class MapIteratorFirst {
	private:
		/**
		 * bv锽qłB
		 */
		Iterator m_i;

	public:
		/**
		 * bp[\z܂B
		 */
		MapIteratorFirst(Iterator i) : m_i(i) {
		}

	public:
		/**
		 * q(Ou)CNg܂B
		 */
		MapIteratorFirst<Iterator, ValueType>& operator++() {
			++m_i;
			return *this;
		}

		/**
		 * q(u)CNg܂B
		 */
		MapIteratorFirst<Iterator, ValueType>& operator++(int dummy) {
			Iterator i = m_i;
			++m_i;
			return i;
		}

		/**
		 * q̓e擾܂B
		 */
		const ValueType& operator*() const {
			return m_i->first;
		}

		/**
		 * q̓eɃANZX܂B
		 */
		ValueType* operator->() const {
			return &m_i->first;
		}

	public:
		/**
		 * łB
		 */
		bool operator==(const MapIteratorFirst<Iterator, ValueType>& i) {
			return m_i == i.m_i;
		}

		/**
		 * słB
		 */
		bool operator!=(const MapIteratorFirst<Iterator, ValueType>& i) {
			return m_i != i.m_i;
		}
	};

	/**
	 * map::iteratorsecondwqłB
	 *
	 * @author gDC[
	 */
	template<class Iterator, class ValueType>
	class MapIteratorSecond {
	private:
		/**
		 * bv锽qłB
		 */
		Iterator m_i;

	public:
		/**
		 * bp[\z܂B
		 */
		MapIteratorSecond(Iterator i) : m_i(i) {
		}

	public:
		/**
		 * q(Ou)CNg܂B
		 */
		MapIteratorSecond<Iterator, ValueType>& operator++() {
			m_i++;
			return *this;
		}

		/**
		 * q(u)CNg܂B
		 */
		MapIteratorSecond<Iterator, ValueType>& operator++(int dummy) {
			Iterator i = m_i;
			++m_i;
			return i;
		}

		/**
		 * q̓e擾܂B
		 */
		const ValueType& operator*() const {
			return m_i->second;
		}

		/**
		 * q̓eɃANZX܂B
		 */
		ValueType* operator->() const {
			return &m_i->second;
		}

	public:
		/**
		 * łB
		 */
		bool operator==(const MapIteratorSecond<Iterator, ValueType>& i) {
			return m_i == i.m_i;
		}

		/**
		 * słB
		 */
		bool operator!=(const MapIteratorSecond<Iterator, ValueType>& i) {
			return m_i != i.m_i;
		}
	};

	/**
	 * map::const_iteratorfirstw萔qłB
	 *
	 * @author gDC[
	 */
	template<class Iterator, class ValueType>
	class ConstMapIteratorFirst {
	private:
		/**
		 * bv锽qłB
		 */
		Iterator m_i;

	public:
		/**
		 * bp[\z܂B
		 */
		ConstMapIteratorFirst(Iterator i) : m_i(i) {
		}

	public:
		/**
		 * q(Ou)CNg܂B
		 */
		ConstMapIteratorFirst<Iterator, ValueType>& operator++() {
			++m_i;
			return *this;
		}

		/**
		 * q(u)CNg܂B
		 */
		ConstMapIteratorFirst<Iterator, ValueType>& operator++(int dummy) {
			Iterator i = m_i;
			++m_i;
			return i;
		}

		/**
		 * q̓e擾܂B
		 */
		const ValueType& operator*() const {
			return m_i->first;
		}

		/**
		 * q̓eɃANZX܂B
		 */
		const ValueType* operator->() const {
			return &m_i->first;
		}

	public:
		/**
		 * łB
		 */
		bool operator==(const ConstMapIteratorFirst<Iterator, ValueType>& i) {
			return m_i == i.m_i;
		}

		/**
		 * słB
		 */
		bool operator!=(const ConstMapIteratorFirst<Iterator, ValueType>& i) {
			return m_i != i.m_i;
		}
	};

	/**
	 * map::const_iteratorsecondw萔qłB
	 *
	 * @author gDC[
	 */
	template<class Iterator, class ValueType>
	class ConstMapIteratorSecond {
	private:
		/**
		 * bv锽qłB
		 */
		Iterator m_i;

	public:
		/**
		 * bp[\z܂B
		 */
		ConstMapIteratorSecond(Iterator i) : m_i(i) {
		}

	public:
		/**
		 * q(Ou)CNg܂B
		 */
		ConstMapIteratorSecond<Iterator, ValueType>& operator++() {
			++m_i;
			return *this;
		}

		/**
		 * q(u)CNg܂B
		 */
		ConstMapIteratorSecond<Iterator, ValueType>& operator++(int dummy) {
			Iterator i = m_i;
			++m_i;
			return i;
		}

		/**
		 * q̓e擾܂B
		 */
		const ValueType& operator*() const {
			return m_i->second;
		}

		/**
		 * q̓eɃANZX܂B
		 */
		const ValueType* operator->() const {
			return &m_i->second;
		}

	public:
		/**
		 * łB
		 */
		bool operator==(const ConstMapIteratorSecond<Iterator, ValueType>& i) {
			return m_i == i.m_i;
		}

		/**
		 * słB
		 */
		bool operator!=(const ConstMapIteratorSecond<Iterator, ValueType>& i) {
			return m_i != i.m_i;
		}
	};

}  // namespace Utility

#endif
