/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: RefCountPtr.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _UTILITY_REF_COUNT_PTR_HPP_
#define _UTILITY_REF_COUNT_PTR_HPP_

#include "tops/utilities/Pointer/MessageCounter.hpp"

namespace Utility {

	/**
	 * QƃJEg^̃X}[g|C^łB
	 *
	 * @author gDC[
	 */
	template<class T>
	class RefCountPtr {
	private:
		T* m_ptr;
		MessageCounter* m_count;

	public:
		/**
		 * X}[g|C^\z܂B
		 */
		explicit RefCountPtr(T* p = 0) : m_ptr(p), m_count(new MessageCounter(1)) {
		}

		/**
		 * plRs[RXgN^łB
		 */
		template<class R>
		RefCountPtr(const RefCountPtr<R>& rhs) :
		m_ptr(rhs.get()), m_count(rhs.getCounter()) {
			++(*m_count);
		}

		/*
		 * Rs[RXgN^łB
		 */
		RefCountPtr(const RefCountPtr<T>& rhs) :
		m_ptr(rhs.m_ptr), m_count(rhs.m_count) {
			++(*m_count);
		}

		/**
		 * X}[g|C^j܂B
		 */
		virtual ~RefCountPtr() {
			refcountdec();
		}

	public:
		/**
		 * plZqłB
		 */
		template<class R>
		RefCountPtr<T>& operator=(const RefCountPtr<R>& rhs) {
			if (m_ptr != rhs.get()) {
				refcountdec();
				m_ptr = rhs.get();
				m_count = rhs.getCounter();
				++(*m_count);
			}

			return *this;
		}

		/**
		 * ZqłB
		 */
		RefCountPtr<T>& operator=(const RefCountPtr<T>& rhs) {
			if (m_ptr != rhs.get()) {
				refcountdec();
				m_ptr = rhs.get();
				m_count = rhs.getCounter();
				++(*m_count);
			}

			return *this;
		}

	public:
		/**
		 * |C^lǂ𔻒肵܂B
		 *
		 * @return |C^lꍇtrueANULL̏ꍇfalseԂ܂B
		 */
		operator bool() const {
			return 0 != m_ptr;
		}

		/**
		 * |C^NULLlǂ𔻒肵܂B
		 *
		 * @return |C^NULL̏ꍇtrueAlꍇfalseԂ܂B
		 */
		bool operator!() const {
			return 0 == m_ptr;
		}

	public:
		/**
		 * QƂ͂ZqłB
		 */
		T& operator*() const {
			return *m_ptr;
		}

		/**
		 * QƂ͂ZqłB
		 */
		T* operator->() const {
			return m_ptr;
		}

		/**
		 * |C^擾܂B
		 */
		T* get() const {
			return m_ptr;
		}

		/**
		 * JEg|C^擾܂B
		 */
		MessageCounter* getCounter() const {
			return m_count;
		}

	public:
		/**
		 * ZqłB
		 */
		bool operator==(const RefCountPtr<T>& rhs) {
			return m_ptr == rhs.m_ptr;
		}

		/**
		 * lZqłB
		 */
		bool operator< (const RefCountPtr<T>& rhs) {
			return m_ptr <  rhs.m_ptr;
		}

	private:
		void refcountdec() {
			--(*m_count);

			if ((*m_count) == 0) {
				delete m_ptr;
				m_ptr = 0;
				delete m_count;
				m_count = 0;
			}
		}
	};

}  // namespace Utility

#endif
