/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: ComputeValue.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_COMPUTE_VALUE_HPP_
#define _TOPS_COMPUTE_VALUE_HPP_

#include "tops/value/Value.hpp"

#include <map>

#include <antlr/AST.hpp>

#include <boost/shared_ptr.hpp>

namespace tops {

	class Variable;
	typedef boost::shared_ptr<Variable> VariablePtr;
	typedef std::map<std::string, VariablePtr> VariableMapForCompute;

	/**
	 * vZlłB
	 *
	 * @author gDC[
	 */
	class ComputeValue : public Value {
	private:
		/**
		 * łB
		 */
		std::string m_expression;

		/**
		 * 瓾ꂽ͖؂łB
		 */
		antlr::RefAST m_parseTree;

	public:
		/**
		 * vZl\z܂B
		 *
		 * @param expression w肵܂B
		 */
		ComputeValue(const std::string& expression);

	public:
		/**
		 * ̒l擾܂B
		 */
		int getValue(const Variables& variables) const;

	public:
		/**
		 * w肳ꂽ萔ƒPꉻs܂B
		 *
		 * @param value PꉻΏۂƂȂ萔w肵܂B
		 * @param variables PꉻɎgpϐ\w肵܂B
		 * @return PꉻɐtrueAsfalseԂ܂B
		 */
		bool unificate(const Constant& value, Variables& variables) const;

		/**
		 * l̉܂B
		 *
		 * @param variables ̉Ɏgpϐ\w肵܂B
		 */
		ConstantPtr instantiate(const Variables& variables) const;

	public:
		// ConditionVariableɗRrZqQłB

		bool operator==(const ConstantAndVariables& a) const;
		bool operator!=(const ConstantAndVariables& a) const;
		bool operator< (const ConstantAndVariables& a) const;
		bool operator> (const ConstantAndVariables& a) const;
		bool operator<=(const ConstantAndVariables& a) const;
		bool operator>=(const ConstantAndVariables& a) const;

		// ł͕Еiinstantiatej萔ł邱Ƃ킩̂ŁA
		// Zq̏ԂuЂԂv܂B

		bool operator==(const ValueAndVariables& a) const;
		bool operator!=(const ValueAndVariables& a) const;
		bool operator< (const ValueAndVariables& a) const;
		bool operator> (const ValueAndVariables& a) const;
		bool operator<=(const ValueAndVariables& a) const;
		bool operator>=(const ValueAndVariables& a) const;

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
