/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: ExprParser.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef INC_ExprParser_hpp_
#define INC_ExprParser_hpp_

#include <antlr/config.hpp>
/* $ANTLR 2.7.7 (20060930): "expr.g" -> "ExprParser.hpp"$ */
#include <antlr/TokenStream.hpp>
#include <antlr/TokenBuffer.hpp>
#include "ExprTreeParserTokenTypes.hpp"
#include <antlr/LLkParser.hpp>

#line 1 "expr.g"

#include "ExprTreeParserTokenTypes.hpp"

#include "tops/value/AllValues.hpp"

using namespace tops;

#line 20 "ExprParser.hpp"
class CUSTOM_API ExprParser : public ANTLR_USE_NAMESPACE(antlr)LLkParser, public ExprTreeParserTokenTypes
{
#line 1 "expr.g"
#line 24 "ExprParser.hpp"
public:
	void initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& factory );
protected:
	ExprParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf, int k);
public:
	ExprParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf);
protected:
	ExprParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer, int k);
public:
	ExprParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer);
	ExprParser(const ANTLR_USE_NAMESPACE(antlr)ParserSharedInputState& state);
	int getNumTokens() const
	{
		return ExprParser::NUM_TOKENS;
	}
	const char* getTokenName( int type ) const
	{
		if( type > getNumTokens() ) return 0;
		return ExprParser::tokenNames[type];
	}
	const char* const* getTokenNames() const
	{
		return ExprParser::tokenNames;
	}
	public: void expr();
	public: void expr_1();
	public: void expr_2();
	public: void expr_3();
	public: void expr_atom();
	public: void expr_integer();
	public: void expr_variable();
	public: void expr_paren();
	public: void expr_sign();
public:
	ANTLR_USE_NAMESPACE(antlr)RefAST getAST()
	{
		return returnAST;
	}
	
protected:
	ANTLR_USE_NAMESPACE(antlr)RefAST returnAST;
private:
	static const char* tokenNames[];
#ifndef NO_STATIC_CONSTS
	static const int NUM_TOKENS = 42;
#else
	enum {
		NUM_TOKENS = 42
	};
#endif
	
};

#endif /*INC_ExprParser_hpp_*/
