// Paqar32.dll
// $Id: Paqar32.h,v 1.2 2004/12/02 12:57:20 sirakaba Exp $

#ifndef PAQAR32_H
#define PAQAR32_H

// o[Wԍ
#define PAQAR_VERSION		2
#define PAQAR_SUBVERSION	225

// 萔`
#ifndef FNAME_MAX32
#define FNAME_MAX32 512
#endif
#ifndef WM_ARCEXTRACT
#define WM_ARCEXTRACT "wm_arcextract"
#endif

// EnumMenberProc
typedef BOOL(CALLBACK *PAQAR_WND_ENUMMEMBPROC)(LPVOID _lpInfo);

typedef struct _tagEnumMembersData{
    BYTE _type;
    PAQAR_WND_ENUMMEMBPROC _proc;
}EnumMembersData;

typedef struct _tagStartProcessInfo{
    UINT uCommand;
    UINT64 llOriginalSize;
    UINT64 llCompressedSize;
    DWORD dwAttributes;
    DWORD dwCRC;
    WORD wRatio;
    FILETIME ftCreateTime;
    FILETIME ftAccessTime;
    FILETIME ftWriteTime;
    char szFileName[FNAME_MAX32+1];
    char szAddFileName[FNAME_MAX32+1];
}StartProcessInfo;

typedef struct _tagPAQAR_ENUM_MEMBER_INFO{
    DWORD dwStructSize;
    UINT uCommand;
    DWORD dwOriginalSize;
    DWORD dwCompressedSize;
    DWORD dwAttributes;
    DWORD dwCRC;
    UINT uOSType;
    WORD wRatio;
    FILETIME ftCreateTime;
    FILETIME ftAccessTime;
    FILETIME ftWriteTime;
    char szFileName[FNAME_MAX32+1];
    char dummy1[3];
    char szAddFileName[FNAME_MAX32+1];
    char dummy2[3];
}PAQAR_ENUM_MEMBER_INFO,*LPPAQAR_ENUM_MEMBER_INFO;

typedef struct _tagPAQAR_ENUM_MEMBER_INFO64{
    DWORD dwStructSize;
    UINT uCommand;
    UINT64 llOriginalSize;
    UINT64 llCompressedSize;
    DWORD dwAttributes;
    DWORD dwCRC;
    UINT uOSType;
    WORD wRatio;
    FILETIME ftCreateTime;
    FILETIME ftAccessTime;
    FILETIME ftWriteTime;
    char szFileName[FNAME_MAX32+1];
    char dummy1[3];
    char szAddFileName[FNAME_MAX32+1];
    char dummy2[3];
}PAQAR_ENUM_MEMBER_INFO64,*LPPAQAR_ENUM_MEMBER_INFO64;

// OwnerWindow
typedef BOOL(CALLBACK *ARCHIVERPROC)(HWND _hwnd,UINT _uMsg,UINT _nState,LPVOID _lpEis);
typedef ARCHIVERPROC *LPARCHIVERPROC;

typedef struct _tagOwnerWindowData{
	BYTE _type;
	HWND _hwnd;
	ARCHIVERPROC _proc;
}OwnerWindowData;

typedef struct _tagExtractInfo{
    UINT64 llFileSize;
    UINT64 llCompressedSize;
    UINT64 llWriteSize;
    DWORD dwAttributes;
    DWORD dwCRC;
    WORD wRatio;
    WORD wDate;
    WORD wTime;
    FILETIME ftCreateTime;
    FILETIME ftAccessTime;
    FILETIME ftWriteTime;
    char szMode[8];
    char szSourceFileName[FNAME_MAX32+1];
    char szDestFileName[FNAME_MAX32+1];
}ExtractInfo;

typedef struct _tagEXTRACTINGINFO{
    DWORD dwFileSize;
    DWORD dwWriteSize;
    char szSourceFileName[FNAME_MAX32+1];
    char dummy1[3];
    char szDestFileName[FNAME_MAX32+1];
    char dummy[3];
}EXTRACTINGINFO,*LPEXTRACTINGINFO;

typedef struct _tagEXTRACTINGINFOEX{
    EXTRACTINGINFO exinfo;
    DWORD dwCompressedSize;
    DWORD dwCRC;
    UINT uOSType;
    WORD wRatio;
    WORD wDate;
    WORD wTime;
    char szAttribute[8];
    char szMode[8];
}EXTRACTINGINFOEX,*LPEXTRACTINGINFOEX;

typedef struct _tagEXTRACTINGINFOEX32{
    DWORD dwStructSize;
    EXTRACTINGINFO exinfo;
    DWORD dwFileSize;
    DWORD dwCompressedSize;
    DWORD dwWriteSize;
    DWORD dwAttributes;
    DWORD dwCRC;
    UINT uOSType;
    WORD wRatio;
    FILETIME ftCreateTime;
    FILETIME ftAccessTime;
    FILETIME ftWriteTime;
    char szMode[8];
    char szSourceFileName[FNAME_MAX32+1];
    char dummy1[3];
    char szDestFileName[FNAME_MAX32+1];
    char dummy2[3];
}EXTRACTINGINFOEX32,*LPEXTRACTINGINFOEX32;

typedef struct _tagEXTRACTINGINFOEX64{
    DWORD dwStructSize;
    EXTRACTINGINFO exinfo;
    UINT64 llFileSize;
    UINT64 llCompressedSize;
    UINT64 llWriteSize;
    DWORD dwAttributes;
    DWORD dwCRC;
    UINT uOSType;
    WORD wRatio;
    FILETIME ftCreateTime;
    FILETIME ftAccessTime;
    FILETIME ftWriteTime;
    char szMode[8];
    char szSourceFileName[FNAME_MAX32+1];
    char dummy1[3];
    char szDestFileName[FNAME_MAX32+1];
    char dummy2[3];
}EXTRACTINGINFOEX64,*LPEXTRACTINGINFOEX64;

// `FbN[h
#ifndef CHECKARCHIVE_RAPID
#define CHECKARCHIVE_RAPID		0
#define	CHECKARCHIVE_BASIC		1
#define	CHECKARCHIVE_FULLCRC	2
#define CHECKARCHIVE_RECOVERY	4
#define CHECKARCHIVE_SFX		8
#define CHECKARCHIVE_ALL		16
#define CHECKARCHIVE_ENDDATA	32
#endif

// G[R[h
#ifndef ERROR_START
#define ERROR_START				0x8000
#define ERROR_DISK_SPACE		0x8005
#define ERROR_READ_ONLY			0x8006
#define ERROR_USER_SKIP			0x8007
#define ERROR_UNKNOWN_TYPE		0x8008
#define ERROR_METHOD			0x8009
#define ERROR_PASSWORD_FILE		0x800A
#define ERROR_VERSION			0x800B
#define ERROR_FILE_CRC			0x800C
#define ERROR_FILE_OPEN			0x800D
#define ERROR_MORE_FRESH		0x800E
#define ERROR_NOT_EXIST			0x800F
#define ERROR_ALREADY_EXIST		0x8010
#define ERROR_TOO_MANY_FILES	0x8011
#define ERROR_MAKEDIRECTORY		0x8012
#define ERROR_CANNOT_WRITE		0x8013
#define ERROR_HUFFMAN_CODE		0x8014
#define ERROR_COMMENT_HEADER	0x8015
#define ERROR_HEADER_CRC		0x8016
#define ERROR_HEADER_BROKEN		0x8017
#define ERROR_ARC_FILE_OPEN		0x8018
#define ERROR_NOT_ARC_FILE		0x8019
#define ERROR_CANNOT_READ		0x801A
#define ERROR_FILE_STYLE		0x801B
#define ERROR_COMMAND_NAME		0x801C
#define ERROR_MORE_HEAP_MEMORY	0x801D
#define ERROR_ENOUGH_MEMORY		0x801E
#define ERROR_ALREADY_RUNNING	0x801F
#define ERROR_USER_CANCEL		0x8020
#define ERROR_HARC_ISNOT_OPENED	0x8021
#define ERROR_NOT_SEARCH_MODE	0x8022
#define ERROR_NOT_SUPPORT		0x8023
#define ERROR_TIME_STAMP		0x8024
#define ERROR_TMP_OPEN			0x8025
#define ERROR_LONG_FILE_NAME	0x8026
#define ERROR_ARC_READ_ONLY		0x8027
#define ERROR_SAME_NAME_FILE	0x8028
#define ERROR_NOT_FIND_ARC_FILE	0x8029
#define ERROR_RESPONSE_READ		0x802A
#define ERROR_NOT_FILENAME		0x802B
#define ERROR_TMP_COPY			0x802C
#define ERROR_EOF				0x802D
#define ERROR_ADD_TO_LARC		0x802E
#define ERROR_TMP_BACK_SPACE    0x802F
#define ERROR_SHARING			0x8030
#define ERROR_NOT_FIND_FILE		0x8031
#define ERROR_LOG_FILE			0x8032
#define	ERROR_NO_DEVICE			0x8033
#define ERROR_GET_ATTRIBUTES    0x8034
#define ERROR_SET_ATTRIBUTES	0x8035
#define ERROR_GET_INFORMATION   0x8036
#define ERROR_GET_POINT			0x8037
#define ERROR_SET_POINT			0x8038
#define ERROR_CONVERT_TIME		0x8039
#define ERROR_GET_TIME			0x803A
#define ERROR_SET_TIME			0x803B
#define ERROR_CLOSE_FILE		0x803C
#define ERROR_HEAP_MEMORY		0x803D
#define ERROR_HANDLE			0x803E
#define ERROR_TIME_STAMP_RANGE  0x803F
#define ERROR_MAKE_ARCHIVE		0x8040
#define ERROR_NOT_CONFIRM_NAME	0x8041
#define ERROR_UNEXPECTED_EOF	0x8042
#define ERROR_INVALID_END_MARK	0x8043
#define ERROR_INVOLVED_LZH		0x8044
#define ERROR_NO_END_MARK		0x8045
#define ERROR_HDR_INVALID_SIZE	0x8046
#define ERROR_UNKNOWN_LEVEL		0x8047
#define ERROR_BROKEN_DATA		0x8048
#define ERROR_INVALID_PATH		0x8049
#define ERROR_END				ERROR_INVALID_PATH
#endif

// ֐R[h
#ifndef ISARC_FUNCTION_START
#define ISARC_FUNCTION_START			0
#define ISARC							0
#define ISARC_GET_VERSION				1
#define ISARC_GET_CURSOR_INTERVAL		2
#define ISARC_SET_CURSOR_INTERVAL		3
#define ISARC_GET_BACK_GROUND_MODE		4
#define ISARC_SET_BACK_GROUND_MODE		5
#define ISARC_GET_CURSOR_MODE			6
#define ISARC_SET_CURSOR_MODE			7
#define ISARC_GET_RUNNING				8
#define ISARC_CHECK_ARCHIVE				16
#define ISARC_CONFIG_DIALOG				17
#define ISARC_GET_FILE_COUNT			18
#define ISARC_QUERY_FUNCTION_LIST		19
#define ISARC_HOUT						20
#define ISARC_STRUCTOUT					21
#define ISARC_GET_ARC_FILE_INFO			22
#define ISARC_OPEN_ARCHIVE				23
#define ISARC_CLOSE_ARCHIVE				24
#define ISARC_FIND_FIRST				25
#define ISARC_FIND_NEXT					26
#define ISARC_EXTRACT					27
#define ISARC_ADD						28
#define ISARC_MOVE						29
#define ISARC_DELETE					30
#define ISARC_SETOWNERWINDOW			31
#define ISARC_CLEAROWNERWINDOW			32
#define ISARC_SETOWNERWINDOWEX			33
#define ISARC_KILLOWNERWINDOWEX			34
#define ISARC_GET_ARC_FILE_NAME			40
#define ISARC_GET_ARC_FILE_SIZE			41
#define ISARC_GET_ARC_ORIGINAL_SIZE		42
#define ISARC_GET_ARC_COMPRESSED_SIZE	43
#define ISARC_GET_ARC_RATIO				44
#define ISARC_GET_ARC_DATE				45
#define ISARC_GET_ARC_TIME				46
#define ISARC_GET_ARC_OS_TYPE			47
#define ISARC_GET_ARC_IS_SFX_FILE		48
#define ISARC_GET_ARC_WRITE_TIME_EX		49
#define ISARC_GET_ARC_CREATE_TIME_EX	50
#define	ISARC_GET_ARC_ACCESS_TIME_EX	51
#define	ISARC_GET_ARC_CREATE_TIME_EX2	52
#define ISARC_GET_ARC_WRITE_TIME_EX2	53
#define ISARC_GET_FILE_NAME				57
#define ISARC_GET_ORIGINAL_SIZE			58
#define ISARC_GET_COMPRESSED_SIZE		59
#define ISARC_GET_RATIO					60
#define ISARC_GET_DATE					61
#define ISARC_GET_TIME					62
#define ISARC_GET_CRC					63
#define ISARC_GET_ATTRIBUTE				64
#define ISARC_GET_OS_TYPE				65
#define ISARC_GET_METHOD				66
#define ISARC_GET_WRITE_TIME			67
#define ISARC_GET_CREATE_TIME			68
#define ISARC_GET_ACCESS_TIME			69
#define ISARC_GET_WRITE_TIME_EX			70
#define ISARC_GET_CREATE_TIME_EX		71
#define ISARC_GET_ACCESS_TIME_EX		72
#define ISARC_SET_ENUM_MEMBERS_PROC		80
#define ISARC_CLEAR_ENUM_MEMBERS_PROC	81
#define ISARC_GET_ARC_FILE_SIZE_EX		82
#define ISARC_GET_ARC_ORIGINAL_SIZE_EX	83
#define ISARC_GET_ARC_COMPRESSED_SIZE_EX 84
#define ISARC_GET_ORIGINAL_SIZE_EX		85
#define ISARC_GET_COMPRESSED_SIZE_EX	86
#define ISARC_SETOWNERWINDOWEX64		87
#define ISARC_KILLOWNERWINDOWEX64		88
#define ISARC_SET_ENUM_MEMBERS_PROC64	89
#define ISARC_CLEAR_ENUM_MEMBERS_PROC64	90
#define ISARC_OPEN_ARCHIVE2				91
#define ISARC_GET_ARC_READ_SIZE			92
#define ISARC_GET_ARC_READ_SIZE_EX		93
#define ISARC_FUNCTION_END				ISARC_GET_ARC_READ_SIZE_EX
#endif

// ȉAPI
int  WINAPI Paqar(const HWND _hwnd,LPCSTR _szCmdLine,LPSTR _szOutput,const DWORD _dwSize);
WORD WINAPI PaqarGetVersion(void);
WORD WINAPI PaqarGetSubVersion(void);
WORD WINAPI PaqarGetBuild(void);
BOOL WINAPI PaqarGetRunning(void);
BOOL WINAPI PaqarGetBackGroundMode(void);
BOOL WINAPI PaqarSetBackGroundMode(const BOOL _bBackGroundMode);
BOOL WINAPI PaqarGetCursorMode(void);
BOOL WINAPI PaqarSetCursorMode(const BOOL _CursorMode);
WORD WINAPI PaqarGetCursorInterval(void);
BOOL WINAPI PaqarSetCursorInterval(const WORD _Interval);
BOOL WINAPI PaqarConfigDialog(const HWND _hwnd,LPSTR _szOptionBuffer,const int _iMode);
BOOL WINAPI PaqarCheckArchive(LPCSTR _szFileName,const int _iMode);
int  WINAPI PaqarGetFileCount(LPCSTR _szArcFile);
BOOL WINAPI PaqarQueryFunctionList(const int _iFunction);
BOOL WINAPI PaqarSetOwnerWindow(HWND _hwnd);
BOOL WINAPI PaqarClearOwnerWindow(void);
BOOL WINAPI PaqarSetOwnerWindowEx(HWND _hwnd,LPARCHIVERPROC _lpArcProc);
BOOL WINAPI PaqarKillOwnerWindowEx(HWND _hwnd);
BOOL WINAPI PaqarSetEnumMembersProc(PAQAR_WND_ENUMMEMBPROC _lpEnumProc);
BOOL WINAPI PaqarClearEnumMembersProc(void);
BOOL WINAPI PaqarSetOwnerWindowEx64(HWND _hwnd,LPARCHIVERPROC _lpArcProc,DWORD _dwStructSize);
BOOL WINAPI PaqarKillOwnerWindowEx64(HWND _hwnd);
BOOL WINAPI PaqarSetEnumMembersProc64(PAQAR_WND_ENUMMEMBPROC _lpEnumProc,DWORD _dwStructSize);
BOOL WINAPI PaqarClearEnumMembersProc64(void);

#endif