// Paqar32.dll
// $Id: function.cpp,v 1.7 2005/01/13 13:59:36 sirakaba Exp $

#define jms1(c) (((((BYTE)(c)) >= 0x81) && (((BYTE)(c)) <= 0x9F)) || ((((BYTE)(c)) >= 0xE0) && (((BYTE)(c)) <= 0xFC)))
#define jms2(c)  ((((BYTE)(c)) != 0x7F) && (((BYTE)(c)) >= 0x40)  &&  (((BYTE)(c)) <= 0xFC))

char *lstrdup(LPCSTR lp){
	char *c;
	c = (char*)GlobalAlloc(GPTR, lstrlen(lp) + 1);
	c[0] = '\0';
	wsprintf(c, lp);
	return c;
}

int isJMS(const char *str, int nPos){
	int i = 0, state = 0;
	for(; i < lstrlen(str); i++){
		state = ((state == 0) && (jms1(*(str + i))) ? 1
			:	((state == 1) && (jms2(*(str + i))) ? 2
			:	((state == 2) && (jms1(*(str + i))) ? 1
			:	0)));
		if(i == nPos) return state;
	}
	return 0;
}

int cmdline2array(char **argv, const char *cmdline){
	int i = 0, len = 0, r, argc = 0;
	char src[10000], temp[512];
	sprintf(src, cmdline);
	for(; i < lstrlen(src); i++) if(isJMS(src, i) == 0 && src[i] == '\\') src[i] = '/';
	while(isJMS(src, len) == 0 && src[len] != '\0'){
		while(isJMS(src, len) == 0 && (src[len] == ' ' || src[len] == '\n' || src[len] == '\r')) len++;
		if(isJMS(src,len) == 0 && src[len] == '\0'){
			argv[argc] = "\0";
			return argc;
		}
		if(isJMS(src, len) == 0 && src[len] == '\"'){
			len++;
			if(isJMS(src, len) == 0 && src[len] == '\0'){
				argv[argc] = "\0";
				return argc;
			}
			r = 0;
			while(src[len] != '\"' && src[len] != '\0'){
r1:
				temp[r] = src[len];
				len++;
				r++;
			}
			if(isJMS(src, len) != 0) goto r1;
			temp[r] = '\0';
			argv[argc] = lstrdup(temp);
			if(isJMS(src, len) == 0 && src[len] == '\0'){
				argc++;
				argv[argc] = "\0";
				return argc;
			}
			len++;
		}else{
			r = 0;
			while(src[len] != ' ' && src[len] != '\n' && src[len] != '\r' && src[len] != '\0'){
r2:
				temp[r] = src[len];
				len++;
				r++;
			}
			if(isJMS(src, len) != 0) goto r2;
			temp[r] = '\0';
			argv[argc] = lstrdup(temp);
			if(isJMS(src, len) == 0 && src[len] == '\0'){
				argc++;
				argv[argc] = "\0";
				return argc;
			}
		}
		argc++;
	}
	argv[argc] = "\0";
	return argc;
}

void DoEvents(void){
	if(! g_Cancel) for(MSG msg; PeekMessage(&msg, 0, 0, 0, PM_REMOVE); ) TranslateMessage(&msg), DispatchMessage(&msg);
}

void AddStatusText(HWND hWnd, LPCTSTR str){
	int idx = SendDlgItemMessage(hWnd, IDC_EDIT1, EM_LINEINDEX, SendDlgItemMessage(hWnd, IDC_EDIT1, EM_GETLINECOUNT, 0, 0) - 1, 0), pos;
	if(idx < 0) return;
	pos = SendDlgItemMessage(hWnd, IDC_EDIT1, EM_LINELENGTH, idx, 0) + idx;
	SendDlgItemMessage(hWnd, IDC_EDIT1, EM_SETSEL, pos, pos);
	SendDlgItemMessage(hWnd, IDC_EDIT1, EM_REPLACESEL, 0, (LPARAM)str);
}

char *strrstr(const char *_szString, const char *_szPattern){
	if(_szPattern[0] == '\0') return NULL;
	const char *p, *szLast;
	for(p = szLast = _szString; (p = strstr(p, _szPattern)) != NULL; p++) szLast = p + lstrlen(_szPattern);
	return (char*)szLast;
}

void CenteringWindow(HWND _hwnd, HWND _hwParent){
	if(_hwParent == NULL) _hwParent = GetDesktopWindow();
	RECT rc;
	GetWindowRect(_hwnd, (LPRECT)&rc);
	int a = rc.right - rc.left, b = rc.bottom - rc.top;
	GetWindowRect(_hwParent,(LPRECT)&rc);
	SetWindowPos(_hwnd, HWND_TOP, (rc.right - a) / 2, (rc.bottom - b) / 2, a, b, SWP_SHOWWINDOW);
	UpdateWindow(_hwnd);
	ShowWindow(_hwnd, SW_SHOW);
	DoEvents();
}

BOOL CALLBACK ProcessDialogProc(HWND _hwnd, UINT in_message, WPARAM in_wp, LPARAM in_lp){
	char *sz = "";
	switch(in_message){
		case WM_INITDIALOG:
			g_Cancel = false;
			return true;
		case WM_COMMAND:
			if(in_wp != ID_BUTTON_STATUS) break;
		case WM_CLOSE:
			if(MessageBox(_hwnd, LJ ? "𒆒f܂H" : "Do you want to cancel this process?", "Paqar32.dll", MB_YESNO) == IDYES){
				g_Cancel = true;
				return true;
			}
			break;
		default:
			if(in_message != uMsg) return false;
			LPEXTRACTINGINFOEX64 lpInfo = (LPEXTRACTINGINFOEX64)in_lp;
			switch(in_wp){
				case ARCEXTRACT_BEGIN:
					// t@CJn (3) (4)
					SetDlgItemText(_hwnd, IDC_STATIC_TARGET2, lpInfo->szDestFileName);
					SendDlgItemMessage(_hwnd, IDC_PROGRESS1, PBM_SETPOS, 0, 0);
					lpInfo->dummy1[0] == 'a' ?
						sprintf(sz, "%-23s %10I64d -> ", lpInfo->szDestFileName, lpInfo->llFileSize) :
						sprintf(sz, "%-23s extracting -> ", lpInfo->szDestFileName);
					AddStatusText(_hwnd, sz);
					break;
				case ARCEXTRACT_INPROCESS:
					// t@C (5) (8) (10)
					SendDlgItemMessage(_hwnd, IDC_PROGRESS1, PBM_SETPOS, int(lpInfo->llWriteSize / (lpInfo->llFileSize / 100)), 0);
					break;
				case ARCEXTRACT_END:
					// I (11)
					break;
				case ARCEXTRACT_OPEN:
					// ɖݒ (1)
					SetDlgItemText(_hwnd, IDC_STATIC_ARCHIVE2, lpInfo->szSourceFileName);
					AddStatusText(_hwnd, lpInfo->dummy1[0] == 'a' ? "Compressing files to archive ...\n" : "Extracting archive ...\n");
					break;
				case ARCEXTRACT_COPY:
					// ƃt@C߂ (9)
				case 5:
					// t@C (2)
					break;
				case 6:
					// t@CI (6)
					sprintf(sz, "%I64d\n", lpInfo->dummy1[0] == 'a' ? lpInfo->llCompressedSize : lpInfo->llFileSize);
					AddStatusText(_hwnd, sz);
					break;
				case 7:
					// Jn (7)
					break;
			}
			return g_Cancel == false;
	}
	return false;
}

BOOL CALLBACK ConfigDialogProc(HWND _hwnd, UINT in_message, WPARAM in_wp, LPARAM in_lp){
	switch(in_message){
		case WM_INITDIALOG:{
			char *sz = "";
			DWORD dwType, dwData;

			// eLXg
			sprintf(sz, "Paqar32.dll v.%1.2f Build %d\nCopyright (c) 2002-2004 Sirakaba.\n", (double)PAQAR_VERSION/100, (int)PAQAR_SUBVERSION);
			SetDlgItemText(_hwnd, IDC_STATIC_VERSION, sz);
			SendDlgItemMessage(_hwnd, IDC_SLIDER1, TBM_SETRANGE, (WPARAM)TRUE, MAKELPARAM(0, 9));

			// L[쐬
			CreateRegistryKey(HKEY_CURRENT_USER, "Software\\ArchiverDll\\Paqar32");
			CreateRegistryKey(HKEY_CURRENT_USER, "Software\\ArchiverDll\\Paqar32\\Config");

			// WXgǂݍ
			if(GetRegistryKeyValue(HKEY_CURRENT_USER, "Software\\ArchiverDll\\Paqar32\\Config", "CompressLevel", &dwType, (LPBYTE)&dwData) && dwType == REG_DWORD) SendDlgItemMessage(_hwnd, IDC_SLIDER1,   TBM_SETPOS,  (WPARAM)TRUE, (LPARAM)dwData);
			if(GetRegistryKeyValue(HKEY_CURRENT_USER, "Software\\ArchiverDll\\Paqar32\\Config", "x86Compress",   &dwType, (LPBYTE)&dwData) && dwType == REG_DWORD) SendDlgItemMessage(_hwnd, IDC_CHECK_X86, BM_SETCHECK, (WPARAM)dwData, 0L);

			// \
			CenteringWindow(_hwnd, (HWND)in_lp);
			return true;}
		case WM_COMMAND:
			switch(in_wp){
				case ID_BUTTON_CONFIG:
					// WXg
					DWORD dwData;
					dwData = SendDlgItemMessage(_hwnd, IDC_SLIDER1, TBM_GETPOS, 0L, 0L);
					SetRegistryKeyValue(HKEY_CURRENT_USER, "Software\\ArchiverDll\\Paqar32\\Config", "CompressLevel", REG_DWORD, (BYTE*)&dwData);
					dwData = SendDlgItemMessage(_hwnd, IDC_CHECK_X86, BM_GETCHECK, 0L, 0L);
					SetRegistryKeyValue(HKEY_CURRENT_USER, "Software\\ArchiverDll\\Paqar32\\Config", "x86Compress",   REG_DWORD, (BYTE*)&dwData);
					EndDialog(_hwnd, true);
					return true;
				case ID_BUTTON_CANCEL:
					EndDialog(_hwnd, false);
					return true;
			}
			return true;
		case WM_CLOSE:
			EndDialog(_hwnd, false);
			return true;
	}
	return false;
}

BOOL SendStartProcessInfo(StartProcessInfo *spinfo){
	BOOL r;
	if(g_Enum._proc==NULL||g_Enum._type<1||g_Enum._type>3) return true;
	switch(g_Enum._type){
		case 1:{
			PAQAR_ENUM_MEMBER_INFO eminfo;
			{
				eminfo.dwStructSize=sizeof(PAQAR_ENUM_MEMBER_INFO);
				eminfo.uCommand=spinfo->uCommand;
				eminfo.dwOriginalSize=(DWORD)spinfo->llOriginalSize;
				eminfo.dwCompressedSize=(DWORD)spinfo->llCompressedSize;
				eminfo.dwAttributes=spinfo->dwAttributes;
				eminfo.dwCRC=spinfo->dwCRC;
				eminfo.uOSType=0;
				eminfo.wRatio=spinfo->wRatio;
				eminfo.ftCreateTime=spinfo->ftCreateTime;
				eminfo.ftAccessTime=spinfo->ftAccessTime;
				eminfo.ftWriteTime=spinfo->ftWriteTime;
				lstrcpy(eminfo.szFileName,spinfo->szFileName);
				lstrcpy(eminfo.dummy1,"");
				lstrcpy(eminfo.szAddFileName,spinfo->szAddFileName);
				lstrcpy(eminfo.dummy2,"");
			}
			r=g_Enum._proc(&eminfo);
			{
				spinfo->ftCreateTime=eminfo.ftCreateTime;
				spinfo->ftAccessTime=eminfo.ftAccessTime;
				spinfo->ftWriteTime=eminfo.ftWriteTime;
				lstrcpy(spinfo->szFileName,eminfo.szFileName);
				lstrcpy(spinfo->szAddFileName,eminfo.szAddFileName);
			}
			break;}
		case 2:
		case 3:{
			PAQAR_ENUM_MEMBER_INFO64 eminfo;
			eminfo.dwStructSize=sizeof(PAQAR_ENUM_MEMBER_INFO64);
			eminfo.uCommand=spinfo->uCommand;
			eminfo.llOriginalSize=spinfo->llOriginalSize;
			eminfo.llCompressedSize=spinfo->llCompressedSize;
			eminfo.dwAttributes=spinfo->dwAttributes;
			eminfo.dwCRC=spinfo->dwCRC;
			eminfo.uOSType=0;
			eminfo.wRatio=spinfo->wRatio;
			eminfo.ftCreateTime=spinfo->ftCreateTime;
			eminfo.ftAccessTime=spinfo->ftAccessTime;
			eminfo.ftWriteTime=spinfo->ftWriteTime;
			lstrcpy(eminfo.szFileName,spinfo->szFileName);
			lstrcpy(eminfo.dummy1,"");
			lstrcpy(eminfo.szAddFileName,spinfo->szAddFileName);
			lstrcpy(eminfo.dummy2,"");
			r=g_Enum._proc(&eminfo);
			{
				spinfo->ftCreateTime=eminfo.ftCreateTime;
				spinfo->ftAccessTime=eminfo.ftAccessTime;
				spinfo->ftWriteTime=eminfo.ftWriteTime;
				lstrcpy(spinfo->szFileName,eminfo.szFileName);
				lstrcpy(spinfo->szAddFileName,eminfo.szAddFileName);
			}
			break;}
	}
	return r;
}

BOOL SendStatusInfo(UINT uMsg, UINT nState, ExtractInfo *einfo){
	if(g_OwnerWindow._proc == NULL) return true;
	DoEvents();
	switch(g_OwnerWindow._type){
		case 1:
		case 3:{
			EXTRACTINGINFO egi;
			{
				egi.dwFileSize	= (DWORD)einfo->llFileSize;
				egi.dwWriteSize	= (DWORD)einfo->llWriteSize;
				lstrcpy(egi.szSourceFileName,	einfo->szSourceFileName);
				lstrcpy(egi.szDestFileName,		einfo->szDestFileName);
			}
			return g_OwnerWindow._type == 1 ? SendMessage(g_OwnerWindow._hwnd, uMsg, nState, (LPARAM)&egi) : g_OwnerWindow._proc(g_OwnerWindow._hwnd, uMsg, nState, &egi);}
		case 2:
		case 4:{
			EXTRACTINGINFOEX egiex;
			{
				egiex.exinfo.dwFileSize	= (DWORD)einfo->llFileSize;
				egiex.exinfo.dwWriteSize= (DWORD)einfo->llWriteSize;
				lstrcpy(egiex.exinfo.szSourceFileName,	einfo->szSourceFileName);
				lstrcpy(egiex.exinfo.szDestFileName,	einfo->szDestFileName);
				egiex.dwCompressedSize	= (DWORD)einfo->llCompressedSize;
				egiex.dwCRC				= einfo->dwCRC;
				egiex.wRatio			= einfo->wRatio;
				egiex.wDate				= einfo->wDate;
				egiex.wTime				= einfo->wTime;
				lstrcpy(egiex.szMode, einfo->szMode);
			}
			return g_OwnerWindow._type == 2 ? SendMessage(g_OwnerWindow._hwnd, uMsg, nState, (LPARAM)&egiex) : g_OwnerWindow._proc(g_OwnerWindow._hwnd, uMsg, nState, &egiex);}
		case 5:{
			EXTRACTINGINFOEX32 egiex32;
			{
				egiex32.dwStructSize		= sizeof(EXTRACTINGINFOEX32);
				egiex32.exinfo.dwFileSize	= (DWORD)einfo->llFileSize;
				egiex32.exinfo.dwWriteSize	= (DWORD)einfo->llWriteSize;
				lstrcpy(egiex32.exinfo.szSourceFileName,	einfo->szSourceFileName);
				lstrcpy(egiex32.exinfo.szDestFileName,		einfo->szDestFileName);
				egiex32.dwFileSize			= (DWORD)einfo->llFileSize;
				egiex32.dwCompressedSize	= (DWORD)einfo->llCompressedSize;
				egiex32.dwWriteSize			= (DWORD)einfo->llWriteSize;
				egiex32.dwAttributes		= (DWORD)einfo->dwAttributes;
				egiex32.dwCRC				= einfo->dwCRC;
				egiex32.wRatio				= einfo->wRatio;
				egiex32.ftCreateTime		= einfo->ftCreateTime;
				egiex32.ftAccessTime		= einfo->ftAccessTime;
				egiex32.ftWriteTime			= einfo->ftWriteTime;
				lstrcpy(egiex32.szSourceFileName,	einfo->szSourceFileName);
				lstrcpy(egiex32.szDestFileName,		einfo->szDestFileName);
			}
			return g_OwnerWindow._proc(g_OwnerWindow._hwnd, uMsg, nState, &egiex32);}
		case 6:{
			EXTRACTINGINFOEX64 egiex64;
			{
				egiex64.dwStructSize		= sizeof(EXTRACTINGINFOEX64);
				egiex64.exinfo.dwFileSize	= (DWORD)einfo->llFileSize;
				egiex64.exinfo.dwWriteSize	= (DWORD)einfo->llWriteSize;
				lstrcpy(egiex64.exinfo.szSourceFileName,	einfo->szSourceFileName);
				lstrcpy(egiex64.exinfo.szDestFileName,		einfo->szDestFileName);
				egiex64.llFileSize			= einfo->llFileSize;
				egiex64.llCompressedSize	= einfo->llCompressedSize;
				egiex64.llWriteSize			= einfo->llWriteSize;
				egiex64.dwAttributes		= einfo->dwAttributes;
				egiex64.dwCRC				= einfo->dwCRC;
				egiex64.wRatio				= einfo->wRatio;
				egiex64.ftCreateTime		= einfo->ftCreateTime;
				egiex64.ftAccessTime		= einfo->ftAccessTime;
				egiex64.ftWriteTime			= einfo->ftWriteTime;
				lstrcpy(egiex64.szSourceFileName,	einfo->szSourceFileName);
				lstrcpy(egiex64.szDestFileName,		einfo->szDestFileName);
				lstrcpy(egiex64.dummy1,				einfo->dummy1);
			}
			return g_OwnerWindow._proc(g_OwnerWindow._hwnd, uMsg, nState, &egiex64);}
		default:
			return true;
	}
}

BOOL ManageOwnerWindow(BOOL _if, BYTE _type, ARCHIVERPROC _proc, HWND _hwnd){
	if(_if) return false;
	g_OwnerWindow._type = _type;
	g_OwnerWindow._proc = _proc;
	g_OwnerWindow._hwnd = _hwnd;
	return true;
}

BOOL ManageEnum(BOOL _if, BYTE _type, PAQAR_WND_ENUMMEMBPROC _proc){
	if(_if) return false;
	g_Enum._type = _type;
	g_Enum._proc = _proc;
	return true;
}
