/** 
 * @file    plugin.h
 * @brief   vOCœǂݍTPIʃwb_B
 * @version $Id: plugin.h,v 1.11 2006/08/25 10:55:54 sirakaba Exp $
 */

/*******************************************************************************
Copyright (c) 2002-2006 Silky.

This software is provided 'as-is', without any express or implied warranty. In  
no event will the authors be held liable for any damages arising from the use of
this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

  1. The origin of this software must not be misrepresented; you must not claim 
     that you wrote the original software. If you use this software in a product,
     an acknowledgment in the product documentation would be appreciated but is 
     not required.
  2. Altered source versions must be plainly marked as such, and must not be mis-
     represented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*******************************************************************************/

#ifndef __TPI_API_SPEC
#define __TPI_API_SPEC

/*******************************************************************************
 *    Defines
 ******************************************************************************/

/**
 * @defgroup c_error G[R[h
 * eAPIsꍇɕԂAُ̗R\ӂ̐lB
 * @{
 */
/** ُ킪AɏIB */
#define TPI_ERROR_SUCCESS           TRUE

/**
 * @defgroup c_error_undefined `G[
 * TPIƂĂ͖`́AevOCƎ̃G[\B
 * @{
 */
/** `G[̊{lB */
#define TPI_ERROR_UNDEFINED         2000
#define TPI_ERROR_U_LOAD_LIBRARY    TPI_ERROR_UNDEFINED + 1 /**< CȕɎsB */
#define TPI_ERROR_U_USE_LIBRARY     TPI_ERROR_UNDEFINED + 2 /**< Cu̎gpɖ肪B */
#define TPI_ERROR_U_FREE_LIBRARY    TPI_ERROR_UNDEFINED + 3 /**< CủɎsB */
/** @} c_error_undefined */

/**
 * @defgroup c_error_defined `σG[
 * TPIƂĒ`ꂽG[\B
 * @{
 */
/** `ς݃G[̊{lB */
#define TPI_ERROR_DEFINED           3000
#define TPI_ERROR_D_PARAMETER       TPI_ERROR_DEFINED + 1   /**< APIɓnꂽsłB */
#define TPI_ERROR_D_UNSUPPORTED     TPI_ERROR_DEFINED + 2   /**< ΉĂȂAPIłB́AAPI̓̂ΉĂȂ̂s悤ƂB */
#define TPI_ERROR_D_SKIPPED         TPI_ERROR_DEFINED + 3   /**< R[obN֐AAPIɏ𒆎~悤wB */
#define TPI_ERROR_D_OUTOFMEMORY     TPI_ERROR_DEFINED + 4   /**< ɃsAmۂłȂȂB */
#define TPI_ERROR_D_USEMEMORY       TPI_ERROR_DEFINED + 5   /**< gp/ۂɖ肪B */

/**
 * @defgroup c_error_defined_io I/OG[
 * eI/OG[\BۂɕԂ鐔l plugin-extra.h ɒ`Ă萔QƁB
 * @{
 * @defgroup c_error_defined_io_target I/OΏۃt@C
 * I/OG[̑ΏۂƂȂt@C\B
 * @{
 */
#define TPI_ERROR_T_IO_MISC         0                           /**< s */
#define TPI_ERROR_T_IO_ARCHIVE      TPI_ERROR_T_IO_MISC + 100   /**<  */
#define TPI_ERROR_T_IO_FILE         TPI_ERROR_T_IO_MISC + 200   /**< ʏt@C */
#define TPI_ERROR_T_IO_WORKING      TPI_ERROR_T_IO_MISC + 300   /**< ԃt@C */
#define TPI_ERROR_T_IO_DIRECTORY    TPI_ERROR_T_IO_MISC + 400   /**< fBNg */
/** @} c_error_defined_io_target */

#define TPI_ERROR_IO_MISC           4000                    /**< ̑/sI/OG[B */
#define TPI_ERROR_IO_NOTFOUND       TPI_ERROR_IO_MISC + 1   /**< t@C݂ȂB */
#define TPI_ERROR_IO_ACCESS         TPI_ERROR_IO_MISC + 2   /**< t@CɃANZXłȂBLᔽB */
#define TPI_ERROR_IO_OPEN           TPI_ERROR_IO_MISC + 3   /**< t@CJƂɎsB */
#define TPI_ERROR_IO_CLOSE          TPI_ERROR_IO_MISC + 4   /**< t@C邱ƂɎsB */
#define TPI_ERROR_IO_READ           TPI_ERROR_IO_MISC + 5   /**< t@Cf[^ǂݍ߂ȂB */
#define TPI_ERROR_IO_WRITE          TPI_ERROR_IO_MISC + 6   /**< t@CɃf[^߂ȂB */
#define TPI_ERROR_IO_GETINFO        TPI_ERROR_IO_MISC + 7   /**< t@Cȅ擾邱ƂɎsB */
#define TPI_ERROR_IO_POINT          TPI_ERROR_IO_MISC + 8   /**< t@C̃|C^ړɎsB */
#define TPI_ERROR_IO_COPY           TPI_ERROR_IO_MISC + 9   /**< t@C̃Rs[ɎsB */
#define TPI_ERROR_IO_MOVE           TPI_ERROR_IO_MISC + 10  /**< t@C̈ړɎsB */
#define TPI_ERROR_IO_DELETE         TPI_ERROR_IO_MISC + 11  /**< t@C̍폜ɎsB */
#define TPI_ERROR_IO_SETINFO        TPI_ERROR_IO_MISC + 12  /**< t@CɊȅݒ肷邱ƂɎsB */

#define TPI_ERROR_ARC_MISC          TPI_ERROR_IO_MISC + TPI_ERROR_T_IO_ARCHIVE + 20 /**< ɂɊւG[̊{lB */
#define TPI_ERROR_ARC_UNSUPPORTED   TPI_ERROR_IO_MISC + TPI_ERROR_T_IO_ARCHIVE + TPI_ERROR_ARC_MISC + 1 /**< ɂɑΉĂȂB */
#define TPI_ERROR_ARC_ENCRYPTED     TPI_ERROR_IO_MISC + TPI_ERROR_T_IO_ARCHIVE + TPI_ERROR_ARC_MISC + 2 /**< ɂÍĂB */
#define TPI_ERROR_ARC_BROKEN_MISC   TPI_ERROR_IO_MISC + TPI_ERROR_T_IO_ARCHIVE + 30 /**< ɂ̔jɊւG[̊{lB */
#define TPI_ERROR_ARC_BROKEN_SUM    TPI_ERROR_IO_MISC + TPI_ERROR_T_IO_ARCHIVE + TPI_ERROR_ARC_BROKEN_MISC + 1  /**< `FbNTvȂB */
#define TPI_ERROR_ARC_BROKEN_SIZE   TPI_ERROR_IO_MISC + TPI_ERROR_T_IO_ARCHIVE + TPI_ERROR_ARC_BROKEN_MISC + 2  /**< t@CTCYvȂB */
#define TPI_ERROR_ARC_BROKEN_HEADER TPI_ERROR_IO_MISC + TPI_ERROR_T_IO_ARCHIVE + TPI_ERROR_ARC_BROKEN_MISC + 3  /**< wb_jĂB */
/** @} c_error_defined_io */
/** @} c_error_defined    */
/** @} c_error            */

/**
 * @defgroup c_info R[h
 * GetPluginInformation() ŁAvOCɊւ擾鎞ɗpA\ӂ̐lB
 * @{
 */
#define TPI_INFO_VERSION_MAJOR      0x0001  /**< vOC̃W[o[W */
#define TPI_INFO_VERSION_MINOR      0x0002  /**< vOC̃}Ci[o[W */
#define TPI_INFO_VERSION_API        0x0003  /**< vOCΉAPĨo[W */
#define TPI_INFO_SUPPORTED_TYPE     0x0004  /**< vOCi[ɑΉĂ` */
#define TPI_INFO_SUPPORTED_SUFFIX   0x0005  /**< vOCi[ɑΉĂgq */
/** @} c_info */

/**
 * @defgroup c_command R}hR[h
 * Command() ŏew肷ӂ̐lB
 * @{
 */
#define TPI_COMMAND_ADD             0x0001  /**< ɂɃt@Ci[ */
#define TPI_COMMAND_EXTRACT         0x0002  /**< ɂt@CWJ */
/** @} c_command */

/**
 * @defgroup c_process R[h
 * R[obN֐ɂđΏۂƂȂ鏈ʒmӂ̐lB
 * @{
 */
#define TPI_NOTIFY_COMMON           0x0001  /**< ʃbZ[WBʏ̏ɑ΂đMB */
#define TPI_NOTIFY_SETPARAM         0x0002  /**< p[^ݒBCӂ̃p[^vꍇɑMB */
/** @} c_process */

/**
 * @defgroup c_process_common CxgR[h
 * TPI_NOTIFY_COMMON MɁATPI_PROCESSINFO::uMessageɊi[lB
 * @{
 */
#define TPI_MESSAGE_STATUS          0x0001  /**< i󋵂ɂĂ̏ TPI_PROCESSINFO Ɋi[B */
#define TPI_MESSAGE_ERROR           0x0002  /**< ɑss\ȃG[B */
#define TPI_MESSAGE_WARNING         0x0003  /**< ɑs\ȌxB */
/** @} c_process_common */

/**
 * @defgroup c_process_common_status i󋵃R[h
 * TPI_MESSAGE_STATUS MꂽɁATPI_PROCESSINFO::uStatusɊi[lB
 * @{
 */
#define TPI_STATUS_OPENARCHIVE      0x0001  /**< ɂJB */
#define TPI_STATUS_CLOSEARCHIVE     0x0002  /**< ɂB */
#define TPI_STATUS_SEEKFILE         0x0003  /**< Ώۃt@CĂB */
#define TPI_STATUS_BEGINPROCESS     0x0004  /**< JnB */
#define TPI_STATUS_INPROCESS        0x0005  /**< łB */
#define TPI_STATUS_ENDPROCESS       0x0006  /**< IB */
#define TPI_STATUS_TESTARCHIVE      0x0007  /**< ɂB */
#define TPI_STATUS_COPYARCHIVE      0x0008  /**< ɂړ/B */
/** @} c_process_common_status */

/**
 * @defgroup c_callback_return R[obN֐̕Ԃl
 * R[obN֐̏IɁAԂlƂĎw肵ȂsɂĎwlB
 * @{
 */
#define TPI_CALLBACK_CONTINUE       TRUE    /**< 𑱍sB */
#define TPI_CALLBACK_CANCEL         0x1000  /**< 𒆒fB */
#define TPI_CALLBACK_UNSUPPORTED    0x1001  /**< 𖳎BsȏłB */
/** @} c_callback_return */

//******************************************************************************
//    Structures
//******************************************************************************

#pragma pack(1)

/** t@CɂĂ̏i[\́B */
typedef struct _TPI_tagFILEINFO
{
	DWORD     dwAttribute;      /**< B */
	DWORD     dwCRC32;          /**< CRC32B */
	FILETIME  ftAccessTime;     /**< ŏIQƓ */
	FILETIME  ftCreateTime;     /**< 쐬 */
	FILETIME  ftModifiedTime;   /**< ŏIXV */
	UINT      uOSType;          /**< 쐬OS */
	ULONGLONG llPackedSize;     /**< i[̃TCY */
	ULONGLONG llUnpackedSize;   /**< i[ÕTCY */
	char      szFileName[MAX_PATH * 2 + 1]; /**< t@C */
	char      szMethod[64];     /**< i[\bh */
	WORD      wCompressRatio;   /**< k */
	ULONGLONG llFileID;         /**< ӂ̃t@CID */
	void *    pCustomInfo;      /**< Cӂ̏i[ */
}	TPI_FILEINFO;

/** ɂɂĂ̏i[\́B */
typedef struct _TPI_tagARCHIVEINFO
{
	FILETIME  ftAccessTime;     /**< ŏIQƓ */
	FILETIME  ftCreateTime;     /**< 쐬 */
	FILETIME  ftModifiedTime;   /**< ŏIXV */
	int       nSFXType;         /**< SFX̎ނ\ӂ̒l */
	UINT      uOSType;          /**< 쐬OS */
	ULONGLONG llFileSize;       /**< t@CTCY */
	ULONGLONG llPackedSize;     /**< i[̃TCY */
	ULONGLONG llReadSize;       /**< ǂݍݍς݃TCY */
	ULONGLONG llUnpackedSize;   /**< i[ÕTCY */
	char      szFileName[MAX_PATH * 2 + 1]; /**< t@C */
	WORD      wCompressRatio;   /**< k */
	void *    pCustomInfo;      /**< Cӂ̏i[ */
}	TPI_ARCHIVEINFO;

/** ɂĂ̊{i[\́B */
typedef struct _TPI_tagSWITCHES
{
	BOOL   fStoreDirectoryPathes;   /**< pXi[ȂTRUE */
	char   szDestinationDirectory[MAX_PATH + 1]; /**< o͐fBNg */
	int    eArchiveType;            /**< Ɍ`\ӂ̐l */
	void * pCustomSwitches;         /**< Cӂ̏i[ */
}	TPI_SWITCHES;

/** ɂĂ̒ʒmi[\́B */
typedef struct _TPI_tagPROCESSINFO
{
	unsigned int uMessage;  /**< CxgR[h */
	unsigned int uStatus;   /**< i󋵃R[h */
	TPI_FILEINFO fiInfo;    /**< ̃t@CɊւ */
	ULONGLONG    llProcessedSize; /**< σTCY */
	char         szDestinationFileName[MAX_PATH * 2 + 1]; /**< o͐t@C */
	void *       pCustomInfo; /**< Cӂ̏i[ */
}	TPI_PROCESSINFO;

/** R[obN֐
  * @param  _uMsg   R[hB
  * @param  _pInfo  R[hɂقȂB
  * @return R[obN֐̕ԂlB
  */
typedef int(CALLBACK * TPI_PROC)(unsigned int _uMsg, void * _pInfo);

#pragma pack()

//******************************************************************************
//    Functions
//******************************************************************************

#ifdef __cplusplus
extern "C"
{
#endif

/** vOCɊւ擾B
 * @param  _uInfoId     擾l(R[h)B
 * @param  _llSubOption R[hɂقȂB
 * @param  _pPtr        ʂi[obt@ւ̃|C^B
 * @return G[R[hB
 */
int WINAPI GetPluginInformation
(
	unsigned int _uInfoId,
	ULONGLONG _llSubOption,
	void * _pPtr
);

/** vOCgp邽߂̏sB
 * @param  _szArcName   ꂩ瑀삷ΏۂƂȂ鏑ɖBsȏꍇNULLwB
 * @param  _llSubOption ɂ쐬ꍇɂ́Åi[`IDwBȊȌꍇ0B
 * @return G[R[hB
 */
int WINAPI LoadPlugin
(
	const char * _szArcName,
	ULONGLONG _llSubOption
);

/** vOCB
 * @param  _pReserved   \ς݁Bł͏NULLB
 * @return G[R[hB
 */
int WINAPI FreePlugin
(
	void * _pReserved
);

/** vOCΉĂt@CǂmFB
 * @param  _szArcName   mFΏۂƂȂ鏑ɖB
 * @param  _nFileCount  ɂɊi[Ăt@Ci[邽߂̃|C^B񂪕svȂNULLwB
 * @return G[R[hB
 */
int WINAPI CheckArchive
(
	const char * _szArcName,
	int * _nFileCount
);

/** ɂ̃nh擾B
 * @param  _szArcName   삷ΏۂƂȂ鏑ɖB
 * @param  _hArchive    擾nhi[邽߂̃|C^B
 * @return G[R[hB
 */
int WINAPI OpenArchive
(
	const char * _szArcName,
	void * * _hArchive
);

/** ɂ̃nhB
 * @param  _hArchive    삷ΏۂƂȂ鏑ɃnhB
 * @return G[R[hB
 */
int WINAPI CloseArchive
(
	void * _hArchive
);

/** ɂɊi[Ăt@C̏Ɏ擾B
 * @param  _hArchive    삷ΏۂƂȂ鏑ɃnhB
 * @param  _fiInfo      擾i[邽߂̃|C^B
 * @param  _bFirst      ŏ̃t@C擾ꍇɂTRUEB
 * @return G[R[hB
 */
int WINAPI GetFileInformation
(
	void * _hArchive,
	TPI_FILEINFO * _fiInfo,
	BOOL _bFirst
);

/** ɂ̏Ɏ擾B
 * @param  _hArchive    삷ΏۂƂȂ鏑ɃnhB
 * @param  _aiInfo      擾i[邽߂̃|C^B
 * @return G[R[hB
 */
int WINAPI GetArchiveInformation
(
	void * _hArchive,
	TPI_ARCHIVEINFO * _aiInfo
);

/** ȅɑsB
 * @param  _uCommand    ɑ̎ނ\R}hR[hB
 * @param  _swInfo      ɑɕKvȏi[\̂ւ̃|C^B
 * @param  _szArcName   삷ΏۂƂȂ鏑ɖB
 * @param  _szFiles     t@Cw肷s(\\n)؂胊XgB
 * @return G[R[hB
 */
int WINAPI Command
(
	unsigned int _uCommand,
	TPI_SWITCHES * _swInfo,
	const char * _szArcName,
	const char * _szFiles
);

/** Command() sɏ̐i󋵂𑗐MR[obN֐w肷B
 * @param  _prArcProc   R[obN֐ւ̃|C^B
 * @return G[R[hB
 */
int WINAPI SetCallbackProc
(
	TPI_PROC _prArcProc
);

#ifdef __cplusplus
}
#endif

#endif /* __TPI_API_SPEC */
