/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: frm_main.cpp,v 1.26 2009/08/20 13:40:42 sirakaba Exp $
*******************************************************************************/

#include "frontend-wx.h"

#include "frm_main.h"
#include "cls_filedroptarget.h"
#include "dlg_make.h"
#include "dlg_process.h"
#include "functions.h"

#include <wx/fileconf.h>
#include <wx/arrstr.h>
#include <wx/arrimpl.cpp>

WX_DEFINE_OBJARRAY(ArrayTPI_FILEINFO);

#define SetMenuToolState(id, state) this->toolbar->EnableTool(XRCID(id), state); this->menubar->Enable(XRCID(id), state)

//******************************************************************************
//    O[oϐ
//******************************************************************************

wxImageList g_hIconT(16, 16), g_hIconLL(32, 32), g_hIconLS(16, 16);
int g_nSortingColumn;

//******************************************************************************
// MainFrame
//******************************************************************************

MainFrame::MainFrame(): wxFrame()
{
}

MainFrame::~MainFrame()
{
	wxCommandEvent e;
	this->OnArcClose(e);

	// ݒL^B
	wxFileConfig fc(wxEmptyString, wxEmptyString, ::wxGetCwd() + wxT("/frontend.conf"), wxEmptyString, wxCONFIG_USE_LOCAL_FILE);
	if (! this->IsIconized() && ! this->IsMaximized())
	{
		int a, b;
		this->GetSize(& a, & b);
		fc.Write(wxT("Window-Width"), a);
		fc.Write(wxT("Window-Height"), b);
		this->GetPosition(& a, & b);
		fc.Write(wxT("Window-X"), a);
		fc.Write(wxT("Window-Y"), b);
	}
	fc.Write(wxT("Splitter-Pos"), this->window_splitter->GetSashPosition());
	fc.Write(wxT("ListView-IconMode"), this->menubar->IsChecked(XRCID("Exe_View_Icons")));
	fc.Write(wxT("ListView-SortingColumn"), g_nSortingColumn);
	fc.Write(wxT("LastOpenPath"), this->fnLastOpenPath.GetFullPath());

	this->Close(true);
}

//******************************************************************************
// Event Table.
//******************************************************************************

BEGIN_EVENT_TABLE(MainFrame, wxFrame)
	EVT_INIT_DIALOG(      MainFrame::OnInit)
	// Menu
	EVT_MENU(XRCID("Arc_Create"),  MainFrame::OnArcCreate)
	EVT_MENU(XRCID("Arc_Open"),    MainFrame::OnArcOpen)
	EVT_MENU(XRCID("Arc_Close"),   MainFrame::OnArcClose)
	EVT_MENU(XRCID("Arc_Add"),     MainFrame::OnArcAdd)
	EVT_MENU(XRCID("Arc_SFX"),     MainFrame::OnArcSFX)
	EVT_MENU(XRCID("Arc_UnSFX"),   MainFrame::OnArcUnSFX)
	EVT_MENU(XRCID("Exe_Exit"),    MainFrame::OnExit)
	EVT_MENU(XRCID("Arc_Extract"), MainFrame::OnArcExtract)
	EVT_MENU(XRCID("Arc_Delete"),  MainFrame::OnArcDelete)
	EVT_MENU(XRCID("Arc_Test"),    MainFrame::OnArcTest)
	EVT_MENU(XRCID("Arc_Repair"),  MainFrame::OnArcRepair)
	EVT_MENU(XRCID("Exe_View_Icons"),  MainFrame::OnViewMode)
	EVT_MENU(XRCID("Exe_View_Details"),MainFrame::OnViewMode)
	EVT_MENU(XRCID("Exe_View_SelectAll"),MainFrame::OnSelectAll)
	// TreeView
	EVT_TREE_SEL_CHANGED(XRCID("TreeView"), MainFrame::OnTreeChanged)
	// ListView
	EVT_LIST_ITEM_ACTIVATED(XRCID("ListView"), MainFrame::OnListItemDClick)
	EVT_LIST_BEGIN_DRAG(XRCID("ListView"), MainFrame::OnListBeginDrag)
END_EVENT_TABLE()

//******************************************************************************
// Event handler.
//******************************************************************************

void MainFrame::OnInit(wxInitDialogEvent&)
{
	// XRCƌтB
	this->menubar    = this->GetMenuBar();
	this->toolbar    = this->GetToolBar();
	this->statusbar = XRCCTRL(* this, "statusbar", wxStatusBar);
	this->tree_ctrl = XRCCTRL(* this, "TreeView", wxTreeCtrl);
	this->list_ctrl = XRCCTRL(* this, "ListView", myListCtrl);
	this->window_splitter = XRCCTRL(* this, "window_splitter", wxSplitterWindow);

	// ݒǂݍ݁B
	wxFileConfig fc(wxEmptyString, wxEmptyString, ::wxGetCwd() + wxT("/frontend.conf"), wxEmptyString, wxCONFIG_USE_LOCAL_FILE);
	this->SetSize(fc.Read(wxT("Window-X"), 0l), fc.Read(wxT("Window-Y"), 0l), fc.Read(wxT("Window-Width"), 800), fc.Read(wxT("Window-Height"), 400));
	this->nProgressShowFileNumLimit = fc.Read(wxT("ProgressShowFileNumLimit"), 1000);
	this->fnLastOpenPath = wxFileName::DirName(fc.Read(wxT("LastOpenPath"), ::wxGetCwd()));

	// lݒB
	{
		wxIcon icon;
		icon.CopyFromBitmap(wxBitmap(FE_DIR_S_ICO wxT("app.png"), wxBITMAP_TYPE_ANY));
		this->SetIcon(icon);
	}

	wxCommandEvent e;
	e.SetId(fc.Read(wxT("ListView-IconMode"), 0l) ? XRCID("Exe_View_Icons") : XRCID("Exe_View_Details"));
	this->OnArcClose(e);
	this->OnViewMode(e);
	this->window_splitter->SetSashPosition(fc.Read(wxT("Splitter-Pos"), 200));
	this->list_ctrl->InsertColumn(0, wxT("Filename"),      wxLIST_FORMAT_LEFT,  140);
	this->list_ctrl->InsertColumn(1, wxT("Unpacked"),      wxLIST_FORMAT_RIGHT,  80);
	this->list_ctrl->InsertColumn(2, wxT("Packed"),        wxLIST_FORMAT_RIGHT,  80);
	this->list_ctrl->InsertColumn(3, wxT("Ratio"),         wxLIST_FORMAT_RIGHT,  50);
	this->list_ctrl->InsertColumn(4, wxT("Method"),        wxLIST_FORMAT_LEFT,   60);
	this->list_ctrl->InsertColumn(5, wxT("Attr"),          wxLIST_FORMAT_LEFT,   50);
	this->list_ctrl->InsertColumn(6, wxT("Last modified"), wxLIST_FORMAT_RIGHT, 140);
	this->list_ctrl->InsertColumn(7, wxT("Path"),          wxLIST_FORMAT_LEFT,  100);
	this->list_ctrl->InsertColumn(8, wxT("Type"),          wxLIST_FORMAT_LEFT,  100);
	this->list_ctrl->InsertColumn(9, wxT("No."),           wxLIST_FORMAT_LEFT,   35);
	g_nSortingColumn = fc.Read(wxT("ListView-SortingColumn"), 9);

	this->list_ctrl->SetDropTarget(new myFileDropTarget(this));

	int nStatusBarParts[] = {40, 60, 120, 120, 90, 1000};
	this->statusbar->SetFieldsCount(6, nStatusBarParts);

	// R}hCǂݍ݁B
	this->cmdLine.SetSwitchChars(wxT("-"));
	this->cmdLine.AddSwitch(wxT("x"), wxEmptyString, wxT("(command) Extract filenames in archive."));
	this->cmdLine.AddSwitch(wxT("l"), wxEmptyString, wxT("(command) List archive(default)."));
	this->cmdLine.AddSwitch(wxT("r"), wxEmptyString, wxT("Use stored pathes(recommend)."));
	this->cmdLine.AddParam(wxT("archive"),   wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_OPTIONAL);
	this->cmdLine.AddParam(wxT("filenames"), wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_OPTIONAL | wxCMD_LINE_PARAM_MULTIPLE);
	if (this->cmdLine.Parse() == 0)
	{
		if (this->cmdLine.GetParamCount() == 0)
		{
			return;
		}

		if (this->cmdLine.Found(wxT("x")))
		{
			// ɂWJB
		}
		else
		{
			// ɂJB
			wxFileName fnArchive(this->cmdLine.GetParam(0));
			fnArchive.Normalize(wxPATH_NORM_ALL, this->szCurrentPath);
			this->LoadArc(fnArchive.GetFullPath());
		}
	}
}

// MenuBar

void MainFrame::OnExit(wxCommandEvent&)
{
	this->Close(true);
}

void MainFrame::OnArcCreate(wxCommandEvent& e)
{
	// Ώۂ̃t@CIB
	wxArrayString files;
	{
		wxFileDialog fdDlg(this, wxT("Choose files to compress"), this->fnLastOpenPath.GetFullPath(), wxEmptyString, wxFileSelectorDefaultWildcardStr, wxFD_OPEN | wxFD_FILE_MUST_EXIST | wxFD_MULTIPLE);
		if (fdDlg.ShowModal() == wxID_CANCEL)
		{
			return;
		}
		// wxFileName::FileNamepĂ̂́AŃfBNgKvƂꍇ邽߁B
		// ܂悢dlł͂Ȃ̂łƂ肠uB
		this->fnLastOpenPath = wxFileName::FileName(fdDlg.GetDirectory());
		fdDlg.GetFilenames(files);
	}

	for (size_t i = 0 ; i < files.GetCount(); i++)
	{
		files[i].Replace(wxT("\\"), wxT("/"));
	}

	// eݒB
	TPI_SWITCHES swInfo;
	swInfo.fnDestinationDirectory = wxFileName::DirName(this->fnLastOpenPath.GetFullPath());
	swInfo.pCustomSwitches = NULL;
	this->statusbar->SetStatusText(swInfo.fnDestinationDirectory.GetFullPath(), 5);

	// 쐬_CAOݒB
	MakeDialog mkDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_make.xrc"));
	::wxXmlResource::Get()->LoadDialog(& mkDlg, this, wxT("dlg_make"));	
	mkDlg.InitDialog();
	mkDlg.cbDir->SetValue(swInfo.fnDestinationDirectory.GetFullPath());
	// ɖ̓t@C̊gqOA̓fBNgB
	mkDlg.cbFileName->SetValue(files.GetCount() == 1 ? wxFileName::FileName(files[0]).GetName() : this->fnLastOpenPath.GetFullName());

	// _CAO\B
	if (mkDlg.ShowModal() == wxID_CANCEL)
	{
		this->statusbar->SetStatusText(wxEmptyString, 5);
		return;
	}
	this->statusbar->SetStatusText(wxEmptyString, 5);

	// eݒB
	swInfo.fStoreDirectoryPathes = ! mkDlg.cbIgnorePath->IsChecked();
	swInfo.fMakeSFX = mkDlg.cbMakeSFX->IsChecked();

	// TPIǂݍ݁B
	int nSelected = mkDlg.chType->GetSelection();
	wxFileName fnArchive = wxFileName::DirName(mkDlg.cbDir->GetValue());
	fnArchive.SetName(mkDlg.cbFileName->GetValue());
	fnArchive.SetExt(swInfo.fMakeSFX ? wxT("exe") : mkDlg.defext[nSelected]);
	if (! tpi.InitLibrary(mkDlg.libname[nSelected], fnArchive.GetFullPath(), nSelected))
	{
		::wxMessageBox(wxT("Fault: InitLibrary()!"));
		return;
	}

	// sB
	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));
	procDlg.InitDialog();
	procDlg.Show(true);
	int nErrorCode = this->ErrorCheck(tpi.Command(TPI_COMMAND_ADD, & swInfo, fnArchive.GetFullPath(), files));
	procDlg.Show(false);
	tpi.FreeLibrary();
	if (nErrorCode != TPI_ERROR_SUCCESS)
	{
		return;
	}

	if (mkDlg.cbOpenAfter->IsChecked())
	{
		// 쐬JB
#ifdef __WINDOWS__
		::wxExecute(wxT("explorer ") + swInfo.fnDestinationDirectory.GetFullPath());
#endif
	}

	if (mkDlg.cbExitAfter->IsChecked())
	{
		// IB
		this->Close(true);
	}

	// IȂꍇ͏ɂJB
	this->OnArcClose(e);
	this->LoadArc(fnArchive.GetFullPath());
}

void MainFrame::OnArcOpen(wxCommandEvent& e)
{
	// ɂIB
	wxString szFileName;
	{
		wxFileDialog fdDlg(this);
		fdDlg.SetDirectory(this->fnLastOpenPath.GetFullPath());
		if (fdDlg.ShowModal() == wxID_CANCEL)
		{
			return;
		}
		this->fnLastOpenPath = wxFileName::DirName(fdDlg.GetDirectory());
		szFileName = fdDlg.GetPath();
	}

	// ɂǂݍ݁B
	this->OnArcClose(e);
	this->LoadArc(szFileName);
}

void MainFrame::OnArcClose(wxCommandEvent&)
{
	// c[r[EXgr[ݒB
	this->tree_ctrl->DeleteAllItems();
	this->list_ctrl->DeleteAllItems();

	// c[o[Ej[o[ݒB
	SetMenuToolState("Arc_Close",   false);
	SetMenuToolState("Arc_Add",     false);
	SetMenuToolState("Arc_SFX",     false);
	SetMenuToolState("Arc_UnSFX",   false);
	SetMenuToolState("Arc_Extract", false);
	SetMenuToolState("Arc_Delete",  false);
	SetMenuToolState("Arc_Test",    false);
	SetMenuToolState("Arc_Repair",  false);

	for (int i = 0; i < this->statusbar->GetFieldsCount(); i++)
	{
		this->statusbar->SetStatusText(wxEmptyString, i);
	}
	this->fileinfo.Clear();
	g_hIconT.RemoveAll();
	g_hIconLL.RemoveAll();
	g_hIconLS.RemoveAll();
	this->tpi.FreeLibrary();
}

void MainFrame::OnArcAdd(wxCommandEvent& e)
{
	// Ώۂ̃t@CIB
	wxArrayString files;
	wxFileDialog fdDlg(this, wxT("Choose files to add"), wxEmptyString, wxEmptyString, wxFileSelectorDefaultWildcardStr, wxFD_OPEN | wxFD_FILE_MUST_EXIST | wxFD_MULTIPLE);
	if (fdDlg.ShowModal() == wxID_CANCEL)
	{
		return;
	}
	fdDlg.GetFilenames(files);
	for (size_t i = 0 ; i < files.GetCount(); i++)
	{
		files[i].Replace(wxT("\\"), wxT("/"));
	}

	// eݒB
	TPI_SWITCHES swInfo;
	swInfo.fnDestinationDirectory = wxFileName::DirName(fdDlg.GetDirectory());
	swInfo.fMakeSFX = false;
	swInfo.pCustomSwitches = NULL;
	wxString szArcName = this->statusbar->GetStatusText(5);

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_ADD, & swInfo, szArcName, files));
	procDlg.Show(false);

	// ɂēǂݍ݁B
	this->OnArcClose(e);
	this->LoadArc(szArcName);
}

void MainFrame::OnArcSFX(wxCommandEvent&)
{
	// ۑq˂B
	wxFileName fnArchive(this->statusbar->GetStatusText(5));
	wxFileDialog fdDlg(this, wxT("Save as SFX"), fnArchive.GetPath(wxPATH_GET_VOLUME), fnArchive.GetName() + wxT(".exe"), wxFileSelectorDefaultWildcardStr, wxFD_SAVE | wxFD_OVERWRITE_PROMPT);
	if (fdDlg.ShowModal() == wxID_CANCEL)
	{
		return;
	}
	this->fnLastOpenPath = wxFileName::DirName(fdDlg.GetDirectory());

	wxArrayString files;
	files.Add(fdDlg.GetPath());

	TPI_SWITCHES swInfo;
	swInfo.fMakeSFX = true;
	swInfo.fnDestinationDirectory = wxFileName::DirName(fdDlg.GetDirectory());

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_SFX, & swInfo, fnArchive.GetFullPath(), files));
	procDlg.Show(false);
}

void MainFrame::OnArcUnSFX(wxCommandEvent&)
{
	// ۑq˂B
	wxFileName fnArchive(this->statusbar->GetStatusText(5));
	wxFileDialog fdDlg(this, wxT("Save as normal archive"), fnArchive.GetPath(wxPATH_GET_VOLUME), fnArchive.GetName(), wxFileSelectorDefaultWildcardStr, wxFD_SAVE | wxFD_OVERWRITE_PROMPT);
	if (fdDlg.ShowModal() == wxID_CANCEL)
	{
		return;
	}
	this->fnLastOpenPath = wxFileName::DirName(fdDlg.GetDirectory());

	wxArrayString files;
	files.Add(fdDlg.GetPath());

	TPI_SWITCHES swInfo;
	swInfo.fMakeSFX = true;
	swInfo.fnDestinationDirectory = wxFileName::DirName(fdDlg.GetDirectory());

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_UNSFX, & swInfo, fnArchive.GetFullPath(), files));
	procDlg.Show(false);
}

void MainFrame::OnArcExtract(wxCommandEvent&)
{
	// WJ_CAO쐬B
	MakeDialog mkDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_make.xrc"));
	::wxXmlResource::Get()->LoadDialog(& mkDlg, this, wxT("dlg_make"));
	mkDlg.bIsMake = false;
	mkDlg.files   = MakeTargetFileList(this, false);
	mkDlg.InitDialog();
	if (mkDlg.ShowModal() == wxID_CANCEL)
	{
		return;
	}

	// eݒB
	TPI_SWITCHES swInfo;
	swInfo.fStoreDirectoryPathes = ! mkDlg.cbIgnorePath->IsChecked();
	swInfo.fnDestinationDirectory = wxFileName::DirName(mkDlg.cbDir->GetValue());
	swInfo.pCustomSwitches = NULL;

	// KvȂ珑ɖŃfBNg쐬B
	if (WillMakeDirByArcName(this, & mkDlg))
	{
		swInfo.fnDestinationDirectory = MakeDirPath(swInfo.fnDestinationDirectory, wxFileName::FileName(this->statusbar->GetStatusText(5)).GetFullName(), true);
		if (! swInfo.fnDestinationDirectory.IsOk())
		{
			::wxMessageBox(wxT("Fault: Unable to make the destination directory!"));
			return;
		}
	}

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	if (mkDlg.files.Count() < this->nProgressShowFileNumLimit)
	{
		procDlg.Show(true);
	}
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_EXTRACT, & swInfo, this->statusbar->GetStatusText(5), mkDlg.files));
	procDlg.Show(false);

	if (mkDlg.cbOpenAfter->IsChecked())
	{
		// WJJB
#ifdef __WINDOWS__
		::wxExecute(wxT("explorer ") + swInfo.fnDestinationDirectory.GetFullPath());
#endif
	}

	if (mkDlg.cbExitAfter->IsChecked())
	{
		// IB
		this->Close(true);
	}
}

void MainFrame::OnArcDelete(wxCommandEvent& e)
{
	// St@C폜͊댯ł͂ȂƁB
	if (this->list_ctrl->GetSelectedItemCount() == 0)
	{
		return;
	}

	if (::wxMessageBox(wxT("Are you sure to delete selected files?"), wxMessageBoxCaptionStr, wxYES_NO | wxICON_EXCLAMATION, this) == wxNO)
	{
		return;
	}

	// eݒB
	TPI_SWITCHES swInfo;
	wxString szArcName = this->statusbar->GetStatusText(5);
	wxArrayString files = MakeTargetFileList(this, false);

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_DELETE, & swInfo, szArcName, files));
	procDlg.Show(false);	

	// ɂēǂݍ݂B
	this->OnArcClose(e);
	this->LoadArc(szArcName);
}

void MainFrame::OnArcTest(wxCommandEvent&)
{
	// eݒB
	wxArrayString files = MakeTargetFileList(this, false);
	TPI_SWITCHES swInfo;

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	if (this->ErrorCheck(this->tpi.Command(TPI_COMMAND_TEST, & swInfo, this->statusbar->GetStatusText(5), files)) == TPI_ERROR_SUCCESS)
	{
		::wxMessageBox(wxT("This is a correct archive."), wxT("Frontend"), wxOK | wxCENTRE | wxICON_INFORMATION, this);
	}
	procDlg.Show(false);
}

void MainFrame::OnArcRepair(wxCommandEvent&)
{
	// eݒB
	wxArrayString files = MakeTargetFileList(this, false);
	TPI_SWITCHES swInfo;

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_REPAIR, & swInfo, this->statusbar->GetStatusText(5), files));
	procDlg.Show(false);	
}

void MainFrame::OnViewMode(wxCommandEvent & e)
{
	int n = e.GetId();
	this->menubar->Check(n, true);
	this->list_ctrl->SetSingleStyle(wxLC_REPORT, n == XRCID("Exe_View_Details"));
	this->list_ctrl->SetSingleStyle(wxLC_ICON,   n == XRCID("Exe_View_Icons"));
}

void MainFrame::OnSelectAll(wxCommandEvent &)
{
	for (int i = 0; i < this->list_ctrl->GetItemCount(); i++)
	{
		this->list_ctrl->SetItemState(i, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
	}
}

// TreeView

void MainFrame::OnTreeChanged(wxTreeEvent& e)
{
	// c[r[pX擾B
	wxString szNodePath = TreeView_GetItemPath(this->tree_ctrl, e.GetItem());
	// Xgr[B
	this->list_ctrl->showFileInfo.Clear();

	// ACRݒB
	this->list_ctrl->SetImageList(& g_hIconLL, wxIMAGE_LIST_NORMAL);
	this->list_ctrl->SetImageList(& g_hIconLS, wxIMAGE_LIST_SMALL);

	// zƔrApXvȂΏB
	for (size_t i = 0; i < this->fileinfo.GetCount(); i++)
	{
		// pXrB
		if (szNodePath == wxT("*") || szNodePath == this->fileinfo[i].fnFileName.GetPath())
		{
			// ڂtH_łȂ疳B
			if (this->fileinfo[i].fnFileName.IsDir())
			{
				continue;
			}

			this->list_ctrl->showFileInfo.Add(this->fileinfo[i]);
			this->list_ctrl->SetItemPtrData(this->list_ctrl->showFileInfo.Count() - 1, (wxUIntPtr) & this->list_ctrl->showFileInfo[i]);
		}
	}
	// \[gĕ\B
	this->list_ctrl->showFileInfo.Sort(& ListCtrlCompareProc);
	this->list_ctrl->SetItemCount(this->list_ctrl->showFileInfo.Count());
}

// ListView

void MainFrame::OnListItemDClick(wxListEvent&)
{
	// WJΏۂB
	wxArrayString files = MakeTargetFileList(this, true);

	// R}h擾B
	wxMimeTypesManager mimeFile;
	wxFileType * ftFile = mimeFile.GetFileTypeFromExtension(wxFileName::FileName(files[0]).GetExt());
	if (! ftFile)
	{
		::wxMessageBox(wxT("Fault: Unable to get the file type!"));
		return;
	}

	// eݒB
	TPI_SWITCHES swInfo;
	swInfo.fStoreDirectoryPathes = false;
	swInfo.pCustomSwitches = NULL;
	swInfo.fnDestinationDirectory = MakeDirPath(wxFileName::DirName(::wxGetCwd()), wxT("tpi_tmp"), true);
	if (! swInfo.fnDestinationDirectory.IsOk())
	{
		::wxMessageBox(wxT("Fault: Unable to make the temporary directory!"));
		return;
	}

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	int nErrorCode = this->ErrorCheck(this->tpi.Command(TPI_COMMAND_EXTRACT, & swInfo, this->statusbar->GetStatusText(5), files));
	procDlg.Show(false);

	// R}hsB
	wxString s = swInfo.fnDestinationDirectory.GetPathWithSep() + wxFileName::FileName(files[0]).GetFullName();
	if (nErrorCode == TPI_ERROR_SUCCESS)
	{
		::wxExecute(ftFile->GetOpenCommand(s), wxEXEC_SYNC);
	}

	// ꎞfBNg폜B
	::wxRemoveFile(s);
	::wxRmdir(swInfo.fnDestinationDirectory.GetFullPath());
}

void MainFrame::OnListBeginDrag(wxListEvent&)
{
	if (this->list_ctrl->GetSelectedItemCount() == 0)
	{
		// ACeIhbO悤ƂꍇB
		return;
	}

	// eݒB
	TPI_SWITCHES swInfo;
	swInfo.fStoreDirectoryPathes = false;
	swInfo.pCustomSwitches = NULL;
	swInfo.fnDestinationDirectory = MakeDirPath(wxFileName::DirName(::wxGetCwd()), wxT("tpi_tmp"), true);
	if (! swInfo.fnDestinationDirectory.IsOk())
	{
		::wxMessageBox(wxT("Fault: Unable to make the temporary directory!"));
		return;
	}

	// WJΏۂB
	wxFileDataObject objFile;
	wxArrayString files = MakeTargetFileList(this, false);
	for (size_t i = 0; i < files.Count(); i++)
	{
		// XgɒǉB
		objFile.AddFile(swInfo.fnDestinationDirectory.GetPathWithSep() + wxFileName::FileName(files[i]).GetFullName());
	}

	this->ErrorCheck(tpi.Command(TPI_COMMAND_EXTRACT, & swInfo, this->statusbar->GetStatusText(5), files));

	wxDropSource dropSource;
	dropSource.SetData(objFile);
	if (dropSource.DoDragDrop() != wxDragMove)
	{
		// ꎞfBNg폜B
		wxArrayString szFileNames = objFile.GetFilenames();
		for (size_t i = 0; i < szFileNames.GetCount(); i++)
		{
			::wxRemoveFile(szFileNames[i]);
		}
		::wxRmdir(swInfo.fnDestinationDirectory.GetFullPath());
	}
}

// CxgnhȊOB

void MainFrame::LoadArc(wxString szFileName)
{
	if (szFileName.IsEmpty())
	{
		return;
	}
	szFileName.Replace(wxT("\\"), wxT("/"));

	// TPIǂݍ݁B
	wxFileSystem fs;
	fs.ChangePathTo(FE_DIR_B_LIB, true);
	wxString szTPIName = fs.FindFirst(wxT("*" TPI_EXT), wxFILE);
	int nFileCount = -1;
	while (! szTPIName.IsEmpty())
	{
		// ΉmFB
		if (! tpi.InitLibrary(szTPIName, szFileName, 0) || ! tpi.CheckArchive(szFileName, & nFileCount) || nFileCount < 0)
		{
			tpi.FreeLibrary();
			szTPIName = fs.FindNext();
			continue;
		}
		break;
	}
	if (nFileCount == -1)
	{
		tpi.FreeLibrary();
		::wxMessageBox(wxT("Fault : No plug-in supporting this archive was found!"));
		return;
	}

	// i_CAO\BAt@CƂ͑xD悵ĕ\ȂB
	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	if ((unsigned) nFileCount < this->nProgressShowFileNumLimit)
	{
		procDlg.Show(true);
	}

	// ŏ̃R[obN𑗐MB
	TPI_PROCESSINFO piInfo;
	piInfo.uMessage = TPI_MESSAGE_STATUS;
	piInfo.uStatus = 0x1000;
	piInfo.fiInfo.fnFileName = wxFileName::FileName(szFileName);
	piInfo.fiInfo.llUnpackedSize = nFileCount;
	TPICallbackProc(TPI_NOTIFY_COMMON, & piInfo);

	// ɂJB
	void * hArc = NULL;
	if (tpi.OpenArchive(szFileName, & hArc) != TPI_ERROR_SUCCESS)
	{
		procDlg.Show(false);
		tpi.FreeLibrary();
		::wxMessageBox(wxT("Fault : OpenArchive()!"));
		return;
	}

	// 摜Xg쐬B
	this->tree_ctrl->SetImageList(& g_hIconT);
	this->tree_ctrl->AddRoot(wxEmptyString);

	// ɂ̃ACR擾AɃ[g쐬B
	wxFileName fn(szFileName);
	wxTreeItemId idRoot = this->tree_ctrl->GetRootItem();
	wxTreeItemId idArchive = this->tree_ctrl->InsertItem(idRoot, idRoot, fn.GetFullName(), g_hIconT.Add(GetFileTypeIcon(fn)), -1);

	// [gfBNg쐬B
	wxTreeItemId idArcRoot = this->tree_ctrl->InsertItem(idRoot, idArchive, wxT("-----"), g_hIconT.Add(wxBitmap(FE_DIR_S_ICO wxT("Folder_closed.png"), wxBITMAP_TYPE_ANY)), -1);

	// z̃TCYmہB
	this->fileinfo.Alloc(nFileCount);

	// t@C[hB
	TPI_FILEINFO fiInfo;
	if (tpi.GetFileInformation(hArc, & fiInfo, true) == TPI_ERROR_SUCCESS)
	{
		do
		{
			piInfo.uStatus = 0x1001;
			piInfo.fiInfo.fnFileName = fiInfo.fnFileName;
			piInfo.llProcessedSize = this->fileinfo.GetCount();
			TPICallbackProc(TPI_NOTIFY_COMMON, & piInfo);

			// c[r[ɔfB
			TreeView_CheckNewerItem(this->tree_ctrl, idArcRoot, fiInfo.fnFileName.GetPath(wxPATH_GET_VOLUME, wxPATH_UNIX));

			// fBNg܂ނ̂ɂĂ͏B
			if (fiInfo.dwAttribute & TPI_ATTRIBUTE_DIRECTORY)
			{
				continue;
			}

			// ۑăJEgAbvB
			this->fileinfo.Add(fiInfo);
			piInfo.uStatus = 0x1002;
			TPICallbackProc(TPI_NOTIFY_COMMON, & piInfo);
		}
		while (tpi.GetFileInformation(hArc, & fiInfo, false) == TPI_ERROR_SUCCESS);
	}
	this->fileinfo.Shrink();
	this->tree_ctrl->ExpandAllChildren(idArcRoot);
	this->tree_ctrl->ScrollTo(idArchive);
	this->tree_ctrl->SelectItem(idArchive);

	// ɂ̏擾B
	TPI_ARCHIVEINFO aiInfo;
	if (tpi.GetArchiveInformation(hArc, & aiInfo) != TPI_ERROR_SUCCESS)
	{
		procDlg.Show(false);
		tpi.FreeLibrary();
		::wxMessageBox(wxT("Fault : GetArchiveInformation()!"));
		return;
	}

	wxString szStatusText;
	this->statusbar->SetStatusText(wxEmptyString, 0);
	szStatusText.Printf(wxT("%d file(s)"), nFileCount);
	this->statusbar->SetStatusText(szStatusText, 1);
	this->statusbar->SetStatusText(wxT("Unpacked: ") + aiInfo.llUnpackedSize.ToString() + wxT(" B"), 2);
	this->statusbar->SetStatusText(wxT("Packed: ")   + aiInfo.llPackedSize.ToString()   + wxT(" B"), 3);
	szStatusText.Printf(wxT("Ratio: %3.1f%%"), aiInfo.wCompressRatio / 10.0);
	this->statusbar->SetStatusText(szStatusText, 4);
	this->statusbar->SetStatusText(szFileName, 5);

	// ɂB
	if (tpi.CloseArchive(hArc) != TPI_ERROR_SUCCESS)
	{
		::wxMessageBox(wxT("Fault : CloseArchive()!"));
	}

	// R[obN֐ݒB
	if (tpi.SetCallbackProc(TPICallbackProc) != TPI_ERROR_SUCCESS)
	{
		::wxMessageBox(wxT("Fault : SetCallbackProc()!"));
	}

	// UIeݒB
	{
		// c[o[Ej[o[ݒB
		SetMenuToolState("Arc_Close",   true);
		SetMenuToolState("Arc_Add",     true);
		SetMenuToolState("Arc_SFX",     aiInfo.nSFXType == 0);
		SetMenuToolState("Arc_UnSFX",   aiInfo.nSFXType != 0);
		SetMenuToolState("Arc_Extract", true);
		SetMenuToolState("Arc_Delete",  true);
		SetMenuToolState("Arc_Test",    true);
		SetMenuToolState("Arc_Repair",  true);
	}

	procDlg.Show(false);
}

int MainFrame::ErrorCheck(int nErrorCode)
{
	wxString s;
	switch (nErrorCode)
	{
	case TPI_ERROR_SUCCESS:
		return TPI_ERROR_SUCCESS;
	case TPI_ERROR_D_UNSUPPORTED:
		s.Printf(wxT("Sorry, this functions is not supported yet."), nErrorCode);
		break;
	case TPI_ERROR_D_SKIPPED:
		s.Printf(wxT("This operation is canceled by the user."), nErrorCode);
		break;
	default:
		s.Printf(wxT("ErrorCode:%d"), nErrorCode);
	}
	::wxMessageBox(s, wxT("Frontend"), wxOK | wxCENTRE | wxICON_ERROR, this);
	return nErrorCode;
}
