# -*- coding: utf-8 -*-

#
# Copyright (C) 2009 ソフトウエア興業株式会社 All rights reserved.
# author 青山陽一
# mail : aoyama-y@users.sourceforge.jp
#
# 本プログラムはフリーソフトウェアです。GPLv2のもとに配布されています。
#

from genshi.builder import tag

import re, calendar, time
from calendar import monthcalendar
from datetime import datetime, date, timedelta, tzinfo

from trac.core import *
from trac.web.chrome import INavigationContributor, ITemplateProvider, \
        add_stylesheet
from trac.web.main import IRequestHandler
from trac.web import auth
from trac.util import escape, Markup
from trac.web.href import Href
from trac.config import Option,ListOption, BoolOption, IntOption

from trac.env import IEnvironmentSetupParticipant

class NicoBaseModule(Component):
    implements(INavigationContributor, IRequestHandler, ITemplateProvider, IEnvironmentSetupParticipant)

    IntOption('nico', 'dispdays', 14,"""""")

    # INavigationContributor methods
    def get_active_navigation_item(self, req):
        return 'nico'

    def get_navigation_items(self, req):
        authname = None
        # 認証していない場合はリンクにメニューを表示しない
        if req.remote_user:
            authname = req.remote_user
        else:
            authname = req.authname
        if authname == None or authname == 'anonymous':
            return

        # yield 'mainnav', 'nico', Markup(u'<a href="%s">NicoCale</a>') % self.env.href.nico()
        yield ('mainnav', 'nico',tag.a(u'NicoCale', href=self.env.href.nico()) )

    # IRequestHandler methods
    def match_request(self, req):
        return req.path_info == '/nico'

    def process_request(self, req):
        authname = None
        if req.remote_user:
            authname = req.remote_user
        else:
            authname = req.authname

        add_stylesheet(req, 'hw/css/nico.css')
        req.args['nico_insert_href'] = req.href.nico_insert()
        req.args['nico_comment_href'] = req.href.nico_comment()

        dispDays = self.env.config.getint('nico', 'dispdays')

        # ログインユーザの登録状態取得
        row = self.getStateData(authname)
        if row:
            req.args['statedate'] = row[0]
            req.args['comment']   = row[2]
            req.args['state']     = row[3]

        # 全体の登録状態取得
        stateData = self.getAllStateData(dispDays)
        req.args['allstatedata'] = stateData

        # 各個人付与情報
        req.args['customdata'] = self.getAllCustomData(dispDays)

        # 状態を示す種類
        req.args['imageNum'] = range(3)

        # カレンダー出力データ
        now = datetime.now()
        calData = []
        for i in range(-dispDays,1):
            bufCal = (now+timedelta(i))
            # 日付形式(年-月-日),日,曜日
            calItem = [bufCal.strftime("%Y-%m-%d"),bufCal.strftime("%d"),bufCal.strftime("%a")]
            calData.append(calItem)
        req.args['caldata'] = calData
        req.args['dispdays']=dispDays

        req.args['pageTitle'] = 'にこにこ'

        return 'nico.html', None

    # ITemplateProvider methods
    def get_templates_dirs(self):
        from pkg_resources import resource_filename
        return [resource_filename(__name__, 'templates')]

    def get_htdocs_dirs(self):
        from pkg_resources import resource_filename
        return [('hw', resource_filename(__name__, 'htdocs'))]

    # 当日1人分のデータを取得
    def getStateData(self,authname):
        now = datetime.now()
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        cursor.execute('SELECT date,id,comment,state FROM nicostate ' \
                       'WHERE id=%s AND date=%s ',
                       (authname, now.strftime("%Y-%m-%d"), ))
        row = cursor.fetchone()
        #if row == None:
        #    return None
        return row

    # 特定期間のデータを取得
    def getAllStateData(self,datenum):
        now = datetime.now()-timedelta(datenum)
        start = datetime.now()-timedelta(datenum)
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        # メンバー一覧取得
        cursor.execute('SELECT distinct id FROM nicostate WHERE date>=%s ORDER BY id ',(start.strftime("%Y-%m-%d"),))
        resultData = []
        while 1:
            row = cursor.fetchone()
            if row == None:
                break
            resultData.append(self.getAllPersonalData(row[0],datenum))
        return resultData

    # 特定期間の個人のデータを取得
    def getAllPersonalData(self,id,datenum):
        now = datetime.now()
        start = datetime.now()-timedelta(datenum)
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        cursor.execute('SELECT date,id,comment,state FROM nicostate ' \
                       'WHERE id=%s AND date>=%s ORDER BY date ',
                       (id,start.strftime("%Y-%m-%d"), ))
        resultData = []
        while 1:
            row = cursor.fetchone()
            if row == None:
                break
            else:
                resultData.append(row)
        return resultData


    # 担当の未解決チケット数
    def getOwnerTicketCount(self,authname):
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        cursor.execute("select count(*) from ticket where owner=%s and status!='closed' ",
                       (authname, ))
        row = cursor.fetchone()
        return row[0]

    # 関係の未解決チケット数
    def getCcTicketCount(self,authname):
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        cursor.execute("select count(*) from ticket where cc like %s and status!='closed' ",
                       ('%'+authname+'%', ))
        row = cursor.fetchone()
        return row[0]

    def getAllCustomData(self,datenum):
        start = datetime.now()-timedelta(datenum)
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        # メンバー一覧取得
        cursor.execute('SELECT distinct id FROM nicostate WHERE date>=%s ORDER BY id ',(start.strftime("%Y-%m-%d"),))
        resultData = []
        while 1:
            row = cursor.fetchone()
            if row == None:
                break
            data = []
            data.append(self.getOwnerTicketCount(row[0]))
            data.append(self.getCcTicketCount(row[0]))
            data.append(self.getStateCount(row[0],datenum))
            resultData.append(data)
        return resultData

    def getStateCount(self,authname,datenum):
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        start = datetime.now()-timedelta(datenum)
        cursor.execute(" select coalesce(n0.count,0),coalesce(n1.count,0),coalesce(n2.count,0) " \
                        " from (select id from nicostate where date>=%s and id=%s order by id) as n " \
                        " left outer join " \
                        " (select id,count(state) as count from nicostate where state=0 and date>=%s group by id ) as n0 " \
                        " on (n.id = n0.id) " \
                        " left outer join " \
                        " (select id,count(state) as count from nicostate where state=1 and date>=%s group by id ) as n1 " \
                        " on (n.id = n1.id) " \
                        " left outer join " \
                        " (select id,count(state) as count from nicostate where state=2 and date>=%s group by id ) as n2 " \
                        " on (n.id = n2.id) "
                        ,(start.strftime("%Y-%m-%d"),authname,start.strftime("%Y-%m-%d"),start.strftime("%Y-%m-%d"),start.strftime("%Y-%m-%d"),))
        row = cursor.fetchone()
        if row == None:
            row = ("0","0","0")
        return row

##############################################
##############    initial setting     ################
##############################################
    # IEnvironmentSetupParticipant methods
    ienvironment_log = ""
    def environment_created(self):
        pass
    def environment_needs_upgrade(self, db):
        cursor = db.cursor()
        try:
            cursor.execute("SELECT id FROM nicostate WHERE id='1'")
        except :
            db.rollback()
            self.log.debug('NicoNicoCalendar environment_needs_upgrade')
            return True
        return False
    def upgrade_environment(self, db):
        self.log.debug('NicoNicoCalendar upgrade_environment')

        sql = [
"""
CREATE TABLE nicostate ( date VARCHAR(12), id VARCHAR(255), comment VARCHAR(2048), state VARCHAR(5), PRIMARY KEY(date,id) );
""",
        ]
        cursor = db.cursor()
        for s in sql:
            cursor.execute(s)
            self.log.debug('%s' % s)

        #pass
