#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk_imlib.h>

#include "TreeSh.h"
#include "CList.h"
#include "Util.h"
#include "Icon.h"
#include "Type.h"

#define CELL_WIDTH   16
#define CELL_HEIGHT  16
#define THUMB_HEIGHT 48
#define THUMB_WIDTH  48

/*
 * CList: Constructr/Destructor
 */
CList::CList(char* _L) : TshWgt()
{
  C = create(_L);
  T = FALSE;
  setPP(gtk_scrolled_window_new ((GtkAdjustment*)NULL, (GtkAdjustment*)NULL));
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(getPP()), C);
}

/*
 * Public Members
 */
void CList::select(GtkCList* _Cl, gint _R, gint _C, GdkEvent* _E)
{
  RowData* rd;

  if(!(rd = (RowData*)gtk_clist_get_row_data(_Cl, _R))) return;
  if(((GdkEventButton*)_E)->type != 5) return;

  gtk_ctree_select(Tsh->getCt(), rd->getR());
}

void CList::press(GtkWidget* _W, GdkEventButton* _E, CList* _C)
{
  if(_E->button != 2) return;
  _C->thumb();
}

GtkWidget* CList::create(char* _L)
{
  char args[BUFSIZ];

  if(sscanf(_L, "%s", args) < 1) Util::die("Title Configuration Error", "");

  GList* a = g_list_append(NULL, strdup(strtok(args, ",")));
  while(char* tk = strtok(NULL, ",")) g_list_append(a, strdup(tk));

  int   c = g_list_length(a);
  int   cw[c];
  char* t [c],* tmp;

  for(int i=0; i<c; i++) {
    tmp = (char*)g_list_nth_data(a, i);
    t[i] = strtok(tmp, ":");
    if(!strcmp(t[i], "icon")) t[i] = "";
    if(char* tmp2 = strtok(NULL, ":")) cw[i] = atoi(tmp2);
    else cw[i] = 0;
  }

  GtkWidget* C = gtk_clist_new_with_titles(c, t);
  for(int i=0; i<c; i++) 
    if(cw[i] != 0)
      gtk_clist_set_column_width((GtkCList*)C, i, cw[i]);

  for(int i=0; i<c; i++)
    delete [] (char*)g_list_nth_data(a, i);
  g_list_free(a);

  return C;
}

void CList::renew(GList* _L)
{
  int c = g_list_length(_L);
  char* t[c];
  for(int i=0; i<c; i++) t[i] = (char*)g_list_nth_data(_L, i);
  if(C) gtk_widget_destroy(C);
  C = gtk_clist_new_with_titles(c, t);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(getPP()), C);
  gtk_signal_connect (GTK_OBJECT(C), "button_press_event",
		      GTK_SIGNAL_FUNC(CList::press), (gpointer)this);
}

void CList::append(char* _S)
{
  GList* a = g_list_append(NULL, strdup(strtok(_S, ",")));
  while(char* tk = strtok(NULL, ",")) g_list_append(a, strdup(tk));

  int c = g_list_length(a);
  if(c != ((GtkCList*)C)->columns) return;
  char* t[c];

  for(int i=0; i<c; i++) t[i] = (char*)g_list_nth_data(a, i);
  gtk_clist_append ((GtkCList*)C, t);
}

void CList::append(GtkCTreeNode* _R, int _C)
{
  RowData* rd = Tsh->getRd(_R);

  GList* a = rd->getA();
  int n = g_list_length(a);
  if(n != ((GtkCList*)C)->columns) return; // else core ... this code is temp
  char* t[n];
  for(int i=0; i<n; i++) t[i] = (char*)g_list_nth_data(a, i);
  int r = gtk_clist_append ((GtkCList*)C, t);

  if(Icon *i = rd->getIcon())
    gtk_clist_set_pixmap((GtkCList*)C, r, 0, i->getXpm(), i->getBmp());
  gtk_clist_set_row_data (GTK_CLIST(C), r, rd);
}

void CList::justify()
{
  for(int i=0; i<((GtkCList*)C)->columns; i++)
    gtk_clist_set_column_justification((GtkCList*)C, i, GTK_JUSTIFY_RIGHT);
}
void CList::autoResize() { gtk_clist_columns_autosize ((GtkCList*)C); }

void CList::clear()
{
  normalMode();
  gtk_clist_clear ((GtkCList*)C);
}

void CList::setEvents(int _C)
{
  gtk_signal_connect (GTK_OBJECT(C), "select_row",
		      GTK_SIGNAL_FUNC(CList::select), NULL);
  gtk_signal_connect (GTK_OBJECT(C), "button_press_event",
		      GTK_SIGNAL_FUNC(CList::press), (gpointer)this);
}

void CList::thumb()
{
  RowData* rd;

  for(int r=0; r<GTK_CLIST(C)->rows; r++)
    if(rd = (RowData*)gtk_clist_get_row_data (GTK_CLIST(C), r))
      if(char* c = rd->getS(TS_TYPE))
	if(!strcmp(c, "I")){
	  thumbMode();
	  thumbLoad(rd->getR(), r);
	}
}

void CList::thumbLoad(GtkCTreeNode* _R, int _r)
{
  char* f = Util::path("/", _R);

  GdkImlibImage* i = gdk_imlib_load_image(f);
  gdk_imlib_render(i, THUMB_WIDTH, THUMB_HEIGHT);
  GdkBitmap* b = gdk_imlib_copy_mask(i);
  GdkPixmap* p = gdk_imlib_move_image(i);

  gtk_clist_set_pixmap((GtkCList*)C, _r, 0, p, b);

  delete [] f;
  gdk_imlib_destroy_image(i);
  gdk_imlib_free_pixmap(p);
  gdk_imlib_free_bitmap(b);
  f = NULL, i = NULL, b = NULL, p = NULL;
}

void CList::thumbMode()
{
  if(T == FALSE){
    gtk_clist_set_column_width ((GtkCList*)C, 0, THUMB_WIDTH);
    gtk_clist_set_row_height((GtkCList*)C, THUMB_HEIGHT);
    T = TRUE;
  }
}

void CList::normalMode()
{
  if(T == TRUE){
    gtk_clist_set_column_width ((GtkCList*)C, 0, CELL_WIDTH);
    gtk_clist_set_row_height((GtkCList*)C, CELL_HEIGHT);
    T = FALSE;
  }
}

/*
 * CLMgr
 */
CLMgr::CLMgr() : TshWgt()
{
  createFromFile();
  setCurrent(1);
  show();
  for(int i=0; i<3; i++) setEvents(i);
}

/*
 * Public Members
 */
void CLMgr::setCurrent(int _C) { CN = _C; }
int  CLMgr::getCurrent()       { return CN; }
CList* CLMgr::getCL()          { return C[CN]; }

void CLMgr::createFromFile()
{
  if(FILE *fp = Util::getfp(Tsh->getD(), "CList", "Cannot open file")){
    int i = 0;
    char l[BUFSIZ];
    while(fgets(l, BUFSIZ, fp) != NULL){
      if(l[0] == '#') continue;
      C[i] = new CList(l);
      i++;
    }
    fclose(fp);
  }
}

void CLMgr::append(GtkCTreeNode* _R, int _C) { C[CN]->append(_R, _C); }
void CLMgr::append(char* _S)                 { C[0]->append(_S); }
void CLMgr::autoResize()                     { C[0]->autoResize(); }
void CLMgr::clear()                          { C[CN]->clear(); }

void CLMgr::show()
{
  hide();
  C[CN]->show();
}
void CLMgr::hide() { for(int i=0; i<3; i++) C[i]->hide(); }
void CLMgr::setEvents(int _C)   { C[_C]->setEvents(_C); }
GtkWidget* CLMgr::getPP(int _C) { C[_C]->getPP(); }
void CLMgr::renew(GList* _L) { C[0]->renew(_L); }
