// -*- c++ -*- 
/*****************************************************************************
 * class: CList
 *****************************************************************************/
#ifndef CLIST_H
#define CLIST_H

#include <gtk/gtk.h>

#include "TshObj.h"
#include "RowData.h"

class CList : public TshWgt
{
private:
  GtkWidget* C; // CList Widget Ref
  bool T;       // Tumb Flag

public:
  static void select(GtkCList*, gint, gint, GdkEvent*);
  static void press(GtkWidget*, GdkEventButton*, CList*);

public:
  CList(char*);
  ~CList(){};
  GtkWidget* create(char*);
  void renew(GList*);
  void append(GtkCTreeNode*, int);
  void append(char*);
  void clear();
  void justify();
  void autoResize();
  void setEvents(int);
  void thumb();
  void thumbLoad(GtkCTreeNode*, int);
  void thumbMode();
  void normalMode();
};

class CLMgr : public TshWgt
{
private:
  CList* C[3]; // 0.general 1.8 Col 2.2 Col
  int CN;      // Current Number

public:
  CLMgr();
  ~CLMgr(){};
  void renew(GList*);
  void setCurrent(int);
  int  getCurrent();
  CList* getCL();
  void createFromFile();
  void append(GtkCTreeNode*, int);
  void append(char*);
  void autoResize();
  void clear();
  void show();
  void hide();
  void setEvents(int);
  GtkWidget* getPP(int);
};
#endif
