#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "TreeSh.h"
#include "Canvas.h"
#include "Util.h"
#include "CList.h"
#include "Text.h"
#include "Image.h"
#include "Form.h"

/*
 * Canvas: Constructr/Destructor
 */
Canvas::Canvas() : TshWgt()
{
  Cm = new CLMgr();
  T  = new Text();
  I  = new Image();
  F  = new FMgr();
}

/*
 * Public Members
 */
void Canvas::hideAll()
{
  listHide();
  textHide();
  imageHide();
  formHide();
}

/*
 * list
 */
void Canvas::listRenew(GList* _L)
{
  Cm->renew(_L);
  listShow(0);
}

void Canvas::listShow(int _C)
{
  hideAll();
  Cm->setCurrent(_C);
  Cm->clear();
  Cm->show();
}
void Canvas::listAppend(GtkCTreeNode* _R, int _C) { Cm->append(_R, _C); }
void Canvas::listAppend(char* _S)                 { Cm->append(_S); }
void Canvas::listAutoResize()                     { Cm->autoResize(); }
void Canvas::listClear()                          { Cm->clear(); }
void Canvas::listHide()                           { Cm->hide(); }
GtkWidget* Canvas::getPpCm(int _C)                { return(Cm->getPP(_C)); }

/*
 * text
 */
void Canvas::textShow()
{
  hideAll();
  T->show();
}
void Canvas::textHide()           { T->hide(); }
GtkWidget* Canvas::getPpT()       { return(T->getPP()); }
void Canvas::textInsert(char* _S) { T->insert(_S); }
void Canvas::textClear()          { T->clear(); }

/*
 * image
 */
void Canvas::imageShow()
{
  hideAll();
  I->show();
}
void Canvas::imageHide()                 { I->hide(); }
void Canvas::imageLoad(char* _F, int _B) { I->load(_F, _B); }
GtkWidget* Canvas::getPpI()              { return(I->getPP()); }
void Canvas::imageCanvas()
{
  I->setMode(false);
  I->hideRoot();
}
void Canvas::imageFullScreen()           { I->setMode(true); }

/*
 * form
 */
void Canvas::formShow()
{
  hideAll();
  F->show();
}
void Canvas::formHide()                  { F->hide(); }
GtkWidget* Canvas::getPpF()              { return(F->getPP()); }

void Canvas::setForm(Form* _F, bool _B)
{
  formHide();
  F->set(_F);
  if(_B) Tsh->packH(getPpF());
  formShow();
}
