#include <stdio.h>
#include <string.h>

#include "CmdLine.h"
#include "TreeSh.h"
#include "Tree.h"

int  CmdLine::K;

/*
 * CmdLine: Constructr/Destructor
 */
CmdLine::CmdLine() : TshWgt()
{
  E = gtk_entry_new();
  K = 0;
  
  GtkWidget* h = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start (GTK_BOX(h), gtk_label_new("Req:"), FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(h), E, TRUE, TRUE, 0);

  setPP(h);
  show();
  setEvents();
}

void CmdLine::setEvents()
{
  gtk_signal_connect (GTK_OBJECT(E), "key_release_event",
		      GTK_SIGNAL_FUNC(keyRelease), (gpointer)this);
}

/*
 * CmdLine: Public Members
 */
void CmdLine::keyRelease(GtkWidget* _W, GdkEventKey* _E, CmdLine* _C)
{
  char buf[BUFSIZ],* s;
  sprintf(buf, "%s", _C->getStr());

  switch(_E->keyval){
  case 65288: // BS
    if(buf[strlen(buf)-1] == '/') Tsh->T->parent();
    break;
  case 65307: // Esc
    {
      if(char* c = strrchr(buf, '/')) {
	c++;
	if(c) Tsh->T->complete(c);
      }
    }      
    break;
    /**
  case 65293: // Enter
    break;
    **/
  case 47:
    {
      char* c = NULL;
      if(K == 47) c = "/";
      else {
	buf[strlen(buf)-1] = '\0';
	if(c = strrchr(buf, '/')) c++;
      }
      if(c) Tsh->T->find(c);
    }
    break;
  }
  K = _E->keyval;
}

char* CmdLine::getStr()         { return(gtk_entry_get_text(GTK_ENTRY(E))); }
void  CmdLine::setStr(char* _C) { gtk_entry_set_text(GTK_ENTRY(E), _C); }
