#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/dir.h>

#include "Form.h"
#include "Tree.h"
#include "TreeSh.h"
#include "Type.h"
#include "Pop.h"
#include "RowData.h"

/*
 * Call back
 */
void Form::ok(GtkWidget* _W, Form* _F)
{
  _F->apply(_W, _F);
}
void Form::apply(GtkWidget* _W, Form* _F)
{
  if(char* c = _F->getText(0)) {
    _F->setLabel(c);
    _F->resetRd();
  }
}
void Form::cancel(GtkWidget* _W, Form* _F)
{
}

/*
 * Constructor
 */
Form::Form(FILE* _F, Type* _T, Pop* _P) : TshWgt()
{
  init();
  create(_F);
  T = _T;
  P = _P;

  if(B[0] && B[1] && B[2]) setEvents();
}

Form::~Form()
{
  if(L) g_list_free(L);
  init();
}

void Form::init()
{
  T = NULL, L = NULL, P = NULL, R = NULL, Rd = NULL;
  I  = 0;
  Vb = NULL, Tb = NULL;
  for(int i=0; i<3; i++) B[i] = NULL;
}

void Form::setEvents()
{
  gtk_signal_connect (GTK_OBJECT(B[0]), "clicked", GTK_SIGNAL_FUNC(ok),
		      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT(B[1]), "clicked", GTK_SIGNAL_FUNC(apply),
		      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT(B[2]), "clicked", GTK_SIGNAL_FUNC(cancel),
		      (gpointer)this);
}

/*
 * Public Members
 */
GtkWidget* Form::create(FILE* _F)
{
  FILE *fp = _F;
  char l[BUFSIZ];

  Vb = gtk_vbox_new(TRUE, 5);
  setPP(Vb);
  Tb = gtk_table_new (20, 3, TRUE);

  gtk_widget_show_all (Tb);
  gtk_container_add (GTK_CONTAINER (Vb), Tb);

  while(fgets(l, BUFSIZ, fp) != NULL){
    switch(l[0]){
    case '#':
      continue;
    case 'B':
      if(char* s = strchr(l, ':')) createButtons(s);
      continue;
    case 'T':
      if(char* s = strchr(l, ':')) createTitle(s);
      continue;
    case 'E':
      if(char* s = strchr(l, ':')) createEntry(s, FALSE);
      continue;
    case 'P':
      if(char* s = strchr(l, ':')) createEntry(s, TRUE);
      continue;
    }
  }

  gtk_container_set_border_width(GTK_CONTAINER(Vb), 10);
}

void Form::createTitle(char* _L)
{
  attach(gtk_label_new (&_L[1]), 0, 3);
  I++;
}

void Form::createEntry(char* _L, bool _B)
{
  GtkWidget* e;
  
  attach(gtk_label_new(&_L[1]), 0, 1);
  e = gtk_entry_new();
  L = g_list_append(L, e);
  if(_B) gtk_entry_set_visibility(GTK_ENTRY(e), FALSE);
  attach(e, 1, 3);
  I++;
}

void Form::clearEntrys()
{
  for(int i=0; i<g_list_length(L); i++)
    gtk_entry_set_text(GTK_ENTRY(g_list_nth_data(L, i)), "");
}

char* Form::getText(int _i)
{
  if(_i > g_list_length(L)) return NULL;
  if(char* c = gtk_entry_get_text(GTK_ENTRY(g_list_nth_data(L, _i)))) return c;
  return NULL;
}

void Form::setText(int _i, char* _S)
{
  if(_i < g_list_length(L))
    gtk_entry_set_text(GTK_ENTRY(g_list_nth_data(L, _i)), _S);
}

void Form::createButtons(char* _L)
{
  char* s = _L;
  int i = 0;
  s++;
  s[strlen(s)-1] = '\0';
  s = strtok(s, ",");

  I++;
  while(s){
    B[i] = gtk_button_new_with_label(s);
    attach(B[i], i, i+1);
    i++;
    s = strtok(NULL, ",");
    if(i > 2) break;
  }
}

void Form::attach(GtkWidget* _W, int l, int r)
{
  gtk_table_attach_defaults (GTK_TABLE(Tb), _W, l, r, I, I+1);
}

void Form::setRd(GList* _A)
{
  for(int i=1; i<g_list_length(L); i++)
    if(char* s = (char*)g_list_nth_data(_A, i+1)) setText(i, s);
}

void Form::resetRd()
{
  if(GList* a = getRd()) {
    Rd->setA(a);
    Rd->setStatus(true);
    Tsh->T->refresh();
  }
}

GList* Form::getRd()
{
  GList* res = NULL;

  for(int i=1; i<g_list_length(L); i++)
    res = g_list_append(res, strdup(getText(i)));

  return res;
}

void Form::setR(GtkCTreeNode* _R)
{
  R = _R;
  if(RowData* rd = (RowData*)gtk_ctree_node_get_row_data(GTK_CTREE(Tsh->getCt()), R))
    Rd = rd;
}

char* Form::getLabel()
{
  if(!R) return NULL;
  return (GTK_CELL_TEXT (GTK_CTREE_ROW (R)->row.cell[0])->text);
}
void Form::setLabel(char* _S)
{
  //gtk_ctree_node_set_text(Tsh->getCt(), R, 0, _S); // pixmap cleared
  delete [] GTK_CELL_TEXT (GTK_CTREE_ROW (R)->row.cell[0])->text;
  GTK_CELL_TEXT (GTK_CTREE_ROW (R)->row.cell[0])->text = strdup(_S);
  gtk_ctree_node_set_shift(Tsh->getCt(), R, 0, 0, 0);
}

/*
 * FMgr
 */
FMgr::FMgr() : TshWgt() { F = NULL; }

/*
 * Public Members
 */
void FMgr::show() { if(F) F->show(); }  
void FMgr::hide() { if(F) F->hide(); }  
void FMgr::set(Form* _F) { F = _F; }
GtkWidget* FMgr::getPP() { F->getPP(); }
