// -*- c++ -*- 
/*****************************************************************************
 * class: Tree
 *****************************************************************************/
#ifndef TREE_H
#define TREE_H

#include <gtk/gtk.h>

#include "TshObj.h"

enum { TR_NEXT, TR_PREV };

class Type;
class RowData;

class Tree : public TshWgt
{
private:
  static bool A;          // Auto Flg 
  static GtkWidget* C;    // Ctree Widget Root
  static GtkCTreeNode* R; // Set by select()
  void setEvents();

public:
  static void select(GtkCTree*, GtkCTreeNode*, int);
  static void list();
  static void press(GtkWidget*, GdkEventButton*, Tree*);
  static void key(GtkWidget*, GdkEventKey*, Tree*);
  static void remove(GtkCTreeNode*);
  static void clean(GtkCTreeNode*);
  static void refresh();
  static void expand();
  static void next();
  static void prev();
  static void current();
  static void fetch(int);
  static void autoNext(int);
  static void autoPrev(int);
  static void exe();
  static void find(char*);
  static void parent();
  static void unselect();
  static void complete(char*);

public:
  Tree();
  ~Tree(){};
  void init();
  GtkCTreeNode* insert(char*);
  void list(FILE*, int);
  GtkCTree* getCt();
};
#endif
