#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/dir.h>

#include "Type.h"
#include "TreeSh.h"
#include "RowData.h"
#include "Tree.h"
#include "Pop.h"
#include "Form.h"
#include "Util.h"

/*
 * Type: Constructor/Destructor
 */
Type::Type(char* _S) : TshObj(Tsh)
{
  init();
  setS(_S, TS_NAME);
  setS(g_get_current_dir(), TS_PATH);
  setIcon();
  setCmd();
  setMgr();

  //print(); //debug
}
Type::~Type()
{
  for(int i=0; i<4; i++) if(S[i]) delete [] S[i];
  if(P) delete P;
  init();
}
void Type::init()
{
  for(int i=0; i<TS_SIZE; i++) S[i] = NULL;
  I = NULL, P = NULL, F = NULL, Tm = NULL;
}
void  Type::setS(char* _S, int _i) { S[_i] = strdup(_S); }

/*
 * Type: Public Members
 */
char* Type::getS(int _i) { return S[_i]; }
Icon* Type::getIcon()    { return I; }

void Type::setIcon()
{
  char buf[BUFSIZ], * f = "icon";
  int i;
    
  if ((i = readlink(f, buf, BUFSIZ-1)) <= 0) return;

  buf[i] = '\0';
  char* c = strrchr(buf, '/');
  c++;
  I = Tsh->getIcon(strtok(c, "."));
  setS(c, TS_ICN);
}

void Type::setCmd()
{
  char* f = "cmd.sh";
  FILE* fp;

  if(!(fp = fopen(f, "r"))) return;

  char* tk, l[BUFSIZ];

  while(fgets(l, BUFSIZ, fp) != NULL){
    if(l[0] == '#' || l[0] == '\n') continue;
    l[strlen(l)-1] = '\0';
    if(tk = strchr(l, ':')){
      *tk = '\0';
      setS(l, TS_TYPE);
      tk++;
      setS(tk, TS_CMD);
    }else
      setS(l, TS_CMD);
  }

  fclose(fp);
}

void Type::setMgr()
{
  Tm = new TypeMgr(S[TS_PATH]);
}

bool Type::match(char* _S)
{
  if(!strcmp(S[0], _S)) return true;
  return false;
}

Type* Type::lookup(char* _S)
{
  if(Type* t = Tm->lookup(_S)) return t;
  return NULL;
}

bool Type::isForm()
{
  if(F) return true;
  else return false;
}

void Type::newPop()
{
  if(!S[TS_PATH]) return;
  char path[BUFSIZ];
  sprintf(path, "%s/Pop", S[TS_PATH]);

  if(FILE* fp = fopen(path, "r")) {
    P = new Pop(fp, this);
    fclose(fp);
  }
}

void Type::popUp(GdkEventButton* _E)
{
  if(!P) newPop();
  if(P) P->popUp(_E); 
}

void Type::newForm()
{
  if(!S[TS_PATH]) return;
  char path[BUFSIZ];
  sprintf(path, "%s/Form", S[TS_PATH]);

  if(FILE* fp = fopen(path, "r")) {
    F = new Form(fp, this, P);
    fclose(fp);
  }
}

Form* Type::getForm()
{
  if(!F) newForm();
  if(!F) return NULL;
  return F;  
}

// test
void Type::print()
{
  if(S[0]) printf("<%s>\n", S[0]);
  for(int i=1; i<TS_SIZE; i++) if(S[i]) printf(" %s\n", S[i]);
  if(S[0]) printf("</%s>\n", S[0]);
}

/*
 * class TypeMgr
 */
TypeMgr::TypeMgr(char* _D) : TshObj(Tsh)
{
  init();
  create(_D);
}
TypeMgr::~TypeMgr()
{
  for(int i=0; i<g_list_length(Tl); i++)
    delete (Type*) g_list_nth_data(Tl, i);
  g_list_free(Tl);
}

void TypeMgr::typeNew(char* _D)
{
  char* pwd = g_get_current_dir();
  if(chdir(_D)) Util::die("Cannot Change Directory", _D);

  Type* t = new Type(_D);
  Tl = g_list_append(Tl, t);

  chdir(pwd);
}

void TypeMgr::init() { Tl = NULL; }
void TypeMgr::create(char* _D)
{
  DIR* dr;
  struct direct* dt;
  char* s;
  struct stat sb;
  char* pwd = getenv("PWD");
  
  if(!(dr = opendir(_D))) Util::die("Cannot Open Directory", _D);
  if(chdir(_D))           Util::die("Cannot Change Directory", _D);

  while((dt = readdir(dr)) != NULL) {
    if(dt->d_ino == 0 || dt->d_name[0] == '.') continue;
    stat(dt->d_name, &sb);
    switch(sb.st_mode & S_IFMT){
    case S_IFDIR:
      typeNew(dt->d_name);
      break;
    }
  }

  chdir(pwd);
  closedir(dr);
}

Type* TypeMgr::getType(char* _S)
{
  char* r;
  Type* t1,* t2;
  if(!(r = strtok(_S, "."))) return NULL;
  if(!(t1 = lookup(r))) return NULL;

  while(r = strtok(NULL, ".")) {
    if(!(t2 = t1->lookup(r))) break;
    t1 = t2;
  }

  return t1;
}

Type* TypeMgr::lookup(char* _S)
{
  Type* t;

  for(int i=0; i<g_list_length(Tl); i++){
    t = (Type*)g_list_nth_data(Tl, i);
    if(t->match(_S)) return t;
  }

  return NULL;
}
