#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>

#include "Util.h"
#include "RowData.h"
#include "TreeSh.h"
#include "Tree.h"
#include "Canvas.h"
#include "CmdLine.h"
#include "Type.h"

/*
 * Public Members
 */
Util::Util() : TshObj(Tsh) {};

gchar* Util::getRoot(GtkCTreeNode* _R)
{
  GtkCTreeNode* p = GTK_CTREE_ROW(_R)->parent;
  char* c;
  while(p){
    c = GTK_CELL_TEXT (GTK_CTREE_ROW (p)->row.cell[0])->text;
    if(isRoot(c)) return c;
    p = GTK_CTREE_ROW(p)->parent;
  }
}

GList* Util::pathList(GtkCTreeNode* _R, bool _B)
{
  GList* l = NULL;
  if(!_R) return l;

  char* c;
  if(!(c = GTK_CELL_TEXT (GTK_CTREE_ROW (_R)->row.cell[0])->text)) NULL;
  l = g_list_append(l, GTK_CELL_TEXT (GTK_CTREE_ROW (_R)->row.cell[0])->text);
  if(!_B) if(isRoot(c) || isUser(_R)) return l;

  GtkCTreeNode* p = GTK_CTREE_ROW(_R)->parent;
  while(p){
    if(!(c = GTK_CELL_TEXT (GTK_CTREE_ROW (p)->row.cell[0])->text)) break;
    if(!_B) if(isRoot(c) || isUser(p)) break;
    l = g_list_append(l, c);
    p = GTK_CTREE_ROW(p)->parent;
  }

  return l;
}

char* Util::path(char* _S, GtkCTreeNode* _R)
{
  if(!_R) return (gchar*)NULL;
  GList* l;
  if(!(l = pathList(_R, false))) return (strdup(_S));

  char buf[BUFSIZ];
  bzero(buf, BUFSIZ);

  for(int i=g_list_length(l)-1; i>=0; i--){
    strcat(buf, _S);
    strcat(buf, (char*)g_list_nth_data(l, i));
  }
  return (strdup(buf));
}

char* Util::pathFull(char* _S, GtkCTreeNode* _R)
{
  if(!_R) return (gchar*)NULL;
  GList* l;
  if(!(l = pathList(_R, true))) return (strdup(_S));

  char buf[BUFSIZ];
  bzero(buf, BUFSIZ);

  for(int i=g_list_length(l)-1; i>=0; i--){
    strcat(buf, _S);
    strcat(buf, (char*)g_list_nth_data(l, i));
  }
  strcat(buf, _S);
  return (strdup(buf));
}

char* Util::getget(GtkCTreeNode* _R, char _T)
{
  RowData* rd;
  Type* t;

  if(!(rd = (RowData*)gtk_ctree_node_get_row_data(Tsh->getCt(), _R)))
    return NULL;
  if(!(t = rd->getType())) return NULL;

  switch(_T){
  case 'H':
    if(t->match("host"))
      return (GTK_CELL_TEXT (GTK_CTREE_ROW (_R)->row.cell[0])->text);
    break;
  case 'I':
    if(t->match("host")) return (rd->getSA(R_IP));
    break;
  case 'U':
    if(t->match("user"))
      return (GTK_CELL_TEXT (GTK_CTREE_ROW (_R)->row.cell[0])->text);
    break;
  case 'P':
    if(t->match("user")) return (rd->getSA(R_PWD));
    break;
  }

  return NULL;
}

char* Util::get(GtkCTreeNode* _R, char _T)
{
  if(!_R) return (gchar*)NULL;
  if(char* s = getget(_R, _T)) return s;
  
  GtkCTreeNode* p = GTK_CTREE_ROW(_R)->parent;
  while(p){
    if(char* s = getget(p, _T)) return s;
    p = GTK_CTREE_ROW(p)->parent;
  }

  return NULL;
}

bool Util::isRoot(char* _S)
{
  if(_S[strlen(_S)-1] == '/') return true;
  return false;
}

bool Util::isUser(GtkCTreeNode* _R)
{
  if(RowData* rd = (RowData*)gtk_ctree_node_get_row_data(Tsh->getCt(), _R))
    if(Type* t = rd->getType())
      if(t->match("user")) return true;
  
  return false;
}

char* Util::editCmd(char* _C, GtkCTreeNode* _R)
{
  GList* l = pathList(_R, false);
  char c[BUFSIZ], r[BUFSIZ],* tk,* p;

  strcpy(c, _C);
  tk = strtok(c, "%");
  if(tk[-1] == '%') strcat(r, "%%");
  strcpy(r, tk);
  
  while(tk = strtok(NULL, "%")){
    if(tk[-1] == '%') strcat(r, "%%");
    switch(*tk){
    case 'C': // Canvas List Column
      //strcat(r, cols(_R));
      break;
    case 'U': case 'P': case 'H': case 'I':
      if(char* s = get(_R, *tk)) strcat(r, s);
      break;
    case 'F': case 'G':
      if(p = path("/", _R)) {
	if(*tk == 'F') strcat(r, p);
	else if(*tk == 'G') strcat(r, &p[1]);
	delete [] p;
	p = NULL;
      }
      break;
    case 'E':
      if(p = path("/", GTK_CTREE_ROW(_R)->parent)) {
	strcat(r, p);
	delete [] p;
	p = NULL;
      }
      break;
    case 'R':
      if(tk[1] == ' ' || tk[1] == '\n' || tk[1] == '\0'){
	char R[64];
	sprintf(R, "%s", getRoot(_R));
	if(R[strlen(R)-1] == '/') R[strlen(R)-1] = '\0';
	strcat(r, R);
      }
      break;
    case '-':
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
      {
	char buf[256];
	int i = atoi(tk);
	sprintf(buf, "%s", (char*)g_list_nth_data(l, i));
	if(buf[strlen(buf)-1] == '/') buf[strlen(buf)-1] = '\0';
	strcat(r, buf);
	sprintf(buf, "%d", i);
	tk += strlen(buf)-1;
      }
      break;
    }

    tk++;
    strcat(r, tk);
  }

  g_list_free(l);

  return(strdup(r));
}

void Util::exe(RowData* _rd, GtkCTreeNode* _R)
{
  char buf[BUFSIZ],* p = path("/", _R);

  sprintf(buf, "%s %s &", _rd->getS(TS_CMD), p);
  system(buf);
  delete [] p;
  p = NULL;
}

void Util::catTxt(RowData* _rd, GtkCTreeNode* _R)
{
  FILE* pipe;
  char cline[BUFSIZ], pline[BUFSIZ],* p;

  if(!(p = editCmd(_rd->getS(TS_CMD), _R))) return;
  sprintf(cline, p);
  delete [] p;
  p = NULL;

  if((pipe = popen(cline, "r")) == NULL) return;

  Tsh->C->textClear();

  while(fgets(pline, BUFSIZ, pipe) != NULL) Tsh->C->textInsert(pline);

  Tsh->C->textShow();

  pclose(pipe);
}

void Util::treeList(RowData* _rd, GtkCTreeNode* _R, int _N)
{
  FILE* pipe;
  char cline[BUFSIZ],* p;

  if(!(p = editCmd(_rd->getS(TS_CMD), _R))) return;
  sprintf(cline, p);
  delete [] p;
  p = NULL;

  if((pipe = popen(cline, "r")) == NULL) return;

  Tsh->C->listShow(atoi(_rd->getS(TS_TYPE)));
  Tsh->T->list(pipe, _N);
      
  pclose(pipe);
}

void Util::catImage(RowData* _rd, GtkCTreeNode* _R, int _B)
{
  char* p = path("/", _R);
  Tsh->C->imageLoad(p, _B);
  Tsh->C->imageShow();
  delete [] p;
  p = NULL;
}

void Util::canvasList(RowData* _rd, GtkCTreeNode* _R)
{
  Type* t[2];
  FILE* pipe;
  char cline[BUFSIZ], pline[BUFSIZ],* p;

  if(t[0] = _rd->getType()){
    if(!(t[1] = t[0]->lookup("CanvasList"))) return;
    if(!(p = editCmd(t[1]->getS(TS_CMD), _R))) return;
    sprintf(cline, p);
    delete [] p;
    p = NULL;

    if((pipe = popen(cline, "r")) == NULL) return;

    Tsh->C->listClear();
    while(fgets(pline, BUFSIZ, pipe) != NULL) Tsh->C->listAppend(pline);
    Tsh->C->listAutoResize();

    pclose(pipe);
  }
}

void Util::die(char* _S1, char* _S2)
{
  fprintf(stderr, "%s %s ... Exit\n", _S1, _S2);
  exit(1);
}

FILE* Util::getfp(char* _D, char* _F, char* _M)
{
  char path[256];

  sprintf(path, "%s/%s", _D, _F);
  if(FILE *fp = fopen(path, "r")) return fp;
  die(_M, path);
}
