#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Menu.h"
#include "TreeSh.h"
#include "Canvas.h"
#include "Tree.h"
#include "Util.h"

GtkItemFactory* Menu::I;
Func Menu::F[] = {
  {"NULL",  NULL},         {"Quit",    gtk_main_quit},
  {"Text",  Menu::text},   {"Refresh", Menu::refresh}
};

/*
 * Menu: Constructr/Destructor
 */
Menu::Menu() : TshWgt()
{
  A = gtk_accel_group_new();
  I = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", A);
  create();
  gtk_accel_group_attach(A, GTK_OBJECT(Tsh->getW()));
  setPP(gtk_item_factory_get_widget(I, "<main>"));
  show();
}

/*
 * Menu: Public Members
 */
void Menu::create()
{
  if(FILE *fp = Util::getfp(Tsh->getD(), "Menu/Menu", "Cannot open file")){
    char l[BUFSIZ];
    while(fgets(l, BUFSIZ, fp) != NULL){
      if(l[0] == '#') continue;
      l[strlen(l)-1] = '\0';
      createMenu(l);
    }
    fclose(fp);
  }
}
void Menu::createMenu(char* _S)
{
  FILE *fp;
  char l[BUFSIZ], p[256];

  sprintf(p, "%s/Menu/%s", Tsh->getD(), _S);

  if(!(fp = fopen(p, "r"))) Util::die("Cannot open file", p);
  char s[5][64];
  GtkItemFactoryEntry i;
  i.path = s[0];

  while(fgets(l, BUFSIZ, fp) != NULL){
    if(l[0] == '#') continue;
    sscanf(l, "%s %s %s %s %s", s[0], s[1], s[2], s[3], s[4]);
    if(!strcmp(s[1], "NULL")) i.accelerator = NULL;
    else i.accelerator = s[1];
    i.callback = (GtkItemFactoryCallback)getFunc(s[2]);
    i.callback_action = atoi(s[3]);
    if(!strcmp(s[4], "NULL")) i.item_type = NULL;
    else i.item_type = s[4];
    gtk_item_factory_create_item(I, &i, NULL, 2);
  }
  fclose(fp);
}

void* Menu::getFunc(char* _S)
{
  for(int i=0; i<FUNCS; i++) if(!strcmp(F[i].name, _S)) return F[i].func;
  return NULL;
}

void Menu::text()    { Tsh->C->textShow(); }  //test
void Menu::refresh() { Tree::refresh(); }
