#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
//#include <gdk/gdkkeysyms.h>

#include "Tree.h"
#include "TreeSh.h"
#include "Type.h"
#include "RowData.h"
#include "Util.h"
#include "Canvas.h"
#include "Icon.h"
#include "Type.h"
#include "CmdLine.h"

bool          Tree::A;
GtkWidget*    Tree::C;
GtkCTreeNode* Tree::R;
RowData*      Tree::Rd;
GList*        Tree::P;
int           Tree::I;

/*
 * Tree: Callback
 */
void Tree::select(GtkCTree* _Ct, GtkCTreeNode* _R, gint _C)
{
  R = _R;
  if(!_Ct || !R || !(Rd = getRd(R)) || !Rd->check()) return;
  Tsh->Cm->setStr();
  if(!Rd->getStatus() && Rd->edit(0)) return;
  if(child(0)) return;
  cmd(0, NULL);
}

void Tree::press(GtkWidget* _W, GdkEventButton* _E, Tree* _T)
{
  if(!R || !Rd) return;
  switch(_E->button){
  case 2: Rd->popUp(_E); break;
  case 3: Rd->clist();   break; //debug
    //case 3: Rd->print();   break; //debug
    //case 3: rd->edit();  break;  //debug
  }
}

void Tree::key(GtkWidget* _W, GdkEventKey* _E, Tree* _T)
{
  switch(_E->keyval){
  case 65364: if(!A) next();  break; //Down:
  case 65362: if(!A) prev();  break; //Up:
    /**
  case 65366: fetch(TR_NEXT); break; //PageDown:
  case 65365: fetch(TR_PREV); break; //Page_Up
  case 65366: fetch(TR_NEXT, 30); break; //PageDown:
  case 65365: fetch(TR_PREV, 30); break; //Page_Up
    **/
  case 65366: fetch(TR_NEXT, 2); break; //PageDown:
  case 65365: fetch(TR_PREV, 2); break; //Page_Up
  case 65299: A = false;      break; //Pause
  case 65470: //F1
    Tsh->C->imageFullScreen();
    current();
    break;
  case 65307: //Esc
    Tsh->C->imageCanvas();
    current();
    break;
  }
}

void Tree::remove(GtkCTreeNode* _R)
{
  if(RowData* rd = getRd(_R)){
    delete rd;
    rd = NULL;
  }
  gtk_ctree_remove_node(GTK_CTREE(C), _R);
}

void Tree::clean(GtkCTreeNode* _R)
{
  while(GTK_CTREE_ROW(_R)->children){
    if(GTK_CTREE_ROW(GTK_CTREE_ROW(_R)->children)->children)
      clean(GTK_CTREE_ROW(_R)->children);
    remove(GTK_CTREE_ROW(_R)->children);
  }
}

void Tree::refresh()
{
  if(!R) return;
  clean(R);
  cmd(0, NULL);
}

void Tree::expand() { gtk_ctree_expand(GTK_CTREE(C), R); }
void Tree::next()   { gtk_ctree_select(GTK_CTREE(C), GTK_CTREE_NODE_NEXT(R)); }
void Tree::prev()   { gtk_ctree_select(GTK_CTREE(C), GTK_CTREE_NODE_PREV(R)); }
void Tree::current(){ gtk_ctree_select(GTK_CTREE(C), R); }

void Tree::fetch(int _B, int _T)
{
  A = true;
  I = _T;
  void (*func)(int);

  switch(_B){
  case TR_NEXT: func = autoNext; break;
  case TR_PREV: func = autoPrev; break;
  }

  signal(SIGALRM, func);
  alarm(I);
}

void Tree::autoNext(int _S)
{
  next();
  if(A) alarm(I);
}

void Tree::autoPrev(int _S)
{
  prev();
  if(A) alarm(I);
}

bool Tree::exe(int _i)
{
  if(Rd) if(Util::exe(Rd, _i)) return true;
  return false;
}

void Tree::list(int _i) { if(Rd) Util::canvasList(Rd, _i); }
void Tree::edit(int _i) { if(Rd) Rd->edit(_i); }

void Tree::find(char* _S)
{
  GtkCTreeNode* n;

  if(R) n = GTK_CTREE_ROW(R)->children; 
  else  n = gtk_ctree_node_nth(GTK_CTREE(C), 0);

  while(n){
    if(!strcmp(getText(n), _S)){
      //select(GTK_CTREE(C), n, 0);
      gtk_ctree_select(GTK_CTREE(C), n);
      gtk_ctree_expand(GTK_CTREE(C), n);
      return;
    }
    n = GTK_CTREE_ROW(n)->sibling;
  }
}

void Tree::setEvents()
{
  gtk_signal_connect (GTK_OBJECT(C), "tree_select_row",
		      GTK_SIGNAL_FUNC(select), NULL);
  gtk_signal_connect (GTK_OBJECT(C), "button_press_event",
		      GTK_SIGNAL_FUNC(press), (gpointer)this);
  gtk_signal_connect (GTK_OBJECT(C), "key_press_event",
		      GTK_SIGNAL_FUNC(key), (gpointer)this);
}

Tree::Tree() : TshWgt()
{
  C = NULL, R = NULL, Rd = NULL, A = false, I = 1;
  C = gtk_ctree_new (1, 0);

  setPP(gtk_scrolled_window_new ((GtkAdjustment*)NULL, (GtkAdjustment*)NULL));
  gtk_widget_set_usize (getPP(), 300, 600);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(getPP()), C);

  show();
  setEvents();
  init();
}

/*
 * Tree: Public Funcs
 */
void Tree::init()
{
  if(FILE* fp = Util::getfp(Tsh->getD(), "Init", "Cannot open file")){
    char l[BUFSIZ];
    R = NULL;

    while(fgets(l, BUFSIZ, fp) != NULL){
      if(l[0] == '#') continue;
      l[strlen(l)-1] = '\0';
      if(l[0] == '+') insert(strtok(l, "+"));
      else {
	R = NULL;
	R = insert(l);
      }
    }
    fclose(fp);
    R = NULL;
  }
}

GtkCTreeNode* Tree::insert(char* _S)
{
  char* n, buf[BUFSIZ];
  Type* t;
  GdkPixmap* p = NULL;
  GdkBitmap* b = NULL;
  Icon *i = NULL;
  GList* a = NULL;

  sprintf(buf, "%s", _S);
  if(!(n = strtok(_S, " "))) return NULL;
  if(!(t = Tsh->getType(n))) return NULL;
  if(!(i = t->getIcon())) i = Tsh->I->getDefault();
  p = i->getXpm();
  b = i->getBmp();

  n = strtok(buf, " ");
  a = g_list_append(a, strdup(n));
  if(!(n = strtok(NULL, " "))) n = "New";
  a = g_list_append(a, strdup(n));
  GtkCTreeNode* res = gtk_ctree_insert_node(GTK_CTREE(C), R, NULL, &n,
					    3, p, b, p, b, FALSE, TRUE);

  while(n = strtok(NULL, " ")) a = g_list_append(a, strdup(n));
    
  RowData* rd = new RowData(t, res, a);
  gtk_ctree_node_set_row_data(GTK_CTREE(C), res, rd);

  return res;
}

void Tree::list(FILE* _F, int _i)
{
  char line[BUFSIZ];

  switch(_i){
  case 0:
    {
      while(fgets(line, BUFSIZ, _F)) {
	line[strlen(line)-1] = '\0';
	insert(line);
      }
      Tsh->C->clistRenew(R);
    }
    break;
  default:
    while(fgets(line, BUFSIZ, _F)) {
      line[strlen(line)-1] = '\0';
      if(GtkCTreeNode* n = insert(line)) Tsh->C->clistAppend(n);
    }
    break;
  }
}

GtkCTree* Tree::getCt() { return(GTK_CTREE(C)); }
void Tree::setR(GtkCTreeNode* _R) { R = _R; }
GtkCTreeNode* Tree::getR() { return R; }
void Tree::parent()
{
  if(R)
    if(GtkCTreeNode* p =  GTK_CTREE_ROW(R)->parent) {
      gtk_ctree_collapse(GTK_CTREE(C), R);
      gtk_ctree_select(GTK_CTREE(C), p);
    } else unselect();
}

void Tree::unselect()
{
  if(R){
    gtk_ctree_unselect(GTK_CTREE(C), R);
    R = NULL;
  }
}

void Tree::complete(char* _S)
{
  GtkCTreeNode* n,* s;
  int i = 0;
  if(R) n = GTK_CTREE_ROW(R)->children; 
  else  n = gtk_ctree_node_nth(GTK_CTREE(C), 0);

  while(n){
    if(!strncmp(getText(n), _S, strlen(_S))) {
      i++;
      s = n;
    }
    n = GTK_CTREE_ROW(n)->sibling;
  }

  if(i == 1) {
    gtk_ctree_select(GTK_CTREE(C), s); 
    gtk_ctree_expand(GTK_CTREE(C), s);
  }
}

void Tree::go(char* _S)
{
  char buf[BUFSIZ];
  sprintf(buf, "%s", _S);

  find("localhost");
  find("/");

  char* c = strtok(buf, "/");
  GList* l = NULL;

  while(c){
    l = g_list_append(l, c);
    c = strtok(NULL, "/");
  }
  for(int i=0; i<g_list_length(l); i++)
    find((char*)g_list_nth_data(l, i));

  g_list_free(l);
}

RowData* Tree::getRd(GtkCTreeNode* _R)
{
  return((RowData*)gtk_ctree_node_get_row_data(GTK_CTREE(C), _R));
}

char* Tree::getText(GtkCTreeNode* _N)
{
  return(GTK_CELL_TEXT (GTK_CTREE_ROW (_N)->row.cell[0])->text);
}

char* Tree::plus(int _N, int _R)
{
  char* res = NULL;
  if(_R == 0) res = getText(getNths(_N));
  else if(RowData* rd = getRd(getNths(_N))) res = rd->getSA(_R-1);

  return res;
}

char* Tree::minus(int _N, int _R)
{
  char* res = NULL;
  if(_R == 0) res = getText(getNth(_N));
  else if(RowData* rd = getRd(getNth(_N))) res = rd->getSA(_R-1);

  return res;
}

void Tree::pathList()
{
  if(P) g_list_free(P);
  P = NULL;
  P = g_list_append(P, R);
  GtkCTreeNode* p = GTK_CTREE_ROW(R)->parent;

  while(p){
    P = g_list_append(P, p);
    p = GTK_CTREE_ROW(p)->parent;
  }
}

GList* Tree::pathList(int _P)
{
  if(P) g_list_free(P);
  P = NULL;

  P = g_list_append(P, getText(R));
  if(GTK_CTREE_ROW(R)->level <= _P+1) return P;
  GtkCTreeNode* p = GTK_CTREE_ROW(R)->parent;

  while(p){
    P = g_list_append(P, getText(p));
    if(GTK_CTREE_ROW(p)->level <= _P+1) break;
    p = GTK_CTREE_ROW(p)->parent;
  }

  return P;
}

GtkCTreeNode* Tree::getNth(int _N)
{
  pathList();
  if(GtkCTreeNode* n = (GtkCTreeNode*)g_list_nth_data(P, _N)) return n;
  return NULL;
}

GtkCTreeNode* Tree::getNths(int _N)
{
  if(GTK_CTREE_ROW(R)->level == _N+1) return R;
  GtkCTreeNode* p = GTK_CTREE_ROW(R)->parent;

  while(p){
    if(GTK_CTREE_ROW(p)->level == _N+1) return p;
    p = GTK_CTREE_ROW(p)->parent;
  }
  return R;
}

bool Tree::child(int _i)
{
  GtkCTreeNode* s;
  Cmd *cmd; 

  if(!R || !Rd) return false;
  if(!(s = GTK_CTREE_ROW(R)->children)) return false;
  if(cmd = Rd->getCmd(_i)) {
    if(!strcmp(cmd->getS(CD_TYPE),"0"))
      Tsh->C->clistRenew(R);
  } else return false;
  if(Util::clist(Rd)) {
    while(s){
      Tsh->C->clistAppend(s);
      s = GTK_CTREE_ROW(s)->sibling;
    }
  }
  return true;
}

bool Tree::cmd(int _i, GList* _L)
{
  Cmd *cmd; 

  if(!R || !Rd) return false;
  if(!(cmd = Rd->getCmd(_i))) return false;
  if(char* c = cmd->getS(CD_TYPE)) {
    switch(*c){
    case 'A': return(Util::apply(Rd, _i, _L));
    case 'F': return(Util::exe(Rd, _i));
    case 'T': return(Util::catTxt(Rd, _i));
    case 'I': return(Util::catImage(Rd, _i));
    case 'D': return true; // dummy
      //default:  return false; 
    }
  }
  Util::treeList(Rd, _i, _L);
  expand();

  return true;
}
