// -*- c++ -*- 
/*****************************************************************************
 * class Type
 *****************************************************************************/
#ifndef TYPE_H
#define TYPE_H

#include <gtk/gtk.h>

#include "TshObj.h"

class Pop;
class Icon;
class Form;
class TypeMgr;
class CList;

enum { TS_NAME, TS_ICN, TS_PATH, TS_SIZE };
enum { CD_TYPE, CD_STR, CD_SIZE };

class Cmd
{
private:
  char* S[CD_SIZE];

public:
  Cmd(char*, char*);
  ~Cmd();
  void init();
  char* getS(int);
  bool check();

  void print(); //test
};

class Type : public TshObj
{
private:
  char*  S[TS_SIZE]; // 0.Name String 3.Icon String
  void   setS(char*, int);
  GList* C;          // Command List
  Icon*  I;          // Icon Ref
  Pop*   P;          // PopUp Menu New
  Form*  F;          // Form New
  TypeMgr* Tm;       // Next Level Mgr New
  CList* L;          // Canvas List New

public:
  Type(char*);
  ~Type();
  void init();
  bool check();
  char* getS(int);
  void  setCmd();
  Cmd*  getCmd(int);
  void  setIcon();
  Icon* getIcon();
  bool  match(char*);
  void  setMgr();
  Type* lookup(char*);
  void  newPop();
  void  popUp(GdkEventButton*);
  void  newForm();
  Form* getForm();
  bool  isForm();
  void  newCList();
  CList* getCList();
  bool  isCList();

  //test
  void print();
};

/*
 * class TypeMgr
 */
class TypeMgr : public TshObj
{
private:
  GList* Tl;   // Type List

public:
  TypeMgr(char*);
  ~TypeMgr();
  void  init();
  void  create(char*);
  void  typeNew(char*);
  Type* getType(char*);
  Type* lookup(char*);
};
#endif
