// -*- c++ -*- 
/*****************************************************************************
 * class: Tree
 *****************************************************************************/
#ifndef TREE_H
#define TREE_H

#include <gtk/gtk.h>

#include "TshObj.h"

enum { TR_NEXT, TR_PREV };

class Type;
class Cmd;
class RowData;
class Icon;

class Tree : public TshWgt
{
private:
  static bool A;          // Auto Flg 
  static GtkWidget* C;    // Ctree Widget Root
  static GtkCTreeNode* R; // Set by select()
  static GtkCTreeNode* S; // Set by src()
  static RowData* Rd;     // Set by select()
  static GList* P;        // Path List
  static int I;           // alarm interval
  void setEvents();

public:
  static void select(GtkCTree*, GtkCTreeNode*, int);
  static void press(GtkWidget*, GdkEventButton*, Tree*);
  static void key(GtkWidget*, GdkEventKey*, Tree*);
  static void remove(GtkCTreeNode*);
  static void clean(GtkCTreeNode*);
  static void refresh();
  static void expand();
  static void next();
  static void prev();
  static void current();
  static void fetch(int, int);
  //static void fetch(int);
  static void autoNext(int);
  static void autoPrev(int);
  static bool exe(int);
  static void find(char*);
  static void parent();
  static void unselect();
  static void complete(char*);
  static void go(char*);
  static void list(int);
  static void edit(int);
  static RowData* getRd(GtkCTreeNode*);
  static char* getText(GtkCTreeNode*);
  static char* minus(int, int);
  static char* plus(int, int);
  static void pathList(GtkCTreeNode*);
  static GList* pathList(GtkCTreeNode*, int);
  static GtkCTreeNode* getNth(int);
  static GtkCTreeNode* getNths(int);
  static int cmd(int, GList*);
  static void src();
  static void dst(int);
  static bool child(int);
  static void setIcon(GtkCTreeNode*, Icon*, int);
  static void resetIcon();

public:
  Tree();
  ~Tree(){};
  void init();
  GtkCTreeNode* insert(char*);
  void list(FILE*, int);
  GtkCTree* getCt();
  void setR(GtkCTreeNode*); // for CList::thumbLoad() ... no good
  GtkCTreeNode* getR();     // for CList::thumbLoad() ... no good
  GtkCTreeNode* getS();     // for %S
};
#endif
