// -*- c++ -*- 
/*****************************************************************************
 * class: CList
 *****************************************************************************/
#ifndef CLIST_H
#define CLIST_H

#include <gtk/gtk.h>

#include "TshObj.h"
#include "RowData.h"

class CList : public TshWgt
{
private:
  GtkWidget* C; // CList Widget Ref
  bool T;       // Tumb Flag

public:
  static void select(GtkCList*, gint, gint, GdkEvent*);
  static void press(GtkWidget*, GdkEventButton*, CList*);

public:
  CList(char*);
  ~CList(){};
  GtkWidget* create(char*);
  GtkWidget* create(GtkCTreeNode*);
  void renew(GtkCTreeNode*);
  void append(GtkCTreeNode*);
  void append(char*);
  void clear();
  void justify();
  void autoResize();
  void setEvents();
  void thumb();
  void thumbLoad(int);
  void thumbMode();
  void normalMode();
  void pop();
};

class CLMgr : public TshWgt
{
private:
  CList* L;    // Active CList

public:
  CLMgr();
  ~CLMgr(){};

  void renew(GtkCTreeNode*);
  void autoResize();
  void clear();
  void set(CList*);
  GtkWidget* getPp();
  void show();
  void hide();
  void append(GtkCTreeNode*);
  void append(char*);
};
#endif
