#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>

#include "Util.h"
#include "RowData.h"
#include "TreeSh.h"
#include "Tree.h"
#include "Canvas.h"
#include "CmdLine.h"
#include "Type.h"

/*
 * Public Members
 */
Util::Util() : TshObj(Tsh) {};

char* Util::path(GtkCTreeNode* _N, char* _S0, char* _S, int _P, int _M)
{
  GList* l;
  if(!(l = Tsh->T->pathList(_N, _P))) return NULL;

  char buf[BUFSIZ];
  bzero(buf, BUFSIZ);

  if(_S0) strcat(buf, _S0);

  for(int i=g_list_length(l)-1; i>=_M; i--){
    if(i < g_list_length(l)-1) strcat(buf, _S);
    strcat(buf, (char*)g_list_nth_data(l, i));
  }
  return (strdup(buf));
}

char* Util::editCmd(char* _C, GList* _L)
{
  char c[BUFSIZ], r[BUFSIZ],* tk,* p;
  strcpy(c, _C);
  tk = strtok(c, "%");
  if(tk[-1] == '%') strcat(r, "%%");
  strcpy(r, tk);
  
  while(tk = strtok(NULL, "%")){
    if(tk[-1] == '%') strcat(r, "%%");
    switch(*tk){
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
      {
	char buf[256];
	int i = atoi(tk);
	sprintf(buf, "%s", (char*)g_list_nth_data(_L, i));
	if(buf[strlen(buf)-1] == '/') buf[strlen(buf)-1] = '\0';
	strcat(r, buf);
	sprintf(buf, "%d", i);
	tk += strlen(buf)-1;
      }
      break;
    case '+': case '-': case 'P': case 'S':
      {
	char* pre = tk;
	tk++;
	switch(*tk){
	case '0': case '1': case '2': case '3': case '4':
	case '5': case '6': case '7': case '8': case '9':
	  {
	    char buf[2][2], res[256];
	    int i[2];
	    sprintf(buf[0], "%c", tk[0]);
	    sprintf(buf[1], "%c", tk[1]);
	    i[0] = atoi(buf[0]);
	    if(tk[1] == ' ') i[1] = 0;
	    else {
	      i[1] = atoi(buf[1]);
	      tk++;
	    }
	    switch(*pre){
	    case '+':
	      if(char* s = Tsh->T->plus(i[0], i[1])) strcat(r, s); break;
	    case '-':
	      if(char* s = Tsh->T->minus(i[0], i[1])) strcat(r, s); break;
	    case 'P':
	      if(char* s = path(NULL, NULL, "/", i[0], i[1])) {
		strcat(r, s);
		delete [] s;
		s = NULL;
	      }
	      break;
	    case 'S':
	      if(char* s = path(Tsh->T->getS(), NULL, "/", i[0], i[1])) {
		strcat(r, s);
		delete [] s;
		s = NULL;
	      }
	      break;
	    }
	  }
	  break;
	}
      }
      break;
    }

    tk++;
    strcat(r, tk);
  }

  return(strdup(r));
}

int Util::exe(RowData* _rd, int _i)
{
  char buf[BUFSIZ],* p = editCmd("/%P20", NULL);
  Cmd* cmd;

  if(!(cmd = _rd->getCmd(_i))) return false; 

  sprintf(buf, "%s %s &", cmd->getS(CD_STR), p);
  delete [] p;
  p = NULL;

  return (system(buf));
}

int Util::apply(RowData* _rd, int _i, GList* _L)
{
  char buf[BUFSIZ],* p;
  Cmd* cmd;

  if(!(cmd = _rd->getCmd(_i))) return false; 
  if(!(p = editCmd(cmd->getS(CD_STR), _L))) return false;

  sprintf(buf, "%s", p);

  delete [] p;
  p = NULL;

  return (system(buf));
}

bool Util::catTxt(RowData* _rd, int _i)
{
  FILE* pipe;
  char cline[BUFSIZ], pline[BUFSIZ],* p;
  Cmd* cmd;

  if(!(cmd = _rd->getCmd(_i))) return false; 
  if(!(p = editCmd(cmd->getS(CD_STR), NULL))) return false;
  sprintf(cline, p);
  delete [] p;
  p = NULL;

  if((pipe = popen(cline, "r")) == NULL) return false;

  Tsh->C->textClear();

  while(fgets(pline, BUFSIZ, pipe) != NULL) Tsh->C->textInsert(pline);

  Tsh->C->textShow();

  pclose(pipe);

  return true;
}

bool Util::treeList(RowData* _rd, int _i, GList* _L)
{
  FILE* pipe;
  char cline[BUFSIZ],* p;
  Cmd* cmd;

  if(!(cmd = _rd->getCmd(_i))) return false; 
  if(!(p = editCmd(cmd->getS(CD_STR),_L))) return false;

  sprintf(cline, p);
  delete [] p;
  p = NULL;

  if((pipe = popen(cline, "r")) == NULL) return false;
  clist(_rd);
  Tsh->T->list(pipe, atoi(cmd->getS(CD_TYPE)));
      
  pclose(pipe);

  return true;
}

bool Util::catImage(RowData* _rd, int _B)
{
  char* p = editCmd("/%P20", NULL);
  Tsh->C->imageLoad(p, _B);
  Tsh->C->imageShow();
  delete [] p;
  p = NULL;

  return true;
}

bool Util::canvasList(RowData* _rd, int _i)
{
  Type* t[2];
  FILE* pipe;
  char cline[BUFSIZ], pline[BUFSIZ],* p;
  Cmd* cmd;

  if(t[0] = _rd->getType()){
    if(!(t[1] = t[0]->lookup("CanvasList"))) return false;
    if(!(cmd = t[1]->getCmd(_i))) return false;
    if(!(p = editCmd(cmd->getS(CD_STR), NULL))) return false;
    sprintf(cline, p);
    delete [] p;
    p = NULL;

    if((pipe = popen(cline, "r")) == NULL) return false;

    Tsh->C->clistClear();
    while(fgets(pline, BUFSIZ, pipe) != NULL) Tsh->C->clistAppend(pline);
    Tsh->C->clistAutoResize();

    pclose(pipe);
  }

  return true;
}

bool Util::clist(RowData* _Rd)
{
  if(Type* t = _Rd->getType()) {
    bool b = false;
    if(!t->isCList()) {
      b = true;
      t->newCList();
    }
    if(CList* c = t->getCList()) {
      Tsh->C->clistHide();
      Tsh->C->clistSet(c, b);
      Tsh->C->clistClear();
      Tsh->C->clistShow();
      return true;
    } 
  }

  return false;
}

void Util::die(char* _S1, char* _S2)
{
  fprintf(stderr, "%s %s ... Exit\n", _S1, _S2);
  exit(1);
}

FILE* Util::getfp(char* _D, char* _F, char* _M)
{
  char path[256];

  sprintf(path, "%s/%s", _D, _F);
  if(FILE *fp = fopen(path, "r")) return fp;
  die(_M, path);
}
