#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk_imlib.h>

#include "TreeSh.h"
#include "CList.h"
#include "Util.h"
#include "Icon.h"
#include "Type.h"
#include "Tree.h"
#include "Canvas.h"

#define CELL_WIDTH   16
#define CELL_HEIGHT  16
#define THUMB_HEIGHT 48
#define THUMB_WIDTH  48

/*
 * CList: Constructr/Destructor
 */
CList::CList(char* _L) : TshWgt()
{
  C = create(_L);
  T = FALSE;
  Rd = NULL;
  setPP(gtk_scrolled_window_new ((GtkAdjustment*)NULL, (GtkAdjustment*)NULL));
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(getPP()), C);
  setEvents();
}

/*
 * Public Members
 */
void CList::select(GtkCList* _Cl, gint _R, gint _C, GdkEvent* _E, CList* _this)
{
  if(!(_this->Rd = (RowData*)gtk_clist_get_row_data(_Cl, _R))) return;
  if(((GdkEventButton*)_E)->type != 5) return;

  gtk_ctree_select(Tsh->getCt(), _this->Rd->getR());
}

void CList::press(GtkWidget* _W, GdkEventButton* _E, CList* _C)
{
  switch(_E->button){
  case 2:
    if(_C->Rd) _C->Rd->popUp(_E);
    else _C->pop(_E);
    break;
  case 3: _C->thumb(); break;
  }
}

GtkWidget* CList::create(char* _L)
{
  char args[BUFSIZ];

  if(sscanf(_L, "%s", args) < 1) Util::die("Title Configuration Error", "");

  GList* a = g_list_append(NULL, strdup(strtok(args, ",")));
  while(char* tk = strtok(NULL, ",")) g_list_append(a, strdup(tk));

  int   c = g_list_length(a);
  int   cw[c];
  char* t [c],* tmp;

  for(int i=0; i<c; i++) {
    tmp = (char*)g_list_nth_data(a, i);
    t[i] = strtok(tmp, ":");
    if(!strcmp(t[i], "icon")) t[i] = "";
    if(char* tmp2 = strtok(NULL, ":")) cw[i] = atoi(tmp2);
    else cw[i] = 0;
  }

  GtkWidget* C = gtk_clist_new_with_titles(c, t);
  for(int i=0; i<c; i++) 
    if(cw[i] != 0)
      gtk_clist_set_column_width((GtkCList*)C, i, cw[i]);

  for(int i=0; i<c; i++)
    delete [] (char*)g_list_nth_data(a, i);
  g_list_free(a);

  return C;
}

void CList::renew(GtkCTreeNode* _R)
{
  GtkCTreeNode* n = GTK_CTREE_ROW(_R)->children;
  int c = 0;

  while(n){
    c++;
    n = GTK_CTREE_ROW(n)->sibling;
  }

  n = GTK_CTREE_ROW(_R)->children;
  char* t[c];
  c = 0;
  while(n){
    t[c] = Tsh->T->getText(n);
    n = GTK_CTREE_ROW(n)->sibling;
    c++;
  }
  if(C) gtk_widget_destroy(C);
  C = gtk_clist_new_with_titles(c, t);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(getPP()), C);
  gtk_signal_connect (GTK_OBJECT(C), "button_press_event",
		      GTK_SIGNAL_FUNC(CList::press), (gpointer)this);
}

void CList::append(char* _S)
{
  GList* a = g_list_append(NULL, strdup(strtok(_S, ",")));
  while(char* tk = strtok(NULL, ",")) g_list_append(a, strdup(tk));

  int c = g_list_length(a);
  if(c != ((GtkCList*)C)->columns) return;
  char* t[c];

  for(int i=0; i<c; i++) t[i] = (char*)g_list_nth_data(a, i);
  gtk_clist_append ((GtkCList*)C, t);
}

void CList::append(GtkCTreeNode* _R)
{
  RowData* rd = Tsh->getRd(_R);

  GList* a = rd->getA();
  int n = g_list_length(a);
  if(n != ((GtkCList*)C)->columns) return; // else core ... this code is temp
  char* t[n];
  for(int i=0; i<n; i++) t[i] = (char*)g_list_nth_data(a, i);
  int r = gtk_clist_append ((GtkCList*)C, t);

  gtk_clist_set_pixmap((GtkCList*)C, r, 0, GTK_CTREE_ROW(_R)->pixmap_closed,
		       GTK_CTREE_ROW(_R)->mask_closed);
  gtk_clist_set_row_data (GTK_CLIST(C), r, rd);
}

void CList::justify()
{
  for(int i=0; i<((GtkCList*)C)->columns; i++)
    gtk_clist_set_column_justification((GtkCList*)C, i, GTK_JUSTIFY_RIGHT);
}
void CList::autoResize() { gtk_clist_columns_autosize ((GtkCList*)C); }

void CList::clear()
{
  normalMode();
  gtk_clist_clear ((GtkCList*)C);
  Rd = NULL;
}

void CList::setEvents()
{
  gtk_signal_connect (GTK_OBJECT(C), "select_row",
		      GTK_SIGNAL_FUNC(CList::select), this);
  gtk_signal_connect (GTK_OBJECT(C), "button_press_event",
		      GTK_SIGNAL_FUNC(CList::press), (gpointer)this);
}

void CList::thumb()
{
  RowData* rd;
  GtkCTreeNode* r = Tsh->T->getR();

  for(int i=0; i<GTK_CLIST(C)->rows; i++)
    if(rd = (RowData*)gtk_clist_get_row_data (GTK_CLIST(C), i))
      if(Cmd* cmd = rd->getCmd(0))
	if(char* c = cmd->getS(CD_TYPE))
	  if(!strcmp(c, "I")){
	    thumbMode();
	    Tsh->T->setR(rd->getR());
	    thumbLoad(i);
	  }

  Tsh->T->setR(r);  
}

void CList::thumbLoad(int _r)
{
  char* f = Util::editCmd("/%P20", NULL);

  GdkImlibImage* i = gdk_imlib_load_image(f);
  gdk_imlib_render(i, THUMB_WIDTH, THUMB_HEIGHT);
  GdkBitmap* b = gdk_imlib_copy_mask(i);
  GdkPixmap* p = gdk_imlib_move_image(i);

  gtk_clist_set_pixmap((GtkCList*)C, _r, 0, p, b);

  delete [] f;
  gdk_imlib_destroy_image(i);
  gdk_imlib_free_pixmap(p);
  gdk_imlib_free_bitmap(b);
  f = NULL, i = NULL, b = NULL, p = NULL;
}

void CList::thumbMode()
{
  if(T == FALSE){
    gtk_clist_set_column_width ((GtkCList*)C, 0, THUMB_WIDTH);
    gtk_clist_set_row_height((GtkCList*)C, THUMB_HEIGHT);
    T = TRUE;
  }
}

void CList::normalMode()
{
  if(T == TRUE){
    gtk_clist_set_column_width ((GtkCList*)C, 0, CELL_WIDTH);
    gtk_clist_set_row_height((GtkCList*)C, CELL_HEIGHT);
    T = FALSE;
  }
}

void CList::pop(GdkEventButton* _E)
{
  if(!Pm) newPop();
  if(Pm) Pm->popUp(_E);
}

void CList::newPop()
{
  if(!Pm) {
    char path[BUFSIZ];
    sprintf(path, "%s/CListPop", Tsh->getD());

    if(FILE* fp = fopen(path, "r")) {
      Pm = new Pop(fp, NULL);
      fclose(fp);
    }
  }
}

/*
 * CLMgr
 */
CLMgr::CLMgr() : TshWgt()
{
  show();
  L = NULL;
}

/*
 * Public Members
 */
void CLMgr::append(GtkCTreeNode* _R) { L->append(_R); }
void CLMgr::append(char* _S)         { L->append(_S); }
void CLMgr::renew(GtkCTreeNode* _R)
{
  L->renew(_R);
  Tsh->C->clistShow();
}
void CLMgr::autoResize()             { L->autoResize(); }
void CLMgr::clear()                  { L->clear(); }

void CLMgr::set(CList* _L) { L = _L; }
GtkWidget* CLMgr::getPp() { L->getPP(); }
void CLMgr::show() { if(L) L->show(); }  
void CLMgr::hide() { if(L) L->hide(); }  
void CLMgr::thumb(){ if(L) L->thumb(); }  
