// -*- c++ -*- 
/*****************************************************************************
 * class: Tree
 *****************************************************************************/
#ifndef TREE_H
#define TREE_H

#include <gtk/gtk.h>
#include <gdk_imlib.h>

#include "TshObj.h"

enum { TR_NEXT, TR_PREV };

class Type;
class Cmd;
class RowData;
class Icon;

class Tree : public TshWgt
{
private:
  static bool A;              // Auto Flg 
  static int I, Si;           // I:alarm interval Si:src cmd index
  static GList* P;            // Path List
  static GtkWidget* C;        // Ctree Widget Root
  static GtkCTreeNode* R,* S; // R:Set by select() S:Set by src()
  static RowData* Rd;         // Set by select()

  void setEvents();

public:
  static void select(GtkCTree*, GtkCTreeNode*, int);
  static void press(GtkWidget*, GdkEventButton*, Tree*);
  static void key(GtkWidget*, GdkEventKey*, Tree*);
  static void remove(GtkCTreeNode*);
  static void clean(GtkCTreeNode*);
  static void refresh();
  static void expand();
  static void next();
  static void prev();
  static void current();
  static void fetch(int, int);
  //static void fetch(int);
  static void autoNext(int);
  static void autoPrev(int);
  static bool exe(int);
  static void find(char*);
  static void parent();
  static void unselect();
  static void complete(char*);
  static void go(char*);

  static RowData* getRd(GtkCTreeNode*);
  static char* getText(GtkCTreeNode*);

  static char* minus(int, int);
  static char* plus(int, int);
  static void nodeList(GtkCTreeNode*);
  static GList* textList(GtkCTreeNode*, int);
  static GtkCTreeNode* getNthFromBottom(int);
  static GtkCTreeNode* getNthFromTop(int);

  static bool child(int);
  static void setIcon(GtkCTreeNode*, Icon*, int);
  static void resetIcon();
  static void setPix(GtkCTreeNode*, GdkPixmap*, GdkBitmap*);
  static GdkImlibImage* loadImage(GtkCTreeNode*);
  static void copy(GtkCTreeNode*, GtkCTreeNode*);

  static void list(int);
  static void edit(int);
  static int cmd(int, GList*);
  static void src(int);
  static void dst(int);
  static void thumb();

public:
  Tree();
  ~Tree(){};
  void init();
  GtkCTreeNode* insert(char*);
  void list(FILE*, int);
  GtkCTree* getCt();
  void setR(GtkCTreeNode*); // for CList::thumbLoad() ... no good
  GtkCTreeNode* getR();     // for CList::thumbLoad() ... no good
  GtkCTreeNode* getS();     // for %S
};
#endif
