#include "Cursor.h"

#define HIGH (guint16)(255*65535.0)

GdkColormap* Cursor::M;
GdkPixmap* Cursor::X[];

ColorItem Cursor::Cl[] = {
  { "White", 0, HIGH, HIGH, HIGH },
  { "Black", 0, 0, 0, 0 }, 
  { "Red", 0, HIGH, 0, 0 },
  { "Green", 0, 0, HIGH, 0 },
  { "Blue", 0, 0, 0, HIGH },
  { "Cyan", 0, 0, HIGH, HIGH },
  { "Magenta", 0, HIGH, 0, HIGH },
  { "Yellow", 0, HIGH, HIGH, 0 }
};
GdkCursor* Cursor::Cr[];

static unsigned char Src[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xd0,
   0x00, 0x00, 0x00, 0xc8, 0x00, 0x00, 0x00, 0xe4, 0x00, 0x00, 0x00, 0x62,
   0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x80, 0x18, 0x00, 0x00, 0x40, 0x0c,
   0x00, 0x00, 0x40, 0x06, 0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x60, 0x00,
   0x00, 0x00, 0x00, 0x00
};
static unsigned char Msk[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xd0,
   0x00, 0x00, 0x00, 0xc8, 0x00, 0x00, 0x00, 0xe4, 0x00, 0x00, 0x00, 0x62,
   0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x80, 0x18, 0x00, 0x00, 0x40, 0x0c,
   0x00, 0x00, 0x40, 0x06, 0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x60, 0x00,
   0x00, 0x00, 0x00, 0x00
};

/*
 * public Member
 */
void Cursor::init()
{
  M = gdk_colormap_get_system();
  X[0] = gdk_bitmap_create_from_data((GdkWindow*)NULL, (gchar*)Src, 32, 16);
  X[1] = gdk_bitmap_create_from_data((GdkWindow*)NULL, (gchar*)Msk, 32, 16);
  for(int i=0; i<8; i++)
    Cr[i] = gdk_cursor_new_from_pixmap(X[0], X[1], &Cl[i].C, &Cl[i].C, 16, 16);
}

void Cursor::setColor(GdkGC* _G, int _i)
{
  gdk_color_alloc(M, &Cl[_i].C);
  gdk_gc_set_foreground(_G, &Cl[_i].C);
}
void Cursor::setCursor(GdkWindow* _G, int _i)
{
  gdk_window_set_cursor(_G, Cr[_i]);
}
