/* A Bison parser, made by GNU Bison 1.875c.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BLOCK_SYM = 295,
     BOOLEAN_SYM = 296,
     BOOL_SYM = 297,
     BOTH = 298,
     BTREE_SYM = 299,
     BY = 300,
     BYTE_SYM = 301,
     CACHE_SYM = 302,
     CALL_SYM = 303,
     CASCADE = 304,
     CASCADED = 305,
     CAST_SYM = 306,
     CHAIN_SYM = 307,
     CHANGE = 308,
     CHANGED = 309,
     CHARSET = 310,
     CHAR_SYM = 311,
     CHECKSUM_SYM = 312,
     CHECK_SYM = 313,
     CIPHER_SYM = 314,
     CLIENT_SYM = 315,
     CLOSE_SYM = 316,
     COALESCE = 317,
     CODE_SYM = 318,
     COLLATE_SYM = 319,
     COLLATION_SYM = 320,
     COLUMNS = 321,
     COLUMN_SYM = 322,
     COMMENT_SYM = 323,
     COMMITTED_SYM = 324,
     COMMIT_SYM = 325,
     COMPACT_SYM = 326,
     COMPRESSED_SYM = 327,
     CONCAT = 328,
     CONCAT_WS = 329,
     CONCURRENT = 330,
     CONDITION_SYM = 331,
     CONNECTION_SYM = 332,
     CONSISTENT_SYM = 333,
     CONSTRAINT = 334,
     CONTAINS_SYM = 335,
     CONTEXT_SYM = 336,
     CONTINUE_SYM = 337,
     CONVERT_SYM = 338,
     CONVERT_TZ_SYM = 339,
     COUNT_SYM = 340,
     CPU_SYM = 341,
     CREATE = 342,
     CROSS = 343,
     CUBE_SYM = 344,
     CURDATE = 345,
     CURRENT_USER = 346,
     CURSOR_SYM = 347,
     CURTIME = 348,
     DATABASE = 349,
     DATABASES = 350,
     DATA_SYM = 351,
     DATETIME = 352,
     DATE_ADD_INTERVAL = 353,
     DATE_SUB_INTERVAL = 354,
     DATE_SYM = 355,
     DAY_HOUR_SYM = 356,
     DAY_MICROSECOND_SYM = 357,
     DAY_MINUTE_SYM = 358,
     DAY_SECOND_SYM = 359,
     DAY_SYM = 360,
     DEALLOCATE_SYM = 361,
     DECIMAL_NUM = 362,
     DECIMAL_SYM = 363,
     DECLARE_SYM = 364,
     DECODE_SYM = 365,
     DEFAULT = 366,
     DEFINER_SYM = 367,
     DELAYED_SYM = 368,
     DELAY_KEY_WRITE_SYM = 369,
     DELETE_SYM = 370,
     DESC = 371,
     DESCRIBE = 372,
     DES_DECRYPT_SYM = 373,
     DES_ENCRYPT_SYM = 374,
     DES_KEY_FILE = 375,
     DETERMINISTIC_SYM = 376,
     DIRECTORY_SYM = 377,
     DISABLE_SYM = 378,
     DISCARD = 379,
     DISTINCT = 380,
     DIV_SYM = 381,
     DOUBLE_SYM = 382,
     DO_SYM = 383,
     DROP = 384,
     DUAL_SYM = 385,
     DUMPFILE = 386,
     DUPLICATE_SYM = 387,
     DYNAMIC_SYM = 388,
     EACH_SYM = 389,
     ELSEIF_SYM = 390,
     ELT_FUNC = 391,
     ENABLE_SYM = 392,
     ENCLOSED = 393,
     ENCODE_SYM = 394,
     ENCRYPT = 395,
     END = 396,
     ENGINES_SYM = 397,
     ENGINE_SYM = 398,
     ENUM = 399,
     EQ = 400,
     EQUAL_SYM = 401,
     ERRORS = 402,
     ESCAPED = 403,
     ESCAPE_SYM = 404,
     EVENTS_SYM = 405,
     EXECUTE_SYM = 406,
     EXISTS = 407,
     EXIT_SYM = 408,
     EXPANSION_SYM = 409,
     EXPORT_SET = 410,
     EXTENDED_SYM = 411,
     EXTRACT_SYM = 412,
     FALSE_SYM = 413,
     FAST_SYM = 414,
     FAULTS_SYM = 415,
     FETCH_SYM = 416,
     FIELD_FUNC = 417,
     FILE_SYM = 418,
     FIRST_SYM = 419,
     FIXED_SYM = 420,
     FLOAT_NUM = 421,
     FLOAT_SYM = 422,
     FLUSH_SYM = 423,
     FORCE_SYM = 424,
     FOREIGN = 425,
     FORMAT_SYM = 426,
     FOR_SYM = 427,
     FOUND_SYM = 428,
     FRAC_SECOND_SYM = 429,
     FROM = 430,
     FROM_UNIXTIME = 431,
     FULL = 432,
     FULLTEXT_SYM = 433,
     FUNCTION_SYM = 434,
     FUNC_ARG0 = 435,
     FUNC_ARG1 = 436,
     FUNC_ARG2 = 437,
     FUNC_ARG3 = 438,
     GE = 439,
     GEOMCOLLFROMTEXT = 440,
     GEOMETRYCOLLECTION = 441,
     GEOMETRY_SYM = 442,
     GEOMFROMTEXT = 443,
     GEOMFROMWKB = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GREATEST_SYM = 449,
     GROUP = 450,
     GROUP_CONCAT_SYM = 451,
     GROUP_UNIQUE_USERS = 452,
     GT_SYM = 453,
     HANDLER_SYM = 454,
     HASH_SYM = 455,
     HAVING = 456,
     HELP_SYM = 457,
     HEX_NUM = 458,
     HIGH_PRIORITY = 459,
     HOSTS_SYM = 460,
     HOUR_MICROSECOND_SYM = 461,
     HOUR_MINUTE_SYM = 462,
     HOUR_SECOND_SYM = 463,
     HOUR_SYM = 464,
     IDENT = 465,
     IDENTIFIED_SYM = 466,
     IDENT_QUOTED = 467,
     IF = 468,
     IGNORE_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INNER_SYM = 474,
     INNOBASE_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INTERVAL_SYM = 480,
     INTO = 481,
     INT_SYM = 482,
     INVOKER_SYM = 483,
     IN_SYM = 484,
     IO_SYM = 485,
     IPC_SYM = 486,
     IS = 487,
     ISOLATION = 488,
     ISSUER_SYM = 489,
     ITERATE_SYM = 490,
     JOIN_SYM = 491,
     KEYS = 492,
     KEY_SYM = 493,
     KILL_SYM = 494,
     LABEL_SYM = 495,
     LANGUAGE_SYM = 496,
     LAST_INSERT_ID = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAST_SYM = 501,
     LEAVES = 502,
     LEAVE_SYM = 503,
     LEFT = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEFROMTEXT = 509,
     LINES = 510,
     LINESTRING = 511,
     LOAD = 512,
     LOCAL_SYM = 513,
     LOCATE = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGS_SYM = 518,
     LOG_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MAKE_SET_SYM = 527,
     MASTER_CONNECT_RETRY_SYM = 528,
     MASTER_HOST_SYM = 529,
     MASTER_LOG_FILE_SYM = 530,
     MASTER_LOG_POS_SYM = 531,
     MASTER_PASSWORD_SYM = 532,
     MASTER_PORT_SYM = 533,
     MASTER_POS_WAIT = 534,
     MASTER_SERVER_ID_SYM = 535,
     MASTER_SSL_CAPATH_SYM = 536,
     MASTER_SSL_CA_SYM = 537,
     MASTER_SSL_CERT_SYM = 538,
     MASTER_SSL_CIPHER_SYM = 539,
     MASTER_SSL_KEY_SYM = 540,
     MASTER_SSL_SYM = 541,
     MASTER_SYM = 542,
     MASTER_USER_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SYM = 548,
     MAX_UPDATES_PER_HOUR = 549,
     MAX_USER_CONNECTIONS_SYM = 550,
     MEDIUMBLOB = 551,
     MEDIUMINT = 552,
     MEDIUMTEXT = 553,
     MEDIUM_SYM = 554,
     MEMORY_SYM = 555,
     MERGE_SYM = 556,
     MICROSECOND_SYM = 557,
     MIGRATE_SYM = 558,
     MINUTE_MICROSECOND_SYM = 559,
     MINUTE_SECOND_SYM = 560,
     MINUTE_SYM = 561,
     MIN_ROWS = 562,
     MIN_SYM = 563,
     MLINEFROMTEXT = 564,
     MODE_SYM = 565,
     MODIFIES_SYM = 566,
     MODIFY_SYM = 567,
     MOD_SYM = 568,
     MONTH_SYM = 569,
     MPOINTFROMTEXT = 570,
     MPOLYFROMTEXT = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     NAMES_SYM = 576,
     NAME_SYM = 577,
     NATIONAL_SYM = 578,
     NATURAL = 579,
     NCHAR_STRING = 580,
     NCHAR_SYM = 581,
     NDBCLUSTER_SYM = 582,
     NE = 583,
     NEW_SYM = 584,
     NEXT_SYM = 585,
     NONE_SYM = 586,
     NOT2_SYM = 587,
     NOT_SYM = 588,
     NOW_SYM = 589,
     NO_SYM = 590,
     NO_WRITE_TO_BINLOG = 591,
     NULL_SYM = 592,
     NUM = 593,
     NUMERIC_SYM = 594,
     NVARCHAR_SYM = 595,
     OFFSET_SYM = 596,
     OJ_SYM = 597,
     OLD_PASSWORD = 598,
     ON = 599,
     ONE_SHOT_SYM = 600,
     ONE_SYM = 601,
     OPEN_SYM = 602,
     OPTIMIZE = 603,
     OPTION = 604,
     OPTIONALLY = 605,
     OR2_SYM = 606,
     ORDER_SYM = 607,
     OR_OR_SYM = 608,
     OR_SYM = 609,
     OUTER = 610,
     OUTFILE = 611,
     OUT_SYM = 612,
     PACK_KEYS_SYM = 613,
     PAGE_SYM = 614,
     PARTIAL = 615,
     PASSWORD = 616,
     PARAM_MARKER = 617,
     PHASE_SYM = 618,
     POINTFROMTEXT = 619,
     POINT_SYM = 620,
     POLYFROMTEXT = 621,
     POLYGON = 622,
     POSITION_SYM = 623,
     PRECISION = 624,
     PREPARE_SYM = 625,
     PREV_SYM = 626,
     PRIMARY_SYM = 627,
     PRIVILEGES = 628,
     PROCEDURE = 629,
     PROCESS = 630,
     PROCESSLIST_SYM = 631,
     PROFILE_SYM = 632,
     PROFILES_SYM = 633,
     PURGE = 634,
     QUARTER_SYM = 635,
     QUERY_SYM = 636,
     QUICK = 637,
     RAID_0_SYM = 638,
     RAID_CHUNKS = 639,
     RAID_CHUNKSIZE = 640,
     RAID_STRIPED_SYM = 641,
     RAID_TYPE = 642,
     RAND = 643,
     READS_SYM = 644,
     READ_SYM = 645,
     REAL = 646,
     RECOVER_SYM = 647,
     REDUNDANT_SYM = 648,
     REFERENCES = 649,
     REGEXP = 650,
     RELAY_LOG_FILE_SYM = 651,
     RELAY_LOG_POS_SYM = 652,
     RELAY_THREAD = 653,
     RELEASE_SYM = 654,
     RELOAD = 655,
     RENAME = 656,
     REPAIR = 657,
     REPEATABLE_SYM = 658,
     REPEAT_SYM = 659,
     REPLACE = 660,
     REPLICATION = 661,
     REQUIRE_SYM = 662,
     RESET_SYM = 663,
     RESOURCES = 664,
     RESTORE_SYM = 665,
     RESTRICT = 666,
     RESUME_SYM = 667,
     RETURNS_SYM = 668,
     RETURN_SYM = 669,
     REVOKE = 670,
     RIGHT = 671,
     ROLLBACK_SYM = 672,
     ROLLUP_SYM = 673,
     ROUND = 674,
     ROUTINE_SYM = 675,
     ROWS_SYM = 676,
     ROW_COUNT_SYM = 677,
     ROW_FORMAT_SYM = 678,
     ROW_SYM = 679,
     RTREE_SYM = 680,
     SAVEPOINT_SYM = 681,
     SECOND_MICROSECOND_SYM = 682,
     SECOND_SYM = 683,
     SECURITY_SYM = 684,
     SELECT_SYM = 685,
     SENNA_DELIMITED_SYM = 686,
     SENNA_KWIC_SYM = 687,
     SENNA_NGRAM_SYM = 688,
     SENNA_NORMALIZE_SYM = 689,
     SENNA_SECTIONALIZE_SYM = 690,
     SENNA_SPLIT_ALPHA_SYM = 691,
     SENNA_SPLIT_DIGIT_SYM = 692,
     SENNA_SPLIT_SYMBOL_SYM = 693,
     SENNA_SYM = 694,
     SENSITIVE_SYM = 695,
     SEPARATOR_SYM = 696,
     SERIALIZABLE_SYM = 697,
     SERIAL_SYM = 698,
     SESSION_SYM = 699,
     SET = 700,
     SET_VAR = 701,
     SHARE_SYM = 702,
     SHIFT_LEFT = 703,
     SHIFT_RIGHT = 704,
     SHOW = 705,
     SHUTDOWN = 706,
     SIGNED_SYM = 707,
     SIMPLE_SYM = 708,
     SLAVE = 709,
     SMALLINT = 710,
     SNAPSHOT_SYM = 711,
     SOUNDS_SYM = 712,
     SOURCE_SYM = 713,
     SPATIAL_SYM = 714,
     SPECIFIC_SYM = 715,
     SQLEXCEPTION_SYM = 716,
     SQLSTATE_SYM = 717,
     SQLWARNING_SYM = 718,
     SQL_BIG_RESULT = 719,
     SQL_BUFFER_RESULT = 720,
     SQL_CACHE_SYM = 721,
     SQL_CALC_FOUND_ROWS = 722,
     SQL_NO_CACHE_SYM = 723,
     SQL_SMALL_RESULT = 724,
     SQL_SYM = 725,
     SQL_THREAD = 726,
     SSL_SYM = 727,
     STARTING = 728,
     START_SYM = 729,
     STATUS_SYM = 730,
     STD_SYM = 731,
     STDDEV_SAMP_SYM = 732,
     STOP_SYM = 733,
     STORAGE_SYM = 734,
     STRAIGHT_JOIN = 735,
     STRING_SYM = 736,
     SUBDATE_SYM = 737,
     SUBJECT_SYM = 738,
     SUBSTRING = 739,
     SUBSTRING_INDEX = 740,
     SUM_SYM = 741,
     SUPER_SYM = 742,
     SUSPEND_SYM = 743,
     SWAPS_SYM = 744,
     SWITCHES_SYM = 745,
     SYSDATE = 746,
     TABLES = 747,
     TABLESPACE = 748,
     TABLE_SYM = 749,
     TEMPORARY = 750,
     TEMPTABLE_SYM = 751,
     TERMINATED = 752,
     TEXT_STRING = 753,
     TEXT_SYM = 754,
     TIMESTAMP = 755,
     TIMESTAMP_ADD = 756,
     TIMESTAMP_DIFF = 757,
     TIME_SYM = 758,
     TINYBLOB = 759,
     TINYINT = 760,
     TINYTEXT = 761,
     TO_SYM = 762,
     TRAILING = 763,
     TRANSACTION_SYM = 764,
     TRIGGER_SYM = 765,
     TRIGGERS_SYM = 766,
     TRIM = 767,
     TRUE_SYM = 768,
     TRUNCATE_SYM = 769,
     TYPES_SYM = 770,
     TYPE_SYM = 771,
     UDF_RETURNS_SYM = 772,
     UDF_SONAME_SYM = 773,
     ULONGLONG_NUM = 774,
     UNCOMMITTED_SYM = 775,
     UNDEFINED_SYM = 776,
     UNDERSCORE_CHARSET = 777,
     UNDO_SYM = 778,
     UNICODE_SYM = 779,
     UNION_SYM = 780,
     UNIQUE_SYM = 781,
     UNIQUE_USERS = 782,
     UNIX_TIMESTAMP = 783,
     UNKNOWN_SYM = 784,
     UNLOCK_SYM = 785,
     UNSIGNED = 786,
     UNTIL_SYM = 787,
     UPDATE_SYM = 788,
     UPGRADE_SYM = 789,
     USAGE = 790,
     USER = 791,
     USE_FRM = 792,
     USE_SYM = 793,
     USING = 794,
     UTC_DATE_SYM = 795,
     UTC_TIMESTAMP_SYM = 796,
     UTC_TIME_SYM = 797,
     VAR_SAMP_SYM = 798,
     VALUES = 799,
     VALUE_SYM = 800,
     VARBINARY = 801,
     VARCHAR = 802,
     VARIABLES = 803,
     VARIANCE_SYM = 804,
     VARYING = 805,
     VIEW_SYM = 806,
     WARNINGS = 807,
     WEEK_SYM = 808,
     WHEN_SYM = 809,
     WHERE = 810,
     WHILE_SYM = 811,
     WITH = 812,
     WORK_SYM = 813,
     WRITE_SYM = 814,
     X509_SYM = 815,
     XA_SYM = 816,
     XOR = 817,
     YEARWEEK = 818,
     YEAR_MONTH_SYM = 819,
     YEAR_SYM = 820,
     ZEROFILL = 821,
     TABLE_REF_PRIORITY = 822,
     ELSE = 823,
     THEN_SYM = 824,
     CASE_SYM = 825,
     BETWEEN_SYM = 826,
     NEG = 827
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BLOCK_SYM 295
#define BOOLEAN_SYM 296
#define BOOL_SYM 297
#define BOTH 298
#define BTREE_SYM 299
#define BY 300
#define BYTE_SYM 301
#define CACHE_SYM 302
#define CALL_SYM 303
#define CASCADE 304
#define CASCADED 305
#define CAST_SYM 306
#define CHAIN_SYM 307
#define CHANGE 308
#define CHANGED 309
#define CHARSET 310
#define CHAR_SYM 311
#define CHECKSUM_SYM 312
#define CHECK_SYM 313
#define CIPHER_SYM 314
#define CLIENT_SYM 315
#define CLOSE_SYM 316
#define COALESCE 317
#define CODE_SYM 318
#define COLLATE_SYM 319
#define COLLATION_SYM 320
#define COLUMNS 321
#define COLUMN_SYM 322
#define COMMENT_SYM 323
#define COMMITTED_SYM 324
#define COMMIT_SYM 325
#define COMPACT_SYM 326
#define COMPRESSED_SYM 327
#define CONCAT 328
#define CONCAT_WS 329
#define CONCURRENT 330
#define CONDITION_SYM 331
#define CONNECTION_SYM 332
#define CONSISTENT_SYM 333
#define CONSTRAINT 334
#define CONTAINS_SYM 335
#define CONTEXT_SYM 336
#define CONTINUE_SYM 337
#define CONVERT_SYM 338
#define CONVERT_TZ_SYM 339
#define COUNT_SYM 340
#define CPU_SYM 341
#define CREATE 342
#define CROSS 343
#define CUBE_SYM 344
#define CURDATE 345
#define CURRENT_USER 346
#define CURSOR_SYM 347
#define CURTIME 348
#define DATABASE 349
#define DATABASES 350
#define DATA_SYM 351
#define DATETIME 352
#define DATE_ADD_INTERVAL 353
#define DATE_SUB_INTERVAL 354
#define DATE_SYM 355
#define DAY_HOUR_SYM 356
#define DAY_MICROSECOND_SYM 357
#define DAY_MINUTE_SYM 358
#define DAY_SECOND_SYM 359
#define DAY_SYM 360
#define DEALLOCATE_SYM 361
#define DECIMAL_NUM 362
#define DECIMAL_SYM 363
#define DECLARE_SYM 364
#define DECODE_SYM 365
#define DEFAULT 366
#define DEFINER_SYM 367
#define DELAYED_SYM 368
#define DELAY_KEY_WRITE_SYM 369
#define DELETE_SYM 370
#define DESC 371
#define DESCRIBE 372
#define DES_DECRYPT_SYM 373
#define DES_ENCRYPT_SYM 374
#define DES_KEY_FILE 375
#define DETERMINISTIC_SYM 376
#define DIRECTORY_SYM 377
#define DISABLE_SYM 378
#define DISCARD 379
#define DISTINCT 380
#define DIV_SYM 381
#define DOUBLE_SYM 382
#define DO_SYM 383
#define DROP 384
#define DUAL_SYM 385
#define DUMPFILE 386
#define DUPLICATE_SYM 387
#define DYNAMIC_SYM 388
#define EACH_SYM 389
#define ELSEIF_SYM 390
#define ELT_FUNC 391
#define ENABLE_SYM 392
#define ENCLOSED 393
#define ENCODE_SYM 394
#define ENCRYPT 395
#define END 396
#define ENGINES_SYM 397
#define ENGINE_SYM 398
#define ENUM 399
#define EQ 400
#define EQUAL_SYM 401
#define ERRORS 402
#define ESCAPED 403
#define ESCAPE_SYM 404
#define EVENTS_SYM 405
#define EXECUTE_SYM 406
#define EXISTS 407
#define EXIT_SYM 408
#define EXPANSION_SYM 409
#define EXPORT_SET 410
#define EXTENDED_SYM 411
#define EXTRACT_SYM 412
#define FALSE_SYM 413
#define FAST_SYM 414
#define FAULTS_SYM 415
#define FETCH_SYM 416
#define FIELD_FUNC 417
#define FILE_SYM 418
#define FIRST_SYM 419
#define FIXED_SYM 420
#define FLOAT_NUM 421
#define FLOAT_SYM 422
#define FLUSH_SYM 423
#define FORCE_SYM 424
#define FOREIGN 425
#define FORMAT_SYM 426
#define FOR_SYM 427
#define FOUND_SYM 428
#define FRAC_SECOND_SYM 429
#define FROM 430
#define FROM_UNIXTIME 431
#define FULL 432
#define FULLTEXT_SYM 433
#define FUNCTION_SYM 434
#define FUNC_ARG0 435
#define FUNC_ARG1 436
#define FUNC_ARG2 437
#define FUNC_ARG3 438
#define GE 439
#define GEOMCOLLFROMTEXT 440
#define GEOMETRYCOLLECTION 441
#define GEOMETRY_SYM 442
#define GEOMFROMTEXT 443
#define GEOMFROMWKB 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GREATEST_SYM 449
#define GROUP 450
#define GROUP_CONCAT_SYM 451
#define GROUP_UNIQUE_USERS 452
#define GT_SYM 453
#define HANDLER_SYM 454
#define HASH_SYM 455
#define HAVING 456
#define HELP_SYM 457
#define HEX_NUM 458
#define HIGH_PRIORITY 459
#define HOSTS_SYM 460
#define HOUR_MICROSECOND_SYM 461
#define HOUR_MINUTE_SYM 462
#define HOUR_SECOND_SYM 463
#define HOUR_SYM 464
#define IDENT 465
#define IDENTIFIED_SYM 466
#define IDENT_QUOTED 467
#define IF 468
#define IGNORE_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INNER_SYM 474
#define INNOBASE_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INTERVAL_SYM 480
#define INTO 481
#define INT_SYM 482
#define INVOKER_SYM 483
#define IN_SYM 484
#define IO_SYM 485
#define IPC_SYM 486
#define IS 487
#define ISOLATION 488
#define ISSUER_SYM 489
#define ITERATE_SYM 490
#define JOIN_SYM 491
#define KEYS 492
#define KEY_SYM 493
#define KILL_SYM 494
#define LABEL_SYM 495
#define LANGUAGE_SYM 496
#define LAST_INSERT_ID 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAST_SYM 501
#define LEAVES 502
#define LEAVE_SYM 503
#define LEFT 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEFROMTEXT 509
#define LINES 510
#define LINESTRING 511
#define LOAD 512
#define LOCAL_SYM 513
#define LOCATE 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGS_SYM 518
#define LOG_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MAKE_SET_SYM 527
#define MASTER_CONNECT_RETRY_SYM 528
#define MASTER_HOST_SYM 529
#define MASTER_LOG_FILE_SYM 530
#define MASTER_LOG_POS_SYM 531
#define MASTER_PASSWORD_SYM 532
#define MASTER_PORT_SYM 533
#define MASTER_POS_WAIT 534
#define MASTER_SERVER_ID_SYM 535
#define MASTER_SSL_CAPATH_SYM 536
#define MASTER_SSL_CA_SYM 537
#define MASTER_SSL_CERT_SYM 538
#define MASTER_SSL_CIPHER_SYM 539
#define MASTER_SSL_KEY_SYM 540
#define MASTER_SSL_SYM 541
#define MASTER_SYM 542
#define MASTER_USER_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SYM 548
#define MAX_UPDATES_PER_HOUR 549
#define MAX_USER_CONNECTIONS_SYM 550
#define MEDIUMBLOB 551
#define MEDIUMINT 552
#define MEDIUMTEXT 553
#define MEDIUM_SYM 554
#define MEMORY_SYM 555
#define MERGE_SYM 556
#define MICROSECOND_SYM 557
#define MIGRATE_SYM 558
#define MINUTE_MICROSECOND_SYM 559
#define MINUTE_SECOND_SYM 560
#define MINUTE_SYM 561
#define MIN_ROWS 562
#define MIN_SYM 563
#define MLINEFROMTEXT 564
#define MODE_SYM 565
#define MODIFIES_SYM 566
#define MODIFY_SYM 567
#define MOD_SYM 568
#define MONTH_SYM 569
#define MPOINTFROMTEXT 570
#define MPOLYFROMTEXT 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define NAMES_SYM 576
#define NAME_SYM 577
#define NATIONAL_SYM 578
#define NATURAL 579
#define NCHAR_STRING 580
#define NCHAR_SYM 581
#define NDBCLUSTER_SYM 582
#define NE 583
#define NEW_SYM 584
#define NEXT_SYM 585
#define NONE_SYM 586
#define NOT2_SYM 587
#define NOT_SYM 588
#define NOW_SYM 589
#define NO_SYM 590
#define NO_WRITE_TO_BINLOG 591
#define NULL_SYM 592
#define NUM 593
#define NUMERIC_SYM 594
#define NVARCHAR_SYM 595
#define OFFSET_SYM 596
#define OJ_SYM 597
#define OLD_PASSWORD 598
#define ON 599
#define ONE_SHOT_SYM 600
#define ONE_SYM 601
#define OPEN_SYM 602
#define OPTIMIZE 603
#define OPTION 604
#define OPTIONALLY 605
#define OR2_SYM 606
#define ORDER_SYM 607
#define OR_OR_SYM 608
#define OR_SYM 609
#define OUTER 610
#define OUTFILE 611
#define OUT_SYM 612
#define PACK_KEYS_SYM 613
#define PAGE_SYM 614
#define PARTIAL 615
#define PASSWORD 616
#define PARAM_MARKER 617
#define PHASE_SYM 618
#define POINTFROMTEXT 619
#define POINT_SYM 620
#define POLYFROMTEXT 621
#define POLYGON 622
#define POSITION_SYM 623
#define PRECISION 624
#define PREPARE_SYM 625
#define PREV_SYM 626
#define PRIMARY_SYM 627
#define PRIVILEGES 628
#define PROCEDURE 629
#define PROCESS 630
#define PROCESSLIST_SYM 631
#define PROFILE_SYM 632
#define PROFILES_SYM 633
#define PURGE 634
#define QUARTER_SYM 635
#define QUERY_SYM 636
#define QUICK 637
#define RAID_0_SYM 638
#define RAID_CHUNKS 639
#define RAID_CHUNKSIZE 640
#define RAID_STRIPED_SYM 641
#define RAID_TYPE 642
#define RAND 643
#define READS_SYM 644
#define READ_SYM 645
#define REAL 646
#define RECOVER_SYM 647
#define REDUNDANT_SYM 648
#define REFERENCES 649
#define REGEXP 650
#define RELAY_LOG_FILE_SYM 651
#define RELAY_LOG_POS_SYM 652
#define RELAY_THREAD 653
#define RELEASE_SYM 654
#define RELOAD 655
#define RENAME 656
#define REPAIR 657
#define REPEATABLE_SYM 658
#define REPEAT_SYM 659
#define REPLACE 660
#define REPLICATION 661
#define REQUIRE_SYM 662
#define RESET_SYM 663
#define RESOURCES 664
#define RESTORE_SYM 665
#define RESTRICT 666
#define RESUME_SYM 667
#define RETURNS_SYM 668
#define RETURN_SYM 669
#define REVOKE 670
#define RIGHT 671
#define ROLLBACK_SYM 672
#define ROLLUP_SYM 673
#define ROUND 674
#define ROUTINE_SYM 675
#define ROWS_SYM 676
#define ROW_COUNT_SYM 677
#define ROW_FORMAT_SYM 678
#define ROW_SYM 679
#define RTREE_SYM 680
#define SAVEPOINT_SYM 681
#define SECOND_MICROSECOND_SYM 682
#define SECOND_SYM 683
#define SECURITY_SYM 684
#define SELECT_SYM 685
#define SENNA_DELIMITED_SYM 686
#define SENNA_KWIC_SYM 687
#define SENNA_NGRAM_SYM 688
#define SENNA_NORMALIZE_SYM 689
#define SENNA_SECTIONALIZE_SYM 690
#define SENNA_SPLIT_ALPHA_SYM 691
#define SENNA_SPLIT_DIGIT_SYM 692
#define SENNA_SPLIT_SYMBOL_SYM 693
#define SENNA_SYM 694
#define SENSITIVE_SYM 695
#define SEPARATOR_SYM 696
#define SERIALIZABLE_SYM 697
#define SERIAL_SYM 698
#define SESSION_SYM 699
#define SET 700
#define SET_VAR 701
#define SHARE_SYM 702
#define SHIFT_LEFT 703
#define SHIFT_RIGHT 704
#define SHOW 705
#define SHUTDOWN 706
#define SIGNED_SYM 707
#define SIMPLE_SYM 708
#define SLAVE 709
#define SMALLINT 710
#define SNAPSHOT_SYM 711
#define SOUNDS_SYM 712
#define SOURCE_SYM 713
#define SPATIAL_SYM 714
#define SPECIFIC_SYM 715
#define SQLEXCEPTION_SYM 716
#define SQLSTATE_SYM 717
#define SQLWARNING_SYM 718
#define SQL_BIG_RESULT 719
#define SQL_BUFFER_RESULT 720
#define SQL_CACHE_SYM 721
#define SQL_CALC_FOUND_ROWS 722
#define SQL_NO_CACHE_SYM 723
#define SQL_SMALL_RESULT 724
#define SQL_SYM 725
#define SQL_THREAD 726
#define SSL_SYM 727
#define STARTING 728
#define START_SYM 729
#define STATUS_SYM 730
#define STD_SYM 731
#define STDDEV_SAMP_SYM 732
#define STOP_SYM 733
#define STORAGE_SYM 734
#define STRAIGHT_JOIN 735
#define STRING_SYM 736
#define SUBDATE_SYM 737
#define SUBJECT_SYM 738
#define SUBSTRING 739
#define SUBSTRING_INDEX 740
#define SUM_SYM 741
#define SUPER_SYM 742
#define SUSPEND_SYM 743
#define SWAPS_SYM 744
#define SWITCHES_SYM 745
#define SYSDATE 746
#define TABLES 747
#define TABLESPACE 748
#define TABLE_SYM 749
#define TEMPORARY 750
#define TEMPTABLE_SYM 751
#define TERMINATED 752
#define TEXT_STRING 753
#define TEXT_SYM 754
#define TIMESTAMP 755
#define TIMESTAMP_ADD 756
#define TIMESTAMP_DIFF 757
#define TIME_SYM 758
#define TINYBLOB 759
#define TINYINT 760
#define TINYTEXT 761
#define TO_SYM 762
#define TRAILING 763
#define TRANSACTION_SYM 764
#define TRIGGER_SYM 765
#define TRIGGERS_SYM 766
#define TRIM 767
#define TRUE_SYM 768
#define TRUNCATE_SYM 769
#define TYPES_SYM 770
#define TYPE_SYM 771
#define UDF_RETURNS_SYM 772
#define UDF_SONAME_SYM 773
#define ULONGLONG_NUM 774
#define UNCOMMITTED_SYM 775
#define UNDEFINED_SYM 776
#define UNDERSCORE_CHARSET 777
#define UNDO_SYM 778
#define UNICODE_SYM 779
#define UNION_SYM 780
#define UNIQUE_SYM 781
#define UNIQUE_USERS 782
#define UNIX_TIMESTAMP 783
#define UNKNOWN_SYM 784
#define UNLOCK_SYM 785
#define UNSIGNED 786
#define UNTIL_SYM 787
#define UPDATE_SYM 788
#define UPGRADE_SYM 789
#define USAGE 790
#define USER 791
#define USE_FRM 792
#define USE_SYM 793
#define USING 794
#define UTC_DATE_SYM 795
#define UTC_TIMESTAMP_SYM 796
#define UTC_TIME_SYM 797
#define VAR_SAMP_SYM 798
#define VALUES 799
#define VALUE_SYM 800
#define VARBINARY 801
#define VARCHAR 802
#define VARIABLES 803
#define VARIANCE_SYM 804
#define VARYING 805
#define VIEW_SYM 806
#define WARNINGS 807
#define WEEK_SYM 808
#define WHEN_SYM 809
#define WHERE 810
#define WHILE_SYM 811
#define WITH 812
#define WORK_SYM 813
#define WRITE_SYM 814
#define X509_SYM 815
#define XA_SYM 816
#define XOR 817
#define YEARWEEK 818
#define YEAR_MONTH_SYM 819
#define YEAR_SYM 820
#define ZEROFILL 821
#define TABLE_REF_PRIORITY 822
#define ELSE 823
#define THEN_SYM 824
#define CASE_SYM 825
#define BETWEEN_SYM 826
#define NEG 827




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 415 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1667 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 455 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 214 of yacc.c.  */
#line 1682 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  476
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   45023

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  592
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  680
/* YYNRULES -- Number of rules. */
#define YYNRULES  2076
/* YYNRULES -- Number of states. */
#define YYNSTATES  3737

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   827

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   585,     2,     2,     2,   578,   573,     2,
     582,   583,   576,   575,   584,   574,   589,   577,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   591,   590,
       2,     2,     2,     2,   588,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   579,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   586,   572,   587,   580,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   581
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   275,   276,   277,   278,   279,   280,   293,   294,   297,
     298,   301,   304,   307,   310,   313,   317,   321,   323,   325,
     327,   330,   334,   338,   339,   344,   345,   349,   350,   352,
     356,   358,   359,   361,   365,   367,   368,   372,   373,   375,
     379,   381,   386,   387,   389,   391,   393,   394,   398,   401,
     405,   406,   410,   411,   417,   423,   424,   432,   438,   439,
     442,   444,   446,   448,   452,   454,   456,   460,   461,   463,
     465,   467,   469,   472,   474,   476,   480,   481,   484,   485,
     488,   489,   493,   494,   500,   502,   504,   505,   508,   511,
     514,   517,   518,   525,   528,   529,   532,   534,   536,   540,
     541,   542,   543,   551,   552,   555,   558,   560,   562,   563,
     564,   573,   574,   581,   583,   586,   588,   591,   592,   593,
     600,   601,   602,   609,   610,   613,   614,   620,   621,   623,
     624,   630,   635,   636,   637,   646,   647,   655,   657,   659,
     661,   663,   665,   668,   671,   674,   679,   684,   685,   690,
     691,   692,   698,   699,   707,   708,   709,   716,   717,   719,
     720,   722,   724,   727,   729,   731,   732,   734,   736,   739,
     741,   742,   746,   747,   749,   751,   754,   756,   759,   763,
     767,   771,   775,   779,   783,   787,   791,   795,   799,   803,
     807,   811,   815,   819,   823,   827,   833,   835,   837,   841,
     846,   851,   855,   860,   865,   867,   869,   871,   873,   875,
     877,   879,   881,   883,   885,   887,   889,   891,   893,   896,
     897,   899,   901,   903,   905,   907,   909,   913,   915,   917,
     920,   923,   930,   938,   947,   950,   953,   954,   956,   959,
     960,   962,   965,   966,   971,   975,   979,   983,   985,   990,
     992,   994,  1000,  1003,  1009,  1012,  1017,  1019,  1025,  1031,
    1036,  1040,  1042,  1044,  1047,  1049,  1051,  1054,  1056,  1058,
    1060,  1063,  1067,  1070,  1074,  1077,  1080,  1084,  1088,  1092,
    1093,  1100,  1101,  1108,  1111,  1113,  1115,  1117,  1119,  1121,
    1123,  1125,  1127,  1129,  1131,  1133,  1136,  1139,  1141,  1144,
    1146,  1149,  1153,  1156,  1158,  1160,  1162,  1164,  1166,  1168,
    1170,  1173,  1174,  1178,  1180,  1186,  1187,  1189,  1192,  1194,
    1196,  1198,  1200,  1201,  1205,  1206,  1208,  1209,  1211,  1214,
    1216,  1218,  1221,  1224,  1229,  1231,  1235,  1238,  1240,  1243,
    1246,  1249,  1252,  1254,  1257,  1259,  1261,  1263,  1265,  1267,
    1268,  1271,  1273,  1275,  1277,  1279,  1281,  1282,  1285,  1287,
    1289,  1290,  1292,  1293,  1296,  1298,  1301,  1305,  1308,  1309,
    1311,  1312,  1314,  1316,  1319,  1320,  1322,  1323,  1328,  1330,
    1335,  1339,  1341,  1342,  1344,  1347,  1349,  1353,  1357,  1360,
    1363,  1366,  1368,  1370,  1373,  1376,  1379,  1381,  1384,  1387,
    1390,  1393,  1395,  1397,  1398,  1400,  1402,  1404,  1406,  1407,
    1409,  1411,  1413,  1414,  1417,  1420,  1422,  1424,  1426,  1428,
    1430,  1434,  1436,  1439,  1441,  1444,  1446,  1448,  1450,  1452,
    1454,  1456,  1458,  1463,  1466,  1468,  1473,  1474,  1476,  1477,
    1480,  1482,  1486,  1487,  1494,  1495,  1501,  1502,  1508,  1509,
    1515,  1516,  1528,  1529,  1531,  1532,  1535,  1538,  1540,  1544,
    1547,  1551,  1554,  1559,  1560,  1567,  1568,  1569,  1578,  1583,
    1588,  1592,  1596,  1599,  1602,  1609,  1615,  1619,  1625,  1627,
    1629,  1631,  1632,  1634,  1635,  1637,  1638,  1640,  1642,  1643,
    1646,  1648,  1649,  1651,  1653,  1655,  1656,  1662,  1666,  1667,
    1673,  1677,  1681,  1682,  1686,  1687,  1690,  1692,  1696,  1697,
    1699,  1701,  1702,  1705,  1707,  1711,  1712,  1719,  1720,  1727,
    1728,  1734,  1735,  1737,  1739,  1740,  1747,  1748,  1750,  1752,
    1755,  1757,  1759,  1761,  1762,  1769,  1770,  1776,  1777,  1779,
    1781,  1784,  1786,  1788,  1790,  1792,  1794,  1797,  1798,  1805,
    1806,  1808,  1810,  1811,  1816,  1821,  1825,  1831,  1833,  1837,
    1841,  1847,  1849,  1853,  1856,  1858,  1860,  1861,  1868,  1870,
    1874,  1878,  1879,  1882,  1883,  1888,  1889,  1892,  1894,  1897,
    1902,  1905,  1909,  1910,  1914,  1915,  1916,  1923,  1926,  1928,
    1930,  1933,  1936,  1945,  1950,  1951,  1953,  1956,  1958,  1960,
    1962,  1964,  1966,  1968,  1970,  1972,  1974,  1976,  1978,  1979,
    1982,  1987,  1991,  1993,  1995,  2000,  2001,  2002,  2004,  2006,
    2007,  2010,  2013,  2015,  2017,  2018,  2021,  2022,  2026,  2027,
    2031,  2035,  2036,  2040,  2041,  2045,  2048,  2050,  2054,  2059,
    2063,  2068,  2072,  2077,  2079,  2083,  2088,  2092,  2096,  2103,
    2105,  2111,  2118,  2124,  2132,  2139,  2148,  2154,  2161,  2166,
    2171,  2177,  2181,  2186,  2188,  2192,  2194,  2198,  2200,  2204,
    2208,  2210,  2214,  2218,  2223,  2228,  2230,  2234,  2238,  2242,
    2246,  2250,  2252,  2256,  2258,  2260,  2262,  2264,  2266,  2268,
    2270,  2272,  2274,  2276,  2278,  2280,  2282,  2284,  2286,  2288,
    2290,  2293,  2295,  2299,  2301,  2303,  2305,  2307,  2311,  2314,
    2317,  2320,  2323,  2327,  2331,  2337,  2344,  2349,  2354,  2362,
    2367,  2370,  2377,  2383,  2390,  2397,  2402,  2407,  2411,  2416,
    2423,  2432,  2439,  2448,  2455,  2460,  2467,  2472,  2479,  2484,
    2489,  2494,  2499,  2506,  2515,  2518,  2521,  2526,  2529,  2537,
    2545,  2549,  2554,  2559,  2566,  2573,  2578,  2585,  2592,  2599,
    2604,  2611,  2616,  2623,  2632,  2643,  2656,  2663,  2668,  2675,
    2682,  2684,  2691,  2696,  2705,  2716,  2721,  2723,  2727,  2732,
    2739,  2746,  2755,  2762,  2769,  2774,  2781,  2788,  2797,  2802,
    2807,  2814,  2819,  2822,  2827,  2832,  2837,  2844,  2849,  2854,
    2858,  2867,  2874,  2879,  2886,  2890,  2895,  2902,  2911,  2916,
    2925,  2932,  2941,  2948,  2957,  2960,  2965,  2970,  2975,  2982,
    2991,  3000,  3005,  3013,  3021,  3029,  3036,  3043,  3050,  3057,
    3064,  3071,  3072,  3078,  3089,  3093,  3098,  3102,  3105,  3108,
    3111,  3116,  3123,  3128,  3133,  3140,  3147,  3154,  3161,  3166,
    3173,  3178,  3185,  3190,  3195,  3200,  3205,  3212,  3217,  3224,
    3229,  3236,  3241,  3246,  3253,  3258,  3265,  3270,  3277,  3282,
    3287,  3294,  3299,  3306,  3307,  3311,  3315,  3316,  3318,  3319,
    3322,  3324,  3328,  3333,  3338,  3344,  3349,  3354,  3359,  3365,
    3370,  3371,  3372,  3380,  3391,  3396,  3402,  3407,  3413,  3418,
    3423,  3428,  3433,  3438,  3444,  3445,  3454,  3455,  3459,  3463,
    3465,  3470,  3471,  3473,  3474,  3477,  3478,  3480,  3481,  3485,
    3488,  3492,  3495,  3497,  3500,  3502,  3505,  3507,  3509,  3511,
    3514,  3515,  3517,  3518,  3521,  3523,  3527,  3529,  3533,  3534,
    3537,  3539,  3543,  3544,  3546,  3547,  3550,  3555,  3561,  3563,
    3565,  3567,  3569,  3573,  3577,  3581,  3582,  3589,  3590,  3597,
    3598,  3607,  3612,  3613,  3622,  3623,  3634,  3641,  3642,  3651,
    3652,  3663,  3670,  3672,  3675,  3678,  3679,  3684,  3685,  3697,
    3701,  3708,  3709,  3713,  3714,  3715,  3721,  3722,  3724,  3725,
    3727,  3728,  3731,  3732,  3735,  3738,  3741,  3742,  3749,  3750,
    3752,  3756,  3758,  3760,  3762,  3766,  3768,  3770,  3772,  3774,
    3776,  3778,  3780,  3782,  3784,  3786,  3788,  3790,  3792,  3794,
    3796,  3798,  3800,  3802,  3804,  3806,  3808,  3810,  3812,  3814,
    3816,  3818,  3819,  3821,  3823,  3824,  3827,  3828,  3830,  3831,
    3832,  3836,  3837,  3838,  3842,  3845,  3846,  3847,  3852,  3857,
    3860,  3861,  3864,  3867,  3871,  3875,  3877,  3880,  3881,  3883,
    3884,  3889,  3894,  3897,  3898,  3900,  3902,  3903,  3905,  3906,
    3908,  3911,  3913,  3917,  3921,  3923,  3925,  3927,  3929,  3930,
    3933,  3935,  3937,  3939,  3941,  3943,  3945,  3947,  3949,  3951,
    3953,  3955,  3956,  3957,  3964,  3965,  3967,  3971,  3973,  3976,
    3977,  3980,  3984,  3986,  3989,  3991,  3992,  3996,  3997,  4003,
    4006,  4008,  4009,  4013,  4020,  4021,  4028,  4033,  4038,  4043,
    4048,  4054,  4059,  4061,  4065,  4067,  4068,  4071,  4072,  4074,
    4075,  4076,  4085,  4086,  4087,  4094,  4095,  4097,  4099,  4101,
    4103,  4105,  4108,  4110,  4112,  4114,  4118,  4123,  4124,  4128,
    4132,  4134,  4137,  4140,  4141,  4145,  4146,  4152,  4156,  4158,
    4162,  4164,  4168,  4170,  4172,  4173,  4175,  4176,  4181,  4182,
    4184,  4188,  4190,  4192,  4194,  4195,  4196,  4203,  4204,  4205,
    4217,  4221,  4223,  4227,  4231,  4233,  4237,  4238,  4240,  4241,
    4246,  4247,  4254,  4255,  4261,  4262,  4269,  4271,  4275,  4279,
    4285,  4286,  4289,  4290,  4293,  4295,  4297,  4299,  4303,  4304,
    4306,  4307,  4309,  4311,  4315,  4317,  4319,  4322,  4325,  4328,
    4330,  4332,  4334,  4336,  4337,  4341,  4342,  4346,  4349,  4354,
    4359,  4364,  4369,  4370,  4375,  4382,  4399,  4402,  4405,  4406,
    4413,  4419,  4422,  4425,  4428,  4430,  4436,  4442,  4445,  4448,
    4450,  4455,  4459,  4462,  4465,  4468,  4472,  4475,  4478,  4481,
    4483,  4485,  4489,  4494,  4498,  4502,  4505,  4508,  4512,  4516,
    4520,  4524,  4528,  4532,  4537,  4539,  4541,  4543,  4545,  4546,
    4548,  4549,  4552,  4553,  4555,  4557,  4559,  4560,  4563,  4564,
    4567,  4568,  4571,  4574,  4575,  4580,  4581,  4586,  4588,  4590,
    4591,  4593,  4594,  4596,  4598,  4599,  4604,  4608,  4610,  4611,
    4615,  4620,  4623,  4625,  4627,  4629,  4631,  4633,  4635,  4637,
    4639,  4640,  4642,  4643,  4647,  4651,  4653,  4655,  4657,  4660,
    4661,  4665,  4669,  4672,  4675,  4676,  4681,  4682,  4684,  4686,
    4689,  4690,  4695,  4701,  4702,  4703,  4704,  4705,  4724,  4727,
    4728,  4730,  4731,  4733,  4735,  4736,  4738,  4740,  4741,  4744,
    4747,  4749,  4753,  4758,  4762,  4766,  4767,  4770,  4773,  4775,
    4779,  4783,  4784,  4788,  4789,  4793,  4796,  4800,  4802,  4804,
    4807,  4808,  4811,  4813,  4815,  4818,  4821,  4823,  4825,  4827,
    4829,  4831,  4834,  4837,  4839,  4841,  4843,  4845,  4847,  4849,
    4851,  4854,  4857,  4860,  4863,  4866,  4868,  4870,  4872,  4874,
    4876,  4878,  4880,  4884,  4890,  4892,  4894,  4896,  4898,  4900,
    4904,  4909,  4915,  4917,  4923,  4927,  4930,  4932,  4936,  4939,
    4941,  4943,  4945,  4947,  4949,  4951,  4953,  4955,  4957,  4959,
    4961,  4963,  4965,  4967,  4971,  4974,  4976,  4978,  4980,  4982,
    4984,  4986,  4988,  4990,  4992,  4994,  4996,  4998,  5000,  5002,
    5004,  5006,  5008,  5010,  5012,  5014,  5016,  5018,  5020,  5022,
    5024,  5026,  5028,  5030,  5032,  5034,  5036,  5038,  5040,  5042,
    5044,  5046,  5048,  5050,  5052,  5054,  5056,  5058,  5060,  5062,
    5064,  5066,  5068,  5070,  5072,  5074,  5076,  5078,  5080,  5082,
    5084,  5086,  5088,  5090,  5092,  5094,  5096,  5098,  5100,  5102,
    5104,  5106,  5108,  5110,  5112,  5114,  5116,  5118,  5120,  5122,
    5124,  5126,  5128,  5130,  5132,  5134,  5136,  5138,  5140,  5142,
    5144,  5146,  5148,  5150,  5152,  5154,  5156,  5158,  5160,  5162,
    5164,  5166,  5168,  5170,  5172,  5174,  5176,  5178,  5180,  5182,
    5184,  5186,  5188,  5190,  5192,  5194,  5196,  5198,  5200,  5202,
    5204,  5206,  5208,  5210,  5212,  5214,  5216,  5218,  5220,  5222,
    5224,  5226,  5228,  5230,  5232,  5234,  5236,  5238,  5240,  5242,
    5244,  5246,  5248,  5250,  5252,  5254,  5256,  5258,  5260,  5262,
    5264,  5266,  5268,  5270,  5272,  5274,  5276,  5278,  5280,  5282,
    5284,  5286,  5288,  5290,  5292,  5294,  5296,  5298,  5300,  5302,
    5304,  5306,  5308,  5310,  5312,  5314,  5316,  5318,  5320,  5322,
    5324,  5326,  5328,  5330,  5332,  5334,  5336,  5338,  5340,  5342,
    5344,  5346,  5348,  5350,  5352,  5354,  5356,  5358,  5360,  5362,
    5364,  5366,  5368,  5370,  5372,  5374,  5376,  5378,  5380,  5382,
    5384,  5386,  5388,  5390,  5392,  5394,  5396,  5398,  5400,  5402,
    5404,  5406,  5408,  5410,  5412,  5414,  5416,  5418,  5420,  5422,
    5424,  5426,  5428,  5430,  5432,  5434,  5436,  5438,  5440,  5442,
    5444,  5446,  5448,  5450,  5452,  5454,  5456,  5458,  5460,  5462,
    5464,  5466,  5468,  5470,  5472,  5474,  5476,  5478,  5480,  5482,
    5484,  5486,  5488,  5490,  5492,  5494,  5496,  5498,  5500,  5502,
    5504,  5506,  5508,  5509,  5514,  5515,  5517,  5519,  5523,  5524,
    5527,  5529,  5531,  5533,  5535,  5536,  5538,  5539,  5541,  5543,
    5545,  5546,  5549,  5552,  5555,  5557,  5560,  5565,  5571,  5576,
    5583,  5586,  5590,  5594,  5598,  5604,  5606,  5610,  5614,  5617,
    5620,  5623,  5625,  5627,  5632,  5637,  5639,  5641,  5643,  5645,
    5647,  5648,  5653,  5655,  5657,  5659,  5663,  5667,  5669,  5671,
    5674,  5677,  5678,  5682,  5687,  5691,  5692,  5700,  5702,  5705,
    5707,  5709,  5711,  5713,  5715,  5717,  5718,  5724,  5726,  5728,
    5730,  5732,  5734,  5738,  5745,  5752,  5759,  5767,  5771,  5780,
    5789,  5798,  5799,  5801,  5803,  5806,  5807,  5809,  5811,  5815,
    5816,  5820,  5821,  5825,  5826,  5830,  5831,  5835,  5837,  5839,
    5841,  5843,  5845,  5847,  5849,  5851,  5853,  5855,  5857,  5860,
    5863,  5865,  5869,  5872,  5875,  5878,  5881,  5884,  5887,  5890,
    5893,  5894,  5896,  5900,  5902,  5905,  5908,  5911,  5913,  5917,
    5921,  5923,  5925,  5929,  5931,  5935,  5940,  5946,  5948,  5949,
    5953,  5957,  5959,  5961,  5962,  5965,  5968,  5971,  5974,  5975,
    5978,  5981,  5983,  5986,  5989,  5992,  5995,  5998,  5999,  6003,
    6004,  6006,  6007,  6011,  6014,  6015,  6017,  6020,  6021,  6023,
    6028,  6033,  6039,  6042,  6046,  6047,  6049,  6050,  6055,  6056,
    6058,  6060,  6061,  6064,  6067,  6069,  6070,  6072,  6074,  6079,
    6080,  6088,  6090,  6091,  6092,  6095,  6099,  6101,  6103,  6105,
    6106,  6110,  6112,  6115,  6117,  6120,  6124,  6128,  6132,  6133,
    6135,  6136,  6140,  6144,  6145,  6154,  6155,  6159,  6161,  6165,
    6166,  6169,  6173,  6179,  6180,  6184,  6189,  6194,  6195,  6210,
    6211,  6218,  6219,  6220,  6221,  6222,  6235,  6240,  6245,  6249,
    6254,  6258,  6261,  6263,  6267,  6273,  6275,  6277,  6278,  6280,
    6282,  6283,  6286,  6287,  6288,  6292,  6293
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     593,     0,    -1,     3,    -1,   594,     3,    -1,   595,    -1,
    1217,    -1,   795,    -1,   836,    -1,   826,    -1,   630,    -1,
     607,    -1,   838,    -1,   828,    -1,  1223,    -1,   612,    -1,
     596,    -1,  1057,    -1,  1088,    -1,  1013,    -1,  1015,    -1,
     600,    -1,  1094,    -1,  1192,    -1,  1183,    -1,   605,    -1,
    1021,    -1,  1108,    -1,  1112,    -1,  1175,    -1,   843,    -1,
     851,    -1,   855,    -1,   598,    -1,  1104,    -1,  1226,    -1,
     846,    -1,   831,    -1,  1024,    -1,  1100,    -1,   824,    -1,
    1190,    -1,  1224,    -1,  1225,    -1,   863,    -1,  1158,    -1,
    1074,    -1,   813,    -1,   816,    -1,  1068,    -1,  1181,    -1,
    1049,    -1,  1111,    -1,  1264,    -1,   597,   370,  1152,    -1,
     106,    -1,   129,    -1,   370,  1152,   175,   599,    -1,  1149,
      -1,   588,  1154,    -1,    -1,   151,  1152,   601,   602,    -1,
      -1,   539,   603,    -1,   603,   584,   604,    -1,   604,    -1,
     588,  1154,    -1,    -1,   202,   606,  1154,    -1,    -1,    53,
     287,   507,   608,   609,    -1,   610,    -1,   609,   584,   610,
      -1,   274,   145,  1149,    -1,   288,   145,  1149,    -1,   277,
     145,  1149,    -1,   278,   145,   998,    -1,   273,   145,   998,
      -1,   286,   145,   998,    -1,   282,   145,  1149,    -1,   281,
     145,  1149,    -1,   283,   145,  1149,    -1,   284,   145,  1149,
      -1,   285,   145,  1149,    -1,   611,    -1,   275,   145,  1149,
      -1,   276,   145,   999,    -1,   396,   145,  1149,    -1,   397,
     145,   998,    -1,    -1,    87,   710,   494,   713,  1146,   613,
     697,    -1,    -1,    87,   785,   217,  1152,   786,   344,  1146,
     614,   582,   790,   583,    -1,    -1,    87,    94,   713,  1152,
     615,   707,    -1,    -1,    87,   616,  1240,    -1,    87,   536,
     617,  1208,    -1,    -1,  1152,   589,  1152,    -1,  1152,    -1,
     413,   726,   518,  1149,    -1,    -1,    -1,    -1,    -1,    -1,
     582,   620,   635,   583,   621,   413,   622,   737,   623,   626,
     624,   659,    -1,    -1,   625,   627,    -1,    -1,   626,   628,
      -1,    68,  1149,    -1,   241,   470,    -1,   335,   470,    -1,
      80,   470,    -1,   389,   470,    96,    -1,   311,   470,    96,
      -1,   629,    -1,   627,    -1,   121,    -1,   902,   121,    -1,
     470,   429,   112,    -1,   470,   429,   228,    -1,    -1,    48,
     618,   631,   632,    -1,    -1,   582,   633,   583,    -1,    -1,
     634,    -1,   634,   584,   884,    -1,   884,    -1,    -1,   636,
      -1,   636,   584,   638,    -1,   638,    -1,    -1,  1152,   637,
     737,    -1,    -1,   640,    -1,   640,   584,   641,    -1,   641,
      -1,   642,   637,  1152,   737,    -1,    -1,   229,    -1,   357,
      -1,   221,    -1,    -1,   643,   659,   590,    -1,   659,   590,
      -1,   644,   659,   590,    -1,    -1,   645,   646,   590,    -1,
      -1,   109,   657,   647,   737,   658,    -1,   109,  1152,    76,
     172,   654,    -1,    -1,   109,   651,   199,   172,   648,   652,
     659,    -1,   109,  1152,    92,   172,   649,    -1,    -1,   650,
     595,    -1,   153,    -1,    82,    -1,   653,    -1,   652,   584,
     653,    -1,   656,    -1,   998,    -1,   462,   655,  1150,    -1,
      -1,   545,    -1,   654,    -1,  1152,    -1,   463,    -1,   902,
     173,    -1,   461,    -1,  1152,    -1,   657,   584,  1152,    -1,
      -1,   111,   884,    -1,    -1,   660,   595,    -1,    -1,   414,
     661,   884,    -1,    -1,   213,   662,   667,   141,   213,    -1,
     672,    -1,   687,    -1,    -1,   663,   690,    -1,   248,  1153,
      -1,   235,  1153,    -1,   347,  1152,    -1,    -1,   161,   665,
    1152,   226,   664,   666,    -1,    61,  1152,    -1,    -1,   330,
     175,    -1,   175,    -1,  1152,    -1,   666,   584,  1152,    -1,
      -1,    -1,    -1,   668,   884,   569,   669,   644,   670,   671,
      -1,    -1,   135,   667,    -1,   568,   644,    -1,   673,    -1,
     676,    -1,    -1,    -1,   570,   674,   884,   675,   678,   686,
     141,   570,    -1,    -1,   570,   677,   679,   686,   141,   570,
      -1,   680,    -1,   678,   680,    -1,   683,    -1,   679,   683,
      -1,    -1,    -1,   554,   681,   884,   682,   569,   644,    -1,
      -1,    -1,   554,   684,   884,   685,   569,   644,    -1,    -1,
     568,   644,    -1,    -1,  1153,   591,   688,   690,   689,    -1,
      -1,  1153,    -1,    -1,    28,   691,   645,   643,   141,    -1,
     269,   644,   141,   269,    -1,    -1,    -1,   556,   692,   884,
     128,   693,   644,   141,   556,    -1,    -1,   404,   644,   532,
     694,   884,   141,   404,    -1,    27,    -1,     8,    -1,   223,
      -1,   533,    -1,   115,    -1,   582,   698,    -1,   714,   700,
      -1,   252,  1146,    -1,   582,   252,  1146,   583,    -1,   727,
     583,   714,   700,    -1,    -1,   703,   583,   699,  1230,    -1,
      -1,    -1,  1121,   706,   703,   701,  1227,    -1,    -1,  1121,
     706,   582,   703,   583,   702,  1230,    -1,    -1,    -1,   430,
     704,   873,   877,   705,   724,    -1,    -1,    18,    -1,    -1,
     708,    -1,   709,    -1,   708,   709,    -1,   719,    -1,   718,
      -1,    -1,   711,    -1,   712,    -1,   712,   711,    -1,   495,
      -1,    -1,   213,   902,   152,    -1,    -1,   716,    -1,   717,
      -1,   717,   715,    -1,   717,    -1,   717,   716,    -1,   717,
     584,   716,    -1,   143,  1041,   720,    -1,   516,  1041,   720,
      -1,   292,  1041,   999,    -1,   307,  1041,   999,    -1,    24,
    1041,   998,    -1,   361,  1041,  1149,    -1,    68,  1041,  1149,
      -1,    23,  1041,   999,    -1,   358,  1041,   998,    -1,   358,
    1041,   111,    -1,    57,  1041,   998,    -1,   114,  1041,   998,
      -1,   423,  1041,   721,    -1,   387,  1041,   722,    -1,   384,
    1041,   998,    -1,   385,  1041,   998,    -1,   525,  1041,   582,
    1017,   583,    -1,   718,    -1,   719,    -1,   224,  1041,   723,
      -1,    96,   122,  1041,  1149,    -1,   217,   122,  1041,  1149,
      -1,    77,  1041,  1149,    -1,   767,   758,  1041,   760,    -1,
     767,    64,  1041,   766,    -1,  1154,    -1,   111,    -1,   165,
      -1,   133,    -1,    72,    -1,   393,    -1,    71,    -1,   386,
      -1,   383,    -1,   998,    -1,   335,    -1,   164,    -1,   243,
      -1,   993,    -1,   872,   876,    -1,    -1,    10,    -1,   481,
      -1,   391,    -1,   108,    -1,   227,    -1,   728,    -1,   727,
     584,   728,    -1,   729,    -1,   730,    -1,   735,   731,    -1,
     735,   772,    -1,   780,   792,   786,   582,   790,   583,    -1,
     733,   781,   792,   786,   582,   790,   583,    -1,   733,   170,
     238,   792,   582,   790,   583,   772,    -1,   734,   731,    -1,
     733,   732,    -1,    -1,   732,    -1,    58,   884,    -1,    -1,
     734,    -1,    79,   792,    -1,    -1,  1145,   736,   737,   754,
      -1,   745,   752,   749,    -1,   746,   753,   749,    -1,   167,
     747,   749,    -1,    37,    -1,    37,   582,   338,   583,    -1,
      42,    -1,    41,    -1,   741,   582,   338,   583,   768,    -1,
     741,   768,    -1,   742,   582,   338,   583,   769,    -1,   742,
     769,    -1,    32,   582,   338,   583,    -1,    32,    -1,   743,
     582,   338,   583,   768,    -1,   744,   582,   338,   583,   769,
      -1,   546,   582,   338,   583,    -1,   565,   752,   749,    -1,
     100,    -1,   503,    -1,   500,   752,    -1,    97,    -1,   504,
      -1,    39,   752,    -1,   740,    -1,   296,    -1,   265,    -1,
     268,   546,    -1,   268,   743,   768,    -1,   506,   768,    -1,
     499,   752,   768,    -1,   298,   768,    -1,   266,   768,    -1,
     108,   747,   749,    -1,   339,   747,   749,    -1,   165,   747,
     749,    -1,    -1,   144,   738,   582,   794,   583,   768,    -1,
      -1,   445,   739,   582,   794,   583,   768,    -1,   268,   768,
      -1,   443,    -1,   187,    -1,   186,    -1,   365,    -1,   318,
      -1,   256,    -1,   317,    -1,   367,    -1,   319,    -1,    56,
      -1,   326,    -1,   323,    56,    -1,   741,   550,    -1,   547,
      -1,   323,   547,    -1,   340,    -1,   326,   547,    -1,   323,
      56,   550,    -1,   326,   550,    -1,   227,    -1,   505,    -1,
     455,    -1,   297,    -1,    31,    -1,   391,    -1,   127,    -1,
     127,   369,    -1,    -1,   582,   338,   583,    -1,   748,    -1,
     582,   338,   584,   338,   583,    -1,    -1,   750,    -1,   750,
     751,    -1,   751,    -1,   452,    -1,   531,    -1,   566,    -1,
      -1,   582,   338,   583,    -1,    -1,   748,    -1,    -1,   755,
      -1,   755,   756,    -1,   756,    -1,   337,    -1,   902,   337,
      -1,   111,   757,    -1,   344,   533,   334,   883,    -1,    23,
      -1,   443,   111,   545,    -1,   771,   238,    -1,   526,    -1,
     526,   238,    -1,    68,  1149,    -1,    64,   764,    -1,   334,
     883,    -1,  1136,    -1,    56,   445,    -1,    55,    -1,  1154,
      -1,    32,    -1,   759,    -1,   111,    -1,    -1,   758,   760,
      -1,  1154,    -1,    32,    -1,   762,    -1,   111,    -1,  1154,
      -1,    -1,    64,   766,    -1,   764,    -1,   111,    -1,    -1,
     111,    -1,    -1,    20,   769,    -1,    46,    -1,   524,   769,
      -1,   758,   759,   769,    -1,    32,   770,    -1,    -1,    32,
      -1,    -1,    20,    -1,   524,    -1,   758,   759,    -1,    -1,
     372,    -1,    -1,   394,  1146,   773,   774,    -1,   776,    -1,
     582,   775,   583,   776,    -1,   775,   584,  1152,    -1,  1152,
      -1,    -1,   777,    -1,   777,   778,    -1,   778,    -1,   344,
     115,   779,    -1,   344,   533,   779,    -1,   289,   177,    -1,
     289,   360,    -1,   289,   453,    -1,   411,    -1,    49,    -1,
     445,   337,    -1,   335,     5,    -1,   445,   111,    -1,   782,
      -1,   178,   783,    -1,   459,   783,    -1,   372,   238,    -1,
     526,   783,    -1,   238,    -1,   217,    -1,    -1,   782,    -1,
     237,    -1,   217,    -1,   216,    -1,    -1,   526,    -1,   178,
      -1,   459,    -1,    -1,   539,   787,    -1,   516,   787,    -1,
      44,    -1,   425,    -1,   200,    -1,   788,    -1,   789,    -1,
     789,   584,   788,    -1,   439,    -1,   335,   439,    -1,   434,
      -1,   335,   434,    -1,   436,    -1,   437,    -1,   438,    -1,
     431,    -1,   433,    -1,   435,    -1,   998,    -1,   790,   584,
     791,   991,    -1,   791,   991,    -1,  1152,    -1,  1152,   582,
     338,   583,    -1,    -1,  1145,    -1,    -1,   589,  1152,    -1,
    1134,    -1,   794,   584,  1134,    -1,    -1,    13,   809,   494,
    1146,   796,   802,    -1,    -1,    13,    94,   801,   797,   707,
      -1,    -1,    13,   374,   618,   798,   625,    -1,    -1,    13,
     179,   618,   799,   625,    -1,    -1,    13,  1246,  1242,  1247,
     551,  1146,   800,  1250,    18,  1252,  1255,    -1,    -1,  1152,
      -1,    -1,   124,   493,    -1,   215,   493,    -1,   804,    -1,
     802,   584,   804,    -1,     6,   808,    -1,   803,   729,   811,
      -1,     6,   730,    -1,   803,   582,   727,   583,    -1,    -1,
      53,   808,  1145,   805,   735,   811,    -1,    -1,    -1,   312,
     808,  1145,   806,   737,   754,   807,   811,    -1,   129,   808,
    1145,   810,    -1,   129,   170,   238,   792,    -1,   129,   372,
     238,    -1,   129,   782,  1145,    -1,   123,   237,    -1,   137,
     237,    -1,    13,   808,  1145,   445,   111,  1136,    -1,    13,
     808,  1145,   129,   111,    -1,   401,   812,  1146,    -1,    83,
     507,   758,   760,   765,    -1,   715,    -1,   169,    -1,   984,
      -1,    -1,    67,    -1,    -1,   214,    -1,    -1,   411,    -1,
      49,    -1,    -1,     8,  1152,    -1,   164,    -1,    -1,   507,
      -1,   145,    -1,    18,    -1,    -1,   474,   454,   818,   814,
     822,    -1,   478,   454,   818,    -1,    -1,   454,   474,   818,
     815,   822,    -1,   454,   478,   818,    -1,   474,   509,   817,
      -1,    -1,   557,    78,   456,    -1,    -1,   819,   820,    -1,
     821,    -1,   820,   584,   821,    -1,    -1,   471,    -1,   398,
      -1,    -1,   532,   823,    -1,   611,    -1,   823,   584,   611,
      -1,    -1,   410,  1177,   825,  1017,   175,  1149,    -1,    -1,
      26,  1177,   827,  1017,   507,  1149,    -1,    -1,    57,  1177,
     829,  1017,   830,    -1,    -1,   382,    -1,   156,    -1,    -1,
     402,   845,  1177,   832,  1017,   833,    -1,    -1,   834,    -1,
     835,    -1,   835,   834,    -1,   382,    -1,   156,    -1,   537,
      -1,    -1,    14,   845,  1177,   837,  1017,   840,    -1,    -1,
      58,  1177,   839,  1017,   840,    -1,    -1,   841,    -1,   842,
      -1,   842,   841,    -1,   382,    -1,   159,    -1,   299,    -1,
     156,    -1,    54,    -1,   172,   534,    -1,    -1,   348,   845,
    1177,   844,  1017,   840,    -1,    -1,   336,    -1,   258,    -1,
      -1,   401,  1177,   847,   849,    -1,   401,   536,   617,   848,
      -1,  1155,   507,  1155,    -1,   848,   584,  1155,   507,  1155,
      -1,   850,    -1,   849,   584,   850,    -1,  1146,   507,  1146,
      -1,    47,   217,   852,   229,   854,    -1,   853,    -1,   852,
     584,   853,    -1,  1146,   859,    -1,  1152,    -1,   111,    -1,
      -1,   257,   217,   226,    47,   856,   857,    -1,   858,    -1,
     857,   584,   858,    -1,  1146,   859,   862,    -1,    -1,   860,
     861,    -1,    -1,   783,   582,   968,   583,    -1,    -1,   214,
     247,    -1,   864,    -1,   430,   866,    -1,   582,   865,   583,
    1230,    -1,   430,   868,    -1,   582,   865,   583,    -1,    -1,
     868,   867,  1227,    -1,    -1,    -1,   869,   873,   877,   870,
     871,   876,    -1,   987,   993,    -1,  1009,    -1,   872,    -1,
    1009,   872,    -1,   872,  1009,    -1,   175,   941,   976,   981,
     978,   987,   993,  1000,    -1,   175,   130,   976,   993,    -1,
      -1,   874,    -1,   874,   875,    -1,   875,    -1,   480,    -1,
     204,    -1,   125,    -1,   469,    -1,   464,    -1,   465,    -1,
     467,    -1,   468,    -1,   466,    -1,    12,    -1,    -1,   172,
     533,    -1,   262,   229,   447,   310,    -1,   877,   584,   878,
      -1,   878,    -1,   576,    -1,   879,   881,   880,   882,    -1,
      -1,    -1,  1140,    -1,   884,    -1,    -1,    18,  1152,    -1,
      18,  1149,    -1,  1152,    -1,  1149,    -1,    -1,   582,   583,
      -1,    -1,   887,   885,   886,    -1,    -1,   886,   900,   887,
      -1,   887,   562,   887,    -1,    -1,   890,   888,   889,    -1,
      -1,   889,   901,   890,    -1,   333,   890,    -1,   891,    -1,
     892,   232,   513,    -1,   892,   232,   902,   513,    -1,   892,
     232,   158,    -1,   892,   232,   902,   158,    -1,   892,   232,
     529,    -1,   892,   232,   902,   529,    -1,   892,    -1,   892,
     232,   337,    -1,   892,   232,   902,   337,    -1,   892,   146,
     893,    -1,   892,   904,   893,    -1,   892,   904,   905,   582,
    1235,   583,    -1,   893,    -1,   894,   229,   582,  1235,   583,
      -1,   894,   902,   229,   582,  1235,   583,    -1,   894,   229,
     582,   884,   583,    -1,   894,   229,   582,   884,   584,   930,
     583,    -1,   894,   902,   229,   582,   884,   583,    -1,   894,
     902,   229,   582,   884,   584,   930,   583,    -1,   894,   571,
     894,    16,   893,    -1,   894,   902,   571,   894,    16,   893,
      -1,   894,   457,   252,   894,    -1,   894,   252,   907,   980,
      -1,   894,   902,   252,   907,   980,    -1,   894,   395,   894,
      -1,   894,   902,   395,   894,    -1,   894,    -1,   894,   572,
     895,    -1,   895,    -1,   895,   573,   896,    -1,   896,    -1,
     896,   448,   897,    -1,   896,   449,   897,    -1,   897,    -1,
     897,   575,   898,    -1,   897,   574,   898,    -1,   897,   575,
     906,   970,    -1,   897,   574,   906,   970,    -1,   898,    -1,
     898,   576,   899,    -1,   898,   577,   899,    -1,   898,   578,
     899,    -1,   898,   126,   899,    -1,   898,   313,   899,    -1,
     899,    -1,   899,   579,   907,    -1,   907,    -1,   354,    -1,
     351,    -1,    16,    -1,    15,    -1,   333,    -1,   332,    -1,
     585,    -1,   332,    -1,   145,    -1,   184,    -1,   198,    -1,
     244,    -1,   271,    -1,   328,    -1,    12,    -1,    17,    -1,
     225,   884,    -1,  1142,    -1,   907,    64,  1154,    -1,  1137,
      -1,  1135,    -1,   920,    -1,   916,    -1,   907,   353,   907,
      -1,   575,   907,    -1,   574,   907,    -1,   580,   907,    -1,
     903,   907,    -1,   582,  1235,   583,    -1,   582,   884,   583,
      -1,   582,   884,   584,   930,   583,    -1,   424,   582,   884,
     584,   930,   583,    -1,   152,   582,  1235,   583,    -1,   586,
    1152,   884,   587,    -1,   289,   933,     9,   582,   894,   910,
     583,    -1,    20,   582,   884,   583,    -1,    32,   907,    -1,
      51,   582,   884,    18,   928,   583,    -1,   570,   937,   939,
     938,   141,    -1,    83,   582,   884,   584,   928,   583,    -1,
      83,   582,   884,   539,   759,   583,    -1,   111,   582,  1142,
     583,    -1,   544,   582,  1143,   583,    -1,   180,   582,   583,
      -1,   181,   582,   884,   583,    -1,   182,   582,   884,   584,
     884,   583,    -1,   183,   582,   884,   584,   884,   584,   884,
     583,    -1,     7,   582,   884,   584,   884,   583,    -1,     7,
     582,   884,   584,   225,   884,   970,   583,    -1,   404,   582,
     884,   584,   884,   583,    -1,    22,   582,   884,   583,    -1,
      22,   582,   884,   584,   884,   583,    -1,    56,   582,   930,
     583,    -1,    56,   582,   930,   539,   759,   583,    -1,    55,
     582,   884,   583,    -1,    62,   582,   930,   583,    -1,    65,
     582,   884,   583,    -1,    73,   582,   930,   583,    -1,    74,
     582,   884,   584,   930,   583,    -1,    84,   582,   884,   584,
     884,   584,   884,   583,    -1,    90,   883,    -1,    93,   883,
      -1,    93,   582,   884,   583,    -1,    91,   883,    -1,    98,
     582,   884,   584,   906,   970,   583,    -1,    99,   582,   884,
     584,   906,   970,   583,    -1,    94,   582,   583,    -1,   100,
     582,   884,   583,    -1,   105,   582,   884,   583,    -1,   136,
     582,   884,   584,   930,   583,    -1,   272,   582,   884,   584,
     930,   583,    -1,   140,   582,   884,   583,    -1,   140,   582,
     884,   584,   884,   583,    -1,   110,   582,   884,   584,  1150,
     583,    -1,   139,   582,   884,   584,  1150,   583,    -1,   118,
     582,   884,   583,    -1,   118,   582,   884,   584,   884,   583,
      -1,   119,   582,   884,   583,    -1,   119,   582,   884,   584,
     884,   583,    -1,   155,   582,   884,   584,   884,   584,   884,
     583,    -1,   155,   582,   884,   584,   884,   584,   884,   584,
     884,   583,    -1,   155,   582,   884,   584,   884,   584,   884,
     584,   884,   584,   884,   583,    -1,   171,   582,   884,   584,
     338,   583,    -1,   176,   582,   884,   583,    -1,   176,   582,
     884,   584,   884,   583,    -1,   162,   582,   884,   584,   930,
     583,    -1,   909,    -1,   190,   582,   972,   584,   884,   583,
      -1,   209,   582,   884,   583,    -1,   213,   582,   884,   584,
     884,   584,   884,   583,    -1,   223,   582,   884,   584,   884,
     584,   884,   584,   884,   583,    -1,   906,   970,   575,   884,
      -1,   906,    -1,   242,   582,   583,    -1,   242,   582,   884,
     583,    -1,   249,   582,   884,   584,   884,   583,    -1,   259,
     582,   884,   584,   884,   583,    -1,   259,   582,   884,   584,
     884,   584,   884,   583,    -1,   194,   582,   884,   584,   930,
     583,    -1,   246,   582,   884,   584,   930,   583,    -1,   264,
     582,   884,   583,    -1,   264,   582,   884,   584,   884,   583,
      -1,   279,   582,   884,   584,   884,   583,    -1,   279,   582,
     884,   584,   884,   584,   884,   583,    -1,   302,   582,   884,
     583,    -1,   306,   582,   884,   583,    -1,   313,   582,   884,
     584,   884,   583,    -1,   314,   582,   884,   583,    -1,   334,
     883,    -1,   334,   582,   884,   583,    -1,   361,   582,   884,
     583,    -1,   343,   582,   884,   583,    -1,   368,   582,   894,
     229,   884,   583,    -1,   380,   582,   884,   583,    -1,   388,
     582,   884,   583,    -1,   388,   582,   583,    -1,   405,   582,
     884,   584,   884,   584,   884,   583,    -1,   416,   582,   884,
     584,   884,   583,    -1,   419,   582,   884,   583,    -1,   419,
     582,   884,   584,   884,   583,    -1,   422,   582,   583,    -1,
     432,   582,   930,   583,    -1,   482,   582,   884,   584,   884,
     583,    -1,   482,   582,   884,   584,   225,   884,   970,   583,
      -1,   428,   582,   884,   583,    -1,   484,   582,   884,   584,
     884,   584,   884,   583,    -1,   484,   582,   884,   584,   884,
     583,    -1,   484,   582,   884,   175,   884,   172,   884,   583,
      -1,   484,   582,   884,   175,   884,   583,    -1,   485,   582,
     884,   584,   884,   584,   884,   583,    -1,   491,   883,    -1,
     491,   582,   884,   583,    -1,   503,   582,   884,   583,    -1,
     500,   582,   884,   583,    -1,   500,   582,   884,   584,   884,
     583,    -1,   501,   582,   971,   584,   884,   584,   884,   583,
      -1,   502,   582,   971,   584,   884,   584,   884,   583,    -1,
     512,   582,   884,   583,    -1,   512,   582,   245,   884,   175,
     884,   583,    -1,   512,   582,   508,   884,   175,   884,   583,
      -1,   512,   582,    43,   884,   175,   884,   583,    -1,   512,
     582,   245,   175,   884,   583,    -1,   512,   582,   508,   175,
     884,   583,    -1,   512,   582,    43,   175,   884,   583,    -1,
     512,   582,   884,   175,   884,   583,    -1,   514,   582,   884,
     584,   884,   583,    -1,  1152,   589,  1152,   582,   929,   583,
      -1,    -1,  1148,   582,   908,   911,   583,    -1,   527,   582,
    1133,   584,   338,   584,   338,   584,   930,   583,    -1,   528,
     582,   583,    -1,   528,   582,   884,   583,    -1,   536,   582,
     583,    -1,   540,   883,    -1,   542,   883,    -1,   541,   883,
      -1,   553,   582,   884,   583,    -1,   553,   582,   884,   584,
     884,   583,    -1,   565,   582,   884,   583,    -1,   563,   582,
     884,   583,    -1,   563,   582,   884,   584,   884,   583,    -1,
      29,   582,   998,   584,   884,   583,    -1,   157,   582,   970,
     175,   884,   583,    -1,    80,   582,   884,   584,   884,   583,
      -1,   188,   582,   884,   583,    -1,   188,   582,   884,   584,
     884,   583,    -1,   189,   582,   884,   583,    -1,   189,   582,
     884,   584,   884,   583,    -1,   186,   582,   930,   583,    -1,
     256,   582,   930,   583,    -1,   317,   582,   930,   583,    -1,
     309,   582,   884,   583,    -1,   309,   582,   884,   584,   884,
     583,    -1,   315,   582,   884,   583,    -1,   315,   582,   884,
     584,   884,   583,    -1,   316,   582,   884,   583,    -1,   316,
     582,   884,   584,   884,   583,    -1,   318,   582,   930,   583,
      -1,   319,   582,   930,   583,    -1,   365,   582,   884,   584,
     884,   583,    -1,   364,   582,   884,   583,    -1,   364,   582,
     884,   584,   884,   583,    -1,   366,   582,   884,   583,    -1,
     366,   582,   884,   584,   884,   583,    -1,   367,   582,   930,
     583,    -1,   185,   582,   884,   583,    -1,   185,   582,   884,
     584,   884,   583,    -1,   254,   582,   884,   583,    -1,   254,
     582,   884,   584,   884,   583,    -1,    -1,   557,   381,   154,
      -1,   229,    41,   310,    -1,    -1,   912,    -1,    -1,   913,
     914,    -1,   915,    -1,   914,   584,   915,    -1,   879,   884,
     880,   882,    -1,    25,   582,   926,   583,    -1,    25,   582,
     125,   926,   583,    -1,    35,   582,   926,   583,    -1,    36,
     582,   926,   583,    -1,    38,   582,   926,   583,    -1,    85,
     582,   975,   576,   583,    -1,    85,   582,   926,   583,    -1,
      -1,    -1,    85,   582,   125,   917,   930,   918,   583,    -1,
     197,   582,  1133,   584,   338,   584,   338,   584,   926,   583,
      -1,   308,   582,   926,   583,    -1,   308,   582,   125,   926,
     583,    -1,   293,   582,   926,   583,    -1,   293,   582,   125,
     926,   583,    -1,   476,   582,   926,   583,    -1,   549,   582,
     926,   583,    -1,   477,   582,   926,   583,    -1,   543,   582,
     926,   583,    -1,   486,   582,   926,   583,    -1,   486,   582,
     125,   926,   583,    -1,    -1,   196,   582,   923,   919,   930,
     925,   924,   583,    -1,    -1,   588,   921,   922,    -1,  1154,
     446,   884,    -1,  1154,    -1,   588,  1167,  1154,   793,    -1,
      -1,   125,    -1,    -1,   441,  1134,    -1,    -1,   988,    -1,
      -1,   975,   927,   884,    -1,    32,   752,    -1,    56,   752,
     768,    -1,   326,   752,    -1,   452,    -1,   452,   227,    -1,
     531,    -1,   531,   227,    -1,   100,    -1,   503,    -1,    97,
      -1,   108,   747,    -1,    -1,   930,    -1,    -1,   931,   932,
      -1,   884,    -1,   932,   584,   884,    -1,   934,    -1,   582,
     934,   583,    -1,    -1,   935,   936,    -1,  1142,    -1,   936,
     584,  1142,    -1,    -1,   884,    -1,    -1,   568,   884,    -1,
     554,   884,   569,   884,    -1,   939,   554,   884,   569,   884,
      -1,   952,    -1,   943,    -1,   942,    -1,   940,    -1,   942,
     584,   940,    -1,   940,   951,   940,    -1,   940,   480,   952,
      -1,    -1,   940,   951,   940,   344,   944,   884,    -1,    -1,
     940,   480,   952,   344,   945,   884,    -1,    -1,   940,   951,
     940,   539,   946,   582,   969,   583,    -1,   940,   324,   236,
     952,    -1,    -1,   940,   249,   962,   236,   940,   344,   947,
     884,    -1,    -1,   940,   249,   962,   236,   952,   948,   539,
     582,   969,   583,    -1,   940,   324,   249,   962,   236,   952,
      -1,    -1,   940,   416,   962,   236,   940,   344,   949,   884,
      -1,    -1,   940,   416,   962,   236,   952,   950,   539,   582,
     969,   583,    -1,   940,   324,   416,   962,   236,   952,    -1,
     236,    -1,   219,   236,    -1,    88,   236,    -1,    -1,   953,
    1146,   974,   964,    -1,    -1,   586,  1152,   940,   249,   355,
     236,   940,   344,   954,   884,   587,    -1,   961,   960,   957,
      -1,   582,   960,   955,  1230,   583,   974,    -1,    -1,   960,
     956,   942,    -1,    -1,    -1,   958,   873,   877,   959,   724,
      -1,    -1,   430,    -1,    -1,   355,    -1,    -1,   172,   236,
      -1,    -1,   538,   965,    -1,   169,   965,    -1,   214,   965,
      -1,    -1,   782,   963,   966,   582,   967,   583,    -1,    -1,
     968,    -1,   968,   584,  1152,    -1,  1152,    -1,   372,    -1,
    1152,    -1,   969,   584,  1152,    -1,   971,    -1,   101,    -1,
     102,    -1,   103,    -1,   104,    -1,   206,    -1,   207,    -1,
     208,    -1,   302,    -1,   304,    -1,   305,    -1,   427,    -1,
     564,    -1,   105,    -1,   553,    -1,   209,    -1,   174,    -1,
     306,    -1,   314,    -1,   380,    -1,   428,    -1,   565,    -1,
     100,    -1,   503,    -1,    97,    -1,   500,    -1,    -1,    18,
      -1,   145,    -1,    -1,   973,  1152,    -1,    -1,    12,    -1,
      -1,    -1,   555,   977,   884,    -1,    -1,    -1,   201,   979,
     884,    -1,   149,   907,    -1,    -1,    -1,   195,    45,   982,
     983,    -1,   982,   584,  1141,   991,    -1,  1141,   991,    -1,
      -1,   557,    89,    -1,   557,   418,    -1,   352,    45,   985,
      -1,   985,   584,   986,    -1,   986,    -1,  1143,   991,    -1,
      -1,   988,    -1,    -1,   352,    45,   989,   990,    -1,   990,
     584,  1141,   991,    -1,  1141,   991,    -1,    -1,    19,    -1,
     116,    -1,    -1,   994,    -1,    -1,   994,    -1,   253,   995,
      -1,   996,    -1,   996,   584,   996,    -1,   996,   341,   996,
      -1,  1135,    -1,   519,    -1,   267,    -1,   338,    -1,    -1,
     253,   996,    -1,   338,    -1,   203,    -1,   267,    -1,   519,
      -1,   107,    -1,   166,    -1,   338,    -1,   519,    -1,   267,
      -1,   107,    -1,   166,    -1,    -1,    -1,   374,  1152,  1001,
     582,  1002,   583,    -1,    -1,  1003,    -1,  1003,   584,  1004,
      -1,  1004,    -1,   879,   884,    -1,    -1,  1006,  1007,    -1,
    1007,   584,  1008,    -1,  1008,    -1,   588,  1154,    -1,  1154,
      -1,    -1,   226,  1010,  1011,    -1,    -1,   356,  1151,  1012,
    1122,  1125,    -1,   131,  1151,    -1,  1005,    -1,    -1,   128,
    1014,   930,    -1,   129,  1020,  1177,  1019,  1017,   810,    -1,
      -1,   129,   217,  1152,   344,  1146,  1016,    -1,   129,    94,
    1019,  1152,    -1,   129,   179,  1019,   618,    -1,   129,   374,
    1019,   618,    -1,   129,   536,   617,  1207,    -1,   129,   551,
    1019,  1017,   810,    -1,   129,   510,  1019,   618,    -1,  1018,
      -1,  1017,   584,  1018,    -1,  1146,    -1,    -1,   213,   152,
      -1,    -1,   495,    -1,    -1,    -1,   223,  1022,  1027,   809,
    1029,  1023,  1031,  1047,    -1,    -1,    -1,   405,  1025,  1028,
    1029,  1026,  1031,    -1,    -1,   270,    -1,   113,    -1,   204,
      -1,  1056,    -1,   113,    -1,   226,  1030,    -1,  1030,    -1,
    1018,    -1,  1034,    -1,   582,   583,  1034,    -1,   582,  1033,
     583,  1034,    -1,    -1,   445,  1032,  1038,    -1,  1033,   584,
    1139,    -1,  1139,    -1,   544,  1037,    -1,   545,  1037,    -1,
      -1,   703,  1035,  1227,    -1,    -1,   582,   703,   583,  1036,
    1230,    -1,  1037,   584,  1042,    -1,  1042,    -1,  1038,   584,
    1039,    -1,  1039,    -1,  1143,  1040,  1046,    -1,   145,    -1,
     446,    -1,    -1,  1040,    -1,    -1,   582,  1043,  1044,   583,
      -1,    -1,  1045,    -1,  1045,   584,  1046,    -1,  1046,    -1,
     884,    -1,   111,    -1,    -1,    -1,   344,   132,  1048,   238,
     533,  1054,    -1,    -1,    -1,   533,  1050,  1056,   809,   941,
     445,  1052,  1051,   976,   987,   997,    -1,  1052,   584,  1053,
      -1,  1053,    -1,  1143,  1040,  1046,    -1,  1054,   584,  1055,
      -1,  1055,    -1,  1143,  1040,  1046,    -1,    -1,   270,    -1,
      -1,   115,  1058,  1066,  1059,    -1,    -1,   175,  1146,  1060,
     976,   987,   997,    -1,    -1,  1063,  1061,   175,   941,   976,
      -1,    -1,   175,  1063,  1062,   539,   941,   976,    -1,  1064,
      -1,  1063,   584,  1064,    -1,  1152,  1065,   974,    -1,  1152,
     589,  1152,  1065,   974,    -1,    -1,   589,   576,    -1,    -1,
    1067,  1066,    -1,   382,    -1,   270,    -1,   214,    -1,   514,
    1069,  1018,    -1,    -1,   494,    -1,    -1,  1071,    -1,  1072,
      -1,  1071,   584,  1072,    -1,    86,    -1,   300,    -1,    40,
     230,    -1,    81,   490,    -1,   359,   160,    -1,   231,    -1,
     489,    -1,   458,    -1,    12,    -1,    -1,   172,   381,   338,
      -1,    -1,   450,  1075,  1076,    -1,    95,  1087,    -1,  1083,
     492,  1082,  1087,    -1,  1083,   511,  1082,  1087,    -1,   494,
     475,  1082,  1087,    -1,   347,   492,  1082,  1087,    -1,    -1,
     143,   720,  1077,  1079,    -1,  1083,    66,  1084,  1146,  1082,
    1087,    -1,   329,   287,   172,   454,   557,   275,   145,  1149,
      16,   276,   145,   999,    16,   280,   145,   998,    -1,  1080,
     263,    -1,   454,   205,    -1,    -1,    33,   150,  1085,  1086,
    1078,   992,    -1,   784,  1084,  1146,  1082,   976,    -1,    67,
     515,    -1,   494,   515,    -1,  1081,   142,    -1,   373,    -1,
      85,   582,   576,   583,   552,    -1,    85,   582,   576,   583,
     147,    -1,   552,   992,    -1,   147,   992,    -1,   378,    -1,
     377,  1070,  1073,   992,    -1,  1166,   475,  1087,    -1,   220,
     475,    -1,   320,   475,    -1,  1083,   376,    -1,  1166,   548,
    1087,    -1,   758,  1087,    -1,    65,  1087,    -1,    30,   263,
      -1,   263,    -1,   193,    -1,   193,   172,  1155,    -1,    87,
      94,   713,  1152,    -1,    87,   494,  1146,    -1,    87,   551,
    1146,    -1,   287,   475,    -1,   454,   475,    -1,    87,   374,
     618,    -1,    87,   179,   618,    -1,   374,   475,  1087,    -1,
     179,   475,  1087,    -1,   374,    63,   618,    -1,   179,    63,
     618,    -1,   439,   475,  1082,  1087,    -1,   475,    -1,   263,
      -1,   287,    -1,    32,    -1,    -1,   479,    -1,    -1,  1084,
    1152,    -1,    -1,   177,    -1,   175,    -1,   229,    -1,    -1,
     229,  1149,    -1,    -1,   175,   999,    -1,    -1,   252,  1149,
      -1,   555,   884,    -1,    -1,  1091,  1146,  1089,  1093,    -1,
      -1,  1091,  1092,  1090,   863,    -1,   116,    -1,   117,    -1,
      -1,   156,    -1,    -1,  1134,    -1,  1152,    -1,    -1,   168,
     845,  1095,  1096,    -1,  1096,   584,  1097,    -1,  1097,    -1,
      -1,  1177,  1098,  1099,    -1,   492,   557,   390,   262,    -1,
     381,    47,    -1,   205,    -1,   373,    -1,   263,    -1,   475,
      -1,   454,    -1,   287,    -1,   120,    -1,   409,    -1,    -1,
    1017,    -1,    -1,   408,  1101,  1102,    -1,  1102,   584,  1103,
      -1,  1103,    -1,   454,    -1,   287,    -1,   381,    47,    -1,
      -1,   379,  1105,  1106,    -1,  1080,   263,  1107,    -1,   507,
    1149,    -1,    27,   884,    -1,    -1,   239,  1109,  1110,   884,
      -1,    -1,    77,    -1,   381,    -1,   538,  1152,    -1,    -1,
     257,    96,  1113,  1114,    -1,   257,   494,  1146,   175,   287,
      -1,    -1,    -1,    -1,    -1,  1120,  1119,   218,  1151,  1115,
    1121,   226,  1116,   494,  1146,  1117,   761,  1118,  1122,  1125,
    1128,  1129,  1132,    -1,   175,   287,    -1,    -1,   258,    -1,
      -1,    75,    -1,   270,    -1,    -1,   405,    -1,   214,    -1,
      -1,    66,  1123,    -1,  1123,  1124,    -1,  1124,    -1,   497,
      45,  1134,    -1,   350,   138,    45,  1134,    -1,   138,    45,
    1134,    -1,   148,    45,  1134,    -1,    -1,   255,  1126,    -1,
    1126,  1127,    -1,  1127,    -1,   497,    45,  1134,    -1,   473,
      45,  1134,    -1,    -1,   214,   338,   255,    -1,    -1,   582,
    1130,   583,    -1,   582,   583,    -1,  1130,   584,  1131,    -1,
    1131,    -1,  1143,    -1,   588,  1154,    -1,    -1,   445,  1054,
      -1,  1150,    -1,   325,    -1,   522,   498,    -1,  1133,  1150,
      -1,  1150,    -1,   203,    -1,    34,    -1,   362,    -1,  1137,
      -1,   575,  1138,    -1,   574,  1138,    -1,  1133,    -1,  1138,
      -1,   337,    -1,   158,    -1,   513,    -1,   203,    -1,    34,
      -1,   522,   203,    -1,   522,    34,    -1,   100,  1133,    -1,
     503,  1133,    -1,   500,  1133,    -1,   338,    -1,   267,    -1,
     519,    -1,   107,    -1,   166,    -1,  1143,    -1,  1140,    -1,
    1152,   589,   576,    -1,  1152,   589,  1152,   589,   576,    -1,
     884,    -1,  1152,    -1,  1144,    -1,  1152,    -1,  1144,    -1,
    1152,   589,  1152,    -1,   589,  1152,   589,  1152,    -1,  1152,
     589,  1152,   589,  1152,    -1,  1152,    -1,  1152,   589,  1152,
     589,  1152,    -1,  1152,   589,  1152,    -1,   589,  1152,    -1,
    1152,    -1,  1152,   589,  1152,    -1,   589,  1152,    -1,  1152,
      -1,   210,    -1,   212,    -1,   498,    -1,   498,    -1,   498,
      -1,  1148,    -1,  1156,    -1,  1148,    -1,  1157,    -1,  1152,
      -1,  1149,    -1,   251,    -1,  1154,    -1,  1154,   588,  1154,
      -1,    91,   883,    -1,  1157,    -1,    20,    -1,    26,    -1,
      28,    -1,    46,    -1,    47,    -1,    55,    -1,    57,    -1,
      61,    -1,    68,    -1,    70,    -1,    80,    -1,   106,    -1,
     128,    -1,   141,    -1,   151,    -1,   168,    -1,   199,    -1,
     202,    -1,   241,    -1,   335,    -1,   347,    -1,   370,    -1,
     402,    -1,   408,    -1,   410,    -1,   417,    -1,   426,    -1,
     429,    -1,   452,    -1,   454,    -1,   474,    -1,   478,    -1,
     514,    -1,   524,    -1,   561,    -1,   534,    -1,     5,    -1,
       7,    -1,     8,    -1,     9,    -1,    10,    -1,    11,    -1,
      17,    -1,    23,    -1,    24,    -1,    25,    -1,    30,    -1,
      33,    -1,    37,    -1,    40,    -1,    42,    -1,    41,    -1,
      44,    -1,    50,    -1,    52,    -1,    54,    -1,    59,    -1,
      60,    -1,    63,    -1,    65,    -1,    66,    -1,    69,    -1,
      71,    -1,    72,    -1,    75,    -1,    77,    -1,    78,    -1,
      81,    -1,    86,    -1,    89,    -1,    96,    -1,    97,    -1,
     100,    -1,   105,    -1,   112,    -1,   114,    -1,   120,    -1,
     122,    -1,   124,    -1,   131,    -1,   132,    -1,   133,    -1,
     144,    -1,   143,    -1,   142,    -1,   147,    -1,   149,    -1,
     150,    -1,   154,    -1,   156,    -1,   159,    -1,   160,    -1,
     173,    -1,   123,    -1,   137,    -1,   177,    -1,   163,    -1,
     164,    -1,   165,    -1,   174,    -1,   187,    -1,   186,    -1,
     190,    -1,   193,    -1,   191,    -1,   200,    -1,   205,    -1,
     209,    -1,   211,    -1,   228,    -1,   215,    -1,   216,    -1,
     233,    -1,   234,    -1,   220,    -1,   224,    -1,   230,    -1,
     231,    -1,   398,    -1,   243,    -1,   247,    -1,   250,    -1,
     256,    -1,   258,    -1,   261,    -1,   263,    -1,   292,    -1,
     287,    -1,   274,    -1,   278,    -1,   275,    -1,   276,    -1,
     288,    -1,   277,    -1,   280,    -1,   273,    -1,   286,    -1,
     282,    -1,   281,    -1,   283,    -1,   284,    -1,   285,    -1,
     290,    -1,   291,    -1,   294,    -1,   295,    -1,   299,    -1,
     300,    -1,   301,    -1,   302,    -1,   303,    -1,   306,    -1,
     307,    -1,   312,    -1,   310,    -1,   314,    -1,   317,    -1,
     318,    -1,   319,    -1,   320,    -1,   322,    -1,   321,    -1,
     323,    -1,   326,    -1,   327,    -1,   330,    -1,   329,    -1,
     331,    -1,   340,    -1,   341,    -1,   343,    -1,   345,    -1,
     346,    -1,   358,    -1,   359,    -1,   360,    -1,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,   371,    -1,   373,    -1,
     375,    -1,   376,    -1,   377,    -1,   378,    -1,   380,    -1,
     381,    -1,   382,    -1,   383,    -1,   384,    -1,   385,    -1,
     386,    -1,   387,    -1,   392,    -1,   393,    -1,   396,    -1,
     397,    -1,   400,    -1,   403,    -1,   406,    -1,   409,    -1,
     412,    -1,   413,    -1,   418,    -1,   420,    -1,   421,    -1,
     423,    -1,   424,    -1,   425,    -1,   428,    -1,   431,    -1,
     433,    -1,   434,    -1,   439,    -1,   443,    -1,   442,    -1,
     444,    -1,   453,    -1,   447,    -1,   451,    -1,   456,    -1,
     457,    -1,   458,    -1,   466,    -1,   465,    -1,   468,    -1,
     471,    -1,   475,    -1,   479,    -1,   481,    -1,   482,    -1,
     483,    -1,   487,    -1,   488,    -1,   489,    -1,   490,    -1,
     492,    -1,   493,    -1,   495,    -1,   496,    -1,   499,    -1,
     509,    -1,   511,    -1,   500,    -1,   501,    -1,   502,    -1,
     503,    -1,   515,    -1,   516,    -1,   517,    -1,   179,    -1,
     520,    -1,   521,    -1,   529,    -1,   532,    -1,   536,    -1,
     537,    -1,   548,    -1,   551,    -1,   545,    -1,   552,    -1,
     553,    -1,   558,    -1,   560,    -1,   565,    -1,    -1,   445,
    1160,  1159,  1161,    -1,    -1,   349,    -1,  1162,    -1,  1161,
     584,  1162,    -1,    -1,  1163,  1168,    -1,  1165,    -1,   191,
      -1,   258,    -1,   444,    -1,    -1,   345,    -1,    -1,   191,
      -1,   258,    -1,   444,    -1,    -1,   191,   589,    -1,   258,
     589,    -1,   444,   589,    -1,  1169,    -1,  1165,  1170,    -1,
    1164,  1171,  1040,  1174,    -1,  1164,   509,   233,   250,  1172,
      -1,   588,  1154,  1040,   884,    -1,   588,   588,  1167,  1171,
    1040,  1174,    -1,   758,   763,    -1,   321,  1040,   884,    -1,
     321,   760,   765,    -1,   361,  1040,  1173,    -1,   361,   172,
    1155,  1040,  1173,    -1,  1152,    -1,  1152,   589,  1152,    -1,
     111,   589,  1152,    -1,   390,   520,    -1,   390,    69,    -1,
     403,   390,    -1,   442,    -1,   498,    -1,   361,   582,   498,
     583,    -1,   343,   582,   498,   583,    -1,   884,    -1,   111,
      -1,   344,    -1,    12,    -1,    32,    -1,    -1,   262,  1177,
    1176,  1178,    -1,   494,    -1,   492,    -1,  1179,    -1,  1178,
     584,  1179,    -1,  1146,   974,  1180,    -1,   390,    -1,   559,
      -1,   270,   559,    -1,   390,   258,    -1,    -1,   530,  1182,
    1177,    -1,   199,  1146,   347,   974,    -1,   199,  1147,    61,
      -1,    -1,   199,  1147,   390,  1184,  1185,   976,   993,    -1,
    1186,    -1,  1152,  1187,    -1,   164,    -1,   330,    -1,   164,
      -1,   330,    -1,   371,    -1,   243,    -1,    -1,  1189,  1188,
     582,  1045,   583,    -1,   145,    -1,   184,    -1,   244,    -1,
     198,    -1,   271,    -1,   415,   617,  1191,    -1,  1195,   344,
    1194,  1206,   175,  1208,    -1,  1195,   344,   179,  1206,   175,
    1208,    -1,  1195,   344,   374,  1206,   175,  1208,    -1,    12,
    1196,   584,   192,   349,   175,  1208,    -1,   192,   617,  1193,
      -1,  1195,   344,  1194,  1206,   507,  1208,  1213,  1214,    -1,
    1195,   344,   179,  1206,   507,  1208,  1213,  1214,    -1,  1195,
     344,   374,  1206,   507,  1208,  1213,  1214,    -1,    -1,   494,
      -1,  1197,    -1,    12,  1196,    -1,    -1,   373,    -1,  1198,
      -1,  1197,   584,  1198,    -1,    -1,   430,  1199,  1210,    -1,
      -1,   223,  1200,  1210,    -1,    -1,   533,  1201,  1210,    -1,
      -1,   394,  1202,  1210,    -1,   115,    -1,   535,    -1,   217,
      -1,    13,    -1,    87,    -1,   129,    -1,   151,    -1,   400,
      -1,   451,    -1,   375,    -1,   163,    -1,   192,   349,    -1,
     450,    95,    -1,   487,    -1,    87,   495,   492,    -1,   262,
     492,    -1,   406,   454,    -1,   406,    60,    -1,    87,   551,
      -1,   450,   551,    -1,    87,   420,    -1,    13,   420,    -1,
      87,   536,    -1,    -1,    16,    -1,  1205,  1203,  1204,    -1,
    1205,    -1,   483,   498,    -1,   234,   498,    -1,    59,   498,
      -1,   576,    -1,  1152,   589,   576,    -1,   576,   589,   576,
      -1,  1146,    -1,  1155,    -1,  1207,   584,  1155,    -1,  1209,
      -1,  1208,   584,  1209,    -1,  1155,   211,    45,   498,    -1,
    1155,   211,    45,   361,   498,    -1,  1155,    -1,    -1,   582,
    1211,   583,    -1,  1211,   584,  1212,    -1,  1212,    -1,  1152,
      -1,    -1,   407,  1204,    -1,   407,   472,    -1,   407,   560,
      -1,   407,   331,    -1,    -1,   557,  1215,    -1,  1215,  1216,
      -1,  1216,    -1,   192,   349,    -1,   291,   998,    -1,   294,
     998,    -1,   290,   998,    -1,   295,   998,    -1,    -1,    28,
    1218,  1219,    -1,    -1,   558,    -1,    -1,    16,   335,    52,
      -1,    16,    52,    -1,    -1,   399,    -1,   335,   399,    -1,
      -1,   426,    -1,    70,  1219,  1220,  1221,    -1,   417,  1219,
    1220,  1221,    -1,   417,  1219,   507,  1222,  1152,    -1,   426,
    1152,    -1,   399,   426,  1152,    -1,    -1,  1228,    -1,    -1,
     525,  1234,  1229,   864,    -1,    -1,  1228,    -1,  1231,    -1,
      -1,  1232,  1233,    -1,   988,   992,    -1,   994,    -1,    -1,
     125,    -1,    12,    -1,   430,  1238,  1237,  1239,    -1,    -1,
     582,  1238,  1235,   583,  1236,  1227,  1239,    -1,   866,    -1,
      -1,    -1,  1242,  1241,    -1,  1243,  1242,  1248,    -1,  1248,
      -1,  1256,    -1,  1258,    -1,    -1,   112,   145,  1155,    -1,
    1244,    -1,  1244,  1245,    -1,  1245,    -1,   354,   405,    -1,
      11,   145,   521,    -1,    11,   145,   301,    -1,    11,   145,
     496,    -1,    -1,  1245,    -1,    -1,   470,   429,   112,    -1,
     470,   429,   228,    -1,    -1,  1247,   551,  1146,  1249,  1250,
      18,  1252,  1255,    -1,    -1,   582,  1251,   583,    -1,  1152,
      -1,  1251,   584,  1152,    -1,    -1,  1253,  1254,    -1,   430,
     879,   866,    -1,   582,   879,   865,   583,  1230,    -1,    -1,
     557,    58,   349,    -1,   557,    50,    58,   349,    -1,   557,
     258,    58,   349,    -1,    -1,   510,   879,   618,   695,   696,
     344,   879,  1146,   172,   879,   134,   424,  1257,   659,    -1,
      -1,   725,   879,   179,   618,  1259,   619,    -1,    -1,    -1,
      -1,    -1,   374,   879,   618,  1260,   582,  1261,   639,   583,
    1262,   626,  1263,   659,    -1,   561,  1266,  1265,  1267,    -1,
     561,   141,  1265,  1269,    -1,   561,   370,  1265,    -1,   561,
      70,  1265,  1268,    -1,   561,   417,  1265,    -1,   561,   392,
      -1,  1134,    -1,  1134,   584,  1134,    -1,  1134,   584,  1134,
     584,   998,    -1,    28,    -1,   474,    -1,    -1,   236,    -1,
     412,    -1,    -1,   346,   363,    -1,    -1,    -1,   488,  1270,
    1271,    -1,    -1,   172,   303,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1225,  1225,  1239,  1242,  1243,  1248,  1249,  1250,  1251,
    1252,  1253,  1254,  1255,  1256,  1257,  1258,  1259,  1260,  1261,
    1262,  1263,  1264,  1265,  1266,  1267,  1268,  1269,  1270,  1271,
    1272,  1273,  1274,  1275,  1276,  1277,  1278,  1279,  1280,  1281,
    1282,  1283,  1284,  1285,  1286,  1287,  1288,  1289,  1290,  1291,
    1292,  1293,  1294,  1298,  1307,  1308,  1313,  1322,  1329,  1339,
    1338,  1349,  1351,  1355,  1356,  1359,  1372,  1371,  1390,  1389,
    1400,  1401,  1404,  1409,  1414,  1419,  1424,  1428,  1433,  1437,
    1441,  1445,  1449,  1454,  1458,  1462,  1478,  1482,  1494,  1493,
    1516,  1515,  1542,  1541,  1554,  1553,  1561,  1569,  1583,  1598,
    1616,  1636,  1675,  1683,  1691,  1703,  1635,  1734,  1735,  1739,
    1740,  1745,  1747,  1749,  1751,  1753,  1755,  1757,  1763,  1764,
    1765,  1769,  1773,  1781,  1780,  1793,  1795,  1798,  1800,  1804,
    1808,  1815,  1817,  1821,  1822,  1827,  1846,  1872,  1874,  1878,
    1879,  1883,  1909,  1910,  1911,  1912,  1916,  1917,  1921,  1922,
    1927,  1930,  1957,  1956,  2012,  2027,  2026,  2070,  2094,  2094,
    2125,  2126,  2131,  2133,  2138,  2161,  2167,  2182,  2183,  2187,
    2191,  2200,  2205,  2210,  2218,  2233,  2251,  2252,  2256,  2256,
    2306,  2305,  2329,  2328,  2332,  2333,  2335,  2335,  2346,  2375,
    2403,  2419,  2418,  2435,  2452,  2454,  2455,  2459,  2480,  2503,
    2505,  2519,  2503,  2537,  2539,  2540,  2544,  2545,  2550,  2556,
    2549,  2575,  2574,  2590,  2591,  2595,  2596,  2601,  2605,  2600,
    2622,  2626,  2621,  2641,  2649,  2654,  2653,  2691,  2692,  2697,
    2696,  2723,  2734,  2736,  2733,  2760,  2759,  2777,  2779,  2784,
    2786,  2788,  2793,  2794,  2795,  2801,  2810,  2811,  2811,  2815,
    2817,  2816,  2819,  2818,  2824,  2840,  2823,  2854,  2855,  2858,
    2859,  2862,  2863,  2866,  2867,  2870,  2871,  2874,  2875,  2878,
    2881,  2882,  2884,  2886,  2889,  2890,  2893,  2894,  2895,  2898,
    2899,  2900,  2901,  2902,  2903,  2904,  2905,  2906,  2921,  2927,
    2928,  2929,  2930,  2935,  2940,  2945,  2960,  2961,  2962,  2963,
    2964,  2965,  2969,  2986,  3002,  3012,  3013,  3014,  3015,  3016,
    3017,  3020,  3021,  3022,  3025,  3026,  3027,  3030,  3031,  3034,
    3035,  3038,  3039,  3040,  3041,  3044,  3045,  3049,  3050,  3054,
    3055,  3065,  3079,  3094,  3114,  3121,  3130,  3132,  3136,  3140,
    3141,  3145,  3150,  3149,  3171,  3172,  3173,  3174,  3176,  3178,
    3180,  3182,  3184,  3186,  3189,  3192,  3195,  3198,  3200,  3203,
    3206,  3207,  3208,  3209,  3222,  3223,  3225,  3227,  3239,  3241,
    3243,  3245,  3246,  3247,  3248,  3249,  3250,  3252,  3254,  3256,
    3256,  3258,  3258,  3260,  3261,  3270,  3271,  3272,  3275,  3276,
    3277,  3278,  3279,  3283,  3287,  3288,  3292,  3293,  3297,  3298,
    3299,  3300,  3301,  3305,  3306,  3307,  3308,  3309,  3312,  3314,
    3315,  3319,  3320,  3321,  3324,  3331,  3332,  3335,  3336,  3339,
    3340,  3341,  3344,  3345,  3348,  3349,  3352,  3353,  3356,  3357,
    3360,  3361,  3362,  3363,  3365,  3366,  3372,  3378,  3384,  3390,
    3391,  3407,  3408,  3412,  3413,  3417,  3425,  3429,  3430,  3433,
    3434,  3438,  3447,  3451,  3452,  3455,  3465,  3466,  3470,  3471,
    3474,  3475,  3478,  3479,  3480,  3481,  3490,  3491,  3494,  3495,
    3498,  3499,  3500,  3509,  3511,  3513,  3518,  3517,  3529,  3530,
    3533,  3534,  3538,  3539,  3542,  3543,  3546,  3547,  3548,  3549,
    3550,  3553,  3554,  3555,  3556,  3557,  3560,  3561,  3562,  3574,
    3575,  3578,  3579,  3582,  3583,  3587,  3588,  3589,  3592,  3593,
    3594,  3595,  3608,  3609,  3610,  3613,  3614,  3618,  3619,  3622,
    3623,  3626,  3631,  3636,  3641,  3646,  3651,  3656,  3661,  3666,
    3671,  3676,  3687,  3688,  3691,  3692,  3703,  3704,  3707,  3708,
    3711,  3712,  3720,  3719,  3746,  3745,  3760,  3759,  3778,  3777,
    3797,  3795,  3810,  3811,  3813,  3814,  3815,  3816,  3817,  3820,
    3828,  3829,  3833,  3838,  3837,  3845,  3854,  3844,  3866,  3873,
    3877,  3884,  3891,  3897,  3903,  3909,  3916,  3935,  3956,  3961,
    3965,  3972,  3973,  3976,  3977,  3981,  3982,  3983,  3987,  3988,
    3989,  3992,  3993,  3994,  3995,  4003,  4002,  4013,  4021,  4020,
    4030,  4040,  4049,  4050,  4057,  4057,  4063,  4064,  4068,  4069,
    4070,  4074,  4075,  4092,  4093,  4098,  4097,  4108,  4107,  4118,
    4117,  4127,  4128,  4129,  4134,  4133,  4145,  4146,  4149,  4150,
    4153,  4154,  4155,  4159,  4158,  4171,  4170,  4187,  4188,  4191,
    4192,  4195,  4196,  4197,  4198,  4199,  4200,  4204,  4203,  4215,
    4216,  4217,  4222,  4221,  4227,  4234,  4239,  4247,  4248,  4251,
    4263,  4272,  4273,  4276,  4289,  4290,  4295,  4294,  4304,  4305,
    4308,  4321,  4321,  4331,  4332,  4341,  4342,  4351,  4360,  4362,
    4365,  4387,  4391,  4390,  4410,  4418,  4410,  4424,  4425,  4426,
    4427,  4428,  4431,  4438,  4445,  4447,  4458,  4459,  4462,  4463,
    4469,  4470,  4471,  4472,  4478,  4484,  4490,  4500,  4503,  4505,
    4511,  4521,  4522,  4523,  4536,  4556,  4563,  4570,  4571,  4574,
    4575,  4576,  4577,  4578,  4582,  4583,  4587,  4587,  4604,  4606,
    4611,  4612,  4612,  4629,  4631,  4636,  4637,  4640,  4642,  4644,
    4646,  4648,  4649,  4650,  4654,  4655,  4656,  4657,  4659,  4661,
    4664,  4668,  4674,  4678,  4684,  4688,  4696,  4698,  4704,  4707,
    4709,  4711,  4712,  4714,  4717,  4718,  4721,  4722,  4725,  4727,
    4729,  4732,  4733,  4734,  4736,  4738,  4741,  4742,  4743,  4744,
    4745,  4746,  4749,  4750,  4752,  4752,  4753,  4753,  4754,  4754,
    4755,  4755,  4757,  4758,  4759,  4760,  4761,  4762,  4765,  4766,
    4770,  4774,  4775,  4782,  4783,  4784,  4785,  4786,  4788,  4789,
    4790,  4791,  4792,  4796,  4797,  4802,  4807,  4811,  4812,  4816,
    4817,  4821,  4828,  4830,  4836,  4838,  4849,  4851,  4862,  4873,
    4884,  4895,  4897,  4899,  4901,  4903,  4905,  4907,  4909,  4911,
    4913,  4915,  4917,  4919,  4925,  4927,  4929,  4934,  4939,  4941,
    4943,  4948,  4950,  4952,  4954,  4956,  4961,  4962,  4964,  4966,
    4968,  4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,  4988,
    4990,  5000,  5002,  5004,  5006,  5008,  5011,  5020,  5025,  5030,
    5032,  5034,  5036,  5038,  5040,  5042,  5044,  5049,  5054,  5056,
    5058,  5060,  5062,  5064,  5066,  5072,  5074,  5076,  5078,  5080,
    5082,  5084,  5086,  5088,  5089,  5095,  5100,  5102,  5104,  5106,
    5108,  5110,  5112,  5114,  5116,  5123,  5130,  5132,  5134,  5136,
    5138,  5140,  5142,  5144,  5146,  5148,  5150,  5152,  5154,  5156,
    5158,  5172,  5171,  5288,  5292,  5297,  5299,  5301,  5303,  5305,
    5307,  5312,  5314,  5316,  5318,  5320,  5325,  5329,  5331,  5333,
    5335,  5337,  5339,  5343,  5346,  5349,  5351,  5353,  5355,  5357,
    5359,  5361,  5364,  5367,  5369,  5371,  5373,  5375,  5377,  5380,
    5382,  5384,  5386,  5391,  5392,  5393,  5397,  5398,  5402,  5402,
    5408,  5412,  5419,  5450,  5452,  5454,  5456,  5458,  5460,  5462,
    5465,  5467,  5464,  5470,  5472,  5479,  5481,  5483,  5485,  5487,
    5489,  5491,  5493,  5495,  5498,  5497,  5512,  5511,  5526,  5532,
    5538,  5551,  5552,  5555,  5556,  5561,  5564,  5576,  5575,  5591,
    5592,  5593,  5594,  5595,  5596,  5597,  5598,  5599,  5600,  5601,
    5605,  5606,  5610,  5610,  5615,  5616,  5619,  5620,  5623,  5623,
    5628,  5629,  5632,  5633,  5636,  5637,  5640,  5646,  5656,  5657,
    5666,  5671,  5672,  5692,  5694,  5698,  5696,  5713,  5711,  5729,
    5727,  5734,  5743,  5741,  5759,  5758,  5768,  5779,  5777,  5796,
    5795,  5806,  5816,  5817,  5818,  5823,  5823,  5842,  5840,  5859,
    5881,  5929,  5928,  5951,  5969,  5951,  5976,  5980,  6006,  6007,
    6009,  6011,  6014,  6015,  6021,  6028,  6037,  6036,  6043,  6044,
    6048,  6052,  6056,  6062,  6070,  6079,  6080,  6081,  6082,  6083,
    6084,  6085,  6086,  6087,  6088,  6089,  6090,  6091,  6094,  6095,
    6096,  6097,  6098,  6099,  6100,  6101,  6102,  6106,  6107,  6108,
    6109,  6112,  6114,  6115,  6118,  6119,  6122,  6124,  6128,  6130,
    6129,  6143,  6146,  6145,  6160,  6166,  6179,  6181,  6184,  6186,
    6190,  6191,  6204,  6222,  6226,  6227,  6231,  6244,  6246,  6250,
    6249,  6281,  6283,  6287,  6288,  6289,  6294,  6300,  6304,  6305,
    6309,  6313,  6320,  6327,  6336,  6340,  6341,  6342,  6347,  6351,
    6359,  6360,  6361,  6362,  6363,  6364,  6368,  6369,  6370,  6371,
    6372,  6375,  6378,  6377,  6406,  6407,  6410,  6411,  6414,  6429,
    6429,  6439,  6440,  6444,  6456,  6489,  6488,  6501,  6500,  6509,
    6521,  6532,  6531,  6548,  6555,  6555,  6567,  6574,  6586,  6598,
    6602,  6608,  6618,  6619,  6622,  6630,  6631,  6635,  6636,  6644,
    6653,  6643,  6663,  6670,  6662,  6680,  6692,  6693,  6694,  6698,
    6699,  6702,  6703,  6706,  6715,  6716,  6717,  6719,  6718,  6728,
    6729,  6732,  6733,  6734,  6734,  6735,  6735,  6739,  6740,  6743,
    6745,  6748,  6756,  6757,  6761,  6762,  6767,  6766,  6779,  6780,
    6783,  6788,  6796,  6797,  6800,  6802,  6802,  6810,  6819,  6809,
    6841,  6842,  6845,  6852,  6853,  6856,  6865,  6866,  6872,  6871,
    6885,  6884,  6893,  6892,  6900,  6899,  6909,  6910,  6913,  6920,
    6933,  6934,  6938,  6939,  6942,  6943,  6944,  6947,  6957,  6959,
    6961,  6963,  6966,  6967,  6970,  6974,  6978,  6982,  6986,  6990,
    6994,  6998,  7002,  7010,  7013,  7022,  7021,  7035,  7043,  7052,
    7061,  7070,  7080,  7079,  7082,  7092,  7102,  7106,  7111,  7110,
    7115,  7125,  7130,  7136,  7141,  7146,  7148,  7150,  7152,  7154,
    7156,  7164,  7173,  7175,  7177,  7179,  7188,  7196,  7204,  7206,
    7208,  7218,  7225,  7231,  7239,  7247,  7251,  7255,  7262,  7269,
    7279,  7289,  7299,  7310,  7319,  7333,  7346,  7347,  7349,  7351,
    7354,  7355,  7358,  7359,  7362,  7363,  7366,  7367,  7370,  7371,
    7373,  7375,  7378,  7390,  7389,  7404,  7403,  7413,  7414,  7417,
    7418,  7422,  7423,  7424,  7432,  7431,  7443,  7444,  7447,  7447,
    7448,  7449,  7450,  7451,  7452,  7453,  7454,  7455,  7456,  7457,
    7460,  7461,  7465,  7464,  7473,  7474,  7477,  7478,  7479,  7483,
    7482,  7492,  7496,  7500,  7512,  7512,  7520,  7521,  7522,  7527,
    7537,  7536,  7552,  7570,  7581,  7588,  7598,  7569,  7603,  7612,
    7613,  7616,  7617,  7629,  7633,  7634,  7635,  7637,  7639,  7642,
    7643,  7646,  7651,  7658,  7663,  7669,  7671,  7674,  7675,  7678,
    7683,  7689,  7691,  7698,  7699,  7700,  7703,  7705,  7710,  7711,
    7716,  7717,  7723,  7728,  7730,  7732,  7737,  7739,  7750,  7763,
    7784,  7785,  7786,  7795,  7796,  7797,  7802,  7803,  7804,  7805,
    7806,  7820,  7834,  7835,  7836,  7839,  7840,  7841,  7842,  7850,
    7865,  7866,  7869,  7875,  7886,  7889,  7925,  7929,  7937,  7941,
    8009,  8024,  8048,  8049,  8065,  8075,  8078,  8079,  8080,  8084,
    8088,  8089,  8114,  8126,  8139,  8151,  8152,  8161,  8162,  8171,
    8172,  8173,  8176,  8189,  8202,  8216,  8217,  8218,  8219,  8220,
    8221,  8222,  8223,  8224,  8225,  8226,  8227,  8228,  8229,  8230,
    8231,  8232,  8233,  8234,  8235,  8236,  8237,  8238,  8239,  8240,
    8241,  8242,  8243,  8244,  8245,  8246,  8247,  8248,  8249,  8250,
    8251,  8252,  8262,  8263,  8264,  8265,  8266,  8267,  8268,  8269,
    8270,  8271,  8272,  8273,  8274,  8275,  8276,  8277,  8278,  8279,
    8280,  8281,  8282,  8283,  8284,  8285,  8286,  8287,  8288,  8289,
    8290,  8291,  8292,  8293,  8294,  8295,  8296,  8297,  8298,  8299,
    8300,  8301,  8302,  8303,  8304,  8305,  8306,  8307,  8308,  8309,
    8310,  8311,  8312,  8313,  8314,  8315,  8316,  8317,  8318,  8319,
    8320,  8321,  8322,  8323,  8324,  8325,  8326,  8327,  8328,  8329,
    8330,  8331,  8332,  8333,  8334,  8335,  8336,  8337,  8338,  8339,
    8340,  8341,  8342,  8343,  8344,  8345,  8346,  8347,  8348,  8349,
    8350,  8351,  8352,  8353,  8354,  8355,  8356,  8357,  8358,  8359,
    8360,  8361,  8362,  8363,  8364,  8365,  8366,  8367,  8368,  8369,
    8370,  8371,  8372,  8373,  8374,  8375,  8376,  8377,  8378,  8379,
    8380,  8381,  8382,  8383,  8384,  8385,  8386,  8387,  8388,  8389,
    8390,  8391,  8392,  8393,  8394,  8395,  8396,  8397,  8398,  8399,
    8400,  8401,  8402,  8403,  8404,  8405,  8406,  8407,  8408,  8409,
    8410,  8411,  8412,  8413,  8414,  8415,  8416,  8417,  8418,  8419,
    8420,  8421,  8422,  8423,  8424,  8425,  8426,  8427,  8428,  8429,
    8430,  8431,  8432,  8433,  8434,  8435,  8436,  8437,  8438,  8439,
    8440,  8441,  8442,  8443,  8444,  8445,  8446,  8447,  8448,  8449,
    8450,  8451,  8452,  8453,  8454,  8455,  8456,  8457,  8458,  8459,
    8460,  8461,  8462,  8463,  8464,  8465,  8466,  8467,  8468,  8469,
    8470,  8471,  8472,  8473,  8474,  8475,  8476,  8477,  8478,  8479,
    8480,  8481,  8482,  8483,  8484,  8485,  8486,  8487,  8488,  8489,
    8490,  8491,  8498,  8497,  8511,  8512,  8515,  8516,  8519,  8519,
    8596,  8597,  8598,  8599,  8603,  8604,  8608,  8609,  8610,  8611,
    8615,  8616,  8617,  8618,  8622,  8623,  8626,  8706,  8719,  8723,
    8728,  8735,  8750,  8763,  8784,  8791,  8829,  8872,  8886,  8887,
    8888,  8889,  8893,  8894,  8901,  8910,  8911,  8912,  8913,  8914,
    8922,  8921,  8937,  8938,  8941,  8942,  8945,  8953,  8954,  8955,
    8956,  8961,  8960,  8981,  8993,  9006,  9005,  9024,  9025,  9029,
    9030,  9034,  9035,  9036,  9037,  9039,  9038,  9049,  9050,  9051,
    9052,  9053,  9059,  9064,  9071,  9084,  9096,  9103,  9108,  9116,
    9129,  9143,  9145,  9148,  9149,  9156,  9158,  9162,  9163,  9166,
    9166,  9167,  9167,  9168,  9168,  9169,  9169,  9170,  9171,  9172,
    9173,  9174,  9175,  9176,  9177,  9178,  9179,  9180,  9181,  9182,
    9183,  9184,  9185,  9186,  9187,  9188,  9189,  9190,  9191,  9192,
    9197,  9198,  9202,  9203,  9207,  9217,  9227,  9240,  9255,  9268,
    9281,  9294,  9295,  9304,  9305,  9314,  9339,  9341,  9348,  9352,
    9355,  9356,  9359,  9380,  9381,  9385,  9389,  9393,  9400,  9401,
    9404,  9405,  9409,  9410,  9416,  9422,  9428,  9438,  9437,  9447,
    9448,  9452,  9453,  9454,  9458,  9459,  9460,  9464,  9465,  9469,
    9479,  9486,  9496,  9505,  9519,  9520,  9525,  9524,  9559,  9560,
    9561,  9565,  9565,  9589,  9590,  9594,  9595,  9596,  9600,  9605,
    9604,  9624,  9630,  9651,  9673,  9675,  9680,  9682,  9684,  9696,
    9706,  9719,  9721,  9723,  9728,  9733,  9735,  9737,  9743,  9744,
    9750,  9751,  9753,  9759,  9758,  9773,  9774,  9778,  9783,  9791,
    9791,  9809,  9818,  9831,  9832,  9834,  9836,  9849,  9847,  9924,
    9923,  9933,  9962,  9971,  9980,  9932, 10004, 10008, 10012, 10016,
   10020, 10024, 10030, 10037, 10044, 10053, 10054, 10058, 10059, 10060,
   10064, 10065, 10069, 10070, 10070, 10075, 10076
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM",
  "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED",
  "CAST_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONVERT_SYM",
  "CONVERT_TZ_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME", "DATABASE",
  "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FIELD_FUNC",
  "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM",
  "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM",
  "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2",
  "FUNC_ARG3", "GE", "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GEOMFROMTEXT", "GEOMFROMWKB", "GET_FORMAT",
  "GLOBAL_SYM", "GRANT", "GRANTS", "GREATEST_SYM", "GROUP",
  "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS", "GT_SYM", "HANDLER_SYM",
  "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM",
  "LANGUAGE_SYM", "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING",
  "LEAST_SYM", "LEAVES", "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD",
  "LOCAL_SYM", "LOCATE", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM",
  "LOGS_SYM", "LOG_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM",
  "LOOP_SYM", "LOW_PRIORITY", "LT", "MAKE_SET_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_POS_WAIT", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PURGE", "QUARTER_SYM",
  "QUERY_SYM", "QUICK", "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE",
  "RAID_STRIPED_SYM", "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL",
  "RECOVER_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "RENAME", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM",
  "RESTRICT", "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENNA_DELIMITED_SYM", "SENNA_KWIC_SYM", "SENNA_NGRAM_SYM",
  "SENNA_NORMALIZE_SYM", "SENNA_SECTIONALIZE_SYM", "SENNA_SPLIT_ALPHA_SYM",
  "SENNA_SPLIT_DIGIT_SYM", "SENNA_SPLIT_SYMBOL_SYM", "SENNA_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM",
  "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM",
  "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM",
  "STD_SYM", "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM",
  "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE", "TABLE_SYM",
  "TEMPORARY", "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGER_SYM", "TRIGGERS_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "UDF_SONAME_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM", "UNION_SYM",
  "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM",
  "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL",
  "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM", "BETWEEN_SYM",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "NEG",
  "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'", "';'", "':'",
  "$accept", "query", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "@1",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "@2",
  "change", "@3", "master_defs", "master_def", "master_file_def", "create",
  "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "create_function_tail", "@8", "@9", "@10", "@11", "@12", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@13",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@14", "@15", "sp_cursor_stmt",
  "@16", "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "opt_value", "sp_hcond", "sp_decl_idents", "sp_opt_default",
  "sp_proc_stmt", "@17", "@18", "@19", "@20", "@21", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "@22", "@23", "@24", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "@25", "@26",
  "searched_case_stmt", "@27", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@28", "@29",
  "searched_when_clause", "@30", "@31", "else_clause_opt",
  "sp_labeled_control", "@32", "sp_opt_label", "sp_unlabeled_control",
  "@33", "@34", "@35", "@36", "trg_action_time", "trg_event", "create2",
  "create2a", "@37", "create3", "@38", "@39", "create_select", "@40",
  "@41", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_func_type", "udf_type",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "@42", "type", "@43", "@44", "spatial_type",
  "char", "nchar", "varchar", "nvarchar", "int_type", "real_type",
  "float_options", "precision", "field_options", "field_opt_list",
  "field_option", "opt_len", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@45", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "opt_senna_list", "opt_senna_item", "key_list",
  "key_part", "opt_ident", "opt_component", "string_list", "alter", "@46",
  "@47", "@48", "@49", "@50", "ident_or_empty", "alter_list", "add_column",
  "alter_list_item", "@51", "@52", "@53", "opt_column", "opt_ignore",
  "opt_restrict", "opt_place", "opt_to", "slave", "@54", "@55", "start",
  "start_transaction_opts", "slave_thread_opts", "@56",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@57", "backup", "@58", "checksum", "@59",
  "opt_checksum_type", "repair", "@60", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@61", "check", "@62",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@63", "opt_no_write_to_binlog", "rename", "@64", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@65", "preload_list",
  "preload_keys", "cache_keys_spec", "@66", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@67", "select_part2", "@68", "@69", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "@70", "bool_or_expr", "bool_term", "@71", "bool_and_expr",
  "bool_factor", "bool_test", "bool_pri", "predicate", "bit_expr",
  "bit_term", "bit_factor", "value_expr", "term", "factor", "or", "and",
  "not", "not2", "comp_op", "all_or_any", "interval_expr", "simple_expr",
  "@72", "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@73", "udf_expr_list3", "udf_expr", "sum_expr", "@74",
  "@75", "@76", "variable", "@77", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@78",
  "cast_type", "opt_expr_list", "expr_list", "@79", "expr_list2",
  "ident_list_arg", "ident_list", "@80", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@81", "@82", "@83", "@84", "@85",
  "@86", "@87", "normal_join", "table_factor", "@88", "@89",
  "select_derived", "@90", "select_derived2", "@91", "@92",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@93", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@94", "having_clause", "@95", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@96", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@97", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@98",
  "select_var_list", "select_var_ident", "into", "@99", "into_destination",
  "@100", "do", "@101", "drop", "@102", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@103", "@104", "replace",
  "@105", "@106", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@107", "fields", "insert_values",
  "@108", "@109", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@110", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@111", "update", "@112", "@113",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@114", "single_multi", "@115", "@116",
  "@117", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "opt_profile_defs", "profile_defs", "profile_def", "opt_profile_args",
  "show", "@118", "show_param", "@119", "@120", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@121", "@122",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@123", "flush_options", "flush_option", "@124",
  "opt_table_list", "reset", "@125", "reset_options", "reset_option",
  "purge", "@126", "purge_options", "purge_option", "kill", "@127",
  "kill_option", "use", "load", "@128", "load_data", "@129", "@130",
  "@131", "@132", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@133", "opt_option", "option_value_list", "option_type_value",
  "@134", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@135",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@136", "handler", "@137", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@138",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@139", "@140", "@141",
  "@142", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@143", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@144",
  "union_opt", "union_order_or_limit", "@145", "order_or_limit",
  "union_option", "subselect", "@146", "subselect_init", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "view_or_trigger_or_sp_tail",
  "definer", "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@147", "view_list_opt",
  "view_list", "view_select", "@148", "view_select_aux",
  "view_check_option", "trigger_tail", "@149", "sp_tail", "@150", "@151",
  "@152", "@153", "@154", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@155",
  "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   124,    38,    45,    43,    42,    47,    37,    94,
     126,   827,    40,    41,    44,    33,   123,   125,    64,    46,
      59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   592,   593,   593,   594,   594,   595,   595,   595,   595,
     595,   595,   595,   595,   595,   595,   595,   595,   595,   595,
     595,   595,   595,   595,   595,   595,   595,   595,   595,   595,
     595,   595,   595,   595,   595,   595,   595,   595,   595,   595,
     595,   595,   595,   595,   595,   595,   595,   595,   595,   595,
     595,   595,   595,   596,   597,   597,   598,   599,   599,   601,
     600,   602,   602,   603,   603,   604,   606,   605,   608,   607,
     609,   609,   610,   610,   610,   610,   610,   610,   610,   610,
     610,   610,   610,   610,   611,   611,   611,   611,   613,   612,
     614,   612,   615,   612,   616,   612,   612,   617,   618,   618,
     619,   620,   621,   622,   623,   624,   619,   625,   625,   626,
     626,   627,   627,   627,   627,   627,   627,   627,   628,   628,
     628,   629,   629,   631,   630,   632,   632,   633,   633,   634,
     634,   635,   635,   636,   636,   637,   638,   639,   639,   640,
     640,   641,   642,   642,   642,   642,   643,   643,   644,   644,
     645,   645,   647,   646,   646,   648,   646,   646,   650,   649,
     651,   651,   652,   652,   653,   654,   654,   655,   655,   656,
     656,   656,   656,   656,   657,   657,   658,   658,   660,   659,
     661,   659,   662,   659,   659,   659,   663,   659,   659,   659,
     659,   664,   659,   659,   665,   665,   665,   666,   666,   668,
     669,   670,   667,   671,   671,   671,   672,   672,   674,   675,
     673,   677,   676,   678,   678,   679,   679,   681,   682,   680,
     684,   685,   683,   686,   686,   688,   687,   689,   689,   691,
     690,   690,   692,   693,   690,   694,   690,   695,   695,   696,
     696,   696,   697,   697,   697,   697,   698,   699,   698,   700,
     701,   700,   702,   700,   704,   705,   703,   706,   706,   707,
     707,   708,   708,   709,   709,   710,   710,   711,   711,   712,
     713,   713,   714,   714,   715,   715,   716,   716,   716,   717,
     717,   717,   717,   717,   717,   717,   717,   717,   717,   717,
     717,   717,   717,   717,   717,   717,   717,   717,   717,   717,
     717,   717,   718,   719,   720,   721,   721,   721,   721,   721,
     721,   722,   722,   722,   723,   723,   723,   724,   724,   725,
     725,   726,   726,   726,   726,   727,   727,   728,   728,   729,
     729,   730,   730,   730,   730,   730,   731,   731,   732,   733,
     733,   734,   736,   735,   737,   737,   737,   737,   737,   737,
     737,   737,   737,   737,   737,   737,   737,   737,   737,   737,
     737,   737,   737,   737,   737,   737,   737,   737,   737,   737,
     737,   737,   737,   737,   737,   737,   737,   737,   737,   738,
     737,   739,   737,   737,   737,   740,   740,   740,   740,   740,
     740,   740,   740,   741,   742,   742,   743,   743,   744,   744,
     744,   744,   744,   745,   745,   745,   745,   745,   746,   746,
     746,   747,   747,   747,   748,   749,   749,   750,   750,   751,
     751,   751,   752,   752,   753,   753,   754,   754,   755,   755,
     756,   756,   756,   756,   756,   756,   756,   756,   756,   756,
     756,   757,   757,   758,   758,   759,   759,   760,   760,   761,
     761,   762,   762,   763,   763,   764,   765,   765,   766,   766,
     767,   767,   768,   768,   768,   768,   768,   768,   769,   769,
     770,   770,   770,   770,   771,   771,   773,   772,   774,   774,
     775,   775,   776,   776,   777,   777,   778,   778,   778,   778,
     778,   779,   779,   779,   779,   779,   780,   780,   780,   781,
     781,   782,   782,   783,   783,   784,   784,   784,   785,   785,
     785,   785,   786,   786,   786,   787,   787,   787,   787,   788,
     788,   789,   789,   789,   789,   789,   789,   789,   789,   789,
     789,   789,   790,   790,   791,   791,   792,   792,   793,   793,
     794,   794,   796,   795,   797,   795,   798,   795,   799,   795,
     800,   795,   801,   801,   802,   802,   802,   802,   802,   803,
     804,   804,   804,   805,   804,   806,   807,   804,   804,   804,
     804,   804,   804,   804,   804,   804,   804,   804,   804,   804,
     804,   808,   808,   809,   809,   810,   810,   810,   811,   811,
     811,   812,   812,   812,   812,   814,   813,   813,   815,   813,
     813,   816,   817,   817,   819,   818,   820,   820,   821,   821,
     821,   822,   822,   823,   823,   825,   824,   827,   826,   829,
     828,   830,   830,   830,   832,   831,   833,   833,   834,   834,
     835,   835,   835,   837,   836,   839,   838,   840,   840,   841,
     841,   842,   842,   842,   842,   842,   842,   844,   843,   845,
     845,   845,   847,   846,   846,   848,   848,   849,   849,   850,
     851,   852,   852,   853,   854,   854,   856,   855,   857,   857,
     858,   860,   859,   861,   861,   862,   862,   863,   864,   864,
     865,   865,   867,   866,   869,   870,   868,   871,   871,   871,
     871,   871,   872,   872,   873,   873,   874,   874,   875,   875,
     875,   875,   875,   875,   875,   875,   875,   875,   876,   876,
     876,   877,   877,   877,   878,   879,   880,   881,   881,   882,
     882,   882,   882,   882,   883,   883,   885,   884,   886,   886,
     887,   888,   887,   889,   889,   890,   890,   891,   891,   891,
     891,   891,   891,   891,   892,   892,   892,   892,   892,   892,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   894,   894,   895,   895,   896,   896,
     896,   897,   897,   897,   897,   897,   898,   898,   898,   898,
     898,   898,   899,   899,   900,   900,   901,   901,   902,   902,
     903,   903,   904,   904,   904,   904,   904,   904,   905,   905,
     906,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   908,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,   907,   907,   907,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   910,   910,   910,   911,   911,   913,   912,
     914,   914,   915,   916,   916,   916,   916,   916,   916,   916,
     917,   918,   916,   916,   916,   916,   916,   916,   916,   916,
     916,   916,   916,   916,   919,   916,   921,   920,   922,   922,
     922,   923,   923,   924,   924,   925,   925,   927,   926,   928,
     928,   928,   928,   928,   928,   928,   928,   928,   928,   928,
     929,   929,   931,   930,   932,   932,   933,   933,   935,   934,
     936,   936,   937,   937,   938,   938,   939,   939,   940,   940,
     941,   942,   942,   943,   943,   944,   943,   945,   943,   946,
     943,   943,   947,   943,   948,   943,   943,   949,   943,   950,
     943,   943,   951,   951,   951,   953,   952,   954,   952,   952,
     952,   956,   955,   958,   959,   957,   960,   961,   962,   962,
     963,   963,   964,   964,   964,   964,   966,   965,   967,   967,
     968,   968,   968,   969,   969,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   972,   972,   972,
     972,   973,   973,   973,   974,   974,   975,   975,   976,   977,
     976,   978,   979,   978,   980,   980,   981,   981,   982,   982,
     983,   983,   983,   984,   985,   985,   986,   987,   987,   989,
     988,   990,   990,   991,   991,   991,   992,   992,   993,   993,
     994,   995,   995,   995,   996,   996,   996,   996,   997,   997,
     998,   998,   998,   998,   998,   998,   999,   999,   999,   999,
     999,  1000,  1001,  1000,  1002,  1002,  1003,  1003,  1004,  1006,
    1005,  1007,  1007,  1008,  1008,  1010,  1009,  1012,  1011,  1011,
    1011,  1014,  1013,  1015,  1016,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1017,  1017,  1018,  1019,  1019,  1020,  1020,  1022,
    1023,  1021,  1025,  1026,  1024,  1027,  1027,  1027,  1027,  1028,
    1028,  1029,  1029,  1030,  1031,  1031,  1031,  1032,  1031,  1033,
    1033,  1034,  1034,  1035,  1034,  1036,  1034,  1037,  1037,  1038,
    1038,  1039,  1040,  1040,  1041,  1041,  1043,  1042,  1044,  1044,
    1045,  1045,  1046,  1046,  1047,  1048,  1047,  1050,  1051,  1049,
    1052,  1052,  1053,  1054,  1054,  1055,  1056,  1056,  1058,  1057,
    1060,  1059,  1061,  1059,  1062,  1059,  1063,  1063,  1064,  1064,
    1065,  1065,  1066,  1066,  1067,  1067,  1067,  1068,  1069,  1069,
    1070,  1070,  1071,  1071,  1072,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1073,  1073,  1075,  1074,  1076,  1076,  1076,
    1076,  1076,  1077,  1076,  1076,  1076,  1076,  1076,  1078,  1076,
    1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,
    1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,
    1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,
    1076,  1076,  1076,  1076,  1079,  1079,  1080,  1080,  1081,  1081,
    1082,  1082,  1083,  1083,  1084,  1084,  1085,  1085,  1086,  1086,
    1087,  1087,  1087,  1089,  1088,  1090,  1088,  1091,  1091,  1092,
    1092,  1093,  1093,  1093,  1095,  1094,  1096,  1096,  1098,  1097,
    1097,  1097,  1097,  1097,  1097,  1097,  1097,  1097,  1097,  1097,
    1099,  1099,  1101,  1100,  1102,  1102,  1103,  1103,  1103,  1105,
    1104,  1106,  1107,  1107,  1109,  1108,  1110,  1110,  1110,  1111,
    1113,  1112,  1112,  1115,  1116,  1117,  1118,  1114,  1114,  1119,
    1119,  1120,  1120,  1120,  1121,  1121,  1121,  1122,  1122,  1123,
    1123,  1124,  1124,  1124,  1124,  1125,  1125,  1126,  1126,  1127,
    1127,  1128,  1128,  1129,  1129,  1129,  1130,  1130,  1131,  1131,
    1132,  1132,  1133,  1133,  1133,  1133,  1134,  1134,  1134,  1135,
    1136,  1136,  1136,  1137,  1137,  1137,  1137,  1137,  1137,  1137,
    1137,  1137,  1137,  1137,  1137,  1138,  1138,  1138,  1138,  1138,
    1139,  1139,  1140,  1140,  1141,  1142,  1142,  1143,  1143,  1144,
    1144,  1144,  1145,  1145,  1145,  1145,  1146,  1146,  1146,  1147,
    1148,  1148,  1149,  1150,  1151,  1152,  1152,  1153,  1153,  1154,
    1154,  1154,  1155,  1155,  1155,  1156,  1156,  1156,  1156,  1156,
    1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,
    1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,
    1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,
    1156,  1156,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1159,  1158,  1160,  1160,  1161,  1161,  1163,  1162,
    1164,  1164,  1164,  1164,  1165,  1165,  1166,  1166,  1166,  1166,
    1167,  1167,  1167,  1167,  1168,  1168,  1169,  1169,  1170,  1170,
    1170,  1170,  1170,  1170,  1170,  1171,  1171,  1171,  1172,  1172,
    1172,  1172,  1173,  1173,  1173,  1174,  1174,  1174,  1174,  1174,
    1176,  1175,  1177,  1177,  1178,  1178,  1179,  1180,  1180,  1180,
    1180,  1182,  1181,  1183,  1183,  1184,  1183,  1185,  1185,  1186,
    1186,  1187,  1187,  1187,  1187,  1188,  1187,  1189,  1189,  1189,
    1189,  1189,  1190,  1191,  1191,  1191,  1191,  1192,  1193,  1193,
    1193,  1194,  1194,  1195,  1195,  1196,  1196,  1197,  1197,  1199,
    1198,  1200,  1198,  1201,  1198,  1202,  1198,  1198,  1198,  1198,
    1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,
    1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,
    1203,  1203,  1204,  1204,  1205,  1205,  1205,  1206,  1206,  1206,
    1206,  1207,  1207,  1208,  1208,  1209,  1209,  1209,  1210,  1210,
    1211,  1211,  1212,  1213,  1213,  1213,  1213,  1213,  1214,  1214,
    1215,  1215,  1216,  1216,  1216,  1216,  1216,  1218,  1217,  1219,
    1219,  1220,  1220,  1220,  1221,  1221,  1221,  1222,  1222,  1223,
    1224,  1224,  1225,  1226,  1227,  1227,  1229,  1228,  1230,  1230,
    1230,  1232,  1231,  1233,  1233,  1234,  1234,  1234,  1235,  1236,
    1235,  1237,  1238,  1239,  1240,  1240,  1241,  1241,  1241,  1242,
    1242,  1243,  1243,  1243,  1244,  1245,  1245,  1245,  1246,  1246,
    1247,  1247,  1247,  1249,  1248,  1250,  1250,  1251,  1251,  1253,
    1252,  1254,  1254,  1255,  1255,  1255,  1255,  1257,  1256,  1259,
    1258,  1260,  1261,  1262,  1263,  1258,  1264,  1264,  1264,  1264,
    1264,  1264,  1265,  1265,  1265,  1266,  1266,  1267,  1267,  1267,
    1268,  1268,  1269,  1270,  1269,  1271,  1271
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       4,     0,     0,     0,     0,     0,    12,     0,     2,     0,
       2,     2,     2,     2,     2,     3,     3,     1,     1,     1,
       2,     3,     3,     0,     4,     0,     3,     0,     1,     3,
       1,     0,     1,     3,     1,     0,     3,     0,     1,     3,
       1,     4,     0,     1,     1,     1,     0,     3,     2,     3,
       0,     3,     0,     5,     5,     0,     7,     5,     0,     2,
       1,     1,     1,     3,     1,     1,     3,     0,     1,     1,
       1,     1,     2,     1,     1,     3,     0,     2,     0,     2,
       0,     3,     0,     5,     1,     1,     0,     2,     2,     2,
       2,     0,     6,     2,     0,     2,     1,     1,     3,     0,
       0,     0,     7,     0,     2,     2,     1,     1,     0,     0,
       8,     0,     6,     1,     2,     1,     2,     0,     0,     6,
       0,     0,     6,     0,     2,     0,     5,     0,     1,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     2,     2,     4,     4,     0,     4,     0,
       0,     5,     0,     7,     0,     0,     6,     0,     1,     0,
       1,     1,     2,     1,     1,     0,     1,     1,     2,     1,
       0,     3,     0,     1,     1,     2,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     1,     1,     3,     4,
       4,     3,     4,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     1,     1,     1,     1,     3,     1,     1,     2,
       2,     6,     7,     8,     2,     2,     0,     1,     2,     0,
       1,     2,     0,     4,     3,     3,     3,     1,     4,     1,
       1,     5,     2,     5,     2,     4,     1,     5,     5,     4,
       3,     1,     1,     2,     1,     1,     2,     1,     1,     1,
       2,     3,     2,     3,     2,     2,     3,     3,     3,     0,
       6,     0,     6,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     2,     1,
       2,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     3,     1,     5,     0,     1,     2,     1,     1,
       1,     1,     0,     3,     0,     1,     0,     1,     2,     1,
       1,     2,     2,     4,     1,     3,     2,     1,     2,     2,
       2,     2,     1,     2,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       0,     1,     0,     2,     1,     2,     3,     2,     0,     1,
       0,     1,     1,     2,     0,     1,     0,     4,     1,     4,
       3,     1,     0,     1,     2,     1,     3,     3,     2,     2,
       2,     1,     1,     2,     2,     2,     1,     2,     2,     2,
       2,     1,     1,     0,     1,     1,     1,     1,     0,     1,
       1,     1,     0,     2,     2,     1,     1,     1,     1,     1,
       3,     1,     2,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     4,     2,     1,     4,     0,     1,     0,     2,
       1,     3,     0,     6,     0,     5,     0,     5,     0,     5,
       0,    11,     0,     1,     0,     2,     2,     1,     3,     2,
       3,     2,     4,     0,     6,     0,     0,     8,     4,     4,
       3,     3,     2,     2,     6,     5,     3,     5,     1,     1,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     2,
       1,     0,     1,     1,     1,     0,     5,     3,     0,     5,
       3,     3,     0,     3,     0,     2,     1,     3,     0,     1,
       1,     0,     2,     1,     3,     0,     6,     0,     6,     0,
       5,     0,     1,     1,     0,     6,     0,     1,     1,     2,
       1,     1,     1,     0,     6,     0,     5,     0,     1,     1,
       2,     1,     1,     1,     1,     1,     2,     0,     6,     0,
       1,     1,     0,     4,     4,     3,     5,     1,     3,     3,
       5,     1,     3,     2,     1,     1,     0,     6,     1,     3,
       3,     0,     2,     0,     4,     0,     2,     1,     2,     4,
       2,     3,     0,     3,     0,     0,     6,     2,     1,     1,
       2,     2,     8,     4,     0,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       4,     3,     1,     1,     4,     0,     0,     1,     1,     0,
       2,     2,     1,     1,     0,     2,     0,     3,     0,     3,
       3,     0,     3,     0,     3,     2,     1,     3,     4,     3,
       4,     3,     4,     1,     3,     4,     3,     3,     6,     1,
       5,     6,     5,     7,     6,     8,     5,     6,     4,     4,
       5,     3,     4,     1,     3,     1,     3,     1,     3,     3,
       1,     3,     3,     4,     4,     1,     3,     3,     3,     3,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     3,     1,     1,     1,     1,     3,     2,     2,
       2,     2,     3,     3,     5,     6,     4,     4,     7,     4,
       2,     6,     5,     6,     6,     4,     4,     3,     4,     6,
       8,     6,     8,     6,     4,     6,     4,     6,     4,     4,
       4,     4,     6,     8,     2,     2,     4,     2,     7,     7,
       3,     4,     4,     6,     6,     4,     6,     6,     6,     4,
       6,     4,     6,     8,    10,    12,     6,     4,     6,     6,
       1,     6,     4,     8,    10,     4,     1,     3,     4,     6,
       6,     8,     6,     6,     4,     6,     6,     8,     4,     4,
       6,     4,     2,     4,     4,     4,     6,     4,     4,     3,
       8,     6,     4,     6,     3,     4,     6,     8,     4,     8,
       6,     8,     6,     8,     2,     4,     4,     4,     6,     8,
       8,     4,     7,     7,     7,     6,     6,     6,     6,     6,
       6,     0,     5,    10,     3,     4,     3,     2,     2,     2,
       4,     6,     4,     4,     6,     6,     6,     6,     4,     6,
       4,     6,     4,     4,     4,     4,     6,     4,     6,     4,
       6,     4,     4,     6,     4,     6,     4,     6,     4,     4,
       6,     4,     6,     0,     3,     3,     0,     1,     0,     2,
       1,     3,     4,     4,     5,     4,     4,     4,     5,     4,
       0,     0,     7,    10,     4,     5,     4,     5,     4,     4,
       4,     4,     4,     5,     0,     8,     0,     3,     3,     1,
       4,     0,     1,     0,     2,     0,     1,     0,     3,     2,
       3,     2,     1,     2,     1,     2,     1,     1,     1,     2,
       0,     1,     0,     2,     1,     3,     1,     3,     0,     2,
       1,     3,     0,     1,     0,     2,     4,     5,     1,     1,
       1,     1,     3,     3,     3,     0,     6,     0,     6,     0,
       8,     4,     0,     8,     0,    10,     6,     0,     8,     0,
      10,     6,     1,     2,     2,     0,     4,     0,    11,     3,
       6,     0,     3,     0,     0,     5,     0,     1,     0,     1,
       0,     2,     0,     2,     2,     2,     0,     6,     0,     1,
       3,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     0,     2,     0,     1,     0,     0,
       3,     0,     0,     3,     2,     0,     0,     4,     4,     2,
       0,     2,     2,     3,     3,     1,     2,     0,     1,     0,
       4,     4,     2,     0,     1,     1,     0,     1,     0,     1,
       2,     1,     3,     3,     1,     1,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     0,     6,     0,     1,     3,     1,     2,     0,
       2,     3,     1,     2,     1,     0,     3,     0,     5,     2,
       1,     0,     3,     6,     0,     6,     4,     4,     4,     4,
       5,     4,     1,     3,     1,     0,     2,     0,     1,     0,
       0,     8,     0,     0,     6,     0,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     3,     4,     0,     3,     3,
       1,     2,     2,     0,     3,     0,     5,     3,     1,     3,
       1,     3,     1,     1,     0,     1,     0,     4,     0,     1,
       3,     1,     1,     1,     0,     0,     6,     0,     0,    11,
       3,     1,     3,     3,     1,     3,     0,     1,     0,     4,
       0,     6,     0,     5,     0,     6,     1,     3,     3,     5,
       0,     2,     0,     2,     1,     1,     1,     3,     0,     1,
       0,     1,     1,     3,     1,     1,     2,     2,     2,     1,
       1,     1,     1,     0,     3,     0,     3,     2,     4,     4,
       4,     4,     0,     4,     6,    16,     2,     2,     0,     6,
       5,     2,     2,     2,     1,     5,     5,     2,     2,     1,
       4,     3,     2,     2,     2,     3,     2,     2,     2,     1,
       1,     3,     4,     3,     3,     2,     2,     3,     3,     3,
       3,     3,     3,     4,     1,     1,     1,     1,     0,     1,
       0,     2,     0,     1,     1,     1,     0,     2,     0,     2,
       0,     2,     2,     0,     4,     0,     4,     1,     1,     0,
       1,     0,     1,     1,     0,     4,     3,     1,     0,     3,
       4,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     0,     3,     3,     1,     1,     1,     2,     0,
       3,     3,     2,     2,     0,     4,     0,     1,     1,     2,
       0,     4,     5,     0,     0,     0,     0,    18,     2,     0,
       1,     0,     1,     1,     0,     1,     1,     0,     2,     2,
       1,     3,     4,     3,     3,     0,     2,     2,     1,     3,
       3,     0,     3,     0,     3,     2,     3,     1,     1,     2,
       0,     2,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     3,     5,     1,     1,     1,     1,     1,     3,
       4,     5,     1,     5,     3,     2,     1,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     4,     0,     1,     1,     3,     0,     2,
       1,     1,     1,     1,     0,     1,     0,     1,     1,     1,
       0,     2,     2,     2,     1,     2,     4,     5,     4,     6,
       2,     3,     3,     3,     5,     1,     3,     3,     2,     2,
       2,     1,     1,     4,     4,     1,     1,     1,     1,     1,
       0,     4,     1,     1,     1,     3,     3,     1,     1,     2,
       2,     0,     3,     4,     3,     0,     7,     1,     2,     1,
       1,     1,     1,     1,     1,     0,     5,     1,     1,     1,
       1,     1,     3,     6,     6,     6,     7,     3,     8,     8,
       8,     0,     1,     1,     2,     0,     1,     1,     3,     0,
       3,     0,     3,     0,     3,     0,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     3,     2,     2,     2,     2,     2,     2,     2,     2,
       0,     1,     3,     1,     2,     2,     2,     1,     3,     3,
       1,     1,     3,     1,     3,     4,     5,     1,     0,     3,
       3,     1,     1,     0,     2,     2,     2,     2,     0,     2,
       2,     1,     2,     2,     2,     2,     2,     0,     3,     0,
       1,     0,     3,     2,     0,     1,     2,     0,     1,     4,
       4,     5,     2,     3,     0,     1,     0,     4,     0,     1,
       1,     0,     2,     2,     1,     0,     1,     1,     4,     0,
       7,     1,     0,     0,     2,     3,     1,     1,     1,     0,
       3,     1,     2,     1,     2,     3,     3,     3,     0,     1,
       0,     3,     3,     0,     8,     0,     3,     1,     3,     0,
       2,     3,     5,     0,     3,     4,     4,     0,    14,     0,
       6,     0,     0,     0,     0,    12,     4,     4,     3,     4,
       3,     2,     1,     3,     5,     1,     1,     0,     1,     1,
       0,     2,     0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       0,     2,  2028,   649,     0,  1977,     0,     0,     0,     0,
       0,  1979,    94,    54,  1288,  1397,  1398,  1211,  1227,     0,
     649,    97,     0,    66,  1229,  1434,     0,     0,   649,     0,
    1429,     0,     0,   649,  1232,  1422,     0,    97,  1979,     0,
     684,  1814,  1325,     0,     0,     0,  1308,  1871,  1277,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   677,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1399,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   552,     0,   584,
       0,     0,  2029,  2019,   651,   650,     0,  1863,  1862,   617,
    1979,     0,  1582,  1583,  1584,  1585,  1586,  1587,  1588,  1546,
    1589,  1590,  1591,  1547,  1548,  1592,  1593,  1594,  1595,  1597,
    1596,  1598,  1549,  1550,  1599,  1600,  1601,  1551,  1552,  1602,
    1603,  1553,  1604,  1605,  1606,  1554,  1607,  1555,  1608,  1609,
    1610,  1611,  1612,  1556,  1613,  1614,  1615,  1616,  1617,  1618,
    1619,  1557,  1620,  1621,  1622,  1623,  1639,  1624,  1558,  1625,
    1626,  1627,  1640,  1559,  1630,  1629,  1628,  1631,  1632,  1633,
    1560,  1634,  1635,  1636,  1637,  1642,  1643,  1644,  1561,  1638,
    1645,  1641,  1797,  1647,  1646,  1648,  1650,  1649,  1562,  1651,
    1563,  1652,  1653,  1530,  1654,  1531,  1656,  1657,  1660,  1661,
    1655,  1662,  1663,  1658,  1659,  1564,  1665,  1666,  1667,  1668,
    1669,  1670,  1671,  1681,  1674,  1676,  1677,  1679,  1675,  1680,
    1684,  1683,  1685,  1686,  1687,  1682,  1673,  1678,  1688,  1689,
    1672,  1690,  1691,  1692,  1693,  1694,  1695,  1696,  1697,  1698,
    1700,  1699,  1701,  1702,  1703,  1704,  1705,  1707,  1706,  1708,
    1709,  1710,  1712,  1711,  1713,  1565,  1714,  1715,  1716,  1717,
    1718,  1566,  1719,  1720,  1721,  1722,  1723,  1724,  1725,  1567,
    1726,  1727,  1728,  1729,  1730,  1731,  1732,  1733,  1734,  1735,
    1736,  1737,  1738,  1739,  1740,  1741,  1742,  1743,  1664,  1744,
    1568,  1745,  1746,  1569,  1747,  1570,  1748,  1749,  1571,  1750,
    1751,  1752,  1753,  1754,  1755,  1572,  1756,  1573,  1757,  1758,
    1759,  1760,  1762,  1761,  1763,  1765,  1766,  1574,  1764,  1575,
    1767,  1768,  1769,  1771,  1770,  1772,  1773,  1576,  1774,  1577,
    1775,  1776,  1777,  1778,  1779,  1780,  1781,  1782,  1783,  1784,
    1785,  1786,  1787,  1790,  1791,  1792,  1793,  1788,  1789,  1578,
    1794,  1795,  1796,  1798,  1799,  1579,  1800,  1801,  1581,  1802,
    1803,  1806,  1804,  1805,  1807,  1808,  1809,  1810,  1580,  1811,
     123,  1535,    99,  1536,  1545,     0,   619,   635,  1980,  1981,
     270,   510,   511,   269,   509,    97,  2019,     0,   266,   267,
       0,  1302,  1032,  1225,  1225,     0,  1225,  1228,  1225,    97,
    1225,     0,    59,  1404,     0,     0,     0,     0,  1529,     0,
    1235,  1436,  1440,     0,     0,  1860,     0,     0,     0,     0,
      97,   652,     0,  1286,     0,   615,     0,  1981,  1992,   678,
     682,   694,  1815,  1812,  1382,   604,   604,   604,   602,   604,
    1309,     0,     0,  1286,  1439,  2065,     0,     0,     0,  2061,
       0,  2066,     0,   684,     0,     0,     1,     3,     0,  1635,
    1395,  1393,  1526,     0,   544,   553,   548,   546,     0,     0,
    2030,   633,     0,  1978,     0,   661,   671,   125,     0,    68,
       0,     0,     0,  1984,     0,     0,     0,     0,    95,   319,
    2019,  2021,  2023,   270,   268,     0,  1306,  1305,  1304,     0,
    1302,  1212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1225,    61,     0,  1905,  1920,  1921,  1917,  1922,  1923,
    1927,     0,  1919,  1911,     0,  1926,  1915,  1924,     0,  1909,
       0,  1925,  1930,  1913,  1918,  1897,     0,  1903,  1907,  1528,
    1131,  1874,  1875,     0,  1541,  1532,  1540,  1539,    67,  1237,
    1238,  1236,   583,  1437,  1438,     0,  1451,     0,     0,     0,
     647,     0,  1377,  1376,     0,  1430,  1993,     0,     0,   624,
    1240,  1287,     0,  1239,  1427,     0,  1426,  1423,  1425,     0,
    1905,  1892,     0,  1987,  1984,  1994,   707,   700,   699,   702,
     703,   706,   704,   705,   701,   698,   715,   695,   697,  1818,
       0,     0,   444,     0,  1390,     0,     0,     0,  1390,     0,
    1166,  1383,     0,  1827,  1360,   507,   506,     0,   505,  1828,
    1359,  1376,     0,     0,     0,  1344,     0,  1310,  1349,     0,
    1829,     0,  1379,     0,  1166,  1390,     0,  1326,     0,     0,
       0,     0,   598,   608,   600,   595,     0,   601,   597,  1307,
    1224,  1872,   583,  1488,  1487,  1533,  2062,  1486,  2070,  2072,
    2058,  2060,  2067,   680,     0,  1998,    53,     0,  1401,  2026,
    2027,  2025,   460,   107,   107,   542,     0,     0,     0,     0,
       0,  1222,     0,     0,   663,   673,   127,   124,    98,     0,
     621,   637,  1983,     0,     0,  1985,  1989,   789,   788,     0,
      92,   724,  1542,  1957,    96,  1953,  2024,   320,   715,   715,
     715,  2014,     0,  2016,  2017,  2018,  2030,  2022,     0,   512,
       0,  1289,  1292,  1296,  1300,  1303,  1583,  1546,     0,  1591,
       0,     0,  1499,     0,     0,     0,     0,  1551,     0,     0,
    1605,     0,     0,  1556,     0,     0,     0,   724,   724,   724,
       0,     0,     0,  1618,  1619,  1508,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1496,     0,  1509,     0,
       0,     0,     0,     0,     0,     0,  1647,     0,     0,  1648,
       0,     0,     0,  1498,  1653,     0,     0,     0,     0,     0,
       0,     0,  1668,     0,     0,  1506,     0,     0,  1038,     0,
    1695,  1697,     0,     0,     0,  1701,     0,     0,  1702,  1703,
    1704,  1483,   791,     0,   724,  1495,  1505,  1716,  1722,  1489,
       0,  1724,     0,  1725,     0,  1732,     0,     0,     0,     0,
       0,     0,  1754,  1756,     0,     0,     0,  1777,     0,     0,
       0,   724,  1790,  1791,  1792,  1793,     0,  1497,  1578,  1507,
       0,     0,     0,  1802,   724,   724,   724,     0,     0,     0,
    1808,     0,  1811,  1042,     0,     0,     0,     0,   790,     0,
    1006,     0,  1034,   726,   731,   736,   743,   749,   763,   765,
     767,   770,   775,   781,     0,   876,   783,   870,   806,   805,
    1033,  1493,   804,   803,  1494,   801,  1516,  1535,  1482,  1515,
    1226,  1216,  1217,     0,  1218,  1221,  1951,  1219,   585,     0,
       0,    60,  1418,  1412,  1414,  1417,  1413,     0,  1419,  1416,
    1415,  1863,  1405,  1407,  1408,  1906,  1904,  1938,  1937,     0,
    1939,  1935,  1928,  1958,  1932,  1958,  1934,  1933,  1958,  1929,
    1936,  1958,  1901,     0,  1132,  1133,     0,  1873,     0,  1527,
       0,  1435,  1452,     0,  1453,  1441,  1449,   666,     0,  1131,
    1861,  1864,     0,     0,    56,    57,     0,   654,     0,   653,
     657,     0,     0,     0,  1243,  1233,  1242,  1428,     0,     0,
    1904,  1901,  1988,     0,  1990,  2005,   683,  1995,   713,   685,
     712,     0,   696,  1813,  1816,  1824,  1358,  1386,   443,     0,
       0,  1357,  1341,     0,   270,     0,     0,     0,     0,  1327,
    1332,   304,     0,  1348,  1167,     0,  1390,     0,  1352,  1365,
    1353,     0,  1380,     0,  1390,  1322,     0,     0,  1314,  1319,
    1315,     0,  1321,  1320,  1323,  1311,  1312,  1380,  1337,  1366,
    1380,  1342,  1347,  1356,  1384,  1385,     0,  1336,  1343,     0,
    1354,  1380,  1380,  1390,  1390,   611,   610,   609,   605,   606,
     611,     0,  1075,     0,     0,  2059,  2073,  2057,  2068,  2069,
    2056,   681,  1999,   679,  2000,     0,  1396,  1394,  1402,  1403,
     461,   545,   460,   261,   264,   263,     0,   549,   547,   460,
    2020,     0,     0,   637,     0,     0,   665,   660,   664,   662,
     502,   501,   504,     0,   672,     0,   128,   130,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    69,    70,    83,   623,   622,   620,   645,
     644,   642,     0,   643,   641,   636,   638,   639,  1982,  1986,
     271,   460,     0,  1544,     0,     0,     0,     0,     0,     0,
       0,  2015,    88,     0,     0,     0,  1294,  1290,  1300,     0,
       0,     0,  1131,     0,     0,     0,  1136,     0,   820,  1136,
    1136,  1136,     0,     0,  1032,  1032,     0,  1032,     0,     0,
       0,     0,  1136,   844,   847,     0,   845,     0,     0,     0,
       0,     0,  1502,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1032,     0,     0,     0,     0,  1011,     0,     0,
       0,     0,   800,     0,     0,     0,     0,  1032,     0,     0,
       0,     0,  1038,     0,  1036,     0,  1136,     0,     0,  1136,
       0,     0,     0,     0,     0,  1032,  1032,  1032,   735,     0,
     892,     0,     0,     0,     0,     0,  1032,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1032,  1136,  1136,
       0,     0,     0,  1136,     0,   914,     0,  1504,     0,     0,
       0,  1503,     0,     0,  1501,  1500,  1484,     0,     0,     0,
     937,   939,   938,  1136,     0,  1136,     0,     0,     0,  1043,
       0,   809,   808,   810,  2012,     0,     0,     0,     0,     0,
       0,     0,   728,   733,   792,     0,   793,   794,     0,   795,
     796,   797,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   811,  1106,  1107,  1108,  1109,  1118,  1121,  1110,  1111,
    1112,  1120,  1113,  1114,  1115,  1122,  1123,  1124,  1116,  1125,
    1119,  1117,  1126,     0,  1105,     0,     0,     0,  1485,   931,
       0,  1214,     0,   587,   586,  1220,   585,     0,    62,    64,
    1411,     0,     0,  1420,  1931,     0,  1912,  1916,  1910,  1914,
       0,     0,  1902,     0,  1908,  1135,  1643,  1711,     0,  1138,
    1877,  1230,  1448,  1450,     0,     0,  1442,     0,     0,   637,
      58,     0,     0,  1431,     0,     0,     0,     0,   626,  1241,
       0,  1424,     0,     0,     0,     0,     0,  1991,  2007,  2006,
    1996,   715,  1157,   716,   718,   717,  1515,  1818,  1821,  1822,
    1825,  1823,     0,  1820,  1819,  1834,     0,  1388,  1391,  1392,
       0,     0,  1368,  1367,  1363,  1364,     0,  1176,  1177,  1175,
    1170,  1171,  1174,  1372,  1370,  1361,     0,  1390,     0,  1371,
    1369,  1316,  1317,  1318,     0,  1166,     0,  1390,  1390,  1380,
       0,  1390,  1390,  1351,  1355,     0,   599,   608,   596,   603,
    1087,  1086,     0,  1051,     0,  1050,  1049,  1048,     0,  1086,
    2063,  2071,  2075,     0,  1166,  2004,  2002,   262,  1264,  1264,
       0,     0,     0,     0,     0,     0,     0,   108,   117,   581,
     581,  1264,  1264,   581,  1264,  1264,  1264,     0,     0,  1264,
       0,     0,   581,     0,  1264,   579,     0,     0,  1264,  1264,
    1264,   581,     0,  1264,  1264,  1264,  1264,  1264,   591,  1264,
    1264,  1264,   578,   274,   296,   297,   543,     0,   557,   580,
    2031,  2032,   550,   634,   618,  1223,     0,   126,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   646,   640,    93,   725,  1543,
       0,  1954,  2051,     0,     0,  2033,   272,   515,  1184,  1185,
     517,  1181,  1182,     0,  1180,   516,   528,   529,   523,   530,
     525,   526,   527,   521,  1183,   514,   518,   519,   531,   513,
       0,     0,  1138,     0,  1297,  1075,  1301,  1300,  1298,     0,
       0,     0,  1137,  1136,     0,  1017,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     990,     0,  1017,     0,   850,     0,     0,     0,     0,     0,
       0,  1515,     0,     0,     0,     0,     0,  2012,     0,     0,
       0,     0,     0,     0,   827,     0,     0,     0,     0,     0,
       0,     0,  1129,  1127,  1130,  1128,     0,     0,  1012,  1004,
       0,     0,     0,     0,   877,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1039,  1040,  1136,     0,
       0,     0,  1136,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   899,     0,     0,     0,     0,     0,   904,     0,     0,
       0,     0,     0,     0,     0,     0,  1136,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   934,
       0,   936,     0,     0,  1518,  1517,     0,     0,     0,     0,
       0,  1044,   684,     0,   813,  1032,   812,     0,  1830,  1007,
    1009,     0,   730,   727,   732,   746,   739,   744,   737,   741,
       0,   798,  1588,   747,     0,     0,  1145,   761,     0,     0,
     764,     0,     0,     0,     0,   766,   768,   769,   772,   876,
     771,   876,   779,   780,   776,   777,   778,   782,     0,   802,
     807,  1035,   978,  1519,  1215,  1952,  1213,    65,     0,     0,
    1406,  1421,  1409,  1962,     0,  1961,  1947,  1950,  1526,     0,
       0,     0,  1887,  1881,  1888,  1890,  1884,  1889,  1891,  1882,
    1883,  1878,  1885,  1139,  1168,     0,     0,   667,   668,   671,
       0,  1867,  1868,  1866,  1865,   648,  1433,  1432,     0,   655,
     658,   659,   631,   630,   632,   625,   627,   628,   254,  1247,
       0,     0,     0,  1253,  1234,  1244,   616,     0,     0,     0,
       0,     0,   711,  1075,  1205,   708,   689,  1168,  1158,   688,
     719,     0,  1817,     0,  1788,  1845,     0,     0,     0,     0,
       0,  1835,  1387,     0,  1338,     0,  1362,  1375,  1374,  1333,
       0,     0,     0,  1331,  1381,     0,  1350,  1313,  1373,  1330,
    1138,  1380,  1328,  1329,   613,   612,   607,  1086,  1075,     0,
       0,  1072,  1088,     0,  1088,  1075,  1075,     0,  1075,  1131,
    1083,     0,     0,  2074,  1159,  2003,  1262,  1263,  1265,     0,
       0,   111,   114,   112,     0,   113,     0,     0,   582,   536,
     503,   503,   561,     0,   336,   536,   496,   559,     0,     0,
       0,     0,     0,     0,     0,     0,  1264,     0,   572,   555,
       0,     0,     0,     0,   573,     0,   556,  1264,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   594,   593,
     592,     0,     0,     0,     0,   275,   460,   339,     0,   588,
     336,   342,  1522,  2035,  1102,     0,  1101,   129,    76,    72,
      84,  1189,  1190,  1188,  1186,  1187,    85,    74,    75,    79,
      78,    80,    81,    82,    77,    73,    86,    87,    71,     0,
    1955,     0,   238,   237,     0,  2049,  2035,     0,   339,    89,
    1454,   273,   276,   524,   522,     0,    90,  1075,  1157,  1300,
    1138,     0,  1131,     0,   819,   834,     0,     0,   983,     0,
       0,   985,   986,   987,     0,   838,     0,   836,   839,   840,
     841,  1032,     0,     0,     0,     0,  1032,   989,     0,   846,
       0,     0,   851,   852,     0,   825,     0,   859,     0,   861,
       0,  1032,     0,   855,     0,   816,     0,     0,  1032,     0,
     867,     0,   828,     0,     0,   969,     0,   952,   948,     0,
     950,     0,     0,  1032,  1032,     0,   872,     0,     0,   878,
    1032,     0,   971,     0,   953,     0,   884,     0,  1032,     0,
    1037,     0,     0,     0,   996,   888,   889,     0,   994,   955,
       0,     0,   891,   957,     0,   959,     0,   954,   961,   962,
     893,   895,   894,   964,     0,     0,   966,     0,   968,     0,
     897,   898,     0,     0,     0,   902,     0,  1032,   908,   905,
     998,  1000,     0,     0,     0,     0,     0,  1002,   915,   917,
       0,     0,     0,   916,     0,     0,     0,     0,     0,     0,
       0,   921,     0,     0,   935,  1001,   826,   999,   940,     0,
     943,     0,   942,     0,     0,     0,     0,  2011,  2013,     0,
       0,   817,     0,     0,     0,     0,     0,  1520,   785,   784,
       0,   787,   786,     0,   740,   745,   738,   742,     0,     0,
       0,     0,   759,   758,     0,     0,  1145,   762,     0,   774,
     773,   875,     0,   977,   715,  1032,     0,    63,  1410,  1959,
       0,     0,     0,     0,     0,     0,     0,     0,  1876,  1169,
    1274,  1534,  1443,     0,   675,  1869,  1870,     0,   629,   694,
       0,  1266,  1251,  1258,  1252,     0,     0,     0,  1250,  1511,
    1510,  1517,  1994,     0,     0,     0,     0,  1997,  1138,  1138,
    1199,     0,     0,   686,   691,   687,   690,     0,   714,   723,
     722,  1512,  1519,     0,     0,     0,     0,   446,   448,   447,
     456,     0,   445,     0,     0,  1830,     0,   452,   454,   453,
    1840,   451,  1389,  1166,  1346,  1345,  1173,  1172,     0,  1324,
    1340,  1390,     0,  2001,  1081,     0,  1074,  1073,  1089,     0,
    1075,  1088,  1088,     0,  1054,  1053,  1278,  1281,     0,  1052,
    1092,  1079,   694,  2064,  2076,     0,   459,   458,   303,   455,
     302,   116,   115,   121,   122,   341,   537,   497,   498,     0,
       0,     0,   503,   335,   536,   334,   337,   512,     0,   286,
     283,   563,   289,   285,   301,     0,     0,   290,   536,   570,
     571,   585,   279,     0,   315,   316,   314,   298,   281,   282,
     565,  1153,  1155,  1163,   288,   287,   284,   293,   294,   312,
     311,   292,   313,   576,   310,   308,   305,   307,   306,   309,
     291,   280,     0,   558,     0,   325,   327,   328,  1525,     0,
     590,   560,     0,   329,   330,     0,     0,     0,     0,   674,
       0,  1956,  2052,   241,   239,   240,     0,     0,     0,   244,
       0,   242,     0,     0,  1456,  1455,   243,   257,   460,   277,
     520,     0,  1138,  1178,  1293,  1299,     0,     0,     0,   984,
    1018,     0,   422,   422,  1028,  1026,   411,   422,  1022,  1027,
    1024,     0,     0,     0,     0,     0,     0,     0,   991,   988,
       0,     0,     0,  1519,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1015,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   973,  1041,   997,   995,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1003,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1045,   822,  2008,  2009,   814,  1831,  1832,  1833,   538,
    1008,   729,   734,     0,   752,  1032,   750,  1144,   756,     0,
       0,   760,     0,   932,     0,   979,   980,     0,  1031,  1521,
    1960,  1949,  1948,  1963,  1963,  1963,     0,  1140,     0,  1231,
    1454,   669,     0,   670,   656,   715,  1248,  1260,     0,  1268,
       0,     0,  1245,  1255,     0,     0,     0,  1254,     0,  1894,
    1895,  1893,  1168,  1146,     0,     0,  1210,     0,  1206,   709,
       0,   721,   720,     0,  1847,     0,  1846,  1858,  1859,  1856,
    1857,  1855,  1836,     0,  1842,  1841,     0,     0,     0,  1852,
    1843,     0,     0,  1339,     0,  1334,   614,     0,  1075,  1088,
    1075,  1061,     0,     0,  1075,  1057,  1055,  1059,     0,  1138,
       0,     0,     0,     0,  1076,   715,  1514,  1160,  1163,   338,
     536,   499,   500,   512,     0,     0,     0,     0,   456,   299,
     569,   568,   300,     0,     0,  1164,  1165,  1156,     0,   562,
     339,   589,   476,   407,   356,   347,   422,   350,   349,   393,
     364,   361,   411,   409,   379,   411,   411,   386,   385,   403,
     389,   369,   462,   462,   368,   406,   462,   390,   388,   392,
       0,   394,   411,   399,   387,   391,   408,   384,   381,   405,
     422,   422,   362,   365,   404,   462,     0,   397,   422,   426,
     367,   462,   468,     0,     0,   422,   424,  1524,  2037,     0,
    2039,  1100,   142,   715,     0,   101,  2050,  2039,     0,   247,
     272,   258,     0,   278,     0,  1295,     0,  1291,   800,   831,
     835,   945,     0,  1019,   462,     0,  1029,   413,  1021,  1023,
    1025,   821,   837,   842,   947,   824,   823,     0,     0,     0,
       0,   857,   860,   862,   853,   858,   856,     0,   946,   869,
     866,   868,   829,     0,   970,   949,   951,   871,   882,  1013,
    1016,     0,     0,     0,   883,   879,   972,   880,     0,   885,
     854,   886,     0,     0,     0,     0,   956,   890,   958,   960,
     965,   963,   967,   896,   833,     0,   901,   903,   815,   800,
     906,     0,   912,   910,     0,     0,   918,     0,     0,   927,
       0,   925,     0,   926,     0,   928,   929,     0,   941,   944,
    1046,     0,  1994,     0,  1010,   748,     0,   754,  1032,   751,
     757,   716,   715,   930,     0,  1968,  1968,  1968,  1273,  1272,
       0,  1271,  1275,     0,   676,   255,     0,     0,     0,  1269,
    1257,  1998,  1246,  1249,  1519,  1896,   693,     0,  1141,  1209,
    1207,     0,  1200,  1202,  1204,     0,  1513,     0,     0,  1851,
    1837,   457,     0,     0,     0,     0,  1838,     0,  1131,  1082,
       0,     0,  1048,  1075,  1075,     0,  1048,     0,     0,     0,
    1280,  1157,  1282,  1090,  1094,  1095,  1093,  1084,     0,  1162,
       0,     0,     0,   575,     0,   588,   577,   426,  1154,   295,
     326,   482,     0,     0,   366,   415,   410,     0,   415,   415,
     468,   470,   464,   468,     0,   375,   393,   370,     0,   462,
     383,   374,   395,   398,   400,   402,   415,     0,   462,   363,
     372,     0,   415,   434,     0,     0,     0,   430,     0,   475,
       0,   437,   343,   427,   429,     0,     0,   396,     0,   352,
     469,     0,   354,     0,     0,   415,     0,   425,   415,     0,
    2036,     0,  2043,     0,   145,   143,   144,     0,   138,   140,
     135,     0,   323,   324,   322,   321,     0,   131,  2043,   245,
    1998,  1454,     0,   250,     0,  1163,   534,  1179,     0,     0,
    1020,     0,     0,   992,   848,   849,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   818,     0,     0,
       0,     0,     0,     0,     0,   924,   922,   923,     0,  1047,
    2013,   539,   753,     0,   719,   981,     0,     0,  1967,  1965,
       0,  1966,  1964,  1940,     0,  1899,  1900,  1898,  1886,     0,
       0,  1444,  1168,  1259,  1261,  1267,  1256,     0,  1142,  1157,
    1457,  1203,     0,   710,  1849,  1848,  1850,  1844,     0,     0,
       0,     0,  1080,  1075,  1062,     0,  1066,  1071,  1067,     0,
    1058,  1056,     0,  1178,     0,  1096,  1168,  1163,     0,     0,
       0,     0,     0,     0,     0,     0,   574,  1490,   564,   566,
       0,     0,     0,   477,   478,   483,   485,     0,     0,   419,
     420,   421,   376,   416,   418,     0,   378,   346,   463,   471,
     472,     0,   467,   465,   468,   371,   401,   377,     0,   373,
       0,   360,   440,   439,   724,   432,   442,     0,     0,   438,
     428,   436,   431,     0,     0,     0,     0,   344,     0,   345,
    1523,  2038,     0,   551,   715,   715,  2040,  2053,   142,     0,
       0,     0,     0,   132,   134,   135,  2034,   248,   246,     0,
    1994,    91,     0,   533,     0,   832,   423,   412,     0,   843,
     863,     0,   830,  1014,  1005,  1136,   873,     0,   881,   887,
     975,   974,   900,   907,   911,   909,   913,   919,   920,  1032,
    2010,   755,   982,  1946,  1945,  1944,  1941,     0,     0,     0,
       0,     0,     0,  1969,  1971,  1270,     0,     0,   256,   708,
     317,  1150,  1163,     0,  1168,     0,  1465,  1201,  1854,  1853,
    1839,     0,     0,     0,     0,     0,     0,     0,  1103,  1279,
    1091,     0,  1085,  1161,     0,     0,   331,  1492,  1491,   588,
     488,   489,   490,     0,     0,     0,   481,   484,   355,   348,
     417,     0,   540,   473,   466,     0,   359,   441,   724,   435,
     462,   468,   462,   468,     0,     0,     0,   684,     0,   109,
     139,     0,   715,   100,   102,     0,     0,   252,   251,  1163,
       0,     0,     0,     0,     0,     0,  1942,  1972,  1975,  1973,
    1974,  1976,  1970,     0,     0,   318,     0,     0,  1147,  1149,
    1143,  1191,     0,     0,     0,     0,  1458,  1460,     0,  1208,
       0,  1077,  1063,     0,  1068,     0,  1060,     0,  1098,     0,
     332,   567,   492,     0,   491,     0,   486,   487,   482,     0,
     462,     0,   462,   433,   351,   353,   357,   358,     0,  2044,
       0,  2041,     0,  2054,   141,     0,     0,   133,   136,  1998,
     532,   535,   414,   864,     0,   993,   874,   933,  1276,  1284,
       0,  1445,  1151,  1152,  1163,     0,   692,     0,     0,     0,
       0,  1459,     0,     0,  1466,  1468,     0,     0,     0,     0,
    1104,     0,  1099,   333,   494,   495,   493,   479,   480,   380,
     541,   382,  2045,  2046,  1998,   119,   118,   110,     0,   178,
       0,   103,   253,     0,     0,     0,   449,  1148,  1192,  1463,
    1464,     0,  1461,     0,     0,  1467,     0,     0,  1065,  1070,
    1097,  2042,   120,     0,   194,   182,     0,     0,     0,   180,
     208,  2055,     0,     0,   184,   206,   207,   185,  1537,     0,
    1538,  2047,     0,   865,  1283,  1285,     0,  1446,     0,  1462,
    1470,  1469,     0,  1078,   193,   196,     0,     0,   199,   189,
     188,   190,     0,     0,     0,   179,   229,   178,   178,   232,
     187,   225,   178,   104,   450,  1457,   715,     0,   195,     0,
       0,     0,   181,   209,   220,   223,   215,   150,   178,     0,
     178,     0,     0,  2048,   109,  1465,     0,     0,  1195,  1197,
       0,   191,     0,     0,     0,     0,   178,   216,     0,   146,
       0,     0,   148,   235,     0,   227,   105,  1471,  1198,  1193,
     715,  1335,     0,   183,   200,   217,   223,   213,   221,   178,
       0,     0,   178,     0,   231,   149,     0,   233,   226,   228,
     178,     0,  1473,  1196,   192,   197,   178,     0,   214,     0,
       0,   212,   161,   160,     0,   152,   174,   230,     0,   151,
       0,   178,   106,     0,     0,  1480,     0,   178,   218,     0,
     178,     0,     0,     0,     0,     0,   147,     0,   178,  1472,
    1475,     0,     0,  1477,  1478,     0,  1447,   198,   203,     0,
     210,   178,   155,   175,   176,     0,   158,   236,     0,  1479,
    1474,     0,  1481,   199,   178,   202,   178,     0,     0,   153,
     167,   154,   165,   157,     0,   234,  1476,   204,   178,   178,
     173,   171,   178,   162,   169,   164,     0,   170,   177,   168,
       0,   159,     0,   156,   172,   166,   163
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   984,    58,   532,
     931,  1398,  1399,    59,   429,    60,   709,  1143,  1144,  1145,
      61,  1616,  2501,  1161,   406,   424,   390,  2806,  3077,  3446,
    3542,  3594,  3640,  1107,  3443,  1537,  3497,  1538,    62,   497,
     707,  1125,  1126,  3252,  3253,  3249,  3254,  3067,  3068,  3069,
    3070,  3632,  3588,  3609,  3633,  3673,  3707,  3713,  3714,  3654,
    3722,  3723,  3724,  3730,  3725,  3655,  3709,  3589,  3532,  3562,
    3558,  3533,  3622,  3557,  3644,  3580,  3581,  3646,  3688,  3705,
    3534,  3535,  3563,  3604,  3536,  3564,  3626,  3585,  3627,  3647,
    3689,  3586,  3605,  3650,  3608,  3537,  3592,  3638,  3570,  3587,
    3591,  3661,  3636,  2074,  2486,  2079,  2491,  3080,  2496,  3260,
    3449,  1903,  2309,  3142,  2812,  1101,  1102,  1103,   407,   408,
     409,   505,  2080,  1572,  2081,  2082,  1574,  1575,  1030,  2460,
    2451,  2437,  3308,   730,  3076,  2464,  2465,  2466,  2467,  2415,
    2416,  1993,  1994,  2040,  2475,  2789,  3007,  3027,  2790,  2791,
    2792,  2793,  2794,  2795,  2796,  2826,  2827,  3202,  3203,  3204,
    2823,  3058,  3042,  3043,  3044,  3225,  3014,  2349,  2350,  3547,
    2359,  2360,  2397,  2684,  2398,  1106,  3015,  3052,  3212,  3045,
    2474,  3001,  3193,  3345,  3194,  3195,  3196,  3426,  1995,  2414,
    1122,  1123,   656,   410,  1175,  1635,  1636,  1637,  3084,  3085,
    2405,  2914,  3351,    63,  1109,   692,   694,   693,  2043,   484,
    1576,  1577,  1578,  2727,  2733,  3339,  1997,   111,  1395,  2471,
    2031,    64,  1080,  1075,    65,   667,   662,   663,  1078,  1079,
    1506,  1955,    66,   599,    67,   492,    68,   500,  1148,    69,
     992,  1895,  1896,  1897,    70,   699,    71,   501,  1155,  1156,
    1157,    72,   982,   116,    73,   588,   987,   989,   990,    74,
     494,   495,  1117,    75,  1425,  1877,  1878,   704,   705,  1124,
    2643,    76,    77,   475,   449,   605,   450,   451,  1452,  1915,
    3309,   616,   617,   618,  2333,  1009,  1010,  1011,  1920,  1453,
    2338,  1163,  2929,  1332,  1803,   893,  1333,  1804,   894,   895,
     896,   897,   898,   899,   900,   901,   902,   903,  2260,  2263,
    3046,   904,  1342,  1814,   905,   906,  1842,   907,  2875,  2282,
    2283,  2284,  2625,  2626,   908,  2116,  2838,  2154,   909,  1329,
    1799,  1709,  3099,  2859,  1654,  2099,  2521,  2627,   521,   522,
     910,  1253,  1254,  1255,  1726,  1320,  2246,  1791,  1513,  1514,
    1515,  1516,  2978,  2977,  2979,  3323,  3165,  3325,  3169,  1966,
    1517,  1518,  3477,  2373,  2698,  2391,  2392,  3176,  1957,  1519,
    2379,  3175,  2714,  2984,  3331,  3481,  2045,  3327,  1383,  1384,
    1706,   966,   967,  1655,  1874,  2297,  3149,  3313,  2272,  2948,
    3311,  3398,  1579,  2441,  2442,  1917,  1918,  2395,  2717,  2737,
    1033,  3310,  2299,  1480,  1481,  2817,  1638,  2056,  3466,  3548,
    3597,  3598,  3599,  2666,  2667,  2952,  2953,  1919,  2330,  2668,
    3150,    78,   412,    79,  1844,   700,   701,   524,   421,    80,
     430,  1875,    81,   443,  1440,   572,   592,   995,   996,  1904,
    2310,  2317,  1905,  2322,  2941,  2312,  2646,  2647,  1978,  1979,
    2313,  2649,  2938,  2930,  2931,  2639,  3140,    82,   463,  2709,
    2386,  2387,  3458,  3459,   593,    83,   411,   741,  1642,  1180,
    1641,   742,   743,  1182,   519,   520,    84,   461,  1054,  1055,
    1056,  1495,    85,   454,   657,  1476,  2363,  1939,   584,   659,
    1487,   660,  1488,  1467,  1934,  1021,    86,   688,   687,    87,
     480,  1097,    88,   533,   942,   943,  1403,  1852,    89,   444,
     597,   598,    90,   438,   585,  1433,    91,   431,   575,    92,
      93,   576,   975,  2640,  3307,  3506,  3575,  1424,   976,  2497,
    3316,  3406,  3407,  3409,  3474,  3475,  3642,  3665,  3682,  3683,
    3686,   911,   676,   912,  3186,   913,   914,  2318,  2319,  2718,
     915,  3460,   916,  2041,   670,   427,   917,   566,   918,  2302,
     919,  3539,   722,   723,   393,   394,    94,   619,   453,  1013,
    1014,  1015,  1462,  1463,   661,  2255,  1464,  1465,  1931,  1926,
    2960,  2690,  2682,    95,   579,   944,   980,   981,  1883,    96,
     462,    97,   968,  1419,  1420,  1871,  2296,  1872,    98,   601,
      99,   555,  1413,   556,   946,   557,   558,   958,   953,   961,
     955,  3297,  3132,  3133,  1859,   927,   724,   725,  1406,  1854,
    1855,  2925,  3135,  3303,  3304,   100,   120,   399,   503,   716,
    1003,   101,   102,   103,   104,  1006,  1092,  1911,  1093,  1094,
    1095,  1526,  1450,  1327,  2912,  2248,  1793,  2603,   508,   731,
     490,   510,   511,   112,   113,   732,   733,  2076,  2478,  2799,
    3062,  3063,  3246,  3243,   734,  3572,   735,  2487,  2071,  2802,
    3369,  3499,   105,   678,   472,  1090,  1085,  1087,  1522,  1973
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3257
static const int yypact[] =
{
    3714, -3257,   173,    34,   728, -3257,   193, 43340,    78,   728,
     728,  -219,   531, -3257, -3257, -3257, -3257, -3257,   718, 43340,
      34, -3257, 21462, -3257, -3257, -3257,   230,   728,    34, 43340,
   -3257,   131,   823,    34, -3257, -3257,   728, -3257,  -219, 43340,
   -3257,   473, -3257,   413,   716,   405,   349, -3257, -3257, 43340,
     240,  -161,   870,   908, -3257, -3257,   661, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, 22024, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257,   913, 43340, 43340, -3257,
   43340,   609, -3257,   964, -3257, -3257,   728, -3257, -3257, -3257,
    -219, 21462, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257,   533, -3257, -3257,   680, -3257, -3257, -3257,  1210,
    1049, -3257, -3257, -3257, -3257, -3257,   395,   788, -3257,   798,
    1084,    67, -3257,  1097,  1097, 43340,  1097, -3257,  1097, -3257,
    1097,   728, -3257, -3257,  1553, 43340,   985,   181,  -136, 38309,
     740,   184, -3257,  1088, 21462, -3257,   728,  1161,   232, 43340,
   -3257, -3257,   728,   164,    22, -3257,  2206,    93, -3257, -3257,
   -3257,   339, -3257, -3257,  3314, -3257, -3257, -3257,   787, -3257,
   -3257, 21462,   728,  1076, -3257, -3257,   175,   175,   175, -3257,
     175, -3257,   175, -3257,  -161,   769, -3257, -3257, 43340,   433,
   -3257, -3257,   775,   637, -3257, -3257, -3257, -3257, 21462,  1226,
     905, -3257, 21462, -3257,   -14, -3257, -3257,   802, 43340, -3257,
   21462, 21462,   198,     8,   561, 43340, 36073,   984, -3257,    98,
     964,  1388, -3257,  1049, -3257, 43340, -3257, -3257, -3257, 39986,
      67, -3257, 13441,  1250, 43340, 43340,  1061, 43340, 43340, 36073,
   21462,  1097,   871,  1368,  1046,  1011,  -121, -3257, -3257, -3257,
   -3257,  1091, -3257, -3257,   955, -3257, -3257, -3257,   211, -3257,
      47, -3257, -3257, -3257, -3257, -3257,  1105,   868, -3257, -3257,
     117, -3257, -3257, 43340, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257,  1243, -3257, -3257, 13441,   216,  1416,  1295, 21462,
   -3257,  -209, -3257, -3257,  1209, -3257, -3257, 36073, 21462, -3257,
   -3257, -3257, 19204, -3257, -3257,  1438, -3257,   903, -3257, 21462,
    1046, -3257,  1145,  1068,     8,   971, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257,   916,   339, -3257, -3257,
    1237,  1360, -3257,  1077,   -19,  1031,   976,    55,   -19, 38309,
    1300, -3257,   111, -3257,  1390, -3257, -3257,  1085, -3257, -3257,
   -3257,  1089,  1092,  1284,  1090, -3257,   126,   151, -3257,  1099,
   -3257,   326, -3257,   315,  1300,   -19,   147, -3257,  1325,  1453,
     190,  -120, -3257,   816, -3257, -3257,  1523, -3257, -3257, -3257,
   -3257, -3257,  1243, -3257, -3257, -3257,  1021, -3257,  1262,  1125,
   -3257, -3257,    51, -3257,  1040,   -29, -3257,   462, 36632, -3257,
   -3257, -3257,    84, -3257, -3257, -3257, 36073,  1191,  1079, 21462,
     613, -3257, 40545, 21462, -3257,    11, 13441, -3257, -3257,  2421,
     159,    85, -3257,  1573,  1228, -3257, -3257, -3257, -3257,  1485,
   -3257,  1057,  1059,  1441,  1070, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257,  1121, -3257, -3257, -3257,   905, -3257, 21462,  -175,
   21462, -3257,  1100, -3257,  1102, -3257,  1104,  1106,  1119,  1127,
    1151, 16366, -3257,  1155,  1157,  1178,  1180,  1183,  1185,  1186,
    1190,  1192,  1193,  1196,  1198,  1199,  1201,  1057,  1057,  1202,
    1203,  1204,  1206,   729,  1207, -3257,  1213,  1215,  1217,  1218,
    1221,  1222,  1223,  1224,  1227,  1231, -3257,  1232, -3257,  1236,
    1238,  1244,  1247,  1249,  1252,  1253,  1254,  1255,  1256,  1257,
    1258,  1263,  1266, -3257,  1267,  1269,  1270, 13441,  1272,  1273,
    1275,  1276,  1279,  1281,  1282, -3257,  1283,  1285,  1288,  1289,
    1291,  1292,  1293,  1294,  1296,  1299,  1301,  1302,  1303,  1304,
    1305, -3257, -3257, 13441,  1306, -3257, -3257,  1307,  1309, -3257,
    1310,  1311,  1315,  1316,  1318,  1321,  1322,  1323,  1326,  1327,
    1328,  1329,  1330,  1333,  1334,  1335,  1337,  1342,  1343,  1344,
    1345,  1347,   755,  1348,  1349,   768,  1350, -3257,  1354, -3257,
     182,  1355,  1356,  1357,  1057,  1057,  1057,  1358,  1361,  1362,
    1363,  1366,  1369, 13441, 16366, 16366, 16366,  8761, -3257, 43340,
   -3257, 43340, -3257,  1141, -3257, -3257,  1370, -3257,   754,  1101,
     689,   594,   100,  1128, 16366,   938,   419, -3257, -3257, -3257,
    1187,  1346, -3257, -3257, -3257, -3257, -3257,  1374, -3257,  1184,
   -3257, -3257, -3257, 21462, -3257, -3257, -3257,  1235,    91, 21462,
    1220, -3257, -3257, -3257, -3257, -3257, -3257,  1744, -3257, -3257,
   -3257,  1264,  1240, -3257, -3257, -3257, -3257, -3257, -3257,  1398,
   -3257, -3257, -3257,  1375, -3257,  1375, -3257, -3257,  1375, -3257,
   -3257,  1375,   591,  2361, -3257, -3257, 43340, -3257, 43899, -3257,
   19204, -3257, -3257,  1538, -3257, -3257,  1608, -3257,  1590,   134,
    1377, -3257, 21462, 38309, -3257, -3257,   114,  1379,  1400,  1380,
   -3257,  1443, 21462, 21462, -3257, -3257, -3257, -3257,    22,   156,
    1382,   605, -3257, 43340, -3257,   846, -3257, -3257, -3257,  1383,
   -3257, 13441, -3257,  1384, -3257,   930, -3257,  1723, -3257,  1460,
   13441, -3257, -3257,  1393,  1049, 43340, 43340, 21462, 21462, -3257,
   -3257, -3257,   518, -3257, -3257, 43340,   -19, 36073, -3257, -3257,
   -3257,  1798,   147, 43340,   -19, -3257,  1745,  1486, -3257, -3257,
   -3257,  1817, -3257, -3257,  1806,  1395, -3257,   147, -3257, -3257,
     147, -3257, -3257, -3257, -3257, -3257, 21462, -3257, -3257,   147,
   -3257,   147,   147,   -19,   -19,  1448, -3257, -3257,  1397, -3257,
    1448,  1528,   386,   175,  1622, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257,    87, -3257, -3257, -3257, -3257,
   -3257, -3257,   116, -3257, -3257, -3257,  1239,   832,   832,  1495,
   -3257,   186, 21462,    85,  1460, 21462, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257,  1404, -3257,  1407,  1403, -3257,  1848,  1850,
    1851,  1852,  1853,  1855,  1856,  1864,  1867,  1871,  1872,  1873,
    1874,  1880,  1882,  1439, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257,  1494, -3257, -3257, -3257, -3257,  1108, -3257, -3257,
   -3257,    84,  1446, -3257, 38309,  1987, 36073, 43340, 43340,  1854,
   21462, -3257, -3257,  1627,  1627,  1690,  1100, -3257,    96, 43340,
    1860, 25953,   127, 13441, 13441, 13441,   873,   744,  1972,  2025,
    2025,  2025, 13441, 13441, -3257, -3257, 13441, -3257, 13441, 13441,
   13441, 13441,   940, -3257, -3257,  9346, -3257,  1455, 13441, 13441,
    1541, 13441,  1346, 13441, 13441, 22586, 13441, 13441, 13441, 13441,
   13441,   513, 13441,   938, 13441, 13441, 13441,  1458, 13441, 13441,
   13441, 13441, -3257, 13441, 13441,   266, 13441,  1918,   794, 13441,
   13441, 13441, -3257,  9931, 13441, 13441, 13441, -3257, 13441, 13441,
   13441, 13441, -3257,  2035, -3257, 22586,  1017, 13441, 13441,  1026,
   13441, 13441, 13441, 13441, 13441, -3257, -3257, -3257, -3257,  9346,
   -3257, 13441, 13441, 13441, 13441, 13441, -3257, 16366, 13441, 10516,
   13441, 13441, 13441, 13441,  1462, 13441, 13441, -3257,  2025,  2025,
   13441, 13441, 13441,  1066,  9346, -3257, 13441,  1346,   747,   747,
   13441,  1346,  7591, 13441, -3257, -3257, -3257,   794, 11101,  1463,
   -3257, -3257, -3257,  2025, 22586,  2025, 13441, 13441, 13441, -3257,
    1493,  1972,  1972,  1972, -3257,  8761,   721,  1465, 13441, 23710,
    1461, 13441, -3257, -3257, -3257, 16366, -3257, -3257,   251, -3257,
   -3257, -3257, 14026,  1467, 16366, 16366,  1799, 16366, 16366,   545,
   16366, 16366, 16366, 16366, 16366, 16366, 16366, 16366, 16366, 16366,
   16366,  1972, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257,  1478, -3257, 38309, 16366, 13441, -3257, -3257,
   43340, -3257, 36073, -3257, -3257, -3257,    91, 38309,  1471, -3257,
   -3257,  1666,  1368, 21462, -3257, 43340, -3257, -3257, -3257, -3257,
   19766, 19766, -3257, 19766, -3257, -3257,   104,   109,  1385,  1502,
   -3257, -3257, -3257, -3257,  1841, 21462, -3257,   -22, 21462,    85,
   -3257, 13441,  1460, -3257, 36073, 36073, 21462, 21462,   171, -3257,
     753, -3257,  1460,  1875, 19766, 19766, 19766, -3257, -3257, -3257,
   -3257, -3257,   118, -3257, -3257, -3257,  1479, -3257, -3257, -3257,
   -3257, -3257, 41104,   144, -3257, -3257,  1460,  1894, -3257, -3257,
    1489, 43340, -3257, -3257, -3257, -3257,   482, -3257, -3257, -3257,
   -3257,   -23, -3257, -3257, -3257, -3257,  1619,   -19, 43340, -3257,
   -3257, -3257, -3257, -3257,  1693,  1300,   151,   -19,   -19,   147,
   21462,   -19,   -19, -3257, -3257,   627, -3257,   816, -3257, -3257,
   -3257, -3257, 43340,   892,  1630,  1492, -3257, -3257, 21462, -3257,
    1496, -3257,  1906,  2036,  1300, -3257, -3257, -3257,   305,   305,
    1460,  1612,  1613,  1614,  1617,  1620,  1660, -3257, -3257,   263,
    2024,   305,   305,  2024,   305,   305,   305,  1586,  1974,   305,
    1861,  1604,   743,  1866,   305, -3257,  1611,  1979,   305,   305,
     305,  2024,  2062,   305,   305,   305,   305,   305,   135,   305,
     305,   305, -3257,  3260, -3257, -3257,  1524, 20328, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, 41663, -3257, 13441,   744,
    1460,  1460,   239,  1460,   744,  1460,  1460,  1460,  1460,  1460,
     744,  1460,  1460,   744,  2421, -3257, -3257, -3257, -3257, -3257,
     435, -3257, -3257,   847, 43340, -3257,  1878, -3257, -3257, -3257,
   -3257, -3257, -3257,   849, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257,  1525, -3257, -3257,
   21462,  1571,  1502, 25953, -3257,   386, -3257,  1522, -3257,  1529,
    1531,   785, -3257,  2025,  1532, -3257,  1533,  1535,  1537,  1540,
    2094,  1542,  -223,  1543,  1544,  1546,  1547,  1548,  -211,  1549,
   -3257,  1551,  1545,  1555, -3257,  1556,  1561,  1564,  1565,  1566,
    1568,  1527,   804,   811,  1569,  1572,   839, -3257,  1574,  1575,
    1949,  1576,  1577,   841, -3257,  1579,  1580,  1582,   878,  1584,
     882,   891, -3257, -3257, -3257, -3257,  1585,  1587, -3257, -3257,
    -204,  1589,  1591,  1593, -3257,  1595,  1598,  1599,   895,  1596,
    1600,   899,  1602,  1605,  1607,  1557,  1609, -3257,  2025,  1615,
    1618,  1621,  2025,  1623,   929,  1610,  1624,   937,   941,  1625,
    1626,  1628,  1629,  1631,  1632,   945,  1616,   948,  1634,   172,
    1637, -3257,  1638,  1640,  1641,  1642,   950, -3257,  1643,  1639,
    1645,  1646,  1648,  1649,   158,  1650,  2025,  1652,  1654,   952,
    1657,  1658,  1655, 11686, 12271, 12856,    63,  1659,  -194, -3257,
    1662, -3257,  1663,  1664, -3257,  1527,  1667,   956,   959,  1668,
   13441,   286, -3257,   513, -3257, -3257, -3257,  1581,   604, -3257,
    1709, 43340, -3257,   801,  1308, -3257, -3257, -3257, -3257, -3257,
     621, -3257,  1592, -3257,  1606,  8761,   724,  1601, 16366,    80,
    1101,  1670, 16366, 16366, 16366,   689,   594,   594,   100,   938,
     100,   938,  1128,  1128,  1128,  1128,  1128,  1972, 13441, -3257,
    1972, -3257,  1671,   657, -3257, -3257, -3257, -3257,  1220,  1896,
   -3257,  1665, -3257, -3257,   961, -3257,  1603, -3257,  1669,  1656,
    1684,  1688, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257,  1300,   753,  1698,  1672, -3257, -3257,
    1644,  1939, -3257, -3257, -3257, -3257, -3257, -3257,  1695, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257,   389, -3257, -3257,
    1673,  1673, 18075, -3257, -3257, -3257, -3257,  1883,  2084,  2086,
    2089,   462, -3257,   143, -3257,   967,  1984,  1300, -3257,  2092,
   38868, 26514, -3257,  1679,  2037,  1680,   305, 34396,   773, 24269,
   34955, -3257, -3257,   239, -3257,    43, -3257, -3257, -3257, -3257,
     518,   518,  1714, -3257, -3257,  1934, -3257, -3257, -3257, -3257,
    1502,   147, -3257, -3257, -3257,  1689, -3257, -3257,   386,  2038,
    2039, -3257,  1921,    52,  1921,   386,   386, 22586,   386,  1597,
   -3257,   744,  1975, -3257, -3257, -3257, -3257, -3257, -3257, 37191,
   35514, -3257, -3257, -3257,  2181, -3257,  2184,   191, -3257, 23148,
     585,   585, -3257,    90,   178, 23148, -3257, -3257, 23148,   239,
     744, 23148,   744,  1460,  1460,  1286,   305,   744, -3257, -3257,
    2043,  2044, 23148, 23148, -3257, 38309, -3257,   305,   174,   239,
     239, 23148, 22586,   722,  1460,   744,   744,   711, -3257, -3257,
   -3257, 21462,  1188, 38309,  1702, -3257,  2910, 17513, 43340,   765,
     274, -3257,  1700,  1708, -3257,  1002, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,  1793,
   -3257,  1710, -3257, -3257,    82, -3257,  1708, 21462, 16951, -3257,
     120, -3257,  2285, -3257, -3257,  1242, -3257,   386,  1942,   108,
    1502,  1719,   127, 14611, -3257, -3257, 13441,  1715, -3257, 13441,
   13441, -3257, -3257, -3257,   250, -3257, 37750, -3257, -3257, -3257,
   -3257, -3257, 13441, 37750,   250, 13441, -3257, -3257,  1716, -3257,
    2072,  2072, -3257, -3257,  1346, -3257, 43340, -3257, 13441, -3257,
   13441, -3257,  1346, -3257, 13441, -3257, 13441, 13441, -3257,  1964,
   -3257, 13441, -3257, 13441, 13441, -3257, 13441, -3257, -3257, 13441,
   -3257, 13441, 13441, -3257, -3257,  1966, -3257, 13441, 13441, -3257,
   -3257, 13441, -3257, 13441, -3257, 13441, -3257, 13441, -3257, 13441,
   -3257, 16366, 22586,  1722, -3257, -3257, -3257,  1724, -3257, -3257,
   13441, 13441, -3257, -3257, 13441, -3257, 13441, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, 13441, 13441, -3257, 13441, -3257, 13441,
   -3257, -3257, 13441, 13441, 13441, -3257, 13441, -3257, -3257, -3257,
   -3257, -3257, 15196, 13441, 13441, 13441,  1727, -3257, -3257, -3257,
   13441, 13441, 13441, -3257, 13441,  2131, 13441,  2136, 13441,  2137,
   13441, -3257, 13441,  1976, -3257, -3257, -3257, -3257, -3257, 13441,
   -3257, 13441, -3257,  1746, 13441, 13441,  2172, -3257, -3257,  1737,
    1739, -3257,  1734,  1735,  1736, 38309, 13441, -3257, -3257, -3257,
   13441, -3257, -3257, 13441, -3257, -3257, -3257, -3257,   513,  1010,
    1748, 16366, -3257,  1601, 16366,  8761,   724,  1601,    86, -3257,
   -3257, -3257,  1749, -3257, -3257,  1750, 43340, -3257, -3257, -3257,
   43340,  1751, 27075, 36073, 36073, 36073,  1747, 13441, -3257, -3257,
    1990, -3257, -3257, 21462,  2123, -3257, -3257, 36073, -3257,   339,
   22586, -3257,  1755, -3257,  1755,  -145,  1760,  1014, -3257, -3257,
   -3257,  1756,   971,  2169, 36073, 36073, 36073, -3257,  1502,  1502,
     132,  1814,  2121, -3257, -3257, -3257, -3257, 42222, -3257, -3257,
   -3257, -3257,   676, 43340,  2101, 43340,  8176, -3257, -3257, -3257,
    2288, 13441, -3257, 36073,   529,   604,   305, -3257, -3257, -3257,
   -3257, -3257, -3257,  1300, -3257, -3257, -3257, -3257,  2079, -3257,
   -3257,   -19,   627,   351, -3257,  1037, -3257, -3257, -3257,  2119,
     386,  1921,  1921,  2122,  2015,   -66,  1776, -3257,   305,   892,
      25, -3257,   339, -3257, -3257, 13441, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, 13441,
    2125,  2126,   585, -3257, 23148, -3257, -3257,  -175,   282, -3257,
   -3257, -3257, -3257, -3257, -3257, 35514,  1460, -3257, 23148, -3257,
   -3257,   168, -3257,  1460, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257,  1777, -3257,   300, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, 21462, -3257,  1020, -3257, -3257, -3257, -3257, 43340,
   -3257, -3257, 21462, -3257, -3257,  5253, 43340, 43340,  2347, -3257,
   43340, -3257, -3257, -3257, -3257, -3257,  2022,  -113,  2349, -3257,
   21462, -3257,  1785,  1028, -3257, -3257, -3257,  2352,  2851, -3257,
   -3257,  1789,  1502,  2120, -3257, -3257, 13441,  1792,  1794, -3257,
   -3257,  1796,  1790,  1790, -3257, -3257,  1800,  1790,  2153, -3257,
    2156,  1801,  1802,  1803,  1804,  1807,  1808,  1805, -3257, -3257,
     938,   938,  1809,  1811,  1810,  1812,  1818,  1819,  1821,  1822,
    1825,  1826,  1827,  1828,  1829,  1830,  1832,  1833,  1834,  1839,
    1843,  1942,  1840,  1846,  1849,  1863,  1869,  1870,  1033,  1876,
    1881,  1038,   226, -3257, -3257, -3257,  1884,  1888,  1889,  1891,
    1892,  1895,  1898,  1899,  1902,  1879,  1903,  1904,  1905, 13441,
    1908,    46,  1051,  1893, -3257,  1909,  1910,  1912,  1914, 13441,
    1915, 13441,  1917, 13441,  1920,  1922,  1923,  1927,  1928, 13441,
    1836, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,  1847,
   -3257,  1141, -3257,  1931, -3257, -3257, -3257,   419, -3257,  1060,
    1932, -3257, 16366, -3257, 13441,  1933, -3257,  1935, -3257, -3257,
   -3257, -3257, -3257,  -132,  -132,  -132, 15781, -3257,  2300, -3257,
      38, -3257,  2188, -3257, -3257,   916,  1937, -3257,   305, 15781,
    1673,  2007, -3257, -3257,  -145, 22586, 26514, -3257, 36073,  1070,
    1070,  1070,  1300,  2243,  1698,  1698, -3257, 24828, -3257, -3257,
    1992, -3257, -3257, 27636, -3257,   828, -3257, -3257, 16366,  1215,
   -3257, -3257, -3257, 37191, -3257, -3257,   305,  1865,  1868, -3257,
   -3257, 42781, 13441, -3257,  2309, -3257, -3257,  1940,   386,  2102,
     386, -3257,  2220,  2222,   386, -3257, -3257, -3257, 22586,  1502,
   15781,   585,   585,   585, -3257,   916, -3257,  1941,   300, -3257,
   23148, -3257, -3257,  -175,  1897,  2355,  2378, 23148,  2288, -3257,
   -3257, -3257, -3257,  5253, 22586, -3257, -3257, -3257,  1062, -3257,
   17513, -3257, -3257, -3257,  1911,  1919,  1790, -3257, -3257, -3257,
   -3257, -3257,  1800,  2135, -3257,  1800,  1800, -3257, -3257, -3257,
   -3257, -3257,   199,   166, -3257, -3257,   199, -3257, -3257, -3257,
     103,   759,  1800, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
    1790,  1790, -3257, -3257, -3257,   199,  1924, -3257,  1790,   202,
   -3257,   137,   106,  1944,  1945,  1790,  1948,  1943, -3257,  1067,
   -3257, -3257,    14, -3257,   692, -3257, -3257, -3257,  1955, -3257,
    3260, -3257,   536, -3257, 43340, -3257,   518, -3257,   938, -3257,
   -3257, -3257,  2178, -3257,   199,  2193, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, 13441,  1956,  1957,
    1958, -3257, -3257, -3257, -3257, -3257, -3257, 13441, -3257, -3257,
   -3257, -3257, -3257, 13441, -3257, -3257, -3257, -3257, -3257,  2103,
   -3257,  2204, 13441, 13441, -3257, -3257, -3257, -3257, 13441, -3257,
   -3257, -3257, 13441,  2504,  2165,  1965, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, 13441, -3257, -3257, -3257,   938,
   -3257, 13441, -3257, -3257, 13441, 13441, -3257, 13441, 13441, -3257,
    1967, -3257,  1968, -3257,  1969, -3257, -3257,  2216, -3257, -3257,
   -3257, 13441,   971, 43340, -3257, -3257,  1973, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257,    95,  1998,  1998,  1998,  1215, -3257,
    1074, -3257, -3257,  2331, -3257,  1383, 22586, 15781,  1977,  1978,
   -3257,   -29, -3257, -3257,  1980,  1070, -3257,  2513,  2362, -3257,
   -3257, 38309,  1982, -3257, -3257,  2254, -3257,    97,  2177, -3257,
   -3257, -3257,   529,  2070,  2073,   305, -3257,  1460,  2004,  1492,
    2334,   860,  2033,   386,   386,   865,  2034, 13441, 13441,  1993,
   -3257,  1942, -3257,  2404, -3257, -3257, -3257,  1383, 13441, -3257,
    1997,  2000, 43340, -3257,  1189,   765, -3257,   202, -3257, -3257,
   -3257,   -30,  2242,  2245, -3257,   684, -3257,  2003,   684,   684,
    2554,   148, -3257,  2554, 37750, -3257,  1077, -3257,  2040,   199,
   -3257, -3257,  2045, -3257, -3257, -3257,   684,  2011,   199, -3257,
   -3257,  2251,   684, -3257, 38309,  1460,   217, -3257,  2063, -3257,
    2487,  2363, -3257,   202, -3257,  2364,  2262, -3257,  2265, -3257,
   -3257,  2266, -3257,  2267,  2269,   684,  2270, -3257,   684, 43340,
   -3257, 43340,  2052,   582, -3257, -3257, -3257,  2027,  2029, -3257,
   -3257, 21462, -3257, -3257, -3257, -3257,  2097, 43340,  2052, -3257,
     -29,   120,  2007, -3257,  1078,   300,  2042, -3257,  2046,  2047,
   -3257,  1082,  2048, -3257, -3257, -3257,  1110,  2049,   175,  2051,
    2032,  2054,  2041,  2055,  2056,  2307,  2464, -3257,  2057,  2058,
    2059,  2061,  2064,  2067,  2069, -3257, -3257, -3257,  2071, -3257,
   -3257, -3257, -3257,  2075, 38868, -3257,  2124,  2128, -3257, -3257,
    2129, -3257, -3257,   113,  1086, -3257, -3257, -3257, -3257, 15781,
    2381, -3257,   656, -3257, -3257, -3257, -3257, 13441, -3257,  1942,
    2555, -3257, 24828, -3257, -3257, -3257, -3257, -3257,  2076,  2078,
    8176,  2604, -3257,   386, -3257,  2096, -3257, -3257, -3257,  2106,
   -3257, -3257, 43340,  2120,  2392, -3257,   656,   300, 43340, 43340,
    1112,   794,   794,   794,   295,   295, -3257, -3257, -3257, -3257,
     649,   115, 43340, -3257, -3257,   928, -3257,  2082,  2085, -3257,
   -3257, -3257, -3257,   684, -3257,   175, -3257, -3257, -3257, -3257,
   -3257, 37750, -3257, -3257,  2554, -3257, -3257, -3257,   175, -3257,
    2088, -3257, -3257, -3257,  1057, -3257, -3257,  2319,  2109, -3257,
   -3257, -3257, -3257,  2090,  2091,  2095,  2098, -3257,  2083, -3257,
   -3257, -3257,   789, -3257, -3257, -3257, -3257, -3257,   616, 43340,
    2490,  1460,  2099,  2093, -3257, -3257, -3257, -3257, -3257,  2100,
     971, -3257, 43340, -3257,  2337, -3257, -3257, -3257,  2341, -3257,
   -3257, 13441, -3257, -3257, -3257,  2025, -3257, 13441, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257,   122,  2336,   744,
     744,   744,   744,  1086, -3257, -3257,  2147,  2192, -3257,   967,
   -3257,  -212,   300, 13441,  1300,   760,  2432, -3257, -3257, -3257,
   -3257,  2413,  1019, 13441,  2108, 13441,  2110,  1116, -3257, -3257,
   -3257,  2118, -3257, -3257,  1122,  1130, -3257, -3257, -3257,   765,
   -3257, -3257, -3257,   430,   430,  1134, -3257, -3257, -3257, -3257,
   -3257,  1137, -3257, -3257, -3257,  1140, -3257, -3257,  1057, -3257,
     199,  2554,   199,  2554,  2630,  2342,  2652, -3257,  -161, -3257,
   -3257,  5253, -3257, -3257, -3257, 43340,  5253, -3257, -3257,   300,
    2132,  2133,  1144,  2134,  2138,  2139, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, 22586, 21462, -3257,   157, 13441, -3257, -3257,
   -3257,  2338,  2666,  2669,  2580,  2674,   760, -3257,  -138, -3257,
    2578, -3257, -3257, 43340, -3257, 43340, -3257, 43340, 41663,  2332,
   -3257, -3257, -3257,  2720, -3257,   179, -3257, -3257,   928, 43340,
     199,   175,   199, -3257, -3257, -3257, -3257, -3257,  2379, -3257,
    2382, -3257,  2149,   821, -3257,  2596,  2321, -3257, -3257,   -29,
   -3257, -3257, -3257, -3257, 13441, -3257, -3257, -3257,  2151, -3257,
     305, -3257, -3257, -3257,   300, 43340, -3257,   175,   175,  2692,
     175, -3257,  2693,  2697,  -138, -3257,   239, 13441,  1146,  1148,
   -3257,  2160,  2161, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257,   -29, -3257, -3257, -3257,  2623, 32709,
    2322, -3257, -3257,  2164, 22586, 15781,  1286, -3257, -3257, -3257,
   -3257,   175, -3257,   175,   175, -3257,  2732,  2162, -3257, -3257,
   -3257, -3257, -3257, 43340,   634, -3257, 44458, 44458, 43340, -3257,
    2196, -3257,  4426,   128, -3257, -3257, -3257, -3257, -3257,  2163,
   -3257, -3257,  5253, -3257, -3257, -3257, 35514, -3257,  2170, -3257,
   -3257, -3257,  2471, -3257, -3257, -3257,  2581, 43340, -3257, -3257,
   -3257, -3257, 13441, 13441,  2203, -3257, -3257, 32709, 32709, -3257,
   -3257, -3257, 32709, -3257, -3257,  2555,  2175,  2614, -3257,  2536,
    2622, 13441, -3257, -3257, -3257,   440, -3257, -3257, 29889,  2174,
   33273, 13441,   128, -3257, -3257,  2432, 13441,  2182,  2185, -3257,
     744, -3257,  2553,  2199,  2217, 13441, 32709, -3257,  2629,  2663,
    2505,  2183, -3257,  2186,  2647, 44458,   821,  2562, -3257, -3257,
   -3257, -3257, 43340, -3257, -3257, -3257,   572, -3257, -3257, 30453,
    2208, 39427, 31017,  2189, -3257, -3257, 13441, -3257, -3257, -3257,
   32709,  2442,  2200, -3257,  2197, -3257, 32709, 13441, -3257,  2642,
    2215, -3257, -3257, -3257,  2586,  2202,   758, -3257,  2205, -3257,
    2646, 32709, -3257,  2534, 18637,  2345, 43340, 28197, -3257,  2223,
   32709,  2620, 43340,  5253,  2626,  2628, -3257,  2390, 31581, -3257,
   -3257, 38309,  1152, -3257, -3257, 22586, -3257, -3257,    36,  2233,
   -3257, 28761, -3257, -3257,  2694,   717, -3257, -3257,  2247, -3257,
   -3257, 20895,  2151, -3257, 32709, -3257, 32709, 33837, 13441, -3257,
    2259, -3257, -3257, -3257,  4426, -3257, -3257, -3257, 32145, 29325,
   -3257, -3257, 25387, -3257, -3257, -3257,  2633, -3257, -3257, -3257,
    1346, -3257, 33837, -3257, -3257, -3257, -3257
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3257, -3257, -3257, -3256, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257,   960, -3257, -3257, -3257, -3257, -3257,  1205, -1442,
   -3257, -3257, -3257, -3257, -3257,   316,   -38, -3257, -3257, -3257,
   -3257, -3257, -3257,  2127,  -781, -3178, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257,  -441,  -560, -3257, -3257,  -432,
   -3257, -3257, -2220, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257,  -913,  -875, -3257, -3257, -3257, -3257, -1850, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257,  -881, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,  -803, -3257,
   -3257,  -761, -3257, -3257,  -801, -3257, -3257, -3257,  -766, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,  -253, -3257,
   -3257, -1858, -3257, -3257, -3257,  1674, -3257,  1728, -3257,  2420,
   -3257,  -370,    21,  1259, -1874, -1035,  -520,  -490, -1679, -3257,
   -3257, -3257,  -343, -3257, -3257,   756,    99,  1261,  1297,   805,
     851, -3257, -3257,   123, -3257, -2671, -3257, -3257, -3257,    89,
   -3257,    92, -3257, -3257, -3257, -1355,    53, -1471, -3257,  -356,
   -1461, -3257,  -144, -3257,  -189, -3257,  -446, -2045, -1950, -3257,
   -3257, -3257,  -178,   129,   176, -3257, -2584, -2114, -3257, -3257,
    -561, -3257, -3257, -3257,  -568, -3257,  -334,  -482, -3257, -3257,
   -1479, -1694, -3257, -3257, -2164,  1691,   778, -3257, -2165,  -398,
   -1900, -3257,  -352, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257,   834, -3257, -3257, -3257,  -170,  -286, -1350, -2712,
   -3257, -3257, -3257, -3257, -3257, -3257,   576, -3257, -3257,  1364,
    1788, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257,   975, -3257, -3257, -3257, -3257, -3257,  -654,  1720,
   -3257, -3257, -3257,  1251, -3257, -3257, -3257, -3257,  1440, -3257,
   -3257,  2176, -3257, -3257, -3257, -3257,   575,  1001, -3257, -3257,
   -3257,  2194,   972,  -463, -1778, -3257,  2409, -3257, -3257, -3257,
   -1306, -1997, -3257,  2268,  -425, -1851,  1435,  -709,   -34, -3257,
    -236,  -744,  3971, -3257, -3257, -1256, -3257, -3257,  -792, -3257,
   -3257, -1292, -1180,  1550,  1539,   318,   197,    57, -3257, -3257,
    -500, -3257, -3257, -3257, -1260,  -724, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257,   -31, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -1138, -3257,   779, -3257, -1161, -3257,
   -3257, -3257,  1647, -3257, -3257, -3257, -3257, -3257, -1889, -1431,
     194, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -1883, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -1361, -3257,
   -1644, -3257, -3257,  -965, -3257, -3257,  -523, -2178, -1192,   445,
   -3257, -3257,  -969,  1699, -1561, -3257, -3257, -3257,   626, -3257,
   -3257, -3257, -3257, -3257,   163, -2032, -1056, -3257, -3257, -2629,
    -638, -1834,  -617, -3257, -1849,  -270, -1158, -1886, -3257, -3257,
   -3257, -3257,  -713, -3257, -3257, -3257,  -243,   998, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257,  -452,  -363,   942, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257,  1950,  1929,  1050,
   -3257, -3257, -2110, -3257, -3257,  1023, -3257,   -21, -1861,  -364,
     271, -3257, -3257,   277, -2626, -3257, -3257, -3257, -3257, -3257,
   -3257,   222,  -753,  -569,  2475, -3257, -3257, -3257, -3257, -3257,
   -3257,  2209,  1766, -1373,  2426, -3257, -3257, -3257, -3257, -3257,
    1452, -3257, -3257, -3257, -3257, -3257, -3257, -3257,  2496, -3257,
    -935, -3257,  -478, -3257, -3257,  -570, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257,  1552, -3257, -3257, -3257, -3257,
   -3257,  1953, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,   312,
    -622, -3257,  -451,  -639, -3257,  -517, -3257, -3257, -3257,  -743,
   -3257,  -738,  -671, -1004,   -77, -2669, -1434,   306,  1959, -2778,
   -1127, -1276, -1288, -1825,    23, -3257,    -7,  -527,  -465,  -912,
    2412, -3219,  -423,  -511, -3257,   327, -3257, -3257, -3257, -3257,
    1503, -3257, -3257, -3257, -3257,   614, -3257, -3257, -3257,   273,
   -3257,     6,  -188, -3257, -3257,   750, -3257,  1554, -3257, -3257,
   -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257,  1970,  2527,  2374, -3257,  2013, -3257, -3257, -3257,
   -3257, -3257,  -320, -3257,    -2, -3257, -1901,  1813,   396, -3257,
     690,  -880, -1168, -3257,  -322, -3257, -3257,   257,  2537,  2384,
   -3257, -3257, -3257, -3257, -3257, -2265,  -596, -3257, -2318, -3257,
   -3257, -3257, -3257, -1162, -3257, -3257,  1677,  -137, -3257, -3257,
    -122, -3257, -3257,   393, -3257,  2499,  2250, -3257,   914, -3257,
     185, -3257, -3257,   -83, -3257, -3257, -3257, -3257, -3257, -3257,
   -3257, -3257, -3257,   861, -3257, -3257, -3257, -3257, -3257, -3257
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2031
static const short yytable[] =
{
     391,   677,   677,   677,   719,   677,   568,   677,   655,  1007,
    1427,   684,   391,  1034,  2247,   391,  1062,  1098,   926,  1167,
    1168,  1169,   391,  1203,  1204,  1206,  1784,  1188,  1482,  1656,
    2400,  1690,   391,  1662,  1663,  1212,  1665,  1034,  1783,  1524,
    2298,  1268,   391,  1805,  2316,   426,  1846,  2362,   710,   711,
    1813,  1657,  1658,  1659,   985,  2697,  2503,  2657,  1029,  1688,
    1996,  2522,  2997,  1954,  1671,  2346,  2351,  2354,  2525,  2375,
     486,  1699,   487,  2012,  1573,  1802,   988,  2385,   928,  2389,
     391,  2088,  2384,  2335,  2982,  1063,  1719,  -259,  1680,  2989,
    1270,  2366,  2367,  1829,  1831,  2417,  2274,  1749,   669, -1526,
     391,   391,  2622,   391,  1739,  1740,  1741, -1879,   727,   502,
     481, -1527, -1880,  2419,   391,  1748, -1943,  1295,  1729,  -260,
   -1134,  1733,  1497,  -249,  1297,  1498,  1760,  1301,  1727,  3296,
    1310,  1311,  1312,  2438,  2439,   964,  1501,  1502,  3050,  1149,
    1393,  1431,   959,   738,   496,   964,  1916,   999,  2409,  1024,
    1761,  1762,   964,  2028,  3126,  1767,  3566,  3010,  1970,  3022,
    1321,  1322,  1323,  1045,  2406,  1817,  3154,  1819,  3209,  3011,
    2406,  3703,  1104,  2418,  1035,  1782,  2421,  1786,  1066,  3020,
    1361,  3126,  3021,  3012,   106,  1110,  3010,  2430,  2431,  1043,
    2364,  1046,   622,   623,  2711,  1100,  2440,  2483,  3011,   622,
     623,  3030,  1105,   622,   623,  2652,  1031,  3049,  2499,   673,
    3177, -1526,  3012,  1648,  2090,   702,  1304,  1393,  2891,  3010,
    2492,   622,  3016,   677, -2001,  3033,  1355,  1100,  1120,   994,
    3343,  3011,  1047,  1019,  1025,  3064,  2409,  1048,  2230,  2712,
    3090,  1150,   561,  3065,  1151,  3012,  3462,  1113,  1880,  1121,
     712,   752,  2494,  2724,   622,   623,  1069,  1152,  1963,  3190,
    2410,   573,   965,  2664,   582,  3496,  3034,   107,   465,   473,
    3035,   956,   965,  2328,  2092,  2924,  3565,   590,  2706,   965,
    2029,   516,  2512,  3188,   509,  1898,   970,  1088,  2380,   565,
    3485,   972,   114,  1913,   675,   447,  2407,  2408,  1580,   948,
    2804,  2381, -1134,  2403,   675,  2484,  2513,  3559,  3560,   594,
     466,  3144,  2645,  3036,  3191,  1146,  2106,  3181,  1940,  2735,
    2383,  -339,  1064, -2001,   775,  3187,   432,  1892,  2113,  3127,
    1988,  1442,  2409,  2213,  2494,  3472,  2432,   517,  2434,   398,
    1032,  1173,  1989,   714,  1914,  3396,  2051,  2514,  -340, -1526,
    2515,   606,   108,   446,  2461,  1073,  3127, -1879,  2516,  3473,
    2107, -1527, -1880,  1702,  1174,   395,  1703,  3187,  1881,  3312,
     115,  3066,  3397,  2114,   949,   786,  1065,   493,   674,   983,
    2155,   467,  1049,   788,  1153,  1305,  1082,   109,   736,  2370,
    2233,   973,  2633,  2634,  2635,  2715,  3639,  3567,  1349,  1900,
    1901,  2199,   775,   595, -1134,  2052,   106,   715,   391,  1806,
     121,  2725,  1520,  1356,  1581,   950,  2736,  2435,   391,  2404,
     803,   474,   391,  2659,  2660,  2661,  3128,   391,  1074,  1026,
     951,  2048,   391,  -339,   591,  3215,  2058,  2651,  3496,  1523,
    -474,  1990,  2064,  2495,  3219,  2067,  1388,   433, -1526,   518,
    1976,  1050,  1166,   563,   391,  2873,  3263,   578,  3731,  1583,
   -1527,   788,  2411,  1089,   607,  1927,  1484,  1154,  2382,  2805,
    1523,   391,   728,  2707,  1490,  2728,   596,  1396,  1525,  3422,
    1120,   391,  2329,  1385,   815,   391,   974,   922,  2665,   924,
     925,   391,  1468,   391,   391,  2692,  1005,  2701,   391,   391,
    1710,  1121,  1394,  1503,  1504,  1928,  2053,   489,   391,  2436,
    1051,   695,   391,  3305,  2723,  2097,  3486,   391,   391,   583,
     391,   391,   391,   391, -1134,  2495,  1485,  2710,  2730,  2504,
    1429,  1058,  3568,   713,   717,   718,  1020,  1882,  1573,  3037,
    1438,  1147,   831,   608,  2942,  1892,  3038,   110,  3333,  1027,
    -340,  3224,  3192,  1893,   835,   836,   391,   439,  1996,  2991,
    1430,  1941,   815,  2713,  1950,   574,  1070,  3129,   697,  1778,
     703,   562,   391,  1510,  3039,  3463,  2517,  2054,  3130,  1394,
     391,   391,  1104,   717,   718,   391,  1036,  1584,  1807,  2406,
    2173,  1500,   391,  -503,  2177,  2365,  2374,  -137,   960,  1996,
     603,  1044,   979,  2406,  3704,  3130,  1028,   994,   729,  1052,
     468,   991,  1105,  2336,  1784,  2485,  2412,  3155,   677,  3464,
    1816,  1432,   391,  3146,  2813,   400,  2320,  3421,  2216,  2892,
     994,  2249,   469,   836,  2250,  -339,  1837,  2279,  2273,  2280,
    1053,  1104,  2030,  2277,  2278,  3040,  2231,  3120,  3344, -2030,
    3023, -1526,  1348,  2270,  1471,  3131,  2502,   470,  1348, -1879,
    1529,  3013,  1840, -1527, -1880,   957, -1134,  -583,  2472,  1115,
   -1943,  1105,  3210,   675,  -259,  1115,  1357,  1358,  1359,  1784,
    1306,   391,  1071,  3399,  3569,  1643, -1526,  3047,  3051,   391,
    3013,  2388,   391, -1134, -1879,   391,   391,  2091, -1527, -1880,
    3444,  1072,  2518, -1943,  -340,  3448,  -260, -1134,  1894,   401,
    -249, -1134,  3017,  2787,   471,   675,  2092,  3182,  2722,  3048,
    3183,   506,  1991,  3013,   434,  1511,   496,  2726,  3041,  1512,
     867,   391,  1929,   391,  1784,   529,   869,  2702,  2703,   870,
    1115,  1609,  2214,  1115,  1348,  1937,  2443,  1388,  -508,   507,
    3450,  1977,  1585,  2519,   119,  1115,   587,  2945,  2055,   396,
     397,  1172,  3257,  1177,  1808,  3423,  1704,  2662,  2663,  1705,
    1410,  1893,  1386,  2469,  1821,  1885,  3434,   435,  3436,  2264,
    1809,  2520,   441,  2874,  1444,  1477,   445,  2937,  1385,  -339,
    1060,  3184,  3185,  2316,  2935,  2252,  2069,  1822,  1348,   512,
    3072,  1059,  1120,   609,   610,   611,   612,   613,   614,  3555,
    1988,  2971,   413,  2393,   869,  2975,  1510,  2972,  1618,   615,
    2990,  2976,   452,  1121,  1618,  2962,  3340,  3180,  2946,  1618,
    1061,  1913,  1388,  2444,  3674,  3507,  1388,  3064,  1810,  3364,
    2244,  3424,  2420,   460,  2422,  3065,  3489,  3365,  3491,  2427,
    3675,  1618,  1366,   569,  2245,  2072,  1478,  1946,  1448,   459,
    2530,  2531,  2253, -1400,  2987,  2445,   491,  2447,  2448,  2452,
     476,  3573,  2687,  2271,  2073,  3425,  1005,  1619,  1034,  3545,
     839,  1845,   391,  1619,   391,  1652,  1975,   455,  1619,  1530,
    2688,   456,    40,   717,   718,  2406,  3208,   414,  3402,  3213,
    1530,  1531,  1130,  1131,   737,  1887,  1800,  1034,  3403,  1032,
    1619,   477,  1531,  2010,  1621,  1906,   391,  1943,  1976,  3073,
    1621,  1367,   391,  1888,  1889,  1621,  1894,  1948,  1949,  2470,
    2696,  1952,  1953,  2070, -1998,   415,  1482,  1482,   689,  1932,
    1823,  2815,  3495,  1324,   570,  2353,  1391,  1621,  1959,  3173,
    2523,  1851,  1652,  1959,  3083,  2528,  1371,  1938,  2265,   391,
    1120,   391,  1839,   391,  3556,  1411,  1898,  3087,  1511,  3214,
    2536,  1449,  1512,  3066,  1847,   391,   391,  2541,  1622,  1445,
    1959,  1121,  2618,  1343,  1622,   391,   391,  1472,  1473,  1622,
     402,  2562,  2550,  2551,  3584,  3378,   391,  1483,  1653,  2555,
    2390,  1573,  3694,  1981,  2611,  1489,  1344,  2560,  3606,  3341,
     571,  1622,  3244,  3334,  3335, -1400,  2371,  1930,   391,   391,
     391,   391,  1784,  1141,  1142,  -265,   403,  2689,   391,  1652,
     391,   478,   664,   665,  2648,   668,   391,  1479,  1652,  1362,
    1363,  1364,  1365,  1366,    51,  2563,  2578,  3366,  2254,  1624,
    1474,  1475,  2824,  1375,   831,  1624,  2828,   404,   483,   391,
    1624,  1376,  1532,  2049,  2050,  1670,  2057,   405,  2059,  2060,
    2061,  2062,  2063,  1532,  2065,  2066,   489,  1386,  1652,  1960,
     831,  2731,  1624,  3074,  1960,  1412,   717,   718,   -55,  1499,
    3166,  3167,   416,   831,  2449,  1687,  1961,  2450,  2276,  1412,
    3354,  1961,  3342,   488,  3160,   391,  2613,  1959,   391,  1962,
    3404,  1960,  1367,  2620,  1962,  2011,  1824,  3314,  3082,   831,
    1114,  1458,   498,  2505,  2628,  1959,  3625,  1377,  1961,  1612,
    1613,  3502,  1533,   690,  2266,  1582,  3199,  1351,  1352,  2331,
    3606,  1962,  1728,  1533,  1368,  1369,  1370,  1371,  2981,  1345,
    2267,  1732,  2258,   717,   718,  2259,  1534,   391,   691,   391,
     391,   391,  1149,   391,  3245,  1980,  3353,  1534,  1353,  1354,
     457,   531,   391,  3075,   391,  1379,  3521,  1999,  2000,  3710,
    2002,  2003,  2004,  1898,  1963,  2007,   580,   499,  1459,  1963,
    2015,  1766,   589,  1615,  2018,  2019,  2020,  1115,  1899,  2023,
    2024,  2025,  2026,  2027,  3164,  2032,  2033,  2034,   391,  3168,
    1535,  1346,   671,   417,  1076,  3200,  1963,  3190,  2957,  1977,
     117,  1535,   118,   752,  3259,   458,   502,   675,   418,  2332,
    1634,  2958,  2983,  2983,  2983,  3478,  1634,  3479,  1960,  2285,
    1372,  1634,  1373,  1374,  1375,  1388,  2286,  3435,   391,  3437,
    3201,  1210,  1376,   675,   419,  1961,  1960,  3405,  2285,  2454,
    2455,  1996,   504,  1634,  1150,  2673,   675,  1151,  1962,   420,
    2959,   423,  3191,  1961,  3322,  1460,  1964,  1210,  3298,   436,
    1152,  1964,   513,  2083,   442,  3004,  2699,  1077,  2084,  3181,
    1210,  1536,   675,   403,   622,   623,   775,  1900,  1901,  2456,
    1380,   515,  1536,  1528,  1794,  1795,  3024,   391,  1964,  3025,
     523,  1211,  1382,  1388,   577,   117,  1210,   118,  1377,  3028,
    3029,  2457,   391,  2261,  2262,  1347,  1348,  3032,   679,   680,
    2920,   681,   560,   682,  3055,  1902,   581,  1296,  2839,  2840,
    1965,   622,   623,  1963,   666,  1965,   591,   786,  3590,  1618,
    1300,  1407,   685,  2458,  1408,   788,   525,  1409,   527,   440,
     528,  1963,   530,  3411,   563,  1378,  1379,  1784,  2095,  2096,
    1998,   696,  1965,  2001,  1461,   697,  3299,  3300,   391,  2320,
    3301,  3302,  2013,   391,   706,   391,  3629,  2127,  2128,   726,
     391,  2021,   803,  2339,  2129,  2130,   391,  3005,   391,   106,
    3008,  3009,   920,   391,   391,   923,   391,  1153,  1619,  1860,
     930,  1861,  1832,  1833,  1834,  1835,  1836,  3026,   391,   945,
    1784,   391,  2133,  2134,  2140,  2141,  3667,   391,   391,   391,
     391,   947,  2388,  1857,  1857,  1964,  1857,   391,   391,   391,
     952,  3678,  1908,  1909,  1910,  1621,  1784,   954,  1879,   962,
    3691,   979,   963,  1964,  2916,   391,   815,   109,  2443,   991,
    1891,  2145,  2146,   977,   391,  2148,  2149,  1857,  1857,  1857,
     978,  2612,   986,   929,  2150,  2151,  2423,  2424,  2162,  2163,
    3401,   391,  2166,  2167,  3718,   997,  3719,   998,   932,  1001,
    1154,  1380,  1008,   391,  1002,  2860,  1005,  2446,  -554,  1965,
    1016,  1539,  1381,  1382,  2352,   391,  2356,  2361,  1540,  1622,
    1017,   391,  2179,  2180,   831,  1334,  1335,  1965,  1541,  1542,
    2183,  2184,  1018,  1951,  2185,  2186,   835,   836,  2193,  2194,
    1862,  2196,  2197,  2205,  2206,  2219,  2220,  3206,  3207,  2238,
    2239,  1969,  2240,  2241,  2289,  2290,  1022,  2617,  1543,  1863,
    1828,  1830,  1544,  1032,  1336,  3217,  2399,  2352,  1023,  2425,
    1038,  3221,  1037,  1545,  1039,   534,   535,  1040,  1337,  1864,
     391,  1041,  1546,   933,  1057,  2624,  2075,  1623,  1547,   391,
    1624,  2459,  1042,  1865,  3237,  2479,  2480,  3239,  1067,  3441,
    3516,  1548,  1031,  2614,  2615,  1068,  3574,  2654,  2655,  3505,
   -1134,  1081,  1338,  2739,  2740,  1083,  1100,   391,  1084,  1549,
    1031,  2810,  2740,  1086,  1339,   964,  2867,  2868,  1550,  1551,
    1111,  2871,  2872,  1091,  1552,  1158,  3088,  1159,  1866,  1867,
    1112,   934,  1553,   391,  2893,  2894,   391,  1160,  1554,  1162,
     536,  1340,  2426,  2917,  2918,  2999,  1115,  1164,  1784,  3531,
    3060,  3061,  1165,  2433,  1166,   935,  1868,  3138,  3139,  2532,
    2648,  3261,  3262,  2086,  1555,  3267,  3268,  2537,   537,  1826,
    1827,  1617,  1170,  1626,  1350,  1627,  1628,  1629,  1630,  1631,
    1632,  1633,   538,  2352,  1179, -1134,  1183,   675,  1184,  3182,
    2352,  1181,  3183,  3270,  3271,  3336,  3262,  3109,  1341,  3416,
    3417,  1185,   867,  1331,   539,  3419,  3262,  1360,   869,  1186,
    1556,   870,  1557,  3420,  3262,  1869,   540,  3428,  3429,  1558,
    3430,  3431,  3593,  3432,  3431,  2693,  1007,  3453,  3454,  3518,
    3417,  3519,  3417,  1187,  1618,  3700,  3701,  1189,  3611,  1190,
    3611,   936,   965,  1770,  1771,   541,  1034,  2985,  2986,   937,
    3337,  3338,  2949,  2950,  2926,  2927,  1870,  3123,  3136,  3137,
    1191,  1634,  1192,  3184,  3185,  1193, -1134,  1194,  1195, -1134,
     542,  1387,  1196,  1390,  1197,  1198,   543,   938,  1199,  3611,
    1200,  1201,  3658,  1202,  1205,  1207,  1208,  1559,  1209,  1213,
    3662,  1400, -1134,  1619,   391,  1214,  2644,  1215, -1134,  1216,
    1217,  2695,  1560,  1218,  1219,  1220,  1221,  1561,  1397,  1222,
    2671, -1134,  1482,  1223,  1224,   544, -1134,  3611,  1225,  1392,
    1226,  1401,   939, -1134,  1402,  1422,  1227,  1620,  3611,  1228,
    1621,  1229,  2609, -1134,  1230,  1231,  1232,  1233,  1234,  1235,
    1236,  3611,  2686,   940,   675,  1237, -1134,  1562,  1238,  1239,
   -1134,  1240,  1241,  1563,  1243,  1244,  1564,  1245,  1246, -1134,
     941,  1247,   118,  1248,  1249,  1250,  1423,  1251,  3611,  3611,
    1252,  1256,  3733,  1257,  1258,  1259,  1260,  1426,  1261,  1565,
    1566,  1262,  1567,  1263,  1264,  1265,  1266,  1267,  1269,  1271,
    1404,  1272,  1273,  1274,  1622,   391,  1568,  1275,  1276,  2729,
    1277,  1541,  1542,  1278,  1279,  1280,  2732,  1435,  1281,  1282,
    1283,  1284,  1285,   391,   391,  1286,  1287,  1288,  1569,  1289,
     391, -1134,   391,   391,  1290,  1291,  1292,  1293,   545,  1294,
    1298,  1299,  1302,  -460,  -460,  1544,  1303,  1307,  1308,  1309,
    1313, -1134,  -460,  1314,  1315,  1316,  1545,   546,  1317, -1134,
    1437,  1318,  1466,   547,  1188,  1546,  1389,  1405,   565,   548,
     391,  1428,  1623,  1434,  1436,  1624,  1443,  1451,  1457,  1470,
    1486, -1134,   391,   391,  1548,  1491,  1492,  1493,  1494,  1496,
    1505,  1507,   391,   549,  1509,  1521,  1586,  1588,   391,  1100,
    1587,   391,  1549,  1589,   391,  1590,  1591,  1592,  1593,  3162,
    1594,  1595,  2352,   550,   551,   391,   391, -1134,   391,  1596,
    2738,  1570,  1597, -1134,   391,   391,  1598,  1599,  1600,  1601,
    1571,  1554,   964,  1604,   391,  1602,   391,  1603,  1605,  1608,
     391,   391,  1610,  1614,  1640,  1645,  1385,  1652,  1674,  1306,
     552,  1694, -1134,  1708,  1725,  1757,  1781,  1790,  1796,  1815,
    1801,  1818,  1625,  1838,  2453,  1848,  1849,  1873,  1626,  1876,
    1627,  1628,  1629,  1630,  1631,  1632,  1633,  1907,  1921,  1933,
     391,   391,  1935,  1942,  1945,  1967,  1968, -1134,  1972,  -554,
    1971,  1974,  1982,  1983,  1984,  -554,   553,  1985,   554,  1987,
    1986,  1988, -1134,  2005,  3071,  1557,  2006,  2009,  2008,   391,
    2489,  2017,  1558,  2014,  2016,  1784,   391,  2022,  2036,  2085,
    2087,  2091,  2104,  2093,  2094,  2098,  2126,  2100,  2101,   391,
    2102,  2118, -1134,  2103,  2137,  2105,  2108,  2109,  3385,  2110,
    2077,  2111,  2112,  2115,  2117, -1134, -1134,  3383,  2119,  2171,
    2120,  3388,  3389,  3390,  3391,  2121,  1634,  2122,  2123,   965,
    2124,  2125, -1134,  2131, -1134,  2256,  2132,  2135,  2288,  2136,
    2138,  2139,  2142,  2293,  2143,   391,  2144,  2147,  2251,  2152,
    1559,  2153,  2156,  1348,  -799,  2157, -1134,  2158,  2159,  2164,
   -1134, -1134,  2160,  2161,  2165,  1560,  2168, -1134,  2268,  2169,
    2170,  2294,  2291,  2172,  2181,  2295,  2301,  2306,  2174, -1134,
    2195,  2175,  2307,  2305,  2176, -1134,  2178,  2182,  2187,  2188,
    1914,  2189,  2190,  2624,  2191,  2192,  1784,  2198,   600,   535,
    2200,  2201,  2208, -1134,  2202,  2203,  2204,  2207,  2209,  2210,
   -1134,  2211,  2323,  2212,  2215,  2217,  1563,  2218,  2223,  1564,
   -1134,  2221,  2222,  2232,  2954,  2234,  2235,  2236,   391,  1115,
    2237,  2242,  2275, -1134,  -976,  2311,  2303, -1134,  2292,  2324,
    2399,  2325,  1565,  1566,  2326,  1567, -1134,  1913,  2343,  2345,
    2344,  2368,  2369,  2372,  2376,  2377,  2378,  2401,  2394,   391,
    2402,  2428,  2429,   391,  2462,   391,   391,   391,   391,  2476,
    2477,  2481,  2482,   536,  1523,  1646,   391,   807,  2509,  2529,
     391,  1569,  2542,   391,  2552,  2564,  2589,  2565,  1541,  1542,
    2584,  2591,  2593,  2602,  2596,  2599,  1007,   391,   391,   391,
    2604,   537,  2605,  2606,  2607,  2608,  1879,  2631, -1134,  2636,
     391,  2616,  2623, -1030,  2638,   538,   391,  2642,   391,  2650,
    -460,  -460,  1544,  2653,  2658,  2656,   391,  2669, -1134,  -460,
    2670,  2675,  2683,  1545,  2694,  2700, -1134,   539,  2704,  2705,
    2708,  2734,  1546,  2720,  2721,  2800,  2803,  2807,  2809,   540,
    2811,  2814,  2822,  2816,   535,  2819,  1784,  2820, -1134,  2821,
    2829,  1548,  2825,  2830,  2831,  2832,  2833,  2834,  3684,  2837,
    2835,  2836,  2841,  2842,  1570,  2843,  1100,  1784,   541,  1549,
    2286,  2844,  2845,  1571,  2846,  2911,  2847,   391,  2848,  2849,
    2850,  2851,  2852,  1784,  2853,  2854,  2855,  2856,   391,   392,
   -1134,   391,  2857,   542,  2861,  3684,  2858,  3273,  1554,   543,
    2862,   422,  2932,  2863,   428,  2934,  2913,  1898,  2947,  2955,
    3161,   437,  3621,  1212,  1297,  1301,  2864,  2963,   536, -1134,
    2964,   448,  2865,  2866,  2967,   391,  2973,  2970,  2974,  2869,
    2078,   464,   391,  2885,  2870,   391,  2993,  2876,   544,   391,
     391,  2877,  2878,   391,  2879,  2880,   537,  2895,  2881,  2992,
    3357,  2882,  2883,   391, -1134,  2884,  2886,  2887,  2888,  2994,
     538,  2890,  2896,  3002,  2897,  2742,  2898,  2899,  2901,   482,
    2903,  3003,  1557,  2905,  3006,  2906,  3031,  2907,  3223,  1558,
    2908,  2909,   539,  2808,  2915,  2919,  3089,  2922,  2923,   485,
     392,  2936,   392,  2968,   540,  2988,  3053,  3054,  3151, -1134,
    3056,  3091,  3059,   482,  3352,  3367,  3368,  3712,  3079,  3093,
    3094,  3095,  3100, -1134,  3098,  3105,  3106,  3352,  3107,  3712,
    3115,  3116,  3117,   541,  3118,  3134,  3122,  3141,  3147, -1134,
    3145, -1134,  3139,  3148,  3153,  3211,  3152,  3156,  3158,  2673,
    3163,  3159, -1064, -1069,  3712,  3172,  3174,  1559,   542,  3178,
    3197,   545,  3179,  3198,   543,  3205,  3050, -1134, -1134,  3220,
    3047,  2352,  1560,  3218, -1134,  3216,  3227,  2339,  3228,  3232,
     546,  3229,  3231,  3233,  3234,  3235,   547,  3236,  3238,  3242,
    3247,  2399,   548,  3248,  3433,  3251,  3275,  3280,  3281,  3306,
    3321,  3315,  3293,   544,  3264,  3277,  3294,  3295,  3330,  3265,
    3266,  3269,  3272,   677,  3274,  3324,   549,  3276,  3278,  3279,
    3282,  3283,  3284,  1563,  3285,  3326,  1564,  3286,   391,   391,
    3287,   391,  3288,  3358,  3359,  3289,   550,   551,  3291,  3318,
     391,  3319,  3372,  3445,  1007,  3348,   391,  3268,  3349,  1565,
    1566,  3356,  1567,  3360,  3361,  3380,   391,  3375,  3362,  3381,
    3393,  3363,  3374,  3377,   391,  3387,  3394,  3408,  3438,  3410,
    3413,  3439,  3415,   552,  1128,  1129,  1130,  1131,  1132,  1133,
    3418,   391,  1134,  1135,  1136,  1137,  1138,  1139,  1569,  1140,
    3440,  3467,  3465,   391,  3468,  3451,  3452,  3455,  3469,  3470,
     391,  3456,  3457,  3476,  3373,  3484,  2472,   391,  3492,  2954,
    3500,  3493,  3494,   391,  3501,  3504,   545,  3511,  3513,   553,
     677,   554,  3514,  3520,  3522,  2480,  3541,  3543,  3552,  3553,
    -211,  3577,  3576,   677,  3571,   546,  3578,  3584, -1194,  3600,
    3490,   547,  3601,  3602,  3612,  3619,  3623,   548,  3624,  3620,
    3630,  3625,  3631,  3635,  3634,  3637,  3641, -1801,  3651,  3659,
    3663,  3666,  3664,  3669,  3670,  3671,  3672,  3677,  2352,  3679,
    3685,   549,  3692,  3690,  3697,  3676,  3509,  3510,  3695,  3512,
    3696,  1570,  3706,  3715,  3729,  3708,  3734,   391,  2287,  2068,
    1571,   550,   551,  3616,  3376,  3447,  3370,  1141,  1142,  3736,
    3711,  1108,  3717,  3648,  3607,  3649,  3615,   526,  3258,   514,
    1527,  3081,  2035,  3332,  2493,  1607,  1992,   559,  2039,  3000,
    3549,   567,  3550,  3551,  2413,  2473,   482,  3350,   552,  3057,
    2995,   586,  3018,  3189,  3230,  3019,  3222,  2996,  3483,  2961,
    3487,  3347,  3427,  2500,  3379,  1639,  3355,  3596,  1508,  2498,
    2463,  1956,  2308,   482,  1541,  1542,  1890,  1606,  2641,  1119,
    2304,  1096,   683,  2327,  3395,  1012,  1912,  3124,  3292,  1825,
     686,  3125,  2969,  2526,   553,  3482,   554,  2998,  1820,  1724,
     482,  1672,  2621,  3329,   482,  3442,   391,  3643,  1544,  3317,
     708,  3596,   482,   482,  2334,  3143,  1539,   720,   567,  1545,
    1421,  2940,  1439,  1540,  2314,  2300,  2939,   739,  1546,   391,
    2980,   744,  3702,  1541,  1542,  3544,   921,   392,   672,   392,
     392,   567,   482,  3498,   391,  1644,   745,  1548,  1947,  1176,
     658,  1441,  2933,  3595,  1850,  3471,  3617,  3515,  3716,  3226,
    1922,  2943,  1100,  1543,  2965,  1549,   677,  1544,  3157,  2691,
    1455,  1446,  3320,   602,  1000,   969,  1414,  3386,  1545,  1611,
    2630,  3392,  1884,  3290,   604,   391,  1171,  1546,  1004,   698,
    2488,   482,  3078,  1547,  1554,  3256,     0,     0,     0,   567,
     482,  1792,   677,   677,   482,   677,  1548,   391,     0,     0,
       0,   482,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1100,     0,     0,  1549,     0,     0,   391,     0,     0,
       0,     0,     0,  1550,     0,     0,     0,     0,     0,  1552,
       0,   567,     0,     0,     0,     0,   677,  1553,   677,   677,
       0,     0,   391,  1554,   391,     0,     0,     0,     0,     0,
    3546,     0,     0,     0,   391,     0,     0,     0,  1557,     0,
     391,     0,     0,     0,     0,  1558,     0,     0,     0,  1555,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3250,     0,     0,     0,     0,     0,
    1099,     0,     0,     0,     0,     0,     0,     0,   567,     0,
       0,   482,     0,     0,  1118,   482,  3498,   391,     0,     0,
       0,     0,     0,  2352,     0,     0,     0,  1557,     0,     0,
       0,     0,     0,     0,  1558,     0,     0,     0,     0,     0,
       0,     0,     0,  1559,     0,   391,     0,     0,     0,     0,
     482,     0,  1178,     0,     0,     0,     0,     0,  1560,     0,
       0,     0,     0,     0,     0,   391,     0,     0,     0,     0,
       0,   391,   391,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   391,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1559,     0,   391,     0,     0,  3726,     0,  1563,
       0,     0,  1564,     0,     0,     0,     0,  1560,     0,     0,
       0,     0,  1561,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3726,     0,     0,  1565,  1566,     0,  1567,     0,
       0,     0,   391,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   391,     0,     0,  3699,     0,
       0,     0,  1562,     0,     0,  3735,     0,     0,  1563,     0,
       0,  1564,     0,     0,  1569,     0,     0,     0,     0,     0,
       0,     0,     0,  1541,  1542,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1565,  1566,     0,  1567,     0,     0,
       0,  1328,     0,  1330,     0,     0,     0,     0,     0,     0,
       0,  1568,     0,     0,     0,  -460,  -460,  1544,     0,     0,
       0,     0,     0,     0,  -460,     0,     0,     0,  1545,     0,
       0,     0,     0,  1569,     0,   482,     0,  1546,     0,     0,
       0,   482,     0,     0,   620,     0,   582,   621,     0,     0,
       0,     0,     0,     0,     0,     0,  1548,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1570,   391,   622,
     623,  1100,     0,     0,  1549,     0,  1571,     0,  1415,   624,
    1418,   625,   482,     0,     0,     0,   391,   391,     0,     0,
       0,     0,     0,     0,   482,   567,     0,     0,     0,   626,
       0,   627,     0,  1554,   482,   482,   391,     0,   391,   628,
     391,   391,     0,     0,     0,  1447,     0,  3461,     0,     0,
       0,     0,   391,  1456,     0,     0,  1570,     0,     0,     0,
       0,     0,     0,     0,     0,  1571,     0,   392,   392,   482,
     482,     0,     0,     0,     0,     0,     0,   392,     0,   567,
       0,     0,     0,     0,     0,   392, -1378,   629,   391,     0,
       0,   630,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1557,   482,     0,
       0,     0,     0,     0,  1558,     0,     0,     0,     0,     0,
       0,   631,  3538,   632,     0,     0,     0,   391,     0,     0,
       0,     0,     0,     0,     0,   633,     0,   634,     0,     0,
       0,     0,     0,     0,     0,     0,   391,     0,     0,  3538,
    3538,   391,     0,     0,   482,     0,     0,   482,     0,     0,
     635,   636,     0,     0,   637,     0,     0,     0,     0,   391,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     391,   638,  1559,     0,     0,     0,     0,     0,     0,     0,
    3538,  3538,     0,     0,     0,  3538,     0,  1560,     0,     0,
       0,     0,   639,     0,     0,     0,   567,   640,   567,   392,
     392,  3538,   482,  3538,     0,     0,     0,     0,     0,     0,
       0,   744,     0,  1647,     0,     0,     0,     0,     0,  3538,
       0,   641,     0,     0,     0,     0,     0,     0,  3538,     0,
       0,     0,     0,     0,     0,   391,     0,     0,  1563,     0,
       0,  1564,  3538,     0,   391,  3538,     0,  1681,     0,     0,
       0,     0,     0,  3538,   642,     0,     0,     0,     0,  3538,
       0,     0,     0,   643,  1565,  1566,     0,  1567,     0,     0,
       0,     0,     0,     0,  3538,     0,     0,   391,     0,   391,
    3538,   644,     0,  3538,     0,   391,     0,  1681,     0,     0,
       0,  3538,     0,     0,   391,     0,     0,     0,   391,     0,
       0,     0,     0,  1569,  3538,     0,     0,   645,   646,     0,
       0,   647,   648,     0,   391,     0,     0,  3538,     0,  3538,
     391,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3538,  3538,     0,     0,  3538,     0,     1,     0,     0,
       0,     0,     0,     0,     0,   391,  1785,     2,     3,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       4,   567,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   649,     0,     0,     0,     0,   650,     0,
       0,     6,     7,     0,     0,     0,     0,     8,   651,     0,
       0,     9,    10,     0,     0,     0,  1570,     0,     0,     0,
       0,     0,     0,     0,    11,  1571,     0,     0,     0, -1826,
       0,     0,     0,   652,     0,     0,     0,   567,     0,     0,
       0,    12,  1843,     0,   567,     0,     0,     0,   653,   567,
       0,     0,     0,     0,     0,   482,     0,  1853,     0,     0,
      13,     0,  1858,  1858,     0,  1858,  3540,     0,     0,    14,
      15,    16,     0,     0,     0,     0,     0,   482,     0,     0,
     482,     0,    17,    18,     0,     0,   567,   567,   482,   482,
       0,     0,     0,  3540,  3540,     0,  1858,  1858,  1858,     0,
       0,     0, -1826,     0,     0,    19,   654,     0,     0,     0,
       0,     0,     0,     0,  1925,     0,     0,     0,     0,     0,
       0,     0,    20,  1936,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3540,  3540,     0,     0,     0,  3540,
    1944,     0,     0,     0,     0,     0,    21,     0,     0,     0,
       0,     0,   482,    22,     0,  3540,    23,  3540,     0,     0,
       0,     0,     0,     0,  1958,     0,     0,     0,     0,     0,
     482,     0,     0,  3540,     0,     0,     0,    24,     0,     0,
       0,     0,  3540,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    25,     0,     0,  3540,     0,     0,  3540,
       0,     0,     0,     0,     0,     0,     0,  3540,     0,     0,
       0,    26,     0,  3540,     0,     0,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3540,  2042,
       0,     0,     0,     0,  3540,     0,     0,  3540,  2046,     0,
       0,     0,     0,     0,     0,  3540,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3540,     0,
       0,     0,     0,     0,     0,     0,   392,     0,     0,     0,
       0,  3540,     0,  3540,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3540,  3540,     0,     0,  3540,
       0,     0,   482,     0,     0,  2089,     0,     0,     0,     0,
       0,     0,    28,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    29,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    31,     0,    32,    33,     0,     0,    34,
       0,     0,    35,     0,    36,     0,     0,     0,     0,    37,
       0,    38,     0,     0,     0,     0,     0,     0,     0,     0,
      39,     0,     0,     0,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
       0,     0,     0,     0,    42,     0,     0,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2257,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,    48,     0,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    50,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    51,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2321,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2340,  2342,     0,     0,     0,     0,     0,   567,
       0,   567,   567,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1785,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   567,   567,     0,     0,     0,     0,     0,     0,     0,
       0,  2042,     0,     0,     0,     0,     0,  2042,     0,     0,
    2042,     0,     0,  2042,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2042,  2042,     0,   567,     0,     0,
       0,     0,     0,  2042,  1785,     0,     0,     0,     0,     2,
       3,     0,     0,   482,     0,   567,     0,     0,     0,  2042,
    2468,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     0,     0,     0,     0,     8,
       0,     0,     0,     9,    10,     0,     0,     0,     0,   482,
    2042,     0,     0,   892,     0,     0,    11,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    12,     0,     0,     0,     0,   567,     0,
       0,     0,     0,     0,     0,   567,     0,     0,     0,     0,
       0,     0,    13,     0,     0,     0,     0,     0,  2533,     0,
       0,    14,    15,    16,     0,     0,   971,     0,     0,     0,
       0,     0,     0,     0,    17,    18,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    19,     0,     0,
       0,     0,     0,     0,  1681,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    20,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    21,     0,
       0,     0,     0,     0,     0,    22,     0,     0,    23,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    24,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    25,     0,   567,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1127,     0,     0,
       0,     0,     0,    26,     0,     0,     0,     0,    27,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2629,     0,
       0,     0,  1853,     0,   969,   567,   567,   567,     0,     0,
       0,     0,     0,     0,     0,   482,     0,     0,     0,   567,
       0,     0,  1785,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   567,   567,   567,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2672,
       0,     0,     0,     0,     0,  2674,     0,  2676,     0,     0,
       0,     0,     0,     0,     0,   567,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,  1242,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    29,     0,     0,     0,
       0,     0,     0,     0,     0,    30,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    31,  2042,    32,    33,     0,
       0,    34,     0,     0,    35,     0,    36,   567,     0,     0,
    2042,    37,     0,    38,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,  1319,     0,    40,     0,  1326,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,     0,     0,   482,     0,    42,     0,     0,     0,
      43,  2741,     0,     0,   482,     0,     0,     0,  2797,  2798,
       0,     0,  2801,     0,     0,     0,     0,     0,     0,     0,
      44,     0,   482,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,    48,
       0,     0,     0,     0,    49,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1454,     0,     0,     0,     0,    50,     0,     0,
       0,  1469,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    51,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2321,  2944,     0,
     567,     0,     0,     0,     0,     0,     0,     0,     0,   567,
       0,     0,     0,     0,     0,  2629,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   567,     0,     0,     0,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1785,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2042,     0,     0,     0,     0,     0,     0,  2042,
       0,     0,     0,     0,     0,     0,  1785,     0,     0,     0,
       0,     0,  2042,     0,  1649,  1650,  1651,     0,     0,     0,
       0,     0,     0,  1660,  1661,     0,     0,  1664,     0,  1666,
    1667,  1668,  1669,     0,     0,     0,  1673,     0,     0,  1675,
    1676,     0,  1677,     0,  1678,  1679,     0,  1682,  1683,  1684,
    1685,  1686,     0,  1689,     0,  1691,  1692,  1693,     0,  1695,
    1696,  1697,  1698,     0,  1700,  1701,     0,  1707,     0,     0,
    1711,  1712,  1713,     0,  1715,  1716,  1717,  1718,     0,  1720,
    1721,  1722,  1723,     0,     0,     0,  3086,     0,  1730,  1731,
       0,  1734,  1735,  1736,  1737,  1738,     0,     0,     0,     0,
    1742,     0,  1743,  1744,  1745,  1746,  1747,     0,     0,  1750,
    1752,  1753,  1754,  1755,  1756,     0,  1758,  1759,     0,     0,
       0,  1763,  1764,  1765,     0,  1768,     0,  1769,     0,     0,
       0,  1772,     0,  1776,  1777,     0,     0,     0,     0,  1780,
       0,     0,     0,     0,  2743,  2744,     0,  1787,  1788,  1789,
    2745,     0,  2746,     0,  2747,  2748,  1326,     0,     0,  1797,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2749,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3121,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1785,     0,
    2750,     0,     0,  2751,     0,     0,     0,     0,  1841,     0,
       0,  2752,     0,   567,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2753,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2754,     0,     0,
       0,     0,  1886,     0,  3086,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2755,     0,
    2756,     0,     0,     0,     0,     0,   567,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2757,
    2758,     0,     0,     0,     0,     0,   567,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3240,     0,  3241,     0,     0,     0,     0,     0,     0,
    2759,     0,     0,   482,     0,     0,     0,     0,     0,  3255,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2760,
       0,     0,     0,     0,     0,     0,     0,     0,  2761,  2762,
       0,  2763,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2340,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2764,
    2765,  2766,     0,     0,     0,     0,     0,     0,     0,  2047,
       0,     0,     0,     0,   567,     0,     0,     0,     0,     0,
    2767,  2768,  2769,     0,     0,     0,  2770,     0,     0,  2771,
       0,     0,     0,     0,  3328,     0,     0,     0,     0,     0,
    3086,  3086,  2772,  2773,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3346,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2774,     0,
    2775,     0,     0,   567,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2776,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3371,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3086,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2777,     0,  2778,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2779,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2225,  2227,  2229,     0,     0,     0,
       0,     0,  2780,  2781,     0,     0,  2782,  2783,  2784,  2785,
       0,  2243,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2269,  3255,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2786,
    2787,     0,     0,     0,     0,  1785,   482,     0,     0,  2281,
       0,     0,     0,     0,     0,     0,     0,     0,  2788,     0,
       0,     0,     0,     0,     0,  3328,     0,  3328,     0,  3480,
    2046,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3488,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3508,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1785,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3554,     0,     0,     0,     0,
    3561,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   567,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3579,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3645,     0,     0,     0,     0,     0,
       0,     0,     0,  3656,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2507,     0,     0,  2508,     0,     0,
    2510,  2511,     0,     0,     0,     0,  1785,     0,  3687,     0,
       0,     0,     0,  2524,  3693,     0,  2527,     0,     0,     0,
       0,     0,     0,   567,     0,     0,     0,  1785,     0,  2534,
       0,  2535,     0,     0,     0,  2538,     0,  2539,  2540,     0,
       0,     0,  2543,  1785,  2544,  2545,     0,  2546,     0,  3727,
    2547,     0,  2548,  2549,     0,     0,     0,     0,  2553,  2554,
       0,     0,  2556,     0,  2557,     0,  2558,     0,  2559,     0,
    2561,     0,     0,     0,  3727,     0,     0,     0,     0,     0,
       0,  2566,  2567,     0,     0,  2568,     0,  2569,     0,     0,
       0,     0,     0,     0,     0,  2570,  2571,     0,  2572,     0,
    2573,     0,     0,  2574,  2575,  2576,     0,  2577,     0,     0,
       0,     0,     0,  2580,  2581,  2582,  2583,     0,     0,     0,
       0,  2585,  2586,  2587,     0,  2588,     0,  2590,     0,  2592,
       0,  2594,     0,  2595,     0,     0,     0,     0,     0,     0,
    2597,     0,  2598,     0,     0,  2600,  2601,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2610,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2619,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2637,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2681,     0,     0,
       0,     0,  2685,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2716,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2719,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2818,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2889,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2900,     0,  2902,     0,  2904,     0,     0,     0,     0,     0,
    2910,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2921,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2966,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3092,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3096,     0,
       0,     0,     0,     0,  3097,     0,     0,     0,     0,     0,
       0,     0,     0,  3101,  3102,     0,     0,     0,     0,  3103,
       0,     0,     0,  3104,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3108,     0,     0,     0,
       0,     0,  3110,     0,     0,  3111,  3112,     0,  3113,  3114,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3119,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3170,  3171,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2716,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2716,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2681,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3382,     0,     0,     0,     0,     0,  3384,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3400,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3412,     0,  3414,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2716,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3503,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3517,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3582,  3583,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3603,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3614,     0,     0,     0,     0,  3618,     0,     0,
       0,     0,     0,     0,     0,     0,  3628,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,     0,   746,   124,
     125,   126,   127,     0,     0,     0,     0,  3660,   128,     0,
       0,   747,     0,   748,   130,   131,   749,   133,  3668,   134,
     750,   135,     0,   751,   136,   752,   753,   754,   137,   755,
       0,   138,   139,   140,  1773,   141,     0,   142,   143,     0,
       0,   144,   756,   145,     0,   146,   757,   758,   148,     0,
     149,   150,   151,   759,   152,     0,   760,   154,     0,   155,
     156,   157,   158,   159,   761,   762,   160,     0,   161,   162,
       0,   763,   164,     0,   764,   765,   766,   165,     0,  3728,
     166,   767,   768,     0,   769,   770,     0,   167,   168,   771,
     772,   773,     0,     0,     0,     0,   774,   171,   775,     0,
       0,   776,   777,   172,     0,   173,     0,     0,     0,   778,
     779,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   780,   182,     0,
     781,   782,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   783,     0,   191,   784,   192,   785,   786,
     193,   194,     0,   787,   195,   196,   197,   788,     0,   198,
       0,     0,   789,     0,   199,   200,     0,   790,   201,     0,
     202,   791,   792,   793,   794,     0,   795,   796,   204,   797,
     798,   799,   206,     0,   207,   800,     0,   801,   802,     0,
     208,   209,     0,   210,   803,     0,   211,     0,     0,     0,
     804,   213,   214,   215,   805,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   806,   219,   807,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   808,   226,     0,  1774,   809,   227,     0,
     810,   228,     0,     0,     0,   811,     0,   812,     0,   230,
     813,     0,   231,     0,   232,   814,     0,     0,   815,     0,
       0,     0,     0,   816,   233,   234,   235,   236,   237,   238,
     817,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     818,   248,   249,   250,   819,   251,   252,     0,     0,     0,
     253,   254,   255,   820,   257,     0,     0,   821,   259,   822,
     823,   260,     0,   261,   824,   825,   826,   827,   828,   829,
     830,   266,   267,   268,   269,     0,   831,   270,   271,     0,
     272,   273,   274,   832,   833,   834,   275,     0,   835,   836,
       0,   276,   277,     0,   837,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   838,   839,   286,   840,   841,   842,   843,   844,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   845,   297,   298,   299,   300,   301,   302,   303,   846,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   847,   848,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   849,   318,   319,
     850,   320,   321,   851,   322,   852,   324,   325,     0,   853,
     327,     0,   328,   854,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,   855,   856,   349,
     350,     0,   351,   857,   353,   858,   859,   860,   354,   355,
     356,   357,   861,   358,   359,     0,   360,   361,     0,   675,
     362,   862,   863,   864,   865,     0,     0,     0,     0,  1775,
     367,     0,   368,   866,   867,   868,   370,   371,   372,     0,
     869,   373,   374,   870,     0,   375,     0,     0,   871,   872,
     376,     0,     0,   377,     0,   378,     0,   873,   380,     0,
       0,   874,   875,   876,   877,   878,   381,     0,     0,   382,
     879,     0,   383,   384,   880,     0,     0,     0,     0,   386,
       0,   387,   388,     0,   881,     0,   882,     0,     0,     0,
       0,   883,     0,     0,     0,   884,   885,     0,     0,     0,
       0,   886,     0,   887,     0,     0,   888,   889,     0,   890,
     891,   122,     0,   746,   124,   125,   126,   127,  2677,     0,
       0,     0,     0,   128,     0,     0,   747,     0,   748,   130,
     131,   749,   133,     0,   134,   750,   135,     0,  2678,   136,
     752,   753,   754,   137,   755,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   756,   145,     0,
     146,   757,   758,   148,     0,   149,   150,   151,   759,   152,
       0,   760,   154,     0,   155,   156,   157,   158,   159,   761,
     762,   160,     0,   161,   162,     0,   763,   164,     0,   764,
     765,   766,   165,     0,     0,   166,   767,   768,     0,   769,
     770,     0,   167,   168,   771,   772,   773,     0,     0,     0,
       0,   774,   171,   775,     0,     0,   776,  2679,   172,     0,
     173,     0,     0,     0,   778,   779,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   780,   182,     0,   781,   782,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   783,     0,
     191,   784,   192,   785,   786,   193,   194,     0,   787,   195,
     196,   197,   788,     0,   198,     0,     0,   789,     0,   199,
     200,     0,   790,   201,     0,   202,   791,   792,   793,   794,
       0,   795,   796,   204,   797,   798,   799,   206,     0,   207,
     800,     0,   801,   802,     0,   208,   209,     0,   210,   803,
       0,   211,     0,     0,     0,   804,   213,   214,   215,   805,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   806,
     219,   807,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   808,   226,
       0,     0,   809,   227,     0,   810,   228,     0,     0,     0,
     811,     0,   812,     0,   230,   813,     0,   231,     0,   232,
     814,     0,     0,   815,     0,     0,     0,     0,   816,   233,
     234,   235,   236,   237,   238,   817,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   818,   248,   249,   250,   819,
     251,   252,     0,     0,     0,   253,   254,   255,   820,   257,
       0,     0,   821,   259,   822,   823,   260,     0,   261,   824,
     825,   826,   827,   828,   829,   830,   266,   267,   268,   269,
       0,   831,   270,   271,     0,   272,   273,   274,   832,   833,
     834,   275,     0,   835,   836,     0,   276,   277,     0,   837,
    2680,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   838,   839,   286,
     840,   841,   842,   843,   844,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   845,   297,   298,   299,
     300,   301,   302,   303,   846,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     847,   848,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   849,   318,   319,   850,   320,   321,   851,   322,
     852,   324,   325,     0,   853,   327,     0,   328,   854,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,   855,   856,   349,   350,     0,   351,   857,   353,
     858,   859,   860,   354,   355,   356,   357,   861,   358,   359,
       0,   360,   361,     0,   675,   362,   862,   863,   864,   865,
       0,     0,     0,     0,     0,   367,     0,   368,   866,   867,
     868,   370,   371,   372,     0,   869,   373,   374,   870,     0,
     375,     0,     0,   871,   872,   376,     0,     0,   377,     0,
     378,     0,   873,   380,     0,     0,   874,   875,   876,   877,
     878,   381,     0,     0,   382,   879,     0,   383,   384,   880,
       0,     0,     0,     0,   386,     0,   387,   388,     0,   881,
       0,   882,     0,     0,     0,     0,   883,     0,     0,     0,
     884,   885,     0,     0,     0,     0,   886,     0,   887,     0,
       0,   888,   889,     0,   890,   891,   122,     0,   746,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   747,     0,   748,   130,   131,   749,   133,     0,   134,
     750,   135,     0,   751,   136,   752,   753,   754,   137,   755,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   756,   145,     0,   146,   757,   758,   148,     0,
     149,   150,   151,   759,   152,     0,   760,   154,     0,   155,
     156,   157,   158,   159,   761,   762,   160,     0,   161,   162,
       0,   763,   164,     0,   764,   765,   766,   165,     0,     0,
     166,   767,   768,     0,   769,   770,     0,   167,   168,   771,
     772,   773,     0,     0,     0,     0,   774,   171,   775,     0,
       0,   776,   777,   172,     0,   173,     0,     0,     0,   778,
     779,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   780,   182,     0,
     781,   782,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   783,     0,   191,   784,   192,   785,   786,
     193,   194,     0,   787,   195,   196,   197,   788,     0,   198,
       0,     0,   789,     0,   199,   200,     0,   790,   201,     0,
     202,   791,   792,   793,   794,     0,   795,   796,   204,   797,
     798,   799,   206,     0,   207,   800,     0,   801,   802,     0,
     208,   209,     0,   210,   803,     0,   211,     0,     0,     0,
     804,   213,   214,   215,   805,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   806,   219,   807,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   808,   226,     0,     0,   809,   227,     0,
     810,   228,     0,     0,     0,   811,     0,   812,     0,   230,
     813,     0,   231,     0,   232,   814,     0,     0,   815,     0,
       0,     0,     0,   816,   233,   234,   235,   236,   237,   238,
     817,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     818,   248,   249,   250,   819,   251,   252,     0,     0,     0,
     253,   254,   255,   820,   257,     0,     0,   821,   259,   822,
     823,   260,     0,   261,   824,   825,   826,   827,   828,   829,
     830,   266,   267,   268,   269,     0,   831,   270,   271,     0,
     272,   273,   274,   832,   833,   834,   275,     0,   835,   836,
       0,   276,   277,     0,   837,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   838,   839,   286,   840,   841,   842,   843,   844,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   845,   297,   298,   299,   300,   301,   302,   303,   846,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   847,   848,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   849,   318,   319,
     850,   320,   321,   851,   322,   852,   324,   325,     0,   853,
     327,  1324,   328,   854,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,   855,   856,   349,
     350,     0,   351,   857,   353,   858,   859,   860,   354,   355,
     356,   357,   861,   358,   359,     0,   360,   361,     0,   675,
     362,   862,   863,   864,   865,     0,     0,     0,     0,     0,
     367,     0,   368,   866,   867,   868,   370,   371,   372,     0,
     869,   373,   374,   870,     0,   375,     0,     0,   871,   872,
     376,     0,     0,   377,     0,   378,     0,   873,   380,     0,
       0,   874,   875,   876,   877,   878,   381,     0,     0,   382,
     879,     0,   383,   384,   880,     0,     0,     0,     0,   386,
       0,   387,   388,     0,   881,     0,   882,     0,     0,     0,
       0,   883,     0,     0,     0,   884,   885,     0,     0,     0,
       0,   886,     0,  1325,     0,     0,   888,   889,     0,   890,
     891,   122,     0,   746,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   747,     0,   748,   130,
     131,   749,   133,     0,   134,   750,   135,     0,   751,   136,
     752,   753,   754,   137,   755,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   756,   145,     0,
     146,   757,   758,   148,     0,   149,   150,   151,   759,   152,
       0,   760,   154,     0,   155,   156,   157,   158,   159,   761,
     762,   160,     0,   161,   162,     0,   763,   164,     0,   764,
     765,   766,   165,     0,     0,   166,   767,   768,     0,   769,
     770,     0,   167,   168,   771,   772,   773,     0,     0,     0,
       0,   774,   171,   775,     0,     0,   776,   777,   172,     0,
     173,     0,     0,     0,   778,   779,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   780,   182,     0,   781,   782,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   783,     0,
     191,   784,   192,   785,   786,   193,   194,     0,   787,   195,
     196,   197,   788,     0,   198,     0,     0,   789,     0,   199,
     200,     0,   790,   201,     0,   202,   791,   792,   793,   794,
       0,   795,   796,   204,   797,   798,   799,   206,     0,   207,
     800,     0,   801,   802,     0,   208,   209,     0,   210,   803,
       0,   211,     0,     0,     0,   804,   213,   214,   215,   805,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   806,
     219,   807,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   808,   226,
       0,     0,   809,   227,     0,   810,   228,     0,     0,     0,
     811,     0,   812,     0,   230,   813,     0,   231,     0,   232,
     814,     0,     0,   815,     0,     0,     0,     0,   816,   233,
     234,   235,   236,   237,   238,   817,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   818,   248,   249,   250,   819,
     251,   252,     0,     0,     0,   253,   254,   255,   820,   257,
       0,     0,   821,   259,   822,   823,   260,     0,   261,   824,
     825,   826,   827,   828,   829,   830,   266,   267,   268,   269,
       0,   831,   270,   271,     0,   272,   273,   274,   832,   833,
     834,   275,     0,   835,   836,     0,   276,   277,     0,   837,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   838,   839,   286,
     840,   841,   842,   843,   844,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   845,   297,   298,   299,
     300,   301,   302,   303,   846,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     847,   848,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   849,   318,   319,   850,   320,   321,   851,   322,
     852,   324,   325,     0,   853,   327,     0,   328,   854,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,   855,   856,   349,   350,     0,   351,   857,   353,
     858,   859,   860,   354,   355,   356,   357,   861,   358,   359,
       0,   360,   361,     0,   675,   362,   862,   863,   864,   865,
       0,     0,     0,     0,     0,   367,     0,   368,   866,   867,
     868,   370,   371,   372,     0,   869,   373,   374,   870,     0,
     375,     0,     0,   871,   872,   376,     0,     0,   377,     0,
     378,     0,   873,   380,     0,     0,   874,   875,   876,   877,
     878,   381,     0,     0,   382,   879,     0,   383,   384,   880,
       0,     0,     0,     0,   386,     0,   387,   388,     0,   881,
       0,   882,     0,     0,     0,     0,   883,     0,     0,     0,
     884,   885,     0,     0,     0,     0,   886,     0,   887,  1608,
       0,   888,   889,     0,   890,   891,   122,     0,   746,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   747,     0,   748,   130,   131,   749,   133,     0,   134,
     750,   135,     0,   751,   136,   752,   753,   754,   137,   755,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   756,   145,     0,   146,   757,   758,   148,     0,
     149,   150,   151,   759,   152,     0,   760,   154,     0,   155,
     156,   157,   158,   159,   761,   762,   160,     0,   161,   162,
       0,   763,   164,     0,   764,   765,   766,   165,     0,     0,
     166,   767,   768,     0,   769,   770,     0,   167,   168,   771,
     772,   773,     0,     0,     0,     0,   774,   171,   775,     0,
       0,   776,   777,   172,     0,   173,     0,     0,     0,   778,
     779,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   780,   182,     0,
     781,   782,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   783,     0,   191,   784,   192,   785,   786,
     193,   194,     0,   787,   195,   196,   197,   788,     0,   198,
       0,     0,   789,     0,   199,   200,     0,   790,   201,     0,
     202,   791,   792,   793,   794,     0,   795,   796,   204,   797,
     798,   799,   206,     0,   207,   800,     0,   801,   802,     0,
     208,   209,     0,   210,   803,     0,   211,     0,     0,     0,
     804,   213,   214,   215,   805,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   806,   219,   807,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   808,   226,     0,     0,   809,   227,     0,
     810,   228,     0,     0,     0,   811,     0,   812,     0,   230,
     813,     0,   231,     0,   232,   814,     0,     0,   815,     0,
       0,     0,     0,   816,   233,   234,   235,   236,   237,   238,
     817,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     818,   248,   249,   250,   819,   251,   252,     0,     0,     0,
     253,   254,   255,   820,   257,     0,     0,   821,   259,   822,
     823,   260,     0,   261,   824,   825,   826,   827,   828,   829,
     830,   266,   267,   268,   269,     0,   831,   270,   271,     0,
     272,   273,   274,   832,   833,   834,   275,     0,   835,   836,
       0,   276,   277,     0,   837,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   838,   839,   286,   840,   841,   842,   843,   844,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   845,   297,   298,   299,   300,   301,   302,   303,   846,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   847,   848,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   849,   318,   319,
     850,   320,   321,   851,   322,   852,   324,   325,     0,   853,
     327,     0,   328,   854,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,   855,   856,   349,
     350,     0,   351,   857,   353,   858,   859,   860,   354,   355,
     356,   357,   861,   358,   359,     0,   360,   361,     0,   675,
     362,   862,   863,   864,   865,     0,     0,     0,     0,     0,
     367,     0,   368,   866,   867,   868,   370,   371,   372,     0,
     869,   373,   374,   870,     0,   375,     0,     0,   871,   872,
     376,     0,     0,   377,     0,   378,     0,   873,   380,     0,
       0,   874,   875,   876,   877,   878,   381,     0,     0,   382,
     879,     0,   383,   384,   880,     0,     0,     0,     0,   386,
       0,   387,   388,     0,   881,     0,   882,     0,     0,     0,
       0,   883,     0,     0,     0,   884,   885,     0,     0,     0,
       0,   886,     0,   887,  1714,     0,   888,   889,     0,   890,
     891,   122,     0,   746,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   747,     0,   748,   130,
     131,   749,   133,     0,   134,   750,   135,     0,   751,   136,
     752,   753,   754,   137,   755,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   756,   145,     0,
     146,   757,   758,   148,     0,   149,   150,   151,   759,   152,
       0,   760,   154,     0,   155,   156,   157,   158,   159,   761,
     762,   160,     0,   161,   162,     0,   763,   164,     0,   764,
     765,   766,   165,     0,     0,   166,   767,   768,     0,   769,
     770,     0,   167,   168,   771,   772,   773,     0,     0,     0,
       0,   774,   171,   775,     0,     0,   776,   777,   172,     0,
     173,     0,     0,     0,   778,   779,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   780,   182,     0,   781,   782,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   783,     0,
     191,   784,   192,   785,   786,   193,   194,     0,   787,   195,
     196,   197,   788,     0,   198,     0,     0,   789,     0,   199,
     200,     0,   790,   201,     0,   202,   791,   792,   793,   794,
       0,   795,   796,   204,   797,   798,   799,   206,     0,   207,
     800,     0,   801,   802,     0,   208,   209,     0,   210,   803,
       0,   211,     0,     0,     0,   804,   213,   214,   215,   805,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   806,
     219,   807,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   808,   226,
       0,     0,   809,   227,     0,   810,   228,     0,     0,     0,
     811,     0,   812,     0,   230,   813,     0,   231,     0,   232,
     814,     0,     0,   815,     0,     0,     0,     0,   816,   233,
     234,   235,   236,   237,   238,   817,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   818,   248,   249,   250,   819,
     251,   252,     0,     0,     0,   253,   254,   255,   820,   257,
       0,     0,   821,   259,   822,   823,   260,     0,   261,   824,
     825,   826,   827,   828,   829,   830,   266,   267,   268,   269,
       0,   831,   270,   271,     0,   272,   273,   274,   832,   833,
     834,   275,     0,   835,   836,     0,   276,   277,     0,   837,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   838,   839,   286,
     840,   841,   842,   843,   844,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   845,   297,   298,   299,
     300,   301,   302,   303,   846,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     847,   848,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   849,   318,   319,   850,   320,   321,   851,   322,
     852,   324,   325,     0,   853,   327,     0,   328,   854,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,   855,   856,   349,   350,     0,   351,   857,   353,
     858,   859,   860,   354,   355,   356,   357,   861,   358,   359,
       0,   360,   361,     0,   675,   362,   862,   863,   864,   865,
       0,     0,     0,     0,     0,   367,     0,   368,   866,   867,
     868,   370,   371,   372,     0,   869,   373,   374,   870,     0,
     375,     0,     0,   871,   872,   376,     0,     0,   377,     0,
     378,     0,   873,   380,     0,     0,   874,   875,   876,   877,
     878,   381,     0,     0,   382,   879,     0,   383,   384,   880,
       0,     0,     0,     0,   386,     0,   387,   388,     0,   881,
       0,   882,     0,     0,     0,     0,   883,     0,     0,     0,
     884,   885,     0,     0,     0,     0,   886,     0,   887,  1751,
       0,   888,   889,     0,   890,   891,   122,     0,   746,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   747,     0,   748,   130,   131,   749,   133,     0,   134,
     750,   135,     0,   751,   136,   752,   753,   754,   137,   755,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   756,   145,     0,   146,   757,   758,   148,     0,
     149,   150,   151,   759,   152,     0,   760,   154,     0,   155,
     156,   157,   158,   159,   761,   762,   160,     0,   161,   162,
       0,   763,   164,     0,   764,   765,   766,   165,     0,     0,
     166,   767,   768,     0,   769,   770,     0,   167,   168,   771,
     772,   773,     0,     0,     0,     0,   774,   171,   775,     0,
       0,   776,   777,   172,     0,   173,     0,     0,     0,   778,
     779,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   780,   182,     0,
     781,   782,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   783,     0,   191,   784,   192,   785,   786,
     193,   194,     0,   787,   195,   196,   197,   788,     0,   198,
       0,     0,   789,     0,   199,   200,     0,   790,   201,     0,
     202,   791,   792,   793,   794,     0,   795,   796,   204,   797,
     798,   799,   206,     0,   207,   800,     0,   801,   802,     0,
     208,   209,     0,   210,   803,     0,   211,     0,     0,     0,
     804,   213,   214,   215,   805,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   806,   219,   807,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   808,   226,     0,     0,   809,   227,     0,
     810,   228,     0,     0,     0,   811,     0,   812,     0,   230,
     813,     0,   231,     0,   232,   814,     0,     0,   815,     0,
       0,     0,     0,   816,   233,   234,   235,   236,   237,   238,
     817,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     818,   248,   249,   250,   819,   251,   252,     0,     0,     0,
     253,   254,   255,   820,   257,     0,     0,   821,   259,   822,
     823,   260,     0,   261,   824,   825,   826,   827,   828,   829,
     830,   266,   267,   268,   269,     0,   831,   270,   271,     0,
     272,   273,   274,   832,   833,   834,   275,     0,   835,   836,
       0,   276,   277,     0,   837,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   838,   839,   286,   840,   841,   842,   843,   844,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   845,   297,   298,   299,   300,   301,   302,   303,   846,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   847,   848,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   849,   318,   319,
     850,   320,   321,   851,   322,   852,   324,   325,     0,   853,
     327,     0,   328,   854,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,   855,   856,   349,
     350,     0,   351,   857,   353,   858,   859,   860,   354,   355,
     356,   357,   861,   358,   359,     0,   360,   361,     0,   675,
     362,   862,   863,   864,   865,     0,     0,     0,     0,     0,
     367,     0,   368,   866,   867,   868,   370,   371,   372,     0,
     869,   373,   374,   870,     0,   375,     0,     0,   871,   872,
     376,     0,     0,   377,     0,   378,     0,   873,   380,     0,
       0,   874,   875,   876,   877,   878,   381,     0,     0,   382,
     879,     0,   383,   384,   880,     0,     0,     0,     0,   386,
       0,   387,   388,     0,   881,     0,   882,     0,     0,     0,
       0,   883,     0,     0,     0,   884,   885,     0,     0,     0,
       0,   886,     0,   887,  1779,     0,   888,   889,     0,   890,
     891,   122,     0,   746,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   747,     0,   748,   130,
     131,   749,   133,     0,   134,   750,   135,     0,   751,   136,
     752,   753,   754,   137,   755,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   756,   145,     0,
     146,   757,   758,   148,     0,   149,   150,   151,   759,   152,
       0,   760,   154,     0,   155,   156,   157,   158,   159,   761,
     762,   160,     0,   161,   162,     0,   763,   164,     0,   764,
     765,   766,   165,     0,     0,   166,   767,   768,     0,   769,
     770,     0,   167,   168,   771,   772,   773,     0,     0,     0,
       0,   774,   171,   775,     0,     0,   776,   777,   172,     0,
     173,     0,     0,     0,   778,   779,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   780,   182,     0,   781,   782,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   783,     0,
     191,   784,   192,   785,   786,   193,   194,     0,   787,   195,
     196,   197,   788,     0,   198,     0,     0,   789,     0,   199,
     200,  2224,   790,   201,     0,   202,   791,   792,   793,   794,
       0,   795,   796,   204,   797,   798,   799,   206,     0,   207,
     800,     0,   801,   802,     0,   208,   209,     0,   210,   803,
       0,   211,     0,     0,     0,   804,   213,   214,   215,   805,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   806,
     219,   807,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   808,   226,
       0,     0,   809,   227,     0,   810,   228,     0,     0,     0,
     811,     0,   812,     0,   230,   813,     0,   231,     0,   232,
     814,     0,     0,   815,     0,     0,     0,     0,   816,   233,
     234,   235,   236,   237,   238,   817,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   818,   248,   249,   250,   819,
     251,   252,     0,     0,     0,   253,   254,   255,   820,   257,
       0,     0,   821,   259,   822,   823,   260,     0,   261,   824,
     825,   826,   827,   828,   829,   830,   266,   267,   268,   269,
       0,   831,   270,   271,     0,   272,   273,   274,   832,   833,
     834,   275,     0,   835,   836,     0,   276,   277,     0,   837,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   838,   839,   286,
     840,   841,   842,   843,   844,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   845,   297,   298,   299,
     300,   301,   302,   303,   846,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     847,   848,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   849,   318,   319,   850,   320,   321,   851,   322,
     852,   324,   325,     0,   853,   327,     0,   328,   854,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,   855,   856,   349,   350,     0,   351,   857,   353,
     858,   859,   860,   354,   355,   356,   357,   861,   358,   359,
       0,   360,   361,     0,   675,   362,   862,   863,   864,   865,
       0,     0,     0,     0,     0,   367,     0,   368,   866,   867,
     868,   370,   371,   372,     0,   869,   373,   374,   870,     0,
     375,     0,     0,   871,   872,   376,     0,     0,   377,     0,
     378,     0,   873,   380,     0,     0,   874,   875,   876,   877,
     878,   381,     0,     0,   382,   879,     0,   383,   384,   880,
       0,     0,     0,     0,   386,     0,   387,   388,     0,   881,
       0,   882,     0,     0,     0,     0,   883,     0,     0,     0,
     884,   885,     0,     0,     0,     0,   886,     0,   887,     0,
       0,   888,   889,     0,   890,   891,   122,     0,   746,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   747,     0,   748,   130,   131,   749,   133,     0,   134,
     750,   135,     0,   751,   136,   752,   753,   754,   137,   755,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   756,   145,     0,   146,   757,   758,   148,     0,
     149,   150,   151,   759,   152,     0,   760,   154,     0,   155,
     156,   157,   158,   159,   761,   762,   160,     0,   161,   162,
       0,   763,   164,     0,   764,   765,   766,   165,     0,     0,
     166,   767,   768,     0,   769,   770,     0,   167,   168,   771,
     772,   773,     0,     0,     0,     0,   774,   171,   775,     0,
       0,   776,   777,   172,     0,   173,     0,     0,     0,   778,
     779,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   780,   182,     0,
     781,   782,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   783,     0,   191,   784,   192,   785,   786,
     193,   194,     0,   787,   195,   196,   197,   788,     0,   198,
       0,     0,   789,     0,   199,   200,  2226,   790,   201,     0,
     202,   791,   792,   793,   794,     0,   795,   796,   204,   797,
     798,   799,   206,     0,   207,   800,     0,   801,   802,     0,
     208,   209,     0,   210,   803,     0,   211,     0,     0,     0,
     804,   213,   214,   215,   805,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   806,   219,   807,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   808,   226,     0,     0,   809,   227,     0,
     810,   228,     0,     0,     0,   811,     0,   812,     0,   230,
     813,     0,   231,     0,   232,   814,     0,     0,   815,     0,
       0,     0,     0,   816,   233,   234,   235,   236,   237,   238,
     817,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     818,   248,   249,   250,   819,   251,   252,     0,     0,     0,
     253,   254,   255,   820,   257,     0,     0,   821,   259,   822,
     823,   260,     0,   261,   824,   825,   826,   827,   828,   829,
     830,   266,   267,   268,   269,     0,   831,   270,   271,     0,
     272,   273,   274,   832,   833,   834,   275,     0,   835,   836,
       0,   276,   277,     0,   837,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   838,   839,   286,   840,   841,   842,   843,   844,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   845,   297,   298,   299,   300,   301,   302,   303,   846,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   847,   848,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   849,   318,   319,
     850,   320,   321,   851,   322,   852,   324,   325,     0,   853,
     327,     0,   328,   854,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,   855,   856,   349,
     350,     0,   351,   857,   353,   858,   859,   860,   354,   355,
     356,   357,   861,   358,   359,     0,   360,   361,     0,   675,
     362,   862,   863,   864,   865,     0,     0,     0,     0,     0,
     367,     0,   368,   866,   867,   868,   370,   371,   372,     0,
     869,   373,   374,   870,     0,   375,     0,     0,   871,   872,
     376,     0,     0,   377,     0,   378,     0,   873,   380,     0,
       0,   874,   875,   876,   877,   878,   381,     0,     0,   382,
     879,     0,   383,   384,   880,     0,     0,     0,     0,   386,
       0,   387,   388,     0,   881,     0,   882,     0,     0,     0,
       0,   883,     0,     0,     0,   884,   885,     0,     0,     0,
       0,   886,     0,   887,     0,     0,   888,   889,     0,   890,
     891,   122,     0,   746,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   747,     0,   748,   130,
     131,   749,   133,     0,   134,   750,   135,     0,   751,   136,
     752,   753,   754,   137,   755,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   756,   145,     0,
     146,   757,   758,   148,     0,   149,   150,   151,   759,   152,
       0,   760,   154,     0,   155,   156,   157,   158,   159,   761,
     762,   160,     0,   161,   162,     0,   763,   164,     0,   764,
     765,   766,   165,     0,     0,   166,   767,   768,     0,   769,
     770,     0,   167,   168,   771,   772,   773,     0,     0,     0,
       0,   774,   171,   775,     0,     0,   776,   777,   172,     0,
     173,     0,     0,     0,   778,   779,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   780,   182,     0,   781,   782,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   783,     0,
     191,   784,   192,   785,   786,   193,   194,     0,   787,   195,
     196,   197,   788,     0,   198,     0,     0,   789,     0,   199,
     200,  2228,   790,   201,     0,   202,   791,   792,   793,   794,
       0,   795,   796,   204,   797,   798,   799,   206,     0,   207,
     800,     0,   801,   802,     0,   208,   209,     0,   210,   803,
       0,   211,     0,     0,     0,   804,   213,   214,   215,   805,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   806,
     219,   807,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   808,   226,
       0,     0,   809,   227,     0,   810,   228,     0,     0,     0,
     811,     0,   812,     0,   230,   813,     0,   231,     0,   232,
     814,     0,     0,   815,     0,     0,     0,     0,   816,   233,
     234,   235,   236,   237,   238,   817,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   818,   248,   249,   250,   819,
     251,   252,     0,     0,     0,   253,   254,   255,   820,   257,
       0,     0,   821,   259,   822,   823,   260,     0,   261,   824,
     825,   826,   827,   828,   829,   830,   266,   267,   268,   269,
       0,   831,   270,   271,     0,   272,   273,   274,   832,   833,
     834,   275,     0,   835,   836,     0,   276,   277,     0,   837,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   838,   839,   286,
     840,   841,   842,   843,   844,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   845,   297,   298,   299,
     300,   301,   302,   303,   846,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     847,   848,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   849,   318,   319,   850,   320,   321,   851,   322,
     852,   324,   325,     0,   853,   327,     0,   328,   854,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,   855,   856,   349,   350,     0,   351,   857,   353,
     858,   859,   860,   354,   355,   356,   357,   861,   358,   359,
       0,   360,   361,     0,   675,   362,   862,   863,   864,   865,
       0,     0,     0,     0,     0,   367,     0,   368,   866,   867,
     868,   370,   371,   372,     0,   869,   373,   374,   870,     0,
     375,     0,     0,   871,   872,   376,     0,     0,   377,     0,
     378,     0,   873,   380,     0,     0,   874,   875,   876,   877,
     878,   381,     0,     0,   382,   879,     0,   383,   384,   880,
       0,     0,     0,     0,   386,     0,   387,   388,     0,   881,
       0,   882,     0,     0,     0,     0,   883,     0,     0,     0,
     884,   885,     0,     0,     0,     0,   886,     0,   887,     0,
       0,   888,   889,     0,   890,   891,   122,     0,   746,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   747,     0,   748,   130,   131,   749,   133,     0,   134,
     750,   135,     0,   751,   136,   752,   753,   754,   137,   755,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   756,   145,     0,   146,   757,   758,   148,     0,
     149,   150,   151,   759,   152,     0,   760,   154,     0,   155,
     156,   157,   158,   159,   761,   762,   160,     0,   161,   162,
       0,   763,   164,     0,   764,   765,   766,   165,     0,     0,
     166,   767,   768,     0,   769,   770,     0,   167,   168,   771,
     772,   773,     0,     0,     0,     0,   774,   171,   775,     0,
       0,   776,   777,   172,     0,   173,     0,     0,     0,   778,
     779,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   780,   182,     0,
     781,   782,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   783,     0,   191,   784,   192,   785,   786,
     193,   194,     0,   787,   195,   196,   197,   788,     0,   198,
       0,     0,   789,     0,   199,   200,     0,   790,   201,     0,
     202,   791,   792,   793,   794,     0,   795,   796,   204,   797,
     798,   799,   206,     0,   207,   800,     0,   801,   802,     0,
     208,   209,     0,   210,   803,     0,   211,     0,     0,     0,
     804,   213,   214,   215,   805,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   806,   219,   807,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   808,   226,     0,     0,   809,   227,     0,
     810,   228,     0,     0,     0,   811,     0,   812,     0,   230,
     813,     0,   231,     0,   232,   814,     0,     0,   815,     0,
       0,     0,     0,   816,   233,   234,   235,   236,   237,   238,
     817,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     818,   248,   249,   250,   819,   251,   252,     0,     0,     0,
     253,   254,   255,   820,   257,     0,     0,   821,   259,   822,
     823,   260,     0,   261,   824,   825,   826,   827,   828,   829,
     830,   266,   267,   268,   269,     0,   831,   270,   271,     0,
     272,   273,   274,   832,   833,   834,   275,     0,   835,   836,
       0,   276,   277,     0,   837,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   838,   839,   286,   840,   841,   842,   843,   844,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   845,   297,   298,   299,   300,   301,   302,   303,   846,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   847,   848,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   849,   318,   319,
     850,   320,   321,   851,   322,   852,   324,   325,     0,   853,
     327,     0,   328,   854,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,   855,   856,   349,
     350,     0,   351,   857,   353,   858,   859,   860,   354,   355,
     356,   357,   861,   358,   359,     0,   360,   361,     0,   675,
     362,   862,   863,   864,   865,     0,     0,     0,     0,     0,
     367,     0,   368,   866,   867,   868,   370,   371,   372,     0,
     869,   373,   374,   870,     0,   375,     0,     0,   871,   872,
     376,     0,     0,   377,     0,   378,     0,   873,   380,     0,
       0,   874,   875,   876,   877,   878,   381,     0,     0,   382,
     879,     0,   383,   384,   880,     0,     0,     0,     0,   386,
       0,   387,   388,     0,   881,     0,   882,     0,     0,     0,
       0,   883,     0,     0,     0,   884,   885,     0,     0,     0,
       0,   886,     0,   887,     0,     0,   888,   889,     0,   890,
     891,   122,     0,   746,   124,   125,   126,   127,  1811,     0,
       0,     0,     0,  1812,     0,     0,   747,     0,   748,   130,
     131,   749,   133,     0,   134,   750,   135,     0,   751,   136,
     752,   753,   754,   137,   755,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   756,   145,     0,
     146,   757,   758,   148,     0,   149,   150,   151,   759,   152,
       0,   760,   154,     0,   155,   156,   157,   158,   159,   761,
     762,   160,     0,   161,   162,     0,   763,   164,     0,   764,
     765,   766,   165,     0,     0,   166,   767,   768,     0,   769,
     770,     0,   167,   168,   771,   772,   773,     0,     0,     0,
       0,   774,   171,   775,     0,     0,   776,   777,   172,     0,
     173,     0,     0,     0,   778,   779,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   780,   182,     0,   781,   782,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   783,     0,
     191,   784,   192,   785,   786,   193,   194,     0,   787,   195,
     196,   197,   788,     0,   198,     0,     0,   789,     0,   199,
     200,     0,   790,   201,     0,   202,   791,   792,   793,   794,
       0,   795,   796,   204,   797,   798,   799,   206,     0,   207,
     800,     0,   801,   802,     0,   208,   209,     0,   210,   803,
       0,   211,     0,     0,     0,   804,   213,   214,   215,   805,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   806,
     219,   807,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   808,   226,
       0,     0,   809,   227,     0,   810,   228,     0,     0,     0,
     811,     0,   812,     0,   230,   813,     0,   231,     0,   232,
     814,     0,     0,   815,     0,     0,     0,     0,   816,   233,
     234,   235,   236,   237,   238,   817,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   818,   248,   249,   250,   819,
     251,   252,     0,     0,     0,   253,   254,   255,   820,   257,
       0,     0,   821,   259,   822,   823,   260,     0,   261,   824,
     825,   826,   827,   828,   829,   830,   266,   267,   268,   269,
       0,   831,   270,   271,     0,   272,   273,   274,   832,     0,
     834,   275,     0,   835,   836,     0,   276,   277,     0,   837,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   838,   839,   286,
     840,   841,   842,   843,   844,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   845,   297,   298,   299,
     300,   301,   302,   303,   846,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     847,   848,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   849,   318,   319,   850,   320,   321,   851,   322,
     852,   324,   325,     0,   853,   327,     0,   328,   854,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,   855,   856,   349,   350,     0,   351,   857,   353,
     858,   859,   860,   354,   355,   356,   357,   861,   358,   359,
       0,   360,   361,     0,   675,   362,   862,   863,   864,   865,
       0,     0,     0,     0,     0,   367,     0,   368,   866,   867,
     868,   370,   371,   372,     0,   869,   373,   374,   870,     0,
     375,     0,     0,   871,   872,   376,     0,     0,   377,     0,
     378,     0,   873,   380,     0,     0,   874,   875,   876,   877,
     878,   381,     0,     0,   382,   879,     0,   383,   384,   880,
       0,     0,     0,     0,   386,     0,   387,   388,     0,   881,
       0,   882,     0,     0,     0,     0,   883,     0,     0,     0,
     884,   885,     0,     0,     0,     0,   886,     0,   887,     0,
       0,   888,   889,     0,   890,   891,   122,     0,   746,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   747,     0,   748,   130,   131,   749,   133,     0,   134,
     750,   135,     0,   751,   136,   752,   753,   754,   137,   755,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   756,   145,     0,   146,   757,   758,   148,     0,
     149,   150,   151,   759,   152,     0,   760,   154,     0,   155,
     156,   157,   158,   159,   761,   762,   160,     0,   161,   162,
       0,   763,   164,     0,   764,   765,   766,   165,     0,     0,
     166,   767,   768,     0,   769,   770,     0,   167,   168,   771,
     772,   773,     0,     0,     0,     0,   774,   171,   775,     0,
       0,   776,   777,   172,     0,   173,     0,     0,     0,   778,
     779,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   780,   182,     0,
     781,   782,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   783,     0,   191,   784,   192,   785,   786,
     193,   194,     0,   787,   195,   196,   197,   788,     0,   198,
       0,     0,   789,     0,   199,   200,     0,   790,   201,     0,
     202,   791,   792,   793,   794,     0,   795,   796,   204,   797,
     798,   799,   206,     0,   207,   800,     0,   801,   802,     0,
     208,   209,     0,   210,   803,     0,   211,     0,     0,     0,
     804,   213,   214,   215,   805,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   806,   219,  2506,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   808,   226,     0,     0,   809,   227,     0,
     810,   228,     0,     0,     0,   811,     0,   812,     0,   230,
     813,     0,   231,     0,   232,   814,     0,     0,   815,     0,
       0,     0,     0,   816,   233,   234,   235,   236,   237,   238,
     817,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     818,   248,   249,   250,   819,   251,   252,     0,     0,     0,
     253,   254,   255,   820,   257,     0,     0,   821,   259,   822,
     823,   260,     0,   261,   824,   825,   826,   827,   828,   829,
     830,   266,   267,   268,   269,     0,   831,   270,   271,     0,
     272,   273,   274,   832,   833,   834,   275,     0,   835,   836,
       0,   276,   277,     0,   837,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   838,   839,   286,   840,   841,   842,   843,   844,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   845,   297,   298,   299,   300,   301,   302,   303,   846,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   847,   848,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   849,   318,   319,
     850,   320,   321,   851,   322,   852,   324,   325,     0,   853,
     327,     0,   328,   854,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,   855,   856,   349,
     350,     0,   351,   857,   353,   858,   859,   860,   354,   355,
     356,   357,   861,   358,   359,     0,   360,   361,     0,   675,
     362,   862,   863,   864,   865,     0,     0,     0,     0,     0,
     367,     0,   368,   866,   867,   868,   370,   371,   372,     0,
     869,   373,   374,   870,     0,   375,     0,     0,   871,   872,
     376,     0,     0,   377,     0,   378,     0,   873,   380,     0,
       0,   874,   875,   876,   877,   878,   381,     0,     0,   382,
     879,     0,   383,   384,   880,     0,     0,     0,     0,   386,
       0,   387,   388,     0,   881,     0,   882,     0,     0,     0,
       0,   883,     0,     0,     0,   884,   885,     0,     0,     0,
       0,   886,     0,   887,     0,     0,   888,   889,     0,   890,
     891,   122,     0,   746,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   747,     0,   748,   130,
     131,   749,   133,     0,   134,   750,   135,     0,   751,   136,
     752,   753,   754,   137,   755,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   756,   145,     0,
     146,   757,   758,   148,     0,   149,   150,   151,   759,   152,
       0,   760,   154,     0,   155,   156,   157,   158,   159,   761,
     762,   160,     0,   161,   162,     0,   763,   164,     0,   764,
     765,   766,   165,     0,     0,   166,   767,   768,     0,   769,
     770,     0,   167,   168,   771,   772,   773,     0,     0,     0,
       0,   774,   171,   775,     0,     0,   776,   777,   172,     0,
     173,     0,     0,     0,   778,   779,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   780,   182,     0,   781,   782,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   783,     0,
     191,   784,   192,   785,   786,   193,   194,     0,   787,   195,
     196,   197,   788,     0,   198,     0,     0,   789,     0,   199,
     200,     0,   790,   201,     0,   202,   791,   792,   793,   794,
       0,   795,   796,   204,   797,   798,   799,   206,     0,   207,
     800,     0,   801,   802,     0,   208,   209,     0,   210,   803,
       0,   211,     0,     0,     0,   804,   213,   214,   215,   805,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   806,
     219,  2579,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   808,   226,
       0,     0,   809,   227,     0,   810,   228,     0,     0,     0,
     811,     0,   812,     0,   230,   813,     0,   231,     0,   232,
     814,     0,     0,   815,     0,     0,     0,     0,   816,   233,
     234,   235,   236,   237,   238,   817,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   818,   248,   249,   250,   819,
     251,   252,     0,     0,     0,   253,   254,   255,   820,   257,
       0,     0,   821,   259,   822,   823,   260,     0,   261,   824,
     825,   826,   827,   828,   829,   830,   266,   267,   268,   269,
       0,   831,   270,   271,     0,   272,   273,   274,   832,   833,
     834,   275,     0,   835,   836,     0,   276,   277,     0,   837,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   838,   839,   286,
     840,   841,   842,   843,   844,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   845,   297,   298,   299,
     300,   301,   302,   303,   846,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     847,   848,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   849,   318,   319,   850,   320,   321,   851,   322,
     852,   324,   325,     0,   853,   327,     0,   328,   854,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,   855,   856,   349,   350,     0,   351,   857,   353,
     858,   859,   860,   354,   355,   356,   357,   861,   358,   359,
       0,   360,   361,     0,   675,   362,   862,   863,   864,   865,
       0,     0,     0,     0,     0,   367,     0,   368,   866,   867,
     868,   370,   371,   372,     0,   869,   373,   374,   870,     0,
     375,     0,     0,   871,   872,   376,     0,     0,   377,     0,
     378,     0,   873,   380,     0,     0,   874,   875,   876,   877,
     878,   381,     0,     0,   382,   879,     0,   383,   384,   880,
       0,     0,     0,     0,   386,     0,   387,   388,     0,   881,
       0,   882,     0,     0,     0,     0,   883,     0,     0,     0,
     884,   885,     0,     0,     0,     0,   886,     0,   887,     0,
       0,   888,   889,     0,   890,   891,   122,     0,   746,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   747,     0,   748,   130,   131,   749,   133,     0,   134,
     750,   135,     0,   751,   136,   752,   753,   754,   137,   755,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   756,   145,     0,   146,   757,   758,   148,     0,
     149,   150,   151,   759,   152,     0,   760,   154,     0,   155,
     156,   157,   158,   159,   761,   762,   160,     0,   161,   162,
       0,   763,   164,     0,   764,   765,   766,   165,     0,     0,
     166,   767,   768,     0,   769,   770,     0,   167,   168,   771,
     772,   773,     0,     0,     0,     0,   774,   171,   775,     0,
       0,   776,  2928,   172,     0,   173,     0,     0,     0,   778,
     779,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   780,   182,     0,
     781,   782,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   783,     0,   191,   784,   192,   785,   786,
     193,   194,     0,   787,   195,   196,   197,   788,     0,   198,
       0,     0,   789,     0,   199,   200,     0,   790,   201,     0,
     202,   791,   792,   793,   794,     0,   795,   796,   204,   797,
     798,   799,   206,     0,   207,   800,     0,   801,   802,     0,
     208,   209,     0,   210,   803,     0,   211,     0,     0,     0,
     804,   213,   214,   215,   805,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   806,   219,   807,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   808,   226,     0,     0,   809,   227,     0,
     810,   228,     0,     0,     0,   811,     0,   812,     0,   230,
     813,     0,   231,     0,   232,   814,     0,     0,   815,     0,
       0,     0,     0,   816,   233,   234,   235,   236,   237,   238,
     817,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     818,   248,   249,   250,   819,   251,   252,     0,     0,     0,
     253,   254,   255,   820,   257,     0,     0,   821,   259,   822,
     823,   260,     0,   261,   824,   825,   826,   827,   828,   829,
     830,   266,   267,   268,   269,     0,   831,   270,   271,     0,
     272,   273,   274,   832,   833,   834,   275,     0,   835,   836,
       0,   276,   277,     0,   837,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   838,   839,   286,   840,   841,   842,   843,   844,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   845,   297,   298,   299,   300,   301,   302,   303,   846,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   847,   848,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   849,   318,   319,
     850,   320,   321,   851,   322,   852,   324,   325,     0,   853,
     327,     0,   328,   854,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,   855,   856,   349,
     350,     0,   351,   857,   353,   858,   859,   860,   354,   355,
     356,   357,   861,   358,   359,     0,   360,   361,     0,   675,
     362,   862,   863,   864,   865,     0,     0,     0,     0,     0,
     367,     0,   368,   866,   867,   868,   370,   371,   372,     0,
     869,   373,   374,   870,     0,   375,     0,     0,   871,   872,
     376,     0,     0,   377,     0,   378,     0,   873,   380,     0,
       0,   874,   875,   876,   877,   878,   381,     0,     0,   382,
     879,     0,   383,   384,   880,     0,     0,     0,     0,   386,
       0,   387,   388,     0,   881,     0,   882,     0,     0,     0,
       0,   883,     0,     0,     0,   884,   885,     0,     0,     0,
       0,   886,     0,   887,     0,     0,   888,   889,     0,   890,
     891,   122,     0,   746,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   747,     0,   748,   130,
     131,   749,   133,     0,   134,   750,   135,     0,   751,   136,
     752,   753,   754,   137,   755,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   756,   145,     0,
     146,   757,   758,   148,     0,   149,   150,   151,   759,   152,
       0,   760,   154,     0,   155,   156,   157,   158,   159,   761,
     762,   160,     0,   161,   162,     0,   763,   164,     0,   764,
     765,   766,   165,     0,     0,   166,   767,   768,     0,   769,
     770,     0,   167,   168,   771,   772,   773,     0,     0,     0,
       0,   774,   171,   775,     0,     0,   776,   777,   172,     0,
     173,     0,     0,     0,   778,   779,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   780,   182,     0,   781,   782,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   783,     0,
     191,   784,   192,   785,   786,   193,   194,     0,   787,   195,
     196,   197,   788,     0,   198,     0,     0,   789,     0,   199,
     200,     0,   790,   201,     0,   202,   791,   792,   793,   794,
       0,   795,   796,   204,   797,   798,   799,   206,     0,   207,
     800,     0,   801,   802,     0,   208,   209,     0,   210,   803,
       0,   211,     0,     0,     0,   804,   213,   214,   215,   805,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   806,
     219,   807,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   808,   226,
       0,     0,   809,   227,     0,   810,   228,     0,     0,     0,
     811,     0,   812,     0,   230,   813,     0,   231,     0,   232,
     814,     0,     0,   815,     0,     0,     0,     0,   816,   233,
     234,   235,   236,   237,   238,   817,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   818,   248,   249,   250,   819,
     251,   252,     0,     0,     0,   253,   254,   255,   820,   257,
       0,     0,   821,   259,   822,   823,   260,     0,   261,   824,
     825,   826,   827,   828,   829,   830,   266,   267,   268,   269,
       0,   831,   270,   271,     0,   272,   273,   274,   832,     0,
     834,   275,     0,   835,   836,     0,   276,   277,     0,   837,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   838,   839,   286,
     840,   841,   842,   843,   844,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   845,   297,   298,   299,
     300,   301,   302,   303,   846,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     847,   848,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   849,   318,   319,   850,   320,   321,   851,   322,
     852,   324,   325,     0,   853,   327,     0,   328,   854,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,   855,   856,   349,   350,     0,   351,   857,   353,
     858,   859,   860,   354,   355,   356,   357,   861,   358,   359,
       0,   360,   361,     0,   675,   362,   862,   863,   864,   865,
       0,     0,     0,     0,     0,   367,     0,   368,   866,   867,
     868,   370,   371,   372,     0,   869,   373,   374,   870,     0,
     375,     0,     0,   871,   872,   376,     0,     0,   377,     0,
     378,     0,   873,   380,     0,     0,   874,   875,   876,   877,
     878,   381,     0,     0,   382,   879,     0,   383,   384,   880,
       0,     0,     0,     0,   386,     0,   387,   388,     0,   881,
       0,   882,     0,     0,     0,     0,   883,     0,     0,     0,
     884,   885,     0,     0,     0,     0,   886,     0,   887,     0,
       0,   888,   889,     0,   890,   891,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
    1989,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,  1990,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,  1120,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,  1121,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,  2490,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,  1898,   328,     0,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
    1991,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,     0,     0,   349,
     350,     0,   351,   352,   353,     0,     0,     0,   354,   355,
     356,   357,     0,   358,   359,     0,   360,   361,     0,     0,
     362,   363,   364,   365,   366,     0,     0,     0,     0,     0,
     367,     0,   368,     0,     0,   369,   370,   371,   372,     0,
       0,   373,   374,     0,     0,   375,     0,     0,     0,     0,
     376,     0,     0,   377,     0,   378,     0,   379,   380,     0,
       0,     0,     0,     0,     0,     0,   381,     0,     0,   382,
       0,     0,   383,   384,   385,     0,     0,     0,     0,   386,
       0,   387,   388,     0,     0,     0,   389,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
    2038,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,  1989,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,  1990,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
    1120,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,  1121,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,   328,     0,   329,   330,     0,     0,
       0,     0,   331,     0,     0,   332,   333,   334,     0,     0,
     335,     0,     0,     0,   336,   337,   338,   339,     0,   340,
     341,   342,  1991,     0,     0,     0,     0,     0,   343,   344,
       0,   345,     0,     0,   346,     0,     0,   347,   348,     0,
       0,   349,   350,     0,   351,   352,   353,     0,     0,     0,
     354,   355,   356,   357,     0,   358,   359,     0,   360,   361,
       0,     0,   362,   363,   364,   365,   366,     0,     0,     0,
       0,     0,   367,     0,   368,     0,     0,   369,   370,   371,
     372,     0,     0,   373,   374,     0,     0,   375,     0,     0,
       0,     0,   376,     0,     0,   377,     0,   378,     0,   379,
     380,     0,     0,     0,     0,     0,     0,     0,   381,     0,
       0,   382,     0,     0,   383,   384,   385,     0,     0,     0,
       0,   386,     0,   387,   388,     0,     0,     0,   389,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,  2038,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,  1898,   328,     0,   329,   330,
       0,     0,     0,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,     0,
     389,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,  2315,     0,
     130,   131,   132,   133,   891,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,   328,     0,
     329,   330,     0,     0,     0,     0,   331,     0,     0,   332,
     333,   334,     0,     0,   335,     0,     0,     0,   336,   337,
     338,   339,     0,   340,   341,   342,     0,     0,     0,     0,
       0,     0,   343,   344,     0,   345,     0,     0,   346,     0,
       0,   347,   348,     0,     0,   349,   350,     0,   351,   352,
     353,     0,     0,     0,   354,   355,   356,   357,     0,   358,
     359,     0,   360,   361,     0,     0,   362,   363,   364,   365,
     366,     0,     0,     0,     0,     0,   367,     0,   368,     0,
       0,   369,   370,   371,   372,     0,     0,   373,   374,     0,
       0,   375,     0,     0,     0,     0,   376,     0,     0,   377,
       0,   378,     0,   379,   380,     0,     0,     0,     0,     0,
       0,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,     0,     0,     0,     0,   386,     0,   387,   388,     0,
       0,     0,   389,     0,     0,     0,     0,     0,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
    3680,   128,     0,     0,   129,  3681,   891,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
     993,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,     0,   329,   330,     0,
       0,     0,     0,   331,     0,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,     0,
     340,   341,   342,     0,     0,     0,     0,     0,     0,   343,
     344,     0,   345,     0,     0,   346,     0,     0,   347,   348,
       0,     0,   349,   350,     0,   351,   352,   353,     0,     0,
       0,   354,   355,   356,   357,     0,   358,   359,     0,   360,
     361,     0,     0,   362,   363,   364,   365,   366,     0,     0,
       0,     0,     0,   367,     0,   368,     0,     0,   369,   370,
     371,   372,     0,     0,   373,   374,     0,     0,   375,     0,
       0,     0,     0,   376,     0,     0,   377,     0,   378,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
       0,     0,   386,     0,   387,   388,     0,     0,     0,   389,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   425,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,     0,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,     0,     0,   349,   350,     0,   351,   352,   353,
       0,     0,     0,   354,   355,   356,   357,     0,   358,   359,
       0,   360,   361,     0,     0,   362,   363,   364,   365,   366,
       0,     0,     0,     0,     0,   367,     0,   368,     0,     0,
     369,   370,   371,   372,     0,     0,   373,   374,     0,     0,
     375,     0,     0,     0,     0,   376,     0,     0,   377,     0,
     378,     0,   379,   380,     0,     0,     0,     0,     0,     0,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,     0,     0,   386,     0,   387,   388,     0,     0,
       0,   389,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,  1856,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   425,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,   328,
       0,   329,   330,     0,     0,     0,     0,   331,     0,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,     0,   340,   341,   342,     0,     0,     0,
       0,     0,     0,   343,   344,     0,   345,     0,     0,   346,
       0,     0,   347,   348,     0,     0,   349,   350,     0,   351,
     352,   353,     0,     0,     0,   354,   355,   356,   357,     0,
     358,   359,     0,   360,   361,     0,     0,   362,   363,   364,
     365,   366,     0,     0,     0,     0,     0,   367,     0,   368,
       0,     0,   369,   370,   371,   372,     0,     0,   373,   374,
       0,     0,   375,     0,     0,     0,     0,   376,     0,     0,
     377,     0,   378,     0,   379,   380,     0,     0,     0,     0,
       0,     0,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,     0,     0,   386,     0,   387,   388,
       0,     0,     0,   389,     0,     0,     0,     0,     0,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
    2037,     0,   128,     0,     0,   129,     0,  2038,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,   328,     0,   329,   330,
       0,     0,     0,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,     0,
     389,     0,     0,     0,     0,     0,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,  3681,   891,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,   328,     0,   329,   330,     0,     0,     0,
       0,   331,     0,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,     0,   340,   341,
     342,     0,     0,     0,     0,     0,     0,   343,   344,     0,
     345,     0,     0,   346,     0,     0,   347,   348,     0,     0,
     349,   350,     0,   351,   352,   353,     0,     0,     0,   354,
     355,   356,   357,     0,   358,   359,     0,   360,   361,     0,
       0,   362,   363,   364,   365,   366,     0,     0,     0,     0,
       0,   367,     0,   368,     0,     0,   369,   370,   371,   372,
       0,     0,   373,   374,     0,     0,   375,     0,     0,     0,
       0,   376,     0,     0,   377,     0,   378,     0,   379,   380,
       0,     0,     0,     0,     0,     0,     0,   381,     0,     0,
     382,     0,     0,   383,   384,   385,     0,     0,     0,     0,
     386,     0,   387,   388,     0,     0,     0,   389,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,   425,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     479,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,     0,   329,   330,     0,
       0,     0,     0,   331,     0,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,     0,
     340,   341,   342,     0,     0,     0,     0,     0,     0,   343,
     344,     0,   345,     0,     0,   346,     0,     0,   347,   348,
       0,     0,   349,   350,     0,   351,   352,   353,     0,     0,
       0,   354,   355,   356,   357,     0,   358,   359,     0,   360,
     361,     0,     0,   362,   363,   364,   365,   366,     0,     0,
       0,     0,     0,   367,     0,   368,     0,     0,   369,   370,
     371,   372,     0,     0,   373,   374,     0,     0,   375,     0,
       0,     0,     0,   376,     0,     0,   377,     0,   378,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
       0,     0,   386,     0,   387,   388,     0,     0,     0,   389,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   425,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,     0,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,     0,     0,   349,   350,     0,   351,   352,   353,
       0,     0,     0,   354,   355,   356,   357,     0,   358,   359,
       0,   360,   361,     0,     0,   362,   363,   364,   365,   366,
       0,     0,     0,     0,     0,   367,     0,   368,     0,     0,
     369,   370,   371,   372,     0,     0,   373,   374,     0,     0,
     375,     0,     0,     0,     0,   376,     0,     0,   377,     0,
     378,     0,   379,   380,     0,     0,     0,     0,     0,     0,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,     0,     0,   386,     0,   387,   388,     0,     0,
       0,   389,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   891,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,   328,
       0,   329,   330,     0,     0,     0,     0,   331,     0,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,     0,   340,   341,   342,     0,     0,     0,
       0,     0,     0,   343,   344,     0,   345,     0,     0,   346,
       0,     0,   347,   348,     0,     0,   349,   350,     0,   351,
     352,   353,     0,     0,     0,   354,   355,   356,   357,     0,
     358,   359,     0,   360,   361,     0,     0,   362,   363,   364,
     365,   366,     0,     0,     0,     0,     0,   367,     0,   368,
       0,     0,   369,   370,   371,   372,     0,     0,   373,   374,
       0,     0,   375,     0,     0,     0,     0,   376,     0,     0,
     377,     0,   378,     0,   379,   380,     0,     0,     0,     0,
       0,     0,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,     0,     0,   386,     0,   387,   388,
       0,     0,     0,   389,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,  2038,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   564,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,     0,   329,   330,     0,     0,     0,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,   565,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,  1798,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     564,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,     0,   329,   330,     0,     0,     0,     0,   331,     0,
       0,   332,   333,   334,     0,     0,   335,     0,     0,     0,
     336,   337,   338,   339,     0,   340,   341,   342,     0,     0,
       0,     0,     0,     0,   343,   344,     0,   345,     0,     0,
     346,     0,     0,   347,   348,     0,     0,   349,   350,     0,
     351,   352,   353,     0,     0,     0,   354,   355,   356,   357,
       0,   358,   359,     0,   360,   361,     0,   565,   362,   363,
     364,   365,   366,     0,     0,     0,     0,     0,   367,     0,
     368,     0,     0,   369,   370,   371,   372,     0,     0,   373,
     374,     0,     0,   375,     0,     0,     0,     0,   376,     0,
       0,   377,     0,   378,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   381,     0,     0,   382,     0,     0,
     383,   384,   385,     0,     0,     0,     0,   386,     0,   387,
     388,     0,     0,   122,   389,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,  2355,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,   564,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,   328,
       0,   329,   330,     0,     0,     0,     0,   331,     0,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,     0,   340,   341,   342,     0,     0,     0,
       0,     0,     0,   343,   344,     0,   345,     0,     0,   346,
       0,     0,   347,   348,     0,     0,   349,   350,     0,   351,
     352,   353,     0,     0,     0,   354,   355,   356,   357,     0,
     358,   359,     0,   360,   361,     0,   565,   362,   363,   364,
     365,   366,     0,     0,     0,     0,     0,   367,     0,   368,
       0,     0,   369,   370,   371,   372,     0,     0,   373,   374,
       0,     0,   375,     0,     0,     0,     0,   376,     0,     0,
     377,     0,   378,     0,   379,   380,     0,     0,     0,     0,
       0,     0,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,     0,     0,   386,     0,   387,   388,
       0,     0,   122,   389,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -186,  2951,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,     0,     0,     0,     0,   144,     0,   145,
       0,   146,     0,     0,     0,     0,   149,   150,  3523,     0,
     152,     0,   153,   154,     0,     0,   156,     0,   158,   159,
       0,     0,   160,     0,   161,   162,     0,     0,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,     0,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,     0,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,     0,   184,
     185,   186,     0,     0,   187,     0,   188,   189,     0,     0,
       0,   191,     0,   192,     0,     0,   193,   194,  3524,     0,
     195,   196,   197,     0,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,     0,   209,     0,     0,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
    3525,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,  3526,     0,     0,     0,     0,     0,     0,     0,
     226,     0,     0,     0,   227,  3527,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,  -186,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,  3528,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,     0,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,     0,
     311,  -186,     0,   312,     0,     0,   314,     0,     0,   316,
     317,  3529,     0,     0,     0,   319,     0,   320,   321,     0,
     322,   323,   324,     0,     0,   326,     0,     0,   328,     0,
     329,   330,     0,     0,     0,     0,   331,     0,     0,   332,
     333,   334,     0,     0,   335,     0,     0,     0,   336,     0,
     338,     0,     0,   340,   341,   342,     0,     0,     0,     0,
       0,     0,   343,   344,     0,   345,     0,     0,   346,     0,
       0,     0,   348,     0,     0,     0,   350,     0,   351,   352,
     353,     0,     0,     0,   354,   355,   356,   357,     0,   358,
     359,     0,   360,   361,     0,     0,   362,   363,   364,   365,
     366,     0,     0,     0,     0,     0,   367,     0,   368,     0,
       0,     0,   370,   371,   372,     0,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   376,     0,     0,   377,
       0,     0,     0,   379,   380,     0,     0,     0,     0,     0,
       0,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,     0,     0,  -186,     0,   386,     0,   387,     0,     0,
       0,     0,   389,     0,     0,     0,     0,  3530,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,  3732,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,   328,     0,   329,   330,     0,     0,
       0,     0,   331,     0,     0,   332,   333,   334,     0,     0,
     335,     0,     0,     0,   336,   337,   338,   339,     0,   340,
     341,   342,     0,     0,     0,     0,     0,     0,   343,   344,
       0,   345,     0,     0,   346,     0,     0,   347,   348,     0,
       0,   349,   350,     0,   351,   352,   353,     0,     0,     0,
     354,   355,   356,   357,     0,   358,   359,     0,   360,   361,
       0,     0,   362,   363,   364,   365,   366,     0,     0,     0,
       0,     0,   367,     0,   368,     0,     0,   369,   370,   371,
     372,     0,     0,   373,   374,     0,     0,   375,     0,     0,
       0,     0,   376,     0,     0,   377,     0,   378,     0,   379,
     380,     0,     0,     0,     0,     0,     0,     0,   381,     0,
       0,   382,     0,     0,   383,   384,   385,     0,     0,     0,
       0,   386,     0,   387,   388,     0,     0,     0,   389,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,  1646,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,     0,   329,   330,     0,
       0,     0,     0,   331,     0,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,     0,
     340,   341,   342,     0,     0,     0,     0,     0,     0,   343,
     344,     0,   345,     0,     0,   346,     0,     0,   347,   348,
       0,     0,   349,   350,     0,   351,   352,   353,     0,     0,
       0,   354,   355,   356,   357,     0,   358,   359,     0,   360,
     361,     0,     0,   362,   363,   364,   365,   366,     0,     0,
       0,     0,     0,   367,     0,   368,     0,     0,   369,   370,
     371,   372,     0,     0,   373,   374,     0,     0,   375,     0,
       0,     0,     0,   376,     0,     0,   377,     0,   378,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
       0,     0,   386,     0,   387,   388,     0,     0,     0,   389,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
    2341,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,   328,     0,   329,   330,
       0,     0,     0,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,     0,
     389,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,  2632,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,     0,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,     0,     0,   349,   350,     0,   351,   352,   353,
       0,     0,     0,   354,   355,   356,   357,     0,   358,   359,
       0,   360,   361,     0,     0,   362,   363,   364,   365,   366,
       0,     0,     0,     0,     0,   367,     0,   368,     0,     0,
     369,   370,   371,   372,     0,     0,   373,   374,     0,     0,
     375,     0,     0,     0,     0,   376,     0,     0,   377,     0,
     378,     0,   379,   380,     0,     0,     0,     0,     0,     0,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,     0,     0,   386,     0,   387,   388,     0,     0,
       0,   389,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,  2956,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -186,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,     0,     0,     0,     0,   144,     0,   145,
       0,   146,     0,     0,     0,     0,   149,   150,  3523,     0,
     152,     0,   153,   154,     0,     0,   156,     0,   158,   159,
       0,     0,   160,     0,   161,   162,     0,     0,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,     0,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,     0,     0,     0,   179,   180,
     181,     0,  -201,     0,   182,     0,     0,     0,  -201,   184,
     185,   186,     0,     0,   187,     0,   188,   189,     0,     0,
       0,   191,     0,   192,     0,     0,   193,   194,  3524,     0,
     195,   196,   197,     0,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,     0,   209,     0,     0,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
    3525,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,  3526,     0,     0,     0,     0,     0,     0,     0,
     226,     0,     0,     0,   227,  3527,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,  -186,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,  3528,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,     0,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,     0,
     311,  -186,     0,   312,     0,     0,   314,     0,     0,   316,
     317,  3529,     0,     0,     0,   319,     0,   320,   321,     0,
     322,   323,   324,     0,     0,   326,     0,     0,   328,     0,
     329,   330,     0,     0,     0,     0,   331,     0,     0,   332,
     333,   334,     0,     0,   335,     0,     0,     0,   336,     0,
     338,     0,     0,   340,   341,   342,     0,     0,     0,     0,
       0,     0,   343,   344,     0,   345,     0,     0,   346,     0,
       0,     0,   348,     0,     0,     0,   350,     0,   351,   352,
     353,     0,     0,     0,   354,   355,   356,   357,     0,   358,
     359,     0,   360,   361,     0,     0,   362,   363,   364,   365,
     366,     0,     0,     0,     0,     0,   367,     0,   368,     0,
       0,     0,   370,   371,   372,     0,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   376,     0,     0,   377,
       0,     0,     0,   379,   380,     0,     0,     0,     0,     0,
       0,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,     0,     0,  -186,     0,   386,     0,   387,     0,     0,
       0,     0,   389,     0,     0,  -201,   122,  3530,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -186,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,     0,     0,     0,
       0,   144,     0,   145,     0,   146,     0,     0,     0,     0,
     149,   150,  3523,     0,   152,     0,   153,   154,     0,     0,
     156,     0,   158,   159,     0,     0,   160,     0,   161,   162,
       0,     0,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,     0,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,  -222,   184,   185,   186,     0,     0,   187,     0,
     188,   189,     0,     0,     0,   191,     0,   192,     0,     0,
     193,   194,  3524,     0,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
       0,   209,     0,     0,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,  3525,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,  3526,     0,     0,     0,
       0,     0,     0,     0,   226,     0,     0,     0,   227,  3527,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
    -186,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,  3528,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,     0,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,     0,   311,  -186,     0,   312,     0,     0,
     314,     0,     0,   316,   317,  3529,     0,     0,     0,   319,
       0,   320,   321,     0,   322,   323,   324,     0,     0,   326,
       0,     0,   328,     0,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,     0,   338,     0,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,     0,   348,     0,     0,     0,
     350,     0,   351,   352,   353,     0,     0,     0,   354,   355,
     356,   357,     0,   358,   359,     0,   360,   361,     0,     0,
     362,   363,   364,   365,   366,     0,     0,     0,     0,     0,
     367,     0,   368,     0,     0,     0,   370,   371,   372,     0,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     376,     0,     0,   377,     0,     0,     0,   379,   380,     0,
       0,     0,     0,     0,     0,     0,   381,     0,     0,   382,
       0,     0,   383,   384,   385,  -222,     0,  -186,     0,   386,
       0,   387,     0,     0,     0,     0,   389,     0,     0,  -222,
     122,  3530,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -186,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3523,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,  -219,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3524,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3525,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3526,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3527,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -186,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3528,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -186,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3529,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,   328,     0,   329,   330,
       0,     0,     0,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,  -219,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,  -219,   122,  3530,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3523,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    3610,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3524,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3525,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3526,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3527,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3528,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3529,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,     0,   329,   330,     0,     0,     0,     0,   331,     0,
       0,   332,   333,   334,     0,     0,   335,     0,     0,     0,
     336,     0,   338,     0,     0,   340,   341,   342,     0,     0,
       0,     0,     0,     0,   343,   344,     0,   345,     0,     0,
     346,     0,     0,     0,   348,     0,     0,     0,   350,     0,
     351,   352,   353,     0,     0,     0,   354,   355,   356,   357,
       0,   358,   359,     0,   360,   361,     0,     0,   362,   363,
     364,   365,   366,     0,     0,     0,     0,     0,   367,     0,
     368,     0,     0,     0,   370,   371,   372,     0,     0,   373,
     374,     0,     0,     0,     0,     0,     0,     0,   376,     0,
       0,   377,     0,     0,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   381,     0,     0,   382,     0,     0,
     383,   384,   385,     0,     0,  -186,     0,   386,     0,   387,
       0,     0,     0,     0,   389,     0,     0,     0,   122,  3530,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -186,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3523,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
     161,   162,     0,     0,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,     0,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,  -224,   184,   185,   186,     0,     0,
     187,     0,   188,   189,     0,     0,     0,   191,     0,   192,
       0,     0,   193,   194,  3524,     0,   195,   196,   197,     0,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,  3525,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,  3526,     0,
       0,     0,     0,     0,     0,     0,   226,     0,     0,     0,
     227,  3527,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,  -186,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
    3528,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,     0,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,     0,   311,  -186,     0,   312,
       0,     0,   314,     0,     0,   316,   317,  3529,     0,     0,
       0,   319,     0,   320,   321,     0,   322,   323,   324,     0,
       0,   326,     0,     0,   328,     0,   329,   330,     0,     0,
       0,     0,   331,     0,     0,   332,   333,   334,     0,     0,
     335,     0,     0,     0,   336,     0,   338,     0,     0,   340,
     341,   342,     0,     0,     0,     0,     0,     0,   343,   344,
       0,   345,     0,     0,   346,     0,     0,     0,   348,     0,
       0,     0,   350,     0,   351,   352,   353,     0,     0,     0,
     354,   355,   356,   357,     0,   358,   359,     0,   360,   361,
       0,     0,   362,   363,   364,   365,   366,     0,     0,     0,
       0,     0,   367,     0,   368,     0,     0,     0,   370,   371,
     372,     0,     0,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   376,     0,     0,   377,     0,     0,     0,   379,
     380,     0,     0,     0,     0,     0,     0,     0,   381,     0,
       0,   382,     0,     0,   383,   384,   385,     0,     0,  -186,
       0,   386,     0,   387,     0,     0,     0,     0,   389,     0,
       0,     0,   122,  3530,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -186,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,     0,     0,     0,     0,   144,     0,   145,
       0,   146,     0,     0,     0,     0,   149,   150,  3523,     0,
     152,     0,   153,   154,     0,     0,   156,     0,   158,   159,
       0,     0,   160,     0,   161,   162,     0,     0,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,     0,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,     0,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,  3657,   184,
     185,   186,     0,     0,   187,     0,   188,   189,     0,     0,
       0,   191,     0,   192,     0,     0,   193,   194,  3524,     0,
     195,   196,   197,     0,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,     0,   209,     0,     0,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
    3525,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,  3526,     0,     0,     0,     0,     0,     0,     0,
     226,     0,     0,     0,   227,  3527,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,  -186,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,  3528,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,     0,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,     0,
     311,  -186,     0,   312,     0,     0,   314,     0,     0,   316,
     317,  3529,     0,     0,     0,   319,     0,   320,   321,     0,
     322,   323,   324,     0,     0,   326,     0,     0,   328,     0,
     329,   330,     0,     0,     0,     0,   331,     0,     0,   332,
     333,   334,     0,     0,   335,     0,     0,     0,   336,     0,
     338,     0,     0,   340,   341,   342,     0,     0,     0,     0,
       0,     0,   343,   344,     0,   345,     0,     0,   346,     0,
       0,     0,   348,     0,     0,     0,   350,     0,   351,   352,
     353,     0,     0,     0,   354,   355,   356,   357,     0,   358,
     359,     0,   360,   361,     0,     0,   362,   363,   364,   365,
     366,     0,     0,     0,     0,     0,   367,     0,   368,     0,
       0,     0,   370,   371,   372,     0,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   376,     0,     0,   377,
       0,     0,     0,   379,   380,     0,     0,     0,     0,     0,
       0,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,     0,     0,  -186,     0,   386,     0,   387,     0,     0,
       0,     0,   389,     0,     0,     0,   122,  3530,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -186,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,     0,     0,     0,
       0,   144,     0,   145,     0,   146,     0,     0,     0,     0,
     149,   150,  3523,     0,   152,     0,   153,   154,     0,     0,
     156,     0,   158,   159,     0,     0,   160,     0,   161,   162,
       0,     0,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,     0,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,  3698,   184,   185,   186,     0,     0,   187,     0,
     188,   189,     0,     0,     0,   191,     0,   192,     0,     0,
     193,   194,  3524,     0,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
       0,   209,     0,     0,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,  3525,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,  3526,     0,     0,     0,
       0,     0,     0,     0,   226,     0,     0,     0,   227,  3527,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
    -186,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,  3528,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,     0,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,     0,   311,  -186,     0,   312,     0,     0,
     314,     0,     0,   316,   317,  3529,     0,     0,     0,   319,
       0,   320,   321,     0,   322,   323,   324,     0,     0,   326,
       0,     0,   328,     0,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,     0,   338,     0,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,     0,   348,     0,     0,     0,
     350,     0,   351,   352,   353,     0,     0,     0,   354,   355,
     356,   357,     0,   358,   359,     0,   360,   361,     0,     0,
     362,   363,   364,   365,   366,     0,     0,     0,     0,     0,
     367,     0,   368,     0,     0,     0,   370,   371,   372,     0,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     376,     0,     0,   377,     0,     0,     0,   379,   380,     0,
       0,     0,     0,     0,     0,     0,   381,     0,     0,   382,
       0,     0,   383,   384,   385,     0,     0,  -186,     0,   386,
       0,   387,     0,     0,     0,     0,   389,     0,     0,     0,
     122,  3530,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -186,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3523,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,  -205,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3524,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3525,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3526,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3527,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -186,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3528,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -186,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3529,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,   328,     0,   329,   330,
       0,     0,     0,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,     0,   122,  3530,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3523,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
       0,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3524,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3525,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3526,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3527,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3528,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3529,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,     0,   329,   330,     0,     0,     0,     0,   331,     0,
       0,   332,   333,   334,     0,     0,   335,     0,     0,     0,
     336,     0,   338,     0,     0,   340,   341,   342,     0,     0,
       0,     0,     0,     0,   343,   344,     0,   345,     0,     0,
     346,     0,     0,     0,   348,     0,     0,     0,   350,     0,
     351,   352,   353,     0,     0,     0,   354,   355,   356,   357,
       0,   358,   359,     0,   360,   361,     0,     0,   362,   363,
     364,   365,   366,     0,     0,     0,     0,     0,   367,     0,
     368,     0,     0,     0,   370,   371,   372,     0,     0,   373,
     374,     0,     0,     0,     0,     0,     0,     0,   376,     0,
       0,   377,     0,     0,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   381,     0,     0,   382,     0,     0,
     383,   384,   385,     0,     0,  -186,     0,   386,     0,   387,
       0,     0,     0,     0,   389,     0,     0,     0,   122,  3530,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -186,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3523,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
     161,   162,     0,     0,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,     0,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,     0,   184,   185,   186,     0,     0,
     187,     0,   188,   189,     0,     0,     0,   191,     0,   192,
       0,     0,   193,   194,  3524,     0,   195,   196,   197,     0,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,  3525,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,  3526,     0,
       0,     0,     0,     0,     0,     0,   226,     0,     0,     0,
     227,  3527,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,  -186,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
    3528,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,     0,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,     0,   311,  -186,     0,   312,
       0,     0,   314,     0,     0,   316,   317,  3529,     0,     0,
       0,   319,     0,   320,   321,     0,   322,   323,   324,     0,
       0,   326,     0,     0,   328,     0,   329,   330,     0,     0,
       0,     0,   331,     0,     0,   332,   333,   334,     0,     0,
     335,     0,     0,     0,   336,     0,   338,     0,     0,   340,
     341,   342,     0,     0,     0,     0,     0,     0,   343,   344,
       0,   345,     0,     0,   346,     0,     0,     0,   348,     0,
       0,     0,   350,     0,   351,   352,   353,     0,     0,     0,
     354,   355,   356,   357,     0,   358,   359,     0,   360,   361,
       0,     0,   362,   363,   364,   365,   366,     0,     0,     0,
       0,     0,   367,     0,   368,     0,     0,     0,   370,   371,
     372,     0,     0,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   376,     0,     0,  3613,     0,     0,     0,   379,
     380,     0,     0,     0,     0,     0,     0,     0,   381,     0,
       0,   382,     0,     0,   383,   384,   385,     0,     0,  -186,
       0,   386,     0,   387,     0,     0,     0,     0,   389,     0,
       0,     0,   122,  3530,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,  1618,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,  1619,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
    1621,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,  1622,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,   717,
     718,     0,   275,     0,     0,  1624,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,   328,     0,
     329,   330,     0,     0,     0,     0,   331,     0,     0,   332,
     333,   334,     0,     0,   335,     0,     0,     0,   336,   337,
     338,   339,     0,   340,   341,   342,     0,     0,  3720,  3710,
    3721,     0,   343,   344,     0,   345,     0,     0,   346,     0,
       0,   347,   348,     0,     0,   349,   350,     0,   351,   352,
     353,     0,     0,     0,   354,   355,   356,   357,     0,   358,
     359,     0,   360,   361,     0,     0,   362,   363,   364,   365,
     366,     0,     0,     0,     0,     0,   367,     0,   368,     0,
       0,   369,   370,   371,   372,     0,  1634,   373,   374,     0,
       0,   375,     0,     0,     0,     0,   376,     0,     0,   377,
       0,   378,     0,   379,   380,     0,     0,     0,     0,     0,
       0,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,     0,     0,     0,     0,   386,     0,   387,   388,     0,
       0,   122,   389,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,  2347,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,  2348,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,  1976,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,   564,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,     0,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,  1977,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,     0,     0,   349,   350,     0,   351,   352,   353,
       0,     0,     0,   354,   355,   356,   357,     0,   358,   359,
       0,   360,   361,     0,   565,   362,   363,   364,   365,   366,
       0,     0,     0,     0,     0,   367,     0,   368,     0,     0,
     369,   370,   371,   372,     0,     0,   373,   374,     0,     0,
     375,     0,     0,     0,     0,   376,     0,     0,   377,     0,
     378,     0,   379,   380,     0,     0,     0,     0,     0,     0,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,     0,     0,   386,     0,   387,   388,     0,     0,
     122,   389,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,  2357,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,  2358,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,   564,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,   328,     0,   329,   330,
       0,     0,     0,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,   565,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,  2347,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  2348,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   564,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,     0,   329,   330,     0,
       0,     0,     0,   331,     0,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,     0,
     340,   341,   342,     0,     0,     0,     0,     0,     0,   343,
     344,     0,   345,     0,     0,   346,     0,     0,   347,   348,
       0,     0,   349,   350,     0,   351,   352,   353,     0,     0,
       0,   354,   355,   356,   357,     0,   358,   359,     0,   360,
     361,     0,   565,   362,   363,   364,   365,   366,     0,     0,
       0,     0,     0,   367,     0,   368,     0,     0,   369,   370,
     371,   372,     0,     0,   373,   374,     0,     0,   375,     0,
       0,     0,     0,   376,     0,     0,   377,     0,   378,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
       0,     0,   386,     0,   387,   388,     0,     0,   122,   389,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,   721,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,   564,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,   328,     0,   329,   330,     0,     0,
       0,     0,   331,     0,     0,   332,   333,   334,     0,     0,
     335,     0,     0,     0,   336,   337,   338,   339,     0,   340,
     341,   342,     0,     0,     0,     0,     0,     0,   343,   344,
       0,   345,     0,     0,   346,     0,     0,   347,   348,     0,
       0,   349,   350,     0,   351,   352,   353,     0,     0,     0,
     354,   355,   356,   357,     0,   358,   359,     0,   360,   361,
       0,   565,   362,   363,   364,   365,   366,     0,     0,     0,
       0,     0,   367,     0,   368,     0,     0,   369,   370,   371,
     372,     0,     0,   373,   374,     0,     0,   375,     0,     0,
       0,     0,   376,     0,     0,   377,     0,   378,     0,   379,
     380,     0,     0,     0,     0,     0,     0,     0,   381,     0,
       0,   382,     0,     0,   383,   384,   385,     0,     0,     0,
       0,   386,     0,   387,   388,     0,     0,   122,   389,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,   673,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,   674,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,   328,     0,   329,   330,     0,     0,     0,
       0,   331,     0,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,     0,   340,   341,
     342,     0,     0,     0,     0,     0,     0,   343,   344,     0,
     345,     0,     0,   346,     0,     0,   347,   348,     0,     0,
     349,   350,     0,   351,   352,   353,     0,     0,     0,   354,
     355,   356,   357,     0,   358,   359,     0,   360,   361,     0,
     675,   362,   363,   364,   365,   366,     0,     0,     0,     0,
       0,   367,     0,   368,     0,     0,   369,   370,   371,   372,
       0,     0,   373,   374,     0,     0,   375,     0,     0,     0,
       0,   376,     0,     0,   377,     0,   378,     0,   379,   380,
       0,     0,     0,     0,     0,     0,     0,   381,     0,     0,
     382,     0,     0,   383,   384,   385,     0,     0,     0,     0,
     386,     0,   387,   388,     0,     0,   122,   389,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,  2396,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,   564,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,     0,     0,   349,
     350,     0,   351,   352,   353,     0,     0,     0,   354,   355,
     356,   357,     0,   358,   359,     0,   360,   361,     0,   565,
     362,   363,   364,   365,   366,     0,     0,     0,     0,     0,
     367,     0,   368,     0,     0,   369,   370,   371,   372,     0,
       0,   373,   374,     0,     0,   375,     0,     0,     0,     0,
     376,     0,     0,   377,     0,   378,     0,   379,   380,     0,
       0,     0,     0,     0,     0,     0,   381,     0,     0,   382,
       0,     0,   383,   384,   385,     0,     0,     0,     0,   386,
       0,   387,   388,     0,     0,   122,   389,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2347,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   564,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,     0,   329,   330,     0,     0,     0,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,   565,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     564,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,     0,   329,   330,     0,     0,     0,     0,   331,     0,
       0,   332,   333,   334,     0,     0,   335,     0,     0,     0,
     336,   337,   338,   339,     0,   340,   341,   342,     0,     0,
       0,     0,     0,     0,   343,   344,     0,   345,     0,     0,
     346,     0,     0,   347,   348,     0,     0,   349,   350,     0,
     351,   352,   353,     0,     0,     0,   354,   355,   356,   357,
       0,   358,   359,     0,   360,   361,     0,   565,   362,   363,
     364,   365,   366,     0,     0,     0,     0,     0,   367,     0,
     368,     0,     0,   369,   370,   371,   372,     0,     0,   373,
     374,     0,     0,   375,     0,     0,     0,     0,   376,     0,
       0,   377,     0,   378,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   381,     0,     0,   382,     0,     0,
     383,   384,   385,     0,     0,     0,     0,   386,     0,   387,
     388,     0,     0,   122,   389,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,  2337,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,   328,
       0,   329,   330,     0,     0,     0,     0,   331,     0,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,     0,   340,   341,   342,     0,     0,     0,
       0,     0,     0,   343,   344,     0,   345,     0,     0,   346,
       0,     0,   347,   348,     0,     0,   349,   350,     0,   351,
     352,   353,     0,     0,     0,   354,   355,   356,   357,     0,
     358,   359,     0,   360,   361,     0,   565,   362,   363,   364,
     365,   366,     0,     0,     0,     0,     0,   367,     0,   368,
       0,     0,   369,   370,   371,   372,     0,     0,   373,   374,
       0,     0,   375,     0,     0,     0,     0,   376,     0,     0,
     377,     0,   378,     0,   379,   380,     0,     0,     0,     0,
       0,     0,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,     0,     0,   386,     0,   387,   388,
       0,     0,   122,   389,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,  3652,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
    3653,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,   328,     0,
     329,   330,     0,     0,     0,     0,   331,     0,     0,   332,
     333,   334,     0,     0,   335,     0,     0,     0,   336,   337,
     338,   339,     0,   340,   341,   342,     0,     0,     0,     0,
       0,     0,   343,   344,     0,   345,     0,     0,   346,     0,
       0,   347,   348,     0,     0,   349,   350,     0,   351,   352,
     353,     0,     0,     0,   354,   355,   356,   357,     0,   358,
     359,     0,   360,   361,     0,     0,   362,   363,   364,   365,
     366,     0,     0,     0,     0,     0,   367,     0,   368,     0,
       0,   369,   370,   371,   372,     0,     0,   373,   374,     0,
       0,   375,     0,     0,     0,     0,   376,     0,     0,   377,
       0,   378,     0,   379,   380,     0,     0,     0,     0,     0,
       0,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,     0,     0,     0,     0,   386,     0,   387,   388,     0,
       0,   122,   389,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,   740,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,     0,   329,
     330,     0,     0,     0,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,     0,     0,   349,   350,     0,   351,   352,   353,
       0,     0,     0,   354,   355,   356,   357,     0,   358,   359,
       0,   360,   361,     0,     0,   362,   363,   364,   365,   366,
       0,     0,     0,     0,     0,   367,     0,   368,     0,     0,
     369,   370,   371,   372,     0,     0,   373,   374,     0,     0,
     375,     0,     0,     0,     0,   376,     0,     0,   377,     0,
     378,     0,   379,   380,     0,     0,     0,     0,     0,     0,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,     0,     0,   386,     0,   387,   388,     0,     0,
     122,   389,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,  1116,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,   328,     0,   329,   330,
       0,     0,     0,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  1923,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,     0,   329,   330,     0,
       0,     0,     0,   331,     0,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,     0,
     340,   341,   342,     0,     0,     0,     0,     0,     0,   343,
     344,     0,   345,     0,     0,   346,     0,     0,   347,   348,
       0,     0,   349,   350,     0,   351,   352,   353,     0,     0,
       0,   354,   355,   356,   357,     0,   358,   359,     0,   360,
     361,     0,     0,   362,   363,   364,   365,   366,     0,     0,
       0,     0,     0,  1924,     0,   368,     0,     0,   369,   370,
     371,   372,     0,     0,   373,   374,     0,     0,   375,     0,
       0,     0,     0,   376,     0,     0,   377,     0,   378,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
       0,     0,   386,     0,   387,   388,     0,     0,   122,   389,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,  2044,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,   328,     0,   329,   330,     0,     0,
       0,     0,   331,     0,     0,   332,   333,   334,     0,     0,
     335,     0,     0,     0,   336,   337,   338,   339,     0,   340,
     341,   342,     0,     0,     0,     0,     0,     0,   343,   344,
       0,   345,     0,     0,   346,     0,     0,   347,   348,     0,
       0,   349,   350,     0,   351,   352,   353,     0,     0,     0,
     354,   355,   356,   357,     0,   358,   359,     0,   360,   361,
       0,     0,   362,   363,   364,   365,   366,     0,     0,     0,
       0,     0,   367,     0,   368,     0,     0,   369,   370,   371,
     372,     0,     0,   373,   374,     0,     0,   375,     0,     0,
       0,     0,   376,     0,     0,   377,     0,   378,     0,   379,
     380,     0,     0,     0,     0,     0,     0,     0,   381,     0,
       0,   382,     0,     0,   383,   384,   385,     0,     0,     0,
       0,   386,     0,   387,   388,     0,     0,   122,   389,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,   328,     0,   329,   330,     0,     0,     0,
       0,   331,     0,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,     0,   340,   341,
     342,     0,     0,     0,     0,     0,     0,   343,   344,     0,
     345,     0,     0,   346,     0,     0,   347,   348,     0,     0,
     349,   350,     0,   351,   352,   353,     0,     0,     0,   354,
     355,   356,   357,     0,   358,   359,     0,   360,   361,     0,
     565,   362,   363,   364,   365,   366,     0,     0,     0,     0,
       0,   367,     0,   368,     0,     0,   369,   370,   371,   372,
       0,     0,   373,   374,     0,     0,   375,     0,     0,     0,
       0,   376,     0,     0,   377,     0,   378,     0,   379,   380,
       0,     0,     0,     0,     0,     0,     0,   381,     0,     0,
     382,     0,     0,   383,   384,   385,     0,     0,     0,     0,
     386,     0,   387,   388,     0,     0,   122,   389,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,  1923,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,     0,     0,     0,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,     0,     0,   349,
     350,     0,   351,   352,   353,     0,     0,     0,   354,   355,
     356,   357,     0,   358,   359,     0,   360,   361,     0,     0,
     362,   363,   364,   365,   366,     0,     0,     0,     0,     0,
     367,     0,   368,     0,     0,   369,   370,   371,   372,     0,
       0,   373,   374,     0,     0,   375,     0,     0,     0,     0,
     376,     0,     0,   377,     0,   378,     0,   379,   380,     0,
       0,     0,     0,     0,     0,     0,   381,     0,     0,   382,
       0,     0,   383,   384,   385,     0,     0,     0,     0,   386,
       0,   387,   388,     0,     0,   122,   389,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,     0,   329,   330,     0,     0,     0,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,     0,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,  1416,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,  1417,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,     0,   329,   330,     0,     0,     0,     0,   331,     0,
       0,   332,   333,   334,     0,     0,   335,     0,     0,     0,
     336,   337,   338,   339,     0,   340,   341,   342,     0,     0,
       0,     0,     0,     0,   343,   344,     0,   345,     0,     0,
     346,     0,     0,   347,   348,     0,     0,   349,   350,     0,
     351,   352,   353,     0,     0,     0,   354,   355,   356,   357,
       0,   358,   359,     0,   360,   361,     0,     0,   362,   363,
     364,   365,   366,     0,     0,     0,     0,     0,   367,     0,
     368,     0,     0,   369,   370,   371,   372,     0,     0,   373,
     374,     0,     0,   375,     0,     0,     0,     0,   376,     0,
       0,   377,     0,   378,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   381,     0,     0,   382,     0,     0,
     383,   384,   385,     0,     0,     0,     0,   386,     0,   387,
     388,     0,     0,   122,   389,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,     0,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,     0,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,   161,   162,     0,     0,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,     0,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,     0,
     184,   185,   186,     0,     0,   187,     0,   188,   189,     0,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,     0,   209,     0,
       0,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,     0,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,     0,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
       0,   311,     0,     0,   312,     0,     0,   314,     0,     0,
     316,   317,     0,     0,     0,     0,   319,     0,   320,   321,
       0,   322,   323,   324,     0,     0,   326,     0,     0,   328,
       0,   329,   330,     0,     0,     0,     0,   331,     0,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
       0,   338,     0,     0,   340,   341,   342,     0,     0,     0,
       0,     0,     0,   343,   344,     0,   345,     0,     0,   346,
       0,     0,     0,   348,     0,     0,     0,   350,     0,   351,
     352,   353,     0,     0,     0,   354,   355,   356,   357,     0,
     358,   359,     0,   360,   361,     0,     0,   362,   363,   364,
     365,   366,     0,     0,     0,     0,     0,   367,     0,   368,
       0,     0,     0,   370,   371,   372,     0,     0,   373,   374,
       0,     0,     0,     0,     0,     0,     0,   376,     0,     0,
     377,     0,     0,     0,   379,   380,     0,     0,     0,     0,
       0,     0,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,     0,     0,   386,     0,   387,     0,
       0,     0,     0,   389
};

static const short yycheck[] =
{
       7,   466,   467,   468,   504,   470,   429,   472,   454,   605,
     979,   474,    19,   630,  1792,    22,   654,   688,   529,   728,
     729,   730,    29,   767,   768,   769,  1314,   751,  1032,  1187,
    1980,  1223,    39,  1194,  1195,   773,  1197,   654,  1314,  1095,
    1874,   833,    49,  1335,  1902,    22,  1396,  1933,   500,   501,
    1342,  1189,  1190,  1191,   581,  2373,  2088,  2322,   628,  1221,
    1539,  2106,  2733,  1505,  1202,  1926,  1927,  1928,  2113,  1958,
     108,  1232,   110,  1552,  1109,  1331,   587,  1966,   530,  1968,
      87,  1642,  1965,  1917,  2710,   655,  1247,     3,  1215,  2718,
     834,  1940,  1941,  1353,  1354,  1995,    16,  1277,   461,     3,
     107,   108,    16,   110,  1265,  1266,  1267,     3,    10,    16,
      87,     3,     3,  1999,   121,  1276,     3,   861,  1256,     3,
       3,  1259,  1057,     3,   862,  1060,  1287,   865,  1255,    16,
     874,   875,   876,  2019,  2020,    18,  1071,  1072,    32,    54,
      49,    27,    95,   513,   121,    18,  1452,   599,    58,    94,
    1288,  1289,    18,    18,    59,  1293,    28,    20,  1519,    56,
     884,   885,   886,    12,  1989,  1345,    69,  1347,    20,    32,
    1995,   135,   692,  1998,    63,  1313,  2001,  1315,   656,  2763,
     904,    59,  2766,    46,    11,   696,    20,  2012,  2013,    63,
     147,    40,    55,    56,   169,   111,  2021,   115,    32,    55,
      56,  2785,   692,    55,    56,  2315,   629,  2791,  2082,    34,
    2988,   347,    46,  1182,  1645,   229,    34,    49,   172,    20,
    2078,    55,    56,   688,   253,    23,   126,   111,   217,   592,
     115,    32,    81,   252,   179,   221,    58,    86,   175,   214,
    2824,   156,    61,   229,   159,    46,    89,   699,   270,   238,
      52,    34,   214,  2417,    55,    56,    66,   172,   324,   289,
     170,    77,   145,   131,    32,  3443,    64,    94,    28,   430,
      68,    60,   145,   130,  1647,   407,  3532,   113,   344,   145,
     145,   214,    32,  2995,   406,   430,   572,   236,   236,   498,
     111,    75,   258,   175,   498,    38,  1990,  1991,   112,   420,
     413,   249,   175,   112,   498,   223,    56,  3526,  3527,   287,
      70,  2937,  2309,   111,   344,   156,   539,   100,   341,    19,
    1964,    58,   175,   352,   107,  2994,    96,   156,   539,   234,
      67,   175,    58,   175,   214,   473,  2015,   270,   164,   558,
     253,   516,    79,   335,   226,   557,   107,    97,   170,   253,
     100,    12,   179,    37,  2033,   475,   234,   253,   108,   497,
     583,   253,   253,    97,   539,   287,   100,  3036,   390,  3147,
     336,   357,   584,   584,   495,   158,   229,   120,   203,   588,
     584,   141,   231,   166,   299,   203,   672,   214,   510,  1950,
     584,   175,  2293,  2294,  2295,  2392,  3615,   269,   898,   544,
     545,   229,   107,   381,   270,   166,    11,   399,   415,   158,
     217,   129,  1083,   313,   228,   536,   116,   243,   425,   228,
     203,   582,   429,  2324,  2325,  2326,   331,   434,   548,   374,
     551,  1589,   439,   170,   270,  3019,  1594,   582,  3616,   352,
     238,   178,  1600,   405,  3028,  1603,   911,   217,   352,   382,
     145,   300,   584,   589,   461,   229,  3085,   434,  3714,  1113,
     352,   166,   372,   412,   125,   321,  1036,   382,   416,   582,
     352,   478,   374,   539,  1044,  2425,   454,   929,  1095,    49,
     217,   488,  1913,    64,   267,   492,   270,   525,   356,   527,
     528,   498,  1019,   500,   501,  2356,   525,  2380,   505,   506,
    1238,   238,   411,  1073,  1074,   361,   267,   112,   515,   335,
     359,   488,   519,  3139,  2414,  1653,   337,   524,   525,   287,
     527,   528,   529,   530,   390,   405,  1037,  2388,  2428,  2090,
     982,   205,   404,   335,   332,   333,   555,   559,  1573,   337,
     992,   382,   325,   204,  2654,   156,   344,   374,  3177,   494,
     372,   334,   582,   382,   337,   338,   563,   426,  2037,  2723,
     983,   584,   267,   538,  1499,   381,   376,   472,   470,  1307,
     584,   390,   579,   430,   372,   418,   326,   338,   483,   411,
     587,   588,  1102,   332,   333,   592,   475,  1114,   337,  2414,
    1728,  1069,   599,   582,  1732,   552,  1957,   583,   551,  2078,
     507,   475,   579,  2428,   568,   483,   551,   970,   510,   458,
     370,   588,  1102,  1919,  1902,   533,   526,   520,  1083,  3397,
    1344,   507,   629,  2941,  2498,    94,  1902,  3339,  1766,   583,
     993,  1793,   392,   338,  1795,   372,  1360,  1829,  1818,  1831,
     489,  1161,   507,  1823,  1824,   443,   583,  2912,   533,   551,
     547,   555,   572,  1815,  1024,   560,  2087,   417,   572,   555,
    1106,   524,  1386,   555,   555,   454,   539,   494,   394,   584,
     557,  1161,   524,   498,   590,   584,   576,   577,   578,  1967,
     498,   688,   492,  3312,   556,   589,   590,   550,   582,   696,
     524,  1967,   699,   559,   590,   702,   703,   589,   590,   590,
    3371,   511,   452,   590,   526,  3376,   590,   590,   537,   178,
     590,   584,   546,   547,   474,   498,  2089,   500,  2412,   582,
     503,   405,   459,   524,   494,   582,   703,   445,   526,   586,
     513,   738,   588,   740,  2022,   419,   519,  2381,  2382,   522,
     584,  1164,   584,   584,   572,   263,  2022,  1212,   217,   354,
    3379,   446,  1115,   503,     4,   584,   440,  2658,   519,     9,
      10,   738,  3080,   740,   513,   335,   500,  2328,  2329,   503,
     179,   382,   353,     8,   229,  1429,  3360,    27,  3362,   158,
     529,   531,    32,   557,   179,   267,    36,  2648,    64,   526,
     475,   574,   575,  2651,  2645,   191,   361,   252,   572,   406,
     108,   475,   217,   464,   465,   466,   467,   468,   469,   175,
      67,  2700,    94,  1971,   519,  2704,   430,  2700,   107,   480,
    2720,  2704,   349,   238,   107,  2686,   177,  2992,  2662,   107,
     515,   175,  1297,   111,    76,  3464,  1301,   221,  1338,    50,
     554,   411,  2000,   494,  2002,   229,  3430,    58,  3432,  2007,
      92,   107,   105,   113,   568,     8,   338,  1495,    12,   454,
    2120,  2121,   258,   430,  2715,  2023,   116,  2025,  2026,  2027,
       0,  3542,   343,   149,    27,   445,   525,   166,  1495,  3505,
     362,  1392,   889,   166,   891,    12,  1524,   474,   166,    68,
     361,   478,   430,   332,   333,  2720,  3010,   179,   138,  3013,
      68,    80,   275,   276,   511,  1432,  1329,  1524,   148,   253,
     166,     3,    80,   170,   203,  1442,   923,  1487,   145,   227,
     203,   174,   929,  1434,  1435,   203,   537,  1497,  1498,   164,
    2372,  1501,  1502,   498,   583,   217,  1940,  1941,   301,  1466,
     395,  2502,   121,   430,   204,   172,   923,   203,    88,  2981,
    2111,  1403,    12,    88,  2812,  2116,   209,   475,   337,   966,
     217,   968,  1385,   970,   330,   374,   430,  2816,   582,  3014,
    2131,   125,   586,   357,  1397,   982,   983,  2138,   267,   374,
      88,   238,  2274,   229,   267,   992,   993,  1025,  1026,   267,
     459,  2171,  2153,  2154,   554,  3260,  1003,  1035,   125,  2160,
    1969,  2036,  3673,  1530,  2260,  1043,   252,  2168,   568,   360,
     270,   267,   430,  3178,  3179,   582,  1951,  1463,  1025,  1026,
    1027,  1028,  2310,   396,   397,   494,   495,   498,  1035,    12,
    1037,   370,   456,   457,  2310,   459,  1043,   519,    12,   101,
     102,   103,   104,   105,   582,  2172,  2207,   258,   444,   338,
    1027,  1028,  2513,   306,   325,   338,  2517,   526,   145,  1066,
     338,   314,   241,  1590,  1591,   125,  1593,   536,  1595,  1596,
    1597,  1598,  1599,   241,  1601,  1602,   112,   353,    12,   219,
     325,  2431,   338,   391,   219,   494,   332,   333,   370,  1066,
    2973,  2974,   374,   325,   383,   582,   236,   386,  1822,   494,
    3214,   236,   453,   494,  2965,  1112,  2268,    88,  1115,   249,
     350,   219,   174,  2275,   249,   372,   571,  3149,   582,   325,
     507,   191,   589,  2092,  2285,    88,   554,   380,   236,  1167,
    1168,  3449,   311,   496,   513,  1112,   452,   448,   449,   172,
     568,   249,   125,   311,   206,   207,   208,   209,  2709,   395,
     529,   125,   351,   332,   333,   354,   335,  1164,   521,  1166,
    1167,  1168,    54,  1170,   582,  1529,  3211,   335,   574,   575,
     454,   421,  1179,   481,  1181,   428,  3494,  1541,  1542,   462,
    1544,  1545,  1546,   430,   324,  1549,   436,   507,   258,   324,
    1554,   125,   442,  1170,  1558,  1559,  1560,   584,   445,  1563,
    1564,  1565,  1566,  1567,   344,  1569,  1570,  1571,  1215,   344,
     389,   457,   462,   495,   398,   531,   324,   289,   390,   446,
     492,   389,   494,    34,  3082,   509,    16,   498,   510,   262,
     519,   403,  2711,  2712,  2713,  3413,   519,  3415,   219,   582,
     302,   519,   304,   305,   306,  1710,   589,  3361,  1255,  3363,
     566,   522,   314,   498,   536,   236,   219,   497,   582,    71,
      72,  2740,   213,   519,   156,   589,   498,   159,   249,   551,
     442,    20,   344,   236,  3163,   345,   416,   522,   192,    28,
     172,   416,   494,   434,    33,  2746,   249,   471,   439,   100,
     522,   470,   498,   495,    55,    56,   107,   544,   545,   111,
     553,   217,   470,    64,   583,   584,   547,  1314,   416,   550,
     213,   582,   565,  1778,   226,   492,   522,   494,   380,  2780,
    2781,   133,  1329,    15,    16,   571,   572,  2788,   467,   468,
    2622,   470,   347,   472,  2795,   582,   175,   582,  2530,  2531,
     480,    55,    56,   324,   557,   480,   270,   158,  3568,   107,
     582,   955,   583,   165,   958,   166,   414,   961,   416,   536,
     418,   324,   420,   344,   589,   427,   428,  2655,   583,   584,
    1540,   145,   480,  1543,   444,   470,   290,   291,  1385,  2655,
     294,   295,  1552,  1390,   582,  1392,  3606,   583,   584,   405,
    1397,  1561,   203,  1920,   583,   584,  1403,  2752,  1405,    11,
    2755,  2756,   152,  1410,  1411,   344,  1413,   299,   166,  1411,
     539,  1413,  1355,  1356,  1357,  1358,  1359,  2772,  1425,   373,
    2708,  1428,   583,   584,   583,   584,  3646,  1434,  1435,  1436,
    1437,   420,  2708,  1410,  1411,   416,  1413,  1444,  1445,  1446,
     349,  3661,  1444,  1445,  1446,   203,  2734,   492,  1425,   344,
    3670,  1428,   584,   416,  2615,  1462,   267,   214,  2734,  1436,
    1437,   583,   584,    47,  1471,   583,   584,  1444,  1445,  1446,
     175,  2263,   263,   531,   583,   584,  2003,  2004,   583,   584,
    3314,  1488,   583,   584,  3704,    47,  3706,   584,   120,   344,
     382,   553,   576,  1500,   426,  2551,   525,  2024,     3,   480,
     263,     6,   564,   565,  1927,  1512,  1929,  1930,    13,   267,
     150,  1518,   583,   584,   325,   145,   146,   480,    23,    24,
     583,   584,   445,  1500,   583,   584,   337,   338,   583,   584,
     145,   583,   584,   583,   584,   583,   584,  3008,  3009,   583,
     584,  1518,   583,   584,   583,   584,   515,  2271,    53,   164,
    1353,  1354,    57,   253,   184,  3026,  1979,  1980,   582,  2005,
     475,  3032,   172,    68,   475,    12,    13,   475,   198,   184,
    1577,   287,    77,   205,   475,  2284,  1614,   335,    83,  1586,
     338,   393,   492,   198,  3055,   583,   584,  3058,   263,  3367,
    3476,    96,  2015,   583,   584,   142,  3546,   583,   584,  3460,
       3,    78,   232,   583,   584,   584,   111,  1614,   346,   114,
    2033,   583,   584,   488,   244,    18,   583,   584,   123,   124,
     429,   583,   584,   583,   129,    52,  2818,   399,   243,   244,
     551,   263,   137,  1640,   583,   584,  1643,   152,   143,   582,
      87,   271,  2006,   583,   584,   583,   584,   588,  2936,  3499,
     583,   584,   211,  2017,   584,   287,   271,   583,   584,  2124,
    2936,   583,   584,  1640,   169,   583,   584,  2132,   115,  1351,
    1352,    44,   551,   431,   573,   433,   434,   435,   436,   437,
     438,   439,   129,  2106,   584,    88,   582,   498,   582,   500,
    2113,   589,   503,   583,   584,   583,   584,  2889,   328,   583,
     584,   582,   513,   562,   151,   583,   584,   579,   519,   582,
     215,   522,   217,   583,   584,   330,   163,   583,   584,   224,
     583,   584,  3572,   583,   584,  2363,  2322,   583,   584,   583,
     584,   583,   584,   582,   107,   583,   584,   582,  3588,   582,
    3590,   373,   145,  1298,  1299,   192,  2363,  2712,  2713,   381,
    3184,  3185,  2664,  2665,  2634,  2635,   371,  2918,  2926,  2927,
     582,   519,   582,   574,   575,   582,   169,   582,   582,   172,
     217,   584,   582,   589,   582,   582,   223,   409,   582,  3629,
     582,   582,  3632,   582,   582,   582,   582,   292,   582,   582,
    3640,    47,   195,   166,  1801,   582,  2307,   582,   201,   582,
     582,  2371,   307,   582,   582,   582,   582,   312,   588,   582,
    2337,   214,  2816,   582,   582,   262,   219,  3667,   582,   584,
     582,   557,   454,   226,   584,   287,   582,   200,  3678,   582,
     203,   582,  2255,   236,   582,   582,   582,   582,   582,   582,
     582,  3691,  2353,   475,   498,   582,   249,   352,   582,   582,
     253,   582,   582,   358,   582,   582,   361,   582,   582,   262,
     492,   582,   494,   582,   582,   582,   258,   582,  3718,  3719,
     582,   582,  3722,   582,   582,   582,   582,   287,   582,   384,
     385,   582,   387,   582,   582,   582,   582,   582,   582,   582,
     492,   582,   582,   582,   267,  1902,   401,   582,   582,  2426,
     582,    23,    24,   582,   582,   582,  2433,   507,   582,   582,
     582,   582,   582,  1920,  1921,   582,   582,   582,   423,   582,
    1927,   324,  1929,  1930,   582,   582,   582,   582,   375,   582,
     582,   582,   582,    55,    56,    57,   582,   582,   582,   582,
     582,   344,    64,   582,   582,   582,    68,   394,   582,   352,
     507,   582,   229,   400,  2678,    77,   582,   582,   498,   406,
    1967,   584,   335,   584,   584,   338,   584,   584,   584,   576,
     172,   374,  1979,  1980,    96,   230,   490,   160,   172,   584,
     532,   584,  1989,   430,   456,   363,   582,   584,  1995,   111,
     583,  1998,   114,   145,  2001,   145,   145,   145,   145,  2968,
     145,   145,  2425,   450,   451,  2012,  2013,     3,  2015,   145,
    2462,   516,   145,   416,  2021,  2022,   145,   145,   145,   145,
     525,   143,    18,   584,  2031,   145,  2033,   145,   534,   583,
    2037,  2038,    45,   179,   344,   175,    64,    12,   583,   498,
     487,   583,   445,   125,     9,   583,   583,   554,   583,   582,
     589,   252,   425,   575,  2031,   584,   390,   555,   431,   218,
     433,   434,   435,   436,   437,   438,   439,   192,   589,   175,
    2077,  2078,   583,   454,   381,   445,   584,   480,   172,   584,
     584,    45,   470,   470,   470,   590,   533,   470,   535,   429,
     470,    67,    88,   507,  2803,   217,   122,   493,   237,  2106,
    2077,   122,   224,   237,   493,  3393,  2113,    45,   584,   584,
     539,   589,    18,   584,   583,   583,   589,   584,   583,  2126,
     583,   576,   525,   583,   175,   583,   583,   583,  3289,   583,
     252,   584,   584,   584,   583,   538,   539,  3275,   583,   582,
     584,  3299,  3300,  3301,  3302,   584,   519,   583,   583,   145,
     584,   583,   555,   584,   557,   446,   584,   583,   262,   584,
     584,   584,   583,   507,   584,  2172,   584,   583,   587,   584,
     292,   584,   583,   572,   582,   584,   172,   584,   583,   583,
     583,   584,   584,   584,   584,   307,   584,   590,   582,   584,
     583,   507,   589,   584,   584,   507,   498,   258,   583,   195,
     584,   583,   507,   559,   583,   201,   583,   583,   583,   583,
     226,   583,   583,  2922,   583,   583,  3504,   583,    12,    13,
     583,   583,   583,   219,   584,   584,   584,   584,   583,   583,
     226,   583,   349,   584,   584,   583,   358,   583,   583,   361,
     236,   584,   584,   584,  2667,   583,   583,   583,  2255,   584,
     583,   583,   582,   249,   583,   582,   584,   253,   589,   175,
    2683,   175,   384,   385,   175,   387,   262,   175,   589,   589,
     233,   557,   338,   584,   236,   236,   355,    96,   303,  2286,
      96,   238,   238,  2290,   582,  2292,  2293,  2294,  2295,   589,
     582,   498,   582,    87,   352,   576,  2303,   225,   583,   583,
    2307,   423,   338,  2310,   338,   583,   175,   583,    23,    24,
     583,   175,   175,   141,   338,   569,  2912,  2324,  2325,  2326,
     583,   115,   583,   589,   589,   589,  2303,   576,   324,   582,
    2337,   583,   583,   583,   344,   129,  2343,   214,  2345,   584,
      55,    56,    57,   583,   175,   589,  2353,   533,   344,    64,
     229,   250,    64,    68,   275,   236,   352,   151,   236,   344,
     584,   584,    77,   238,   238,    18,   344,    18,   583,   163,
      18,   582,   582,   253,    13,   583,  3664,   583,   374,   583,
     227,    96,   582,   227,   583,   583,   583,   583,  3664,   584,
     583,   583,   583,   583,   516,   583,   111,  3685,   192,   114,
     589,   583,   583,   525,   583,   569,   584,  2414,   583,   583,
     583,   583,   583,  3701,   584,   583,   583,   583,  2425,     7,
     416,  2428,   583,   217,   584,  3701,   583,  3098,   143,   223,
     584,    19,   132,   584,    22,   247,   589,   430,   195,   447,
    2967,    29,  3600,  3181,  3182,  3183,   583,   582,    87,   445,
     582,    39,   583,   583,   145,  2462,   236,   355,   236,   583,
     582,    49,  2469,   584,   583,  2472,   111,   583,   262,  2476,
    2477,   583,   583,  2480,   583,   583,   115,   584,   583,   582,
    3224,   583,   583,  2490,   480,   583,   583,   583,   583,   111,
     129,   583,   583,   582,   584,  2472,   584,   583,   583,    87,
     583,   582,   217,   583,   369,   583,   582,   584,  3035,   224,
     583,   583,   151,  2490,   583,   583,   338,   584,   583,   107,
     108,   584,   110,   583,   163,   584,   582,   582,  2951,   525,
     582,   338,   589,   121,  3205,  3244,  3245,  3695,   583,   583,
     583,   583,   338,   539,   441,    41,   381,  3218,   583,  3707,
     583,   583,   583,   192,   338,   557,   583,   226,    45,   555,
     583,   557,   584,   201,   310,  3011,   584,   390,   498,   589,
     236,   498,   539,   539,  3732,   582,   172,   292,   217,   582,
     338,   375,   582,   338,   223,   582,    32,   583,   584,   338,
     550,  3014,   307,   582,   590,   550,   533,  3124,   111,   337,
     394,   238,   238,   338,   338,   338,   400,   338,   338,   557,
     583,  3034,   406,   584,  3358,   518,   584,   310,   154,   238,
      16,    66,   498,   262,   582,   584,   498,   498,   236,   583,
     583,   583,   583,  3098,   583,   539,   430,   583,   583,   583,
     583,   583,   583,   358,   583,   539,   361,   583,  2655,  2656,
     583,  2658,   583,   334,   545,   584,   450,   451,   583,   583,
    2667,   583,   172,  3372,  3260,   583,  2673,   584,   583,   384,
     385,   583,   387,   583,   583,   338,  2683,   584,   583,   338,
     533,   583,   583,   583,  2691,   349,   494,   255,    58,   276,
     582,   349,   582,   487,   273,   274,   275,   276,   277,   278,
     582,  2708,   281,   282,   283,   284,   285,   286,   423,   288,
      58,    45,   374,  2720,    45,   583,   583,   583,   138,    45,
    2727,   583,   583,   145,  3251,     5,   394,  2734,   349,  3152,
     134,   349,   583,  2740,   413,   584,   375,    45,    45,   533,
    3205,   535,    45,   583,   121,   584,   424,   583,    16,   587,
     554,   280,   582,  3218,   591,   394,   175,   554,   583,   145,
    3431,   400,   226,   141,   590,   583,   213,   406,   569,   584,
     141,   554,   109,   590,   269,   128,   214,   591,   570,   590,
     338,   584,   582,   141,   569,   199,   584,   141,  3211,   255,
     445,   430,   172,   570,   404,   590,  3467,  3468,   172,  3470,
     172,   516,   569,   556,   545,   111,   173,  2814,  1848,  1604,
     525,   450,   451,  3594,  3255,  3375,  3248,   396,   397,  3732,
    3695,   694,  3703,  3626,  3585,  3626,  3592,   415,  3081,   409,
    1102,  2810,  1573,  3176,  2078,  1161,  1539,   425,  1577,  2740,
    3511,   429,  3513,  3514,  1993,  2040,   434,  3203,   487,  2796,
    2727,   439,  2763,  2997,  3043,  2763,  3034,  2728,  3419,  2683,
    3428,  3195,  3344,  2085,  3262,  1174,  3218,  3576,  1080,   584,
    2036,  1507,  1897,   461,    23,    24,  1436,  1157,  2303,   703,
    1879,   687,   473,  1911,  3309,   617,  1451,  2921,  3124,  1350,
     478,  2922,  2698,  2114,   533,  3418,   535,  2734,  1348,  1252,
     488,  1202,  2276,  3173,   492,  3368,  2913,  3620,    57,  3152,
     498,  3620,   500,   501,  1916,  2936,     6,   505,   506,    68,
     970,  2650,   993,    13,  1901,  1875,  2649,   515,    77,  2936,
    2708,   519,  3685,    23,    24,  3504,   524,   525,   463,   527,
     528,   529,   530,  3443,  2951,  1179,   520,    96,  1496,   740,
     454,   998,  2640,  3575,  1402,  3406,  3595,  3474,  3701,  3036,
    1457,  2655,   111,    53,  2691,   114,  3431,    57,  2962,  2355,
    1011,  1001,  3160,   446,   600,   563,   963,  3297,    68,  1166,
    2290,  3303,  1428,  3120,   447,  2992,   736,    77,   604,   490,
    2076,   579,  2807,    83,   143,  3078,    -1,    -1,    -1,   587,
     588,  1324,  3467,  3468,   592,  3470,    96,  3014,    -1,    -1,
      -1,   599,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   111,    -1,    -1,   114,    -1,    -1,  3034,    -1,    -1,
      -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,   129,
      -1,   629,    -1,    -1,    -1,    -1,  3511,   137,  3513,  3514,
      -1,    -1,  3059,   143,  3061,    -1,    -1,    -1,    -1,    -1,
    3506,    -1,    -1,    -1,  3071,    -1,    -1,    -1,   217,    -1,
    3077,    -1,    -1,    -1,    -1,   224,    -1,    -1,    -1,   169,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3071,    -1,    -1,    -1,    -1,    -1,
     688,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   696,    -1,
      -1,   699,    -1,    -1,   702,   703,  3616,  3124,    -1,    -1,
      -1,    -1,    -1,  3546,    -1,    -1,    -1,   217,    -1,    -1,
      -1,    -1,    -1,    -1,   224,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   292,    -1,  3152,    -1,    -1,    -1,    -1,
     738,    -1,   740,    -1,    -1,    -1,    -1,    -1,   307,    -1,
      -1,    -1,    -1,    -1,    -1,  3172,    -1,    -1,    -1,    -1,
      -1,  3178,  3179,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3192,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   292,    -1,  3211,    -1,    -1,  3707,    -1,   358,
      -1,    -1,   361,    -1,    -1,    -1,    -1,   307,    -1,    -1,
      -1,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3732,    -1,    -1,   384,   385,    -1,   387,    -1,
      -1,    -1,  3249,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3262,    -1,    -1,  3681,    -1,
      -1,    -1,   352,    -1,    -1,  3730,    -1,    -1,   358,    -1,
      -1,   361,    -1,    -1,   423,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    23,    24,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   384,   385,    -1,   387,    -1,    -1,
      -1,   889,    -1,   891,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   401,    -1,    -1,    -1,    55,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    64,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,   423,    -1,   923,    -1,    77,    -1,    -1,
      -1,   929,    -1,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   516,  3375,    55,
      56,   111,    -1,    -1,   114,    -1,   525,    -1,   966,    65,
     968,    67,   970,    -1,    -1,    -1,  3393,  3394,    -1,    -1,
      -1,    -1,    -1,    -1,   982,   983,    -1,    -1,    -1,    85,
      -1,    87,    -1,   143,   992,   993,  3413,    -1,  3415,    95,
    3417,  3418,    -1,    -1,    -1,  1003,    -1,  3394,    -1,    -1,
      -1,    -1,  3429,  1011,    -1,    -1,   516,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   525,    -1,  1025,  1026,  1027,
    1028,    -1,    -1,    -1,    -1,    -1,    -1,  1035,    -1,  1037,
      -1,    -1,    -1,    -1,    -1,  1043,   142,   143,  3465,    -1,
      -1,   147,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,  1066,    -1,
      -1,    -1,    -1,    -1,   224,    -1,    -1,    -1,    -1,    -1,
      -1,   177,  3499,   179,    -1,    -1,    -1,  3504,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3523,    -1,    -1,  3526,
    3527,  3528,    -1,    -1,  1112,    -1,    -1,  1115,    -1,    -1,
     216,   217,    -1,    -1,   220,    -1,    -1,    -1,    -1,  3546,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3557,   237,   292,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3567,  3568,    -1,    -1,    -1,  3572,    -1,   307,    -1,    -1,
      -1,    -1,   258,    -1,    -1,    -1,  1164,   263,  1166,  1167,
    1168,  3588,  1170,  3590,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1179,    -1,  1181,    -1,    -1,    -1,    -1,    -1,  3606,
      -1,   287,    -1,    -1,    -1,    -1,    -1,    -1,  3615,    -1,
      -1,    -1,    -1,    -1,    -1,  3622,    -1,    -1,   358,    -1,
      -1,   361,  3629,    -1,  3631,  3632,    -1,  1215,    -1,    -1,
      -1,    -1,    -1,  3640,   320,    -1,    -1,    -1,    -1,  3646,
      -1,    -1,    -1,   329,   384,   385,    -1,   387,    -1,    -1,
      -1,    -1,    -1,    -1,  3661,    -1,    -1,  3664,    -1,  3666,
    3667,   347,    -1,  3670,    -1,  3672,    -1,  1255,    -1,    -1,
      -1,  3678,    -1,    -1,  3681,    -1,    -1,    -1,  3685,    -1,
      -1,    -1,    -1,   423,  3691,    -1,    -1,   373,   374,    -1,
      -1,   377,   378,    -1,  3701,    -1,    -1,  3704,    -1,  3706,
    3707,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3718,  3719,    -1,    -1,  3722,    -1,     3,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3732,  1314,    13,    14,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      26,  1329,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   439,    -1,    -1,    -1,    -1,   444,    -1,
      -1,    47,    48,    -1,    -1,    -1,    -1,    53,   454,    -1,
      -1,    57,    58,    -1,    -1,    -1,   516,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,   525,    -1,    -1,    -1,   475,
      -1,    -1,    -1,   479,    -1,    -1,    -1,  1385,    -1,    -1,
      -1,    87,  1390,    -1,  1392,    -1,    -1,    -1,   494,  1397,
      -1,    -1,    -1,    -1,    -1,  1403,    -1,  1405,    -1,    -1,
     106,    -1,  1410,  1411,    -1,  1413,  3499,    -1,    -1,   115,
     116,   117,    -1,    -1,    -1,    -1,    -1,  1425,    -1,    -1,
    1428,    -1,   128,   129,    -1,    -1,  1434,  1435,  1436,  1437,
      -1,    -1,    -1,  3526,  3527,    -1,  1444,  1445,  1446,    -1,
      -1,    -1,   548,    -1,    -1,   151,   552,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1462,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   168,  1471,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3567,  3568,    -1,    -1,    -1,  3572,
    1488,    -1,    -1,    -1,    -1,    -1,   192,    -1,    -1,    -1,
      -1,    -1,  1500,   199,    -1,  3588,   202,  3590,    -1,    -1,
      -1,    -1,    -1,    -1,  1512,    -1,    -1,    -1,    -1,    -1,
    1518,    -1,    -1,  3606,    -1,    -1,    -1,   223,    -1,    -1,
      -1,    -1,  3615,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   239,    -1,    -1,  3629,    -1,    -1,  3632,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3640,    -1,    -1,
      -1,   257,    -1,  3646,    -1,    -1,   262,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3661,  1577,
      -1,    -1,    -1,    -1,  3667,    -1,    -1,  3670,  1586,    -1,
      -1,    -1,    -1,    -1,    -1,  3678,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3691,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1614,    -1,    -1,    -1,
      -1,  3704,    -1,  3706,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3718,  3719,    -1,    -1,  3722,
      -1,    -1,  1640,    -1,    -1,  1643,    -1,    -1,    -1,    -1,
      -1,    -1,   348,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   370,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   399,    -1,   401,   402,    -1,    -1,   405,
      -1,    -1,   408,    -1,   410,    -1,    -1,    -1,    -1,   415,
      -1,   417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     426,    -1,    -1,    -1,   430,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   445,
      -1,    -1,    -1,    -1,   450,    -1,    -1,    -1,   454,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   474,    -1,
      -1,    -1,   478,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1801,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   514,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,    -1,
      -1,    -1,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   582,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1902,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1920,  1921,    -1,    -1,    -1,    -1,    -1,  1927,
      -1,  1929,  1930,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1967,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1979,  1980,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1989,    -1,    -1,    -1,    -1,    -1,  1995,    -1,    -1,
    1998,    -1,    -1,  2001,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2012,  2013,    -1,  2015,    -1,    -1,
      -1,    -1,    -1,  2021,  2022,    -1,    -1,    -1,    -1,    13,
      14,    -1,    -1,  2031,    -1,  2033,    -1,    -1,    -1,  2037,
    2038,    -1,    26,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    -1,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,  2077,
    2078,    -1,    -1,   522,    -1,    -1,    70,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,  2106,    -1,
      -1,    -1,    -1,    -1,    -1,  2113,    -1,    -1,    -1,    -1,
      -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,  2126,    -1,
      -1,   115,   116,   117,    -1,    -1,   575,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,    -1,
      -1,    -1,    -1,    -1,  2172,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   192,    -1,
      -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,   202,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   223,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   239,    -1,  2255,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   706,    -1,    -1,
      -1,    -1,    -1,   257,    -1,    -1,    -1,    -1,   262,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2286,    -1,
      -1,    -1,  2290,    -1,  2292,  2293,  2294,  2295,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2303,    -1,    -1,    -1,  2307,
      -1,    -1,  2310,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2324,  2325,  2326,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2337,
      -1,    -1,    -1,    -1,    -1,  2343,    -1,  2345,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2353,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   348,    -1,    -1,    -1,   807,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   399,  2414,   401,   402,    -1,
      -1,   405,    -1,    -1,   408,    -1,   410,  2425,    -1,    -1,
    2428,   415,    -1,   417,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   426,    -1,   883,    -1,   430,    -1,   887,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   445,    -1,    -1,  2462,    -1,   450,    -1,    -1,    -1,
     454,  2469,    -1,    -1,  2472,    -1,    -1,    -1,  2476,  2477,
      -1,    -1,  2480,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     474,    -1,  2490,    -1,   478,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,    -1,    -1,    -1,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1011,    -1,    -1,    -1,    -1,   561,    -1,    -1,
      -1,  1020,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   582,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2655,  2656,    -1,
    2658,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2667,
      -1,    -1,    -1,    -1,    -1,  2673,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2683,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2691,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2708,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2720,    -1,    -1,    -1,    -1,    -1,    -1,  2727,
      -1,    -1,    -1,    -1,    -1,    -1,  2734,    -1,    -1,    -1,
      -1,    -1,  2740,    -1,  1183,  1184,  1185,    -1,    -1,    -1,
      -1,    -1,    -1,  1192,  1193,    -1,    -1,  1196,    -1,  1198,
    1199,  1200,  1201,    -1,    -1,    -1,  1205,    -1,    -1,  1208,
    1209,    -1,  1211,    -1,  1213,  1214,    -1,  1216,  1217,  1218,
    1219,  1220,    -1,  1222,    -1,  1224,  1225,  1226,    -1,  1228,
    1229,  1230,  1231,    -1,  1233,  1234,    -1,  1236,    -1,    -1,
    1239,  1240,  1241,    -1,  1243,  1244,  1245,  1246,    -1,  1248,
    1249,  1250,  1251,    -1,    -1,    -1,  2814,    -1,  1257,  1258,
      -1,  1260,  1261,  1262,  1263,  1264,    -1,    -1,    -1,    -1,
    1269,    -1,  1271,  1272,  1273,  1274,  1275,    -1,    -1,  1278,
    1279,  1280,  1281,  1282,  1283,    -1,  1285,  1286,    -1,    -1,
      -1,  1290,  1291,  1292,    -1,  1294,    -1,  1296,    -1,    -1,
      -1,  1300,    -1,  1302,  1303,    -1,    -1,    -1,    -1,  1308,
      -1,    -1,    -1,    -1,    31,    32,    -1,  1316,  1317,  1318,
      37,    -1,    39,    -1,    41,    42,  1325,    -1,    -1,  1328,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    56,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2913,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2936,    -1,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,  1387,    -1,
      -1,   108,    -1,  2951,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     127,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,    -1,    -1,
      -1,    -1,  1431,    -1,  2992,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   165,    -1,
     167,    -1,    -1,    -1,    -1,    -1,  3014,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,    -1,    -1,    -1,  3034,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3059,    -1,  3061,    -1,    -1,    -1,    -1,    -1,    -1,
     227,    -1,    -1,  3071,    -1,    -1,    -1,    -1,    -1,  3077,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   256,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
      -1,   268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3124,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,
     297,   298,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1588,
      -1,    -1,    -1,    -1,  3152,    -1,    -1,    -1,    -1,    -1,
     317,   318,   319,    -1,    -1,    -1,   323,    -1,    -1,   326,
      -1,    -1,    -1,    -1,  3172,    -1,    -1,    -1,    -1,    -1,
    3178,  3179,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3192,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   365,    -1,
     367,    -1,    -1,  3211,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3249,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3262,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   443,    -1,   445,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   455,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1773,  1774,  1775,    -1,    -1,    -1,
      -1,    -1,   499,   500,    -1,    -1,   503,   504,   505,   506,
      -1,  1790,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1815,  3375,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,
     547,    -1,    -1,    -1,    -1,  3393,  3394,    -1,    -1,  1838,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   565,    -1,
      -1,    -1,    -1,    -1,    -1,  3413,    -1,  3415,    -1,  3417,
    3418,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3429,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3465,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3504,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3523,    -1,    -1,    -1,    -1,
    3528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3546,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3557,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3622,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3631,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2093,    -1,    -1,  2096,    -1,    -1,
    2099,  2100,    -1,    -1,    -1,    -1,  3664,    -1,  3666,    -1,
      -1,    -1,    -1,  2112,  3672,    -1,  2115,    -1,    -1,    -1,
      -1,    -1,    -1,  3681,    -1,    -1,    -1,  3685,    -1,  2128,
      -1,  2130,    -1,    -1,    -1,  2134,    -1,  2136,  2137,    -1,
      -1,    -1,  2141,  3701,  2143,  2144,    -1,  2146,    -1,  3707,
    2149,    -1,  2151,  2152,    -1,    -1,    -1,    -1,  2157,  2158,
      -1,    -1,  2161,    -1,  2163,    -1,  2165,    -1,  2167,    -1,
    2169,    -1,    -1,    -1,  3732,    -1,    -1,    -1,    -1,    -1,
      -1,  2180,  2181,    -1,    -1,  2184,    -1,  2186,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2194,  2195,    -1,  2197,    -1,
    2199,    -1,    -1,  2202,  2203,  2204,    -1,  2206,    -1,    -1,
      -1,    -1,    -1,  2212,  2213,  2214,  2215,    -1,    -1,    -1,
      -1,  2220,  2221,  2222,    -1,  2224,    -1,  2226,    -1,  2228,
      -1,  2230,    -1,  2232,    -1,    -1,    -1,    -1,    -1,    -1,
    2239,    -1,  2241,    -1,    -1,  2244,  2245,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2256,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2275,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2297,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2346,    -1,    -1,
      -1,    -1,  2351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2395,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2506,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2579,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2589,    -1,  2591,    -1,  2593,    -1,    -1,    -1,    -1,    -1,
    2599,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2624,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2692,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2837,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2847,    -1,
      -1,    -1,    -1,    -1,  2853,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2862,  2863,    -1,    -1,    -1,    -1,  2868,
      -1,    -1,    -1,  2872,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2885,    -1,    -1,    -1,
      -1,    -1,  2891,    -1,    -1,  2894,  2895,    -1,  2897,  2898,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2911,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2977,  2978,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2988,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3147,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3160,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3271,    -1,    -1,    -1,    -1,    -1,  3277,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3313,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3323,    -1,  3325,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3397,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3454,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3477,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3562,  3563,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3581,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3591,    -1,    -1,    -1,    -1,  3596,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3605,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,  3636,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,  3647,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    43,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,  3708,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,   245,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,   452,   453,   454,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,    -1,   495,   496,    -1,   498,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,   508,
     509,    -1,   511,   512,   513,   514,   515,   516,   517,    -1,
     519,   520,   521,   522,    -1,   524,    -1,    -1,   527,   528,
     529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,   544,   545,    -1,    -1,   548,
     549,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,   563,    -1,   565,    -1,    -1,    -1,
      -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,
      -1,   580,    -1,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,    -1,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
     344,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
      -1,   495,   496,    -1,   498,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,   512,   513,
     514,   515,   516,   517,    -1,   519,   520,   521,   522,    -1,
     524,    -1,    -1,   527,   528,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,
      -1,   565,    -1,    -1,    -1,    -1,   570,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,   580,    -1,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,   430,   431,   432,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,   452,   453,   454,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,    -1,   495,   496,    -1,   498,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,   512,   513,   514,   515,   516,   517,    -1,
     519,   520,   521,   522,    -1,   524,    -1,    -1,   527,   528,
     529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,   544,   545,    -1,    -1,   548,
     549,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,   563,    -1,   565,    -1,    -1,    -1,
      -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,
      -1,   580,    -1,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,    -1,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
      -1,   495,   496,    -1,   498,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,   512,   513,
     514,   515,   516,   517,    -1,   519,   520,   521,   522,    -1,
     524,    -1,    -1,   527,   528,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,
      -1,   565,    -1,    -1,    -1,    -1,   570,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,   580,    -1,   582,   583,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,   452,   453,   454,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,    -1,   495,   496,    -1,   498,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,   512,   513,   514,   515,   516,   517,    -1,
     519,   520,   521,   522,    -1,   524,    -1,    -1,   527,   528,
     529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,   544,   545,    -1,    -1,   548,
     549,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,   563,    -1,   565,    -1,    -1,    -1,
      -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,
      -1,   580,    -1,   582,   583,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,    -1,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
      -1,   495,   496,    -1,   498,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,   512,   513,
     514,   515,   516,   517,    -1,   519,   520,   521,   522,    -1,
     524,    -1,    -1,   527,   528,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,
      -1,   565,    -1,    -1,    -1,    -1,   570,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,   580,    -1,   582,   583,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,   452,   453,   454,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,    -1,   495,   496,    -1,   498,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,   512,   513,   514,   515,   516,   517,    -1,
     519,   520,   521,   522,    -1,   524,    -1,    -1,   527,   528,
     529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,   544,   545,    -1,    -1,   548,
     549,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,   563,    -1,   565,    -1,    -1,    -1,
      -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,
      -1,   580,    -1,   582,   583,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
      -1,   495,   496,    -1,   498,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,   512,   513,
     514,   515,   516,   517,    -1,   519,   520,   521,   522,    -1,
     524,    -1,    -1,   527,   528,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,
      -1,   565,    -1,    -1,    -1,    -1,   570,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,   580,    -1,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,   175,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,   452,   453,   454,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,    -1,   495,   496,    -1,   498,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,   512,   513,   514,   515,   516,   517,    -1,
     519,   520,   521,   522,    -1,   524,    -1,    -1,   527,   528,
     529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,   544,   545,    -1,    -1,   548,
     549,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,   563,    -1,   565,    -1,    -1,    -1,
      -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,
      -1,   580,    -1,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
      -1,   495,   496,    -1,   498,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,   512,   513,
     514,   515,   516,   517,    -1,   519,   520,   521,   522,    -1,
     524,    -1,    -1,   527,   528,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,
      -1,   565,    -1,    -1,    -1,    -1,   570,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,   580,    -1,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,   452,   453,   454,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,    -1,   495,   496,    -1,   498,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,   512,   513,   514,   515,   516,   517,    -1,
     519,   520,   521,   522,    -1,   524,    -1,    -1,   527,   528,
     529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,   544,   545,    -1,    -1,   548,
     549,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,   563,    -1,   565,    -1,    -1,    -1,
      -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,
      -1,   580,    -1,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,    -1,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,    -1,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
      -1,   495,   496,    -1,   498,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,   512,   513,
     514,   515,   516,   517,    -1,   519,   520,   521,   522,    -1,
     524,    -1,    -1,   527,   528,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,
      -1,   565,    -1,    -1,    -1,    -1,   570,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,   580,    -1,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,   452,   453,   454,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,    -1,   495,   496,    -1,   498,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,   512,   513,   514,   515,   516,   517,    -1,
     519,   520,   521,   522,    -1,   524,    -1,    -1,   527,   528,
     529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,   544,   545,    -1,    -1,   548,
     549,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,   563,    -1,   565,    -1,    -1,    -1,
      -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,
      -1,   580,    -1,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,    -1,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
      -1,   495,   496,    -1,   498,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,   512,   513,
     514,   515,   516,   517,    -1,   519,   520,   521,   522,    -1,
     524,    -1,    -1,   527,   528,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,
      -1,   565,    -1,    -1,    -1,    -1,   570,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,   580,    -1,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,   452,   453,   454,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,    -1,   495,   496,    -1,   498,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,   512,   513,   514,   515,   516,   517,    -1,
     519,   520,   521,   522,    -1,   524,    -1,    -1,   527,   528,
     529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,   544,   545,    -1,    -1,   548,
     549,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,   563,    -1,   565,    -1,    -1,    -1,
      -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,
      -1,   580,    -1,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,    -1,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,    -1,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
      -1,   495,   496,    -1,   498,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,   512,   513,
     514,   515,   516,   517,    -1,   519,   520,   521,   522,    -1,
     524,    -1,    -1,   527,   528,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,
      -1,   565,    -1,    -1,    -1,    -1,   570,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,   580,    -1,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      79,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,   178,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,   217,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,   238,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,   252,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,   430,   431,    -1,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,   452,   453,   454,    -1,   456,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,   474,   475,    -1,    -1,   478,
     479,    -1,   481,   482,   483,    -1,    -1,    -1,   487,   488,
     489,   490,    -1,   492,   493,    -1,   495,   496,    -1,    -1,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,    -1,    -1,   514,   515,   516,   517,    -1,
      -1,   520,   521,    -1,    -1,   524,    -1,    -1,    -1,    -1,
     529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,   548,
      -1,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,    -1,    -1,   565,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     589,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    79,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,   178,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
     217,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,   238,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,    -1,   433,   434,    -1,    -1,
      -1,    -1,   439,    -1,    -1,   442,   443,   444,    -1,    -1,
     447,    -1,    -1,    -1,   451,   452,   453,   454,    -1,   456,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,   465,   466,
      -1,   468,    -1,    -1,   471,    -1,    -1,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,    -1,    -1,    -1,
     487,   488,   489,   490,    -1,   492,   493,    -1,   495,   496,
      -1,    -1,   499,   500,   501,   502,   503,    -1,    -1,    -1,
      -1,    -1,   509,    -1,   511,    -1,    -1,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,    -1,   524,    -1,    -1,
      -1,    -1,   529,    -1,    -1,   532,    -1,   534,    -1,   536,
     537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,
      -1,   548,    -1,    -1,   551,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,   561,    -1,    -1,    -1,   565,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   589,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,   430,   431,    -1,   433,   434,
      -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,
      -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,   454,
      -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,
     465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,   474,
     475,    -1,    -1,   478,   479,    -1,   481,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,   492,   493,    -1,
     495,   496,    -1,    -1,   499,   500,   501,   502,   503,    -1,
      -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,   524,
      -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,   534,
      -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,   561,    -1,    -1,    -1,
     565,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   583,    -1,
      23,    24,    25,    26,   589,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,    -1,
     433,   434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,
     443,   444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,
     453,   454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,
      -1,    -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,
      -1,   474,   475,    -1,    -1,   478,   479,    -1,   481,   482,
     483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,   492,
     493,    -1,   495,   496,    -1,    -1,   499,   500,   501,   502,
     503,    -1,    -1,    -1,    -1,    -1,   509,    -1,   511,    -1,
      -1,   514,   515,   516,   517,    -1,    -1,   520,   521,    -1,
      -1,   524,    -1,    -1,    -1,    -1,   529,    -1,    -1,   532,
      -1,   534,    -1,   536,   537,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   545,    -1,    -1,   548,    -1,    -1,   551,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,
      -1,    -1,   565,    -1,    -1,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
     583,    17,    -1,    -1,    20,   588,   589,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
     226,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,    -1,   433,   434,    -1,
      -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,    -1,
      -1,   447,    -1,    -1,    -1,   451,   452,   453,   454,    -1,
     456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,   465,
     466,    -1,   468,    -1,    -1,   471,    -1,    -1,   474,   475,
      -1,    -1,   478,   479,    -1,   481,   482,   483,    -1,    -1,
      -1,   487,   488,   489,   490,    -1,   492,   493,    -1,   495,
     496,    -1,    -1,   499,   500,   501,   502,   503,    -1,    -1,
      -1,    -1,    -1,   509,    -1,   511,    -1,    -1,   514,   515,
     516,   517,    -1,    -1,   520,   521,    -1,    -1,   524,    -1,
      -1,    -1,    -1,   529,    -1,    -1,   532,    -1,   534,    -1,
     536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,
      -1,    -1,   548,    -1,    -1,   551,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,   561,    -1,    -1,    -1,   565,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   589,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,    -1,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,    -1,    -1,   478,   479,    -1,   481,   482,   483,
      -1,    -1,    -1,   487,   488,   489,   490,    -1,   492,   493,
      -1,   495,   496,    -1,    -1,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,
     514,   515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,
     524,    -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,    -1,
      -1,   565,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,   576,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   589,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
      -1,   433,   434,    -1,    -1,    -1,    -1,   439,    -1,    -1,
     442,   443,   444,    -1,    -1,   447,    -1,    -1,    -1,   451,
     452,   453,   454,    -1,   456,   457,   458,    -1,    -1,    -1,
      -1,    -1,    -1,   465,   466,    -1,   468,    -1,    -1,   471,
      -1,    -1,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,
     492,   493,    -1,   495,   496,    -1,    -1,   499,   500,   501,
     502,   503,    -1,    -1,    -1,    -1,    -1,   509,    -1,   511,
      -1,    -1,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,    -1,   524,    -1,    -1,    -1,    -1,   529,    -1,    -1,
     532,    -1,   534,    -1,   536,   537,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   545,    -1,    -1,   548,    -1,    -1,   551,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,
      -1,    -1,    -1,   565,    -1,    -1,    -1,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
     582,    -1,    17,    -1,    -1,    20,    -1,   589,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,    -1,   433,   434,
      -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,
      -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,   454,
      -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,
     465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,   474,
     475,    -1,    -1,   478,   479,    -1,   481,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,   492,   493,    -1,
     495,   496,    -1,    -1,   499,   500,   501,   502,   503,    -1,
      -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,   524,
      -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,   534,
      -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,   561,    -1,    -1,    -1,
     565,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,   588,   589,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,    -1,   433,   434,    -1,    -1,    -1,
      -1,   439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,
      -1,    -1,    -1,   451,   452,   453,   454,    -1,   456,   457,
     458,    -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,
     468,    -1,    -1,   471,    -1,    -1,   474,   475,    -1,    -1,
     478,   479,    -1,   481,   482,   483,    -1,    -1,    -1,   487,
     488,   489,   490,    -1,   492,   493,    -1,   495,   496,    -1,
      -1,   499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,
      -1,   509,    -1,   511,    -1,    -1,   514,   515,   516,   517,
      -1,    -1,   520,   521,    -1,    -1,   524,    -1,    -1,    -1,
      -1,   529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,
     548,    -1,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,   561,    -1,    -1,    -1,   565,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,   589,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,    -1,   433,   434,    -1,
      -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,    -1,
      -1,   447,    -1,    -1,    -1,   451,   452,   453,   454,    -1,
     456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,   465,
     466,    -1,   468,    -1,    -1,   471,    -1,    -1,   474,   475,
      -1,    -1,   478,   479,    -1,   481,   482,   483,    -1,    -1,
      -1,   487,   488,   489,   490,    -1,   492,   493,    -1,   495,
     496,    -1,    -1,   499,   500,   501,   502,   503,    -1,    -1,
      -1,    -1,    -1,   509,    -1,   511,    -1,    -1,   514,   515,
     516,   517,    -1,    -1,   520,   521,    -1,    -1,   524,    -1,
      -1,    -1,    -1,   529,    -1,    -1,   532,    -1,   534,    -1,
     536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,
      -1,    -1,   548,    -1,    -1,   551,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,   561,    -1,    -1,    -1,   565,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   589,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,    -1,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,    -1,    -1,   478,   479,    -1,   481,   482,   483,
      -1,    -1,    -1,   487,   488,   489,   490,    -1,   492,   493,
      -1,   495,   496,    -1,    -1,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,
     514,   515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,
     524,    -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,    -1,
      -1,   565,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   589,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
      -1,   433,   434,    -1,    -1,    -1,    -1,   439,    -1,    -1,
     442,   443,   444,    -1,    -1,   447,    -1,    -1,    -1,   451,
     452,   453,   454,    -1,   456,   457,   458,    -1,    -1,    -1,
      -1,    -1,    -1,   465,   466,    -1,   468,    -1,    -1,   471,
      -1,    -1,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,
     492,   493,    -1,   495,   496,    -1,    -1,   499,   500,   501,
     502,   503,    -1,    -1,    -1,    -1,    -1,   509,    -1,   511,
      -1,    -1,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,    -1,   524,    -1,    -1,    -1,    -1,   529,    -1,    -1,
     532,    -1,   534,    -1,   536,   537,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   545,    -1,    -1,   548,    -1,    -1,   551,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,
      -1,    -1,    -1,   565,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,   589,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,    -1,   433,   434,    -1,    -1,    -1,    -1,   439,
      -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,    -1,
      -1,   451,   452,   453,   454,    -1,   456,   457,   458,    -1,
      -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,    -1,
      -1,   471,    -1,    -1,   474,   475,    -1,    -1,   478,   479,
      -1,   481,   482,   483,    -1,    -1,    -1,   487,   488,   489,
     490,    -1,   492,   493,    -1,   495,   496,    -1,   498,   499,
     500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,   509,
      -1,   511,    -1,    -1,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,    -1,   524,    -1,    -1,    -1,    -1,   529,
      -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,   548,    -1,
      -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,   561,    -1,    -1,     5,   565,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,   588,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,    -1,   433,   434,    -1,    -1,    -1,    -1,   439,    -1,
      -1,   442,   443,   444,    -1,    -1,   447,    -1,    -1,    -1,
     451,   452,   453,   454,    -1,   456,   457,   458,    -1,    -1,
      -1,    -1,    -1,    -1,   465,   466,    -1,   468,    -1,    -1,
     471,    -1,    -1,   474,   475,    -1,    -1,   478,   479,    -1,
     481,   482,   483,    -1,    -1,    -1,   487,   488,   489,   490,
      -1,   492,   493,    -1,   495,   496,    -1,   498,   499,   500,
     501,   502,   503,    -1,    -1,    -1,    -1,    -1,   509,    -1,
     511,    -1,    -1,   514,   515,   516,   517,    -1,    -1,   520,
     521,    -1,    -1,   524,    -1,    -1,    -1,    -1,   529,    -1,
      -1,   532,    -1,   534,    -1,   536,   537,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   545,    -1,    -1,   548,    -1,    -1,
     551,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
     561,    -1,    -1,     5,   565,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,   588,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,   251,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
      -1,   433,   434,    -1,    -1,    -1,    -1,   439,    -1,    -1,
     442,   443,   444,    -1,    -1,   447,    -1,    -1,    -1,   451,
     452,   453,   454,    -1,   456,   457,   458,    -1,    -1,    -1,
      -1,    -1,    -1,   465,   466,    -1,   468,    -1,    -1,   471,
      -1,    -1,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,
     492,   493,    -1,   495,   496,    -1,   498,   499,   500,   501,
     502,   503,    -1,    -1,    -1,    -1,    -1,   509,    -1,   511,
      -1,    -1,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,    -1,   524,    -1,    -1,    -1,    -1,   529,    -1,    -1,
     532,    -1,   534,    -1,   536,   537,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   545,    -1,    -1,   548,    -1,    -1,   551,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,
      -1,    -1,     5,   565,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,   588,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,    52,
      -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    -1,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
     163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,    -1,
     403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,   412,
     413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,   431,    -1,
     433,   434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,
     443,   444,    -1,    -1,   447,    -1,    -1,    -1,   451,    -1,
     453,    -1,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,
      -1,    -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,
      -1,    -1,   475,    -1,    -1,    -1,   479,    -1,   481,   482,
     483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,   492,
     493,    -1,   495,   496,    -1,    -1,   499,   500,   501,   502,
     503,    -1,    -1,    -1,    -1,    -1,   509,    -1,   511,    -1,
      -1,    -1,   515,   516,   517,    -1,    -1,   520,   521,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   529,    -1,    -1,   532,
      -1,    -1,    -1,   536,   537,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   545,    -1,    -1,   548,    -1,    -1,   551,   552,
     553,    -1,    -1,   556,    -1,   558,    -1,   560,    -1,    -1,
      -1,    -1,   565,    -1,    -1,    -1,    -1,   570,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,   584,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,    -1,   433,   434,    -1,    -1,
      -1,    -1,   439,    -1,    -1,   442,   443,   444,    -1,    -1,
     447,    -1,    -1,    -1,   451,   452,   453,   454,    -1,   456,
     457,   458,    -1,    -1,    -1,    -1,    -1,    -1,   465,   466,
      -1,   468,    -1,    -1,   471,    -1,    -1,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,    -1,    -1,    -1,
     487,   488,   489,   490,    -1,   492,   493,    -1,   495,   496,
      -1,    -1,   499,   500,   501,   502,   503,    -1,    -1,    -1,
      -1,    -1,   509,    -1,   511,    -1,    -1,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,    -1,   524,    -1,    -1,
      -1,    -1,   529,    -1,    -1,   532,    -1,   534,    -1,   536,
     537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,
      -1,   548,    -1,    -1,   551,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,   561,    -1,    -1,    -1,   565,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,   576,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,    -1,   433,   434,    -1,
      -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,    -1,
      -1,   447,    -1,    -1,    -1,   451,   452,   453,   454,    -1,
     456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,   465,
     466,    -1,   468,    -1,    -1,   471,    -1,    -1,   474,   475,
      -1,    -1,   478,   479,    -1,   481,   482,   483,    -1,    -1,
      -1,   487,   488,   489,   490,    -1,   492,   493,    -1,   495,
     496,    -1,    -1,   499,   500,   501,   502,   503,    -1,    -1,
      -1,    -1,    -1,   509,    -1,   511,    -1,    -1,   514,   515,
     516,   517,    -1,    -1,   520,   521,    -1,    -1,   524,    -1,
      -1,    -1,    -1,   529,    -1,    -1,   532,    -1,   534,    -1,
     536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,
      -1,    -1,   548,    -1,    -1,   551,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,   561,    -1,    -1,    -1,   565,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
     576,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,    -1,   433,   434,
      -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,
      -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,   454,
      -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,
     465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,   474,
     475,    -1,    -1,   478,   479,    -1,   481,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,   492,   493,    -1,
     495,   496,    -1,    -1,   499,   500,   501,   502,   503,    -1,
      -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,   524,
      -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,   534,
      -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,   561,    -1,    -1,    -1,
     565,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,   576,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,    -1,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,    -1,    -1,   478,   479,    -1,   481,   482,   483,
      -1,    -1,    -1,   487,   488,   489,   490,    -1,   492,   493,
      -1,   495,   496,    -1,    -1,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,
     514,   515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,
     524,    -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,    -1,
      -1,   565,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,   576,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,    52,
      -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    -1,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,
     133,    -1,   135,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
     163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,    -1,
     403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,   412,
     413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,   431,    -1,
     433,   434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,
     443,   444,    -1,    -1,   447,    -1,    -1,    -1,   451,    -1,
     453,    -1,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,
      -1,    -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,
      -1,    -1,   475,    -1,    -1,    -1,   479,    -1,   481,   482,
     483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,   492,
     493,    -1,   495,   496,    -1,    -1,   499,   500,   501,   502,
     503,    -1,    -1,    -1,    -1,    -1,   509,    -1,   511,    -1,
      -1,    -1,   515,   516,   517,    -1,    -1,   520,   521,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   529,    -1,    -1,   532,
      -1,    -1,    -1,   536,   537,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   545,    -1,    -1,   548,    -1,    -1,   551,   552,
     553,    -1,    -1,   556,    -1,   558,    -1,   560,    -1,    -1,
      -1,    -1,   565,    -1,    -1,   568,     5,   570,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,
      69,    -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
      -1,   200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,    -1,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,
     409,    -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,
      -1,   420,   421,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,   431,    -1,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,    -1,   453,    -1,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,    -1,   475,    -1,    -1,    -1,
     479,    -1,   481,   482,   483,    -1,    -1,    -1,   487,   488,
     489,   490,    -1,   492,   493,    -1,   495,   496,    -1,    -1,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,    -1,    -1,    -1,   515,   516,   517,    -1,
      -1,   520,   521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     529,    -1,    -1,   532,    -1,    -1,    -1,   536,   537,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,   548,
      -1,    -1,   551,   552,   553,   554,    -1,   556,    -1,   558,
      -1,   560,    -1,    -1,    -1,    -1,   565,    -1,    -1,   568,
       5,   570,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,   431,    -1,   433,   434,
      -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,
      -1,    -1,   447,    -1,    -1,    -1,   451,    -1,   453,    -1,
      -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,
     465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,    -1,
     475,    -1,    -1,    -1,   479,    -1,   481,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,   492,   493,    -1,
     495,   496,    -1,    -1,   499,   500,   501,   502,   503,    -1,
      -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,    -1,
     515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,    -1,
      -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,   554,
      -1,   556,    -1,   558,    -1,   560,    -1,    -1,    -1,    -1,
     565,    -1,    -1,   568,     5,   570,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,    -1,   433,   434,    -1,    -1,    -1,    -1,   439,    -1,
      -1,   442,   443,   444,    -1,    -1,   447,    -1,    -1,    -1,
     451,    -1,   453,    -1,    -1,   456,   457,   458,    -1,    -1,
      -1,    -1,    -1,    -1,   465,   466,    -1,   468,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,    -1,    -1,   479,    -1,
     481,   482,   483,    -1,    -1,    -1,   487,   488,   489,   490,
      -1,   492,   493,    -1,   495,   496,    -1,    -1,   499,   500,
     501,   502,   503,    -1,    -1,    -1,    -1,    -1,   509,    -1,
     511,    -1,    -1,    -1,   515,   516,   517,    -1,    -1,   520,
     521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   529,    -1,
      -1,   532,    -1,    -1,    -1,   536,   537,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   545,    -1,    -1,   548,    -1,    -1,
     551,   552,   553,    -1,    -1,   556,    -1,   558,    -1,   560,
      -1,    -1,    -1,    -1,   565,    -1,    -1,    -1,     5,   570,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,   431,    -1,   433,   434,    -1,    -1,
      -1,    -1,   439,    -1,    -1,   442,   443,   444,    -1,    -1,
     447,    -1,    -1,    -1,   451,    -1,   453,    -1,    -1,   456,
     457,   458,    -1,    -1,    -1,    -1,    -1,    -1,   465,   466,
      -1,   468,    -1,    -1,   471,    -1,    -1,    -1,   475,    -1,
      -1,    -1,   479,    -1,   481,   482,   483,    -1,    -1,    -1,
     487,   488,   489,   490,    -1,   492,   493,    -1,   495,   496,
      -1,    -1,   499,   500,   501,   502,   503,    -1,    -1,    -1,
      -1,    -1,   509,    -1,   511,    -1,    -1,    -1,   515,   516,
     517,    -1,    -1,   520,   521,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   529,    -1,    -1,   532,    -1,    -1,    -1,   536,
     537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,
      -1,   548,    -1,    -1,   551,   552,   553,    -1,    -1,   556,
      -1,   558,    -1,   560,    -1,    -1,    -1,    -1,   565,    -1,
      -1,    -1,     5,   570,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,    52,
      -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    -1,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
     163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,    -1,
     403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,   412,
     413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,   431,    -1,
     433,   434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,
     443,   444,    -1,    -1,   447,    -1,    -1,    -1,   451,    -1,
     453,    -1,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,
      -1,    -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,
      -1,    -1,   475,    -1,    -1,    -1,   479,    -1,   481,   482,
     483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,   492,
     493,    -1,   495,   496,    -1,    -1,   499,   500,   501,   502,
     503,    -1,    -1,    -1,    -1,    -1,   509,    -1,   511,    -1,
      -1,    -1,   515,   516,   517,    -1,    -1,   520,   521,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   529,    -1,    -1,   532,
      -1,    -1,    -1,   536,   537,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   545,    -1,    -1,   548,    -1,    -1,   551,   552,
     553,    -1,    -1,   556,    -1,   558,    -1,   560,    -1,    -1,
      -1,    -1,   565,    -1,    -1,    -1,     5,   570,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,
      69,    -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
      -1,   200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,    -1,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,
     409,    -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,
      -1,   420,   421,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,   431,    -1,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,    -1,   453,    -1,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,    -1,   475,    -1,    -1,    -1,
     479,    -1,   481,   482,   483,    -1,    -1,    -1,   487,   488,
     489,   490,    -1,   492,   493,    -1,   495,   496,    -1,    -1,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,    -1,    -1,    -1,   515,   516,   517,    -1,
      -1,   520,   521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     529,    -1,    -1,   532,    -1,    -1,    -1,   536,   537,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,   548,
      -1,    -1,   551,   552,   553,    -1,    -1,   556,    -1,   558,
      -1,   560,    -1,    -1,    -1,    -1,   565,    -1,    -1,    -1,
       5,   570,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,   431,    -1,   433,   434,
      -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,
      -1,    -1,   447,    -1,    -1,    -1,   451,    -1,   453,    -1,
      -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,
     465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,    -1,
     475,    -1,    -1,    -1,   479,    -1,   481,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,   492,   493,    -1,
     495,   496,    -1,    -1,   499,   500,   501,   502,   503,    -1,
      -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,    -1,
     515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,    -1,
      -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,    -1,
      -1,   556,    -1,   558,    -1,   560,    -1,    -1,    -1,    -1,
     565,    -1,    -1,    -1,     5,   570,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,    -1,   433,   434,    -1,    -1,    -1,    -1,   439,    -1,
      -1,   442,   443,   444,    -1,    -1,   447,    -1,    -1,    -1,
     451,    -1,   453,    -1,    -1,   456,   457,   458,    -1,    -1,
      -1,    -1,    -1,    -1,   465,   466,    -1,   468,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,    -1,    -1,   479,    -1,
     481,   482,   483,    -1,    -1,    -1,   487,   488,   489,   490,
      -1,   492,   493,    -1,   495,   496,    -1,    -1,   499,   500,
     501,   502,   503,    -1,    -1,    -1,    -1,    -1,   509,    -1,
     511,    -1,    -1,    -1,   515,   516,   517,    -1,    -1,   520,
     521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   529,    -1,
      -1,   532,    -1,    -1,    -1,   536,   537,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   545,    -1,    -1,   548,    -1,    -1,
     551,   552,   553,    -1,    -1,   556,    -1,   558,    -1,   560,
      -1,    -1,    -1,    -1,   565,    -1,    -1,    -1,     5,   570,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,   431,    -1,   433,   434,    -1,    -1,
      -1,    -1,   439,    -1,    -1,   442,   443,   444,    -1,    -1,
     447,    -1,    -1,    -1,   451,    -1,   453,    -1,    -1,   456,
     457,   458,    -1,    -1,    -1,    -1,    -1,    -1,   465,   466,
      -1,   468,    -1,    -1,   471,    -1,    -1,    -1,   475,    -1,
      -1,    -1,   479,    -1,   481,   482,   483,    -1,    -1,    -1,
     487,   488,   489,   490,    -1,   492,   493,    -1,   495,   496,
      -1,    -1,   499,   500,   501,   502,   503,    -1,    -1,    -1,
      -1,    -1,   509,    -1,   511,    -1,    -1,    -1,   515,   516,
     517,    -1,    -1,   520,   521,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   529,    -1,    -1,   532,    -1,    -1,    -1,   536,
     537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,
      -1,   548,    -1,    -1,   551,   552,   553,    -1,    -1,   556,
      -1,   558,    -1,   560,    -1,    -1,    -1,    -1,   565,    -1,
      -1,    -1,     5,   570,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,   166,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,   267,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,   332,
     333,    -1,   335,    -1,    -1,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,    -1,
     433,   434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,
     443,   444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,
     453,   454,    -1,   456,   457,   458,    -1,    -1,   461,   462,
     463,    -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,
      -1,   474,   475,    -1,    -1,   478,   479,    -1,   481,   482,
     483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,   492,
     493,    -1,   495,   496,    -1,    -1,   499,   500,   501,   502,
     503,    -1,    -1,    -1,    -1,    -1,   509,    -1,   511,    -1,
      -1,   514,   515,   516,   517,    -1,   519,   520,   521,    -1,
      -1,   524,    -1,    -1,    -1,    -1,   529,    -1,    -1,   532,
      -1,   534,    -1,   536,   537,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   545,    -1,    -1,   548,    -1,    -1,   551,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,
      -1,     5,   565,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    32,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,   111,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,   145,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,   251,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,    -1,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,   446,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,    -1,    -1,   478,   479,    -1,   481,   482,   483,
      -1,    -1,    -1,   487,   488,   489,   490,    -1,   492,   493,
      -1,   495,   496,    -1,   498,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,
     514,   515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,
     524,    -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,    -1,
       5,   565,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,    -1,   433,   434,
      -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,
      -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,   454,
      -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,
     465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,   474,
     475,    -1,    -1,   478,   479,    -1,   481,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,   492,   493,    -1,
     495,   496,    -1,   498,   499,   500,   501,   502,   503,    -1,
      -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,   524,
      -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,   534,
      -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,   561,    -1,    -1,     5,
     565,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,    -1,   433,   434,    -1,
      -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,    -1,
      -1,   447,    -1,    -1,    -1,   451,   452,   453,   454,    -1,
     456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,   465,
     466,    -1,   468,    -1,    -1,   471,    -1,    -1,   474,   475,
      -1,    -1,   478,   479,    -1,   481,   482,   483,    -1,    -1,
      -1,   487,   488,   489,   490,    -1,   492,   493,    -1,   495,
     496,    -1,   498,   499,   500,   501,   502,   503,    -1,    -1,
      -1,    -1,    -1,   509,    -1,   511,    -1,    -1,   514,   515,
     516,   517,    -1,    -1,   520,   521,    -1,    -1,   524,    -1,
      -1,    -1,    -1,   529,    -1,    -1,   532,    -1,   534,    -1,
     536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,
      -1,    -1,   548,    -1,    -1,   551,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,   561,    -1,    -1,     5,   565,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    91,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,    -1,   433,   434,    -1,    -1,
      -1,    -1,   439,    -1,    -1,   442,   443,   444,    -1,    -1,
     447,    -1,    -1,    -1,   451,   452,   453,   454,    -1,   456,
     457,   458,    -1,    -1,    -1,    -1,    -1,    -1,   465,   466,
      -1,   468,    -1,    -1,   471,    -1,    -1,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,    -1,    -1,    -1,
     487,   488,   489,   490,    -1,   492,   493,    -1,   495,   496,
      -1,   498,   499,   500,   501,   502,   503,    -1,    -1,    -1,
      -1,    -1,   509,    -1,   511,    -1,    -1,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,    -1,   524,    -1,    -1,
      -1,    -1,   529,    -1,    -1,   532,    -1,   534,    -1,   536,
     537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,
      -1,   548,    -1,    -1,   551,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,   561,    -1,    -1,     5,   565,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,    -1,   433,   434,    -1,    -1,    -1,
      -1,   439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,
      -1,    -1,    -1,   451,   452,   453,   454,    -1,   456,   457,
     458,    -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,
     468,    -1,    -1,   471,    -1,    -1,   474,   475,    -1,    -1,
     478,   479,    -1,   481,   482,   483,    -1,    -1,    -1,   487,
     488,   489,   490,    -1,   492,   493,    -1,   495,   496,    -1,
     498,   499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,
      -1,   509,    -1,   511,    -1,    -1,   514,   515,   516,   517,
      -1,    -1,   520,   521,    -1,    -1,   524,    -1,    -1,    -1,
      -1,   529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,
     548,    -1,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,   561,    -1,    -1,     5,   565,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,   452,   453,   454,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,   474,   475,    -1,    -1,   478,
     479,    -1,   481,   482,   483,    -1,    -1,    -1,   487,   488,
     489,   490,    -1,   492,   493,    -1,   495,   496,    -1,   498,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,    -1,    -1,   514,   515,   516,   517,    -1,
      -1,   520,   521,    -1,    -1,   524,    -1,    -1,    -1,    -1,
     529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,   548,
      -1,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,    -1,     5,   565,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,    -1,   433,   434,    -1,    -1,    -1,    -1,   439,
      -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,    -1,
      -1,   451,   452,   453,   454,    -1,   456,   457,   458,    -1,
      -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,    -1,
      -1,   471,    -1,    -1,   474,   475,    -1,    -1,   478,   479,
      -1,   481,   482,   483,    -1,    -1,    -1,   487,   488,   489,
     490,    -1,   492,   493,    -1,   495,   496,    -1,   498,   499,
     500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,   509,
      -1,   511,    -1,    -1,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,    -1,   524,    -1,    -1,    -1,    -1,   529,
      -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,   548,    -1,
      -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,   561,    -1,    -1,     5,   565,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,    -1,   433,   434,    -1,    -1,    -1,    -1,   439,    -1,
      -1,   442,   443,   444,    -1,    -1,   447,    -1,    -1,    -1,
     451,   452,   453,   454,    -1,   456,   457,   458,    -1,    -1,
      -1,    -1,    -1,    -1,   465,   466,    -1,   468,    -1,    -1,
     471,    -1,    -1,   474,   475,    -1,    -1,   478,   479,    -1,
     481,   482,   483,    -1,    -1,    -1,   487,   488,   489,   490,
      -1,   492,   493,    -1,   495,   496,    -1,   498,   499,   500,
     501,   502,   503,    -1,    -1,    -1,    -1,    -1,   509,    -1,
     511,    -1,    -1,   514,   515,   516,   517,    -1,    -1,   520,
     521,    -1,    -1,   524,    -1,    -1,    -1,    -1,   529,    -1,
      -1,   532,    -1,   534,    -1,   536,   537,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   545,    -1,    -1,   548,    -1,    -1,
     551,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
     561,    -1,    -1,     5,   565,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    18,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
      -1,   433,   434,    -1,    -1,    -1,    -1,   439,    -1,    -1,
     442,   443,   444,    -1,    -1,   447,    -1,    -1,    -1,   451,
     452,   453,   454,    -1,   456,   457,   458,    -1,    -1,    -1,
      -1,    -1,    -1,   465,   466,    -1,   468,    -1,    -1,   471,
      -1,    -1,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,
     492,   493,    -1,   495,   496,    -1,   498,   499,   500,   501,
     502,   503,    -1,    -1,    -1,    -1,    -1,   509,    -1,   511,
      -1,    -1,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,    -1,   524,    -1,    -1,    -1,    -1,   529,    -1,    -1,
     532,    -1,   534,    -1,   536,   537,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   545,    -1,    -1,   548,    -1,    -1,   551,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,
      -1,    -1,     5,   565,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    82,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
     153,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,    -1,
     433,   434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,
     443,   444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,
     453,   454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,
      -1,    -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,
      -1,   474,   475,    -1,    -1,   478,   479,    -1,   481,   482,
     483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,   492,
     493,    -1,   495,   496,    -1,    -1,   499,   500,   501,   502,
     503,    -1,    -1,    -1,    -1,    -1,   509,    -1,   511,    -1,
      -1,   514,   515,   516,   517,    -1,    -1,   520,   521,    -1,
      -1,   524,    -1,    -1,    -1,    -1,   529,    -1,    -1,   532,
      -1,   534,    -1,   536,   537,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   545,    -1,    -1,   548,    -1,    -1,   551,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,
      -1,     5,   565,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,   175,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,    -1,   433,
     434,    -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,
     444,    -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,
     454,    -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,   465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,
     474,   475,    -1,    -1,   478,   479,    -1,   481,   482,   483,
      -1,    -1,    -1,   487,   488,   489,   490,    -1,   492,   493,
      -1,   495,   496,    -1,    -1,   499,   500,   501,   502,   503,
      -1,    -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,
     514,   515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,
     524,    -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,
     534,    -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,    -1,
       5,   565,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,    -1,   433,   434,
      -1,    -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,
      -1,    -1,   447,    -1,    -1,    -1,   451,   452,   453,   454,
      -1,   456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,
     465,   466,    -1,   468,    -1,    -1,   471,    -1,    -1,   474,
     475,    -1,    -1,   478,   479,    -1,   481,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,   492,   493,    -1,
     495,   496,    -1,    -1,   499,   500,   501,   502,   503,    -1,
      -1,    -1,    -1,    -1,   509,    -1,   511,    -1,    -1,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,    -1,   524,
      -1,    -1,    -1,    -1,   529,    -1,    -1,   532,    -1,   534,
      -1,   536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     545,    -1,    -1,   548,    -1,    -1,   551,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,   561,    -1,    -1,     5,
     565,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,    -1,   433,   434,    -1,
      -1,    -1,    -1,   439,    -1,    -1,   442,   443,   444,    -1,
      -1,   447,    -1,    -1,    -1,   451,   452,   453,   454,    -1,
     456,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,   465,
     466,    -1,   468,    -1,    -1,   471,    -1,    -1,   474,   475,
      -1,    -1,   478,   479,    -1,   481,   482,   483,    -1,    -1,
      -1,   487,   488,   489,   490,    -1,   492,   493,    -1,   495,
     496,    -1,    -1,   499,   500,   501,   502,   503,    -1,    -1,
      -1,    -1,    -1,   509,    -1,   511,    -1,    -1,   514,   515,
     516,   517,    -1,    -1,   520,   521,    -1,    -1,   524,    -1,
      -1,    -1,    -1,   529,    -1,    -1,   532,    -1,   534,    -1,
     536,   537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,
      -1,    -1,   548,    -1,    -1,   551,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,   561,    -1,    -1,     5,   565,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,   372,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,    -1,   433,   434,    -1,    -1,
      -1,    -1,   439,    -1,    -1,   442,   443,   444,    -1,    -1,
     447,    -1,    -1,    -1,   451,   452,   453,   454,    -1,   456,
     457,   458,    -1,    -1,    -1,    -1,    -1,    -1,   465,   466,
      -1,   468,    -1,    -1,   471,    -1,    -1,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,    -1,    -1,    -1,
     487,   488,   489,   490,    -1,   492,   493,    -1,   495,   496,
      -1,    -1,   499,   500,   501,   502,   503,    -1,    -1,    -1,
      -1,    -1,   509,    -1,   511,    -1,    -1,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,    -1,   524,    -1,    -1,
      -1,    -1,   529,    -1,    -1,   532,    -1,   534,    -1,   536,
     537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,
      -1,   548,    -1,    -1,   551,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,   561,    -1,    -1,     5,   565,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,    -1,   433,   434,    -1,    -1,    -1,
      -1,   439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,
      -1,    -1,    -1,   451,   452,   453,   454,    -1,   456,   457,
     458,    -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,
     468,    -1,    -1,   471,    -1,    -1,   474,   475,    -1,    -1,
     478,   479,    -1,   481,   482,   483,    -1,    -1,    -1,   487,
     488,   489,   490,    -1,   492,   493,    -1,   495,   496,    -1,
     498,   499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,
      -1,   509,    -1,   511,    -1,    -1,   514,   515,   516,   517,
      -1,    -1,   520,   521,    -1,    -1,   524,    -1,    -1,    -1,
      -1,   529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,
     548,    -1,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,   561,    -1,    -1,     5,   565,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,
      -1,    -1,   451,   452,   453,   454,    -1,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,
      -1,    -1,   471,    -1,    -1,   474,   475,    -1,    -1,   478,
     479,    -1,   481,   482,   483,    -1,    -1,    -1,   487,   488,
     489,   490,    -1,   492,   493,    -1,   495,   496,    -1,    -1,
     499,   500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,
     509,    -1,   511,    -1,    -1,   514,   515,   516,   517,    -1,
      -1,   520,   521,    -1,    -1,   524,    -1,    -1,    -1,    -1,
     529,    -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,   548,
      -1,    -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,    -1,     5,   565,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,    -1,   433,   434,    -1,    -1,    -1,    -1,   439,
      -1,    -1,   442,   443,   444,    -1,    -1,   447,    -1,    -1,
      -1,   451,   452,   453,   454,    -1,   456,   457,   458,    -1,
      -1,    -1,    -1,    -1,    -1,   465,   466,    -1,   468,    -1,
      -1,   471,    -1,    -1,   474,   475,    -1,    -1,   478,   479,
      -1,   481,   482,   483,    -1,    -1,    -1,   487,   488,   489,
     490,    -1,   492,   493,    -1,   495,   496,    -1,    -1,   499,
     500,   501,   502,   503,    -1,    -1,    -1,    -1,    -1,   509,
      -1,   511,    -1,    -1,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,    -1,   524,    -1,    -1,    -1,    -1,   529,
      -1,    -1,   532,    -1,   534,    -1,   536,   537,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   545,    -1,    -1,   548,    -1,
      -1,   551,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,   561,    -1,    -1,     5,   565,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,    -1,   433,   434,    -1,    -1,    -1,    -1,   439,    -1,
      -1,   442,   443,   444,    -1,    -1,   447,    -1,    -1,    -1,
     451,   452,   453,   454,    -1,   456,   457,   458,    -1,    -1,
      -1,    -1,    -1,    -1,   465,   466,    -1,   468,    -1,    -1,
     471,    -1,    -1,   474,   475,    -1,    -1,   478,   479,    -1,
     481,   482,   483,    -1,    -1,    -1,   487,   488,   489,   490,
      -1,   492,   493,    -1,   495,   496,    -1,    -1,   499,   500,
     501,   502,   503,    -1,    -1,    -1,    -1,    -1,   509,    -1,
     511,    -1,    -1,   514,   515,   516,   517,    -1,    -1,   520,
     521,    -1,    -1,   524,    -1,    -1,    -1,    -1,   529,    -1,
      -1,   532,    -1,   534,    -1,   536,   537,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   545,    -1,    -1,   548,    -1,    -1,
     551,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
     561,    -1,    -1,     5,   565,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    -1,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    -1,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,    -1,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,    -1,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,   431,
      -1,   433,   434,    -1,    -1,    -1,    -1,   439,    -1,    -1,
     442,   443,   444,    -1,    -1,   447,    -1,    -1,    -1,   451,
      -1,   453,    -1,    -1,   456,   457,   458,    -1,    -1,    -1,
      -1,    -1,    -1,   465,   466,    -1,   468,    -1,    -1,   471,
      -1,    -1,    -1,   475,    -1,    -1,    -1,   479,    -1,   481,
     482,   483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,
     492,   493,    -1,   495,   496,    -1,    -1,   499,   500,   501,
     502,   503,    -1,    -1,    -1,    -1,    -1,   509,    -1,   511,
      -1,    -1,    -1,   515,   516,   517,    -1,    -1,   520,   521,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   529,    -1,    -1,
     532,    -1,    -1,    -1,   536,   537,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   545,    -1,    -1,   548,    -1,    -1,   551,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,
      -1,    -1,    -1,   565
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,     3,    13,    14,    26,    28,    47,    48,    53,    57,
      58,    70,    87,   106,   115,   116,   117,   128,   129,   151,
     168,   192,   199,   202,   223,   239,   257,   262,   348,   370,
     379,   399,   401,   402,   405,   408,   410,   415,   417,   426,
     430,   445,   450,   454,   474,   478,   514,   530,   533,   538,
     561,   582,   593,   594,   595,   596,   597,   598,   600,   605,
     607,   612,   630,   795,   813,   816,   824,   826,   828,   831,
     836,   838,   843,   846,   851,   855,   863,   864,  1013,  1015,
    1021,  1024,  1049,  1057,  1068,  1074,  1088,  1091,  1094,  1100,
    1104,  1108,  1111,  1112,  1158,  1175,  1181,  1183,  1190,  1192,
    1217,  1223,  1224,  1225,  1226,  1264,    11,    94,   179,   214,
     374,   809,  1245,  1246,   258,   336,   845,   492,   494,  1177,
    1218,   217,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      42,    44,    46,    47,    50,    52,    54,    55,    57,    59,
      60,    61,    63,    65,    66,    68,    69,    70,    71,    72,
      75,    77,    78,    80,    81,    86,    89,    96,    97,   100,
     105,   106,   112,   114,   120,   122,   123,   124,   128,   131,
     132,   133,   137,   141,   142,   143,   144,   147,   149,   150,
     151,   154,   156,   159,   160,   163,   164,   165,   168,   173,
     174,   177,   179,   186,   187,   190,   191,   193,   199,   200,
     202,   205,   209,   210,   211,   212,   215,   216,   220,   224,
     228,   230,   231,   233,   234,   241,   243,   247,   250,   256,
     258,   261,   263,   273,   274,   275,   276,   277,   278,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   290,   291,
     292,   294,   295,   299,   300,   301,   302,   303,   306,   307,
     310,   312,   314,   317,   318,   319,   320,   321,   322,   323,
     326,   327,   329,   330,   331,   335,   340,   341,   343,   345,
     346,   347,   358,   359,   360,   361,   363,   365,   367,   370,
     371,   373,   375,   376,   377,   378,   380,   381,   382,   383,
     384,   385,   386,   387,   392,   393,   396,   397,   398,   400,
     402,   403,   406,   408,   409,   410,   412,   413,   417,   418,
     420,   421,   423,   424,   425,   426,   428,   429,   431,   433,
     434,   439,   442,   443,   444,   447,   451,   452,   453,   454,
     456,   457,   458,   465,   466,   468,   471,   474,   475,   478,
     479,   481,   482,   483,   487,   488,   489,   490,   492,   493,
     495,   496,   499,   500,   501,   502,   503,   509,   511,   514,
     515,   516,   517,   520,   521,   524,   529,   532,   534,   536,
     537,   545,   548,   551,   552,   553,   558,   560,   561,   565,
     618,  1148,  1152,  1156,  1157,   287,  1177,  1177,   558,  1219,
      94,   178,   459,   495,   526,   536,   616,   710,   711,   712,
     785,  1058,  1014,    94,   179,   217,   374,   495,   510,   536,
     551,  1020,  1152,   845,   617,   589,  1146,  1147,  1152,   606,
    1022,  1109,    96,   217,   494,  1177,   845,  1152,  1105,   426,
     536,  1177,   845,  1025,  1101,  1177,   617,  1219,  1152,   866,
     868,   869,   349,  1160,  1075,   474,   478,   454,   509,   454,
     494,  1069,  1182,  1050,  1152,    28,    70,   141,   370,   392,
     417,   474,  1266,   430,   582,   865,     0,     3,   370,   156,
    1092,  1146,  1152,   145,   801,  1152,   618,   618,   494,   112,
    1242,  1177,   827,  1219,   852,   853,  1146,   631,   589,   507,
     829,   839,    16,  1220,   213,   713,   617,   354,  1240,  1242,
    1243,  1244,  1245,   494,   711,   217,   214,   270,   382,  1066,
    1067,   930,   931,   213,  1019,  1019,  1152,  1019,  1019,   617,
    1019,  1177,   601,  1095,    12,    13,    87,   115,   129,   151,
     163,   192,   217,   223,   262,   375,   394,   400,   406,   430,
     450,   451,   487,   533,   535,  1193,  1195,  1197,  1198,  1152,
     347,    61,   390,   589,   251,   498,  1149,  1152,  1154,   113,
     204,   270,  1027,    77,   381,  1110,  1113,   226,  1146,  1176,
    1177,   175,    32,   287,  1080,  1106,  1152,   617,   847,  1177,
     113,   270,  1028,  1056,   287,   381,   454,  1102,  1103,   825,
      12,  1191,  1195,   507,  1220,   867,    12,   125,   204,   464,
     465,   466,   467,   468,   469,   480,   873,   874,   875,  1159,
      30,    33,    55,    56,    65,    67,    85,    87,    95,   143,
     147,   177,   179,   191,   193,   216,   217,   220,   237,   258,
     263,   287,   320,   329,   347,   373,   374,   377,   378,   439,
     444,   454,   479,   494,   552,   758,   784,  1076,  1080,  1081,
    1083,  1166,   818,   819,   818,   818,   557,   817,   818,  1018,
    1146,  1177,  1056,    34,   203,   498,  1134,  1150,  1265,  1265,
    1265,  1265,  1265,   868,   865,   583,  1152,  1090,  1089,   301,
     496,   521,   797,   799,   798,  1146,   145,   470,  1247,   837,
    1017,  1018,   229,   584,   859,   860,   582,   632,  1152,   608,
    1017,  1017,    52,   335,   335,   399,  1221,   332,   333,   902,
    1152,    91,  1154,  1155,  1208,  1209,   405,    10,   374,   510,
     725,  1241,  1247,  1248,  1256,  1258,  1242,  1245,   713,  1152,
     175,  1059,  1063,  1064,  1152,  1066,     7,    20,    22,    25,
      29,    32,    34,    35,    36,    38,    51,    55,    56,    62,
      65,    73,    74,    80,    83,    84,    85,    90,    91,    93,
      94,    98,    99,   100,   105,   107,   110,   111,   118,   119,
     136,   139,   140,   152,   155,   157,   158,   162,   166,   171,
     176,   180,   181,   182,   183,   185,   186,   188,   189,   190,
     194,   196,   197,   203,   209,   213,   223,   225,   242,   246,
     249,   254,   256,   259,   264,   267,   272,   279,   289,   293,
     302,   306,   308,   309,   313,   314,   315,   316,   317,   318,
     319,   325,   332,   333,   334,   337,   338,   343,   361,   362,
     364,   365,   366,   367,   368,   380,   388,   404,   405,   416,
     419,   422,   424,   428,   432,   476,   477,   482,   484,   485,
     486,   491,   500,   501,   502,   503,   512,   513,   514,   519,
     522,   527,   528,   536,   540,   541,   542,   543,   544,   549,
     553,   563,   565,   570,   574,   575,   580,   582,   585,   586,
     588,   589,   884,   887,   890,   891,   892,   893,   894,   895,
     896,   897,   898,   899,   903,   906,   907,   909,   916,   920,
     932,  1133,  1135,  1137,  1138,  1142,  1144,  1148,  1150,  1152,
     152,  1152,   618,   344,   618,   618,  1155,  1207,  1017,  1019,
     539,   602,   120,   205,   263,   287,   373,   381,   409,   454,
     475,   492,  1096,  1097,  1177,   373,  1196,   420,   420,   495,
     536,   551,   349,  1200,   492,  1202,    60,   454,  1199,    95,
     551,  1201,   344,   584,    18,   145,   973,   974,  1184,  1152,
     809,   884,    75,   175,   270,  1114,  1120,    47,   175,  1146,
    1178,  1179,   844,   588,   599,  1149,   263,   848,  1155,   849,
     850,  1146,   832,   226,  1018,  1029,  1030,    47,   584,  1017,
    1196,   344,   426,  1222,  1221,   525,  1227,  1228,   576,   877,
     878,   879,   875,  1161,  1162,  1163,   263,   150,   445,   252,
     555,  1087,   515,   582,    94,   179,   374,   494,   551,  1087,
     720,  1154,   253,   992,   994,    63,   475,   172,   475,   475,
     475,   287,   492,    63,   475,    12,    40,    81,    86,   231,
     300,   359,   458,   489,  1070,  1071,  1072,   475,   205,   475,
     475,   515,   992,  1087,   175,   229,  1084,   263,   142,    66,
     376,   492,   511,   475,   548,   815,   398,   471,   820,   821,
     814,    78,   809,   584,   346,  1268,   488,  1269,   236,   412,
    1267,   583,  1228,  1230,  1231,  1232,   863,  1093,  1134,  1152,
     111,   707,   708,   709,   718,   719,   767,   625,   625,   796,
    1155,   429,   551,  1017,   507,   584,   111,   854,  1152,   853,
     217,   238,   782,   783,   861,   633,   634,   884,   273,   274,
     275,   276,   277,   278,   281,   282,   283,   284,   285,   286,
     288,   396,   397,   609,   610,   611,   156,   382,   830,    54,
     156,   159,   172,   299,   382,   840,   841,   842,    52,   399,
     152,   615,   582,   883,   588,   211,   584,   879,   879,   879,
     551,  1248,  1146,   516,   539,   786,  1063,  1146,  1152,   584,
    1061,   589,  1065,   582,   582,   582,   582,   582,   907,   582,
     582,   582,   582,   582,   582,   582,   582,   582,   582,   582,
     582,   582,   582,   883,   883,   582,   883,   582,   582,   582,
     522,   582,  1133,   582,   582,   582,   582,   582,   582,   582,
     582,   582,   582,   582,   582,   582,   582,   582,   582,   582,
     582,   582,   582,   582,   582,   582,   582,   582,   582,   582,
     582,   582,   884,   582,   582,   582,   582,   582,   582,   582,
     582,   582,   582,   933,   934,   935,   582,   582,   582,   582,
     582,   582,   582,   582,   582,   582,   582,   582,   890,   582,
     883,   582,   582,   582,   582,   582,   582,   582,   582,   582,
     582,   582,   582,   582,   582,   582,   582,   582,   582,   582,
     582,   582,   582,   582,   582,   883,   582,  1133,   582,   582,
     582,  1133,   582,   582,    34,   203,   498,   582,   582,   582,
     883,   883,   883,   582,   582,   582,   582,   582,   582,   884,
     937,   907,   907,   907,   430,   582,   884,  1235,  1152,   921,
    1152,   562,   885,   888,   145,   146,   184,   198,   232,   244,
     271,   328,   904,   229,   252,   395,   457,   571,   572,   902,
     573,   448,   449,   574,   575,   126,   313,   576,   577,   578,
     579,   907,   101,   102,   103,   104,   105,   174,   206,   207,
     208,   209,   302,   304,   305,   306,   314,   380,   427,   428,
     553,   564,   565,   970,   971,    64,   353,   584,  1150,   582,
     589,  1146,   584,    49,   411,   810,  1017,   588,   603,   604,
      47,   557,   584,  1098,   492,   582,  1210,  1210,  1210,  1210,
     179,   374,   494,  1194,  1198,  1152,   164,   330,  1152,  1185,
    1186,  1029,   287,   258,  1119,   856,   287,   974,   584,  1017,
    1154,    27,   507,  1107,   584,   507,   584,   507,  1017,  1030,
    1026,  1103,   175,   584,   179,   374,  1194,  1152,    12,   125,
    1234,   584,   870,   881,   884,  1140,  1152,   584,   191,   258,
     345,   444,  1164,  1165,  1168,  1169,   229,  1085,  1149,   884,
     576,   713,   618,   618,  1146,  1146,  1077,   267,   338,   519,
     995,   996,  1135,   618,  1087,  1155,   172,  1082,  1084,   618,
    1087,   230,   490,   160,   172,  1073,   584,  1082,  1082,  1146,
    1084,  1082,  1082,  1087,  1087,   532,   822,   584,   822,   456,
     430,   582,   586,   940,   941,   942,   943,   952,   953,   961,
    1134,   363,  1270,   352,   988,   994,  1233,   709,    64,   758,
      68,    80,   241,   311,   335,   389,   470,   627,   629,     6,
      13,    23,    24,    53,    57,    68,    77,    83,    96,   114,
     123,   124,   129,   137,   143,   169,   215,   217,   224,   292,
     307,   312,   352,   358,   361,   384,   385,   387,   401,   423,
     516,   525,   715,   717,   718,   719,   802,   803,   804,   984,
     112,   228,  1146,   840,  1149,  1018,   582,   583,   584,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   584,   534,   841,   707,   583,  1154,
      45,  1209,   618,   618,   179,  1146,   613,    44,   107,   166,
     200,   203,   267,   335,   338,   425,   431,   433,   434,   435,
     436,   437,   438,   439,   519,   787,   788,   789,   998,   787,
     344,  1062,  1060,   589,  1064,   175,   576,  1152,   974,   884,
     884,   884,    12,   125,   926,   975,   998,   926,   926,   926,
     884,   884,   930,   930,   884,   930,   884,   884,   884,   884,
     125,   926,   975,   884,   583,   884,   884,   884,   884,   884,
    1142,  1152,   884,   884,   884,   884,   884,   582,  1235,   884,
     970,   884,   884,   884,   583,   884,   884,   884,   884,   930,
     884,   884,    97,   100,   500,   503,   972,   884,   125,   923,
    1133,   884,   884,   884,   583,   884,   884,   884,   884,   930,
     884,   884,   884,   884,   934,     9,   936,  1142,   125,   926,
     884,   884,   125,   926,   884,   884,   884,   884,   884,   930,
     930,   930,   884,   884,   884,   884,   884,   884,   930,   894,
     884,   583,   884,   884,   884,   884,   884,   583,   884,   884,
     930,   926,   926,   884,   884,   884,   125,   926,   884,   884,
     971,   971,   884,    43,   245,   508,   884,   884,  1133,   583,
     884,   583,   926,  1143,  1144,  1152,   926,   884,   884,   884,
     554,   939,  1238,  1238,   583,   584,   583,   884,   588,   922,
    1154,   589,   887,   886,   889,   893,   158,   337,   513,   529,
     902,    12,    17,   893,   905,   582,   907,   894,   252,   894,
     895,   229,   252,   395,   571,   896,   897,   897,   898,   906,
     898,   906,   899,   899,   899,   899,   899,   907,   575,  1154,
     907,   884,   908,  1152,  1016,  1155,   810,  1154,   584,   390,
    1097,  1017,  1099,  1152,  1211,  1212,   576,  1146,  1152,  1206,
    1206,  1206,   145,   164,   184,   198,   243,   244,   271,   330,
     371,  1187,  1189,   555,   976,  1023,   218,   857,   858,  1146,
     270,   390,   559,  1180,  1179,   840,   884,  1149,  1155,  1155,
     850,  1146,   156,   382,   537,   833,   834,   835,   430,   445,
     544,   545,   582,   703,  1031,  1034,  1149,   192,  1206,  1206,
    1206,  1229,   878,   175,   226,   871,   872,   987,   988,  1009,
     880,   589,  1162,   111,   509,  1152,  1171,   321,   361,   588,
     758,  1170,  1149,   175,  1086,   583,  1152,   263,   475,  1079,
     341,   584,   454,  1087,  1152,   381,   992,  1072,  1087,  1087,
    1082,  1146,  1087,  1087,   611,   823,   821,   960,  1152,    88,
     219,   236,   249,   324,   416,   480,   951,   445,   584,  1146,
     960,   584,   172,  1271,    45,   992,   145,   446,  1040,  1041,
    1041,  1149,   470,   470,   470,   470,   470,   429,    67,    79,
     178,   459,   730,   733,   734,   780,   782,   808,   808,  1041,
    1041,   808,  1041,  1041,  1041,   507,   122,  1041,   237,   493,
     170,   372,   782,   808,   237,  1041,   493,   122,  1041,  1041,
    1041,   808,    45,  1041,  1041,  1041,  1041,  1041,    18,   145,
     507,   812,  1041,  1041,  1041,   715,   584,   582,   589,   729,
     735,  1145,  1152,   800,   372,   968,  1152,   884,   998,  1149,
    1149,   107,   166,   267,   338,   519,   999,  1149,   998,  1149,
    1149,  1149,  1149,  1149,   998,  1149,  1149,   998,   610,   361,
     498,  1260,     8,    27,   695,   618,  1249,   252,   582,   697,
     714,   716,   717,   434,   439,   584,  1146,   539,   976,  1152,
     941,   589,  1065,   584,   583,   583,   584,   926,   583,   927,
     584,   583,   583,   583,    18,   583,   539,   583,   583,   583,
     583,   584,   584,   539,   584,   584,   917,   583,   576,   583,
     584,   584,   583,   583,   584,   583,   589,   583,   584,   583,
     584,   584,   584,   583,   584,   583,   584,   175,   584,   584,
     583,   584,   583,   584,   584,   583,   584,   583,   583,   584,
     583,   584,   584,   584,   919,   584,   583,   584,   584,   583,
     584,   584,   583,   584,   583,   584,   583,   584,   584,   584,
     583,   582,   584,   926,   583,   583,   583,   926,   583,   583,
     584,   584,   583,   583,   584,   583,   584,   583,   583,   583,
     583,   583,   583,   583,   584,   584,   583,   584,   583,   229,
     583,   583,   584,   584,   584,   583,   584,   584,   583,   583,
     583,   583,   584,   175,   584,   584,   926,   583,   583,   583,
     584,   584,   584,   583,   175,   884,   175,   884,   175,   884,
     175,   583,   584,   584,   583,   583,   583,   583,   583,   584,
     583,   584,   583,   884,   554,   568,   938,   866,  1237,  1235,
     930,   587,   191,   258,   444,  1167,   446,  1152,   351,   354,
     900,    15,    16,   901,   158,   337,   513,   529,   582,   884,
    1235,   149,   980,   894,    16,   582,   907,   894,   894,   970,
     970,   884,   911,   912,   913,   582,   589,   604,   262,   583,
     584,   589,   589,   507,   507,   507,  1188,   977,   993,   994,
    1031,   498,  1151,   584,   859,   559,   258,   507,   834,   704,
    1032,   582,  1037,  1042,  1037,   583,   703,  1033,  1139,  1140,
    1143,  1152,  1035,   349,   175,   175,   175,   864,   130,   941,
    1010,   172,   262,   876,  1009,   993,   872,    18,   882,  1149,
    1152,   576,  1152,   589,   233,   589,  1040,    32,   111,   759,
     760,  1040,  1154,   172,  1040,   588,  1154,    32,   111,   762,
     763,  1154,   999,  1078,   147,   552,   996,   996,   557,   338,
     976,  1082,   584,   955,   960,   940,   236,   236,   355,   962,
     236,   249,   416,   962,   952,   940,  1052,  1053,  1143,   940,
     974,   957,   958,   998,   303,   989,   111,   764,   766,  1154,
     760,    96,    96,   112,   228,   792,  1145,   783,   783,    58,
     170,   372,   526,   732,   781,   731,   732,   792,  1145,   999,
     998,  1145,   998,  1149,  1149,   758,  1041,   998,   238,   238,
    1145,  1145,   720,  1041,   164,   243,   335,   723,   999,   999,
    1145,   985,   986,  1143,   111,   998,  1149,   998,   998,   383,
     386,   722,   998,  1146,    71,    72,   111,   133,   165,   393,
     721,   720,   582,   804,   727,   728,   729,   730,  1152,     8,
     164,   811,   394,   731,   772,   736,   589,   582,  1250,   583,
     584,   498,   582,   115,   223,   533,   696,  1259,  1250,  1146,
     252,   698,   703,   727,   214,   405,   700,  1121,   584,   716,
     788,   614,   941,   987,   976,   974,   225,   884,   884,   583,
     884,   884,    32,    56,    97,   100,   108,   326,   452,   503,
     531,   928,   759,   930,   884,   759,   928,   884,   930,   583,
     906,   906,  1150,  1152,   884,   884,   930,  1150,   884,   884,
     884,   930,   338,   884,   884,   884,   884,   884,   884,   884,
     930,   930,   338,   884,   884,   930,   884,   884,   884,   884,
     930,   884,   894,  1142,   583,   583,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   930,   225,
     884,   884,   884,   884,   583,   884,   884,   884,   884,   175,
     884,   175,   884,   175,   884,   884,   338,   884,   884,   569,
     884,   884,   141,  1239,   583,   583,   589,   589,   589,  1154,
     884,   887,   890,  1235,   583,   584,   583,   907,   893,   884,
    1235,   980,    16,   583,   879,   914,   915,   929,   930,  1152,
    1212,   576,   576,  1208,  1208,  1208,   582,   884,   344,  1047,
    1115,   858,   214,   862,  1155,   873,  1038,  1039,  1143,  1043,
     584,   582,  1034,   583,   583,   584,   589,  1227,   175,  1208,
    1208,  1208,   976,   976,   131,   356,  1005,  1006,  1011,   533,
     229,  1149,  1152,   589,  1152,   250,  1152,    12,    32,   111,
     344,   884,  1174,    64,   765,   884,  1155,   343,   361,   498,
    1173,  1167,  1040,   992,   275,  1087,   611,  1230,   956,   249,
     236,   952,   962,   962,   236,   344,   344,   539,   584,  1051,
    1040,   169,   214,   538,   964,   873,   884,   990,  1141,   884,
     238,   238,   783,   792,   786,   129,   445,   805,   760,  1149,
     792,   810,  1149,   806,   584,    19,   116,   991,  1017,   583,
     584,  1152,  1146,    31,    32,    37,    39,    41,    42,    56,
      97,   100,   108,   127,   144,   165,   167,   186,   187,   227,
     256,   265,   266,   268,   296,   297,   298,   317,   318,   319,
     323,   326,   339,   340,   365,   367,   391,   443,   445,   455,
     499,   500,   503,   504,   505,   506,   546,   547,   565,   737,
     740,   741,   742,   743,   744,   745,   746,  1152,  1152,  1251,
      18,  1152,  1261,   344,   413,   582,   619,    18,  1146,   583,
     583,    18,   706,   716,   582,   976,   253,   997,   884,   583,
     583,   583,   582,   752,   752,   582,   747,   748,   752,   227,
     227,   583,   583,   583,   583,   583,   583,   584,   918,   970,
     970,   583,   583,   583,   583,   583,   583,   584,   583,   583,
     583,   583,   583,   584,   583,   583,   583,   583,   583,   925,
     988,   584,   584,   584,   583,   583,   583,   583,   584,   583,
     583,   583,   584,   229,   557,   910,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   584,   583,   583,   583,   884,
     583,   172,   583,   583,   584,   584,   583,   584,   584,   583,
     884,   583,   884,   583,   884,   583,   583,   584,   583,   583,
     884,   569,  1236,   589,   793,   583,   930,   583,   584,   583,
     893,   884,   584,   583,   407,  1213,  1213,  1213,   111,   884,
    1045,  1046,   132,  1121,   247,   877,   584,  1040,  1044,  1045,
    1042,  1036,  1034,  1139,  1152,  1208,   993,   195,   981,  1151,
    1151,   588,  1007,  1008,  1154,   447,   576,   390,   403,   442,
    1172,   766,  1040,   582,   582,  1171,   884,   145,   583,   942,
     355,   940,   952,   236,   236,   940,   952,   945,   944,   946,
    1053,   976,  1046,   782,   965,   965,   965,   877,   584,   991,
     792,   786,   582,   111,   111,   735,   765,   737,   986,   583,
     728,   773,   582,   582,   752,   747,   369,   738,   747,   747,
      20,    32,    46,   524,   758,   768,    56,   546,   741,   743,
     768,   768,    56,   547,   547,   550,   747,   739,   752,   752,
     768,   582,   752,    23,    64,    68,   111,   337,   344,   372,
     443,   526,   754,   755,   756,   771,   902,   550,   582,   768,
      32,   582,   769,   582,   582,   752,   582,   748,   753,   589,
     583,   584,  1252,  1253,   221,   229,   357,   639,   640,   641,
     642,   879,   108,   227,   391,   481,   726,   620,  1252,   583,
     699,   714,   582,   703,   790,   791,  1152,   996,   970,   338,
     768,   338,   884,   583,   583,   583,   884,   884,   441,   924,
     338,   884,   884,   884,   884,    41,   381,   583,   884,   970,
     884,   884,   884,   884,   884,   583,   583,   583,   338,   884,
    1227,  1152,   583,   930,   880,   915,    59,   234,   331,   472,
     483,   560,  1204,  1205,   557,  1214,  1214,  1214,   583,   584,
    1048,   226,   705,  1039,  1046,   583,  1230,    45,   201,   978,
    1012,  1154,   584,   310,    69,   520,   390,  1173,   498,   498,
    1040,  1149,   974,   236,   344,   948,   952,   952,   344,   950,
     884,   884,   582,   987,   172,   963,   959,  1141,   582,   582,
     790,   100,   500,   503,   574,   575,  1136,  1137,   811,   754,
     289,   344,   582,   774,   776,   777,   778,   338,   338,   452,
     531,   566,   749,   750,   751,   582,   749,   749,   769,    20,
     524,   758,   770,   769,   759,   768,   550,   749,   582,   768,
     338,   749,   764,  1149,   334,   757,  1136,   533,   111,   238,
     756,   238,   337,   338,   338,   338,   338,   749,   338,   749,
    1152,  1152,   557,  1255,   430,   582,  1254,   583,   584,   637,
    1146,   518,   635,   636,   638,  1152,  1255,  1230,   700,   703,
     701,   583,   584,   991,   582,   583,   583,   583,   584,   583,
     583,   584,   583,  1134,   583,   584,   583,   584,   583,   583,
     310,   154,   583,   583,   583,   583,   583,   583,   583,   584,
    1239,   583,   882,   498,   498,   498,    16,  1203,   192,   290,
     291,   294,   295,  1215,  1216,  1046,   238,  1116,   724,   872,
     993,   982,  1141,   979,   987,    66,  1122,  1008,   583,   583,
    1174,    16,   940,   947,   539,   949,   539,   969,  1152,   997,
     236,   966,   724,   991,   790,   790,   583,  1138,  1138,   807,
     177,   360,   453,   115,   533,   775,  1152,   778,   583,   583,
     751,   794,  1134,   759,   769,   794,   583,   883,   334,   545,
     583,   583,   583,   583,    50,    58,   258,   879,   879,  1262,
     641,  1152,   172,  1149,   583,   584,   637,   583,  1227,   791,
     338,   338,   884,   926,   884,   930,  1204,   349,   998,   998,
     998,   998,  1216,   533,   494,   876,   557,   584,   983,   991,
     884,   993,   138,   148,   350,   497,  1123,  1124,   255,  1125,
     276,   344,   884,   582,   884,   582,   583,   584,   582,   583,
     583,   811,    49,   335,   411,   445,   779,   779,   583,   584,
     583,   584,   583,   883,   768,   769,   768,   769,    58,   349,
      58,   866,   865,   626,   737,   879,   621,   638,   737,   702,
     991,   583,   583,   583,   584,   583,   583,   583,  1054,  1055,
    1143,  1146,    89,   418,  1141,   374,  1000,    45,    45,   138,
      45,  1124,   473,   497,  1126,  1127,   145,   954,   969,   969,
    1152,   967,   968,   772,     5,   111,   337,   776,  1152,   768,
    1134,   768,   349,   349,   583,   121,   627,   628,   902,  1263,
     134,   413,  1230,   884,   584,  1040,  1117,   991,  1152,  1134,
    1134,    45,  1134,    45,    45,  1127,   999,   884,   583,   583,
     583,  1230,   121,    61,   161,   213,   235,   248,   347,   414,
     570,   659,   660,   663,   672,   673,   676,   687,  1148,  1153,
    1157,   424,   622,   583,  1055,  1046,   758,   761,  1001,  1134,
    1134,  1134,    16,   587,  1152,   175,   330,   665,   662,  1153,
    1153,  1152,   661,   674,   677,   595,    28,   269,   404,   556,
     690,   591,  1257,   737,   760,  1118,   582,   280,   175,  1152,
     667,   668,   884,   884,   554,   679,   683,   691,   644,   659,
     644,   692,   688,   659,   623,  1122,   879,  1002,  1003,  1004,
     145,   226,   141,   884,   675,   684,   568,   683,   686,   645,
     141,   659,   590,   532,   884,   690,   626,  1125,   884,   583,
     584,   998,   664,   213,   569,   554,   678,   680,   884,   644,
     141,   109,   643,   646,   269,   590,   694,   128,   689,  1153,
     624,   214,  1128,  1004,   666,  1152,   669,   681,   680,   686,
     685,   570,    82,   153,   651,   657,  1152,   141,   659,   590,
     884,   693,   659,   338,   582,  1129,   584,   644,   884,   141,
     569,   199,   584,   647,    76,    92,   590,   141,   644,   255,
     583,   588,  1130,  1131,  1143,   445,  1132,  1152,   670,   682,
     570,   644,   172,  1152,   737,   172,   172,   404,   141,  1154,
     583,   584,  1054,   135,   568,   671,   569,   648,   111,   658,
     462,   654,   998,   649,   650,   556,  1131,   667,   644,   644,
     461,   463,   652,   653,   654,   656,   902,  1152,   884,   545,
     655,   595,   584,   659,   173,  1150,   653
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1226 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     MYSQL_YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1239 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1299 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= yyvsp[0].lex_str;
        }
    break;

  case 56:
#line 1314 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= yyvsp[-2].lex_str;
        }
    break;

  case 57:
#line 1323 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= yyvsp[0].lex_str;
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1330 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= yyvsp[0].lex_str;
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1339 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= yyvsp[0].lex_str;
        }
    break;

  case 60:
#line 1346 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1360 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&yyvsp[0].lex_str, sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 66:
#line 1372 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 67:
#line 1380 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= yyvsp[0].lex_str.str;
       }
    break;

  case 68:
#line 1390 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1396 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1405 "sql_yacc.yy"
    {
	 Lex->mi.host = yyvsp[0].lex_str.str;
       }
    break;

  case 73:
#line 1410 "sql_yacc.yy"
    {
	 Lex->mi.user = yyvsp[0].lex_str.str;
       }
    break;

  case 74:
#line 1415 "sql_yacc.yy"
    {
	 Lex->mi.password = yyvsp[0].lex_str.str;
       }
    break;

  case 75:
#line 1420 "sql_yacc.yy"
    {
	 Lex->mi.port = yyvsp[0].ulong_num;
       }
    break;

  case 76:
#line 1425 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = yyvsp[0].ulong_num;
       }
    break;

  case 77:
#line 1429 "sql_yacc.yy"
    {
           Lex->mi.ssl= yyvsp[0].ulong_num ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1434 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= yyvsp[0].lex_str.str;
         }
    break;

  case 79:
#line 1438 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= yyvsp[0].lex_str.str;
         }
    break;

  case 80:
#line 1442 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= yyvsp[0].lex_str.str;
         }
    break;

  case 81:
#line 1446 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= yyvsp[0].lex_str.str;
         }
    break;

  case 82:
#line 1450 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= yyvsp[0].lex_str.str;
	 }
    break;

  case 84:
#line 1459 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = yyvsp[0].lex_str.str;
       }
    break;

  case 85:
#line 1463 "sql_yacc.yy"
    {
           Lex->mi.pos = yyvsp[0].ulonglong_number;
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1479 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = yyvsp[0].lex_str.str;
         }
    break;

  case 87:
#line 1483 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = yyvsp[0].ulong_num;
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1494 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, yyvsp[0].table, NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
#ifdef ENABLE_SENNA
	  lex->senna_clear();
#endif
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=yyvsp[-3].num | yyvsp[-1].num;
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 89:
#line 1514 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1516 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, yyvsp[0].table, NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1528 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
#ifdef ENABLE_SENNA
            Key *key= new Key(yyvsp[-9].key_type,yyvsp[-7].lex_str.str, yyvsp[-6].key_alg, 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key(yyvsp[-9].key_type, yyvsp[-7].lex_str.str, yyvsp[-6].key_alg, 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1542 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1547 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=yyvsp[-2].lex_str.str;
            lex->create_info.options=yyvsp[-3].num;
	  }
    break;

  case 94:
#line 1554 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1560 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1562 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1569 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1584 "sql_yacc.yy"
    {
            if (!yyvsp[-2].lex_str.str || check_db_name(yyvsp[-2].lex_str.str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), yyvsp[-2].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name(yyvsp[0].lex_str))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    yyval.spname= new sp_name(yyvsp[-2].lex_str, yyvsp[0].lex_str, true);
	    yyval.spname->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1599 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX_STRING db;
	    if (check_routine_name(yyvsp[0].lex_str))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
            if (thd->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    yyval.spname= new sp_name(db, yyvsp[0].lex_str, false);
            if (yyval.spname)
	      yyval.spname->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1617 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            if (lex->definer != NULL)
            {
              /*
                 DEFINER is a concept meaningful when interpreting SQL code.
                 UDF functions are compiled.
                 Using DEFINER with UDF has therefore no semantic,
                 and is considered a parsing error.
              */
	      my_error(ER_WRONG_USAGE, MYF(0), "SONAME", "DEFINER");
              MYSQL_YYABORT;
            }
	    lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    lex->udf.name = lex->spname->m_name;
	    lex->udf.returns=(Item_result) yyvsp[-2].num;
	    lex->udf.dl=yyvsp[0].lex_str.str;
	  }
    break;

  case 101:
#line 1636 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp;

            /* 
              First check if AGGREGATE was used, in that case it's a
              syntax error.
            */
            if (lex->udf.type == UDFTYPE_AGGREGATE)
            {
              my_error(ER_SP_NO_AGGREGATE, MYF(0));
              MYSQL_YYABORT;
            }

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_RECURSIVE_CREATE, MYF(0), "FUNCTION");
	      MYSQL_YYABORT;
	    }
	    /* Order is important here: new - reset - init */
	    sp= new sp_head();
	    sp->reset_thd_mem_root(thd);
	    sp->init(lex);
            sp->init_sp_name(thd, lex->spname);

	    sp->m_type= TYPE_ENUM_FUNCTION;
	    lex->sphead= sp;
	    /*
	     * We have to turn of CLIENT_MULTI_QUERIES while parsing a
	     * stored procedure, otherwise yylex will chop it into pieces
	     * at each ';'.
	     */
	    sp->m_old_cmq= thd->client_capabilities & CLIENT_MULTI_QUERIES;
	    thd->client_capabilities &= ~CLIENT_MULTI_QUERIES;
	    lex->sphead->m_param_begin= lip->tok_start+1;
	  }
    break;

  case 102:
#line 1675 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_param_end= lip->tok_start;
	  }
    break;

  case 103:
#line 1683 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    lex->charset= NULL;
	    lex->length= lex->dec= NULL;
	    lex->interval_list.empty();
	    lex->type= 0;
	  }
    break;

  case 104:
#line 1691 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->fill_field_definition(YYTHD, lex,
                                          (enum enum_field_types) yyvsp[0].num,
                                          &sp->m_return_field_def))
              MYSQL_YYABORT;

	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
	  }
    break;

  case 105:
#line 1703 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_chistics= &lex->sp_chistics;
	    lex->sphead->m_body_begin= lip->tok_start;
	  }
    break;

  case 106:
#line 1712 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->is_not_allowed_in_function("function"))
              MYSQL_YYABORT;

	    lex->sql_command= SQLCOM_CREATE_SPFUNCTION;
	    sp->init_strings(YYTHD, lex);
            if (!(sp->m_flags & sp_head::HAS_RETURN))
            {
              my_error(ER_SP_NORETURN, MYF(0), sp->m_qname.str);
              MYSQL_YYABORT;
            }
	    /* Restore flag if it was cleared above */
	    if (sp->m_old_cmq)
	      YYTHD->client_capabilities |= CLIENT_MULTI_QUERIES;
	    sp->restore_thd_mem_root(YYTHD);
	  }
    break;

  case 107:
#line 1734 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1735 "sql_yacc.yy"
    {}
    break;

  case 109:
#line 1739 "sql_yacc.yy"
    {}
    break;

  case 110:
#line 1740 "sql_yacc.yy"
    {}
    break;

  case 111:
#line 1746 "sql_yacc.yy"
    { Lex->sp_chistics.comment= yyvsp[0].lex_str; }
    break;

  case 112:
#line 1748 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 113:
#line 1750 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 114:
#line 1752 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 115:
#line 1754 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 116:
#line 1756 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 117:
#line 1758 "sql_yacc.yy"
    { }
    break;

  case 118:
#line 1763 "sql_yacc.yy"
    { }
    break;

  case 119:
#line 1764 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 120:
#line 1765 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 121:
#line 1770 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 122:
#line 1774 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 123:
#line 1781 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= yyvsp[0].spname;
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, yyvsp[0].spname, TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 124:
#line 1789 "sql_yacc.yy"
    {}
    break;

  case 129:
#line 1805 "sql_yacc.yy"
    {
	    Lex->value_list.push_back(yyvsp[0].item);
	  }
    break;

  case 130:
#line 1809 "sql_yacc.yy"
    {
	    Lex->value_list.push_back(yyvsp[0].item);
	  }
    break;

  case 135:
#line 1827 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 136:
#line 1847 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[-2].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), yyvsp[-2].lex_str.str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&yyvsp[-2].lex_str,
                                                     (enum enum_field_types)yyvsp[0].num,
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) yyvsp[0].num,
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 141:
#line 1884 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[-1].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&yyvsp[-1].lex_str,
                                                     (enum enum_field_types)yyvsp[0].num,
                                                     (sp_param_mode_t)yyvsp[-3].num);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) yyvsp[0].num,
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 142:
#line 1909 "sql_yacc.yy"
    { yyval.num= sp_param_in; }
    break;

  case 143:
#line 1910 "sql_yacc.yy"
    { yyval.num= sp_param_in; }
    break;

  case 144:
#line 1911 "sql_yacc.yy"
    { yyval.num= sp_param_out; }
    break;

  case 145:
#line 1912 "sql_yacc.yy"
    { yyval.num= sp_param_inout; }
    break;

  case 146:
#line 1916 "sql_yacc.yy"
    {}
    break;

  case 148:
#line 1921 "sql_yacc.yy"
    {}
    break;

  case 150:
#line 1927 "sql_yacc.yy"
    {
	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
	  }
    break;

  case 151:
#line 1931 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if ((yyvsp[-1].spblock.vars || yyvsp[-1].spblock.conds) && (yyvsp[-2].spblock.curs || yyvsp[-2].spblock.hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (yyvsp[-1].spblock.curs && yyvsp[-2].spblock.hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    yyval.spblock.vars= yyvsp[-2].spblock.vars + yyvsp[-1].spblock.vars;
	    yyval.spblock.conds= yyvsp[-2].spblock.conds + yyvsp[-1].spblock.conds;
	    yyval.spblock.hndlrs= yyvsp[-2].spblock.hndlrs + yyvsp[-1].spblock.hndlrs;
	    yyval.spblock.curs= yyvsp[-2].spblock.curs + yyvsp[-1].spblock.curs;
	  }
    break;

  case 152:
#line 1957 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            lex->sphead->reset_lex(YYTHD);
            lex->spcont->declare_var_boundary(yyvsp[0].num);
          }
    break;

  case 153:
#line 1965 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) yyvsp[-1].num;
            Item *dflt_value_item= yyvsp[0].item;
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-yyvsp[-3].num ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            yyval.spblock.vars= yyvsp[-3].num;
            yyval.spblock.conds= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
          }
    break;

  case 154:
#line 2013 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&yyvsp[-3].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), yyvsp[-3].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&yyvsp[-3].lex_str, yyvsp[0].spcondtype);
	    yyval.spblock.vars= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
	    yyval.spblock.conds= 1;
	  }
    break;

  case 155:
#line 2027 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, yyvsp[-2].num,
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 156:
#line 2042 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if (yyvsp[-5].num == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);

	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.curs= 0;
	    yyval.spblock.hndlrs= yyvsp[-1].num;
	    lex->spcont->add_handlers(yyvsp[-1].num);
	  }
    break;

  case 157:
#line 2071 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&yyvsp[-3].lex_str, &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), yyvsp[-3].lex_str.str);
	      delete yyvsp[0].lex;
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, yyvsp[0].lex,
                                  ctx->current_cursor_count());
	    sp->add_instr(i);
	    ctx->push_cursor(&yyvsp[-3].lex_str);
	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.hndlrs= 0;
	    yyval.spblock.curs= 1;
	  }
    break;

  case 158:
#line 2094 "sql_yacc.yy"
    {
	    Lex->sphead->reset_lex(YYTHD);

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 159:
#line 2103 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    yyval.lex= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 160:
#line 2125 "sql_yacc.yy"
    { yyval.num= SP_HANDLER_EXIT; }
    break;

  case 161:
#line 2126 "sql_yacc.yy"
    { yyval.num= SP_HANDLER_CONTINUE; }
    break;

  case 162:
#line 2132 "sql_yacc.yy"
    { yyval.num= 1; }
    break;

  case 163:
#line 2134 "sql_yacc.yy"
    { yyval.num+= 1; }
    break;

  case 164:
#line 2139 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler(yyvsp[0].spcondtype))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition(yyvsp[0].spcondtype);
	      ctx->push_handler(yyvsp[0].spcondtype);
	    }
	  }
    break;

  case 165:
#line 2162 "sql_yacc.yy"
    {			/* mysql errno */
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::number;
	    yyval.spcondtype->mysqlerr= yyvsp[0].ulong_num;
	  }
    break;

  case 166:
#line 2168 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&yyvsp[0].lex_str))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::state;
	    memcpy(yyval.spcondtype->sqlstate, yyvsp[0].lex_str.str, 5);
	    yyval.spcondtype->sqlstate[5]= '\0';
	  }
    break;

  case 167:
#line 2182 "sql_yacc.yy"
    {}
    break;

  case 168:
#line 2183 "sql_yacc.yy"
    {}
    break;

  case 169:
#line 2188 "sql_yacc.yy"
    {
	    yyval.spcondtype= yyvsp[0].spcondtype;
	  }
    break;

  case 170:
#line 2192 "sql_yacc.yy"
    {
	    yyval.spcondtype= Lex->spcont->find_cond(&yyvsp[0].lex_str);
	    if (yyval.spcondtype == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 171:
#line 2201 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::warning;
	  }
    break;

  case 172:
#line 2206 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::notfound;
	  }
    break;

  case 173:
#line 2211 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::exception;
	  }
    break;

  case 174:
#line 2219 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[0].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&yyvsp[0].lex_str, (enum_field_types)0, sp_param_in);
	    yyval.num= 1;
	  }
    break;

  case 175:
#line 2234 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[0].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&yyvsp[0].lex_str, (enum_field_types)0, sp_param_in);
	    yyval.num= yyvsp[-2].num + 1;
	  }
    break;

  case 176:
#line 2251 "sql_yacc.yy"
    { yyval.item = NULL; }
    break;

  case 177:
#line 2252 "sql_yacc.yy"
    { yyval.item = yyvsp[0].item; }
    break;

  case 178:
#line 2256 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->reset_lex(thd);
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 179:
#line 2265 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i=new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);

              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lip->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lip->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(thd->mem_root,
                                           sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(thd);
          }
    break;

  case 180:
#line 2306 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 181:
#line 2308 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, yyvsp[0].item,
                                      sp->m_return_field_def.sql_type, lex);
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 182:
#line 2329 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 183:
#line 2331 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 185:
#line 2334 "sql_yacc.yy"
    {}
    break;

  case 186:
#line 2335 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 187:
#line 2341 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 188:
#line 2347 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[0].lex_str.str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx);
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2376 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[0].lex_str.str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              sp->add_instr(i);
	    }
	  }
    break;

  case 190:
#line 2404 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&yyvsp[0].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2419 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&yyvsp[-1].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 192:
#line 2434 "sql_yacc.yy"
    { }
    break;

  case 193:
#line 2436 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&yyvsp[0].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
	    sp->add_instr(i);
	  }
    break;

  case 197:
#line 2460 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2481 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 199:
#line 2503 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 200:
#line 2505 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               yyvsp[-1].item, lex);

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 201:
#line 2519 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);

	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 202:
#line 2530 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 208:
#line 2550 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2556 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, yyvsp[0].item))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 210:
#line 2567 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 211:
#line 2575 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 212:
#line 2583 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 217:
#line 2601 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2605 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, yyvsp[0].item, true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 219:
#line 2614 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 220:
#line 2622 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2626 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, yyvsp[0].item, false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 222:
#line 2633 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 223:
#line 2641 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            sp->add_instr(i);
          }
    break;

  case 225:
#line 2654 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[-1].lex_str.str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label(yyvsp[-1].lex_str.str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 226:
#line 2672 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (yyvsp[0].lex_str.str)
	    {
	      sp_label_t *lab= lex->spcont->find_label(yyvsp[0].lex_str.str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, yyvsp[0].lex_str.str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 227:
#line 2691 "sql_yacc.yy"
    { yyval.lex_str= null_lex_str; }
    break;

  case 228:
#line 2692 "sql_yacc.yy"
    { yyval.lex_str= yyvsp[0].lex_str; }
    break;

  case 229:
#line 2697 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 230:
#line 2709 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if (yyvsp[-2].spblock.hndlrs)
	      sp->add_instr(new sp_instr_hpop(sp->instructions(), ctx,
					      yyvsp[-2].spblock.hndlrs));
	    if (yyvsp[-2].spblock.curs)
	      sp->add_instr(new sp_instr_cpop(sp->instructions(), ctx,
					      yyvsp[-2].spblock.curs));
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 231:
#line 2725 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
	  }
    break;

  case 232:
#line 2734 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 233:
#line 2736 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       yyvsp[-1].item, lex);

	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 234:
#line 2750 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 235:
#line 2760 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 236:
#line 2762 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               yyvsp[-2].item, lab->ip,
                                                               lex);
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 237:
#line 2778 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 238:
#line 2780 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 239:
#line 2785 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 240:
#line 2787 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 241:
#line 2789 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 242:
#line 2793 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2794 "sql_yacc.yy"
    {}
    break;

  case 244:
#line 2796 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, yyvsp[0].table, NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 245:
#line 2802 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, yyvsp[-1].table, NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 246:
#line 2810 "sql_yacc.yy"
    {}
    break;

  case 247:
#line 2811 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 248:
#line 2811 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2815 "sql_yacc.yy"
    {}
    break;

  case 250:
#line 2817 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 251:
#line 2817 "sql_yacc.yy"
    {}
    break;

  case 252:
#line 2819 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 253:
#line 2819 "sql_yacc.yy"
    {}
    break;

  case 254:
#line 2824 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 255:
#line 2840 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 256:
#line 2844 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 257:
#line 2854 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2855 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2858 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2859 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2862 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2863 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2866 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2867 "sql_yacc.yy"
    {}
    break;

  case 265:
#line 2870 "sql_yacc.yy"
    { yyval.num= 0; }
    break;

  case 266:
#line 2871 "sql_yacc.yy"
    { yyval.num= yyvsp[0].num;}
    break;

  case 267:
#line 2874 "sql_yacc.yy"
    { yyval.num=yyvsp[0].num; }
    break;

  case 268:
#line 2875 "sql_yacc.yy"
    { yyval.num= yyvsp[-1].num | yyvsp[0].num; }
    break;

  case 269:
#line 2878 "sql_yacc.yy"
    { yyval.num=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 270:
#line 2881 "sql_yacc.yy"
    { yyval.num= 0; }
    break;

  case 271:
#line 2882 "sql_yacc.yy"
    { yyval.num=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 279:
#line 2898 "sql_yacc.yy"
    { Lex->create_info.db_type= yyvsp[0].db_type; Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2899 "sql_yacc.yy"
    { Lex->create_info.db_type= yyvsp[0].db_type; WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 281:
#line 2900 "sql_yacc.yy"
    { Lex->create_info.max_rows= yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 282:
#line 2901 "sql_yacc.yy"
    { Lex->create_info.min_rows= yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 283:
#line 2902 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=yyvsp[0].ulong_num; Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 284:
#line 2903 "sql_yacc.yy"
    { Lex->create_info.password=yyvsp[0].lex_str.str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 285:
#line 2904 "sql_yacc.yy"
    { Lex->create_info.comment=yyvsp[0].lex_str; Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 286:
#line 2905 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 287:
#line 2907 "sql_yacc.yy"
    {
            switch(yyvsp[0].ulong_num) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2922 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 289:
#line 2927 "sql_yacc.yy"
    { Lex->create_info.table_options|= yyvsp[0].ulong_num ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 290:
#line 2928 "sql_yacc.yy"
    { Lex->create_info.table_options|= yyvsp[0].ulong_num ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 291:
#line 2929 "sql_yacc.yy"
    { Lex->create_info.row_type= yyvsp[0].row_type;  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 292:
#line 2931 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 293:
#line 2936 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 294:
#line 2941 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 295:
#line 2946 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 298:
#line 2962 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= yyvsp[0].ulong_num; Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 299:
#line 2963 "sql_yacc.yy"
    { Lex->create_info.data_file_name= yyvsp[0].lex_str.str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 300:
#line 2964 "sql_yacc.yy"
    { Lex->create_info.index_file_name= yyvsp[0].lex_str.str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 301:
#line 2965 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= yyvsp[0].lex_str.str; Lex->create_info.connect_string.length= yyvsp[0].lex_str.length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 302:
#line 2970 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && yyvsp[0].charset &&
               !my_charset_same(cinfo->default_table_charset,yyvsp[0].charset))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", yyvsp[0].charset->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= yyvsp[0].charset;
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 2987 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && yyvsp[0].charset &&
               !my_charset_same(cinfo->default_table_charset,yyvsp[0].charset))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       yyvsp[0].charset->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= yyvsp[0].charset;
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 304:
#line 3003 "sql_yacc.yy"
    {
	  yyval.db_type = ha_resolve_by_name(yyvsp[0].lex_str.str,yyvsp[0].lex_str.length);
	  if (yyval.db_type == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), yyvsp[0].lex_str.str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 305:
#line 3012 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_DEFAULT; }
    break;

  case 306:
#line 3013 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_FIXED; }
    break;

  case 307:
#line 3014 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_DYNAMIC; }
    break;

  case 308:
#line 3015 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_COMPRESSED; }
    break;

  case 309:
#line 3016 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_REDUNDANT; }
    break;

  case 310:
#line 3017 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_COMPACT; }
    break;

  case 311:
#line 3020 "sql_yacc.yy"
    { yyval.ulong_num= RAID_TYPE_0; }
    break;

  case 312:
#line 3021 "sql_yacc.yy"
    { yyval.ulong_num= RAID_TYPE_0; }
    break;

  case 313:
#line 3022 "sql_yacc.yy"
    { yyval.ulong_num=yyvsp[0].ulong_num;}
    break;

  case 314:
#line 3025 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_DISABLED; }
    break;

  case 315:
#line 3026 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_TO_FIRST; }
    break;

  case 316:
#line 3027 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_TO_LAST; }
    break;

  case 317:
#line 3030 "sql_yacc.yy"
    {}
    break;

  case 319:
#line 3034 "sql_yacc.yy"
    { yyval.udf_type = UDFTYPE_FUNCTION; }
    break;

  case 320:
#line 3035 "sql_yacc.yy"
    { yyval.udf_type = UDFTYPE_AGGREGATE; }
    break;

  case 321:
#line 3038 "sql_yacc.yy"
    {yyval.num = (int) STRING_RESULT; }
    break;

  case 322:
#line 3039 "sql_yacc.yy"
    {yyval.num = (int) REAL_RESULT; }
    break;

  case 323:
#line 3040 "sql_yacc.yy"
    {yyval.num = (int) DECIMAL_RESULT; }
    break;

  case 324:
#line 3041 "sql_yacc.yy"
    {yyval.num = (int) INT_RESULT; }
    break;

  case 330:
#line 3056 "sql_yacc.yy"
    {
#ifdef ENABLE_SENNA
            Lex->senna_clear();
#endif /* ENABLE_SENNA */
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 3066 "sql_yacc.yy"
    {
            LEX *lex=Lex;
#ifdef ENABLE_SENNA
            Key *key= new Key(yyvsp[-5].key_type,yyvsp[-4].simple_string, yyvsp[-3].key_alg, 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key(yyvsp[-5].key_type, yyvsp[-4].simple_string, yyvsp[-3].key_alg, 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
            lex->col_list.empty();              /* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 3080 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= yyvsp[-4].simple_string ? yyvsp[-4].simple_string:yyvsp[-6].simple_string;
#ifdef ENABLE_SENNA
            Key *key= new Key(yyvsp[-5].key_type, key_name, yyvsp[-3].key_alg, 0, lex->col_list,
                         