/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BLOCK_SYM = 295,
     BOOLEAN_SYM = 296,
     BOOL_SYM = 297,
     BOTH = 298,
     BTREE_SYM = 299,
     BY = 300,
     BYTE_SYM = 301,
     CACHE_SYM = 302,
     CALL_SYM = 303,
     CASCADE = 304,
     CASCADED = 305,
     CAST_SYM = 306,
     CHAIN_SYM = 307,
     CHANGE = 308,
     CHANGED = 309,
     CHARSET = 310,
     CHAR_SYM = 311,
     CHECKSUM_SYM = 312,
     CHECK_SYM = 313,
     CIPHER_SYM = 314,
     CLIENT_SYM = 315,
     CLOSE_SYM = 316,
     COALESCE = 317,
     CODE_SYM = 318,
     COLLATE_SYM = 319,
     COLLATION_SYM = 320,
     COLUMNS = 321,
     COLUMN_SYM = 322,
     COMMENT_SYM = 323,
     COMMITTED_SYM = 324,
     COMMIT_SYM = 325,
     COMPACT_SYM = 326,
     COMPRESSED_SYM = 327,
     CONCAT = 328,
     CONCAT_WS = 329,
     CONCURRENT = 330,
     CONDITION_SYM = 331,
     CONNECTION_SYM = 332,
     CONSISTENT_SYM = 333,
     CONSTRAINT = 334,
     CONTAINS_SYM = 335,
     CONTEXT_SYM = 336,
     CONTINUE_SYM = 337,
     CONVERT_SYM = 338,
     CONVERT_TZ_SYM = 339,
     COUNT_SYM = 340,
     CPU_SYM = 341,
     CREATE = 342,
     CROSS = 343,
     CUBE_SYM = 344,
     CURDATE = 345,
     CURRENT_USER = 346,
     CURSOR_SYM = 347,
     CURTIME = 348,
     DATABASE = 349,
     DATABASES = 350,
     DATA_SYM = 351,
     DATETIME = 352,
     DATE_ADD_INTERVAL = 353,
     DATE_SUB_INTERVAL = 354,
     DATE_SYM = 355,
     DAY_HOUR_SYM = 356,
     DAY_MICROSECOND_SYM = 357,
     DAY_MINUTE_SYM = 358,
     DAY_SECOND_SYM = 359,
     DAY_SYM = 360,
     DEALLOCATE_SYM = 361,
     DECIMAL_NUM = 362,
     DECIMAL_SYM = 363,
     DECLARE_SYM = 364,
     DECODE_SYM = 365,
     DEFAULT = 366,
     DEFINER_SYM = 367,
     DELAYED_SYM = 368,
     DELAY_KEY_WRITE_SYM = 369,
     DELETE_SYM = 370,
     DESC = 371,
     DESCRIBE = 372,
     DES_DECRYPT_SYM = 373,
     DES_ENCRYPT_SYM = 374,
     DES_KEY_FILE = 375,
     DETERMINISTIC_SYM = 376,
     DIRECTORY_SYM = 377,
     DISABLE_SYM = 378,
     DISCARD = 379,
     DISTINCT = 380,
     DIV_SYM = 381,
     DOUBLE_SYM = 382,
     DO_SYM = 383,
     DROP = 384,
     DUAL_SYM = 385,
     DUMPFILE = 386,
     DUPLICATE_SYM = 387,
     DYNAMIC_SYM = 388,
     EACH_SYM = 389,
     ELSEIF_SYM = 390,
     ELT_FUNC = 391,
     ENABLE_SYM = 392,
     ENCLOSED = 393,
     ENCODE_SYM = 394,
     ENCRYPT = 395,
     END = 396,
     ENGINES_SYM = 397,
     ENGINE_SYM = 398,
     ENUM = 399,
     EQ = 400,
     EQUAL_SYM = 401,
     ERRORS = 402,
     ESCAPED = 403,
     ESCAPE_SYM = 404,
     EVENTS_SYM = 405,
     EXECUTE_SYM = 406,
     EXISTS = 407,
     EXIT_SYM = 408,
     EXPANSION_SYM = 409,
     EXPORT_SET = 410,
     EXTENDED_SYM = 411,
     EXTRACT_SYM = 412,
     FALSE_SYM = 413,
     FAST_SYM = 414,
     FAULTS_SYM = 415,
     FETCH_SYM = 416,
     FIELD_FUNC = 417,
     FILE_SYM = 418,
     FIRST_SYM = 419,
     FIXED_SYM = 420,
     FLOAT_NUM = 421,
     FLOAT_SYM = 422,
     FLUSH_SYM = 423,
     FORCE_SYM = 424,
     FOREIGN = 425,
     FORMAT_SYM = 426,
     FOR_SYM = 427,
     FOUND_SYM = 428,
     FRAC_SECOND_SYM = 429,
     FROM = 430,
     FROM_UNIXTIME = 431,
     FULL = 432,
     FULLTEXT_SYM = 433,
     FUNCTION_SYM = 434,
     FUNC_ARG0 = 435,
     FUNC_ARG1 = 436,
     FUNC_ARG2 = 437,
     FUNC_ARG3 = 438,
     GE = 439,
     GEOMCOLLFROMTEXT = 440,
     GEOMETRYCOLLECTION = 441,
     GEOMETRY_SYM = 442,
     GEOMFROMTEXT = 443,
     GEOMFROMWKB = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GREATEST_SYM = 449,
     GROUP = 450,
     GROUP_CONCAT_SYM = 451,
     GROUP_UNIQUE_USERS = 452,
     GT_SYM = 453,
     HANDLER_SYM = 454,
     HASH_SYM = 455,
     HAVING = 456,
     HELP_SYM = 457,
     HEX_NUM = 458,
     HIGH_PRIORITY = 459,
     HOSTS_SYM = 460,
     HOUR_MICROSECOND_SYM = 461,
     HOUR_MINUTE_SYM = 462,
     HOUR_SECOND_SYM = 463,
     HOUR_SYM = 464,
     IDENT = 465,
     IDENTIFIED_SYM = 466,
     IDENT_QUOTED = 467,
     IF = 468,
     IGNORE_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INNER_SYM = 474,
     INNOBASE_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INTERVAL_SYM = 480,
     INTO = 481,
     INT_SYM = 482,
     INVOKER_SYM = 483,
     IN_SYM = 484,
     IO_SYM = 485,
     IPC_SYM = 486,
     IS = 487,
     ISOLATION = 488,
     ISSUER_SYM = 489,
     ITERATE_SYM = 490,
     JOIN_SYM = 491,
     KEYS = 492,
     KEY_SYM = 493,
     KILL_SYM = 494,
     LABEL_SYM = 495,
     LANGUAGE_SYM = 496,
     LAST_INSERT_ID = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAST_SYM = 501,
     LEAVES = 502,
     LEAVE_SYM = 503,
     LEFT = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEFROMTEXT = 509,
     LINES = 510,
     LINESTRING = 511,
     LOAD = 512,
     LOCAL_SYM = 513,
     LOCATE = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGS_SYM = 518,
     LOG_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MAKE_SET_SYM = 527,
     MASTER_CONNECT_RETRY_SYM = 528,
     MASTER_HOST_SYM = 529,
     MASTER_LOG_FILE_SYM = 530,
     MASTER_LOG_POS_SYM = 531,
     MASTER_PASSWORD_SYM = 532,
     MASTER_PORT_SYM = 533,
     MASTER_POS_WAIT = 534,
     MASTER_SERVER_ID_SYM = 535,
     MASTER_SSL_CAPATH_SYM = 536,
     MASTER_SSL_CA_SYM = 537,
     MASTER_SSL_CERT_SYM = 538,
     MASTER_SSL_CIPHER_SYM = 539,
     MASTER_SSL_KEY_SYM = 540,
     MASTER_SSL_SYM = 541,
     MASTER_SYM = 542,
     MASTER_USER_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SYM = 548,
     MAX_UPDATES_PER_HOUR = 549,
     MAX_USER_CONNECTIONS_SYM = 550,
     MEDIUMBLOB = 551,
     MEDIUMINT = 552,
     MEDIUMTEXT = 553,
     MEDIUM_SYM = 554,
     MEMORY_SYM = 555,
     MERGE_SYM = 556,
     MICROSECOND_SYM = 557,
     MIGRATE_SYM = 558,
     MINUTE_MICROSECOND_SYM = 559,
     MINUTE_SECOND_SYM = 560,
     MINUTE_SYM = 561,
     MIN_ROWS = 562,
     MIN_SYM = 563,
     MLINEFROMTEXT = 564,
     MODE_SYM = 565,
     MODIFIES_SYM = 566,
     MODIFY_SYM = 567,
     MOD_SYM = 568,
     MONTH_SYM = 569,
     MPOINTFROMTEXT = 570,
     MPOLYFROMTEXT = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     NAMES_SYM = 576,
     NAME_SYM = 577,
     NATIONAL_SYM = 578,
     NATURAL = 579,
     NCHAR_STRING = 580,
     NCHAR_SYM = 581,
     NDBCLUSTER_SYM = 582,
     NE = 583,
     NEW_SYM = 584,
     NEXT_SYM = 585,
     NONE_SYM = 586,
     NOT2_SYM = 587,
     NOT_SYM = 588,
     NOW_SYM = 589,
     NO_SYM = 590,
     NO_WRITE_TO_BINLOG = 591,
     NULL_SYM = 592,
     NUM = 593,
     NUMERIC_SYM = 594,
     NVARCHAR_SYM = 595,
     OFFSET_SYM = 596,
     OJ_SYM = 597,
     OLD_PASSWORD = 598,
     ON = 599,
     ONE_SHOT_SYM = 600,
     ONE_SYM = 601,
     OPEN_SYM = 602,
     OPTIMIZE = 603,
     OPTION = 604,
     OPTIONALLY = 605,
     OR2_SYM = 606,
     ORDER_SYM = 607,
     OR_OR_SYM = 608,
     OR_SYM = 609,
     OUTER = 610,
     OUTFILE = 611,
     OUT_SYM = 612,
     PACK_KEYS_SYM = 613,
     PAGE_SYM = 614,
     PARTIAL = 615,
     PASSWORD = 616,
     PARAM_MARKER = 617,
     PHASE_SYM = 618,
     POINTFROMTEXT = 619,
     POINT_SYM = 620,
     POLYFROMTEXT = 621,
     POLYGON = 622,
     POSITION_SYM = 623,
     PRECISION = 624,
     PREPARE_SYM = 625,
     PREV_SYM = 626,
     PRIMARY_SYM = 627,
     PRIVILEGES = 628,
     PROCEDURE = 629,
     PROCESS = 630,
     PROCESSLIST_SYM = 631,
     PROFILE_SYM = 632,
     PROFILES_SYM = 633,
     PURGE = 634,
     QUARTER_SYM = 635,
     QUERY_SYM = 636,
     QUICK = 637,
     RAID_0_SYM = 638,
     RAID_CHUNKS = 639,
     RAID_CHUNKSIZE = 640,
     RAID_STRIPED_SYM = 641,
     RAID_TYPE = 642,
     RAND = 643,
     READS_SYM = 644,
     READ_SYM = 645,
     REAL = 646,
     RECOVER_SYM = 647,
     REDUNDANT_SYM = 648,
     REFERENCES = 649,
     REGEXP = 650,
     RELAY_LOG_FILE_SYM = 651,
     RELAY_LOG_POS_SYM = 652,
     RELAY_THREAD = 653,
     RELEASE_SYM = 654,
     RELOAD = 655,
     RENAME = 656,
     REPAIR = 657,
     REPEATABLE_SYM = 658,
     REPEAT_SYM = 659,
     REPLACE = 660,
     REPLICATION = 661,
     REQUIRE_SYM = 662,
     RESET_SYM = 663,
     RESOURCES = 664,
     RESTORE_SYM = 665,
     RESTRICT = 666,
     RESUME_SYM = 667,
     RETURNS_SYM = 668,
     RETURN_SYM = 669,
     REVOKE = 670,
     RIGHT = 671,
     ROLLBACK_SYM = 672,
     ROLLUP_SYM = 673,
     ROUND = 674,
     ROUTINE_SYM = 675,
     ROWS_SYM = 676,
     ROW_COUNT_SYM = 677,
     ROW_FORMAT_SYM = 678,
     ROW_SYM = 679,
     RTREE_SYM = 680,
     SAVEPOINT_SYM = 681,
     SECOND_MICROSECOND_SYM = 682,
     SECOND_SYM = 683,
     SECURITY_SYM = 684,
     SELECT_SYM = 685,
     SENNA_DELIMITED_SYM = 686,
     SENNA_KWIC_SYM = 687,
     SENNA_MECAB_SYM = 688,
     SENNA_NGRAM_SYM = 689,
     SENNA_NORMALIZE_SYM = 690,
     SENNA_SECTIONALIZE_SYM = 691,
     SENNA_SPLIT_ALPHA_SYM = 692,
     SENNA_SPLIT_DIGIT_SYM = 693,
     SENNA_SPLIT_SYMBOL_SYM = 694,
     SENNA_SYM = 695,
     SENSITIVE_SYM = 696,
     SEPARATOR_SYM = 697,
     SERIALIZABLE_SYM = 698,
     SERIAL_SYM = 699,
     SESSION_SYM = 700,
     SET = 701,
     SET_VAR = 702,
     SHARE_SYM = 703,
     SHIFT_LEFT = 704,
     SHIFT_RIGHT = 705,
     SHOW = 706,
     SHUTDOWN = 707,
     SIGNED_SYM = 708,
     SIMPLE_SYM = 709,
     SLAVE = 710,
     SMALLINT = 711,
     SNAPSHOT_SYM = 712,
     SOUNDS_SYM = 713,
     SOURCE_SYM = 714,
     SPATIAL_SYM = 715,
     SPECIFIC_SYM = 716,
     SQLEXCEPTION_SYM = 717,
     SQLSTATE_SYM = 718,
     SQLWARNING_SYM = 719,
     SQL_BIG_RESULT = 720,
     SQL_BUFFER_RESULT = 721,
     SQL_CACHE_SYM = 722,
     SQL_CALC_FOUND_ROWS = 723,
     SQL_NO_CACHE_SYM = 724,
     SQL_SMALL_RESULT = 725,
     SQL_SYM = 726,
     SQL_THREAD = 727,
     SSL_SYM = 728,
     STARTING = 729,
     START_SYM = 730,
     STATUS_SYM = 731,
     STD_SYM = 732,
     STDDEV_SAMP_SYM = 733,
     STOP_SYM = 734,
     STORAGE_SYM = 735,
     STRAIGHT_JOIN = 736,
     STRING_SYM = 737,
     SUBDATE_SYM = 738,
     SUBJECT_SYM = 739,
     SUBSTRING = 740,
     SUBSTRING_INDEX = 741,
     SUM_SYM = 742,
     SUPER_SYM = 743,
     SUSPEND_SYM = 744,
     SWAPS_SYM = 745,
     SWITCHES_SYM = 746,
     SYSDATE = 747,
     TABLES = 748,
     TABLESPACE = 749,
     TABLE_SYM = 750,
     TEMPORARY = 751,
     TEMPTABLE_SYM = 752,
     TERMINATED = 753,
     TEXT_STRING = 754,
     TEXT_SYM = 755,
     TIMESTAMP = 756,
     TIMESTAMP_ADD = 757,
     TIMESTAMP_DIFF = 758,
     TIME_SYM = 759,
     TINYBLOB = 760,
     TINYINT = 761,
     TINYTEXT = 762,
     TO_SYM = 763,
     TRAILING = 764,
     TRANSACTION_SYM = 765,
     TRIGGER_SYM = 766,
     TRIGGERS_SYM = 767,
     TRIM = 768,
     TRUE_SYM = 769,
     TRUNCATE_SYM = 770,
     TYPES_SYM = 771,
     TYPE_SYM = 772,
     UDF_RETURNS_SYM = 773,
     UDF_SONAME_SYM = 774,
     ULONGLONG_NUM = 775,
     UNCOMMITTED_SYM = 776,
     UNDEFINED_SYM = 777,
     UNDERSCORE_CHARSET = 778,
     UNDO_SYM = 779,
     UNICODE_SYM = 780,
     UNION_SYM = 781,
     UNIQUE_SYM = 782,
     UNIQUE_USERS = 783,
     UNIX_TIMESTAMP = 784,
     UNKNOWN_SYM = 785,
     UNLOCK_SYM = 786,
     UNSIGNED = 787,
     UNTIL_SYM = 788,
     UPDATE_SYM = 789,
     UPGRADE_SYM = 790,
     USAGE = 791,
     USER = 792,
     USE_FRM = 793,
     USE_SYM = 794,
     USING = 795,
     UTC_DATE_SYM = 796,
     UTC_TIMESTAMP_SYM = 797,
     UTC_TIME_SYM = 798,
     VAR_SAMP_SYM = 799,
     VALUES = 800,
     VALUE_SYM = 801,
     VARBINARY = 802,
     VARCHAR = 803,
     VARIABLES = 804,
     VARIANCE_SYM = 805,
     VARYING = 806,
     VIEW_SYM = 807,
     WARNINGS = 808,
     WEEK_SYM = 809,
     WHEN_SYM = 810,
     WHERE = 811,
     WHILE_SYM = 812,
     WITH = 813,
     WORK_SYM = 814,
     WRITE_SYM = 815,
     X509_SYM = 816,
     XA_SYM = 817,
     XOR = 818,
     YEARWEEK = 819,
     YEAR_MONTH_SYM = 820,
     YEAR_SYM = 821,
     ZEROFILL = 822,
     TABLE_REF_PRIORITY = 823,
     ELSE = 824,
     THEN_SYM = 825,
     CASE_SYM = 826,
     BETWEEN_SYM = 827,
     NEG = 828
   };
#endif
/* Tokens.  */
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BLOCK_SYM 295
#define BOOLEAN_SYM 296
#define BOOL_SYM 297
#define BOTH 298
#define BTREE_SYM 299
#define BY 300
#define BYTE_SYM 301
#define CACHE_SYM 302
#define CALL_SYM 303
#define CASCADE 304
#define CASCADED 305
#define CAST_SYM 306
#define CHAIN_SYM 307
#define CHANGE 308
#define CHANGED 309
#define CHARSET 310
#define CHAR_SYM 311
#define CHECKSUM_SYM 312
#define CHECK_SYM 313
#define CIPHER_SYM 314
#define CLIENT_SYM 315
#define CLOSE_SYM 316
#define COALESCE 317
#define CODE_SYM 318
#define COLLATE_SYM 319
#define COLLATION_SYM 320
#define COLUMNS 321
#define COLUMN_SYM 322
#define COMMENT_SYM 323
#define COMMITTED_SYM 324
#define COMMIT_SYM 325
#define COMPACT_SYM 326
#define COMPRESSED_SYM 327
#define CONCAT 328
#define CONCAT_WS 329
#define CONCURRENT 330
#define CONDITION_SYM 331
#define CONNECTION_SYM 332
#define CONSISTENT_SYM 333
#define CONSTRAINT 334
#define CONTAINS_SYM 335
#define CONTEXT_SYM 336
#define CONTINUE_SYM 337
#define CONVERT_SYM 338
#define CONVERT_TZ_SYM 339
#define COUNT_SYM 340
#define CPU_SYM 341
#define CREATE 342
#define CROSS 343
#define CUBE_SYM 344
#define CURDATE 345
#define CURRENT_USER 346
#define CURSOR_SYM 347
#define CURTIME 348
#define DATABASE 349
#define DATABASES 350
#define DATA_SYM 351
#define DATETIME 352
#define DATE_ADD_INTERVAL 353
#define DATE_SUB_INTERVAL 354
#define DATE_SYM 355
#define DAY_HOUR_SYM 356
#define DAY_MICROSECOND_SYM 357
#define DAY_MINUTE_SYM 358
#define DAY_SECOND_SYM 359
#define DAY_SYM 360
#define DEALLOCATE_SYM 361
#define DECIMAL_NUM 362
#define DECIMAL_SYM 363
#define DECLARE_SYM 364
#define DECODE_SYM 365
#define DEFAULT 366
#define DEFINER_SYM 367
#define DELAYED_SYM 368
#define DELAY_KEY_WRITE_SYM 369
#define DELETE_SYM 370
#define DESC 371
#define DESCRIBE 372
#define DES_DECRYPT_SYM 373
#define DES_ENCRYPT_SYM 374
#define DES_KEY_FILE 375
#define DETERMINISTIC_SYM 376
#define DIRECTORY_SYM 377
#define DISABLE_SYM 378
#define DISCARD 379
#define DISTINCT 380
#define DIV_SYM 381
#define DOUBLE_SYM 382
#define DO_SYM 383
#define DROP 384
#define DUAL_SYM 385
#define DUMPFILE 386
#define DUPLICATE_SYM 387
#define DYNAMIC_SYM 388
#define EACH_SYM 389
#define ELSEIF_SYM 390
#define ELT_FUNC 391
#define ENABLE_SYM 392
#define ENCLOSED 393
#define ENCODE_SYM 394
#define ENCRYPT 395
#define END 396
#define ENGINES_SYM 397
#define ENGINE_SYM 398
#define ENUM 399
#define EQ 400
#define EQUAL_SYM 401
#define ERRORS 402
#define ESCAPED 403
#define ESCAPE_SYM 404
#define EVENTS_SYM 405
#define EXECUTE_SYM 406
#define EXISTS 407
#define EXIT_SYM 408
#define EXPANSION_SYM 409
#define EXPORT_SET 410
#define EXTENDED_SYM 411
#define EXTRACT_SYM 412
#define FALSE_SYM 413
#define FAST_SYM 414
#define FAULTS_SYM 415
#define FETCH_SYM 416
#define FIELD_FUNC 417
#define FILE_SYM 418
#define FIRST_SYM 419
#define FIXED_SYM 420
#define FLOAT_NUM 421
#define FLOAT_SYM 422
#define FLUSH_SYM 423
#define FORCE_SYM 424
#define FOREIGN 425
#define FORMAT_SYM 426
#define FOR_SYM 427
#define FOUND_SYM 428
#define FRAC_SECOND_SYM 429
#define FROM 430
#define FROM_UNIXTIME 431
#define FULL 432
#define FULLTEXT_SYM 433
#define FUNCTION_SYM 434
#define FUNC_ARG0 435
#define FUNC_ARG1 436
#define FUNC_ARG2 437
#define FUNC_ARG3 438
#define GE 439
#define GEOMCOLLFROMTEXT 440
#define GEOMETRYCOLLECTION 441
#define GEOMETRY_SYM 442
#define GEOMFROMTEXT 443
#define GEOMFROMWKB 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GREATEST_SYM 449
#define GROUP 450
#define GROUP_CONCAT_SYM 451
#define GROUP_UNIQUE_USERS 452
#define GT_SYM 453
#define HANDLER_SYM 454
#define HASH_SYM 455
#define HAVING 456
#define HELP_SYM 457
#define HEX_NUM 458
#define HIGH_PRIORITY 459
#define HOSTS_SYM 460
#define HOUR_MICROSECOND_SYM 461
#define HOUR_MINUTE_SYM 462
#define HOUR_SECOND_SYM 463
#define HOUR_SYM 464
#define IDENT 465
#define IDENTIFIED_SYM 466
#define IDENT_QUOTED 467
#define IF 468
#define IGNORE_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INNER_SYM 474
#define INNOBASE_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INTERVAL_SYM 480
#define INTO 481
#define INT_SYM 482
#define INVOKER_SYM 483
#define IN_SYM 484
#define IO_SYM 485
#define IPC_SYM 486
#define IS 487
#define ISOLATION 488
#define ISSUER_SYM 489
#define ITERATE_SYM 490
#define JOIN_SYM 491
#define KEYS 492
#define KEY_SYM 493
#define KILL_SYM 494
#define LABEL_SYM 495
#define LANGUAGE_SYM 496
#define LAST_INSERT_ID 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAST_SYM 501
#define LEAVES 502
#define LEAVE_SYM 503
#define LEFT 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEFROMTEXT 509
#define LINES 510
#define LINESTRING 511
#define LOAD 512
#define LOCAL_SYM 513
#define LOCATE 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGS_SYM 518
#define LOG_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MAKE_SET_SYM 527
#define MASTER_CONNECT_RETRY_SYM 528
#define MASTER_HOST_SYM 529
#define MASTER_LOG_FILE_SYM 530
#define MASTER_LOG_POS_SYM 531
#define MASTER_PASSWORD_SYM 532
#define MASTER_PORT_SYM 533
#define MASTER_POS_WAIT 534
#define MASTER_SERVER_ID_SYM 535
#define MASTER_SSL_CAPATH_SYM 536
#define MASTER_SSL_CA_SYM 537
#define MASTER_SSL_CERT_SYM 538
#define MASTER_SSL_CIPHER_SYM 539
#define MASTER_SSL_KEY_SYM 540
#define MASTER_SSL_SYM 541
#define MASTER_SYM 542
#define MASTER_USER_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SYM 548
#define MAX_UPDATES_PER_HOUR 549
#define MAX_USER_CONNECTIONS_SYM 550
#define MEDIUMBLOB 551
#define MEDIUMINT 552
#define MEDIUMTEXT 553
#define MEDIUM_SYM 554
#define MEMORY_SYM 555
#define MERGE_SYM 556
#define MICROSECOND_SYM 557
#define MIGRATE_SYM 558
#define MINUTE_MICROSECOND_SYM 559
#define MINUTE_SECOND_SYM 560
#define MINUTE_SYM 561
#define MIN_ROWS 562
#define MIN_SYM 563
#define MLINEFROMTEXT 564
#define MODE_SYM 565
#define MODIFIES_SYM 566
#define MODIFY_SYM 567
#define MOD_SYM 568
#define MONTH_SYM 569
#define MPOINTFROMTEXT 570
#define MPOLYFROMTEXT 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define NAMES_SYM 576
#define NAME_SYM 577
#define NATIONAL_SYM 578
#define NATURAL 579
#define NCHAR_STRING 580
#define NCHAR_SYM 581
#define NDBCLUSTER_SYM 582
#define NE 583
#define NEW_SYM 584
#define NEXT_SYM 585
#define NONE_SYM 586
#define NOT2_SYM 587
#define NOT_SYM 588
#define NOW_SYM 589
#define NO_SYM 590
#define NO_WRITE_TO_BINLOG 591
#define NULL_SYM 592
#define NUM 593
#define NUMERIC_SYM 594
#define NVARCHAR_SYM 595
#define OFFSET_SYM 596
#define OJ_SYM 597
#define OLD_PASSWORD 598
#define ON 599
#define ONE_SHOT_SYM 600
#define ONE_SYM 601
#define OPEN_SYM 602
#define OPTIMIZE 603
#define OPTION 604
#define OPTIONALLY 605
#define OR2_SYM 606
#define ORDER_SYM 607
#define OR_OR_SYM 608
#define OR_SYM 609
#define OUTER 610
#define OUTFILE 611
#define OUT_SYM 612
#define PACK_KEYS_SYM 613
#define PAGE_SYM 614
#define PARTIAL 615
#define PASSWORD 616
#define PARAM_MARKER 617
#define PHASE_SYM 618
#define POINTFROMTEXT 619
#define POINT_SYM 620
#define POLYFROMTEXT 621
#define POLYGON 622
#define POSITION_SYM 623
#define PRECISION 624
#define PREPARE_SYM 625
#define PREV_SYM 626
#define PRIMARY_SYM 627
#define PRIVILEGES 628
#define PROCEDURE 629
#define PROCESS 630
#define PROCESSLIST_SYM 631
#define PROFILE_SYM 632
#define PROFILES_SYM 633
#define PURGE 634
#define QUARTER_SYM 635
#define QUERY_SYM 636
#define QUICK 637
#define RAID_0_SYM 638
#define RAID_CHUNKS 639
#define RAID_CHUNKSIZE 640
#define RAID_STRIPED_SYM 641
#define RAID_TYPE 642
#define RAND 643
#define READS_SYM 644
#define READ_SYM 645
#define REAL 646
#define RECOVER_SYM 647
#define REDUNDANT_SYM 648
#define REFERENCES 649
#define REGEXP 650
#define RELAY_LOG_FILE_SYM 651
#define RELAY_LOG_POS_SYM 652
#define RELAY_THREAD 653
#define RELEASE_SYM 654
#define RELOAD 655
#define RENAME 656
#define REPAIR 657
#define REPEATABLE_SYM 658
#define REPEAT_SYM 659
#define REPLACE 660
#define REPLICATION 661
#define REQUIRE_SYM 662
#define RESET_SYM 663
#define RESOURCES 664
#define RESTORE_SYM 665
#define RESTRICT 666
#define RESUME_SYM 667
#define RETURNS_SYM 668
#define RETURN_SYM 669
#define REVOKE 670
#define RIGHT 671
#define ROLLBACK_SYM 672
#define ROLLUP_SYM 673
#define ROUND 674
#define ROUTINE_SYM 675
#define ROWS_SYM 676
#define ROW_COUNT_SYM 677
#define ROW_FORMAT_SYM 678
#define ROW_SYM 679
#define RTREE_SYM 680
#define SAVEPOINT_SYM 681
#define SECOND_MICROSECOND_SYM 682
#define SECOND_SYM 683
#define SECURITY_SYM 684
#define SELECT_SYM 685
#define SENNA_DELIMITED_SYM 686
#define SENNA_KWIC_SYM 687
#define SENNA_MECAB_SYM 688
#define SENNA_NGRAM_SYM 689
#define SENNA_NORMALIZE_SYM 690
#define SENNA_SECTIONALIZE_SYM 691
#define SENNA_SPLIT_ALPHA_SYM 692
#define SENNA_SPLIT_DIGIT_SYM 693
#define SENNA_SPLIT_SYMBOL_SYM 694
#define SENNA_SYM 695
#define SENSITIVE_SYM 696
#define SEPARATOR_SYM 697
#define SERIALIZABLE_SYM 698
#define SERIAL_SYM 699
#define SESSION_SYM 700
#define SET 701
#define SET_VAR 702
#define SHARE_SYM 703
#define SHIFT_LEFT 704
#define SHIFT_RIGHT 705
#define SHOW 706
#define SHUTDOWN 707
#define SIGNED_SYM 708
#define SIMPLE_SYM 709
#define SLAVE 710
#define SMALLINT 711
#define SNAPSHOT_SYM 712
#define SOUNDS_SYM 713
#define SOURCE_SYM 714
#define SPATIAL_SYM 715
#define SPECIFIC_SYM 716
#define SQLEXCEPTION_SYM 717
#define SQLSTATE_SYM 718
#define SQLWARNING_SYM 719
#define SQL_BIG_RESULT 720
#define SQL_BUFFER_RESULT 721
#define SQL_CACHE_SYM 722
#define SQL_CALC_FOUND_ROWS 723
#define SQL_NO_CACHE_SYM 724
#define SQL_SMALL_RESULT 725
#define SQL_SYM 726
#define SQL_THREAD 727
#define SSL_SYM 728
#define STARTING 729
#define START_SYM 730
#define STATUS_SYM 731
#define STD_SYM 732
#define STDDEV_SAMP_SYM 733
#define STOP_SYM 734
#define STORAGE_SYM 735
#define STRAIGHT_JOIN 736
#define STRING_SYM 737
#define SUBDATE_SYM 738
#define SUBJECT_SYM 739
#define SUBSTRING 740
#define SUBSTRING_INDEX 741
#define SUM_SYM 742
#define SUPER_SYM 743
#define SUSPEND_SYM 744
#define SWAPS_SYM 745
#define SWITCHES_SYM 746
#define SYSDATE 747
#define TABLES 748
#define TABLESPACE 749
#define TABLE_SYM 750
#define TEMPORARY 751
#define TEMPTABLE_SYM 752
#define TERMINATED 753
#define TEXT_STRING 754
#define TEXT_SYM 755
#define TIMESTAMP 756
#define TIMESTAMP_ADD 757
#define TIMESTAMP_DIFF 758
#define TIME_SYM 759
#define TINYBLOB 760
#define TINYINT 761
#define TINYTEXT 762
#define TO_SYM 763
#define TRAILING 764
#define TRANSACTION_SYM 765
#define TRIGGER_SYM 766
#define TRIGGERS_SYM 767
#define TRIM 768
#define TRUE_SYM 769
#define TRUNCATE_SYM 770
#define TYPES_SYM 771
#define TYPE_SYM 772
#define UDF_RETURNS_SYM 773
#define UDF_SONAME_SYM 774
#define ULONGLONG_NUM 775
#define UNCOMMITTED_SYM 776
#define UNDEFINED_SYM 777
#define UNDERSCORE_CHARSET 778
#define UNDO_SYM 779
#define UNICODE_SYM 780
#define UNION_SYM 781
#define UNIQUE_SYM 782
#define UNIQUE_USERS 783
#define UNIX_TIMESTAMP 784
#define UNKNOWN_SYM 785
#define UNLOCK_SYM 786
#define UNSIGNED 787
#define UNTIL_SYM 788
#define UPDATE_SYM 789
#define UPGRADE_SYM 790
#define USAGE 791
#define USER 792
#define USE_FRM 793
#define USE_SYM 794
#define USING 795
#define UTC_DATE_SYM 796
#define UTC_TIMESTAMP_SYM 797
#define UTC_TIME_SYM 798
#define VAR_SAMP_SYM 799
#define VALUES 800
#define VALUE_SYM 801
#define VARBINARY 802
#define VARCHAR 803
#define VARIABLES 804
#define VARIANCE_SYM 805
#define VARYING 806
#define VIEW_SYM 807
#define WARNINGS 808
#define WEEK_SYM 809
#define WHEN_SYM 810
#define WHERE 811
#define WHILE_SYM 812
#define WITH 813
#define WORK_SYM 814
#define WRITE_SYM 815
#define X509_SYM 816
#define XA_SYM 817
#define XOR 818
#define YEARWEEK 819
#define YEAR_MONTH_SYM 820
#define YEAR_SYM 821
#define ZEROFILL 822
#define TABLE_REF_PRIORITY 823
#define ELSE 824
#define THEN_SYM 825
#define CASE_SYM 826
#define BETWEEN_SYM 827
#define NEG 828




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 415 "sql_yacc.yy"
{
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
}
/* Line 193 of yacc.c.  */
#line 1688 "sql_yacc.cc"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 455 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 216 of yacc.c.  */
#line 1704 "sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  482
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   44015

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  593
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  670
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2074
/* YYNRULES -- Number of states.  */
#define YYNSTATES  3733

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   828

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   586,     2,     2,     2,   579,   574,     2,
     583,   584,   577,   576,   585,   575,   590,   578,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   592,   591,
       2,     2,     2,     2,   589,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   580,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   587,   573,   588,   581,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   582
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   275,   276,   277,   278,   279,   280,   293,   294,   297,
     298,   301,   304,   307,   310,   313,   317,   321,   323,   325,
     327,   330,   334,   338,   339,   344,   345,   349,   350,   352,
     356,   358,   359,   361,   365,   367,   368,   372,   373,   375,
     379,   381,   386,   387,   389,   391,   393,   394,   398,   401,
     405,   406,   410,   411,   417,   423,   424,   432,   438,   439,
     442,   444,   446,   448,   452,   454,   456,   460,   461,   463,
     465,   467,   469,   472,   474,   476,   480,   481,   484,   485,
     488,   489,   493,   494,   500,   502,   504,   505,   508,   511,
     514,   517,   518,   525,   528,   529,   532,   534,   536,   540,
     541,   542,   543,   551,   552,   555,   558,   560,   562,   563,
     564,   573,   574,   581,   583,   586,   588,   591,   592,   593,
     600,   601,   602,   609,   610,   613,   614,   620,   621,   623,
     624,   630,   635,   636,   637,   646,   647,   655,   657,   659,
     661,   663,   665,   668,   671,   674,   679,   684,   685,   690,
     691,   692,   698,   699,   707,   708,   709,   716,   717,   719,
     720,   722,   724,   727,   729,   731,   732,   734,   736,   739,
     741,   742,   746,   747,   749,   751,   754,   756,   759,   763,
     767,   771,   775,   779,   783,   787,   791,   795,   799,   803,
     807,   811,   815,   819,   823,   827,   833,   835,   837,   841,
     846,   851,   855,   860,   865,   867,   869,   871,   873,   875,
     877,   879,   881,   883,   885,   887,   889,   891,   893,   896,
     897,   899,   901,   903,   905,   907,   909,   913,   915,   917,
     920,   923,   930,   938,   947,   950,   953,   954,   956,   959,
     960,   962,   965,   966,   971,   975,   979,   983,   985,   990,
     992,   994,  1000,  1003,  1009,  1012,  1017,  1019,  1025,  1031,
    1036,  1040,  1042,  1044,  1047,  1049,  1051,  1054,  1056,  1058,
    1060,  1063,  1067,  1070,  1074,  1077,  1080,  1084,  1088,  1092,
    1093,  1100,  1101,  1108,  1111,  1113,  1115,  1117,  1119,  1121,
    1123,  1125,  1127,  1129,  1131,  1133,  1136,  1139,  1141,  1144,
    1146,  1149,  1153,  1156,  1158,  1160,  1162,  1164,  1166,  1168,
    1170,  1173,  1174,  1178,  1180,  1186,  1187,  1189,  1192,  1194,
    1196,  1198,  1200,  1201,  1205,  1206,  1208,  1209,  1211,  1214,
    1216,  1218,  1221,  1224,  1229,  1231,  1235,  1238,  1240,  1243,
    1246,  1249,  1252,  1254,  1257,  1259,  1261,  1263,  1265,  1267,
    1268,  1271,  1273,  1275,  1277,  1279,  1281,  1282,  1285,  1287,
    1289,  1290,  1292,  1293,  1296,  1298,  1301,  1305,  1308,  1309,
    1311,  1312,  1314,  1316,  1319,  1320,  1322,  1323,  1328,  1330,
    1335,  1339,  1341,  1342,  1344,  1347,  1349,  1353,  1357,  1360,
    1363,  1366,  1368,  1370,  1373,  1376,  1379,  1381,  1384,  1387,
    1390,  1393,  1395,  1397,  1398,  1400,  1402,  1404,  1406,  1407,
    1409,  1411,  1413,  1414,  1417,  1420,  1422,  1424,  1426,  1428,
    1430,  1434,  1436,  1439,  1441,  1444,  1446,  1448,  1450,  1452,
    1454,  1456,  1458,  1460,  1465,  1468,  1470,  1475,  1476,  1478,
    1479,  1482,  1484,  1488,  1489,  1496,  1497,  1503,  1504,  1510,
    1511,  1517,  1518,  1530,  1531,  1533,  1534,  1537,  1540,  1542,
    1546,  1549,  1553,  1556,  1561,  1562,  1569,  1570,  1571,  1580,
    1585,  1590,  1594,  1598,  1601,  1604,  1611,  1617,  1621,  1627,
    1629,  1631,  1633,  1634,  1636,  1637,  1639,  1640,  1642,  1644,
    1645,  1648,  1650,  1651,  1653,  1655,  1657,  1658,  1664,  1668,
    1669,  1675,  1679,  1683,  1684,  1688,  1689,  1692,  1694,  1698,
    1699,  1701,  1703,  1704,  1707,  1709,  1713,  1714,  1721,  1722,
    1729,  1730,  1736,  1737,  1739,  1741,  1742,  1749,  1750,  1752,
    1754,  1757,  1759,  1761,  1763,  1764,  1771,  1772,  1778,  1779,
    1781,  1783,  1786,  1788,  1790,  1792,  1794,  1796,  1799,  1800,
    1807,  1808,  1810,  1812,  1813,  1818,  1823,  1827,  1833,  1835,
    1839,  1843,  1849,  1851,  1855,  1858,  1860,  1862,  1863,  1870,
    1872,  1876,  1880,  1881,  1884,  1885,  1890,  1891,  1894,  1896,
    1899,  1904,  1907,  1911,  1912,  1916,  1917,  1918,  1925,  1928,
    1930,  1932,  1935,  1938,  1947,  1952,  1953,  1955,  1958,  1960,
    1962,  1964,  1966,  1968,  1970,  1972,  1974,  1976,  1978,  1980,
    1981,  1984,  1989,  1993,  1995,  1997,  2002,  2003,  2004,  2006,
    2008,  2009,  2012,  2015,  2017,  2019,  2020,  2023,  2027,  2031,
    2035,  2038,  2042,  2047,  2051,  2056,  2060,  2065,  2067,  2071,
    2076,  2080,  2084,  2091,  2093,  2099,  2106,  2112,  2120,  2127,
    2136,  2142,  2149,  2154,  2159,  2165,  2169,  2174,  2176,  2180,
    2184,  2188,  2192,  2196,  2200,  2205,  2210,  2214,  2218,  2222,
    2226,  2230,  2234,  2236,  2238,  2240,  2242,  2244,  2246,  2248,
    2250,  2252,  2254,  2256,  2258,  2260,  2262,  2264,  2266,  2268,
    2271,  2273,  2277,  2279,  2281,  2283,  2285,  2289,  2292,  2295,
    2298,  2301,  2305,  2309,  2315,  2322,  2327,  2332,  2340,  2345,
    2348,  2355,  2361,  2368,  2375,  2380,  2385,  2389,  2394,  2401,
    2410,  2417,  2426,  2433,  2438,  2445,  2450,  2457,  2462,  2467,
    2472,  2477,  2484,  2493,  2496,  2499,  2504,  2507,  2515,  2523,
    2527,  2532,  2537,  2544,  2551,  2556,  2563,  2570,  2577,  2582,
    2589,  2594,  2601,  2610,  2621,  2634,  2641,  2646,  2653,  2660,
    2662,  2669,  2674,  2683,  2694,  2699,  2701,  2705,  2710,  2717,
    2724,  2733,  2740,  2747,  2752,  2759,  2766,  2775,  2780,  2785,
    2792,  2797,  2800,  2805,  2810,  2815,  2822,  2827,  2832,  2836,
    2845,  2852,  2857,  2864,  2868,  2873,  2880,  2889,  2894,  2903,
    2910,  2919,  2926,  2935,  2938,  2943,  2948,  2953,  2960,  2969,
    2978,  2983,  2991,  2999,  3007,  3014,  3021,  3028,  3035,  3042,
    3049,  3050,  3056,  3067,  3071,  3076,  3080,  3083,  3086,  3089,
    3094,  3101,  3106,  3111,  3118,  3125,  3132,  3139,  3144,  3151,
    3156,  3163,  3168,  3173,  3178,  3183,  3190,  3195,  3202,  3207,
    3214,  3219,  3224,  3231,  3236,  3243,  3248,  3255,  3260,  3265,
    3272,  3277,  3284,  3285,  3289,  3293,  3294,  3296,  3297,  3300,
    3302,  3306,  3311,  3316,  3322,  3327,  3332,  3337,  3343,  3348,
    3349,  3350,  3358,  3369,  3374,  3380,  3385,  3391,  3396,  3401,
    3406,  3411,  3416,  3422,  3423,  3432,  3433,  3437,  3441,  3443,
    3448,  3449,  3451,  3452,  3455,  3456,  3458,  3459,  3463,  3466,
    3470,  3473,  3475,  3478,  3480,  3483,  3485,  3487,  3489,  3492,
    3493,  3495,  3496,  3499,  3501,  3505,  3507,  3511,  3512,  3515,
    3517,  3521,  3522,  3524,  3525,  3528,  3533,  3539,  3541,  3543,
    3545,  3547,  3551,  3555,  3559,  3560,  3567,  3568,  3575,  3576,
    3585,  3590,  3591,  3600,  3601,  3612,  3619,  3620,  3629,  3630,
    3641,  3648,  3650,  3653,  3656,  3657,  3662,  3663,  3675,  3679,
    3686,  3687,  3691,  3692,  3693,  3699,  3700,  3702,  3703,  3705,
    3706,  3709,  3710,  3713,  3716,  3719,  3720,  3727,  3728,  3730,
    3734,  3736,  3738,  3740,  3744,  3746,  3748,  3750,  3752,  3754,
    3756,  3758,  3760,  3762,  3764,  3766,  3768,  3770,  3772,  3774,
    3776,  3778,  3780,  3782,  3784,  3786,  3788,  3790,  3792,  3794,
    3796,  3797,  3799,  3801,  3802,  3805,  3806,  3808,  3809,  3810,
    3814,  3815,  3816,  3820,  3823,  3824,  3825,  3830,  3835,  3838,
    3839,  3842,  3845,  3849,  3853,  3855,  3858,  3859,  3861,  3862,
    3867,  3872,  3875,  3876,  3878,  3880,  3881,  3883,  3884,  3886,
    3889,  3891,  3895,  3899,  3901,  3903,  3905,  3907,  3908,  3911,
    3913,  3915,  3917,  3919,  3921,  3923,  3925,  3927,  3929,  3931,
    3933,  3934,  3935,  3942,  3943,  3945,  3949,  3951,  3954,  3955,
    3958,  3962,  3964,  3967,  3969,  3970,  3974,  3975,  3981,  3984,
    3986,  3987,  3991,  3998,  3999,  4006,  4011,  4016,  4021,  4026,
    4032,  4037,  4039,  4043,  4045,  4047,  4051,  4053,  4054,  4057,
    4058,  4060,  4061,  4062,  4071,  4072,  4073,  4080,  4081,  4083,
    4085,  4087,  4089,  4091,  4094,  4096,  4098,  4100,  4104,  4109,
    4110,  4114,  4118,  4120,  4123,  4126,  4127,  4131,  4132,  4138,
    4142,  4144,  4148,  4150,  4154,  4156,  4158,  4159,  4161,  4162,
    4167,  4168,  4170,  4174,  4176,  4178,  4180,  4181,  4182,  4189,
    4190,  4191,  4203,  4207,  4209,  4213,  4217,  4219,  4223,  4224,
    4226,  4227,  4232,  4233,  4240,  4241,  4247,  4248,  4255,  4257,
    4261,  4265,  4271,  4272,  4275,  4276,  4279,  4281,  4283,  4285,
    4289,  4290,  4292,  4293,  4295,  4297,  4301,  4303,  4305,  4308,
    4311,  4314,  4316,  4318,  4320,  4322,  4323,  4327,  4328,  4332,
    4335,  4340,  4345,  4350,  4355,  4356,  4361,  4368,  4385,  4388,
    4391,  4392,  4399,  4405,  4408,  4411,  4414,  4416,  4422,  4428,
    4431,  4434,  4436,  4441,  4445,  4448,  4451,  4454,  4458,  4461,
    4464,  4467,  4469,  4471,  4475,  4480,  4484,  4488,  4491,  4494,
    4498,  4502,  4506,  4510,  4514,  4518,  4523,  4525,  4527,  4529,
    4531,  4532,  4534,  4535,  4538,  4539,  4541,  4543,  4545,  4546,
    4549,  4550,  4553,  4554,  4557,  4560,  4561,  4566,  4567,  4572,
    4574,  4576,  4577,  4579,  4580,  4582,  4584,  4585,  4590,  4594,
    4596,  4597,  4601,  4606,  4609,  4611,  4613,  4615,  4617,  4619,
    4621,  4623,  4625,  4626,  4628,  4629,  4633,  4637,  4639,  4641,
    4643,  4646,  4647,  4651,  4655,  4658,  4661,  4662,  4667,  4668,
    4670,  4672,  4675,  4676,  4681,  4687,  4688,  4689,  4690,  4691,
    4710,  4713,  4714,  4716,  4717,  4719,  4721,  4722,  4724,  4726,
    4727,  4730,  4733,  4735,  4739,  4744,  4748,  4752,  4753,  4756,
    4759,  4761,  4765,  4769,  4770,  4774,  4775,  4779,  4782,  4786,
    4788,  4790,  4793,  4794,  4797,  4799,  4801,  4804,  4807,  4809,
    4811,  4813,  4815,  4817,  4820,  4823,  4825,  4827,  4829,  4831,
    4833,  4835,  4837,  4840,  4843,  4846,  4849,  4852,  4854,  4856,
    4858,  4860,  4862,  4864,  4866,  4870,  4876,  4878,  4880,  4882,
    4884,  4886,  4890,  4895,  4901,  4903,  4909,  4913,  4916,  4918,
    4922,  4925,  4927,  4929,  4931,  4933,  4935,  4937,  4939,  4941,
    4943,  4945,  4947,  4949,  4951,  4953,  4957,  4960,  4962,  4964,
    4966,  4968,  4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,
    4986,  4988,  4990,  4992,  4994,  4996,  4998,  5000,  5002,  5004,
    5006,  5008,  5010,  5012,  5014,  5016,  5018,  5020,  5022,  5024,
    5026,  5028,  5030,  5032,  5034,  5036,  5038,  5040,  5042,  5044,
    5046,  5048,  5050,  5052,  5054,  5056,  5058,  5060,  5062,  5064,
    5066,  5068,  5070,  5072,  5074,  5076,  5078,  5080,  5082,  5084,
    5086,  5088,  5090,  5092,  5094,  5096,  5098,  5100,  5102,  5104,
    5106,  5108,  5110,  5112,  5114,  5116,  5118,  5120,  5122,  5124,
    5126,  5128,  5130,  5132,  5134,  5136,  5138,  5140,  5142,  5144,
    5146,  5148,  5150,  5152,  5154,  5156,  5158,  5160,  5162,  5164,
    5166,  5168,  5170,  5172,  5174,  5176,  5178,  5180,  5182,  5184,
    5186,  5188,  5190,  5192,  5194,  5196,  5198,  5200,  5202,  5204,
    5206,  5208,  5210,  5212,  5214,  5216,  5218,  5220,  5222,  5224,
    5226,  5228,  5230,  5232,  5234,  5236,  5238,  5240,  5242,  5244,
    5246,  5248,  5250,  5252,  5254,  5256,  5258,  5260,  5262,  5264,
    5266,  5268,  5270,  5272,  5274,  5276,  5278,  5280,  5282,  5284,
    5286,  5288,  5290,  5292,  5294,  5296,  5298,  5300,  5302,  5304,
    5306,  5308,  5310,  5312,  5314,  5316,  5318,  5320,  5322,  5324,
    5326,  5328,  5330,  5332,  5334,  5336,  5338,  5340,  5342,  5344,
    5346,  5348,  5350,  5352,  5354,  5356,  5358,  5360,  5362,  5364,
    5366,  5368,  5370,  5372,  5374,  5376,  5378,  5380,  5382,  5384,
    5386,  5388,  5390,  5392,  5394,  5396,  5398,  5400,  5402,  5404,
    5406,  5408,  5410,  5412,  5414,  5416,  5418,  5420,  5422,  5424,
    5426,  5428,  5430,  5432,  5434,  5436,  5438,  5440,  5442,  5444,
    5446,  5448,  5450,  5452,  5454,  5456,  5458,  5460,  5462,  5464,
    5466,  5468,  5470,  5472,  5474,  5476,  5478,  5480,  5482,  5484,
    5486,  5488,  5490,  5492,  5494,  5496,  5498,  5500,  5502,  5504,
    5506,  5507,  5512,  5513,  5515,  5517,  5521,  5522,  5525,  5527,
    5529,  5531,  5533,  5534,  5536,  5537,  5539,  5541,  5543,  5544,
    5547,  5550,  5553,  5555,  5558,  5563,  5569,  5574,  5581,  5584,
    5588,  5592,  5596,  5602,  5604,  5608,  5612,  5615,  5618,  5621,
    5623,  5625,  5630,  5635,  5637,  5639,  5641,  5643,  5645,  5646,
    5651,  5653,  5655,  5657,  5661,  5665,  5667,  5669,  5672,  5675,
    5676,  5680,  5685,  5689,  5690,  5698,  5700,  5703,  5705,  5707,
    5709,  5711,  5713,  5715,  5716,  5722,  5724,  5726,  5728,  5730,
    5732,  5736,  5743,  5750,  5757,  5765,  5769,  5778,  5787,  5796,
    5797,  5799,  5801,  5804,  5805,  5807,  5809,  5813,  5814,  5818,
    5819,  5823,  5824,  5828,  5829,  5833,  5835,  5837,  5839,  5841,
    5843,  5845,  5847,  5849,  5851,  5853,  5855,  5858,  5861,  5863,
    5867,  5870,  5873,  5876,  5879,  5882,  5885,  5888,  5891,  5892,
    5894,  5898,  5900,  5903,  5906,  5909,  5911,  5915,  5919,  5921,
    5923,  5927,  5929,  5933,  5938,  5944,  5946,  5947,  5951,  5955,
    5957,  5959,  5960,  5963,  5966,  5969,  5972,  5973,  5976,  5979,
    5981,  5984,  5987,  5990,  5993,  5996,  5997,  6001,  6002,  6004,
    6005,  6009,  6012,  6013,  6015,  6018,  6019,  6021,  6026,  6031,
    6037,  6040,  6044,  6045,  6047,  6048,  6053,  6054,  6056,  6058,
    6059,  6062,  6065,  6067,  6068,  6070,  6072,  6077,  6078,  6086,
    6088,  6089,  6090,  6093,  6097,  6099,  6101,  6103,  6104,  6108,
    6110,  6113,  6115,  6118,  6122,  6126,  6130,  6131,  6133,  6134,
    6138,  6142,  6143,  6152,  6153,  6157,  6159,  6163,  6164,  6167,
    6171,  6177,  6178,  6182,  6187,  6192,  6193,  6208,  6209,  6216,
    6217,  6218,  6219,  6220,  6233,  6238,  6243,  6247,  6252,  6256,
    6259,  6261,  6265,  6271,  6273,  6275,  6276,  6278,  6280,  6281,
    6284,  6285,  6286,  6290,  6291
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     594,     0,    -1,     3,    -1,   595,     3,    -1,   596,    -1,
    1208,    -1,   796,    -1,   837,    -1,   827,    -1,   631,    -1,
     608,    -1,   839,    -1,   829,    -1,  1214,    -1,   613,    -1,
     597,    -1,  1048,    -1,  1079,    -1,  1002,    -1,  1004,    -1,
     601,    -1,  1085,    -1,  1183,    -1,  1174,    -1,   606,    -1,
    1012,    -1,  1099,    -1,  1103,    -1,  1166,    -1,   844,    -1,
     852,    -1,   856,    -1,   599,    -1,  1095,    -1,  1217,    -1,
     847,    -1,   832,    -1,  1015,    -1,  1091,    -1,   825,    -1,
    1181,    -1,  1215,    -1,  1216,    -1,   864,    -1,  1149,    -1,
    1065,    -1,   814,    -1,   817,    -1,  1059,    -1,  1172,    -1,
    1040,    -1,  1102,    -1,  1255,    -1,   598,   370,  1143,    -1,
     106,    -1,   129,    -1,   370,  1143,   175,   600,    -1,  1140,
      -1,   589,  1145,    -1,    -1,   151,  1143,   602,   603,    -1,
      -1,   540,   604,    -1,   604,   585,   605,    -1,   605,    -1,
     589,  1145,    -1,    -1,   202,   607,  1145,    -1,    -1,    53,
     287,   508,   609,   610,    -1,   611,    -1,   610,   585,   611,
      -1,   274,   145,  1140,    -1,   288,   145,  1140,    -1,   277,
     145,  1140,    -1,   278,   145,   987,    -1,   273,   145,   987,
      -1,   286,   145,   987,    -1,   282,   145,  1140,    -1,   281,
     145,  1140,    -1,   283,   145,  1140,    -1,   284,   145,  1140,
      -1,   285,   145,  1140,    -1,   612,    -1,   275,   145,  1140,
      -1,   276,   145,   988,    -1,   396,   145,  1140,    -1,   397,
     145,   987,    -1,    -1,    87,   711,   495,   714,  1137,   614,
     698,    -1,    -1,    87,   786,   217,  1143,   787,   344,  1137,
     615,   583,   791,   584,    -1,    -1,    87,    94,   714,  1143,
     616,   708,    -1,    -1,    87,   617,  1231,    -1,    87,   537,
     618,  1199,    -1,    -1,  1143,   590,  1143,    -1,  1143,    -1,
     413,   727,   519,  1140,    -1,    -1,    -1,    -1,    -1,    -1,
     583,   621,   636,   584,   622,   413,   623,   738,   624,   627,
     625,   660,    -1,    -1,   626,   628,    -1,    -1,   627,   629,
      -1,    68,  1140,    -1,   241,   471,    -1,   335,   471,    -1,
      80,   471,    -1,   389,   471,    96,    -1,   311,   471,    96,
      -1,   630,    -1,   628,    -1,   121,    -1,   891,   121,    -1,
     471,   429,   112,    -1,   471,   429,   228,    -1,    -1,    48,
     619,   632,   633,    -1,    -1,   583,   634,   584,    -1,    -1,
     635,    -1,   635,   585,   885,    -1,   885,    -1,    -1,   637,
      -1,   637,   585,   639,    -1,   639,    -1,    -1,  1143,   638,
     738,    -1,    -1,   641,    -1,   641,   585,   642,    -1,   642,
      -1,   643,   638,  1143,   738,    -1,    -1,   229,    -1,   357,
      -1,   221,    -1,    -1,   644,   660,   591,    -1,   660,   591,
      -1,   645,   660,   591,    -1,    -1,   646,   647,   591,    -1,
      -1,   109,   658,   648,   738,   659,    -1,   109,  1143,    76,
     172,   655,    -1,    -1,   109,   652,   199,   172,   649,   653,
     660,    -1,   109,  1143,    92,   172,   650,    -1,    -1,   651,
     596,    -1,   153,    -1,    82,    -1,   654,    -1,   653,   585,
     654,    -1,   657,    -1,   987,    -1,   463,   656,  1141,    -1,
      -1,   546,    -1,   655,    -1,  1143,    -1,   464,    -1,   891,
     173,    -1,   462,    -1,  1143,    -1,   658,   585,  1143,    -1,
      -1,   111,   885,    -1,    -1,   661,   596,    -1,    -1,   414,
     662,   885,    -1,    -1,   213,   663,   668,   141,   213,    -1,
     673,    -1,   688,    -1,    -1,   664,   691,    -1,   248,  1144,
      -1,   235,  1144,    -1,   347,  1143,    -1,    -1,   161,   666,
    1143,   226,   665,   667,    -1,    61,  1143,    -1,    -1,   330,
     175,    -1,   175,    -1,  1143,    -1,   667,   585,  1143,    -1,
      -1,    -1,    -1,   669,   885,   570,   670,   645,   671,   672,
      -1,    -1,   135,   668,    -1,   569,   645,    -1,   674,    -1,
     677,    -1,    -1,    -1,   571,   675,   885,   676,   679,   687,
     141,   571,    -1,    -1,   571,   678,   680,   687,   141,   571,
      -1,   681,    -1,   679,   681,    -1,   684,    -1,   680,   684,
      -1,    -1,    -1,   555,   682,   885,   683,   570,   645,    -1,
      -1,    -1,   555,   685,   885,   686,   570,   645,    -1,    -1,
     569,   645,    -1,    -1,  1144,   592,   689,   691,   690,    -1,
      -1,  1144,    -1,    -1,    28,   692,   646,   644,   141,    -1,
     269,   645,   141,   269,    -1,    -1,    -1,   557,   693,   885,
     128,   694,   645,   141,   557,    -1,    -1,   404,   645,   533,
     695,   885,   141,   404,    -1,    27,    -1,     8,    -1,   223,
      -1,   534,    -1,   115,    -1,   583,   699,    -1,   715,   701,
      -1,   252,  1137,    -1,   583,   252,  1137,   584,    -1,   728,
     584,   715,   701,    -1,    -1,   704,   584,   700,  1221,    -1,
      -1,    -1,  1112,   707,   704,   702,  1218,    -1,    -1,  1112,
     707,   583,   704,   584,   703,  1221,    -1,    -1,    -1,   430,
     705,   874,   878,   706,   725,    -1,    -1,    18,    -1,    -1,
     709,    -1,   710,    -1,   709,   710,    -1,   720,    -1,   719,
      -1,    -1,   712,    -1,   713,    -1,   713,   712,    -1,   496,
      -1,    -1,   213,   891,   152,    -1,    -1,   717,    -1,   718,
      -1,   718,   716,    -1,   718,    -1,   718,   717,    -1,   718,
     585,   717,    -1,   143,  1032,   721,    -1,   517,  1032,   721,
      -1,   292,  1032,   988,    -1,   307,  1032,   988,    -1,    24,
    1032,   987,    -1,   361,  1032,  1140,    -1,    68,  1032,  1140,
      -1,    23,  1032,   988,    -1,   358,  1032,   987,    -1,   358,
    1032,   111,    -1,    57,  1032,   987,    -1,   114,  1032,   987,
      -1,   423,  1032,   722,    -1,   387,  1032,   723,    -1,   384,
    1032,   987,    -1,   385,  1032,   987,    -1,   526,  1032,   583,
    1006,   584,    -1,   719,    -1,   720,    -1,   224,  1032,   724,
      -1,    96,   122,  1032,  1140,    -1,   217,   122,  1032,  1140,
      -1,    77,  1032,  1140,    -1,   768,   759,  1032,   761,    -1,
     768,    64,  1032,   767,    -1,  1145,    -1,   111,    -1,   165,
      -1,   133,    -1,    72,    -1,   393,    -1,    71,    -1,   386,
      -1,   383,    -1,   987,    -1,   335,    -1,   164,    -1,   243,
      -1,   982,    -1,   873,   877,    -1,    -1,    10,    -1,   482,
      -1,   391,    -1,   108,    -1,   227,    -1,   729,    -1,   728,
     585,   729,    -1,   730,    -1,   731,    -1,   736,   732,    -1,
     736,   773,    -1,   781,   793,   787,   583,   791,   584,    -1,
     734,   782,   793,   787,   583,   791,   584,    -1,   734,   170,
     238,   793,   583,   791,   584,   773,    -1,   735,   732,    -1,
     734,   733,    -1,    -1,   733,    -1,    58,   885,    -1,    -1,
     735,    -1,    79,   793,    -1,    -1,  1136,   737,   738,   755,
      -1,   746,   753,   750,    -1,   747,   754,   750,    -1,   167,
     748,   750,    -1,    37,    -1,    37,   583,   338,   584,    -1,
      42,    -1,    41,    -1,   742,   583,   338,   584,   769,    -1,
     742,   769,    -1,   743,   583,   338,   584,   770,    -1,   743,
     770,    -1,    32,   583,   338,   584,    -1,    32,    -1,   744,
     583,   338,   584,   769,    -1,   745,   583,   338,   584,   770,
      -1,   547,   583,   338,   584,    -1,   566,   753,   750,    -1,
     100,    -1,   504,    -1,   501,   753,    -1,    97,    -1,   505,
      -1,    39,   753,    -1,   741,    -1,   296,    -1,   265,    -1,
     268,   547,    -1,   268,   744,   769,    -1,   507,   769,    -1,
     500,   753,   769,    -1,   298,   769,    -1,   266,   769,    -1,
     108,   748,   750,    -1,   339,   748,   750,    -1,   165,   748,
     750,    -1,    -1,   144,   739,   583,   795,   584,   769,    -1,
      -1,   446,   740,   583,   795,   584,   769,    -1,   268,   769,
      -1,   444,    -1,   187,    -1,   186,    -1,   365,    -1,   318,
      -1,   256,    -1,   317,    -1,   367,    -1,   319,    -1,    56,
      -1,   326,    -1,   323,    56,    -1,   742,   551,    -1,   548,
      -1,   323,   548,    -1,   340,    -1,   326,   548,    -1,   323,
      56,   551,    -1,   326,   551,    -1,   227,    -1,   506,    -1,
     456,    -1,   297,    -1,    31,    -1,   391,    -1,   127,    -1,
     127,   369,    -1,    -1,   583,   338,   584,    -1,   749,    -1,
     583,   338,   585,   338,   584,    -1,    -1,   751,    -1,   751,
     752,    -1,   752,    -1,   453,    -1,   532,    -1,   567,    -1,
      -1,   583,   338,   584,    -1,    -1,   749,    -1,    -1,   756,
      -1,   756,   757,    -1,   757,    -1,   337,    -1,   891,   337,
      -1,   111,   758,    -1,   344,   534,   334,   884,    -1,    23,
      -1,   444,   111,   546,    -1,   772,   238,    -1,   527,    -1,
     527,   238,    -1,    68,  1140,    -1,    64,   765,    -1,   334,
     884,    -1,  1127,    -1,    56,   446,    -1,    55,    -1,  1145,
      -1,    32,    -1,   760,    -1,   111,    -1,    -1,   759,   761,
      -1,  1145,    -1,    32,    -1,   763,    -1,   111,    -1,  1145,
      -1,    -1,    64,   767,    -1,   765,    -1,   111,    -1,    -1,
     111,    -1,    -1,    20,   770,    -1,    46,    -1,   525,   770,
      -1,   759,   760,   770,    -1,    32,   771,    -1,    -1,    32,
      -1,    -1,    20,    -1,   525,    -1,   759,   760,    -1,    -1,
     372,    -1,    -1,   394,  1137,   774,   775,    -1,   777,    -1,
     583,   776,   584,   777,    -1,   776,   585,  1143,    -1,  1143,
      -1,    -1,   778,    -1,   778,   779,    -1,   779,    -1,   344,
     115,   780,    -1,   344,   534,   780,    -1,   289,   177,    -1,
     289,   360,    -1,   289,   454,    -1,   411,    -1,    49,    -1,
     446,   337,    -1,   335,     5,    -1,   446,   111,    -1,   783,
      -1,   178,   784,    -1,   460,   784,    -1,   372,   238,    -1,
     527,   784,    -1,   238,    -1,   217,    -1,    -1,   783,    -1,
     237,    -1,   217,    -1,   216,    -1,    -1,   527,    -1,   178,
      -1,   460,    -1,    -1,   540,   788,    -1,   517,   788,    -1,
      44,    -1,   425,    -1,   200,    -1,   789,    -1,   790,    -1,
     790,   585,   789,    -1,   440,    -1,   335,   440,    -1,   435,
      -1,   335,   435,    -1,   437,    -1,   438,    -1,   439,    -1,
     431,    -1,   433,    -1,   434,    -1,   436,    -1,   987,    -1,
     791,   585,   792,   980,    -1,   792,   980,    -1,  1143,    -1,
    1143,   583,   338,   584,    -1,    -1,  1136,    -1,    -1,   590,
    1143,    -1,  1125,    -1,   795,   585,  1125,    -1,    -1,    13,
     810,   495,  1137,   797,   803,    -1,    -1,    13,    94,   802,
     798,   709,    -1,    -1,    13,   374,   619,   799,   626,    -1,
      -1,    13,   179,   619,   800,   626,    -1,    -1,    13,  1237,
    1233,  1238,   552,  1137,   801,  1241,    18,  1243,  1246,    -1,
      -1,  1143,    -1,    -1,   124,   494,    -1,   215,   494,    -1,
     805,    -1,   803,   585,   805,    -1,     6,   809,    -1,   804,
     730,   812,    -1,     6,   731,    -1,   804,   583,   728,   584,
      -1,    -1,    53,   809,  1136,   806,   736,   812,    -1,    -1,
      -1,   312,   809,  1136,   807,   738,   755,   808,   812,    -1,
     129,   809,  1136,   811,    -1,   129,   170,   238,   793,    -1,
     129,   372,   238,    -1,   129,   783,  1136,    -1,   123,   237,
      -1,   137,   237,    -1,    13,   809,  1136,   446,   111,  1127,
      -1,    13,   809,  1136,   129,   111,    -1,   401,   813,  1137,
      -1,    83,   508,   759,   761,   766,    -1,   716,    -1,   169,
      -1,   973,    -1,    -1,    67,    -1,    -1,   214,    -1,    -1,
     411,    -1,    49,    -1,    -1,     8,  1143,    -1,   164,    -1,
      -1,   508,    -1,   145,    -1,    18,    -1,    -1,   475,   455,
     819,   815,   823,    -1,   479,   455,   819,    -1,    -1,   455,
     475,   819,   816,   823,    -1,   455,   479,   819,    -1,   475,
     510,   818,    -1,    -1,   558,    78,   457,    -1,    -1,   820,
     821,    -1,   822,    -1,   821,   585,   822,    -1,    -1,   472,
      -1,   398,    -1,    -1,   533,   824,    -1,   612,    -1,   824,
     585,   612,    -1,    -1,   410,  1168,   826,  1006,   175,  1140,
      -1,    -1,    26,  1168,   828,  1006,   508,  1140,    -1,    -1,
      57,  1168,   830,  1006,   831,    -1,    -1,   382,    -1,   156,
      -1,    -1,   402,   846,  1168,   833,  1006,   834,    -1,    -1,
     835,    -1,   836,    -1,   836,   835,    -1,   382,    -1,   156,
      -1,   538,    -1,    -1,    14,   846,  1168,   838,  1006,   841,
      -1,    -1,    58,  1168,   840,  1006,   841,    -1,    -1,   842,
      -1,   843,    -1,   843,   842,    -1,   382,    -1,   159,    -1,
     299,    -1,   156,    -1,    54,    -1,   172,   535,    -1,    -1,
     348,   846,  1168,   845,  1006,   841,    -1,    -1,   336,    -1,
     258,    -1,    -1,   401,  1168,   848,   850,    -1,   401,   537,
     618,   849,    -1,  1146,   508,  1146,    -1,   849,   585,  1146,
     508,  1146,    -1,   851,    -1,   850,   585,   851,    -1,  1137,
     508,  1137,    -1,    47,   217,   853,   229,   855,    -1,   854,
      -1,   853,   585,   854,    -1,  1137,   860,    -1,  1143,    -1,
     111,    -1,    -1,   257,   217,   226,    47,   857,   858,    -1,
     859,    -1,   858,   585,   859,    -1,  1137,   860,   863,    -1,
      -1,   861,   862,    -1,    -1,   784,   583,   957,   584,    -1,
      -1,   214,   247,    -1,   865,    -1,   430,   867,    -1,   583,
     866,   584,  1221,    -1,   430,   869,    -1,   583,   866,   584,
      -1,    -1,   869,   868,  1218,    -1,    -1,    -1,   870,   874,
     878,   871,   872,   877,    -1,   976,   982,    -1,   998,    -1,
     873,    -1,   998,   873,    -1,   873,   998,    -1,   175,   930,
     965,   970,   967,   976,   982,   989,    -1,   175,   130,   965,
     982,    -1,    -1,   875,    -1,   875,   876,    -1,   876,    -1,
     481,    -1,   204,    -1,   125,    -1,   470,    -1,   465,    -1,
     466,    -1,   468,    -1,   469,    -1,   467,    -1,    12,    -1,
      -1,   172,   534,    -1,   262,   229,   448,   310,    -1,   878,
     585,   879,    -1,   879,    -1,   577,    -1,   880,   882,   881,
     883,    -1,    -1,    -1,  1131,    -1,   885,    -1,    -1,    18,
    1143,    -1,    18,  1140,    -1,  1143,    -1,  1140,    -1,    -1,
     583,   584,    -1,   885,   889,   885,    -1,   885,   563,   885,
      -1,   885,   890,   885,    -1,   333,   885,    -1,   886,   232,
     514,    -1,   886,   232,   891,   514,    -1,   886,   232,   158,
      -1,   886,   232,   891,   158,    -1,   886,   232,   530,    -1,
     886,   232,   891,   530,    -1,   886,    -1,   886,   232,   337,
      -1,   886,   232,   891,   337,    -1,   886,   146,   887,    -1,
     886,   893,   887,    -1,   886,   893,   894,   583,  1226,   584,
      -1,   887,    -1,   888,   229,   583,  1226,   584,    -1,   888,
     891,   229,   583,  1226,   584,    -1,   888,   229,   583,   885,
     584,    -1,   888,   229,   583,   885,   585,   919,   584,    -1,
     888,   891,   229,   583,   885,   584,    -1,   888,   891,   229,
     583,   885,   585,   919,   584,    -1,   888,   572,   888,    16,
     887,    -1,   888,   891,   572,   888,    16,   887,    -1,   888,
     458,   252,   888,    -1,   888,   252,   896,   969,    -1,   888,
     891,   252,   896,   969,    -1,   888,   395,   888,    -1,   888,
     891,   395,   888,    -1,   888,    -1,   888,   573,   888,    -1,
     888,   574,   888,    -1,   888,   449,   888,    -1,   888,   450,
     888,    -1,   888,   576,   888,    -1,   888,   575,   888,    -1,
     888,   576,   895,   959,    -1,   888,   575,   895,   959,    -1,
     888,   577,   888,    -1,   888,   578,   888,    -1,   888,   579,
     888,    -1,   888,   126,   888,    -1,   888,   313,   888,    -1,
     888,   580,   888,    -1,   896,    -1,   354,    -1,   351,    -1,
      16,    -1,    15,    -1,   333,    -1,   332,    -1,   586,    -1,
     332,    -1,   145,    -1,   184,    -1,   198,    -1,   244,    -1,
     271,    -1,   328,    -1,    12,    -1,    17,    -1,   225,   885,
      -1,  1133,    -1,   896,    64,  1145,    -1,  1128,    -1,  1126,
      -1,   909,    -1,   905,    -1,   896,   353,   896,    -1,   576,
     896,    -1,   575,   896,    -1,   581,   896,    -1,   892,   896,
      -1,   583,  1226,   584,    -1,   583,   885,   584,    -1,   583,
     885,   585,   919,   584,    -1,   424,   583,   885,   585,   919,
     584,    -1,   152,   583,  1226,   584,    -1,   587,  1143,   885,
     588,    -1,   289,   922,     9,   583,   888,   899,   584,    -1,
      20,   583,   885,   584,    -1,    32,   896,    -1,    51,   583,
     885,    18,   917,   584,    -1,   571,   926,   928,   927,   141,
      -1,    83,   583,   885,   585,   917,   584,    -1,    83,   583,
     885,   540,   760,   584,    -1,   111,   583,  1133,   584,    -1,
     545,   583,  1134,   584,    -1,   180,   583,   584,    -1,   181,
     583,   885,   584,    -1,   182,   583,   885,   585,   885,   584,
      -1,   183,   583,   885,   585,   885,   585,   885,   584,    -1,
       7,   583,   885,   585,   885,   584,    -1,     7,   583,   885,
     585,   225,   885,   959,   584,    -1,   404,   583,   885,   585,
     885,   584,    -1,    22,   583,   885,   584,    -1,    22,   583,
     885,   585,   885,   584,    -1,    56,   583,   919,   584,    -1,
      56,   583,   919,   540,   760,   584,    -1,    55,   583,   885,
     584,    -1,    62,   583,   919,   584,    -1,    65,   583,   885,
     584,    -1,    73,   583,   919,   584,    -1,    74,   583,   885,
     585,   919,   584,    -1,    84,   583,   885,   585,   885,   585,
     885,   584,    -1,    90,   884,    -1,    93,   884,    -1,    93,
     583,   885,   584,    -1,    91,   884,    -1,    98,   583,   885,
     585,   895,   959,   584,    -1,    99,   583,   885,   585,   895,
     959,   584,    -1,    94,   583,   584,    -1,   100,   583,   885,
     584,    -1,   105,   583,   885,   584,    -1,   136,   583,   885,
     585,   919,   584,    -1,   272,   583,   885,   585,   919,   584,
      -1,   140,   583,   885,   584,    -1,   140,   583,   885,   585,
     885,   584,    -1,   110,   583,   885,   585,  1141,   584,    -1,
     139,   583,   885,   585,  1141,   584,    -1,   118,   583,   885,
     584,    -1,   118,   583,   885,   585,   885,   584,    -1,   119,
     583,   885,   584,    -1,   119,   583,   885,   585,   885,   584,
      -1,   155,   583,   885,   585,   885,   585,   885,   584,    -1,
     155,   583,   885,   585,   885,   585,   885,   585,   885,   584,
      -1,   155,   583,   885,   585,   885,   585,   885,   585,   885,
     585,   885,   584,    -1,   171,   583,   885,   585,   338,   584,
      -1,   176,   583,   885,   584,    -1,   176,   583,   885,   585,
     885,   584,    -1,   162,   583,   885,   585,   919,   584,    -1,
     898,    -1,   190,   583,   961,   585,   885,   584,    -1,   209,
     583,   885,   584,    -1,   213,   583,   885,   585,   885,   585,
     885,   584,    -1,   223,   583,   885,   585,   885,   585,   885,
     585,   885,   584,    -1,   895,   959,   576,   885,    -1,   895,
      -1,   242,   583,   584,    -1,   242,   583,   885,   584,    -1,
     249,   583,   885,   585,   885,   584,    -1,   259,   583,   885,
     585,   885,   584,    -1,   259,   583,   885,   585,   885,   585,
     885,   584,    -1,   194,   583,   885,   585,   919,   584,    -1,
     246,   583,   885,   585,   919,   584,    -1,   264,   583,   885,
     584,    -1,   264,   583,   885,   585,   885,   584,    -1,   279,
     583,   885,   585,   885,   584,    -1,   279,   583,   885,   585,
     885,   585,   885,   584,    -1,   302,   583,   885,   584,    -1,
     306,   583,   885,   584,    -1,   313,   583,   885,   585,   885,
     584,    -1,   314,   583,   885,   584,    -1,   334,   884,    -1,
     334,   583,   885,   584,    -1,   361,   583,   885,   584,    -1,
     343,   583,   885,   584,    -1,   368,   583,   888,   229,   885,
     584,    -1,   380,   583,   885,   584,    -1,   388,   583,   885,
     584,    -1,   388,   583,   584,    -1,   405,   583,   885,   585,
     885,   585,   885,   584,    -1,   416,   583,   885,   585,   885,
     584,    -1,   419,   583,   885,   584,    -1,   419,   583,   885,
     585,   885,   584,    -1,   422,   583,   584,    -1,   432,   583,
     919,   584,    -1,   483,   583,   885,   585,   885,   584,    -1,
     483,   583,   885,   585,   225,   885,   959,   584,    -1,   428,
     583,   885,   584,    -1,   485,   583,   885,   585,   885,   585,
     885,   584,    -1,   485,   583,   885,   585,   885,   584,    -1,
     485,   583,   885,   175,   885,   172,   885,   584,    -1,   485,
     583,   885,   175,   885,   584,    -1,   486,   583,   885,   585,
     885,   585,   885,   584,    -1,   492,   884,    -1,   492,   583,
     885,   584,    -1,   504,   583,   885,   584,    -1,   501,   583,
     885,   584,    -1,   501,   583,   885,   585,   885,   584,    -1,
     502,   583,   960,   585,   885,   585,   885,   584,    -1,   503,
     583,   960,   585,   885,   585,   885,   584,    -1,   513,   583,
     885,   584,    -1,   513,   583,   245,   885,   175,   885,   584,
      -1,   513,   583,   509,   885,   175,   885,   584,    -1,   513,
     583,    43,   885,   175,   885,   584,    -1,   513,   583,   245,
     175,   885,   584,    -1,   513,   583,   509,   175,   885,   584,
      -1,   513,   583,    43,   175,   885,   584,    -1,   513,   583,
     885,   175,   885,   584,    -1,   515,   583,   885,   585,   885,
     584,    -1,  1143,   590,  1143,   583,   918,   584,    -1,    -1,
    1139,   583,   897,   900,   584,    -1,   528,   583,  1124,   585,
     338,   585,   338,   585,   919,   584,    -1,   529,   583,   584,
      -1,   529,   583,   885,   584,    -1,   537,   583,   584,    -1,
     541,   884,    -1,   543,   884,    -1,   542,   884,    -1,   554,
     583,   885,   584,    -1,   554,   583,   885,   585,   885,   584,
      -1,   566,   583,   885,   584,    -1,   564,   583,   885,   584,
      -1,   564,   583,   885,   585,   885,   584,    -1,    29,   583,
     987,   585,   885,   584,    -1,   157,   583,   959,   175,   885,
     584,    -1,    80,   583,   885,   585,   885,   584,    -1,   188,
     583,   885,   584,    -1,   188,   583,   885,   585,   885,   584,
      -1,   189,   583,   885,   584,    -1,   189,   583,   885,   585,
     885,   584,    -1,   186,   583,   919,   584,    -1,   256,   583,
     919,   584,    -1,   317,   583,   919,   584,    -1,   309,   583,
     885,   584,    -1,   309,   583,   885,   585,   885,   584,    -1,
     315,   583,   885,   584,    -1,   315,   583,   885,   585,   885,
     584,    -1,   316,   583,   885,   584,    -1,   316,   583,   885,
     585,   885,   584,    -1,   318,   583,   919,   584,    -1,   319,
     583,   919,   584,    -1,   365,   583,   885,   585,   885,   584,
      -1,   364,   583,   885,   584,    -1,   364,   583,   885,   585,
     885,   584,    -1,   366,   583,   885,   584,    -1,   366,   583,
     885,   585,   885,   584,    -1,   367,   583,   919,   584,    -1,
     185,   583,   885,   584,    -1,   185,   583,   885,   585,   885,
     584,    -1,   254,   583,   885,   584,    -1,   254,   583,   885,
     585,   885,   584,    -1,    -1,   558,   381,   154,    -1,   229,
      41,   310,    -1,    -1,   901,    -1,    -1,   902,   903,    -1,
     904,    -1,   903,   585,   904,    -1,   880,   885,   881,   883,
      -1,    25,   583,   915,   584,    -1,    25,   583,   125,   915,
     584,    -1,    35,   583,   915,   584,    -1,    36,   583,   915,
     584,    -1,    38,   583,   915,   584,    -1,    85,   583,   964,
     577,   584,    -1,    85,   583,   915,   584,    -1,    -1,    -1,
      85,   583,   125,   906,   919,   907,   584,    -1,   197,   583,
    1124,   585,   338,   585,   338,   585,   915,   584,    -1,   308,
     583,   915,   584,    -1,   308,   583,   125,   915,   584,    -1,
     293,   583,   915,   584,    -1,   293,   583,   125,   915,   584,
      -1,   477,   583,   915,   584,    -1,   550,   583,   915,   584,
      -1,   478,   583,   915,   584,    -1,   544,   583,   915,   584,
      -1,   487,   583,   915,   584,    -1,   487,   583,   125,   915,
     584,    -1,    -1,   196,   583,   912,   908,   919,   914,   913,
     584,    -1,    -1,   589,   910,   911,    -1,  1145,   447,   885,
      -1,  1145,    -1,   589,  1158,  1145,   794,    -1,    -1,   125,
      -1,    -1,   442,  1125,    -1,    -1,   977,    -1,    -1,   964,
     916,   885,    -1,    32,   753,    -1,    56,   753,   769,    -1,
     326,   753,    -1,   453,    -1,   453,   227,    -1,   532,    -1,
     532,   227,    -1,   100,    -1,   504,    -1,    97,    -1,   108,
     748,    -1,    -1,   919,    -1,    -1,   920,   921,    -1,   885,
      -1,   921,   585,   885,    -1,   923,    -1,   583,   923,   584,
      -1,    -1,   924,   925,    -1,  1133,    -1,   925,   585,  1133,
      -1,    -1,   885,    -1,    -1,   569,   885,    -1,   555,   885,
     570,   885,    -1,   928,   555,   885,   570,   885,    -1,   941,
      -1,   932,    -1,   931,    -1,   929,    -1,   931,   585,   929,
      -1,   929,   940,   929,    -1,   929,   481,   941,    -1,    -1,
     929,   940,   929,   344,   933,   885,    -1,    -1,   929,   481,
     941,   344,   934,   885,    -1,    -1,   929,   940,   929,   540,
     935,   583,   958,   584,    -1,   929,   324,   236,   941,    -1,
      -1,   929,   249,   951,   236,   929,   344,   936,   885,    -1,
      -1,   929,   249,   951,   236,   941,   937,   540,   583,   958,
     584,    -1,   929,   324,   249,   951,   236,   941,    -1,    -1,
     929,   416,   951,   236,   929,   344,   938,   885,    -1,    -1,
     929,   416,   951,   236,   941,   939,   540,   583,   958,   584,
      -1,   929,   324,   416,   951,   236,   941,    -1,   236,    -1,
     219,   236,    -1,    88,   236,    -1,    -1,   942,  1137,   963,
     953,    -1,    -1,   587,  1143,   929,   249,   355,   236,   929,
     344,   943,   885,   588,    -1,   950,   949,   946,    -1,   583,
     949,   944,  1221,   584,   963,    -1,    -1,   949,   945,   931,
      -1,    -1,    -1,   947,   874,   878,   948,   725,    -1,    -1,
     430,    -1,    -1,   355,    -1,    -1,   172,   236,    -1,    -1,
     539,   954,    -1,   169,   954,    -1,   214,   954,    -1,    -1,
     783,   952,   955,   583,   956,   584,    -1,    -1,   957,    -1,
     957,   585,  1143,    -1,  1143,    -1,   372,    -1,  1143,    -1,
     958,   585,  1143,    -1,   960,    -1,   101,    -1,   102,    -1,
     103,    -1,   104,    -1,   206,    -1,   207,    -1,   208,    -1,
     302,    -1,   304,    -1,   305,    -1,   427,    -1,   565,    -1,
     105,    -1,   554,    -1,   209,    -1,   174,    -1,   306,    -1,
     314,    -1,   380,    -1,   428,    -1,   566,    -1,   100,    -1,
     504,    -1,    97,    -1,   501,    -1,    -1,    18,    -1,   145,
      -1,    -1,   962,  1143,    -1,    -1,    12,    -1,    -1,    -1,
     556,   966,   885,    -1,    -1,    -1,   201,   968,   885,    -1,
     149,   896,    -1,    -1,    -1,   195,    45,   971,   972,    -1,
     971,   585,  1132,   980,    -1,  1132,   980,    -1,    -1,   558,
      89,    -1,   558,   418,    -1,   352,    45,   974,    -1,   974,
     585,   975,    -1,   975,    -1,  1134,   980,    -1,    -1,   977,
      -1,    -1,   352,    45,   978,   979,    -1,   979,   585,  1132,
     980,    -1,  1132,   980,    -1,    -1,    19,    -1,   116,    -1,
      -1,   983,    -1,    -1,   983,    -1,   253,   984,    -1,   985,
      -1,   985,   585,   985,    -1,   985,   341,   985,    -1,  1126,
      -1,   520,    -1,   267,    -1,   338,    -1,    -1,   253,   985,
      -1,   338,    -1,   203,    -1,   267,    -1,   520,    -1,   107,
      -1,   166,    -1,   338,    -1,   520,    -1,   267,    -1,   107,
      -1,   166,    -1,    -1,    -1,   374,  1143,   990,   583,   991,
     584,    -1,    -1,   992,    -1,   992,   585,   993,    -1,   993,
      -1,   880,   885,    -1,    -1,   995,   996,    -1,   996,   585,
     997,    -1,   997,    -1,   589,  1145,    -1,  1145,    -1,    -1,
     226,   999,  1000,    -1,    -1,   356,  1142,  1001,  1113,  1116,
      -1,   131,  1142,    -1,   994,    -1,    -1,   128,  1003,   919,
      -1,   129,  1011,  1168,  1010,  1006,   811,    -1,    -1,   129,
     217,  1143,   344,  1137,  1005,    -1,   129,    94,  1010,  1143,
      -1,   129,   179,  1010,   619,    -1,   129,   374,  1010,   619,
      -1,   129,   537,   618,  1198,    -1,   129,   552,  1010,  1006,
     811,    -1,   129,   511,  1010,   619,    -1,  1007,    -1,  1006,
     585,  1007,    -1,  1137,    -1,  1009,    -1,  1008,   585,  1009,
      -1,  1137,    -1,    -1,   213,   152,    -1,    -1,   496,    -1,
      -1,    -1,   223,  1013,  1018,   810,  1020,  1014,  1022,  1038,
      -1,    -1,    -1,   405,  1016,  1019,  1020,  1017,  1022,    -1,
      -1,   270,    -1,   113,    -1,   204,    -1,  1047,    -1,   113,
      -1,   226,  1021,    -1,  1021,    -1,  1007,    -1,  1025,    -1,
     583,   584,  1025,    -1,   583,  1024,   584,  1025,    -1,    -1,
     446,  1023,  1029,    -1,  1024,   585,  1130,    -1,  1130,    -1,
     545,  1028,    -1,   546,  1028,    -1,    -1,   704,  1026,  1218,
      -1,    -1,   583,   704,   584,  1027,  1221,    -1,  1028,   585,
    1033,    -1,  1033,    -1,  1029,   585,  1030,    -1,  1030,    -1,
    1134,  1031,  1037,    -1,   145,    -1,   447,    -1,    -1,  1031,
      -1,    -1,   583,  1034,  1035,   584,    -1,    -1,  1036,    -1,
    1036,   585,  1037,    -1,  1037,    -1,   885,    -1,   111,    -1,
      -1,    -1,   344,   132,  1039,   238,   534,  1045,    -1,    -1,
      -1,   534,  1041,  1047,   810,   930,   446,  1043,  1042,   965,
     976,   986,    -1,  1043,   585,  1044,    -1,  1044,    -1,  1134,
    1031,  1037,    -1,  1045,   585,  1046,    -1,  1046,    -1,  1134,
    1031,  1037,    -1,    -1,   270,    -1,    -1,   115,  1049,  1057,
    1050,    -1,    -1,   175,  1137,  1051,   965,   976,   986,    -1,
      -1,  1054,  1052,   175,   930,   965,    -1,    -1,   175,  1008,
    1053,   540,   930,   965,    -1,  1055,    -1,  1054,   585,  1055,
      -1,  1143,  1056,   963,    -1,  1143,   590,  1143,  1056,   963,
      -1,    -1,   590,   577,    -1,    -1,  1058,  1057,    -1,   382,
      -1,   270,    -1,   214,    -1,   515,  1060,  1007,    -1,    -1,
     495,    -1,    -1,  1062,    -1,  1063,    -1,  1062,   585,  1063,
      -1,    86,    -1,   300,    -1,    40,   230,    -1,    81,   491,
      -1,   359,   160,    -1,   231,    -1,   490,    -1,   459,    -1,
      12,    -1,    -1,   172,   381,   338,    -1,    -1,   451,  1066,
    1067,    -1,    95,  1078,    -1,  1074,   493,  1073,  1078,    -1,
    1074,   512,  1073,  1078,    -1,   495,   476,  1073,  1078,    -1,
     347,   493,  1073,  1078,    -1,    -1,   143,   721,  1068,  1070,
      -1,  1074,    66,  1075,  1137,  1073,  1078,    -1,   329,   287,
     172,   455,   558,   275,   145,  1140,    16,   276,   145,   988,
      16,   280,   145,   987,    -1,  1071,   263,    -1,   455,   205,
      -1,    -1,    33,   150,  1076,  1077,  1069,   981,    -1,   785,
    1075,  1137,  1073,   965,    -1,    67,   516,    -1,   495,   516,
      -1,  1072,   142,    -1,   373,    -1,    85,   583,   577,   584,
     553,    -1,    85,   583,   577,   584,   147,    -1,   553,   981,
      -1,   147,   981,    -1,   378,    -1,   377,  1061,  1064,   981,
      -1,  1157,   476,  1078,    -1,   220,   476,    -1,   320,   476,
      -1,  1074,   376,    -1,  1157,   549,  1078,    -1,   759,  1078,
      -1,    65,  1078,    -1,    30,   263,    -1,   263,    -1,   193,
      -1,   193,   172,  1146,    -1,    87,    94,   714,  1143,    -1,
      87,   495,  1137,    -1,    87,   552,  1137,    -1,   287,   476,
      -1,   455,   476,    -1,    87,   374,   619,    -1,    87,   179,
     619,    -1,   374,   476,  1078,    -1,   179,   476,  1078,    -1,
     374,    63,   619,    -1,   179,    63,   619,    -1,   440,   476,
    1073,  1078,    -1,   476,    -1,   263,    -1,   287,    -1,    32,
      -1,    -1,   480,    -1,    -1,  1075,  1143,    -1,    -1,   177,
      -1,   175,    -1,   229,    -1,    -1,   229,  1140,    -1,    -1,
     175,   988,    -1,    -1,   252,  1140,    -1,   556,   885,    -1,
      -1,  1082,  1137,  1080,  1084,    -1,    -1,  1082,  1083,  1081,
     864,    -1,   116,    -1,   117,    -1,    -1,   156,    -1,    -1,
    1125,    -1,  1143,    -1,    -1,   168,   846,  1086,  1087,    -1,
    1087,   585,  1088,    -1,  1088,    -1,    -1,  1168,  1089,  1090,
      -1,   493,   558,   390,   262,    -1,   381,    47,    -1,   205,
      -1,   373,    -1,   263,    -1,   476,    -1,   455,    -1,   287,
      -1,   120,    -1,   409,    -1,    -1,  1006,    -1,    -1,   408,
    1092,  1093,    -1,  1093,   585,  1094,    -1,  1094,    -1,   455,
      -1,   287,    -1,   381,    47,    -1,    -1,   379,  1096,  1097,
      -1,  1071,   263,  1098,    -1,   508,  1140,    -1,    27,   885,
      -1,    -1,   239,  1100,  1101,   885,    -1,    -1,    77,    -1,
     381,    -1,   539,  1143,    -1,    -1,   257,    96,  1104,  1105,
      -1,   257,   495,  1137,   175,   287,    -1,    -1,    -1,    -1,
      -1,  1111,  1110,   218,  1142,  1106,  1112,   226,  1107,   495,
    1137,  1108,   762,  1109,  1113,  1116,  1119,  1120,  1123,    -1,
     175,   287,    -1,    -1,   258,    -1,    -1,    75,    -1,   270,
      -1,    -1,   405,    -1,   214,    -1,    -1,    66,  1114,    -1,
    1114,  1115,    -1,  1115,    -1,   498,    45,  1125,    -1,   350,
     138,    45,  1125,    -1,   138,    45,  1125,    -1,   148,    45,
    1125,    -1,    -1,   255,  1117,    -1,  1117,  1118,    -1,  1118,
      -1,   498,    45,  1125,    -1,   474,    45,  1125,    -1,    -1,
     214,   338,   255,    -1,    -1,   583,  1121,   584,    -1,   583,
     584,    -1,  1121,   585,  1122,    -1,  1122,    -1,  1134,    -1,
     589,  1145,    -1,    -1,   446,  1045,    -1,   499,    -1,   325,
      -1,   523,   499,    -1,  1124,  1141,    -1,  1141,    -1,   203,
      -1,    34,    -1,   362,    -1,  1128,    -1,   576,  1129,    -1,
     575,  1129,    -1,  1124,    -1,  1129,    -1,   337,    -1,   158,
      -1,   514,    -1,   203,    -1,    34,    -1,   523,   203,    -1,
     523,    34,    -1,   100,  1124,    -1,   504,  1124,    -1,   501,
    1124,    -1,   338,    -1,   267,    -1,   520,    -1,   107,    -1,
     166,    -1,  1134,    -1,  1131,    -1,  1143,   590,   577,    -1,
    1143,   590,  1143,   590,   577,    -1,   885,    -1,  1143,    -1,
    1135,    -1,  1143,    -1,  1135,    -1,  1143,   590,  1143,    -1,
     590,  1143,   590,  1143,    -1,  1143,   590,  1143,   590,  1143,
      -1,  1143,    -1,  1143,   590,  1143,   590,  1143,    -1,  1143,
     590,  1143,    -1,   590,  1143,    -1,  1143,    -1,  1143,   590,
    1143,    -1,   590,  1143,    -1,  1143,    -1,   210,    -1,   212,
      -1,   499,    -1,   499,    -1,   499,    -1,  1139,    -1,  1147,
      -1,  1139,    -1,  1148,    -1,  1143,    -1,  1140,    -1,   251,
      -1,  1145,    -1,  1145,   589,  1145,    -1,    91,   884,    -1,
    1148,    -1,    20,    -1,    26,    -1,    28,    -1,    46,    -1,
      47,    -1,    55,    -1,    57,    -1,    61,    -1,    68,    -1,
      70,    -1,    80,    -1,   106,    -1,   128,    -1,   141,    -1,
     151,    -1,   168,    -1,   199,    -1,   202,    -1,   241,    -1,
     335,    -1,   347,    -1,   370,    -1,   402,    -1,   408,    -1,
     410,    -1,   417,    -1,   426,    -1,   429,    -1,   453,    -1,
     455,    -1,   475,    -1,   479,    -1,   515,    -1,   525,    -1,
     562,    -1,   535,    -1,     5,    -1,     7,    -1,     8,    -1,
       9,    -1,    10,    -1,    11,    -1,    17,    -1,    23,    -1,
      24,    -1,    25,    -1,    30,    -1,    33,    -1,    37,    -1,
      40,    -1,    42,    -1,    41,    -1,    44,    -1,    50,    -1,
      52,    -1,    54,    -1,    59,    -1,    60,    -1,    63,    -1,
      65,    -1,    66,    -1,    69,    -1,    71,    -1,    72,    -1,
      75,    -1,    77,    -1,    78,    -1,    81,    -1,    86,    -1,
      89,    -1,    96,    -1,    97,    -1,   100,    -1,   105,    -1,
     112,    -1,   114,    -1,   120,    -1,   122,    -1,   124,    -1,
     131,    -1,   132,    -1,   133,    -1,   144,    -1,   143,    -1,
     142,    -1,   147,    -1,   149,    -1,   150,    -1,   154,    -1,
     156,    -1,   159,    -1,   160,    -1,   173,    -1,   123,    -1,
     137,    -1,   177,    -1,   163,    -1,   164,    -1,   165,    -1,
     174,    -1,   187,    -1,   186,    -1,   190,    -1,   193,    -1,
     191,    -1,   200,    -1,   205,    -1,   209,    -1,   211,    -1,
     228,    -1,   215,    -1,   216,    -1,   233,    -1,   234,    -1,
     220,    -1,   224,    -1,   230,    -1,   231,    -1,   398,    -1,
     243,    -1,   247,    -1,   250,    -1,   256,    -1,   258,    -1,
     261,    -1,   263,    -1,   292,    -1,   287,    -1,   274,    -1,
     278,    -1,   275,    -1,   276,    -1,   288,    -1,   277,    -1,
     280,    -1,   273,    -1,   286,    -1,   282,    -1,   281,    -1,
     283,    -1,   284,    -1,   285,    -1,   290,    -1,   291,    -1,
     294,    -1,   295,    -1,   299,    -1,   300,    -1,   301,    -1,
     302,    -1,   303,    -1,   306,    -1,   307,    -1,   312,    -1,
     310,    -1,   314,    -1,   317,    -1,   318,    -1,   319,    -1,
     320,    -1,   322,    -1,   321,    -1,   323,    -1,   326,    -1,
     327,    -1,   330,    -1,   329,    -1,   331,    -1,   340,    -1,
     341,    -1,   343,    -1,   345,    -1,   346,    -1,   358,    -1,
     359,    -1,   360,    -1,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,   371,    -1,   373,    -1,   375,    -1,   376,    -1,
     377,    -1,   378,    -1,   380,    -1,   381,    -1,   382,    -1,
     383,    -1,   384,    -1,   385,    -1,   386,    -1,   387,    -1,
     392,    -1,   393,    -1,   396,    -1,   397,    -1,   400,    -1,
     403,    -1,   406,    -1,   409,    -1,   412,    -1,   413,    -1,
     418,    -1,   420,    -1,   421,    -1,   423,    -1,   424,    -1,
     425,    -1,   428,    -1,   431,    -1,   432,    -1,   433,    -1,
     434,    -1,   435,    -1,   436,    -1,   437,    -1,   438,    -1,
     439,    -1,   440,    -1,   444,    -1,   443,    -1,   445,    -1,
     454,    -1,   448,    -1,   452,    -1,   457,    -1,   458,    -1,
     459,    -1,   467,    -1,   466,    -1,   469,    -1,   472,    -1,
     476,    -1,   480,    -1,   482,    -1,   483,    -1,   484,    -1,
     488,    -1,   489,    -1,   490,    -1,   491,    -1,   493,    -1,
     494,    -1,   496,    -1,   497,    -1,   500,    -1,   510,    -1,
     512,    -1,   501,    -1,   502,    -1,   503,    -1,   504,    -1,
     516,    -1,   517,    -1,   518,    -1,   179,    -1,   521,    -1,
     522,    -1,   530,    -1,   533,    -1,   537,    -1,   538,    -1,
     549,    -1,   552,    -1,   546,    -1,   553,    -1,   554,    -1,
     559,    -1,   561,    -1,   566,    -1,    -1,   446,  1151,  1150,
    1152,    -1,    -1,   349,    -1,  1153,    -1,  1152,   585,  1153,
      -1,    -1,  1154,  1159,    -1,  1156,    -1,   191,    -1,   258,
      -1,   445,    -1,    -1,   345,    -1,    -1,   191,    -1,   258,
      -1,   445,    -1,    -1,   191,   590,    -1,   258,   590,    -1,
     445,   590,    -1,  1160,    -1,  1156,  1161,    -1,  1155,  1162,
    1031,  1165,    -1,  1155,   510,   233,   250,  1163,    -1,   589,
    1145,  1031,   885,    -1,   589,   589,  1158,  1162,  1031,  1165,
      -1,   759,   764,    -1,   321,  1031,   885,    -1,   321,   761,
     766,    -1,   361,  1031,  1164,    -1,   361,   172,  1146,  1031,
    1164,    -1,  1143,    -1,  1143,   590,  1143,    -1,   111,   590,
    1143,    -1,   390,   521,    -1,   390,    69,    -1,   403,   390,
      -1,   443,    -1,   499,    -1,   361,   583,   499,   584,    -1,
     343,   583,   499,   584,    -1,   885,    -1,   111,    -1,   344,
      -1,    12,    -1,    32,    -1,    -1,   262,  1168,  1167,  1169,
      -1,   495,    -1,   493,    -1,  1170,    -1,  1169,   585,  1170,
      -1,  1137,   963,  1171,    -1,   390,    -1,   560,    -1,   270,
     560,    -1,   390,   258,    -1,    -1,   531,  1173,  1168,    -1,
     199,  1137,   347,   963,    -1,   199,  1138,    61,    -1,    -1,
     199,  1138,   390,  1175,  1176,   965,   982,    -1,  1177,    -1,
    1143,  1178,    -1,   164,    -1,   330,    -1,   164,    -1,   330,
      -1,   371,    -1,   243,    -1,    -1,  1180,  1179,   583,  1036,
     584,    -1,   145,    -1,   184,    -1,   244,    -1,   198,    -1,
     271,    -1,   415,   618,  1182,    -1,  1186,   344,  1185,  1197,
     175,  1199,    -1,  1186,   344,   179,  1197,   175,  1199,    -1,
    1186,   344,   374,  1197,   175,  1199,    -1,    12,  1187,   585,
     192,   349,   175,  1199,    -1,   192,   618,  1184,    -1,  1186,
     344,  1185,  1197,   508,  1199,  1204,  1205,    -1,  1186,   344,
     179,  1197,   508,  1199,  1204,  1205,    -1,  1186,   344,   374,
    1197,   508,  1199,  1204,  1205,    -1,    -1,   495,    -1,  1188,
      -1,    12,  1187,    -1,    -1,   373,    -1,  1189,    -1,  1188,
     585,  1189,    -1,    -1,   430,  1190,  1201,    -1,    -1,   223,
    1191,  1201,    -1,    -1,   534,  1192,  1201,    -1,    -1,   394,
    1193,  1201,    -1,   115,    -1,   536,    -1,   217,    -1,    13,
      -1,    87,    -1,   129,    -1,   151,    -1,   400,    -1,   452,
      -1,   375,    -1,   163,    -1,   192,   349,    -1,   451,    95,
      -1,   488,    -1,    87,   496,   493,    -1,   262,   493,    -1,
     406,   455,    -1,   406,    60,    -1,    87,   552,    -1,   451,
     552,    -1,    87,   420,    -1,    13,   420,    -1,    87,   537,
      -1,    -1,    16,    -1,  1196,  1194,  1195,    -1,  1196,    -1,
     484,   499,    -1,   234,   499,    -1,    59,   499,    -1,   577,
      -1,  1143,   590,   577,    -1,   577,   590,   577,    -1,  1137,
      -1,  1146,    -1,  1198,   585,  1146,    -1,  1200,    -1,  1199,
     585,  1200,    -1,  1146,   211,    45,   499,    -1,  1146,   211,
      45,   361,   499,    -1,  1146,    -1,    -1,   583,  1202,   584,
      -1,  1202,   585,  1203,    -1,  1203,    -1,  1143,    -1,    -1,
     407,  1195,    -1,   407,   473,    -1,   407,   561,    -1,   407,
     331,    -1,    -1,   558,  1206,    -1,  1206,  1207,    -1,  1207,
      -1,   192,   349,    -1,   291,   987,    -1,   294,   987,    -1,
     290,   987,    -1,   295,   987,    -1,    -1,    28,  1209,  1210,
      -1,    -1,   559,    -1,    -1,    16,   335,    52,    -1,    16,
      52,    -1,    -1,   399,    -1,   335,   399,    -1,    -1,   426,
      -1,    70,  1210,  1211,  1212,    -1,   417,  1210,  1211,  1212,
      -1,   417,  1210,   508,  1213,  1143,    -1,   426,  1143,    -1,
     399,   426,  1143,    -1,    -1,  1219,    -1,    -1,   526,  1225,
    1220,   865,    -1,    -1,  1219,    -1,  1222,    -1,    -1,  1223,
    1224,    -1,   977,   981,    -1,   983,    -1,    -1,   125,    -1,
      12,    -1,   430,  1229,  1228,  1230,    -1,    -1,   583,  1229,
    1226,   584,  1227,  1218,  1230,    -1,   867,    -1,    -1,    -1,
    1233,  1232,    -1,  1234,  1233,  1239,    -1,  1239,    -1,  1247,
      -1,  1249,    -1,    -1,   112,   145,  1146,    -1,  1235,    -1,
    1235,  1236,    -1,  1236,    -1,   354,   405,    -1,    11,   145,
     522,    -1,    11,   145,   301,    -1,    11,   145,   497,    -1,
      -1,  1236,    -1,    -1,   471,   429,   112,    -1,   471,   429,
     228,    -1,    -1,  1238,   552,  1137,  1240,  1241,    18,  1243,
    1246,    -1,    -1,   583,  1242,   584,    -1,  1143,    -1,  1242,
     585,  1143,    -1,    -1,  1244,  1245,    -1,   430,   880,   867,
      -1,   583,   880,   866,   584,  1221,    -1,    -1,   558,    58,
     349,    -1,   558,    50,    58,   349,    -1,   558,   258,    58,
     349,    -1,    -1,   511,   880,   619,   696,   697,   344,   880,
    1137,   172,   880,   134,   424,  1248,   660,    -1,    -1,   726,
     880,   179,   619,  1250,   620,    -1,    -1,    -1,    -1,    -1,
     374,   880,   619,  1251,   583,  1252,   640,   584,  1253,   627,
    1254,   660,    -1,   562,  1257,  1256,  1258,    -1,   562,   141,
    1256,  1260,    -1,   562,   370,  1256,    -1,   562,    70,  1256,
    1259,    -1,   562,   417,  1256,    -1,   562,   392,    -1,  1125,
      -1,  1125,   585,  1125,    -1,  1125,   585,  1125,   585,   987,
      -1,    28,    -1,   475,    -1,    -1,   236,    -1,   412,    -1,
      -1,   346,   363,    -1,    -1,    -1,   489,  1261,  1262,    -1,
      -1,   172,   303,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1230,  1230,  1244,  1247,  1248,  1253,  1254,  1255,  1256,
    1257,  1258,  1259,  1260,  1261,  1262,  1263,  1264,  1265,  1266,
    1267,  1268,  1269,  1270,  1271,  1272,  1273,  1274,  1275,  1276,
    1277,  1278,  1279,  1280,  1281,  1282,  1283,  1284,  1285,  1286,
    1287,  1288,  1289,  1290,  1291,  1292,  1293,  1294,  1295,  1296,
    1297,  1298,  1299,  1303,  1312,  1313,  1318,  1327,  1334,  1344,
    1343,  1354,  1356,  1360,  1361,  1364,  1377,  1376,  1395,  1394,
    1405,  1406,  1409,  1414,  1419,  1424,  1429,  1433,  1438,  1442,
    1446,  1450,  1454,  1459,  1463,  1467,  1483,  1487,  1499,  1498,
    1521,  1520,  1547,  1546,  1559,  1558,  1566,  1574,  1588,  1603,
    1621,  1641,  1680,  1688,  1696,  1708,  1640,  1739,  1740,  1744,
    1745,  1750,  1752,  1754,  1756,  1758,  1760,  1762,  1768,  1769,
    1770,  1774,  1778,  1786,  1785,  1798,  1800,  1803,  1805,  1809,
    1813,  1820,  1822,  1826,  1827,  1832,  1851,  1877,  1879,  1883,
    1884,  1888,  1914,  1915,  1916,  1917,  1921,  1922,  1926,  1927,
    1932,  1935,  1962,  1961,  2017,  2032,  2031,  2075,  2099,  2099,
    2130,  2131,  2136,  2138,  2143,  2166,  2172,  2187,  2188,  2192,
    2196,  2205,  2210,  2215,  2223,  2238,  2256,  2257,  2261,  2261,
    2311,  2310,  2334,  2333,  2337,  2338,  2340,  2340,  2351,  2380,
    2408,  2424,  2423,  2440,  2457,  2459,  2460,  2464,  2485,  2508,
    2510,  2524,  2508,  2542,  2544,  2545,  2549,  2550,  2555,  2561,
    2554,  2580,  2579,  2595,  2596,  2600,  2601,  2606,  2610,  2605,
    2627,  2631,  2626,  2646,  2654,  2659,  2658,  2696,  2697,  2702,
    2701,  2728,  2739,  2741,  2738,  2765,  2764,  2782,  2784,  2789,
    2791,  2793,  2798,  2799,  2800,  2806,  2815,  2816,  2816,  2820,
    2822,  2821,  2824,  2823,  2829,  2845,  2828,  2859,  2860,  2863,
    2864,  2867,  2868,  2871,  2872,  2875,  2876,  2879,  2880,  2883,
    2886,  2887,  2889,  2891,  2894,  2895,  2898,  2899,  2900,  2903,
    2904,  2905,  2906,  2907,  2908,  2909,  2910,  2911,  2926,  2932,
    2933,  2934,  2935,  2940,  2945,  2950,  2965,  2966,  2967,  2968,
    2969,  2970,  2974,  2991,  3007,  3017,  3018,  3019,  3020,  3021,
    3022,  3025,  3026,  3027,  3030,  3031,  3032,  3035,  3036,  3039,
    3040,  3043,  3044,  3045,  3046,  3049,  3050,  3054,  3055,  3059,
    3060,  3070,  3084,  3099,  3119,  3126,  3135,  3137,  3141,  3145,
    3146,  3150,  3155,  3154,  3176,  3177,  3178,  3179,  3181,  3183,
    3185,  3187,  3189,  3191,  3194,  3197,  3200,  3203,  3205,  3208,
    3211,  3212,  3213,  3214,  3227,  3228,  3230,  3232,  3244,  3246,
    3248,  3250,  3251,  3252,  3253,  3254,  3255,  3257,  3259,  3261,
    3261,  3263,  3263,  3265,  3266,  3275,  3276,  3277,  3280,  3281,
    3282,  3283,  3284,  3288,  3292,  3293,  3297,  3298,  3302,  3303,
    3304,  3305,  3306,  3310,  3311,  3312,  3313,  3314,  3317,  3319,
    3320,  3324,  3325,  3326,  3329,  3336,  3337,  3340,  3341,  3344,
    3345,  3346,  3349,  3350,  3353,  3354,  3357,  3358,  3361,  3362,
    3365,  3366,  3367,  3368,  3370,  3371,  3377,  3383,  3389,  3395,
    3396,  3412,  3413,  3417,  3418,  3422,  3430,  3434,  3435,  3438,
    3439,  3443,  3452,  3456,  3457,  3460,  3470,  3471,  3475,  3476,
    3479,  3480,  3483,  3484,  3485,  3486,  3495,  3496,  3499,  3500,
    3503,  3504,  3505,  3514,  3516,  3518,  3523,  3522,  3534,  3535,
    3538,  3539,  3543,  3544,  3547,  3548,  3551,  3552,  3553,  3554,
    3555,  3558,  3559,  3560,  3561,  3562,  3565,  3566,  3567,  3579,
    3580,  3583,  3584,  3587,  3588,  3592,  3593,  3594,  3597,  3598,
    3599,  3600,  3613,  3614,  3615,  3618,  3619,  3623,  3624,  3627,
    3628,  3631,  3636,  3641,  3646,  3651,  3656,  3661,  3666,  3672,
    3678,  3683,  3688,  3699,  3700,  3703,  3704,  3715,  3716,  3719,
    3720,  3723,  3724,  3732,  3731,  3758,  3757,  3771,  3770,  3789,
    3788,  3808,  3806,  3826,  3827,  3829,  3830,  3831,  3832,  3833,
    3836,  3844,  3845,  3849,  3854,  3853,  3861,  3870,  3860,  3882,
    3889,  3893,  3900,  3907,  3913,  3919,  3925,  3932,  3950,  3971,
    3976,  3980,  3987,  3988,  3991,  3992,  3996,  3997,  3998,  4002,
    4003,  4004,  4007,  4008,  4009,  4010,  4018,  4017,  4028,  4036,
    4035,  4045,  4055,  4064,  4065,  4072,  4072,  4078,  4079,  4083,
    4084,  4085,  4089,  4090,  4107,  4108,  4113,  4112,  4123,  4122,
    4133,  4132,  4142,  4143,  4144,  4149,  4148,  4160,  4161,  4164,
    4165,  4168,  4169,  4170,  4174,  4173,  4186,  4185,  4202,  4203,
    4206,  4207,  4210,  4211,  4212,  4213,  4214,  4215,  4219,  4218,
    4230,  4231,  4232,  4237,  4236,  4242,  4249,  4254,  4262,  4263,
    4266,  4278,  4287,  4288,  4291,  4304,  4305,  4310,  4309,  4319,
    4320,  4323,  4336,  4336,  4346,  4347,  4356,  4357,  4366,  4375,
    4377,  4380,  4402,  4406,  4405,  4425,  4433,  4425,  4439,  4440,
    4441,  4442,  4443,  4446,  4453,  4460,  4462,  4473,  4474,  4477,
    4478,  4484,  4485,  4486,  4487,  4493,  4499,  4505,  4519,  4522,
    4524,  4530,  4540,  4541,  4542,  4555,  4575,  4582,  4589,  4590,
    4593,  4594,  4595,  4596,  4597,  4601,  4602,  4606,  4655,  4660,
    4701,  4703,  4705,  4707,  4709,  4711,  4713,  4715,  4719,  4721,
    4723,  4725,  4727,  4729,  4732,  4736,  4742,  4746,  4752,  4756,
    4764,  4766,  4772,  4775,  4777,  4779,  4780,  4782,  4785,  4787,
    4789,  4791,  4793,  4795,  4797,  4799,  4801,  4803,  4805,  4807,
    4809,  4811,  4813,  4816,  4816,  4817,  4817,  4818,  4818,  4819,
    4819,  4821,  4822,  4823,  4824,  4825,  4826,  4829,  4830,  4834,
    4839,  4840,  4847,  4848,  4849,  4850,  4851,  4853,  4854,  4855,
    4856,  4857,  4861,  4862,  4867,  4872,  4876,  4877,  4881,  4882,
    4886,  4893,  4895,  4901,  4903,  4914,  4916,  4927,  4938,  4949,
    4960,  4962,  4964,  4966,  4968,  4970,  4972,  4974,  4976,  4978,
    4980,  4982,  4984,  4990,  4992,  4994,  4999,  5004,  5006,  5008,
    5013,  5015,  5017,  5019,  5021,  5026,  5027,  5029,  5031,  5033,
    5035,  5037,  5039,  5041,  5043,  5045,  5047,  5049,  5053,  5055,
    5065,  5067,  5069,  5071,  5073,  5076,  5085,  5090,  5095,  5097,
    5099,  5101,  5103,  5105,  5107,  5109,  5114,  5119,  5121,  5123,
    5125,  5127,  5129,  5131,  5137,  5139,  5141,  5143,  5145,  5147,
    5149,  5151,  5153,  5154,  5160,  5165,  5167,  5169,  5171,  5173,
    5175,  5177,  5179,  5181,  5188,  5195,  5197,  5199,  5201,  5203,
    5205,  5207,  5209,  5211,  5213,  5215,  5217,  5219,  5221,  5223,
    5237,  5236,  5353,  5357,  5362,  5364,  5366,  5368,  5370,  5372,
    5377,  5379,  5381,  5383,  5385,  5390,  5394,  5396,  5398,  5400,
    5402,  5404,  5408,  5411,  5414,  5416,  5418,  5420,  5422,  5424,
    5426,  5429,  5432,  5434,  5436,  5438,  5440,  5442,  5445,  5447,
    5449,  5451,  5456,  5457,  5458,  5462,  5463,  5467,  5467,  5473,
    5477,  5484,  5515,  5517,  5519,  5521,  5523,  5525,  5527,  5530,
    5532,  5529,  5535,  5537,  5544,  5546,  5548,  5550,  5552,  5554,
    5556,  5558,  5560,  5563,  5562,  5577,  5576,  5591,  5597,  5603,
    5616,  5617,  5621,  5624,  5629,  5632,  5644,  5643,  5659,  5660,
    5661,  5662,  5663,  5664,  5665,  5666,  5667,  5668,  5669,  5673,
    5674,  5678,  5678,  5683,  5684,  5687,  5688,  5691,  5691,  5696,
    5697,  5700,  5701,  5704,  5705,  5708,  5714,  5724,  5725,  5734,
    5739,  5740,  5760,  5762,  5766,  5764,  5781,  5779,  5797,  5795,
    5802,  5811,  5809,  5827,  5826,  5836,  5847,  5845,  5864,  5863,
    5874,  5884,  5885,  5886,  5891,  5891,  5910,  5908,  5927,  5949,
    5997,  5996,  6019,  6037,  6019,  6044,  6048,  6074,  6075,  6077,
    6079,  6082,  6083,  6089,  6096,  6105,  6104,  6111,  6112,  6116,
    6120,  6124,  6130,  6138,  6147,  6148,  6149,  6150,  6151,  6152,
    6153,  6154,  6155,  6156,  6157,  6158,  6159,  6162,  6163,  6164,
    6165,  6166,  6167,  6168,  6169,  6170,  6174,  6175,  6176,  6177,
    6180,  6182,  6183,  6186,  6187,  6190,  6192,  6196,  6198,  6197,
    6211,  6214,  6213,  6228,  6234,  6247,  6249,  6252,  6254,  6258,
    6259,  6272,  6290,  6294,  6295,  6299,  6312,  6314,  6318,  6317,
    6349,  6351,  6355,  6356,  6357,  6362,  6368,  6372,  6373,  6377,
    6381,  6388,  6395,  6404,  6408,  6409,  6410,  6415,  6419,  6427,
    6428,  6429,  6430,  6431,  6432,  6436,  6437,  6438,  6439,  6440,
    6443,  6446,  6445,  6474,  6475,  6478,  6479,  6482,  6497,  6497,
    6507,  6508,  6512,  6524,  6557,  6556,  6569,  6568,  6577,  6589,
    6600,  6599,  6616,  6623,  6623,  6635,  6642,  6654,  6666,  6670,
    6676,  6686,  6687,  6690,  6698,  6699,  6702,  6712,  6713,  6717,
    6718,  6726,  6735,  6725,  6745,  6752,  6744,  6762,  6774,  6775,
    6776,  6780,  6781,  6784,  6785,  6788,  6797,  6798,  6799,  6801,
    6800,  6810,  6811,  6814,  6815,  6816,  6816,  6817,  6817,  6821,
    6822,  6825,  6827,  6830,  6838,  6839,  6843,  6844,  6849,  6848,
    6861,  6862,  6865,  6870,  6878,  6879,  6882,  6884,  6884,  6892,
    6901,  6891,  6923,  6924,  6927,  6934,  6935,  6938,  6947,  6948,
    6954,  6953,  6967,  6966,  6975,  6974,  6982,  6981,  6991,  6992,
    6995,  7002,  7015,  7016,  7020,  7021,  7024,  7025,  7026,  7029,
    7039,  7041,  7043,  7045,  7048,  7049,  7052,  7056,  7060,  7064,
    7068,  7072,  7076,  7080,  7084,  7092,  7095,  7104,  7103,  7117,
    7125,  7134,  7143,  7152,  7162,  7161,  7164,  7174,  7184,  7188,
    7193,  7192,  7197,  7207,  7212,  7218,  7223,  7228,  7230,  7232,
    7234,  7236,  7238,  7246,  7255,  7257,  7259,  7261,  7270,  7278,
    7286,  7288,  7290,  7300,  7307,  7313,  7321,  7329,  7333,  7337,
    7344,  7351,  7361,  7371,  7381,  7392,  7401,  7415,  7428,  7429,
    7431,  7433,  7436,  7437,  7440,  7441,  7444,  7445,  7448,  7449,
    7452,  7453,  7455,  7457,  7460,  7472,  7471,  7486,  7485,  7495,
    7496,  7499,  7500,  7504,  7505,  7506,  7514,  7513,  7525,  7526,
    7529,  7529,  7530,  7531,  7532,  7533,  7534,  7535,  7536,  7537,
    7538,  7539,  7542,  7543,  7547,  7546,  7555,  7556,  7559,  7560,
    7561,  7565,  7564,  7574,  7578,  7582,  7594,  7594,  7602,  7603,
    7604,  7609,  7619,  7618,  7634,  7652,  7663,  7670,  7680,  7651,
    7685,  7694,  7695,  7698,  7699,  7711,  7715,  7716,  7717,  7719,
    7721,  7724,  7725,  7728,  7733,  7740,  7745,  7751,  7753,  7756,
    7757,  7760,  7765,  7771,  7773,  7780,  7781,  7782,  7785,  7787,
    7792,  7793,  7798,  7799,  7805,  7823,  7831,  7836,  7855,  7857,
    7868,  7881,  7902,  7903,  7904,  7913,  7914,  7915,  7920,  7921,
    7922,  7923,  7924,  7940,  7954,  7955,  7956,  7959,  7960,  7961,
    7962,  7970,  7985,  7986,  7989,  7995,  8006,  8009,  8046,  8050,
    8058,  8062,  8130,  8145,  8169,  8170,  8186,  8196,  8199,  8200,
    8201,  8205,  8209,  8210,  8235,  8247,  8260,  8272,  8273,  8282,
    8283,  8292,  8293,  8294,  8297,  8310,  8323,  8337,  8338,  8339,
    8340,  8341,  8342,  8343,  8344,  8345,  8346,  8347,  8348,  8349,
    8350,  8351,  8352,  8353,  8354,  8355,  8356,  8357,  8358,  8359,
    8360,  8361,  8362,  8363,  8364,  8365,  8366,  8367,  8368,  8369,
    8370,  8371,  8372,  8373,  8383,  8384,  8385,  8386,  8387,  8388,
    8389,  8390,  8391,  8392,  8393,  8394,  8395,  8396,  8397,  8398,
    8399,  8400,  8401,  8402,  8403,  8404,  8405,  8406,  8407,  8408,
    8409,  8410,  8411,  8412,  8413,  8414,  8415,  8416,  8417,  8418,
    8419,  8420,  8421,  8422,  8423,  8424,  8425,  8426,  8427,  8428,
    8429,  8430,  8431,  8432,  8433,  8434,  8435,  8436,  8437,  8438,
    8439,  8440,  8441,  8442,  8443,  8444,  8445,  8446,  8447,  8448,
    8449,  8450,  8451,  8452,  8453,  8454,  8455,  8456,  8457,  8458,
    8459,  8460,  8461,  8462,  8463,  8464,  8465,  8466,  8467,  8468,
    8469,  8470,  8471,  8472,  8473,  8474,  8475,  8476,  8477,  8478,
    8479,  8480,  8481,  8482,  8483,  8484,  8485,  8486,  8487,  8488,
    8489,  8490,  8491,  8492,  8493,  8494,  8495,  8496,  8497,  8498,
    8499,  8500,  8501,  8502,  8503,  8504,  8505,  8506,  8507,  8508,
    8509,  8510,  8511,  8512,  8513,  8514,  8515,  8516,  8517,  8518,
    8519,  8520,  8521,  8522,  8523,  8524,  8525,  8526,  8527,  8528,
    8529,  8530,  8531,  8532,  8533,  8534,  8535,  8536,  8537,  8538,
    8539,  8540,  8541,  8542,  8543,  8544,  8545,  8546,  8547,  8548,
    8549,  8550,  8551,  8552,  8553,  8554,  8555,  8556,  8557,  8558,
    8559,  8560,  8561,  8562,  8563,  8564,  8565,  8566,  8567,  8568,
    8569,  8570,  8571,  8572,  8573,  8574,  8575,  8576,  8577,  8578,
    8579,  8580,  8581,  8582,  8583,  8584,  8585,  8586,  8587,  8588,
    8589,  8590,  8591,  8592,  8593,  8594,  8595,  8596,  8597,  8598,
    8599,  8600,  8601,  8602,  8603,  8604,  8605,  8606,  8607,  8608,
    8609,  8610,  8611,  8612,  8613,  8614,  8615,  8616,  8617,  8618,
    8625,  8624,  8638,  8639,  8642,  8643,  8646,  8646,  8723,  8724,
    8725,  8726,  8730,  8731,  8735,  8736,  8737,  8738,  8742,  8743,
    8744,  8745,  8749,  8750,  8753,  8833,  8846,  8850,  8855,  8862,
    8877,  8890,  8911,  8918,  8956,  8999,  9013,  9014,  9015,  9016,
    9020,  9021,  9028,  9037,  9038,  9039,  9040,  9041,  9049,  9048,
    9064,  9065,  9068,  9069,  9072,  9080,  9081,  9082,  9083,  9088,
    9087,  9108,  9120,  9133,  9132,  9151,  9152,  9156,  9157,  9161,
    9162,  9163,  9164,  9166,  9165,  9176,  9177,  9178,  9179,  9180,
    9186,  9191,  9198,  9211,  9223,  9230,  9235,  9243,  9256,  9270,
    9272,  9275,  9276,  9283,  9285,  9289,  9290,  9293,  9293,  9294,
    9294,  9295,  9295,  9296,  9296,  9297,  9298,  9299,  9300,  9301,
    9302,  9303,  9304,  9305,  9306,  9307,  9308,  9309,  9310,  9311,
    9312,  9313,  9314,  9315,  9316,  9317,  9318,  9319,  9324,  9325,
    9329,  9330,  9334,  9344,  9354,  9367,  9381,  9394,  9407,  9420,
    9421,  9430,  9431,  9440,  9465,  9467,  9474,  9478,  9481,  9482,
    9485,  9506,  9507,  9511,  9515,  9519,  9526,  9527,  9530,  9531,
    9535,  9536,  9542,  9548,  9554,  9564,  9563,  9573,  9574,  9578,
    9579,  9580,  9584,  9585,  9586,  9590,  9591,  9595,  9605,  9612,
    9622,  9631,  9645,  9646,  9651,  9650,  9685,  9686,  9687,  9691,
    9691,  9715,  9716,  9720,  9721,  9722,  9726,  9731,  9730,  9750,
    9756,  9777,  9799,  9801,  9806,  9808,  9810,  9822,  9832,  9845,
    9847,  9849,  9854,  9859,  9861,  9863,  9869,  9870,  9876,  9877,
    9879,  9885,  9884,  9899,  9900,  9904,  9909,  9917,  9917,  9935,
    9944,  9957,  9958,  9960,  9962,  9975,  9973, 10050, 10049, 10059,
   10088, 10097, 10106, 10058, 10130, 10134, 10138, 10142, 10146, 10150,
   10156, 10163, 10170, 10179, 10180, 10184, 10185, 10186, 10190, 10191,
   10195, 10196, 10196, 10201, 10202
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM",
  "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED",
  "CAST_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONVERT_SYM",
  "CONVERT_TZ_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME", "DATABASE",
  "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FIELD_FUNC",
  "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM",
  "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM",
  "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2",
  "FUNC_ARG3", "GE", "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GEOMFROMTEXT", "GEOMFROMWKB", "GET_FORMAT",
  "GLOBAL_SYM", "GRANT", "GRANTS", "GREATEST_SYM", "GROUP",
  "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS", "GT_SYM", "HANDLER_SYM",
  "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM",
  "LANGUAGE_SYM", "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING",
  "LEAST_SYM", "LEAVES", "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD",
  "LOCAL_SYM", "LOCATE", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM",
  "LOGS_SYM", "LOG_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM",
  "LOOP_SYM", "LOW_PRIORITY", "LT", "MAKE_SET_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_POS_WAIT", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PURGE", "QUARTER_SYM",
  "QUERY_SYM", "QUICK", "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE",
  "RAID_STRIPED_SYM", "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL",
  "RECOVER_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "RENAME", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM",
  "RESTRICT", "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENNA_DELIMITED_SYM", "SENNA_KWIC_SYM", "SENNA_MECAB_SYM",
  "SENNA_NGRAM_SYM", "SENNA_NORMALIZE_SYM", "SENNA_SECTIONALIZE_SYM",
  "SENNA_SPLIT_ALPHA_SYM", "SENNA_SPLIT_DIGIT_SYM",
  "SENNA_SPLIT_SYMBOL_SYM", "SENNA_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM",
  "SERIALIZABLE_SYM", "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SMALLINT", "SNAPSHOT_SYM",
  "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM", "STD_SYM",
  "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM",
  "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE", "TABLE_SYM",
  "TEMPORARY", "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGER_SYM", "TRIGGERS_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "UDF_SONAME_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM", "UNION_SYM",
  "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM",
  "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL",
  "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM", "BETWEEN_SYM",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "NEG",
  "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'", "';'", "':'",
  "$accept", "query", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "@1",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "@2",
  "change", "@3", "master_defs", "master_def", "master_file_def", "create",
  "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "create_function_tail", "@8", "@9", "@10", "@11", "@12", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@13",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@14", "@15", "sp_cursor_stmt",
  "@16", "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "opt_value", "sp_hcond", "sp_decl_idents", "sp_opt_default",
  "sp_proc_stmt", "@17", "@18", "@19", "@20", "@21", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "@22", "@23", "@24", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "@25", "@26",
  "searched_case_stmt", "@27", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@28", "@29",
  "searched_when_clause", "@30", "@31", "else_clause_opt",
  "sp_labeled_control", "@32", "sp_opt_label", "sp_unlabeled_control",
  "@33", "@34", "@35", "@36", "trg_action_time", "trg_event", "create2",
  "create2a", "@37", "create3", "@38", "@39", "create_select", "@40",
  "@41", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_func_type", "udf_type",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "@42", "type", "@43", "@44", "spatial_type",
  "char", "nchar", "varchar", "nvarchar", "int_type", "real_type",
  "float_options", "precision", "field_options", "field_opt_list",
  "field_option", "opt_len", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@45", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "opt_senna_list", "opt_senna_item", "key_list",
  "key_part", "opt_ident", "opt_component", "string_list", "alter", "@46",
  "@47", "@48", "@49", "@50", "ident_or_empty", "alter_list", "add_column",
  "alter_list_item", "@51", "@52", "@53", "opt_column", "opt_ignore",
  "opt_restrict", "opt_place", "opt_to", "slave", "@54", "@55", "start",
  "start_transaction_opts", "slave_thread_opts", "@56",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@57", "backup", "@58", "checksum", "@59",
  "opt_checksum_type", "repair", "@60", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@61", "check", "@62",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@63", "opt_no_write_to_binlog", "rename", "@64", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@65", "preload_list",
  "preload_keys", "cache_keys_spec", "@66", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@67", "select_part2", "@68", "@69", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "bool_pri", "predicate", "bit_expr", "or", "and", "not", "not2",
  "comp_op", "all_or_any", "interval_expr", "simple_expr", "@70",
  "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@71", "udf_expr_list3", "udf_expr", "sum_expr", "@72",
  "@73", "@74", "variable", "@75", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@76",
  "cast_type", "opt_expr_list", "expr_list", "@77", "expr_list2",
  "ident_list_arg", "ident_list", "@78", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@79", "@80", "@81", "@82", "@83",
  "@84", "@85", "normal_join", "table_factor", "@86", "@87",
  "select_derived", "@88", "select_derived2", "@89", "@90",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@91", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@92", "having_clause", "@93", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@94", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@95", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@96",
  "select_var_list", "select_var_ident", "into", "@97", "into_destination",
  "@98", "do", "@99", "drop", "@100", "table_list", "table_name",
  "table_alias_ref_list", "table_alias_ref", "if_exists", "opt_temporary",
  "insert", "@101", "@102", "replace", "@103", "@104",
  "insert_lock_option", "replace_lock_option", "insert2", "insert_table",
  "insert_field_spec", "@105", "fields", "insert_values", "@106", "@107",
  "values_list", "ident_eq_list", "ident_eq_value", "equal", "opt_equal",
  "no_braces", "@108", "opt_values", "values", "expr_or_default",
  "opt_insert_update", "@109", "update", "@110", "@111", "update_list",
  "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@112", "single_multi", "@113", "@114",
  "@115", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "opt_profile_defs", "profile_defs", "profile_def", "opt_profile_args",
  "show", "@116", "show_param", "@117", "@118", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@119", "@120",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@121", "flush_options", "flush_option", "@122",
  "opt_table_list", "reset", "@123", "reset_options", "reset_option",
  "purge", "@124", "purge_options", "purge_option", "kill", "@125",
  "kill_option", "use", "load", "@126", "load_data", "@127", "@128",
  "@129", "@130", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@131", "opt_option", "option_value_list", "option_type_value",
  "@132", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@133",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@134", "handler", "@135", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@136",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@137", "@138", "@139",
  "@140", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@141", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@142",
  "union_opt", "union_order_or_limit", "@143", "order_or_limit",
  "union_option", "subselect", "@144", "subselect_init", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "view_or_trigger_or_sp_tail",
  "definer", "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@145", "view_list_opt",
  "view_list", "view_select", "@146", "view_select_aux",
  "view_check_option", "trigger_tail", "@147", "sp_tail", "@148", "@149",
  "@150", "@151", "@152", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@153",
  "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   124,    38,    45,    43,    42,    47,    37,
      94,   126,   828,    40,    41,    44,    33,   123,   125,    64,
      46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   593,   594,   594,   595,   595,   596,   596,   596,   596,
     596,   596,   596,   596,   596,   596,   596,   596,   596,   596,
     596,   596,   596,   596,   596,   596,   596,   596,   596,   596,
     596,   596,   596,   596,   596,   596,   596,   596,   596,   596,
     596,   596,   596,   596,   596,   596,   596,   596,   596,   596,
     596,   596,   596,   597,   598,   598,   599,   600,   600,   602,
     601,   603,   603,   604,   604,   605,   607,   606,   609,   608,
     610,   610,   611,   611,   611,   611,   611,   611,   611,   611,
     611,   611,   611,   611,   612,   612,   612,   612,   614,   613,
     615,   613,   616,   613,   617,   613,   613,   618,   619,   619,
     620,   621,   622,   623,   624,   625,   620,   626,   626,   627,
     627,   628,   628,   628,   628,   628,   628,   628,   629,   629,
     629,   630,   630,   632,   631,   633,   633,   634,   634,   635,
     635,   636,   636,   637,   637,   638,   639,   640,   640,   641,
     641,   642,   643,   643,   643,   643,   644,   644,   645,   645,
     646,   646,   648,   647,   647,   649,   647,   647,   651,   650,
     652,   652,   653,   653,   654,   655,   655,   656,   656,   657,
     657,   657,   657,   657,   658,   658,   659,   659,   661,   660,
     662,   660,   663,   660,   660,   660,   664,   660,   660,   660,
     660,   665,   660,   660,   666,   666,   666,   667,   667,   669,
     670,   671,   668,   672,   672,   672,   673,   673,   675,   676,
     674,   678,   677,   679,   679,   680,   680,   682,   683,   681,
     685,   686,   684,   687,   687,   689,   688,   690,   690,   692,
     691,   691,   693,   694,   691,   695,   691,   696,   696,   697,
     697,   697,   698,   698,   698,   698,   699,   700,   699,   701,
     702,   701,   703,   701,   705,   706,   704,   707,   707,   708,
     708,   709,   709,   710,   710,   711,   711,   712,   712,   713,
     714,   714,   715,   715,   716,   716,   717,   717,   717,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   719,   720,   721,   722,   722,   722,   722,   722,
     722,   723,   723,   723,   724,   724,   724,   725,   725,   726,
     726,   727,   727,   727,   727,   728,   728,   729,   729,   730,
     730,   731,   731,   731,   731,   731,   732,   732,   733,   734,
     734,   735,   737,   736,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   739,
     738,   740,   738,   738,   738,   741,   741,   741,   741,   741,
     741,   741,   741,   742,   743,   743,   744,   744,   745,   745,
     745,   745,   745,   746,   746,   746,   746,   746,   747,   747,
     747,   748,   748,   748,   749,   750,   750,   751,   751,   752,
     752,   752,   753,   753,   754,   754,   755,   755,   756,   756,
     757,   757,   757,   757,   757,   757,   757,   757,   757,   757,
     757,   758,   758,   759,   759,   760,   760,   761,   761,   762,
     762,   763,   763,   764,   764,   765,   766,   766,   767,   767,
     768,   768,   769,   769,   769,   769,   769,   769,   770,   770,
     771,   771,   771,   771,   772,   772,   774,   773,   775,   775,
     776,   776,   777,   777,   778,   778,   779,   779,   779,   779,
     779,   780,   780,   780,   780,   780,   781,   781,   781,   782,
     782,   783,   783,   784,   784,   785,   785,   785,   786,   786,
     786,   786,   787,   787,   787,   788,   788,   788,   788,   789,
     789,   790,   790,   790,   790,   790,   790,   790,   790,   790,
     790,   790,   790,   791,   791,   792,   792,   793,   793,   794,
     794,   795,   795,   797,   796,   798,   796,   799,   796,   800,
     796,   801,   796,   802,   802,   803,   803,   803,   803,   803,
     804,   805,   805,   805,   806,   805,   807,   808,   805,   805,
     805,   805,   805,   805,   805,   805,   805,   805,   805,   805,
     805,   805,   809,   809,   810,   810,   811,   811,   811,   812,
     812,   812,   813,   813,   813,   813,   815,   814,   814,   816,
     814,   814,   817,   818,   818,   820,   819,   821,   821,   822,
     822,   822,   823,   823,   824,   824,   826,   825,   828,   827,
     830,   829,   831,   831,   831,   833,   832,   834,   834,   835,
     835,   836,   836,   836,   838,   837,   840,   839,   841,   841,
     842,   842,   843,   843,   843,   843,   843,   843,   845,   844,
     846,   846,   846,   848,   847,   847,   849,   849,   850,   850,
     851,   852,   853,   853,   854,   855,   855,   857,   856,   858,
     858,   859,   861,   860,   862,   862,   863,   863,   864,   865,
     865,   866,   866,   868,   867,   870,   871,   869,   872,   872,
     872,   872,   872,   873,   873,   874,   874,   875,   875,   876,
     876,   876,   876,   876,   876,   876,   876,   876,   876,   877,
     877,   877,   878,   878,   878,   879,   880,   881,   882,   882,
     883,   883,   883,   883,   883,   884,   884,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   886,   886,
     886,   886,   886,   886,   887,   887,   887,   887,   887,   887,
     887,   887,   887,   887,   887,   887,   887,   887,   888,   888,
     888,   888,   888,   888,   888,   888,   888,   888,   888,   888,
     888,   888,   888,   889,   889,   890,   890,   891,   891,   892,
     892,   893,   893,   893,   893,   893,   893,   894,   894,   895,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     897,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   898,   898,   898,   898,
     898,   898,   898,   898,   898,   898,   898,   898,   898,   898,
     898,   898,   898,   898,   898,   898,   898,   898,   898,   898,
     898,   898,   899,   899,   899,   900,   900,   902,   901,   903,
     903,   904,   905,   905,   905,   905,   905,   905,   905,   906,
     907,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   905,   905,   908,   905,   910,   909,   911,   911,   911,
     912,   912,   913,   913,   914,   914,   916,   915,   917,   917,
     917,   917,   917,   917,   917,   917,   917,   917,   917,   918,
     918,   920,   919,   921,   921,   922,   922,   924,   923,   925,
     925,   926,   926,   927,   927,   928,   928,   929,   929,   930,
     931,   931,   932,   932,   933,   932,   934,   932,   935,   932,
     932,   936,   932,   937,   932,   932,   938,   932,   939,   932,
     932,   940,   940,   940,   942,   941,   943,   941,   941,   941,
     945,   944,   947,   948,   946,   949,   950,   951,   951,   952,
     952,   953,   953,   953,   953,   955,   954,   956,   956,   957,
     957,   957,   958,   958,   959,   959,   959,   959,   959,   959,
     959,   959,   959,   959,   959,   959,   959,   960,   960,   960,
     960,   960,   960,   960,   960,   960,   961,   961,   961,   961,
     962,   962,   962,   963,   963,   964,   964,   965,   966,   965,
     967,   968,   967,   969,   969,   970,   970,   971,   971,   972,
     972,   972,   973,   974,   974,   975,   976,   976,   978,   977,
     979,   979,   980,   980,   980,   981,   981,   982,   982,   983,
     984,   984,   984,   985,   985,   985,   985,   986,   986,   987,
     987,   987,   987,   987,   987,   988,   988,   988,   988,   988,
     989,   990,   989,   991,   991,   992,   992,   993,   995,   994,
     996,   996,   997,   997,   999,   998,  1001,  1000,  1000,  1000,
    1003,  1002,  1004,  1005,  1004,  1004,  1004,  1004,  1004,  1004,
    1004,  1006,  1006,  1007,  1008,  1008,  1009,  1010,  1010,  1011,
    1011,  1013,  1014,  1012,  1016,  1017,  1015,  1018,  1018,  1018,
    1018,  1019,  1019,  1020,  1020,  1021,  1022,  1022,  1022,  1023,
    1022,  1024,  1024,  1025,  1025,  1026,  1025,  1027,  1025,  1028,
    1028,  1029,  1029,  1030,  1031,  1031,  1032,  1032,  1034,  1033,
    1035,  1035,  1036,  1036,  1037,  1037,  1038,  1039,  1038,  1041,
    1042,  1040,  1043,  1043,  1044,  1045,  1045,  1046,  1047,  1047,
    1049,  1048,  1051,  1050,  1052,  1050,  1053,  1050,  1054,  1054,
    1055,  1055,  1056,  1056,  1057,  1057,  1058,  1058,  1058,  1059,
    1060,  1060,  1061,  1061,  1062,  1062,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1064,  1064,  1066,  1065,  1067,
    1067,  1067,  1067,  1067,  1068,  1067,  1067,  1067,  1067,  1067,
    1069,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1067,  1067,  1067,  1067,  1070,  1070,  1071,  1071,
    1072,  1072,  1073,  1073,  1074,  1074,  1075,  1075,  1076,  1076,
    1077,  1077,  1078,  1078,  1078,  1080,  1079,  1081,  1079,  1082,
    1082,  1083,  1083,  1084,  1084,  1084,  1086,  1085,  1087,  1087,
    1089,  1088,  1088,  1088,  1088,  1088,  1088,  1088,  1088,  1088,
    1088,  1088,  1090,  1090,  1092,  1091,  1093,  1093,  1094,  1094,
    1094,  1096,  1095,  1097,  1098,  1098,  1100,  1099,  1101,  1101,
    1101,  1102,  1104,  1103,  1103,  1106,  1107,  1108,  1109,  1105,
    1105,  1110,  1110,  1111,  1111,  1111,  1112,  1112,  1112,  1113,
    1113,  1114,  1114,  1115,  1115,  1115,  1115,  1116,  1116,  1117,
    1117,  1118,  1118,  1119,  1119,  1120,  1120,  1120,  1121,  1121,
    1122,  1122,  1123,  1123,  1124,  1124,  1124,  1124,  1125,  1125,
    1125,  1126,  1127,  1127,  1127,  1128,  1128,  1128,  1128,  1128,
    1128,  1128,  1128,  1128,  1128,  1128,  1128,  1129,  1129,  1129,
    1129,  1129,  1130,  1130,  1131,  1131,  1132,  1133,  1133,  1134,
    1134,  1135,  1135,  1135,  1136,  1136,  1136,  1136,  1137,  1137,
    1137,  1138,  1139,  1139,  1140,  1141,  1142,  1143,  1143,  1144,
    1144,  1145,  1145,  1145,  1146,  1146,  1146,  1147,  1147,  1147,
    1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,
    1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,
    1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,
    1147,  1147,  1147,  1147,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1150,  1149,  1151,  1151,  1152,  1152,  1154,  1153,  1155,  1155,
    1155,  1155,  1156,  1156,  1157,  1157,  1157,  1157,  1158,  1158,
    1158,  1158,  1159,  1159,  1160,  1160,  1161,  1161,  1161,  1161,
    1161,  1161,  1161,  1162,  1162,  1162,  1163,  1163,  1163,  1163,
    1164,  1164,  1164,  1165,  1165,  1165,  1165,  1165,  1167,  1166,
    1168,  1168,  1169,  1169,  1170,  1171,  1171,  1171,  1171,  1173,
    1172,  1174,  1174,  1175,  1174,  1176,  1176,  1177,  1177,  1178,
    1178,  1178,  1178,  1179,  1178,  1180,  1180,  1180,  1180,  1180,
    1181,  1182,  1182,  1182,  1182,  1183,  1184,  1184,  1184,  1185,
    1185,  1186,  1186,  1187,  1187,  1188,  1188,  1190,  1189,  1191,
    1189,  1192,  1189,  1193,  1189,  1189,  1189,  1189,  1189,  1189,
    1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,
    1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,  1194,  1194,
    1195,  1195,  1196,  1196,  1196,  1197,  1197,  1197,  1197,  1198,
    1198,  1199,  1199,  1200,  1200,  1200,  1201,  1201,  1202,  1202,
    1203,  1204,  1204,  1204,  1204,  1204,  1205,  1205,  1206,  1206,
    1207,  1207,  1207,  1207,  1207,  1209,  1208,  1210,  1210,  1211,
    1211,  1211,  1212,  1212,  1212,  1213,  1213,  1214,  1215,  1215,
    1216,  1217,  1218,  1218,  1220,  1219,  1221,  1221,  1221,  1223,
    1222,  1224,  1224,  1225,  1225,  1225,  1226,  1227,  1226,  1228,
    1229,  1230,  1231,  1231,  1232,  1232,  1232,  1233,  1233,  1234,
    1234,  1234,  1235,  1236,  1236,  1236,  1237,  1237,  1238,  1238,
    1238,  1240,  1239,  1241,  1241,  1242,  1242,  1244,  1243,  1245,
    1245,  1246,  1246,  1246,  1246,  1248,  1247,  1250,  1249,  1251,
    1252,  1253,  1254,  1249,  1255,  1255,  1255,  1255,  1255,  1255,
    1256,  1256,  1256,  1257,  1257,  1258,  1258,  1258,  1259,  1259,
    1260,  1261,  1260,  1262,  1262
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       4,     0,     0,     0,     0,     0,    12,     0,     2,     0,
       2,     2,     2,     2,     2,     3,     3,     1,     1,     1,
       2,     3,     3,     0,     4,     0,     3,     0,     1,     3,
       1,     0,     1,     3,     1,     0,     3,     0,     1,     3,
       1,     4,     0,     1,     1,     1,     0,     3,     2,     3,
       0,     3,     0,     5,     5,     0,     7,     5,     0,     2,
       1,     1,     1,     3,     1,     1,     3,     0,     1,     1,
       1,     1,     2,     1,     1,     3,     0,     2,     0,     2,
       0,     3,     0,     5,     1,     1,     0,     2,     2,     2,
       2,     0,     6,     2,     0,     2,     1,     1,     3,     0,
       0,     0,     7,     0,     2,     2,     1,     1,     0,     0,
       8,     0,     6,     1,     2,     1,     2,     0,     0,     6,
       0,     0,     6,     0,     2,     0,     5,     0,     1,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     2,     2,     4,     4,     0,     4,     0,
       0,     5,     0,     7,     0,     0,     6,     0,     1,     0,
       1,     1,     2,     1,     1,     0,     1,     1,     2,     1,
       0,     3,     0,     1,     1,     2,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     1,     1,     3,     4,
       4,     3,     4,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     1,     1,     1,     1,     3,     1,     1,     2,
       2,     6,     7,     8,     2,     2,     0,     1,     2,     0,
       1,     2,     0,     4,     3,     3,     3,     1,     4,     1,
       1,     5,     2,     5,     2,     4,     1,     5,     5,     4,
       3,     1,     1,     2,     1,     1,     2,     1,     1,     1,
       2,     3,     2,     3,     2,     2,     3,     3,     3,     0,
       6,     0,     6,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     2,     1,
       2,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     3,     1,     5,     0,     1,     2,     1,     1,
       1,     1,     0,     3,     0,     1,     0,     1,     2,     1,
       1,     2,     2,     4,     1,     3,     2,     1,     2,     2,
       2,     2,     1,     2,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       0,     1,     0,     2,     1,     2,     3,     2,     0,     1,
       0,     1,     1,     2,     0,     1,     0,     4,     1,     4,
       3,     1,     0,     1,     2,     1,     3,     3,     2,     2,
       2,     1,     1,     2,     2,     2,     1,     2,     2,     2,
       2,     1,     1,     0,     1,     1,     1,     1,     0,     1,
       1,     1,     0,     2,     2,     1,     1,     1,     1,     1,
       3,     1,     2,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     2,     1,     4,     0,     1,     0,
       2,     1,     3,     0,     6,     0,     5,     0,     5,     0,
       5,     0,    11,     0,     1,     0,     2,     2,     1,     3,
       2,     3,     2,     4,     0,     6,     0,     0,     8,     4,
       4,     3,     3,     2,     2,     6,     5,     3,     5,     1,
       1,     1,     0,     1,     0,     1,     0,     1,     1,     0,
       2,     1,     0,     1,     1,     1,     0,     5,     3,     0,
       5,     3,     3,     0,     3,     0,     2,     1,     3,     0,
       1,     1,     0,     2,     1,     3,     0,     6,     0,     6,
       0,     5,     0,     1,     1,     0,     6,     0,     1,     1,
       2,     1,     1,     1,     0,     6,     0,     5,     0,     1,
       1,     2,     1,     1,     1,     1,     1,     2,     0,     6,
       0,     1,     1,     0,     4,     4,     3,     5,     1,     3,
       3,     5,     1,     3,     2,     1,     1,     0,     6,     1,
       3,     3,     0,     2,     0,     4,     0,     2,     1,     2,
       4,     2,     3,     0,     3,     0,     0,     6,     2,     1,
       1,     2,     2,     8,     4,     0,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     4,     3,     1,     1,     4,     0,     0,     1,     1,
       0,     2,     2,     1,     1,     0,     2,     3,     3,     3,
       2,     3,     4,     3,     4,     3,     4,     1,     3,     4,
       3,     3,     6,     1,     5,     6,     5,     7,     6,     8,
       5,     6,     4,     4,     5,     3,     4,     1,     3,     3,
       3,     3,     3,     3,     4,     4,     3,     3,     3,     3,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     3,     1,     1,     1,     1,     3,     2,     2,     2,
       2,     3,     3,     5,     6,     4,     4,     7,     4,     2,
       6,     5,     6,     6,     4,     4,     3,     4,     6,     8,
       6,     8,     6,     4,     6,     4,     6,     4,     4,     4,
       4,     6,     8,     2,     2,     4,     2,     7,     7,     3,
       4,     4,     6,     6,     4,     6,     6,     6,     4,     6,
       4,     6,     8,    10,    12,     6,     4,     6,     6,     1,
       6,     4,     8,    10,     4,     1,     3,     4,     6,     6,
       8,     6,     6,     4,     6,     6,     8,     4,     4,     6,
       4,     2,     4,     4,     4,     6,     4,     4,     3,     8,
       6,     4,     6,     3,     4,     6,     8,     4,     8,     6,
       8,     6,     8,     2,     4,     4,     4,     6,     8,     8,
       4,     7,     7,     7,     6,     6,     6,     6,     6,     6,
       0,     5,    10,     3,     4,     3,     2,     2,     2,     4,
       6,     4,     4,     6,     6,     6,     6,     4,     6,     4,
       6,     4,     4,     4,     4,     6,     4,     6,     4,     6,
       4,     4,     6,     4,     6,     4,     6,     4,     4,     6,
       4,     6,     0,     3,     3,     0,     1,     0,     2,     1,
       3,     4,     4,     5,     4,     4,     4,     5,     4,     0,
       0,     7,    10,     4,     5,     4,     5,     4,     4,     4,
       4,     4,     5,     0,     8,     0,     3,     3,     1,     4,
       0,     1,     0,     2,     0,     1,     0,     3,     2,     3,
       2,     1,     2,     1,     2,     1,     1,     1,     2,     0,
       1,     0,     2,     1,     3,     1,     3,     0,     2,     1,
       3,     0,     1,     0,     2,     4,     5,     1,     1,     1,
       1,     3,     3,     3,     0,     6,     0,     6,     0,     8,
       4,     0,     8,     0,    10,     6,     0,     8,     0,    10,
       6,     1,     2,     2,     0,     4,     0,    11,     3,     6,
       0,     3,     0,     0,     5,     0,     1,     0,     1,     0,
       2,     0,     2,     2,     2,     0,     6,     0,     1,     3,
       1,     1,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     1,     0,     2,     0,     1,     0,     0,     3,
       0,     0,     3,     2,     0,     0,     4,     4,     2,     0,
       2,     2,     3,     3,     1,     2,     0,     1,     0,     4,
       4,     2,     0,     1,     1,     0,     1,     0,     1,     2,
       1,     3,     3,     1,     1,     1,     1,     0,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     0,     6,     0,     1,     3,     1,     2,     0,     2,
       3,     1,     2,     1,     0,     3,     0,     5,     2,     1,
       0,     3,     6,     0,     6,     4,     4,     4,     4,     5,
       4,     1,     3,     1,     1,     3,     1,     0,     2,     0,
       1,     0,     0,     8,     0,     0,     6,     0,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     3,     4,     0,
       3,     3,     1,     2,     2,     0,     3,     0,     5,     3,
       1,     3,     1,     3,     1,     1,     0,     1,     0,     4,
       0,     1,     3,     1,     1,     1,     0,     0,     6,     0,
       0,    11,     3,     1,     3,     3,     1,     3,     0,     1,
       0,     4,     0,     6,     0,     5,     0,     6,     1,     3,
       3,     5,     0,     2,     0,     2,     1,     1,     1,     3,
       0,     1,     0,     1,     1,     3,     1,     1,     2,     2,
       2,     1,     1,     1,     1,     0,     3,     0,     3,     2,
       4,     4,     4,     4,     0,     4,     6,    16,     2,     2,
       0,     6,     5,     2,     2,     2,     1,     5,     5,     2,
       2,     1,     4,     3,     2,     2,     2,     3,     2,     2,
       2,     1,     1,     3,     4,     3,     3,     2,     2,     3,
       3,     3,     3,     3,     3,     4,     1,     1,     1,     1,
       0,     1,     0,     2,     0,     1,     1,     1,     0,     2,
       0,     2,     0,     2,     2,     0,     4,     0,     4,     1,
       1,     0,     1,     0,     1,     1,     0,     4,     3,     1,
       0,     3,     4,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     0,     3,     3,     1,     1,     1,
       2,     0,     3,     3,     2,     2,     0,     4,     0,     1,
       1,     2,     0,     4,     5,     0,     0,     0,     0,    18,
       2,     0,     1,     0,     1,     1,     0,     1,     1,     0,
       2,     2,     1,     3,     4,     3,     3,     0,     2,     2,
       1,     3,     3,     0,     3,     0,     3,     2,     3,     1,
       1,     2,     0,     2,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     5,     1,     1,     1,     1,
       1,     3,     4,     5,     1,     5,     3,     2,     1,     3,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     4,     0,     1,     1,     3,     0,     2,     1,     1,
       1,     1,     0,     1,     0,     1,     1,     1,     0,     2,
       2,     2,     1,     2,     4,     5,     4,     6,     2,     3,
       3,     3,     5,     1,     3,     3,     2,     2,     2,     1,
       1,     4,     4,     1,     1,     1,     1,     1,     0,     4,
       1,     1,     1,     3,     3,     1,     1,     2,     2,     0,
       3,     4,     3,     0,     7,     1,     2,     1,     1,     1,
       1,     1,     1,     0,     5,     1,     1,     1,     1,     1,
       3,     6,     6,     6,     7,     3,     8,     8,     8,     0,
       1,     1,     2,     0,     1,     1,     3,     0,     3,     0,
       3,     0,     3,     0,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     3,
       2,     2,     2,     2,     2,     2,     2,     2,     0,     1,
       3,     1,     2,     2,     2,     1,     3,     3,     1,     1,
       3,     1,     3,     4,     5,     1,     0,     3,     3,     1,
       1,     0,     2,     2,     2,     2,     0,     2,     2,     1,
       2,     2,     2,     2,     2,     0,     3,     0,     1,     0,
       3,     2,     0,     1,     2,     0,     1,     4,     4,     5,
       2,     3,     0,     1,     0,     4,     0,     1,     1,     0,
       2,     2,     1,     0,     1,     1,     4,     0,     7,     1,
       0,     0,     2,     3,     1,     1,     1,     0,     3,     1,
       2,     1,     2,     3,     3,     3,     0,     1,     0,     3,
       3,     0,     8,     0,     3,     1,     3,     0,     2,     3,
       5,     0,     3,     4,     4,     0,    14,     0,     6,     0,
       0,     0,     0,    12,     4,     4,     3,     4,     3,     2,
       1,     3,     5,     1,     1,     0,     1,     1,     0,     2,
       0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     2,  2026,   650,     0,  1975,     0,     0,     0,     0,
       0,  1977,    94,    54,  1280,  1389,  1390,  1200,  1219,     0,
     650,    97,     0,    66,  1221,  1426,     0,     0,   650,     0,
    1421,     0,     0,   650,  1224,  1414,     0,    97,  1977,     0,
     685,  1812,  1317,     0,     0,     0,  1300,  1869,  1269,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   678,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1391,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   553,     0,   585,
       0,     0,  2027,  2017,   652,   651,     0,  1861,  1860,   618,
    1977,     0,  1574,  1575,  1576,  1577,  1578,  1579,  1580,  1538,
    1581,  1582,  1583,  1539,  1540,  1584,  1585,  1586,  1587,  1589,
    1588,  1590,  1541,  1542,  1591,  1592,  1593,  1543,  1544,  1594,
    1595,  1545,  1596,  1597,  1598,  1546,  1599,  1547,  1600,  1601,
    1602,  1603,  1604,  1548,  1605,  1606,  1607,  1608,  1609,  1610,
    1611,  1549,  1612,  1613,  1614,  1615,  1631,  1616,  1550,  1617,
    1618,  1619,  1632,  1551,  1622,  1621,  1620,  1623,  1624,  1625,
    1552,  1626,  1627,  1628,  1629,  1634,  1635,  1636,  1553,  1630,
    1637,  1633,  1795,  1639,  1638,  1640,  1642,  1641,  1554,  1643,
    1555,  1644,  1645,  1522,  1646,  1523,  1648,  1649,  1652,  1653,
    1647,  1654,  1655,  1650,  1651,  1556,  1657,  1658,  1659,  1660,
    1661,  1662,  1663,  1673,  1666,  1668,  1669,  1671,  1667,  1672,
    1676,  1675,  1677,  1678,  1679,  1674,  1665,  1670,  1680,  1681,
    1664,  1682,  1683,  1684,  1685,  1686,  1687,  1688,  1689,  1690,
    1692,  1691,  1693,  1694,  1695,  1696,  1697,  1699,  1698,  1700,
    1701,  1702,  1704,  1703,  1705,  1557,  1706,  1707,  1708,  1709,
    1710,  1558,  1711,  1712,  1713,  1714,  1715,  1716,  1717,  1559,
    1718,  1719,  1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,
    1728,  1729,  1730,  1731,  1732,  1733,  1734,  1735,  1656,  1736,
    1560,  1737,  1738,  1561,  1739,  1562,  1740,  1741,  1563,  1742,
    1743,  1744,  1745,  1746,  1747,  1564,  1748,  1565,  1749,  1750,
    1751,  1752,  1753,  1754,  1755,  1756,  1757,  1758,  1760,  1759,
    1761,  1763,  1764,  1566,  1762,  1567,  1765,  1766,  1767,  1769,
    1768,  1770,  1771,  1568,  1772,  1569,  1773,  1774,  1775,  1776,
    1777,  1778,  1779,  1780,  1781,  1782,  1783,  1784,  1785,  1788,
    1789,  1790,  1791,  1786,  1787,  1570,  1792,  1793,  1794,  1796,
    1797,  1571,  1798,  1799,  1573,  1800,  1801,  1804,  1802,  1803,
    1805,  1806,  1807,  1808,  1572,  1809,   123,  1527,    99,  1528,
    1537,     0,   620,   636,  1978,  1979,   270,   510,   511,   269,
     509,    97,  2017,     0,   266,   267,     0,  1294,  1021,  1217,
    1217,     0,  1217,  1220,  1217,    97,  1217,     0,    59,  1396,
       0,     0,     0,     0,  1521,     0,  1227,  1428,  1432,     0,
       0,  1858,     0,     0,     0,     0,    97,   653,     0,  1278,
       0,   616,     0,  1979,  1990,   679,   683,   695,  1813,  1810,
    1374,   605,   605,   605,   603,   605,  1301,     0,     0,  1278,
    1431,  2063,     0,     0,     0,  2059,     0,  2064,     0,   685,
       0,     0,     1,     3,     0,  1627,  1387,  1385,  1518,     0,
     545,   554,   549,   547,     0,     0,  2028,   634,     0,  1976,
       0,   662,   672,   125,     0,    68,     0,     0,     0,  1982,
       0,     0,     0,     0,    95,   319,  2017,  2019,  2021,   270,
     268,     0,  1298,  1297,  1296,     0,  1294,  1201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1217,    61,     0,
    1903,  1918,  1919,  1915,  1920,  1921,  1925,     0,  1917,  1909,
       0,  1924,  1913,  1922,     0,  1907,     0,  1923,  1928,  1911,
    1916,  1895,     0,  1901,  1905,  1520,  1120,  1872,  1873,     0,
    1533,  1524,  1532,  1531,    67,  1229,  1230,  1228,   584,  1429,
    1430,     0,  1443,     0,     0,     0,   648,     0,  1369,  1368,
       0,  1422,  1991,     0,     0,   625,  1232,  1279,     0,  1231,
    1419,     0,  1418,  1415,  1417,     0,  1903,  1890,     0,  1985,
    1982,  1992,   708,   701,   700,   703,   704,   707,   705,   706,
     702,   699,   716,   696,   698,  1816,     0,     0,   444,     0,
    1382,     0,     0,     0,  1382,     0,  1155,  1375,     0,  1825,
    1352,   507,   506,     0,   505,  1826,  1351,  1368,     0,     0,
       0,  1336,     0,  1302,  1341,     0,  1827,     0,  1371,     0,
    1155,  1382,     0,  1318,     0,     0,     0,     0,   599,   609,
     601,   596,     0,   602,   598,  1299,  1213,  1870,   584,  1480,
    1479,  1525,  2060,  1478,  2068,  2070,  2056,  2058,  2065,   681,
       0,  1996,    53,     0,  1393,  2024,  2025,  2023,   460,   107,
     107,   543,     0,     0,     0,     0,     0,  1211,     0,     0,
     664,   674,   127,   124,    98,     0,   622,   638,  1981,     0,
       0,  1983,  1987,   778,   777,     0,    92,   725,  1534,  1955,
      96,  1951,  2022,   320,   716,   716,   716,  2012,     0,  2014,
    2015,  2016,  2028,  2020,     0,   512,     0,  1281,  1284,  1288,
    1292,  1295,  1575,  1538,     0,  1583,     0,     0,  1491,     0,
       0,     0,     0,  1543,     0,     0,  1597,     0,     0,  1548,
       0,     0,     0,   725,   725,   725,     0,     0,     0,  1610,
    1611,  1500,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1488,     0,  1501,     0,     0,     0,     0,     0,
       0,     0,  1639,     0,     0,  1640,     0,     0,     0,  1490,
    1645,     0,     0,     0,     0,     0,     0,     0,  1660,     0,
       0,  1498,     0,     0,  1027,     0,  1687,  1689,     0,     0,
       0,  1693,     0,     0,  1694,  1695,  1696,  1475,   780,     0,
     725,  1487,  1497,  1708,  1714,  1481,     0,  1716,     0,  1717,
       0,  1724,     0,     0,     0,     0,     0,     0,  1746,  1748,
    1750,     0,     0,  1775,     0,     0,     0,   725,  1474,  1788,
    1789,  1790,  1791,     0,  1489,  1570,  1499,     0,     0,     0,
    1800,   725,   725,   725,     0,     0,     0,  1806,     0,  1809,
    1031,     0,     0,     0,     0,   779,     0,   995,     0,  1023,
     737,   743,   757,     0,   865,   772,   859,   795,   794,  1022,
    1485,   793,   792,  1486,   790,  1508,  1527,  1507,  1218,  1205,
    1206,     0,  1207,  1210,  1949,  1208,   586,     0,     0,    60,
    1410,  1404,  1406,  1409,  1405,     0,  1411,  1408,  1407,  1861,
    1397,  1399,  1400,  1904,  1902,  1936,  1935,     0,  1937,  1933,
    1926,  1956,  1930,  1956,  1932,  1931,  1956,  1927,  1934,  1956,
    1899,     0,  1121,  1122,     0,  1871,     0,  1519,     0,  1427,
    1444,     0,  1445,  1433,  1441,   667,     0,  1120,  1859,  1862,
       0,     0,    56,    57,     0,   655,     0,   654,   658,     0,
       0,     0,  1235,  1225,  1234,  1420,     0,     0,  1902,  1899,
    1986,     0,  1988,  2003,   684,  1993,   714,   686,   713,     0,
     697,  1811,  1814,  1822,  1350,  1378,   443,     0,     0,  1349,
    1333,     0,   270,     0,     0,     0,     0,  1319,  1324,   304,
       0,  1340,  1156,     0,  1382,     0,  1344,  1357,  1345,     0,
    1372,     0,  1382,  1314,     0,     0,  1306,  1311,  1307,     0,
    1313,  1312,  1315,  1303,  1304,  1372,  1329,  1358,  1372,  1334,
    1339,  1348,  1376,  1377,     0,  1328,  1335,     0,  1346,  1372,
    1372,  1382,  1382,   612,   611,   610,   606,   607,   612,     0,
    1064,     0,     0,  2057,  2071,  2055,  2066,  2067,  2054,   682,
    1997,   680,  1998,     0,  1388,  1386,  1394,  1395,   461,   460,
     261,   264,   263,     0,   550,   548,   460,  2018,     0,     0,
     638,     0,     0,   666,   661,   665,   663,   502,   501,   504,
       0,   673,     0,   128,   130,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      69,    70,    83,   624,   623,   621,   646,   645,   643,     0,
     644,   642,   637,   639,   640,  1980,  1984,   271,   460,     0,
    1536,     0,     0,     0,     0,     0,     0,     0,  2013,    88,
       0,     0,     0,  1286,  1214,  1282,     0,     0,     0,  1120,
       0,     0,     0,  1125,     0,   809,  1125,  1125,  1125,     0,
       0,  1021,  1021,     0,  1021,     0,     0,     0,     0,  1125,
     833,   836,     0,   834,     0,     0,     0,     0,     0,  1494,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1021,
       0,     0,     0,     0,  1000,     0,     0,     0,     0,   789,
       0,     0,     0,     0,  1021,     0,     0,     0,     0,  1027,
       0,  1025,     0,  1125,     0,     0,  1125,     0,     0,     0,
       0,     0,  1021,  1021,  1021,   730,     0,   881,     0,     0,
       0,     0,     0,  1021,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1021,  1125,  1125,     0,     0,     0,
    1125,     0,   903,     0,  1496,     0,     0,     0,  1495,     0,
       0,  1493,  1492,  1476,     0,     0,     0,   926,   928,   927,
    1125,     0,  1125,     0,     0,     0,  1032,     0,   798,   797,
     799,  2010,     0,     0,     0,     0,     0,     0,   776,   775,
     774,   773,     0,     0,     0,   781,     0,   782,   783,     0,
     784,   785,   786,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   800,  1095,  1096,  1097,  1098,  1107,  1110,  1099,
    1100,  1101,  1109,  1102,  1103,  1104,  1111,  1112,  1113,  1105,
    1114,  1108,  1106,  1115,     0,  1094,     0,     0,     0,  1477,
     920,     0,  1203,     0,   588,   587,  1209,   586,     0,    62,
      64,  1403,     0,     0,  1412,  1929,     0,  1910,  1914,  1908,
    1912,     0,     0,  1900,     0,  1906,  1124,  1635,  1703,     0,
    1127,  1875,  1222,  1440,  1442,     0,     0,  1434,     0,     0,
     638,    58,     0,     0,  1423,     0,     0,     0,     0,   627,
    1233,     0,  1416,     0,     0,     0,     0,     0,  1989,  2005,
    2004,  1994,   716,  1146,   717,   719,   718,  1507,  1816,  1819,
    1820,  1823,  1821,     0,  1818,  1817,  1832,     0,  1380,  1383,
    1384,     0,     0,  1360,  1359,  1355,  1356,     0,  1165,  1166,
    1164,  1159,  1160,  1163,  1364,  1362,  1353,     0,  1382,     0,
    1363,  1361,  1308,  1309,  1310,     0,  1155,     0,  1382,  1382,
    1372,     0,  1382,  1382,  1343,  1347,     0,   600,   609,   597,
     604,  1076,  1075,     0,  1040,     0,  1039,  1038,  1037,     0,
    1075,  2061,  2069,  2073,     0,  1155,  2002,  2000,   262,  1256,
    1256,     0,     0,     0,     0,     0,     0,     0,   108,   117,
     582,   582,  1256,  1256,   582,  1256,  1256,  1256,     0,     0,
    1256,     0,     0,   582,     0,  1256,   580,     0,     0,  1256,
    1256,  1256,   582,     0,  1256,  1256,  1256,  1256,  1256,   592,
    1256,  1256,  1256,   579,   274,   296,   297,   544,     0,   558,
     581,  2029,  2030,   551,   635,   619,  1212,     0,   126,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   647,   641,    93,   460,
     726,  1535,     0,  1952,  2049,     0,     0,  2031,   272,   515,
    1173,  1174,   517,  1170,  1171,     0,  1169,   516,   528,   529,
     530,   523,   531,   525,   526,   527,   521,  1172,   514,   518,
     519,   532,   513,     0,     0,     0,  1127,  1289,  1064,  1293,
    1292,  1290,     0,     0,     0,  1126,  1125,     0,  1006,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   979,     0,  1006,     0,   839,     0,     0,
       0,     0,     0,     0,  1507,     0,     0,     0,     0,     0,
    2010,     0,     0,     0,     0,     0,     0,   816,     0,     0,
       0,     0,     0,     0,     0,  1118,  1116,  1119,  1117,     0,
       0,  1001,   993,     0,     0,     0,     0,   866,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1028,
    1029,  1125,     0,     0,     0,  1125,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   888,     0,     0,     0,     0,     0,
     893,     0,     0,     0,     0,     0,     0,     0,     0,  1125,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   923,     0,   925,     0,     0,  1510,  1509,     0,
       0,     0,     0,     0,  1033,   685,     0,   802,  1021,   801,
       0,  1828,   996,   998,     0,   728,   727,   729,   740,   733,
     738,   731,   735,     0,   787,  1580,   741,     0,   769,     0,
    1134,   770,   755,   760,   761,     0,     0,   758,   759,   763,
     865,   762,   865,   766,   767,   768,   771,     0,     0,     0,
       0,     0,   791,   796,  1024,   967,  1511,  1204,  1950,  1202,
      65,     0,     0,  1398,  1413,  1401,  1960,     0,  1959,  1945,
    1948,  1518,     0,     0,     0,  1885,  1879,  1886,  1888,  1882,
    1887,  1889,  1880,  1881,  1876,  1883,  1128,  1157,     0,     0,
     668,   669,   672,     0,  1865,  1866,  1864,  1863,   649,  1425,
    1424,     0,   656,   659,   660,   632,   631,   633,   626,   628,
     629,   254,  1239,     0,     0,     0,  1245,  1226,  1236,   617,
       0,     0,     0,     0,     0,   712,  1064,  1194,   709,   690,
    1157,  1147,   689,   720,     0,  1815,     0,  1786,  1843,     0,
       0,     0,     0,     0,  1833,  1379,     0,  1330,     0,  1354,
    1367,  1366,  1325,     0,     0,     0,  1323,  1373,     0,  1342,
    1305,  1365,  1322,  1127,  1372,  1320,  1321,   614,   613,   608,
    1075,  1064,     0,     0,  1061,  1077,     0,  1077,  1064,  1064,
       0,  1064,  1120,  1072,     0,     0,  2072,  1148,  2001,  1254,
    1255,  1257,     0,     0,   111,   114,   112,     0,   113,     0,
       0,   583,   537,   503,   503,   562,     0,   336,   537,   496,
     560,     0,     0,     0,     0,     0,     0,     0,     0,  1256,
       0,   573,   556,     0,     0,     0,     0,   574,     0,   557,
    1256,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   595,   594,   593,     0,     0,     0,     0,   275,   460,
     339,     0,   589,   336,   342,  1514,  2033,  1091,     0,  1090,
     129,    76,    72,    84,  1178,  1179,  1177,  1175,  1176,    85,
      74,    75,    79,    78,    80,    81,    82,    77,    73,    86,
      87,    71,     0,  1953,     0,   238,   237,     0,  2047,  2033,
       0,   339,    89,  1446,   273,   276,   524,   522,     0,    90,
    1215,  1216,  1064,  1146,  1127,     0,  1120,     0,   808,   823,
       0,     0,   972,     0,     0,   974,   975,   976,     0,   827,
       0,   825,   828,   829,   830,  1021,     0,     0,     0,     0,
    1021,   978,     0,   835,     0,     0,   840,   841,     0,   814,
       0,   848,     0,   850,     0,  1021,     0,   844,     0,   805,
       0,     0,  1021,     0,   856,     0,   817,     0,     0,   958,
       0,   941,   937,     0,   939,     0,     0,  1021,  1021,     0,
     861,     0,     0,   867,  1021,     0,   960,     0,   942,     0,
     873,     0,  1021,     0,  1026,     0,     0,     0,   985,   877,
     878,     0,   983,   944,     0,     0,   880,   946,     0,   948,
       0,   943,   950,   951,   882,   884,   883,   953,     0,     0,
     955,     0,   957,     0,   886,   887,     0,     0,     0,   891,
       0,  1021,   897,   894,   987,   989,     0,     0,     0,     0,
       0,   991,   904,   906,     0,     0,     0,   905,     0,     0,
       0,     0,     0,     0,     0,   910,     0,     0,   924,   990,
     815,   988,   929,     0,   932,     0,   931,     0,     0,     0,
       0,  2009,  2011,     0,     0,   806,     0,     0,     0,     0,
       0,  1512,   734,   739,   732,   736,     0,     0,     0,     0,
     753,   752,     0,   765,   764,     0,  1134,   756,     0,   864,
       0,   966,   716,  1021,     0,    63,  1402,  1957,     0,     0,
       0,     0,     0,     0,     0,     0,  1874,  1158,  1266,  1526,
    1435,     0,   676,  1867,  1868,     0,   630,   695,     0,  1258,
    1243,  1250,  1244,     0,     0,     0,  1242,  1503,  1502,  1509,
    1992,     0,     0,     0,     0,  1995,  1127,  1127,  1188,     0,
       0,   687,   692,   688,   691,     0,   715,   724,   723,  1504,
    1511,     0,     0,     0,     0,   446,   448,   447,   456,     0,
     445,     0,     0,  1828,     0,   452,   454,   453,  1838,   451,
    1381,  1155,  1338,  1337,  1162,  1161,     0,  1316,  1332,  1382,
       0,  1999,  1070,     0,  1063,  1062,  1078,     0,  1064,  1077,
    1077,     0,  1043,  1042,  1270,  1273,     0,  1041,  1081,  1068,
     695,  2062,  2074,     0,   459,   458,   303,   455,   302,   116,
     115,   121,   122,   341,   538,   497,   498,     0,     0,     0,
     503,   335,   537,   334,   337,   512,     0,   286,   283,   564,
     289,   285,   301,     0,     0,   290,   537,   571,   572,   586,
     279,     0,   315,   316,   314,   298,   281,   282,   566,  1142,
    1144,  1152,   288,   287,   284,   293,   294,   312,   311,   292,
     313,   577,   310,   308,   305,   307,   306,   309,   291,   280,
       0,   559,     0,   325,   327,   328,  1517,     0,   591,   561,
       0,   329,   330,     0,     0,     0,     0,   675,     0,  1954,
    2050,   241,   239,   240,     0,     0,     0,   244,     0,   242,
       0,     0,  1448,  1447,   243,   257,   460,   277,   520,     0,
    1127,  1167,  1285,  1291,     0,     0,     0,   973,  1007,     0,
     422,   422,  1017,  1015,   411,   422,  1011,  1016,  1013,     0,
       0,     0,     0,     0,     0,     0,   980,   977,     0,     0,
       0,  1511,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1004,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     962,  1030,   986,   984,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   992,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1034,
     811,  2006,  2007,   803,  1829,  1830,  1831,   539,   997,     0,
     746,  1021,   744,  1133,   750,     0,     0,   754,     0,   921,
       0,   968,   969,     0,  1020,  1513,  1958,  1947,  1946,  1961,
    1961,  1961,     0,  1129,     0,  1223,  1446,   670,     0,   671,
     657,   716,  1240,  1252,     0,  1260,     0,     0,  1237,  1247,
       0,     0,     0,  1246,     0,  1892,  1893,  1891,  1157,  1135,
       0,     0,  1199,     0,  1195,   710,     0,   722,   721,     0,
    1845,     0,  1844,  1856,  1857,  1854,  1855,  1853,  1834,     0,
    1840,  1839,     0,     0,     0,  1850,  1841,     0,     0,  1331,
       0,  1326,   615,     0,  1064,  1077,  1064,  1050,     0,     0,
    1064,  1046,  1044,  1048,     0,  1127,     0,     0,     0,     0,
    1065,   716,  1506,  1149,  1152,   338,   537,   499,   500,   512,
       0,     0,     0,     0,   456,   299,   570,   569,   300,     0,
       0,  1153,  1154,  1145,     0,   563,   339,   590,   476,   407,
     356,   347,   422,   350,   349,   393,   364,   361,   411,   409,
     379,   411,   411,   386,   385,   403,   389,   369,   462,   462,
     368,   406,   462,   390,   388,   392,     0,   394,   411,   399,
     387,   391,   408,   384,   381,   405,   422,   422,   362,   365,
     404,   462,     0,   397,   422,   426,   367,   462,   468,     0,
       0,   422,   424,  1516,  2035,     0,  2037,  1089,   142,   716,
       0,   101,  2048,  2037,     0,   247,   272,   258,     0,   278,
       0,  1287,     0,  1283,   789,   820,   824,   934,     0,  1008,
     462,     0,  1018,   413,  1010,  1012,  1014,   810,   826,   831,
     936,   813,   812,     0,     0,     0,     0,   846,   849,   851,
     842,   847,   845,     0,   935,   858,   855,   857,   818,     0,
     959,   938,   940,   860,   871,  1002,  1005,     0,     0,     0,
     872,   868,   961,   869,     0,   874,   843,   875,     0,     0,
       0,     0,   945,   879,   947,   949,   954,   952,   956,   885,
     822,     0,   890,   892,   804,   789,   895,     0,   901,   899,
       0,     0,   907,     0,     0,   916,     0,   914,     0,   915,
       0,   917,   918,     0,   930,   933,  1035,     0,  1992,     0,
     999,   742,     0,   748,  1021,   745,   751,   717,   716,   919,
       0,  1966,  1966,  1966,  1265,  1264,     0,  1263,  1267,     0,
     677,   255,     0,     0,     0,  1261,  1249,  1996,  1238,  1241,
    1511,  1894,   694,     0,  1130,  1198,  1196,     0,  1189,  1191,
    1193,     0,  1505,     0,     0,  1849,  1835,   457,     0,     0,
       0,     0,  1836,     0,  1120,  1071,     0,     0,  1037,  1064,
    1064,     0,  1037,     0,     0,     0,  1272,  1146,  1274,  1079,
    1083,  1084,  1082,  1073,     0,  1151,     0,     0,     0,   576,
       0,   589,   578,   426,  1143,   295,   326,   482,     0,     0,
     366,   415,   410,     0,   415,   415,   468,   470,   464,   468,
       0,   375,   393,   370,     0,   462,   383,   374,   395,   398,
     400,   402,   415,     0,   462,   363,   372,     0,   415,   434,
       0,     0,     0,   430,     0,   475,     0,   437,   343,   427,
     429,     0,     0,   396,     0,   352,   469,     0,   354,     0,
       0,   415,     0,   425,   415,     0,  2034,     0,  2041,     0,
     145,   143,   144,     0,   138,   140,   135,     0,   323,   324,
     322,   321,     0,   131,  2041,   245,  1996,  1446,     0,   250,
       0,  1152,   535,  1168,     0,     0,  1009,     0,     0,   981,
     837,   838,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   807,     0,     0,     0,     0,     0,     0,
       0,   913,   911,   912,     0,  1036,  2011,   540,   747,     0,
     720,   970,     0,     0,  1965,  1963,     0,  1964,  1962,  1938,
       0,  1897,  1898,  1896,  1884,     0,     0,  1436,  1157,  1251,
    1253,  1259,  1248,     0,  1131,  1146,  1449,  1192,     0,   711,
    1847,  1846,  1848,  1842,     0,     0,     0,     0,  1069,  1064,
    1051,     0,  1055,  1060,  1056,     0,  1047,  1045,     0,  1167,
       0,  1085,  1157,  1152,     0,     0,     0,     0,     0,     0,
       0,     0,   575,  1482,   565,   567,     0,     0,     0,   477,
     478,   483,   485,     0,     0,   419,   420,   421,   376,   416,
     418,     0,   378,   346,   463,   471,   472,     0,   467,   465,
     468,   371,   401,   377,     0,   373,     0,   360,   440,   439,
     725,   432,   442,     0,     0,   438,   428,   436,   431,     0,
       0,     0,     0,   344,     0,   345,  1515,  2036,     0,   552,
     716,   716,  2038,  2051,   142,     0,     0,     0,     0,   132,
     134,   135,  2032,   248,   246,     0,  1992,    91,     0,   534,
       0,   821,   423,   412,     0,   832,   852,     0,   819,  1003,
     994,  1125,   862,     0,   870,   876,   964,   963,   889,   896,
     900,   898,   902,   908,   909,  1021,  2008,   749,   971,  1944,
    1943,  1942,  1939,     0,     0,     0,     0,     0,     0,  1967,
    1969,  1262,     0,     0,   256,   709,   317,  1139,  1152,     0,
    1157,     0,  1457,  1190,  1852,  1851,  1837,     0,     0,     0,
       0,     0,     0,     0,  1092,  1271,  1080,     0,  1074,  1150,
       0,     0,   331,  1484,  1483,   589,   488,   489,   490,     0,
       0,     0,   481,   484,   355,   348,   417,     0,   541,   473,
     466,     0,   359,   441,   725,   435,   462,   468,   462,   468,
       0,     0,     0,   685,     0,   109,   139,     0,   716,   100,
     102,     0,     0,   252,   251,  1152,     0,     0,     0,     0,
       0,     0,  1940,  1970,  1973,  1971,  1972,  1974,  1968,     0,
       0,   318,     0,     0,  1136,  1138,  1132,  1180,     0,     0,
       0,     0,  1450,  1452,     0,  1197,     0,  1066,  1052,     0,
    1057,     0,  1049,     0,  1087,     0,   332,   568,   492,     0,
     491,     0,   486,   487,   482,     0,   462,     0,   462,   433,
     351,   353,   357,   358,     0,  2042,     0,  2039,     0,  2052,
     141,     0,     0,   133,   136,  1996,   533,   536,   414,   853,
       0,   982,   863,   922,  1268,  1276,     0,  1437,  1140,  1141,
    1152,     0,   693,     0,     0,     0,     0,  1451,     0,     0,
    1458,  1460,     0,     0,     0,     0,  1093,     0,  1088,   333,
     494,   495,   493,   479,   480,   380,   542,   382,  2043,  2044,
    1996,   119,   118,   110,     0,   178,     0,   103,   253,     0,
       0,     0,   449,  1137,  1181,  1455,  1456,     0,  1453,     0,
       0,  1459,     0,     0,  1054,  1059,  1086,  2040,   120,     0,
     194,   182,     0,     0,     0,   180,   208,  2053,     0,     0,
     184,   206,   207,   185,  1529,     0,  1530,  2045,     0,   854,
    1275,  1277,     0,  1438,     0,  1454,  1462,  1461,     0,  1067,
     193,   196,     0,     0,   199,   189,   188,   190,     0,     0,
       0,   179,   229,   178,   178,   232,   187,   225,   178,   104,
     450,  1449,   716,     0,   195,     0,     0,     0,   181,   209,
     220,   223,   215,   150,   178,     0,   178,     0,     0,  2046,
     109,  1457,     0,     0,  1184,  1186,     0,   191,     0,     0,
       0,     0,   178,   216,     0,   146,     0,     0,   148,   235,
       0,   227,   105,  1463,  1187,  1182,   716,  1327,     0,   183,
     200,   217,   223,   213,   221,   178,     0,     0,   178,     0,
     231,   149,     0,   233,   226,   228,   178,     0,  1465,  1185,
     192,   197,   178,     0,   214,     0,     0,   212,   161,   160,
       0,   152,   174,   230,     0,   151,     0,   178,   106,     0,
       0,  1472,     0,   178,   218,     0,   178,     0,     0,     0,
       0,     0,   147,     0,   178,  1464,  1467,     0,     0,  1469,
    1470,     0,  1439,   198,   203,     0,   210,   178,   155,   175,
     176,     0,   158,   236,     0,  1471,  1466,     0,  1473,   199,
     178,   202,   178,     0,     0,   153,   167,   154,   165,   157,
       0,   234,  1468,   204,   178,   178,   173,   171,   178,   162,
     169,   164,     0,   170,   177,   168,     0,   159,     0,   156,
     172,   166,   163
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   982,    58,   538,
     929,  1399,  1400,    59,   435,    60,   715,  1140,  1141,  1142,
      61,  1618,  2499,  1158,   412,   430,   396,  2802,  3073,  3442,
    3538,  3590,  3636,  1104,  3439,  1538,  3493,  1539,    62,   503,
     713,  1122,  1123,  3248,  3249,  3245,  3250,  3063,  3064,  3065,
    3066,  3628,  3584,  3605,  3629,  3669,  3703,  3709,  3710,  3650,
    3718,  3719,  3720,  3726,  3721,  3651,  3705,  3585,  3528,  3558,
    3554,  3529,  3618,  3553,  3640,  3576,  3577,  3642,  3684,  3701,
    3530,  3531,  3559,  3600,  3532,  3560,  3622,  3581,  3623,  3643,
    3685,  3582,  3601,  3646,  3604,  3533,  3588,  3634,  3566,  3583,
    3587,  3657,  3632,  2077,  2484,  2082,  2489,  3076,  2494,  3256,
    3445,  1906,  2307,  3138,  2808,  1608,  1099,  1100,   413,   414,
     415,   511,  2083,  1573,  2084,  2085,  1575,  1576,  1028,  2458,
    2449,  2435,  3304,   736,  3072,  2462,  2463,  2464,  2465,  2413,
    2414,  1996,  1997,  2043,  2473,  2785,  3003,  3023,  2786,  2787,
    2788,  2789,  2790,  2791,  2792,  2822,  2823,  3198,  3199,  3200,
    2819,  3054,  3038,  3039,  3040,  3221,  3010,  2347,  2348,  3543,
    2357,  2358,  2395,  2680,  2396,  1103,  3011,  3048,  3208,  3041,
    2472,  2997,  3189,  3341,  3190,  3191,  3192,  3422,  1998,  2412,
    1119,  1120,   662,   416,  1172,  1638,  1639,  1640,  3080,  3081,
    2403,  2910,  3347,    63,  1106,   698,   700,   699,  2046,   490,
    1577,  1578,  1579,  2723,  2729,  3335,  2000,   111,  1396,  2469,
    2034,    64,  1078,  1073,    65,   673,   668,   669,  1076,  1077,
    1507,  1958,    66,   605,    67,   498,    68,   506,  1145,    69,
     990,  1898,  1899,  1900,    70,   705,    71,   507,  1152,  1153,
    1154,    72,   980,   116,    73,   594,   985,   987,   988,    74,
     500,   501,  1114,    75,  1426,  1880,  1881,   710,   711,  1121,
    2639,    76,    77,   481,   455,   611,   456,   457,  1453,  1918,
    3305,   622,   623,   624,  2331,  1007,  1008,  1009,  1923,  1454,
    2336,  1160,  2925,   900,   901,   902,  1333,  1334,  3042,   903,
    1343,  1817,   904,   905,  1845,   906,  2871,  2280,  2281,  2282,
    2621,  2622,   907,  2120,  2834,  2158,   908,  1326,  1802,  1712,
    3095,  2855,  1657,  2103,  2519,  2623,   527,   528,   909,  1250,
    1251,  1252,  1729,  1317,  2250,  1794,  1514,  1515,  1516,  1517,
    2974,  2973,  2975,  3319,  3161,  3321,  3165,  1969,  1518,  1519,
    3473,  2371,  2694,  2389,  2390,  3172,  1960,  1520,  2377,  3171,
    2710,  2980,  3327,  3477,  2048,  3323,  1384,  1385,  1709,   964,
     965,  1658,  1877,  2295,  3145,  3309,  2270,  2944,  3307,  3394,
    1580,  2439,  2440,  1920,  1921,  2393,  2713,  2733,  1031,  3306,
    2297,  1481,  1482,  2813,  1641,  2059,  3462,  3544,  3593,  3594,
    3595,  2662,  2663,  2948,  2949,  1922,  2328,  2664,  3146,    78,
     418,    79,  1847,   706,   707,  1173,  1174,   530,   427,    80,
     436,  1878,    81,   449,  1441,   578,   598,   993,   994,  1907,
    2308,  2315,  1908,  2320,  2937,  2310,  2642,  2643,  1981,  1982,
    2311,  2645,  2934,  2926,  2927,  2635,  3136,    82,   469,  2705,
    2384,  2385,  3454,  3455,   599,    83,   417,   747,  1646,  1177,
    1645,   748,   749,  1179,   525,   526,    84,   467,  1052,  1053,
    1054,  1496,    85,   460,   663,  1477,  2361,  1942,   590,   665,
    1488,   666,  1489,  1468,  1937,  1019,    86,   694,   693,    87,
     486,  1095,    88,   539,   940,   941,  1404,  1855,    89,   450,
     603,   604,    90,   444,   591,  1434,    91,   437,   581,    92,
      93,   582,   973,  2636,  3303,  3502,  3571,  1425,   974,  2495,
    3312,  3402,  3403,  3405,  3470,  3471,  3638,  3661,  3678,  3679,
    3682,   910,   682,   911,  3182,   912,   913,  2316,  2317,  2714,
     914,  3456,   915,  2044,   676,   433,   916,   572,   683,  2300,
     917,  3535,   728,   729,   399,   400,    94,   625,   459,  1011,
    1012,  1013,  1463,  1464,   667,  2259,  1465,  1466,  1934,  1929,
    2956,  2686,  2678,    95,   585,   942,   978,   979,  1886,    96,
     468,    97,   966,  1420,  1421,  1874,  2294,  1875,    98,   607,
      99,   561,  1414,   562,   944,   563,   564,   956,   951,   959,
     953,  3293,  3128,  3129,  1862,   925,   730,   731,  1407,  1857,
    1858,  2921,  3131,  3299,  3300,   100,   120,   405,   509,   722,
    1001,   101,   102,   103,   104,  1004,  1090,  1914,  1091,  1092,
    1093,  1527,  1451,  1324,  2908,  2252,  1796,  2601,   514,   737,
     496,   516,   517,   112,   113,   738,   739,  2079,  2476,  2795,
    3058,  3059,  3242,  3239,   740,  3568,   741,  2485,  2074,  2798,
    3365,  3495,   105,   684,   478,  1088,  1083,  1085,  1523,  1976
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3264
static const int yypact[] =
{
    4297, -3264,   181,    68,  -148, -3264,   569, 42329,   506,  -148,
    -148,  -200,  2759, -3264, -3264, -3264, -3264, -3264,  2777, 42329,
      68, -3264, 20412, -3264, -3264, -3264,   108,  -148,    68, 42329,
   -3264,   388,   798,    68, -3264, -3264,  -148, -3264,  -200, 42329,
   -3264,   472, -3264,   836,  -112,   419,   422, -3264, -3264, 42329,
    2314,  -195,   933,   922, -3264, -3264,   581, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, 20975, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264,   815, 42329, 42329, -3264,
   42329,   493, -3264,   981, -3264, -3264,  -148, -3264, -3264, -3264,
    -200, 20412, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,   455, -3264,
   -3264,   550, -3264, -3264, -3264,  1163,  1012, -3264, -3264, -3264,
   -3264, -3264,   311,   738, -3264,   763,  1047,   658, -3264,  1086,
    1086, 42329,  1086, -3264,  1086, -3264,  1086,  -148, -3264, -3264,
    3345, 42329,   949,   118,   317, 37289,   251,   185, -3264,  1081,
   20412, -3264,  -148,  1141,   656, 42329, -3264, -3264,  -148,   201,
     629, -3264,  3355,   127, -3264, -3264, -3264,  2571, -3264, -3264,
    5123, -3264, -3264, -3264,   769, -3264, -3264, 20412,  -148,  1100,
   -3264, -3264,   143,   143,   143, -3264,   143, -3264,   143, -3264,
    -195,   770, -3264, -3264, 42329,   418, -3264, -3264,   786,   449,
   -3264, -3264, -3264, -3264, 20412,  1242,   939, -3264, 20412, -3264,
      73, -3264, -3264,   813, 42329, -3264, 20412, 20412,   377,   842,
      51, 42329, 35049,  1008, -3264,   444,   981,  1410, -3264,  1012,
   -3264, 42329, -3264, -3264, -3264, 38969,   658, -3264, 12377,  1284,
   42329, 42329,  1104, 42329, 42329, 35049, 20412,  1086,   885,  3561,
    1101,  1037,  1193, -3264, -3264, -3264, -3264,  1140, -3264, -3264,
     999, -3264, -3264, -3264,   195, -3264,    49, -3264, -3264, -3264,
   -3264, -3264,  1153,   919, -3264, -3264,    80, -3264, -3264, 42329,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,  1293, -3264,
   -3264, 12377,   186,  1464,  1342, 20412, -3264,  -204, -3264, -3264,
    1257, -3264, -3264, 35049, 20412, -3264, -3264, -3264, 18150, -3264,
   -3264,  1476, -3264,   940, -3264, 20412,  1101, -3264,  1184,  1107,
     842,  1019, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264,   985,  2571, -3264, -3264,  1287,  1415, -3264,  1131,
     -20,  1051,   996,   958,   -20, 37289,  1350, -3264,    93, -3264,
    1418, -3264, -3264,  1148, -3264, -3264, -3264,  1174,  1186,  1329,
    1146, -3264,    97,  2935, -3264,  1191, -3264,     8, -3264,   772,
    1350,   -20,   654, -3264,  1412,  1531,    70,   613, -3264,   335,
   -3264, -3264,  1604, -3264, -3264, -3264, -3264, -3264,  1293, -3264,
   -3264, -3264,  1111, -3264,  1340,  1219, -3264, -3264,    27, -3264,
    1108,   528, -3264,   496, 35609, -3264, -3264, -3264,  1603, -3264,
   -3264, -3264, 35049,  1288,  1172, 20412,  -145, -3264, 39529, 20412,
   -3264,    79, 12377, -3264, -3264,  4198,   -10,   247, -3264,  1676,
    1332, -3264, -3264, -3264, -3264,  1588, -3264,  1169,  1165,  1546,
    1175, -3264, -3264, -3264, -3264, -3264, -3264, -3264,  1211, -3264,
   -3264, -3264,   939, -3264, 20412,   768, 20412, -3264,  1182, -3264,
    1192, -3264,  1206,  1208,  1216,  1223,  1240, 15307, -3264,  1248,
    1254,  1256,  1260,  1262,  1270,  1276,  1283,  1286,  1290,  1301,
    1308,  1314,  1316,  1169,  1169,  1331,  1341,  1347,  1359,   542,
    1367, -3264,  1385,  1387,  1389,  1394,  1398,  1401,  1403,  1407,
    1409,  1420, -3264,  1429, -3264,  1437,  1440,  1448,  1452,  1454,
    1459,  1462,  1470,  1486,  1488,  1492,  1498,  1501,  1503, -3264,
    1506,  1509,  1510, 12377,  1524,  1526,  1537,  1538,  1541,  1547,
    1548, -3264,  1549,  1550,  1551,  1560,  1562,  1565,  1577,  1579,
    1580,  1584,  1590,  1592,  1594,  1595,  1598, -3264, -3264, 12377,
    1599, -3264, -3264,  1600,  1602, -3264,  1611,  1612,  1617,  1619,
    1621,  1628,  1637,  1639,  1642,  1644,  1645,  1647,  1648,  1649,
    1650,  1651,  1654,  1655,  1658,  1660,  1661,  1668, -3264,   578,
    1672,  1682,   667,  1683, -3264,  1684, -3264,   178,  1697,  1699,
    1705,  1169,  1169,  1169,  1713,  1714,  1717,  1724,  1725,  1730,
   12377, 15307, 15307, 15307,  7689, -3264, 42329, -3264, 42329,  2702,
    3155, -3264,  4331, 15307,  5610,   354, -3264, -3264, -3264,  1189,
    1285, -3264, -3264, -3264, -3264, -3264,  1738,  1205, -3264, -3264,
   -3264, 20412, -3264, -3264, -3264,  1327,    72, 20412,  1304, -3264,
   -3264, -3264, -3264, -3264, -3264,  1873, -3264, -3264, -3264,  1369,
    1416, -3264, -3264, -3264, -3264, -3264, -3264,  1502, -3264, -3264,
   -3264,  1740, -3264,  1740, -3264, -3264,  1740, -3264, -3264,  1740,
       6,  4315, -3264, -3264, 42329, -3264, 42889, -3264, 18150,  2702,
   -3264,  1719, -3264, -3264,  1808, -3264,  1789,    95,  1529, -3264,
   20412, 37289, -3264, -3264,    77,  1544,  1575,  1552, -3264,  1634,
   20412, 20412, -3264, -3264, -3264, -3264,   629,   -27,  1601,    48,
   -3264, 42329, -3264,   825, -3264, -3264, -3264,  1718, -3264, 12377,
   -3264,  1739, -3264,   830, -3264,  1967, -3264,  1827, 12377, -3264,
   -3264,  1753,  1012, 42329, 42329, 20412, 20412, -3264, -3264, -3264,
    1011, -3264, -3264, 42329,   -20, 35049, -3264, -3264, -3264,  2159,
     654, 42329,   -20, -3264,  2105,  1846, -3264, -3264, -3264,  2185,
   -3264, -3264,  2181,  1773, -3264,   654, -3264, -3264,   654, -3264,
   -3264, -3264, -3264, -3264, 20412, -3264, -3264,   654, -3264,   654,
     654,   -20,   -20,  1814, -3264, -3264,  1777, -3264,  1814,  1908,
     508,   143,  2003, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264,   758, -3264, -3264, -3264, -3264, -3264,    88,
   -3264, -3264, -3264,  1325,  2179,  2179,  1570, -3264,   673, 20412,
     247,  1827, 20412, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
    1786, -3264,  1788,  1785,  2702,  2228,  2232,  2233,  2248,  2249,
    2255,  2264,  2266,  2267,  2276,  2283,  2286,  2287,  2291,  2293,
    1806, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,  1867,
   -3264, -3264, -3264, -3264,  2236, -3264, -3264, -3264,    89,  1797,
   -3264, 37289,  2395, 35049, 42329, 42329,  2262, 20412, -3264, -3264,
    3519,  3519,  2098,  1874, -3264,   653, 42329,  2282, 24911,   114,
   12377, 12377, 12377,   969,  1423,  2388,  2446,  2446,  2446, 12377,
   12377, -3264, -3264, 12377, -3264, 12377, 12377, 12377, 12377,  1069,
   -3264, -3264,  8275, -3264,  1877, 12377, 12377,  1966, 12377,  1285,
   12377, 12377, 21538, 12377, 12377, 12377, 12377, 12377,   524, 12377,
    5610, 12377, 12377, 12377,  1885, 12377, 12377, 12377, 12377, -3264,
   12377, 12377,   290, 12377,  2345,   712, 12377, 12377, 12377, -3264,
    8861, 12377, 12377, 12377, -3264, 12377, 12377, 12377, 12377, -3264,
    2464, -3264, 21538,  1084, 12377, 12377,  1156, 12377, 12377, 12377,
   12377, 12377, -3264, -3264, -3264, -3264,  8275, -3264, 12377, 12377,
   12377, 12377, 12377, -3264, 15307, 12377,  9447, 12377, 12377, 12377,
   12377,  1890, 12377, 12377, -3264,  2446,  2446, 12377, 12377, 12377,
    1198,  8275, -3264, 12377,  1285,   978,   978, 12377,  1285,  6517,
   12377, -3264, -3264, -3264,   712, 10033,  1891, -3264, -3264, -3264,
    2446, 21538,  2446, 12377, 12377, 12377,  2702,  1924,  2388,  2388,
    2388, -3264,  7689,   171,  1900, 12377, 22664,  1895, -3264, -3264,
   -3264, -3264, 12377, 12377, 12377, -3264, 15307, -3264, -3264,  2346,
   -3264, -3264, -3264, 12963, 15307,  1905, 15307, 15307, 15307, 15307,
   15307,  2237, 15307, 15307, 15307, 15307, 15307, 15307, 15307, 15307,
   15307,   796,  2388, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264,  1910, -3264, 37289, 15307, 12377, -3264,
   -3264, 42329, -3264, 35049, -3264, -3264, -3264,    72, 37289,  1907,
   -3264, -3264,  2104,  3561, 20412, -3264, 42329, -3264, -3264, -3264,
   -3264, 18713, 18713, -3264, 18713, -3264, -3264,    82,    83,  3405,
    1939, -3264, -3264, -3264, -3264,  2279, 20412, -3264,   -97, 20412,
     247, -3264, 12377,  1827, -3264, 35049, 35049, 20412, 20412,   188,
   -3264,   817, -3264,  1827,  2310, 18713, 18713, 18713, -3264, -3264,
   -3264, -3264, -3264,   946, -3264,  2702, -3264,  1915, -3264, -3264,
   -3264, -3264, -3264, 40089,   227, -3264, -3264,  1827,  2333, -3264,
    2702,  1926, 42329, -3264, -3264, -3264, -3264,   -11, -3264, -3264,
   -3264, -3264,   104, -3264, -3264, -3264, -3264,  2061,   -20, 42329,
   -3264, -3264, -3264, -3264, -3264,  2138,  1350,  2935,   -20,   -20,
     654, 20412,   -20,   -20, -3264, -3264,  1185, -3264,   335, -3264,
   -3264, -3264, -3264, 42329,  2374,  2074,  1937, -3264, -3264, 20412,
   -3264,  1940, -3264,  2355,  2487,  1350, -3264, -3264, -3264,   231,
     231,  1827,  2063,  2067,  2073,  2076,  2077,  2120, -3264, -3264,
    3105,  2490,   231,   231,  2490,   231,   231,   231,  2054,  2442,
     231,  2328,  2072,   938,  2330,   231, -3264,  2081,  2448,   231,
     231,   231,  2490,  2536,   231,   231,   231,   231,   231,   106,
     231,   231,   231, -3264,  5812, -3264, -3264,  2001, 19276, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, 40649, -3264, 12377,
    1423,  1827,  1827,  1571,  1827,  1423,  1827,  1827,  1827,  1827,
    1827,  1423,  1827,  1827,  1423,  4198, -3264, -3264, -3264,    92,
   -3264, -3264,   -69, -3264, -3264,  1213, 42329, -3264,  4163, -3264,
   -3264, -3264, -3264, -3264, -3264,   814, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
    2004, -3264, -3264, 20412, 20412,  2055,  1939, -3264,   508, -3264,
    2009, -3264,   256,   271,   179, -3264,  2446,  2017, -3264,  2019,
    2021,  2028,  2029,  1337,   782,   696,  2030,   861,  2040,   305,
     621,   214,   827, -3264,  2043,  2056,  1212, -3264,   829,   838,
    1378,  1475,   916,  2048,  2051,   190,   238,   920,   951,   242,
   -3264,  2058,   983,  2476,  1034,  1057,   254, -3264,  1613,  1083,
    1124,   262,  2069,   300,   312, -3264, -3264, -3264, -3264,  2053,
    1134, -3264, -3264,  -170,  1656,  1149,  1170, -3264,  1685,  1183,
    1203,   339,  2071,  1207,   355,  1237,  1261,  2075,  2078,  2079,
   -3264,  2446,  2086,  1695,  1711,  2446,  2089,   384,  1267,  1726,
     393,   395,  2097,  2101,  2106,  1728,  1757,  1762,   428,  1271,
     459,  2111,  3329,  1764, -3264,  1787,  1279,  1298,  1305,   611,
   -3264,  1309,  1796,  2116,  2119,  2123,  1326,   155,  1344,  2446,
    2124,  1798,   676,  2080,  2134,  1805, 10619, 11205, 11791,   203,
    1402,  -158, -3264,  1820, -3264,  2144,  2146, -3264,  2051,  2148,
     681,   688,  1833, 12377,   748, -3264,   524, -3264, -3264, -3264,
      81,    65, -3264,  2216, 42329,  1447,   119, -3264, -3264, -3264,
   -3264, -3264, -3264,   557, -3264,  2121, -3264,  2139,  2109,  7689,
     855,  2109,  2965,  2797,  2797, 15307,  2556,  3022,  3297,  1962,
    5610,  1962,  5610,  2109,  2109,  2109, -3264,  2152, 15307, 15307,
   15307, 12377, -3264,  2388,  2702,  2155,   792, -3264, -3264, -3264,
   -3264,  1304,  2474, -3264,  2157, -3264, -3264,   902, -3264,  2151,
   -3264,  2166,  2238,  2241,  2250, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264,  1350,   817,  2258,
    2169, -3264, -3264,  2200,  2505, -3264, -3264, -3264, -3264,  2702,
   -3264,  2261, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
     156, -3264, -3264,  2183,  2183, 17019, -3264, -3264, -3264, -3264,
    2421,  2596,  2597,  2602,   496, -3264,   283, -3264,   180,  2555,
    1350, -3264,  2618, 37849, 25473, -3264,  2204,  2563,  2205,   231,
   33369,   276, 23224, 33929, -3264, -3264,  1571, -3264,    41, -3264,
   -3264, -3264, -3264,  1011,  1011,  2240, -3264, -3264,  2461, -3264,
   -3264, -3264, -3264,  1939,   654, -3264, -3264, -3264,  2215, -3264,
   -3264,   508,  2566,  2570, -3264,  2452,   664,  2452,   508,   508,
   21538,   508,  1614, -3264,  1423,  2514, -3264, -3264, -3264, -3264,
   -3264, -3264, 36169, 34489, -3264, -3264, -3264,  2723, -3264,  2725,
     954, -3264, 22101,   141,   141, -3264,   140,   192, 22101, -3264,
   -3264, 22101,  1571,  1423, 22101,  1423,  1827,  1827,  1483,   231,
    1423, -3264, -3264,  2584,  2589, 22101, 22101, -3264, 37289, -3264,
     231,   971,  1571,  1571, 22101, 21538,   202,  1827,  1423,  1423,
    2805, -3264, -3264, -3264, 20412,  1986, 37289,  2245, -3264,  5370,
   16456, 42329,   295,   166, -3264,  2239,  2253, -3264,   975, -3264,
    2702, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264,  2332, -3264,  2256, -3264, -3264,    37, -3264,  2253,
   20412, 15893, -3264,    84, -3264,  3978, -3264, -3264,  4362, -3264,
   -3264, -3264,   508,  2480,  1939,  2271,   114, 13549, -3264, -3264,
   12377,  2254, -3264, 12377, 12377, -3264, -3264, -3264,  2156, -3264,
   36729, -3264, -3264, -3264, -3264, -3264, 12377, 36729,  2156, 12377,
   -3264, -3264,  2260, -3264,  2608,  2608, -3264, -3264,  1285, -3264,
   42329, -3264, 12377, -3264, 12377, -3264,  1285, -3264, 12377, -3264,
   12377, 12377, -3264,  2509, -3264, 12377, -3264, 12377, 12377, -3264,
   12377, -3264, -3264, 12377, -3264, 12377, 12377, -3264, -3264,  2513,
   -3264, 12377, 12377, -3264, -3264, 12377, -3264, 12377, -3264, 12377,
   -3264, 12377, -3264, 12377, -3264, 15307, 21538,  2272, -3264, -3264,
   -3264,  2274, -3264, -3264, 12377, 12377, -3264, -3264, 12377, -3264,
   12377, -3264, -3264, -3264, -3264, -3264, -3264, -3264, 12377, 12377,
   -3264, 12377, -3264, 12377, -3264, -3264, 12377, 12377, 12377, -3264,
   12377, -3264, -3264, -3264, -3264, -3264, 14135, 12377, 12377, 12377,
    2284, -3264, -3264, -3264, 12377, 12377, 12377, -3264, 12377,  2660,
   12377,  2671, 12377,  2677, 12377, -3264, 12377,  2516, -3264, -3264,
   -3264, -3264, -3264, 12377, -3264, 12377, -3264,   846, 12377, 12377,
    2722, -3264, -3264,  2295,  2297, -3264,  2292,  2294,  2303, 37289,
   12377, -3264, -3264, -3264, -3264, -3264,   524,   705,  2299, 15307,
   -3264,  2965, 15307, -3264, -3264,  7689,   855,  2965,  2636, -3264,
    2312, -3264, -3264,  2313, 42329, -3264, -3264, -3264, 42329,  2289,
   26035, 35049, 35049, 35049,  2281, 12377, -3264, -3264,  2523, -3264,
   -3264, 20412,  2656, -3264, -3264, 35049, -3264,  2571, 21538, -3264,
    2315, -3264,  2315,   973,  2320,  1002, -3264, -3264, -3264,  2309,
    1019,  2731, 35049, 35049, 35049, -3264,  1939,  1939,   142,  2375,
    2679, -3264, -3264, -3264, -3264, 41209, -3264, -3264, -3264, -3264,
     812, 42329,  2667, 42329,  7103, -3264, -3264, -3264,  2846, 12377,
   -3264, 35049,   725,    65,   231, -3264, -3264, -3264, -3264, -3264,
   -3264,  1350, -3264, -3264, -3264, -3264,  2643, -3264, -3264,   -20,
    1185,  -193, -3264,  2904, -3264, -3264, -3264,  2683,   508,  2452,
    2452,  2684,  2582,    -6,  2343, -3264,   231,  2374,     3, -3264,
    2571, -3264, -3264, 12377, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, 12377,  2691,  2696,
     141, -3264, 22101, -3264, -3264,   768,   105, -3264, -3264, -3264,
   -3264, -3264, -3264, 34489,  1827, -3264, 22101, -3264, -3264,   230,
   -3264,  1827, -3264, -3264, -3264, -3264, -3264, -3264, -3264,  2350,
   -3264,   320, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   20412, -3264,  1023, -3264, -3264, -3264, -3264, 42329, -3264, -3264,
   20412, -3264, -3264,  5744, 42329, 42329,  2918, -3264, 42329, -3264,
   -3264, -3264, -3264, -3264,  2595,  -119,  2926, -3264, 20412, -3264,
    2367,  1026, -3264, -3264, -3264,  2940,  4350, -3264, -3264,  2376,
    1939,  2700, -3264, -3264, 12377,  1855,  1859, -3264,  2702,  1864,
    2380,  2380, -3264, -3264,  2386,  2380,  2739, -3264,  2745,  2394,
    2402,  2406,  1870,  2407,  2411,  1411, -3264, -3264,  5610,  5610,
    2415,  2389,  1872,  1888,  2416,  2417,  1903,  1439,  1917,  2418,
    2420,  1989,  1998,  1456,  2000,  2006,  2052,  2083,  2423,  2480,
    2424,  1465,  1493,  2426,  2142,  2149,   716,  2164,  2428,   746,
    2951, -3264, -3264, -3264,  2175,  2177,  2192,  2220,  2234,  2246,
    2257,  2277,  2317,  1500,  2323,  2340,  2429, 12377,  2348,   205,
     755,  1527, -3264,  2359,  1554,  1559,  2370, 12377,  2383, 12377,
    2399, 12377,  2414,  2434,  2430,  2483,  2491, 12377,  1201,  2702,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264,  2437,  2702,  2435,
   -3264, -3264, -3264,   354, -3264,   780,  2436, -3264, 15307, -3264,
   12377,  2444, -3264,  2450, -3264, -3264, -3264, -3264, -3264,  -103,
    -103,  -103, 14721,  2702,  2898, -3264,   601, -3264,  2785, -3264,
   -3264,   985,  2457, -3264,   231, 14721,  2183,  2605, -3264, -3264,
     973, 21538, 25473, -3264, 35049,  1175,  1175,  1175,  1350,  2848,
    2258,  2258, -3264, 23784, -3264, -3264,  2599, -3264, -3264, 26597,
   -3264,   -50, -3264, -3264, 15307,  1387, -3264,  2702, -3264, 36169,
   -3264,  2702,   231,  2466,  2468, -3264, -3264, 41769, 12377, -3264,
    2899, -3264, -3264,  2471,   508,  2703,   508, -3264,  2821,  2823,
     508, -3264, -3264, -3264, 21538,  1939, 14721,   141,   141,   141,
   -3264,   985,  2702,  2477,   320,  2702, 22101, -3264, -3264,   768,
    2478,  2952,  2953, 22101,  2846, -3264, -3264, -3264, -3264,  5744,
   21538, -3264, -3264, -3264,  1070, -3264, 16456, -3264, -3264, -3264,
    2482,  2485,  2380, -3264, -3264, -3264, -3264, -3264,  2386,  2701,
   -3264,  2386,  2386, -3264, -3264, -3264, -3264, -3264,   244,  1200,
   -3264, -3264,   244, -3264, -3264, -3264,    99,   800,  2386, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264,  2380,  2380, -3264, -3264,
   -3264,   244,  2486, -3264,  2380,   925, -3264,   832,    57,  2493,
    2495,  2380,  2496,  2484, -3264,  1073, -3264, -3264,    59, -3264,
     226, -3264, -3264, -3264,  2489, -3264,  5812, -3264,   570, -3264,
   42329, -3264,  1011, -3264,  5610, -3264, -3264, -3264,  2744, -3264,
     244,  2751, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, 12377,  2510,  2511,  2512, -3264, -3264, -3264,
   -3264, -3264, -3264, 12377, -3264, -3264, -3264, -3264, -3264, 12377,
   -3264, -3264, -3264, -3264, -3264,  2651, -3264,  2760, 12377, 12377,
   -3264, -3264, -3264, -3264, 12377, -3264, -3264, -3264, 12377,  3056,
    2719,  2518, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, 12377, -3264, -3264, -3264,  5610, -3264, 12377, -3264, -3264,
   12377, 12377, -3264, 12377, 12377, -3264,  2508, -3264,  2521, -3264,
    2538, -3264, -3264,  2771, -3264, -3264,  2702, 12377,  1019, 42329,
   -3264, -3264,  2527, -3264, -3264, -3264, -3264,  2702, -3264, -3264,
     590,  2554,  2554,  2554,  1387,  2702,  1085, -3264, -3264,  2888,
   -3264,  1718, 21538, 14721,  2531,  2532, -3264,   528, -3264, -3264,
    2526,  1175, -3264,  3073,  2919, -3264, -3264, 37289,  2534, -3264,
   -3264,  2811, -3264,    60,  2737, -3264, -3264, -3264,   725,  2627,
    2638,   231,  2702,  1827,  1720,  1937,  2902,  1125,  2604,   508,
     508,  1425,  2609, 12377, 12377,  2559, -3264,  2480, -3264,  2973,
   -3264, -3264, -3264,  1718, 12377, -3264,  2572,  2573, 42329, -3264,
    3124,   295, -3264,   925, -3264, -3264, -3264,   560,  2824,  2832,
   -3264,   367, -3264,  2600,   367,   367,  3127,   211, -3264,  3127,
   36729, -3264,  1131, -3264,  2623,   244, -3264, -3264,  2628, -3264,
   -3264, -3264,   367,  2603,   244, -3264, -3264,  2849,   367, -3264,
   37289,  1827,  2999, -3264,  2655, -3264,  3081,  2955, -3264,   925,
   -3264,  2959,  2862, -3264,  2866, -3264, -3264,  2868, -3264,  2870,
    2880,   367,  2883, -3264,   367, 42329, -3264, 42329,  2664,   584,
   -3264, -3264, -3264,  2641,  2644, -3264, -3264, 20412, -3264, -3264,
   -3264, -3264,  2708, 42329,  2664, -3264,   528,    84,  2605, -3264,
    1119,   320,  2647, -3264,  2648,  2649, -3264,  1121,  2540, -3264,
   -3264, -3264,   787,  2544,   143,  2652,  2654,  2562,  1583,  2576,
    2587,  2927,  3087, -3264,  2591,  2658,  2601,  2606,  2610,  2614,
    2619, -3264, -3264, -3264,  2662,  2702, -3264, -3264, -3264,  2661,
   37849, -3264,  2750,  2753, -3264, -3264,  2754, -3264, -3264,    90,
    1310, -3264, -3264, -3264, -3264, 14721,  3012, -3264,   917, -3264,
   -3264, -3264, -3264, 12377, -3264,  2480,  3190, -3264, 23784, -3264,
   -3264, -3264, -3264, -3264,  2673,  2674,  7103,  3243, -3264,   508,
   -3264,  2727, -3264, -3264, -3264,  2728,  2702,  2702, 42329,  2700,
    3026, -3264,   917,   320, 42329, 42329,  1136,   712,   712,   712,
    1694,  1694, -3264, -3264, -3264, -3264,    91,    38, 42329, -3264,
   -3264,   456, -3264,  2685,  2688, -3264, -3264, -3264, -3264,   367,
   -3264,   143, -3264, -3264, -3264, -3264, -3264, 36729, -3264, -3264,
    3127, -3264, -3264, -3264,   143, -3264,  2690, -3264, -3264, -3264,
    1169, -3264, -3264,  2929,  2730, -3264, -3264, -3264, -3264,  2695,
    2707,  2709,  2711, -3264,  2699, -3264, -3264, -3264,   261, -3264,
   -3264, -3264, -3264, -3264,   802, 42329,  3108,  1827,  2713,  2717,
   -3264, -3264, -3264, -3264, -3264,  2714,  1019, -3264, 42329, -3264,
    2947, -3264, -3264, -3264,  2949, -3264, -3264, 12377, -3264, -3264,
   -3264,  2446, -3264, 12377, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264,   116,  2958,  1423,  1423,  1423,  1423,  1310,
   -3264, -3264,  2774,  2815, -3264,   180, -3264,  -210,   320, 12377,
    1350,   136,  3054, -3264, -3264, -3264, -3264,  3035,  3261, 12377,
    2733, 12377,  2734,  1151, -3264, -3264, -3264,  2735, -3264, -3264,
    1166,  1220, -3264, -3264, -3264,   295, -3264, -3264, -3264,   337,
     337,  1233, -3264, -3264, -3264, -3264, -3264,  1273, -3264, -3264,
   -3264,  1311, -3264, -3264,  1169, -3264,   244,  3127,   244,  3127,
    3254,  2970,  3265, -3264,  -195, -3264, -3264,  5744, -3264, -3264,
   -3264, 42329,  5744, -3264, -3264,   320,  2742,  2746,   793,  2747,
    2633,  2748, -3264, -3264, -3264, -3264, -3264, -3264, -3264, 21538,
   20412, -3264,   134, 12377, -3264, -3264,  2702,  2954,  3293,  3295,
    3203,  3300,   136, -3264,  -132, -3264,  3197, -3264,  2702, 42329,
    2702, 42329, -3264, 42329, 40649,  2956, -3264, -3264, -3264,  3341,
   -3264,   115, -3264, -3264,   456, 42329,   244,   143,   244, -3264,
   -3264, -3264, -3264, -3264,  2998, -3264,  3002, -3264,  2764,  3399,
   -3264,  3218,  2941, -3264, -3264,   528, -3264, -3264, -3264, -3264,
   12377, -3264, -3264, -3264,  2770, -3264,   231, -3264, -3264, -3264,
     320, 42329, -3264,   143,   143,  3311,   143, -3264,  3314,  3315,
    -132, -3264,  1571, 12377,  1317,  1351, -3264,  2778,  2776, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
     528, -3264, -3264, -3264,  3242, 31679,  2942, -3264, -3264,  2642,
   21538, 14721,  1483, -3264, -3264, -3264, -3264,   143, -3264,   143,
     143, -3264,  3349,   122, -3264, -3264, -3264, -3264, -3264, 42329,
     690, -3264, 43449, 43449, 42329, -3264,  2816, -3264,  5156,   113,
   -3264, -3264, -3264, -3264, -3264,  2786, -3264, -3264,  5744, -3264,
   -3264, -3264, 34489, -3264,  2787, -3264, -3264, -3264,  3089, -3264,
   -3264, -3264,  3204, 42329, -3264, -3264, -3264, -3264, 12377, 12377,
    2825, -3264, -3264, 31679, 31679, -3264, -3264, -3264, 31679, -3264,
   -3264,  3190,  2800,  3236, -3264,  3160,  3247, 12377,  2702,  2702,
   -3264,   757, -3264, -3264, 28854,  2799, 32244, 12377,   113, -3264,
   -3264,  3054, 12377,  2809,  2810, -3264,  1423, -3264,  3183,  1700,
    2842, 12377, 31679, -3264,  3257,  3294,  3136,  2817, -3264,  2818,
    2729, 43449,  3399,  3195,  2702, -3264, -3264, -3264, 42329, -3264,
   -3264, -3264,   778, -3264,  2702, 29419,  2841, 38409, 29984,  2822,
   -3264, -3264, 12377, -3264, -3264, -3264, 31679,  3078,  2834, -3264,
    2835, -3264, 31679, 12377, -3264,  3278,  2851, -3264, -3264, -3264,
    3223,  2839,   281, -3264,  2836, -3264,  2736, 31679, -3264,  3173,
   17582,  2984, 42329, 27159,  2702,  2860, 31679,  3262, 42329,  5744,
    3263,  3264, -3264,  3029, 30549, -3264, -3264, 37289,  1364, -3264,
   -3264, 21538, -3264, -3264,    10,  2867, -3264, 27724, -3264, -3264,
    3327,  2814, -3264, -3264,  2882, -3264, -3264, 19844,  2770, -3264,
   31679, -3264, 31679, 32809, 12377, -3264,  2894, -3264, -3264, -3264,
    5156, -3264, -3264, -3264, 31114, 28289, -3264, -3264, 24344, -3264,
   -3264, -3264,  3273, -3264,  2702, -3264,  1285, -3264, 32809, -3264,
   -3264, -3264, -3264
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3264, -3264, -3264, -3263, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264,  1597, -3264, -3264, -3264, -3264, -3264,  1845, -1429,
   -3264, -3264, -3264, -3264, -3264,   332,   -38, -3264, -3264, -3264,
   -3264, -3264, -3264,  2752,  -139, -3154, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264,   206,    94, -3264, -3264,   209,
   -3264, -3264,  -752, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264,  -269,  -228, -3264, -3264, -3264, -3264,   344, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264,  -235, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,  -156, -3264,
   -3264,  -113, -3264, -3264,  -153, -3264, -3264, -3264,  -110, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,   396, -3264,
   -3264, -1871, -3264, -3264, -3264, -3264,  2318, -1000, -3264,  3060,
   -3264,  -425,   675,  1911, -1919, -1042,  -627,  -619, -1669, -3264,
   -3264, -3264,   314, -3264, -3264,  1406,   753,  1912,  1951,  1451,
    1499, -3264, -3264,   776, -3264, -2667, -3264, -3264, -3264,   742,
   -3264,   743, -3264, -3264, -3264, -1117,   713,  -385, -3264,   308,
    -197, -3264,   511, -3264,   475, -3264,  -457, -2061, -1957, -3264,
   -3264, -3264,   481,   797,   844, -3264, -2598, -1864, -3264, -3264,
     121, -3264, -3264, -3264,   109, -3264,   343,   212, -3264, -3264,
   -1505, -1826, -3264, -3264, -2059,  2378,  1463, -3264, -2707,   297,
   -1910, -3264,   345, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264,  1521, -3264, -3264, -3264,   499,  -241, -1351, -2782,
   -3264, -3264, -3264, -3264, -3264, -3264,   979, -3264, -3264,  2059,
    2488, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264,  1664, -3264, -3264, -3264, -3264, -3264,  -819,  2419,
   -3264, -3264, -3264,  1209, -3264, -3264, -3264, -3264,  2133, -3264,
   -3264,  2872, -3264, -3264, -3264, -3264,  1281,  1701, -3264, -3264,
   -3264,  2891,  1673,  -476, -1771, -3264,  3107, -3264, -3264, -3264,
   -1320, -2001, -3264,  2967,   287, -2310,  2136,  -729,   677, -3264,
     473,  -756,  2901, -3264, -1296, -1111, -3264, -3264,  -508, -3264,
   -3264, -3264, -1274,  -734, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264,   691, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -1136, -3264,  1490, -3264, -1082, -3264, -3264, -3264,
    2363, -3264, -3264, -3264, -3264, -3264, -1916, -1509,   921, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -1908, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -1380, -3264, -1756, -3264,
   -3264, -1113, -3264, -3264,   200, -2073, -1200,   657, -3264, -3264,
    -964,  2425, -1602, -3264, -3264, -3264,  1343, -3264, -3264, -3264,
   -3264, -3264,   886, -2032, -1065, -3264, -3264, -2624,  -639, -1846,
    -603, -3264, -1868,   453, -1170, -1900, -3264, -3264, -3264, -3264,
      11, -3264, -3264, -3264,   482,  1712, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264,  -477,  -401, -3264,  1990,  1680, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264,  2665,  2645,  1759,
   -3264, -3264, -2162, -3264, -3264,  1735, -3264,   709, -1892,  2270,
     997, -3264, -3264,  1000, -2628, -3264, -3264, -3264, -3264, -3264,
   -3264,   942,   -30,   152,  3185, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264,  2481,  2008,  3137, -3264, -3264, -3264, -3264, -3264,
    2165, -3264, -3264, -3264, -3264, -3264, -3264, -3264,  3205, -3264,
    -939, -3264,  -448, -3264, -3264,  -593, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264,  2265, -3264, -3264, -3264, -3264,
   -3264,  2668, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,  1033,
     101, -3264,   273,    96, -3264,   213, -3264, -3264, -3264,   -18,
   -3264,  -754,  -684, -1014,   650, -2658, -1221,  1038,  2689, -2819,
   -1147, -1253, -1284, -1808,    21, -3264,    -7,  -480,  -902,  -662,
    2280, -2641,  -434,  -524, -3264,  2463, -3264, -3264, -3264, -3264,
    2230, -3264, -3264, -3264, -3264,  1348, -3264, -3264, -3264,  1010,
   -3264,   744,   547, -3264, -3264,  3544, -3264,  2275, -3264, -3264,
   -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264,  2706,  3260,  3117, -3264,  2763, -3264, -3264, -3264,
   -3264, -3264,   420, -3264,   533, -3264,   154,  2565,   517, -3264,
    1441,  -605,  -875, -3264,   434, -3264, -3264,  1110,  3283,  3128,
   -3264, -3264, -3264, -3264, -3264, -2247,  -602, -3264, -2317, -3264,
   -3264, -3264, -3264, -1151, -3264, -3264,  2427,   625, -3264, -3264,
    -104, -3264, -3264,  -115, -3264,  3241,  3008, -3264,  1665, -3264,
     950, -3264, -3264,   680, -3264, -3264, -3264, -3264, -3264, -3264,
   -3264, -3264, -3264,  1167, -3264, -3264, -3264, -3264, -3264, -3264
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2029
static const yytype_int16 yytable[] =
{
     397,   574,   725,   661,   690,  1164,  1165,  1166,  1389,  1005,
    1096,   924,   397,  1428,  1659,   397,  1483,  1200,  1201,  1203,
    1693,  1060,   397,  1185,  2251,  1209,  2398,  1787,  1525,   716,
     717,  2296,   397,  1032,  2314,  1999,  2360,  2344,  2349,  2352,
    1808,  1027,   397,   432,  2093,  2373,  1849,  1816,  2015,  2520,
    1660,  1661,  1662,  2383,  2693,  2387,  2523,  1032,  1786,   926,
    2382,  2501,  2993,  1674,  1574,  1683,   675,  1691,  1061,   986,
     492,  1101,   493,  2653,  2333,  2364,  2365,  1957,  2978,  1102,
     397,  1830,  1832, -1123,  1267, -1877, -1878,  -249,  2415,  3046,
    2985,  -546,  -259, -1941,   744,  -260,  1328,  1329,   962,  1528,
     397,   397,  2417,   397,  1432,  1730,  3292,   983,   487,  1665,
    1666,  1292,  1668,   962,   397,  1294,  1498,  1732,  1298,  1499,
    1736,  1394,  2436,  2437,  2031,  1307,  1308,  1309,   997,  3150,
    1502,  1503,   962,  1919,  1328,  1329,  1067,  1328,  1329,  2094,
    1973,  3562,   502,   508,   957,  3699,  1143,  1702,  1443,  1764,
    1765,  2648,  2481,  3339,  1770,  3018,  1033,  1318,  1319,  1320,
    1041,  3016,  1722,  1752,  3017,  3173,  2497,  2405,  2406,  1362,
    1328,  1329,  2707,  1883,  1785,  3122,  1789,   679,  1107,   567,
    1742,  1743,  1744,  3026,  2404,  1411,  1328,  1329,  2362,  3045,
    2404,  1751,   106,  2416,  1328,  1329,  2419,   992,  2407,  1098,
    1098,  1029,  1763,  1098,   438,  1328,  1329,  2428,  2429,  3184,
    2490,  2381,  1301,  1056,  1064,  1651,  2438,  2708,  1328,  1329,
    1328,  1329,  3086,  3458,  2407,   963,  3481,  1445,  1110,  1328,
    1329,  3205,  1017,  1818,  2721,   479,  1821,  1822,  1823,  1824,
     963,  1826,  1827,  1828,  1829,  1831,  1833,  1834,  1835,  1836,
    2407,  2032,  1940,  1328,  1329,   954,  2256,  1328,  1329,   963,
    2482,   970,   579,  1086,  3006,  3561,   628,   629,  3336,  1328,
    1329,  1328,  1329,  2660,  3398,   107,  3007,  1328,  1329,  1394,
    3060,  3176,   628,   629,  3399,  3492,  1328,  1329,  3061, -1123,
    3008,  1584,  2072,  1884,  2800,   571,  1117,   518,  2492,   628,
     629,  1146,   708,  2467,  2920,  3140,  2641,  1389,   515,  1620,
    2408,  3360,  1895,  2442,   596,  1328,  1329,  1118,  1966,  3361,
    1328,  1329,   106,  2257,  3308,   439,   114,  1328,  1329,   681,
    2217,  2931,  3183,  1003,  3068, -1877, -1878,   968,  2702,  2731,
    2953,   681,  3468,   463,  1895,   117,   680,   118,  3392,  2430,
    3123,  2368,  2329,  2954,  1328,  1329,  2720,  3670,  1117,   404,
     108,   971,  -340,  1111,   575, -1123,  3469,  2459,  1621,   452,
    1328,  1329,  1144,  3671,  3183,  3393,  1979,  2887,  2234,  1118,
    1412,  1302,  3563,   723,   724,   981,  3418,  1705,   480,  2711,
    1706, -1996,  1389,  2955,  1361,   109,  1389,  1521,   464,  1328,
    1329,  2983,   743,  1147,   115,  1623,  1148,  2327,  1328,  1329,
    1328,  1329,   742,  2326,   397,  2159,  3062,  3211,  1386,  1149,
    2051,  1979,  1446,   495,   397,  2061,  3215,  2237,   397,   718,
    2073,  2067,  1330,   397,  2070,  1331,  2732,  1080,   397,  1087,
    1112,  1485,  2330,  1328,  1329,  1943,  1068,  3727,  2351,  1491,
    1397,  3337,  3482,  3069,   733,   576,   972,  3259,  3492,  2468,
     397,   584,  2688,  1885,  2801,  1941,  2724,  3330,  3331,  1624,
    2697,   597,  1101,  1330,  1328,  1329,  1331,   397,  1504,  1505,
    1102,  1713,  1163,  1395,  1057, -1123,  3400,   397,  2938,  2493,
    1526,   397,  2502,   920,  2706,   922,   923,   397,  2661,   397,
     397,  1413,  2719,  1430,   397,   397,  1330,  3301,   568,  1331,
    2258,  1486,  2409,  1439,   397,   701,  2726,  3564,   397,  3362,
    2101,   577,  1330,   397,   397,  1331,   397,   397,   397,   397,
    1330,  1101,  1574,  1331,  2703,  1999,  1018,  1469,  1896,  1102,
    1626,  1330,  2709,  1413,  1331,  3338,  1150,  1431,  1930,  3329,
    1781,  2722,  3459,  3417,  1330,   110,  1330,  1331,  1112,  1331,
    2470,  1953,   397,  1069,  -340,  1330,   580,   992,  1331,  1034,
    1896,  2483,  3340,  1042,  3460,  1112,  1999,  2809,   397,  3700,
    2372,  3151,  1070,  2500,  2718,  1433,   397,   397,  1931,  1330,
     992,   397,  1331,  1330,  2363,  2177,  1331,  1472,   397,  2181,
    3126,   958,  2334,   440,  2404,  1330,   977,  1330,  1331,  1528,
    1331,  1888,  1820,  1330,  2033,   989,  1331,  3070,  2404,  1501,
    3142,  1787,  1330,  2698,  2699,  1331,  1328,  1329,   397,  1151,
    2273,  1585,  2274,  2220,  3401,   609,  1328,  1329, -1877, -1878,
    3047,  1395,   681,  -137,  1332,  2253,  1530,  3019, -1941,  3122,
     955,  1330,  2318,  1843,  1331, -1123,  1330,  1112,   709,  1331,
    2987,  3116,  -503,  1330, -1518,   513,  1331,  2410,  2268,  2255,
    3565, -1123,  3419, -1877, -1878,  -249,  -584,  1303,  1980,  -546,
    -259, -1941,  1332,  -260,  3395,  1332,  1787,   397,   588,  1944,
    1330,  1328,  1329,  1331,  1897,   397,  1328,  1329,   397, -1123,
    3440,   397,   397,  1328,  1329,  3444,  1330,  1387,  3071,  1331,
    3549,  1586,   719,  1511,  2271,  2262,  2254,  2386,  1332,  -340,
    1328,  1329,  1637,  1980,  2658,  2659,  1897,  1611,  2277,  2278,
     502,  1328,  1329,  1074,  1332,  1330,  3206,   397,  1331,   397,
    2218,  1787,  1332,   512,  1330,  3186,  1330,  1331,  3420,  1331,
     695,  3446,  2933,  1332,  2117,  1797,  1798,   535,  3430,  3253,
    3432,  1328,  1329,  2099,  2100,  1169,  1332,  1175,  1332,  3009,
    1328,  1329,  2441,  1112,  2131,  2132,  2314,  1332,   593,  1330,
    2967, -1999,  1331,  3421,  2971,  1581,   121,  2235,  2968,  2888,
    2958,  1707,  2972,   401,  1708,  1328,  1329,  1328,  1329,  2118,
    3187,  1332,  1328,  1329,  2391,  1332,  2986,  1075,  1328,  1329,
    1330,  1389,  2942,  1331,   445,  2492,  1932,  1332,   734,  1332,
    3195,   458,  2133,  2134,  3123,  1332,  2137,  2138,  3485,  1062,
    3487,  1813,  1112,  2418,  1332,  2420,  3503,  1449,  2144,  2145,
    2425,  2097,  1328,  1329,  1328,  1329,  2149,  2150, -1392,  3186,
    2528,  2529,  3006,  1328,  1329,  2098,  2443,  1949,  2445,  2446,
    2450,  1328,  1329,  1332,  3007,  3551,  1512,   837,  1332,  1848,
    1513,  3569,   522,  3541,   465,  1332,  1328,  1329,  3008,  1389,
   -1999,  3555,  3556,  1063,  2152,  2153,  1978,   628,   629,   397,
    2115,   397,  1803,  1032,  2263,  1946,  2154,  2155,  2811,  3196,
    2378,  1582,  1332,   837,  3187,  1951,  1952,   569,  2404,  1955,
    1956,  1891,  1892,  2379,   397,   703,   600,   466,  1332,  1386,
     397,  3124,  1032,  2166,  2167,   483,    40,  1854,   523,  1483,
    1483,  1328,  1329,   482,  3197,  1328,  1329,  3079,  1511,  2170,
    2171,  2692,  1392,   589,  3083,  3169,   696,  1332,  3029,  3210,
    1450,   484,  1842,  1890,  1321,   735,  1332,   397,  1332,   397,
     489,   397,  1330,  1909,  1850,  1331,  1328,  1329,  2183,  2184,
    3635,   697,  1330,   397,   397,  1331,  2614,  2187,  2188,  2189,
    2190,  1655,  1101,   397,   397,  1473,  1474,  1935,   494,  3030,
    1102,  1332,   837,  3031,   397,  1484, -2028,  1574,  1328,  1329,
    1901, -1392,  3690,  1490,  2269,  1991,  2493,  1933,  2388,  3374,
     601,  1030,  2197,  2198,  3240,  2369,   397,   397,   397,   397,
    3552,  1459,  1332,  3060,  1787,  1837,   397,  1330,   397,  2561,
    1331,  3061,  1330,  2521,   397,  1331,  3032,   837,  2526,  1330,
     524,   868,  1331,  2200,  2201,   504,  1475,  1476,  1838,  1328,
    1329,  1984,  1022,  2534,  1003,  2644,  1330,   397,   505,  1331,
    2539,  3162,  3163,  3125,  2560,  1207,  2401,  1330,  2683,  3156,
    1331,  2264,  1328,  1329,  3126,  2548,  2549,   868,  2727,    51,
    2380,  1655,  2553,  1367,   602,  1500,  2684,  2265,  1460,  1071,
    2558,  1512,  1916,   495,  1656,  1513,  1655,  1330,  1328,  1329,
    1331,  1207,   397,  2977,  2276,   397,  1330,  1690,  2013,  1331,
    1524,  2052,  2053,  3310,  2060,  2609,  2062,  2063,  2064,  2065,
    2066,  1916,  2068,  2069,  2616,  1208,  1614,  1615,  3498,  2576,
    1583,  1330,  2503,  1330,  1331,  2432,  1331,  1023,  1330,  1328,
    1329,  1331,  3204,  3188,  1330,  3209,  3349,  1331,   453,  1328,
    1329,  3127,  1368,  3078,   397,  1117,   397,   397,   397,  3062,
     397,  1293,  1072,  -474,  1328,  1329,   868,  3241,  1655,   397,
    1030,   397,  1917,  3517,  1332,  1461,  1118,   720,  1330,   508,
    1330,  1331,  2402,  1331,  1332,  1328,  1329,  1372,  1617,  1330,
    1207,  1839,  1331, -1216,  1673,  2209,  2210,  1330,  1328,  1329,
    1331,  2624,  2979,  2979,  2979,   397,  2116,  3255,  1387,  1731,
    1655,   868,  1330,  1962,  2433,  1331,  1328,  1329,  1328,  1329,
    3006,  2075,  1328,  1329,  2685,   510,  2530,  1328,  1329,   429,
     499,  1999,  3007,   519,  2535,  1207,  2110,   442, -1216,  1332,
    2076,   721,   448,  3318,  1332,   397,  3008,  1901,  1058,  2086,
    1297,  1332,  1328,  1329,  2087,   628,  3012,   723,   724,   409,
    2223,  2224,  3033,  1902,   521,  2242,  2243,  1330,  1332,  3034,
    1331,  1330,  2244,  2245,  1331,  1462,  1328,  1329,  1478,  1332,
    2111,  1735,  1328,  1329,  1376,  1170,  1328,  1329,  1059,  2610,
    2611,   117,  1377,   118,  1328,  1329,   566,  3035,  1524,   529,
    2863,  2864,  1330,  2248,   397,  1331,  2434,   583,  1171,  1332,
    2014,   461,  3580,  1328,  1329,   462,   587,  2249,  1332,   397,
    1328,  1329,  2916,  1769,  1328,  1329,  3602,   672,  2835,  2836,
    2867,  2868,  1024,  3621,  1330,   446,  3474,  1331,  3475,  2889,
    2890,  1328,  1329,  1332,  1963,  1332,  3350,  3602,  3020,  1479,
    1332,  3021,  1328,  1329,   691,  2108,  1332,  3009,  1378,  1328,
    1329,  1964,  1903,  1904,  2913,  2914,  2109,  1787,  1840,  3036,
     597,  3266,  3267,   845,  1965,  2283,   569,  3449,  3450,   397,
     628,   629,  2284,  3043,   397,  1330,   397,   702,  1331,  1529,
    1332,   397,  1332,  1328,  1329,  2283,   712,   397,  2318,   397,
    1905,  1332,  2669,  1901,   397,   397,  1380,   397,  1330,  1332,
     703,  1331,  2119,   732,  2124,  3044,  2597,  1328,  1329,   397,
    1787,   106,   397,  2125,  1332,   928,  1328,  1329,   397,   397,
     397,   397,  1860,  1860,  1330,  1860,   918,  1331,   397,   397,
     397,   670,   671,  2337,   674,  2113,  1787,  1882,   921,  1966,
     977,  2386,  3037,  1025,  1328,  1329,   397,   945,   989,  1894,
    1127,  1128,  1328,  1329,  3397,   397,  1860,  1860,  1860,  3160,
    1408,  1328,  1329,  1409,   943,  1330,  1410,  2441,  1331,  1332,
    1328,  1329,   397,  1332,  2856,  1330,  2287,  2288,  1331,   950,
    1328,  1329,   952,  3431,   397,  3433,  2350,   960,  2354,  2359,
    1330,  2128,  3294,  1331,   961,  2135,   397,   109,  1328,  1329,
    1026,   975,   397,  1962,  1332,  1328,  1329,   976,  1903,  1904,
     984,  1330,  1954,   995,  1331,   996,  2421,  2422,   999,  2912,
    1620,  1480,  1381,  1000,  1330,  2613,  2136,  1331,   628,   629,
    1972,  1967,  1328,  1329,  1383,  1003,  1332,  2444,  2397,  2350,
    1014,  2423,  1330,  2620,  1330,  1331,  2647,  1331,  1330,  2477,
    2478,  1331,  1006,  1330,  3501,  1015,  1331,  1020,  2140,  1328,
    1329,   397,  3512,  -555,  1328,  1329,  1540,  1016,  2078,  1021,
     397,  1138,  1139,  1541,  1029,  3570,  2650,  2651,  1330,  1621,
    1035,  1331,  3437,  1542,  1543,  2981,  2982,  1332,  1328,  1329,
    3295,  3296,  1029,  1030,  3297,  3298,  1968,  2735,  2736,   397,
    2806,  2736,  1330,   946,  3084,  1331,  1039, -1123,  1330,  2142,
    1332,  1331,  1330,  1544,  1036,  1331,  1623,  1545,  1328,  1329,
    1330,  3001,   962,  1331,  3004,  3005,   397,   397,  1546,  1040,
     685,   686,  2143,   687,  1963,   688,  1332,  1547,  1787,  1330,
    1037,  3022,  1331,  1548,  2995,  1112,  1330,  3056,  3057,  1331,
    1330,  1964,  1038,  1331,  2089,  2091,  1549,  1055,  2147,  3134,
    3135,  1328,  1329,  1066,  1965,  1065,  2350,  1330,  2054,  2644,
    1331,  1098,  1079,  2350,  1550,  3105,  1082,  1332,  1330,   947,
    1624,  1331,  1089,  1551,  1552,  1330,  1081,  1332,  1331,  1553,
    1328,  1329, -1123,  3257,  3258,  3263,  3264,  1554,  1084,  2148,
    1328,  1329,  1332,  1555,  1098,  1328,  1329,  1108,  1005,  2157,
    3332,  3258,  2689, -1123,  1109,  3009,  1328,  1329,  1155,  1330,
     948,  1156,  1331,  1332,  2161,  3412,  3413,  2055,   962,  1556,
    1157,  1328,  1329,  1328,  1329,   949,  1332,  3013,  2783,  1966,
    3415,  3258,  1159,  1330,  1161,  2162,  1331,  1162,  1032,   963,
    1163,  1626,  1330,  1167,  1332,  1331,  1332,  1176,  2164,  3164,
    1332,  2907,  1328,  1329,  1388,  1332,  2691,  1328,  1329,  1328,
    1329,  2640,  1178, -1123,   681,  1557, -1123,  1558,  2165,  1180,
    1330,  1181,  2169,  1331,  1559,  1391,  2123,   397,  1483,  1182,
    1332,   781,  1328,  1329,  3416,  3258,  1183,  1330, -1123, -1123,
    1331,  1328,  1329,  1328,  1329, -1123,  1330,  3424,  3425,  1331,
    1328,  1329,  2172,  1184,  1332,  2607,  1330,  2682, -1123,  1331,
    1332,  1186,  3119, -1123,  1332,  1328,  1329,  1187,  2056,  1188,
   -1123,  1967,  1332,  1189,  1330,  1190,  2173,  1331,  1328,  1329,
   -1123,  1330,  2185,  1191,  1331,  2667,  2199,  3426,  3427,  1192,
     794,  1332,  1560, -1123,  2206,   963,  1193, -1123,  1332,  1194,
    1328,  1329,  1332,  1195,  1328,  1329, -1123,  1561,  1330,  1328,
    1329,  1331,  1562,  2207,  1196,  1328,  1329,  1328,  1329,  1332,
    2208,  1197, -1123,  1398,  2211,  3428,  3427,  1198,   397,  1199,
    1332,  3514,  3413,  1328,  1329,  1330,  1968,  1332,  1331,  2057,
    1330,  2216,  1393,  1331,  1202, -1123,   397,   397,  1328,  1329,
    1401, -1123,  1563,   397,  1204,   397,   397,  1402,  1564,  2219,
    1205,  1565,  1328,  1329,  1330,  3515,  3413,  1331, -1123, -1123,
    1185,  1332,  1206,  1637,  2725,  1863, -1123,  1864,  3696,  3697,
    1210,  2728,  1773,  1774,  1566,  1567, -1123,  1568, -1123,  3333,
    3334,   821,  2126,   397,  1330,  1332, -1123,  1331,  1211, -1123,
    1212,  1569,  1213, -1123,  1332,   397,   397,  1214,  1911,  1912,
    1913,  1215, -1123,  2734,  1216,   397,  1217,  2236, -1123,  2350,
    1218,   397,  1219,  1570,   397,  1405,  2833,   397,  2945,  2946,
    3158,  1403,  1332,  1220,  1328,  1329,  1423,  1330,   397,   397,
    1331,   397,  1221,  1328,  1329,  1328,  1329,   397,   397,  1332,
    1222,  1328,  1329,  1223,  2843,  2922,  2923,   397,  1332,   397,
   -1123,  1224,   842,   397,   397,  1225,  1330,  1226,  1332,  1331,
    2001,  2849,  1227,  2004, -1123,  1228,  1330,  3132,  3133,  1331,
    2858,  1330,  2016,  1229,  1331,  2451,  1332,  2452,  2453,  2127,
   -1123,  2024,  1330,  1332, -1123,  1331,  1424,  1328,  1329,  1230,
    3067,  1231, -1123,   397,   397,  1232,  1427,  1330,  2859,  1330,
    1331,  1233,  1331,  1436,  1234,  2881,  1235,  1571,  1344,  1236,
    1332,  2058,  1237,  1238, -1123, -1123,  1572,  2454,  1328,  1329,
     531,  2487,   533,   397,   534,  1787,   536,  1240,  1330,  1241,
     397,  1331,  2891,  1330,  1429,  1330,  1331,  1332,  1331,  2455,
    1242,  1243,  1332,   397,  1244,  3384,  3385,  3386,  3387,  1435,
    1245,  1246,  1247,  1248,  1249,  3379, -1123,  1437,  1330,  2893,
   -1123,  1331,  1438,  1253,  2894,  1254,  1332,  1330,  1255,  1330,
    1331,  2456,  1331, -1123, -1123,  -555,  1330,  1328,  1329,  1331,
    1256,  -555,  1257,  1258,  1328,  1329, -1123,  1259,  3273,   397,
   -1123,  1330, -1123,  1260,  1331,  1261,  1332,  1262,  1263,  1328,
    1329,  1264,  1266,  1268,  1330,  1269,  1444,  1331,  2510,  2620,
    1328,  1329,  1328,  1329,  1270,  1271,  1467,  2146, -1123, -1123,
    1272, -1123,  1273,  3381,  1274, -1123,  1330,  1328,  1329,  1331,
    1330,  1275,  2511,  1331,   876,  1330,  1787,   927,  1331,  1332,
    1276,  1330,  1277,  1330,  1331,  1278,  1331,  1279,  1280,  2950,
    1281,  1282,  1283,  1284,  1285,  1328,  1329,  1286,  1287,  1330,
    2160,  1288,  1331,  1289,  1290,  2397, -1123,  1531,  1332,  1328,
    1329,  1291,   397,  2512,  1330,  1295,  2513,  1331,  1332,  1532,
   -1123,  1328,  1329,  1332,  2514,  1296,  1299,  1300,  1330,  2163,
    3620,  1331,  1328,  1329,  1332,  1347, -1123,   397, -1123,  2179,
    1304,   397,  1305,   397,   397,   397,   397,   398,  1306,  1332,
    1146,  1332,  1328,  1329,   397,  2180,  1310,  1311,   397,   428,
    1312,   397,   434,  1452, -1123, -1123,  1005,  1313,  1314,   443,
    2186, -1123,  2194,  1315,  2820,   397,   397,   397,  2824,   454,
    1332,  1390,  1882,  1406,  1458,  1332,   571,  1332,   397,   470,
    1471,  1487,  1328,  1329,   397,  1492,   397,  1493,  1328,  1329,
    1330,  2195,   471,  1331,   397,  1494,  2196,  1506,  2204,  1330,
    1332,  1330,  1331,  1495,  1331,  1328,  1329,  1330,  1497,  1332,
    1331,  1332,  1508,  1328,  1329,  1510,  1522,   488,  1332,  1587,
    1589,  2205,  1588,  1590,  1328,  1329,  1787,  1591,  1592,  2457,
    2212,  1610,  2222,  1332,   472,  1328,  1329,   491,   398,  2227,
     398,  1605,  1147,  1593,  1594,  1148,  1332,  1787,  1328,  1329,
    1595,   488,  1606,  1330,  2238,   397,  1331,  3680,  1149,  1596,
    3269,  1597,  1598,  1787,  1328,  1329,   397,  2246,  1332,   397,
    1533,  1599,  1332,  1209,  1294,  1298,  3617,  1332,  1600,  1328,
    1329,  1601,  1602,  1332,  1330,  1332,  1603,  1331,  1604,  2815,
    1612,  1616,  1643,  2816,  3680,  2629,  2630,  2631,  2817,  1328,
    1329,  1332,  1386,   397,  2830,   473,  2838,  1648,  1655,  1644,
     397,  1677,  1962,   397,  3353,  1303,  1332,   397,   397,  1697,
    1711,   397,  2839,  1728,  1760,  1784,  2655,  2656,  2657,  1793,
    1332,   397,  2515,  3157,  1799,  1804,  1841,  2842,  1819,  1825,
    1534,  2738,  1851,  1330,  1852,  1876,  1331,  1879,  1328,  1329,
    1330,  2844,  1910,  1331,  1809,  1924,  1328,  1329,  1936,  2804,
    1938,  3363,  3364,  3147,  1535,  1330,  1945,  3348,  1331,  1948,
    1970,  3708,  1971,  1328,  1329,  1974,  1330,  1975,  1330,  1331,
    3348,  1331,  1977,  3708,  1985,  1150,  1328,  1329,  1986,  1357,
    1358,  1359,  1360,  1330,  1987,  3000,  1331,  1988,  1989,  1990,
    3207,  3219,  1332,  1328,  1329,  1328,  1329,  1991,  3708,  1328,
    1329,  1332,  2008,  1332,  2009,  2011,  2012,  2017,  1536,  1332,
    2020,  1330,  2272,  2847,  1331,  2019,  2350,  1328,  1329,  3024,
    3025,  2025,  2848,   612,  2850,  1330,  2039,  3028,  1331,  2088,
    2851,  1328,  1329,  1963,  3051,  2092,  2397,  1330,  3429,  2095,
    1331,  2102,  1328,  1329,  2104,  2105,  1328,  1329,  1330,  2516,
    1964,  1331,  2106,  2107,  2112,  1332,  1328,  1329,  1151,  3202,
    3203,  1328,  1329,  1965,  2114,  1328,  1329,  2121,  1330,  1328,
    1329,  1331,  2129,  2122,  1328,  1329,  2852,  3213,  2156,  3441,
    2337,  2130,  2139,  3217,   397,   397,  1332,   397,  1328,  1329,
    1537,  2141,  2618,  2151,  1005,  2168,   397,  1328,  1329,  2174,
    2517,  2175,   397,  2260,  2176,  2225,  3233,  2853,  1330,  3235,
    2178,  1331,   397,  2182,  1330,  1328,  1329,  1331,   723,   724,
     397,  2191,  1344,  1810,   474,  2192,  1328,  1329,  2518,  1360,
    2193,  1330,  1328,  1329,  1331,  2202,   613,   397,  1966,  1330,
    2213,   532,  1331,  2214,  -788,  1332,   475,  2215,  2221,   397,
    1330,   565,  1332,  1331,  2950,   573,   397,  1328,  1329,  2226,
     488,  1330,  2266,   397,  1331,   592,  2861,  1332,  2239,   397,
    2240,   476,  2241,  2862,  1330,  2275,  2286,  1331,  1332,  -965,
    1332,  2289,  1112,  3486,  1328,  1329,  2291,   488,  2865,  2292,
    1330,  1328,  1329,  1331,  2301,  1332,  2290,  2299,  2293,  2872,
    2303,  2873,  1344,  2304,   692,  1330,  2309,  3369,  1331,  2305,
    2321,  2322,  2323,  2350,   488,   614,  2874,  2324,   488,  3505,
    3506,  1917,  3508,  1332,   714,  1330,   488,   488,  1331,   477,
    1967,   726,   573,  1916,  2341,  2343,  2342,  1332,  2366,  2367,
    2370,   745,  2374,   397,  2875,   750,  2375,  2376,  2941,  1332,
     919,   398,  3586,   398,   398,   573,   488,  2392,  2876,  2399,
    1332,  2400,  2426,  3545,  3731,  3546,  3547,  2427,  2460,  2474,
    2877,  2479,  1524,   813,  1330,  2587,  2475,  1331,  2507,  2480,
    1332,  2878,  1330,  3592,  2527,  1331,  2589,  2540,  1649,   967,
    3625,  2550,  2591,   406,  2594,  1968,  2562,  3633,  2563,  1330,
    1811,  2879,  1331,  2600,  2632,   488,  2627,  2634,  2582,  1347,
    2638,   419,  1330,   573,   488,  1331,  1812,  3673,   488,  2602,
    1332,  2603,  2604,  2612,  2605,   488,  1332,  3592,  3438,  1330,
    3663,  1330,  1331,  2606,  1331,  1330,  2619, -1019,  1331,  2652,
    2646,  2880,   397,  1332,  2649,  3674,  2654,  2882,  2666,  2665,
    2679,  1332,  1620,  1330,  3687,   573,  1331,  2671,  2690,  2696,
    2700,  1620,  1332,  1344,  2883,   397,  2701,  1330,  2704,  2716,
    1331,  3494,  2886,  1332,  2717,  2730,  2796,   407,  1330,  2799,
     397,  1331,  1330,  2892,  2803,  1331,  1332,  1043,  3714,  1347,
    3715,  2805,  1330,  2812,  2895,  1331,   420,  1330,  2807,  2810,
    1331,  1330,  1332,  2818,  1331,  1330,  2825,  2897,  1331,  2821,
    1330,  1621,  2826,  1331,  1097,  1044,  -508,  1332,  2827,  2284,
    1621,   397,   573,  2899,  1330,   488,  2828,  1331,  1115,   488,
    2829,  2831,  1962,  1330,   421,  2832,  1331,  1332,  2901,  2837,
    2840,  2841,  2845,   397,  2846,  1349,  1350,  2854,  1623,  2857,
    2860,  1330,  2866,  2884,  1331,  2903,  1045,  1623,  2902,  2911,
    2915,  1046,  1330,   397,   488,  1331,   488,  2909,  1330,  2918,
    2928,  1331,  2930,   758,  2919,  1901,   615,   616,   617,   618,
     619,   620,  2932,  2943,  2963,  3542,  1332,  2951,   397,  2959,
     397,  2960,   621,  1330,  1332,  2964,  1331,  2969,  2966,  2970,
     397,  2988,  2984,  2989,  2990,  2998,   397,  2904,  2999,  3027,
    3002,  1332,  1624,  3075,  3055,  2905,  3049,  1344,  3050,  3052,
    1330,  1624,  3085,  1331,  1332,  1349,  1350,  1330,  3246,  3087,
    1331,  1344,  3111,  3094,  3089,  3090,  3091,  3101,  3096,  3177,
    3102,  1332,  3103,  1332,  3494,  3112,   781,  1332,  2350,  3114,
    1347,  3118,  3130,   397,  3137,  3141,  2669,  3135,  3143,  3148,
    3144,  3149,  3113,  1963,  3265,  1332,  3154,  3152,  3268,  1353,
    1354,  1355,  1356,  1357,  1358,  1359,  1360,  3155,  3159,  1332,
    1964,   397,  3168,  1626, -1053,  3170,  3272,   -55,  1344, -1058,
    1332,   422,  1626,  2695,  1332,  3174,  3175,   792,   758,  3046,
    3274,   397,  3193,  -339,  1332,   794,  1047,   397,   397,  1332,
    3194,  3275,  1991,  1332,  3043,  3278,  1325,  1332,  1327,  3212,
    2869,   397,  1332,  3201,  1992,  3280,  3214,  3216,  2447,  3223,
    3281,  2448,  3224,  3225,  3282,  3722,  1332,  3227,  3283,  3228,
     397,   488,   809,  3284,  3229,  1332,  3230,   488,  3231,  1353,
    1354,  1355,  1356,  1357,  1358,  1359,  1360,  3452,  3232,   408,
    3722,  3234,  3238,  1332,  3177,  3243,  3539,  3247,  1966,  3244,
    3260,   781,  3261,  3262,  1332,  1048,  3270,  3276,   397,  3271,
    1332,  3277,  3279,  3695,  1416,  3287,  1419,  3285,   488,  3289,
    3302,   397,  3290,  3291,  -265,   409,  3311,  3314,  3315,  3317,
     488,   573,  3326,  3354,  1347,  1332,   821,  3320,  3322,  3344,
     488,   488,  3345,   423,  3352,  -339,  3355,  3706,  1347,  3356,
    3368,  1448,   792,  1993,  3264,  3376,   410,  3377,   424,  1457,
     794,  3357,  1332,  3358,  1049,  3359,   411,  3370,  3373,  1332,
    1335,  1336,  3371,   398,   398,   488,   488,  3383,  3389,  3404,
    3390,  3406,  3434,   398,   425,   573,  3409,  3411,  3414,  3435,
    1967,   398,  1117,  3436,   837,  1637,  3447,   809,  3461,   426,
    3448,  3451,  3453,  3220,  1637,  1347,   841,   842,  3463,  1337,
    3464,  3465,  3472,  1118,   488,  3466,  3480,  3488,  3490,  1962,
    2470,  3489,  3496,  1338,  3497,  3500,  3507,   540,   541,  3509,
    3510,  2478,  3516,  3518,   397,  3548,  3537,   606,   541,  3573,
    3572,  -211,  1355,  1356,  1357,  1358,  1359,  1360,  3567,  3574,
    3580,  3596,   397,   397, -1183,  1968,  3597,  1339,  3598,   488,
    3608,   821,   488,  3615,  1050,  3616,  3619,  3621,  3626,  1340,
    1349,  1350,   397,  3627,   397,  3630,   397,   397,  3631,  3637,
   -1799,  3457,  3647,  3655,  1349,  1350,  3659,  3660,   397,  3665,
    3662,  3666,  3667,  1344,  3668,  1051,  1341,  3672,  3675,   899,
    3681,  3686,   542,  3693,  3688,  3691,  3692,  3702,  3704,  3711,
    3725,   573,   542,   573,   398,   398,  3730,   488,  2285,   837,
    2071,  3612,  1105,  3366,   397,  1344,   750,  3372,  1650,  3732,
     543,   841,   842,  3707,  3713,  3443,  3644,  1531,  3603,  3645,
     543,  1349,  1350,  3254,   544,   520,  1609,  -339,  3611,  1532,
    1963,  3077,   969,  1342,   544,  2038,  3328,  2491,  3534,  2996,
    2042,  1995,  1684,   397,  2471,  2411,   545,  1964,   868,  2991,
    3178,  3014,  3015,  3179,  3185,  3053,   545,  3346,   546,  2870,
    1965,  3218,   397,   874,  3226,  3534,  3534,   397,   546,   876,
    3491,  2992,   877,  2957,  1353,  1354,  1355,  1356,  1357,  1358,
    1359,  1360,  1684,  3483,  3343,   397,  3479,   547,  1353,  1354,
    1355,  1356,  1357,  1358,  1359,  1360,   397,   547,   119,  1642,
    1865,  2498,  3423,   402,   403,  3375,  3534,  3534,  2203,  3351,
    2461,  3534,   548,  1619,  2306,  1994,  1509,  1959,   549,  1866,
    1893,   441,   548,  1607,  3180,  3181,   447,  3534,   549,  3534,
     451,  1116,  2637,  2302,  1094,  1966,   689,  2325,  1915,  1867,
    1010,  1788,  3391,  3288,  3120,  3534,  1354,  1355,  1356,  1357,
    1358,  1359,  1360,  1868,  3534,  3407,   573,   550,  2524,  3121,
    1347,   397,  1727,  1124,  3478,  2965,  2994,   550,  3534,  2617,
     397,  3534,  3325,   868,  1675,  3178,  1620,  3639,  3179,  3534,
    3313,  2332,  -339,  1422,  2090,  3534,  1440,  2298,   874,  2312,
    1533,  3139,  1347,  2936,   876,  2935,  2976,   877,  1869,  1870,
    3534,  3698,  3540,   397,   678,   397,  3534,  1647,  2096,  3534,
     497,   397,  1950,   751,  1442,   664,   573,  3534,  1853,  2929,
     397,  1846,  3591,   573,   397,  3467,  1871,  1967,   573,  3712,
    3534,   930,  3222,  3511,   488,  1621,  1856,  3613,  1925,  2939,
     397,  1861,  1861,  3534,  1861,  3534,   397,  2961,  1456,  3180,
    3181,  2687,  3153,  3316,  1887,  1447,   488,  3534,  3534,   488,
    1534,  3534,   608,  3382,  1239,   573,   573,   488,   488,  1622,
     551,   397,  1623,   998,  1415,  1861,  1861,  1861,  1613,  2626,
     551,   723,   724,  3388,  1535,  1872,   610,   704,  1002,   552,
    1265,  3286,  1968,  1928,  2486,   553,  1349,  1350,  1795,   552,
    1168,   554,  1939,  3074,  3252,   553,     0,     0,     0,     0,
       0,   554,     0,     0,     0,     0,   931,     0,     0,  1947,
       0,     0,     0,     0,     0,   555,  1873,     0,  1349,  1350,
       0,   488,     0,     0,     0,   555,  1624,     0,  1536,     0,
       0,  1316,     0,  1961,     0,  1323,   556,   557,     0,   488,
    1983,     0,     0,     0,     0,     0,   556,   557,     0,     0,
       0,     0,  2002,  2003,     0,  2005,  2006,  2007,     0,     0,
    2010,     0,     0,     0,   932,  2018,     0,     0,     0,  2021,
    2022,  2023,     0,   558,  2026,  2027,  2028,  2029,  2030,  3527,
    2035,  2036,  2037,   558,     0,     0,     0,     0,   933,     0,
       0,     0,     0,     0,  1625,     0,     0,  1626,  2045,     0,
       0,     0,     0,     0,     0,     0,     0,  2049,     0,     0,
    1537,     0,  1355,  1356,  1357,  1358,  1359,  1360,     0,   559,
       0,   560,     0,     0,     0,     0,     0,     0,     0,   559,
       0,   560,     0,     0,     0,     0,   398,     0,     0,     0,
       0,     0,  1353,  1354,  1355,  1356,  1357,  1358,  1359,  1360,
    1455,     0,  3589,     0,     0,     0,     0,     0,     0,  1470,
       0,     0,     0,   488,   488,     0,     0,     0,  3607,     0,
    3607,     0,     0,     0,   934,     0,     0,     0,     0,     0,
       0,     0,   935,     0,  1627,     0,     0,     0,     0,     0,
    1628,     0,  1629,  1630,  1631,  1632,  1633,  1634,  1635,  1636,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3607,
     936,   537,  3654,     0,     0,     0,     0,     0,     0,     0,
    3658,     0,     0,     0,     0,     0,   586,     0,     0,     0,
       0,     0,   595,     0,     0,     0,     0,     0,     0,     0,
       0,  1542,  1543,     0,     0,     0,     0,  3607,     0,     0,
       0,     0,   677,     0,     0,     0,   937,     0,  3607,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3607,     0,  -460,  -460,  1545,     0,   938,     0,  1637,
       0,     0,  -460,     0,     0,     0,  1546,     0,     0,     0,
       0,     0,     0,     0,   939,  1547,   118,     0,  3607,  3607,
       0,     0,  3729,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1549,     0,     0,     0,     0,     0,
       0,  1652,  1653,  1654,  2261,     0,     0,     0,     0,  1098,
    1663,  1664,  1550,     0,  1667,     0,  1669,  1670,  1671,  1672,
       0,     0,     0,  1676,     0,     0,  1678,  1679,     0,  1680,
       0,  1681,  1682,     0,  1685,  1686,  1687,  1688,  1689,     0,
    1692,  1555,  1694,  1695,  1696,     0,  1698,  1699,  1700,  1701,
       0,  1703,  1704,     0,  1710,     0,     0,  1714,  1715,  1716,
       0,  1718,  1719,  1720,  1721,     0,  1723,  1724,  1725,  1726,
       0,     0,     0,     0,     0,  1733,  1734,     0,  1737,  1738,
    1739,  1740,  1741,     0,     0,     0,     0,  1745,     0,  1746,
    1747,  1748,  1749,  1750,     0,     0,  1753,  1755,  1756,  1757,
    1758,  1759,     0,  1761,  1762,  2319,  1542,  1543,  1766,  1767,
    1768,     0,  1771,     0,  1772,  1558,     0,     0,  1775,     0,
    1779,  1780,  1559,  2338,  2340,     0,  1783,     0,     0,     0,
     573,     0,   573,   573,  1790,  1791,  1792,     0,  -460,  -460,
    1545,     0,     0,  1323,     0,     0,  1800,  -460,     0,     0,
       0,  1546,     0,  1805,  1806,  1807,     0,     0,     0,     0,
    1547,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1788,     0,     0,     0,     0,     0,     0,     0,     0,  1549,
       0,     0,   573,   573,     0,     0,     0,     0,     0,     0,
    1560,     0,  2045,     0,  1098,     0,     0,  1550,  2045,  2424,
       0,  2045,     0,     0,  2045,  1561,     0,     0,     0,  1844,
    2431,     0,     0,     0,     0,  2045,  2045,     0,   573,     0,
       1,     0,     0,     0,  2045,  1788,  1555,     0,     0,     0,
       2,     3,     0,     0,   488,     0,   573,     0,     0,     0,
    2045,  2466,     0,     4,     0,     5,     0,     0,   541,     0,
       0,     0,     0,  1889,     0,     0,  1564,     0,     0,  1565,
       0,     0,     0,     0,     6,     7,     0,     0,     0,     0,
       8,     0,     0,     0,     9,    10,     0,     0,     0,     0,
     488,  2045,  1566,  1567,     0,  1568,     0,    11,     0,     0,
       0,     0,     0,  1542,  1543,     0,     0,     0,     0,     0,
    1558,     0,     0,     0,    12,     0,     0,  1559,     0,     0,
     573,     0,     0,     0,     0,     0,     0,   573,     0,     0,
       0,  1570,   542,    13,     0,     0,     0,  1545,     0,     0,
    2531,     0,    14,    15,    16,  2080,     0,     0,  1546,     0,
       0,     0,     0,     0,     0,    17,    18,  1547,     0,     0,
     543,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   544,     0,  1549,     0,    19,     0,
       0,     0,     0,     0,     0,  1560,  1684,  1344,     0,     0,
       0,  1098,     0,     0,  1550,    20,   545,     0,     0,  1620,
    1561,  1125,  1126,  1127,  1128,  1129,  1130,     0,   546,  1131,
    1132,  1133,  1134,  1135,  1136,     0,  1137,     0,     0,    21,
    2050,     0,     0,  1555,     0,  1571,    22,     0,     0,    23,
       0,     0,     0,     0,  1572,     0,     0,   547,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      24,  1564,     0,     0,  1565,     0,     0,     0,  1621,     0,
       0,     0,   548,     0,     0,     0,    25,     0,   549,   573,
       0,     0,     0,     0,     0,     0,     0,  1566,  1567,     0,
    1568,     0,     0,     0,    26,     0,     0,     0,     0,    27,
    1345,     0,     0,  2496,  2625,  1623,     0,  1558,  1856,     0,
     967,   573,   573,   573,  1559,     0,     0,   550,     0,     0,
       0,   488,     0,  1346,     0,   573,  1570,     0,  1788,     0,
       0,     0,     0,     0,  1138,  1139,     0,     0,     0,     0,
       0,     0,   573,   573,   573,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2668,     0,     0,     0,     0,
       0,  2670,     0,  2672,     0,     0,     0,     0,     0,  1624,
       0,   573,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1560,     0,  1347,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1561,     0,     0,
       0,     0,     0,   723,   724,     0,     0,    29,     0,     0,
       0,     0,     0,     0,     0,     0,    30,  2229,  2231,  2233,
    1571,     0,     0,     0,     0,     0,     0,     0,     0,  1572,
     551,     0,  2045,     0,  2247,     0,    31,  1625,    32,    33,
    1626,     0,    34,   573,     0,    35,  2045,    36,  1564,   552,
       0,  1565,    37,     0,    38,   553,     0,     0,     0,     0,
    2267,   554,     0,    39,     0,     0,  1348,    40,     0,     0,
       0,     0,     0,     0,  1566,  1567,     0,  1568,     0,     0,
     488,     0,  2279,    41,     0,   555,  2081,  2737,    42,     0,
     488,     0,    43,     0,  2793,  2794,     0,     0,  2797,     0,
       0,     0,     0,     0,     0,     0,   556,   557,   488,     0,
       0,     0,    44,  1570,     0,     0,    45,     0,     0,     0,
    1349,  1350,     0,     0,     0,     0,     0,     0,     0,  1351,
       0,     0,     0,  1628,     0,  1629,  1630,  1631,  1632,  1633,
    1634,  1635,  1636,   558,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,    48,     0,     0,     0,     0,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   559,
       0,   560,     0,     0,     0,     0,     0,     0,     0,    50,
       0,     0,     0,     0,     0,     0,     0,  1571,     0,     0,
       0,     0,     0,     0,     0,     0,  1572,     0,     0,     0,
      51,     0,  1637,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1352,  1353,  1354,  1355,  1356,  1357,  1358,
    1359,  1360,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2319,  2940,     0,   573,     0,     0,     0,     0,     0,
       0,     0,     0,   573,     0,     0,     0,     0,     0,  2625,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   573,
       0,     0,     0,     0,     0,     0,     0,  1928,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1788,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2045,     0,  2505,     0,
       0,  2506,     0,  2045,  2508,  2509,     0,     0,     0,     0,
    1788,     0,     0,     0,     0,     0,  2045,  2522,     0,     0,
    2525,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2532,     0,  2533,     0,     0,     0,  2536,
       0,  2537,  2538,     0,     0,     0,  2541,     0,  2542,  2543,
       0,  2544,     0,     0,  2545,     0,  2546,  2547,     0,     0,
       0,     0,  2551,  2552,     0,     0,  2554,     0,  2555,     0,
    2556,     0,  2557,     0,  2559,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2564,  2565,     0,     0,  2566,
    3082,  2567,     0,     0,     0,     0,     0,     0,     0,  2568,
    2569,     0,  2570,     0,  2571,     0,     0,  2572,  2573,  2574,
       0,  2575,     0,     0,     0,     0,     0,  2578,  2579,  2580,
    2581,     0,     0,     0,     0,  2583,  2584,  2585,     0,  2586,
       0,  2588,     0,  2590,     0,  2592,     0,  2593,     0,     0,
       0,     0,     0,     0,  2595,     0,  2596,     0,     0,  2598,
    2599,     0,     0,   626,     0,   588,   627,     0,     0,     0,
       0,  2608,     0,     0,     0,     0,     0,     0,     0,     2,
       3,     0,     0,     0,     0,     0,  2615,     0,   628,   629,
       0,     0,     4,     0,     0,     0,     0,     0,   630,  3117,
     631,     0,     0,     0,     0,     0,  2633,     0,     0,     0,
       0,     0,     0,     6,     7,     0,     0,     0,   632,     8,
     633,     0,  1788,     9,    10,     0,     0,     0,   634,     0,
       0,     0,     0,     0,     0,     0,    11,   573,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    12,     0,  2677,     0,     0,     0,     0,
    2681,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    13,     0,     0, -1370,   635,     0,  3082,     0,
     636,    14,    15,    16,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    17,    18,     0,     0,     0,     0,
     573,     0,     0,     0,  2712,     0,     0,     0,     0,     0,
     637,     0,   638,     0,     0,     0,     0,    19,  2715,     0,
     573,     0,     0,     0,   639,     0,   640,     0,     0,     0,
       0,     0,     0,     0,    20,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3236,     0,  3237,     0,   641,
     642,     0,     0,   643,     0,     0,     0,   488,    21,     0,
       0,     0,     0,  3251,     0,    22,     0,     0,    23,     0,
     644,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1540,     0,     0,    24,
       0,   645,     0,  1541,     0,     0,   646,     0,     0,     0,
       0,     0,     0,  1542,  1543,    25,     0,     0,     0,     0,
    2338,     0,     0,     0,     0,  2814,     0,     0,     0,     0,
     647,     0,     0,    26,     0,     0,     0,     0,    27,     0,
       0,     0,     0,  1544,     0,     0,     0,  1545,   573,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1546,     0,
       0,     0,     0,   648,     0,     0,     0,  1547,  3324,     0,
       0,     0,   649,  1548,  3082,  3082,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1549,     0,  3342,     0,
     650,     0,     0,     0,     0,     0,     0,     0,  2885,     0,
       0,  1098,     0,     0,  1550,     0,     0,   573,  2896,     0,
    2898,     0,  2900,  1551,     0,     0,   651,   652,  2906,  1553,
     653,   654,     0,     0,    28,     0,     0,  1554,     0,     0,
       0,     0,     0,  1555,     0,     0,     0,     0,     0,     0,
       0,  2917,     0,     0,     0,  3367,    29,     0,     0,     0,
       0,     0,     0,     0,     0,    30,     0,     0,  3082,  1556,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    31,     0,    32,    33,     0,
       0,    34,     0,   655,    35,     0,    36,     0,   656,     0,
       0,    37,     0,    38,     0,     0,     0,     0,   657,     0,
       0,     0,    39,     0,     0,     0,    40,  1558,     0,  2962,
       0,     0,     0,     0,  1559,     0,     0,     0,     0, -1824,
       0,     0,    41,   658,     0,     0,     0,    42,     0,     0,
       0,    43,     0,     0,     0,     0,     0,     0,   659,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    44,     0,     0,     0,    45,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3251,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1560,     0,     0,     0,     0,     0,     0,  1788,
     488,    46, -1824,     0,     0,     0,   660,  1561,     0,     0,
       0,     0,  1562,     0,     0,     0,     0,    47,     0,  3324,
      48,  3324,     0,  3476,  2049,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3484,     0,     0,     0,     0,
       0,  1363,  1364,  1365,  1366,  1367,     0,     0,    50,     0,
       0,     0,  1563,     0,     0,     0,     0,     0,  1564,     0,
       0,  1565,     0,     0,  3088,     0,     0,     0,     0,    51,
       0,  3504,     0,     0,  3092,     0,     0,     0,     0,     0,
    3093,     0,     0,     0,  1566,  1567,     0,  1568,     0,  3097,
    3098,     0,     0,     0,     0,  3099,     0,     0,     0,  3100,
       0,  1569,     0,     0,     0,  2739,  2740,     0,     0,     0,
    1788,  2741,  3104,  2742,  1368,  2743,  2744,     0,  3106,     0,
       0,  3107,  3108,  1570,  3109,  3110,     0,     0,     0,  3550,
    2745,     0,     0,     0,  3557,     0,     0,     0,  3115,     0,
       0,     0,     0,     0,     0,     0,  1369,  1370,  1371,  1372,
       0,     0,   573,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3575,     0,  1542,  1543,     0,     0,     0,
       0,  2746,     0,     0,  2747,     0,     0,     0,     0,     0,
       0,     0,  2748,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -460,  -460,  1545,
       0,  2749,     0,     0,  3166,  3167,  -460,     0,     0,     0,
    1546,     0,     0,     0,     0,  2712,     0,  1571,  2750,  1547,
       0,     0,     0,     0,     0,     0,  1572,     0,  3641,     0,
       0,     0,     0,     0,     0,     0,     0,  3652,  1549,  2751,
       0,  2752,  1373,     0,  1374,  1375,  1376,     0,     0,     0,
       0,     0,     0,  1098,  1377,     0,  1550,     0,     0,     0,
    2753,  2754,     0,     0,     0,     0,     0,     0,     0,     0,
    1788,     0,  3683,     0,     0,     0,     0,     0,  3689,     0,
       0,     0,     0,     0,     0,  1555,     0,   573,  3536,     0,
       0,  1788,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2755,     0,     0,     0,     0,     0,  1788,     0,     0,
       0,     0,     0,  3723,     0,  3536,  3536,     0,     0,     0,
    1378,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2756,     0,     0,     0,     0,     0,     0,     0,  3723,  2757,
    2758,     0,  2759,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3536,  3536,     0,  1558,
       0,  3536,     0,     0,     0,     0,  1559,  1379,  1380,     0,
    2760,  2761,  2762,     0,  2712,     0,     0,  3536,     0,  3536,
       0,     0,     0,     0,     0,     0,     0,  2677,     0,     0,
       0,  2763,  2764,  2765,     0,  3536,     0,  2766,     0,     0,
    2767,     0,     0,     0,  3536,     0,     0,     0,     0,     0,
       0,     0,     0,  2768,  2769,     0,     0,     0,  3536,     0,
       0,  3536,     0,     0,     0,     0,     0,     0,     0,  3536,
       0,     0,     0,     0,  1560,  3536,     0,     0,     0,  2770,
       0,  2771,     0,     0,     0,     0,     0,     0,     0,  1561,
    3536,     0,     0,     0,     0,     0,  3536,     0,     0,  3536,
       0,     0,     0,     0,     0,  2772,     0,  3536,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3536,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3536,  1381,  3536,     0,     0,  3378,     0,
    1564,     0,     0,  1565,  3380,  1382,  1383,  3536,  3536,     0,
       0,  3536,     0,     0,     0,     0,     0,     0,  2773,     0,
    2774,     0,     0,     0,     0,     0,  1566,  1567,     0,  1568,
    2775,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3396,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3408,     0,  3410,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1570,     0,     0,     0,     0,
       0,     0,     0,     0,  2776,  2777,     0,     0,  2778,  2779,
    2780,  2781,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2782,  2783,     0,  2712,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2784,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1571,
       0,     0,     0,     0,     0,     0,     0,     0,  1572,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3499,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3513,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3578,
    3579,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3599,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3610,     0,
       0,     0,     0,  3614,     0,     0,     0,     0,     0,     0,
       0,     0,  3624,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   122,     0,   752,   124,   125,   126,   127,     0,
       0,     0,     0,  3656,   128,     0,     0,   753,     0,   754,
     130,   131,   755,   133,  3664,   134,   756,   135,     0,   757,
     136,   758,   759,   760,   137,   761,     0,   138,   139,   140,
    1776,   141,     0,   142,   143,     0,     0,   144,   762,   145,
       0,   146,   763,   764,   148,     0,   149,   150,   151,   765,
     152,     0,   766,   154,     0,   155,   156,   157,   158,   159,
     767,   768,   160,     0,   161,   162,     0,   769,   164,     0,
     770,   771,   772,   165,     0,  3724,   166,   773,   774,     0,
     775,   776,     0,   167,   168,   777,   778,   779,     0,     0,
       0,     0,   780,   171,   781,     0,     0,   782,   783,   172,
       0,   173,     0,     0,     0,   784,   785,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   786,   182,     0,   787,   788,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   789,
       0,   191,   790,   192,   791,   792,   193,   194,     0,   793,
     195,   196,   197,   794,     0,   198,     0,     0,   795,     0,
     199,   200,     0,   796,   201,     0,   202,   797,   798,   799,
     800,     0,   801,   802,   204,   803,   804,   805,   206,     0,
     207,   806,     0,   807,   808,     0,   208,   209,     0,   210,
     809,     0,   211,     0,     0,     0,   810,   213,   214,   215,
     811,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     812,   219,   813,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   814,
     226,     0,  1777,   815,   227,     0,   816,   228,     0,     0,
       0,   817,     0,   818,     0,   230,   819,     0,   231,     0,
     232,   820,     0,     0,   821,     0,     0,     0,     0,   822,
     233,   234,   235,   236,   237,   238,   823,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   824,   248,   249,   250,
     825,   251,   252,     0,     0,     0,   253,   254,   255,   826,
     257,     0,     0,   827,   259,   828,   829,   260,     0,   261,
     830,   831,   832,   833,   834,   835,   836,   266,   267,   268,
     269,     0,   837,   270,   271,     0,   272,   273,   274,   838,
     839,   840,   275,     0,   841,   842,     0,   276,   277,     0,
     843,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   844,   845,
     286,   846,   847,   848,   849,   850,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   851,   297,   298,
     299,   300,   301,   302,   303,   852,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   853,   854,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   855,   318,   319,   856,   320,   321,   857,
     322,   858,   324,   325,     0,   859,   327,     0,   328,   860,
     330,   331,   332,   333,   334,   335,   336,   337,     0,     0,
     338,   339,   340,     0,     0,   341,     0,     0,     0,   342,
     343,   344,   345,     0,   346,   347,   348,     0,     0,     0,
       0,     0,     0,   349,   350,     0,   351,     0,     0,   352,
       0,     0,   353,   354,   861,   862,   355,   356,     0,   357,
     863,   359,   864,   865,   866,   360,   361,   362,   363,   867,
     364,   365,     0,   366,   367,     0,   868,   368,   869,   870,
     871,   872,     0,     0,     0,     0,  1778,   373,     0,   374,
     873,   874,   875,   376,   377,   378,     0,   876,   379,   380,
     877,     0,   381,     0,     0,   878,   879,   382,     0,     0,
     383,     0,   384,     0,   880,   386,     0,     0,   881,   882,
     883,   884,   885,   387,     0,     0,   388,   886,     0,   389,
     390,   887,     0,     0,     0,     0,   392,     0,   393,   394,
       0,   888,     0,   889,     0,     0,     0,     0,   890,     0,
       0,     0,   891,   892,     0,     0,     0,     0,   893,     0,
     894,     0,     0,   895,   896,     0,   897,   898,   122,     0,
     752,   124,   125,   126,   127,  2673,     0,     0,     0,     0,
     128,     0,     0,   753,     0,   754,   130,   131,   755,   133,
       0,   134,   756,   135,     0,  2674,   136,   758,   759,   760,
     137,   761,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   762,   145,     0,   146,   763,   764,
     148,     0,   149,   150,   151,   765,   152,     0,   766,   154,
       0,   155,   156,   157,   158,   159,   767,   768,   160,     0,
     161,   162,     0,   769,   164,     0,   770,   771,   772,   165,
       0,     0,   166,   773,   774,     0,   775,   776,     0,   167,
     168,   777,   778,   779,     0,     0,     0,     0,   780,   171,
     781,     0,     0,   782,  2675,   172,     0,   173,     0,     0,
       0,   784,   785,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,   786,
     182,     0,   787,   788,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,   789,     0,   191,   790,   192,
     791,   792,   193,   194,     0,   793,   195,   196,   197,   794,
       0,   198,     0,     0,   795,     0,   199,   200,     0,   796,
     201,     0,   202,   797,   798,   799,   800,     0,   801,   802,
     204,   803,   804,   805,   206,     0,   207,   806,     0,   807,
     808,     0,   208,   209,     0,   210,   809,     0,   211,     0,
       0,     0,   810,   213,   214,   215,   811,     0,   216,   217,
       0,     0,     0,   218,     0,     0,   812,   219,   813,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   814,   226,     0,     0,   815,
     227,     0,   816,   228,     0,     0,     0,   817,     0,   818,
       0,   230,   819,     0,   231,     0,   232,   820,     0,     0,
     821,     0,     0,     0,     0,   822,   233,   234,   235,   236,
     237,   238,   823,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   824,   248,   249,   250,   825,   251,   252,     0,
       0,     0,   253,   254,   255,   826,   257,     0,     0,   827,
     259,   828,   829,   260,     0,   261,   830,   831,   832,   833,
     834,   835,   836,   266,   267,   268,   269,     0,   837,   270,
     271,     0,   272,   273,   274,   838,   839,   840,   275,     0,
     841,   842,     0,   276,   277,     0,   843,  2676,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   844,   845,   286,   846,   847,   848,
     849,   850,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   851,   297,   298,   299,   300,   301,   302,
     303,   852,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,   853,   854,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,   855,
     318,   319,   856,   320,   321,   857,   322,   858,   324,   325,
       0,   859,   327,     0,   328,   860,   330,   331,   332,   333,
     334,   335,   336,   337,     0,     0,   338,   339,   340,     0,
       0,   341,     0,     0,     0,   342,   343,   344,   345,     0,
     346,   347,   348,     0,     0,     0,     0,     0,     0,   349,
     350,     0,   351,     0,     0,   352,     0,     0,   353,   354,
     861,   862,   355,   356,     0,   357,   863,   359,   864,   865,
     866,   360,   361,   362,   363,   867,   364,   365,     0,   366,
     367,     0,   868,   368,   869,   870,   871,   872,     0,     0,
       0,     0,     0,   373,     0,   374,   873,   874,   875,   376,
     377,   378,     0,   876,   379,   380,   877,     0,   381,     0,
       0,   878,   879,   382,     0,     0,   383,     0,   384,     0,
     880,   386,     0,     0,   881,   882,   883,   884,   885,   387,
       0,     0,   388,   886,     0,   389,   390,   887,     0,     0,
       0,     0,   392,     0,   393,   394,     0,   888,     0,   889,
       0,     0,     0,     0,   890,     0,     0,     0,   891,   892,
       0,     0,     0,     0,   893,     0,   894,     0,     0,   895,
     896,     0,   897,   898,   122,     0,   752,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   753,
       0,   754,   130,   131,   755,   133,     0,   134,   756,   135,
       0,   757,   136,   758,   759,   760,   137,   761,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     762,   145,     0,   146,   763,   764,   148,     0,   149,   150,
     151,   765,   152,     0,   766,   154,     0,   155,   156,   157,
     158,   159,   767,   768,   160,     0,   161,   162,     0,   769,
     164,     0,   770,   771,   772,   165,     0,     0,   166,   773,
     774,     0,   775,   776,     0,   167,   168,   777,   778,   779,
       0,     0,     0,     0,   780,   171,   781,     0,     0,   782,
     783,   172,     0,   173,     0,     0,     0,   784,   785,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,   786,   182,     0,   787,   788,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,   789,     0,   191,   790,   192,   791,   792,   193,   194,
       0,   793,   195,   196,   197,   794,     0,   198,     0,     0,
     795,     0,   199,   200,     0,   796,   201,     0,   202,   797,
     798,   799,   800,     0,   801,   802,   204,   803,   804,   805,
     206,     0,   207,   806,     0,   807,   808,     0,   208,   209,
       0,   210,   809,     0,   211,     0,     0,     0,   810,   213,
     214,   215,   811,     0,   216,   217,     0,     0,     0,   218,
       0,     0,   812,   219,   813,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   814,   226,     0,     0,   815,   227,     0,   816,   228,
       0,     0,     0,   817,     0,   818,     0,   230,   819,     0,
     231,     0,   232,   820,     0,     0,   821,     0,     0,     0,
       0,   822,   233,   234,   235,   236,   237,   238,   823,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   824,   248,
     249,   250,   825,   251,   252,     0,     0,     0,   253,   254,
     255,   826,   257,     0,     0,   827,   259,   828,   829,   260,
       0,   261,   830,   831,   832,   833,   834,   835,   836,   266,
     267,   268,   269,     0,   837,   270,   271,     0,   272,   273,
     274,   838,   839,   840,   275,     0,   841,   842,     0,   276,
     277,     0,   843,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     844,   845,   286,   846,   847,   848,   849,   850,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   851,
     297,   298,   299,   300,   301,   302,   303,   852,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,   853,   854,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,   855,   318,   319,   856,   320,
     321,   857,   322,   858,   324,   325,     0,   859,   327,  1321,
     328,   860,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,   861,   862,   355,   356,
       0,   357,   863,   359,   864,   865,   866,   360,   361,   362,
     363,   867,   364,   365,     0,   366,   367,     0,   868,   368,
     869,   870,   871,   872,     0,     0,     0,     0,     0,   373,
       0,   374,   873,   874,   875,   376,   377,   378,     0,   876,
     379,   380,   877,     0,   381,     0,     0,   878,   879,   382,
       0,     0,   383,     0,   384,     0,   880,   386,     0,     0,
     881,   882,   883,   884,   885,   387,     0,     0,   388,   886,
       0,   389,   390,   887,     0,     0,     0,     0,   392,     0,
     393,   394,     0,   888,     0,   889,     0,     0,     0,     0,
     890,     0,     0,     0,   891,   892,     0,     0,     0,     0,
     893,     0,  1322,     0,     0,   895,   896,     0,   897,   898,
     122,     0,   752,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   753,     0,   754,   130,   131,
     755,   133,     0,   134,   756,   135,     0,   757,   136,   758,
     759,   760,   137,   761,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   762,   145,     0,   146,
     763,   764,   148,     0,   149,   150,   151,   765,   152,     0,
     766,   154,     0,   155,   156,   157,   158,   159,   767,   768,
     160,     0,   161,   162,     0,   769,   164,     0,   770,   771,
     772,   165,     0,     0,   166,   773,   774,     0,   775,   776,
       0,   167,   168,   777,   778,   779,     0,     0,     0,     0,
     780,   171,   781,     0,     0,   782,   783,   172,     0,   173,
       0,     0,     0,   784,   785,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,   786,   182,     0,   787,   788,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,   789,     0,   191,
     790,   192,   791,   792,   193,   194,     0,   793,   195,   196,
     197,   794,     0,   198,     0,     0,   795,     0,   199,   200,
       0,   796,   201,     0,   202,   797,   798,   799,   800,     0,
     801,   802,   204,   803,   804,   805,   206,     0,   207,   806,
       0,   807,   808,     0,   208,   209,     0,   210,   809,     0,
     211,     0,     0,     0,   810,   213,   214,   215,   811,     0,
     216,   217,     0,     0,     0,   218,     0,     0,   812,   219,
     813,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   814,   226,     0,
       0,   815,   227,     0,   816,   228,     0,     0,     0,   817,
       0,   818,     0,   230,   819,     0,   231,     0,   232,   820,
       0,     0,   821,     0,     0,     0,     0,   822,   233,   234,
     235,   236,   237,   238,   823,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   824,   248,   249,   250,   825,   251,
     252,     0,     0,     0,   253,   254,   255,   826,   257,     0,
       0,   827,   259,   828,   829,   260,     0,   261,   830,   831,
     832,   833,   834,   835,   836,   266,   267,   268,   269,     0,
     837,   270,   271,     0,   272,   273,   274,   838,   839,   840,
     275,     0,   841,   842,     0,   276,   277,     0,   843,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   844,   845,   286,   846,
     847,   848,   849,   850,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   851,   297,   298,   299,   300,
     301,   302,   303,   852,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,   853,
     854,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,   855,   318,   319,   856,   320,   321,   857,   322,   858,
     324,   325,     0,   859,   327,     0,   328,   860,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,   343,   344,
     345,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
     353,   354,   861,   862,   355,   356,     0,   357,   863,   359,
     864,   865,   866,   360,   361,   362,   363,   867,   364,   365,
       0,   366,   367,     0,   868,   368,   869,   870,   871,   872,
       0,     0,     0,     0,     0,   373,     0,   374,   873,   874,
     875,   376,   377,   378,     0,   876,   379,   380,   877,     0,
     381,     0,     0,   878,   879,   382,     0,     0,   383,     0,
     384,     0,   880,   386,     0,     0,   881,   882,   883,   884,
     885,   387,     0,     0,   388,   886,     0,   389,   390,   887,
       0,     0,     0,     0,   392,     0,   393,   394,     0,   888,
       0,   889,     0,     0,     0,     0,   890,     0,     0,     0,
     891,   892,     0,     0,     0,     0,   893,     0,   894,  1610,
       0,   895,   896,     0,   897,   898,   122,     0,   752,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   753,     0,   754,   130,   131,   755,   133,     0,   134,
     756,   135,     0,   757,   136,   758,   759,   760,   137,   761,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   762,   145,     0,   146,   763,   764,   148,     0,
     149,   150,   151,   765,   152,     0,   766,   154,     0,   155,
     156,   157,   158,   159,   767,   768,   160,     0,   161,   162,
       0,   769,   164,     0,   770,   771,   772,   165,     0,     0,
     166,   773,   774,     0,   775,   776,     0,   167,   168,   777,
     778,   779,     0,     0,     0,     0,   780,   171,   781,     0,
       0,   782,   783,   172,     0,   173,     0,     0,     0,   784,
     785,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   786,   182,     0,
     787,   788,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   789,     0,   191,   790,   192,   791,   792,
     193,   194,     0,   793,   195,   196,   197,   794,     0,   198,
       0,     0,   795,     0,   199,   200,     0,   796,   201,     0,
     202,   797,   798,   799,   800,     0,   801,   802,   204,   803,
     804,   805,   206,     0,   207,   806,     0,   807,   808,     0,
     208,   209,     0,   210,   809,     0,   211,     0,     0,     0,
     810,   213,   214,   215,   811,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   812,   219,   813,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   814,   226,     0,     0,   815,   227,     0,
     816,   228,     0,     0,     0,   817,     0,   818,     0,   230,
     819,     0,   231,     0,   232,   820,     0,     0,   821,     0,
       0,     0,     0,   822,   233,   234,   235,   236,   237,   238,
     823,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     824,   248,   249,   250,   825,   251,   252,     0,     0,     0,
     253,   254,   255,   826,   257,     0,     0,   827,   259,   828,
     829,   260,     0,   261,   830,   831,   832,   833,   834,   835,
     836,   266,   267,   268,   269,     0,   837,   270,   271,     0,
     272,   273,   274,   838,   839,   840,   275,     0,   841,   842,
       0,   276,   277,     0,   843,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   844,   845,   286,   846,   847,   848,   849,   850,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   851,   297,   298,   299,   300,   301,   302,   303,   852,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   853,   854,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   855,   318,   319,
     856,   320,   321,   857,   322,   858,   324,   325,     0,   859,
     327,     0,   328,   860,   330,   331,   332,   333,   334,   335,
     336,   337,     0,     0,   338,   339,   340,     0,     0,   341,
       0,     0,     0,   342,   343,   344,   345,     0,   346,   347,
     348,     0,     0,     0,     0,     0,     0,   349,   350,     0,
     351,     0,     0,   352,     0,     0,   353,   354,   861,   862,
     355,   356,     0,   357,   863,   359,   864,   865,   866,   360,
     361,   362,   363,   867,   364,   365,     0,   366,   367,     0,
     868,   368,   869,   870,   871,   872,     0,     0,     0,     0,
       0,   373,     0,   374,   873,   874,   875,   376,   377,   378,
       0,   876,   379,   380,   877,     0,   381,     0,     0,   878,
     879,   382,     0,     0,   383,     0,   384,     0,   880,   386,
       0,     0,   881,   882,   883,   884,   885,   387,     0,     0,
     388,   886,     0,   389,   390,   887,     0,     0,     0,     0,
     392,     0,   393,   394,     0,   888,     0,   889,     0,     0,
       0,     0,   890,     0,     0,     0,   891,   892,     0,     0,
       0,     0,   893,     0,   894,  1717,     0,   895,   896,     0,
     897,   898,   122,     0,   752,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   753,     0,   754,
     130,   131,   755,   133,     0,   134,   756,   135,     0,   757,
     136,   758,   759,   760,   137,   761,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   762,   145,
       0,   146,   763,   764,   148,     0,   149,   150,   151,   765,
     152,     0,   766,   154,     0,   155,   156,   157,   158,   159,
     767,   768,   160,     0,   161,   162,     0,   769,   164,     0,
     770,   771,   772,   165,     0,     0,   166,   773,   774,     0,
     775,   776,     0,   167,   168,   777,   778,   779,     0,     0,
       0,     0,   780,   171,   781,     0,     0,   782,   783,   172,
       0,   173,     0,     0,     0,   784,   785,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   786,   182,     0,   787,   788,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   789,
       0,   191,   790,   192,   791,   792,   193,   194,     0,   793,
     195,   196,   197,   794,     0,   198,     0,     0,   795,     0,
     199,   200,     0,   796,   201,     0,   202,   797,   798,   799,
     800,     0,   801,   802,   204,   803,   804,   805,   206,     0,
     207,   806,     0,   807,   808,     0,   208,   209,     0,   210,
     809,     0,   211,     0,     0,     0,   810,   213,   214,   215,
     811,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     812,   219,   813,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   814,
     226,     0,     0,   815,   227,     0,   816,   228,     0,     0,
       0,   817,     0,   818,     0,   230,   819,     0,   231,     0,
     232,   820,     0,     0,   821,     0,     0,     0,     0,   822,
     233,   234,   235,   236,   237,   238,   823,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   824,   248,   249,   250,
     825,   251,   252,     0,     0,     0,   253,   254,   255,   826,
     257,     0,     0,   827,   259,   828,   829,   260,     0,   261,
     830,   831,   832,   833,   834,   835,   836,   266,   267,   268,
     269,     0,   837,   270,   271,     0,   272,   273,   274,   838,
     839,   840,   275,     0,   841,   842,     0,   276,   277,     0,
     843,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   844,   845,
     286,   846,   847,   848,   849,   850,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   851,   297,   298,
     299,   300,   301,   302,   303,   852,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   853,   854,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   855,   318,   319,   856,   320,   321,   857,
     322,   858,   324,   325,     0,   859,   327,     0,   328,   860,
     330,   331,   332,   333,   334,   335,   336,   337,     0,     0,
     338,   339,   340,     0,     0,   341,     0,     0,     0,   342,
     343,   344,   345,     0,   346,   347,   348,     0,     0,     0,
       0,     0,     0,   349,   350,     0,   351,     0,     0,   352,
       0,     0,   353,   354,   861,   862,   355,   356,     0,   357,
     863,   359,   864,   865,   866,   360,   361,   362,   363,   867,
     364,   365,     0,   366,   367,     0,   868,   368,   869,   870,
     871,   872,     0,     0,     0,     0,     0,   373,     0,   374,
     873,   874,   875,   376,   377,   378,     0,   876,   379,   380,
     877,     0,   381,     0,     0,   878,   879,   382,     0,     0,
     383,     0,   384,     0,   880,   386,     0,     0,   881,   882,
     883,   884,   885,   387,     0,     0,   388,   886,     0,   389,
     390,   887,     0,     0,     0,     0,   392,     0,   393,   394,
       0,   888,     0,   889,     0,     0,     0,     0,   890,     0,
       0,     0,   891,   892,     0,     0,     0,     0,   893,     0,
     894,  1754,     0,   895,   896,     0,   897,   898,   122,     0,
     752,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   753,     0,   754,   130,   131,   755,   133,
       0,   134,   756,   135,     0,   757,   136,   758,   759,   760,
     137,   761,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   762,   145,     0,   146,   763,   764,
     148,     0,   149,   150,   151,   765,   152,     0,   766,   154,
       0,   155,   156,   157,   158,   159,   767,   768,   160,     0,
     161,   162,     0,   769,   164,     0,   770,   771,   772,   165,
       0,     0,   166,   773,   774,     0,   775,   776,     0,   167,
     168,   777,   778,   779,     0,     0,     0,     0,   780,   171,
     781,     0,     0,   782,   783,   172,     0,   173,     0,     0,
       0,   784,   785,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,   786,
     182,     0,   787,   788,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,   789,     0,   191,   790,   192,
     791,   792,   193,   194,     0,   793,   195,   196,   197,   794,
       0,   198,     0,     0,   795,     0,   199,   200,     0,   796,
     201,     0,   202,   797,   798,   799,   800,     0,   801,   802,
     204,   803,   804,   805,   206,     0,   207,   806,     0,   807,
     808,     0,   208,   209,     0,   210,   809,     0,   211,     0,
       0,     0,   810,   213,   214,   215,   811,     0,   216,   217,
       0,     0,     0,   218,     0,     0,   812,   219,   813,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   814,   226,     0,     0,   815,
     227,     0,   816,   228,     0,     0,     0,   817,     0,   818,
       0,   230,   819,     0,   231,     0,   232,   820,     0,     0,
     821,     0,     0,     0,     0,   822,   233,   234,   235,   236,
     237,   238,   823,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   824,   248,   249,   250,   825,   251,   252,     0,
       0,     0,   253,   254,   255,   826,   257,     0,     0,   827,
     259,   828,   829,   260,     0,   261,   830,   831,   832,   833,
     834,   835,   836,   266,   267,   268,   269,     0,   837,   270,
     271,     0,   272,   273,   274,   838,   839,   840,   275,     0,
     841,   842,     0,   276,   277,     0,   843,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   844,   845,   286,   846,   847,   848,
     849,   850,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   851,   297,   298,   299,   300,   301,   302,
     303,   852,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,   853,   854,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,   855,
     318,   319,   856,   320,   321,   857,   322,   858,   324,   325,
       0,   859,   327,     0,   328,   860,   330,   331,   332,   333,
     334,   335,   336,   337,     0,     0,   338,   339,   340,     0,
       0,   341,     0,     0,     0,   342,   343,   344,   345,     0,
     346,   347,   348,     0,     0,     0,     0,     0,     0,   349,
     350,     0,   351,     0,     0,   352,     0,     0,   353,   354,
     861,   862,   355,   356,     0,   357,   863,   359,   864,   865,
     866,   360,   361,   362,   363,   867,   364,   365,     0,   366,
     367,     0,   868,   368,   869,   870,   871,   872,     0,     0,
       0,     0,     0,   373,     0,   374,   873,   874,   875,   376,
     377,   378,     0,   876,   379,   380,   877,     0,   381,     0,
       0,   878,   879,   382,     0,     0,   383,     0,   384,     0,
     880,   386,     0,     0,   881,   882,   883,   884,   885,   387,
       0,     0,   388,   886,     0,   389,   390,   887,     0,     0,
       0,     0,   392,     0,   393,   394,     0,   888,     0,   889,
       0,     0,     0,     0,   890,     0,     0,     0,   891,   892,
       0,     0,     0,     0,   893,     0,   894,  1782,     0,   895,
     896,     0,   897,   898,   122,     0,   752,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   753,
       0,   754,   130,   131,   755,   133,     0,   134,   756,   135,
       0,   757,   136,   758,   759,   760,   137,   761,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     762,   145,     0,   146,   763,   764,   148,     0,   149,   150,
     151,   765,   152,     0,   766,   154,     0,   155,   156,   157,
     158,   159,   767,   768,   160,     0,   161,   162,     0,   769,
     164,     0,   770,   771,   772,   165,     0,     0,   166,   773,
     774,     0,   775,   776,     0,   167,   168,   777,   778,   779,
       0,     0,     0,     0,   780,   171,   781,     0,     0,   782,
     783,   172,     0,   173,     0,     0,     0,   784,   785,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,   786,   182,     0,   787,   788,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,   789,     0,   191,   790,   192,   791,   792,   193,   194,
       0,   793,   195,   196,   197,   794,     0,   198,     0,     0,
     795,     0,   199,   200,  2228,   796,   201,     0,   202,   797,
     798,   799,   800,     0,   801,   802,   204,   803,   804,   805,
     206,     0,   207,   806,     0,   807,   808,     0,   208,   209,
       0,   210,   809,     0,   211,     0,     0,     0,   810,   213,
     214,   215,   811,     0,   216,   217,     0,     0,     0,   218,
       0,     0,   812,   219,   813,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   814,   226,     0,     0,   815,   227,     0,   816,   228,
       0,     0,     0,   817,     0,   818,     0,   230,   819,     0,
     231,     0,   232,   820,     0,     0,   821,     0,     0,     0,
       0,   822,   233,   234,   235,   236,   237,   238,   823,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   824,   248,
     249,   250,   825,   251,   252,     0,     0,     0,   253,   254,
     255,   826,   257,     0,     0,   827,   259,   828,   829,   260,
       0,   261,   830,   831,   832,   833,   834,   835,   836,   266,
     267,   268,   269,     0,   837,   270,   271,     0,   272,   273,
     274,   838,   839,   840,   275,     0,   841,   842,     0,   276,
     277,     0,   843,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     844,   845,   286,   846,   847,   848,   849,   850,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   851,
     297,   298,   299,   300,   301,   302,   303,   852,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,   853,   854,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,   855,   318,   319,   856,   320,
     321,   857,   322,   858,   324,   325,     0,   859,   327,     0,
     328,   860,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,   861,   862,   355,   356,
       0,   357,   863,   359,   864,   865,   866,   360,   361,   362,
     363,   867,   364,   365,     0,   366,   367,     0,   868,   368,
     869,   870,   871,   872,     0,     0,     0,     0,     0,   373,
       0,   374,   873,   874,   875,   376,   377,   378,     0,   876,
     379,   380,   877,     0,   381,     0,     0,   878,   879,   382,
       0,     0,   383,     0,   384,     0,   880,   386,     0,     0,
     881,   882,   883,   884,   885,   387,     0,     0,   388,   886,
       0,   389,   390,   887,     0,     0,     0,     0,   392,     0,
     393,   394,     0,   888,     0,   889,     0,     0,     0,     0,
     890,     0,     0,     0,   891,   892,     0,     0,     0,     0,
     893,     0,   894,     0,     0,   895,   896,     0,   897,   898,
     122,     0,   752,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   753,     0,   754,   130,   131,
     755,   133,     0,   134,   756,   135,     0,   757,   136,   758,
     759,   760,   137,   761,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   762,   145,     0,   146,
     763,   764,   148,     0,   149,   150,   151,   765,   152,     0,
     766,   154,     0,   155,   156,   157,   158,   159,   767,   768,
     160,     0,   161,   162,     0,   769,   164,     0,   770,   771,
     772,   165,     0,     0,   166,   773,   774,     0,   775,   776,
       0,   167,   168,   777,   778,   779,     0,     0,     0,     0,
     780,   171,   781,     0,     0,   782,   783,   172,     0,   173,
       0,     0,     0,   784,   785,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,   786,   182,     0,   787,   788,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,   789,     0,   191,
     790,   192,   791,   792,   193,   194,     0,   793,   195,   196,
     197,   794,     0,   198,     0,     0,   795,     0,   199,   200,
    2230,   796,   201,     0,   202,   797,   798,   799,   800,     0,
     801,   802,   204,   803,   804,   805,   206,     0,   207,   806,
       0,   807,   808,     0,   208,   209,     0,   210,   809,     0,
     211,     0,     0,     0,   810,   213,   214,   215,   811,     0,
     216,   217,     0,     0,     0,   218,     0,     0,   812,   219,
     813,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   814,   226,     0,
       0,   815,   227,     0,   816,   228,     0,     0,     0,   817,
       0,   818,     0,   230,   819,     0,   231,     0,   232,   820,
       0,     0,   821,     0,     0,     0,     0,   822,   233,   234,
     235,   236,   237,   238,   823,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   824,   248,   249,   250,   825,   251,
     252,     0,     0,     0,   253,   254,   255,   826,   257,     0,
       0,   827,   259,   828,   829,   260,     0,   261,   830,   831,
     832,   833,   834,   835,   836,   266,   267,   268,   269,     0,
     837,   270,   271,     0,   272,   273,   274,   838,   839,   840,
     275,     0,   841,   842,     0,   276,   277,     0,   843,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   844,   845,   286,   846,
     847,   848,   849,   850,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   851,   297,   298,   299,   300,
     301,   302,   303,   852,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,   853,
     854,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,   855,   318,   319,   856,   320,   321,   857,   322,   858,
     324,   325,     0,   859,   327,     0,   328,   860,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,   343,   344,
     345,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
     353,   354,   861,   862,   355,   356,     0,   357,   863,   359,
     864,   865,   866,   360,   361,   362,   363,   867,   364,   365,
       0,   366,   367,     0,   868,   368,   869,   870,   871,   872,
       0,     0,     0,     0,     0,   373,     0,   374,   873,   874,
     875,   376,   377,   378,     0,   876,   379,   380,   877,     0,
     381,     0,     0,   878,   879,   382,     0,     0,   383,     0,
     384,     0,   880,   386,     0,     0,   881,   882,   883,   884,
     885,   387,     0,     0,   388,   886,     0,   389,   390,   887,
       0,     0,     0,     0,   392,     0,   393,   394,     0,   888,
       0,   889,     0,     0,     0,     0,   890,     0,     0,     0,
     891,   892,     0,     0,     0,     0,   893,     0,   894,     0,
       0,   895,   896,     0,   897,   898,   122,     0,   752,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   753,     0,   754,   130,   131,   755,   133,     0,   134,
     756,   135,     0,   757,   136,   758,   759,   760,   137,   761,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   762,   145,     0,   146,   763,   764,   148,     0,
     149,   150,   151,   765,   152,     0,   766,   154,     0,   155,
     156,   157,   158,   159,   767,   768,   160,     0,   161,   162,
       0,   769,   164,     0,   770,   771,   772,   165,     0,     0,
     166,   773,   774,     0,   775,   776,     0,   167,   168,   777,
     778,   779,     0,     0,     0,     0,   780,   171,   781,     0,
       0,   782,   783,   172,     0,   173,     0,     0,     0,   784,
     785,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   786,   182,     0,
     787,   788,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   789,     0,   191,   790,   192,   791,   792,
     193,   194,     0,   793,   195,   196,   197,   794,     0,   198,
       0,     0,   795,     0,   199,   200,  2232,   796,   201,     0,
     202,   797,   798,   799,   800,     0,   801,   802,   204,   803,
     804,   805,   206,     0,   207,   806,     0,   807,   808,     0,
     208,   209,     0,   210,   809,     0,   211,     0,     0,     0,
     810,   213,   214,   215,   811,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   812,   219,   813,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   814,   226,     0,     0,   815,   227,     0,
     816,   228,     0,     0,     0,   817,     0,   818,     0,   230,
     819,     0,   231,     0,   232,   820,     0,     0,   821,     0,
       0,     0,     0,   822,   233,   234,   235,   236,   237,   238,
     823,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     824,   248,   249,   250,   825,   251,   252,     0,     0,     0,
     253,   254,   255,   826,   257,     0,     0,   827,   259,   828,
     829,   260,     0,   261,   830,   831,   832,   833,   834,   835,
     836,   266,   267,   268,   269,     0,   837,   270,   271,     0,
     272,   273,   274,   838,   839,   840,   275,     0,   841,   842,
       0,   276,   277,     0,   843,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   844,   845,   286,   846,   847,   848,   849,   850,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   851,   297,   298,   299,   300,   301,   302,   303,   852,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   853,   854,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   855,   318,   319,
     856,   320,   321,   857,   322,   858,   324,   325,     0,   859,
     327,     0,   328,   860,   330,   331,   332,   333,   334,   335,
     336,   337,     0,     0,   338,   339,   340,     0,     0,   341,
       0,     0,     0,   342,   343,   344,   345,     0,   346,   347,
     348,     0,     0,     0,     0,     0,     0,   349,   350,     0,
     351,     0,     0,   352,     0,     0,   353,   354,   861,   862,
     355,   356,     0,   357,   863,   359,   864,   865,   866,   360,
     361,   362,   363,   867,   364,   365,     0,   366,   367,     0,
     868,   368,   869,   870,   871,   872,     0,     0,     0,     0,
       0,   373,     0,   374,   873,   874,   875,   376,   377,   378,
       0,   876,   379,   380,   877,     0,   381,     0,     0,   878,
     879,   382,     0,     0,   383,     0,   384,     0,   880,   386,
       0,     0,   881,   882,   883,   884,   885,   387,     0,     0,
     388,   886,     0,   389,   390,   887,     0,     0,     0,     0,
     392,     0,   393,   394,     0,   888,     0,   889,     0,     0,
       0,     0,   890,     0,     0,     0,   891,   892,     0,     0,
       0,     0,   893,     0,   894,     0,     0,   895,   896,     0,
     897,   898,   122,     0,   752,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   753,     0,   754,
     130,   131,   755,   133,     0,   134,   756,   135,     0,   757,
     136,   758,   759,   760,   137,   761,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   762,   145,
       0,   146,   763,   764,   148,     0,   149,   150,   151,   765,
     152,     0,   766,   154,     0,   155,   156,   157,   158,   159,
     767,   768,   160,     0,   161,   162,     0,   769,   164,     0,
     770,   771,   772,   165,     0,     0,   166,   773,   774,     0,
     775,   776,     0,   167,   168,   777,   778,   779,     0,     0,
       0,     0,   780,   171,   781,     0,     0,   782,   783,   172,
       0,   173,     0,     0,     0,   784,   785,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   786,   182,     0,   787,   788,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   789,
       0,   191,   790,   192,   791,   792,   193,   194,     0,   793,
     195,   196,   197,   794,     0,   198,     0,     0,   795,     0,
     199,   200,     0,   796,   201,     0,   202,   797,   798,   799,
     800,     0,   801,   802,   204,   803,   804,   805,   206,     0,
     207,   806,     0,   807,   808,     0,   208,   209,     0,   210,
     809,     0,   211,     0,     0,     0,   810,   213,   214,   215,
     811,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     812,   219,   813,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   814,
     226,     0,     0,   815,   227,     0,   816,   228,     0,     0,
       0,   817,     0,   818,     0,   230,   819,     0,   231,     0,
     232,   820,     0,     0,   821,     0,     0,     0,     0,   822,
     233,   234,   235,   236,   237,   238,   823,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   824,   248,   249,   250,
     825,   251,   252,     0,     0,     0,   253,   254,   255,   826,
     257,     0,     0,   827,   259,   828,   829,   260,     0,   261,
     830,   831,   832,   833,   834,   835,   836,   266,   267,   268,
     269,     0,   837,   270,   271,     0,   272,   273,   274,   838,
     839,   840,   275,     0,   841,   842,     0,   276,   277,     0,
     843,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   844,   845,
     286,   846,   847,   848,   849,   850,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   851,   297,   298,
     299,   300,   301,   302,   303,   852,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   853,   854,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   855,   318,   319,   856,   320,   321,   857,
     322,   858,   324,   325,     0,   859,   327,     0,   328,   860,
     330,   331,   332,   333,   334,   335,   336,   337,     0,     0,
     338,   339,   340,     0,     0,   341,     0,     0,     0,   342,
     343,   344,   345,     0,   346,   347,   348,     0,     0,     0,
       0,     0,     0,   349,   350,     0,   351,     0,     0,   352,
       0,     0,   353,   354,   861,   862,   355,   356,     0,   357,
     863,   359,   864,   865,   866,   360,   361,   362,   363,   867,
     364,   365,     0,   366,   367,     0,   868,   368,   869,   870,
     871,   872,     0,     0,     0,     0,     0,   373,     0,   374,
     873,   874,   875,   376,   377,   378,     0,   876,   379,   380,
     877,     0,   381,     0,     0,   878,   879,   382,     0,     0,
     383,     0,   384,     0,   880,   386,     0,     0,   881,   882,
     883,   884,   885,   387,     0,     0,   388,   886,     0,   389,
     390,   887,     0,     0,     0,     0,   392,     0,   393,   394,
       0,   888,     0,   889,     0,     0,     0,     0,   890,     0,
       0,     0,   891,   892,     0,     0,     0,     0,   893,     0,
     894,     0,     0,   895,   896,     0,   897,   898,   122,     0,
     752,   124,   125,   126,   127,  1814,     0,     0,     0,     0,
    1815,     0,     0,   753,     0,   754,   130,   131,   755,   133,
       0,   134,   756,   135,     0,   757,   136,   758,   759,   760,
     137,   761,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   762,   145,     0,   146,   763,   764,
     148,     0,   149,   150,   151,   765,   152,     0,   766,   154,
       0,   155,   156,   157,   158,   159,   767,   768,   160,     0,
     161,   162,     0,   769,   164,     0,   770,   771,   772,   165,
       0,     0,   166,   773,   774,     0,   775,   776,     0,   167,
     168,   777,   778,   779,     0,     0,     0,     0,   780,   171,
     781,     0,     0,   782,   783,   172,     0,   173,     0,     0,
       0,   784,   785,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,   786,
     182,     0,   787,   788,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,   789,     0,   191,   790,   192,
     791,   792,   193,   194,     0,   793,   195,   196,   197,   794,
       0,   198,     0,     0,   795,     0,   199,   200,     0,   796,
     201,     0,   202,   797,   798,   799,   800,     0,   801,   802,
     204,   803,   804,   805,   206,     0,   207,   806,     0,   807,
     808,     0,   208,   209,     0,   210,   809,     0,   211,     0,
       0,     0,   810,   213,   214,   215,   811,     0,   216,   217,
       0,     0,     0,   218,     0,     0,   812,   219,   813,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   814,   226,     0,     0,   815,
     227,     0,   816,   228,     0,     0,     0,   817,     0,   818,
       0,   230,   819,     0,   231,     0,   232,   820,     0,     0,
     821,     0,     0,     0,     0,   822,   233,   234,   235,   236,
     237,   238,   823,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   824,   248,   249,   250,   825,   251,   252,     0,
       0,     0,   253,   254,   255,   826,   257,     0,     0,   827,
     259,   828,   829,   260,     0,   261,   830,   831,   832,   833,
     834,   835,   836,   266,   267,   268,   269,     0,   837,   270,
     271,     0,   272,   273,   274,   838,     0,   840,   275,     0,
     841,   842,     0,   276,   277,     0,   843,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   844,   845,   286,   846,   847,   848,
     849,   850,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   851,   297,   298,   299,   300,   301,   302,
     303,   852,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,   853,   854,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,   855,
     318,   319,   856,   320,   321,   857,   322,   858,   324,   325,
       0,   859,   327,     0,   328,   860,   330,   331,   332,   333,
     334,   335,   336,   337,     0,     0,   338,   339,   340,     0,
       0,   341,     0,     0,     0,   342,   343,   344,   345,     0,
     346,   347,   348,     0,     0,     0,     0,     0,     0,   349,
     350,     0,   351,     0,     0,   352,     0,     0,   353,   354,
     861,   862,   355,   356,     0,   357,   863,   359,   864,   865,
     866,   360,   361,   362,   363,   867,   364,   365,     0,   366,
     367,     0,   868,   368,   869,   870,   871,   872,     0,     0,
       0,     0,     0,   373,     0,   374,   873,   874,   875,   376,
     377,   378,     0,   876,   379,   380,   877,     0,   381,     0,
       0,   878,   879,   382,     0,     0,   383,     0,   384,     0,
     880,   386,     0,     0,   881,   882,   883,   884,   885,   387,
       0,     0,   388,   886,     0,   389,   390,   887,     0,     0,
       0,     0,   392,     0,   393,   394,     0,   888,     0,   889,
       0,     0,     0,     0,   890,     0,     0,     0,   891,   892,
       0,     0,     0,     0,   893,     0,   894,     0,     0,   895,
     896,     0,   897,   898,   122,     0,   752,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   753,
       0,   754,   130,   131,   755,   133,     0,   134,   756,   135,
       0,   757,   136,   758,   759,   760,   137,   761,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     762,   145,     0,   146,   763,   764,   148,     0,   149,   150,
     151,   765,   152,     0,   766,   154,     0,   155,   156,   157,
     158,   159,   767,   768,   160,     0,   161,   162,     0,   769,
     164,     0,   770,   771,   772,   165,     0,     0,   166,   773,
     774,     0,   775,   776,     0,   167,   168,   777,   778,   779,
       0,     0,     0,     0,   780,   171,   781,     0,     0,   782,
     783,   172,     0,   173,     0,     0,     0,   784,   785,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,   786,   182,     0,   787,   788,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,   789,     0,   191,   790,   192,   791,   792,   193,   194,
       0,   793,   195,   196,   197,   794,     0,   198,     0,     0,
     795,     0,   199,   200,     0,   796,   201,     0,   202,   797,
     798,   799,   800,     0,   801,   802,   204,   803,   804,   805,
     206,     0,   207,   806,     0,   807,   808,     0,   208,   209,
       0,   210,   809,     0,   211,     0,     0,     0,   810,   213,
     214,   215,   811,     0,   216,   217,     0,     0,     0,   218,
       0,     0,   812,   219,  2504,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   814,   226,     0,     0,   815,   227,     0,   816,   228,
       0,     0,     0,   817,     0,   818,     0,   230,   819,     0,
     231,     0,   232,   820,     0,     0,   821,     0,     0,     0,
       0,   822,   233,   234,   235,   236,   237,   238,   823,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   824,   248,
     249,   250,   825,   251,   252,     0,     0,     0,   253,   254,
     255,   826,   257,     0,     0,   827,   259,   828,   829,   260,
       0,   261,   830,   831,   832,   833,   834,   835,   836,   266,
     267,   268,   269,     0,   837,   270,   271,     0,   272,   273,
     274,   838,   839,   840,   275,     0,   841,   842,     0,   276,
     277,     0,   843,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     844,   845,   286,   846,   847,   848,   849,   850,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   851,
     297,   298,   299,   300,   301,   302,   303,   852,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,   853,   854,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,   855,   318,   319,   856,   320,
     321,   857,   322,   858,   324,   325,     0,   859,   327,     0,
     328,   860,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,   861,   862,   355,   356,
       0,   357,   863,   359,   864,   865,   866,   360,   361,   362,
     363,   867,   364,   365,     0,   366,   367,     0,   868,   368,
     869,   870,   871,   872,     0,     0,     0,     0,     0,   373,
       0,   374,   873,   874,   875,   376,   377,   378,     0,   876,
     379,   380,   877,     0,   381,     0,     0,   878,   879,   382,
       0,     0,   383,     0,   384,     0,   880,   386,     0,     0,
     881,   882,   883,   884,   885,   387,     0,     0,   388,   886,
       0,   389,   390,   887,     0,     0,     0,     0,   392,     0,
     393,   394,     0,   888,     0,   889,     0,     0,     0,     0,
     890,     0,     0,     0,   891,   892,     0,     0,     0,     0,
     893,     0,   894,     0,     0,   895,   896,     0,   897,   898,
     122,     0,   752,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   753,     0,   754,   130,   131,
     755,   133,     0,   134,   756,   135,     0,   757,   136,   758,
     759,   760,   137,   761,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   762,   145,     0,   146,
     763,   764,   148,     0,   149,   150,   151,   765,   152,     0,
     766,   154,     0,   155,   156,   157,   158,   159,   767,   768,
     160,     0,   161,   162,     0,   769,   164,     0,   770,   771,
     772,   165,     0,     0,   166,   773,   774,     0,   775,   776,
       0,   167,   168,   777,   778,   779,     0,     0,     0,     0,
     780,   171,   781,     0,     0,   782,   783,   172,     0,   173,
       0,     0,     0,   784,   785,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,   786,   182,     0,   787,   788,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,   789,     0,   191,
     790,   192,   791,   792,   193,   194,     0,   793,   195,   196,
     197,   794,     0,   198,     0,     0,   795,     0,   199,   200,
       0,   796,   201,     0,   202,   797,   798,   799,   800,     0,
     801,   802,   204,   803,   804,   805,   206,     0,   207,   806,
       0,   807,   808,     0,   208,   209,     0,   210,   809,     0,
     211,     0,     0,     0,   810,   213,   214,   215,   811,     0,
     216,   217,     0,     0,     0,   218,     0,     0,   812,   219,
    2577,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   814,   226,     0,
       0,   815,   227,     0,   816,   228,     0,     0,     0,   817,
       0,   818,     0,   230,   819,     0,   231,     0,   232,   820,
       0,     0,   821,     0,     0,     0,     0,   822,   233,   234,
     235,   236,   237,   238,   823,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   824,   248,   249,   250,   825,   251,
     252,     0,     0,     0,   253,   254,   255,   826,   257,     0,
       0,   827,   259,   828,   829,   260,     0,   261,   830,   831,
     832,   833,   834,   835,   836,   266,   267,   268,   269,     0,
     837,   270,   271,     0,   272,   273,   274,   838,   839,   840,
     275,     0,   841,   842,     0,   276,   277,     0,   843,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   844,   845,   286,   846,
     847,   848,   849,   850,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   851,   297,   298,   299,   300,
     301,   302,   303,   852,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,   853,
     854,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,   855,   318,   319,   856,   320,   321,   857,   322,   858,
     324,   325,     0,   859,   327,     0,   328,   860,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,   343,   344,
     345,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
     353,   354,   861,   862,   355,   356,     0,   357,   863,   359,
     864,   865,   866,   360,   361,   362,   363,   867,   364,   365,
       0,   366,   367,     0,   868,   368,   869,   870,   871,   872,
       0,     0,     0,     0,     0,   373,     0,   374,   873,   874,
     875,   376,   377,   378,     0,   876,   379,   380,   877,     0,
     381,     0,     0,   878,   879,   382,     0,     0,   383,     0,
     384,     0,   880,   386,     0,     0,   881,   882,   883,   884,
     885,   387,     0,     0,   388,   886,     0,   389,   390,   887,
       0,     0,     0,     0,   392,     0,   393,   394,     0,   888,
       0,   889,     0,     0,     0,     0,   890,     0,     0,     0,
     891,   892,     0,     0,     0,     0,   893,     0,   894,     0,
       0,   895,   896,     0,   897,   898,   122,     0,   752,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   753,     0,   754,   130,   131,   755,   133,     0,   134,
     756,   135,     0,   757,   136,   758,   759,   760,   137,   761,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   762,   145,     0,   146,   763,   764,   148,     0,
     149,   150,   151,   765,   152,     0,   766,   154,     0,   155,
     156,   157,   158,   159,   767,   768,   160,     0,   161,   162,
       0,   769,   164,     0,   770,   771,   772,   165,     0,     0,
     166,   773,   774,     0,   775,   776,     0,   167,   168,   777,
     778,   779,     0,     0,     0,     0,   780,   171,   781,     0,
       0,   782,  2924,   172,     0,   173,     0,     0,     0,   784,
     785,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   786,   182,     0,
     787,   788,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   789,     0,   191,   790,   192,   791,   792,
     193,   194,     0,   793,   195,   196,   197,   794,     0,   198,
       0,     0,   795,     0,   199,   200,     0,   796,   201,     0,
     202,   797,   798,   799,   800,     0,   801,   802,   204,   803,
     804,   805,   206,     0,   207,   806,     0,   807,   808,     0,
     208,   209,     0,   210,   809,     0,   211,     0,     0,     0,
     810,   213,   214,   215,   811,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   812,   219,   813,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   814,   226,     0,     0,   815,   227,     0,
     816,   228,     0,     0,     0,   817,     0,   818,     0,   230,
     819,     0,   231,     0,   232,   820,     0,     0,   821,     0,
       0,     0,     0,   822,   233,   234,   235,   236,   237,   238,
     823,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     824,   248,   249,   250,   825,   251,   252,     0,     0,     0,
     253,   254,   255,   826,   257,     0,     0,   827,   259,   828,
     829,   260,     0,   261,   830,   831,   832,   833,   834,   835,
     836,   266,   267,   268,   269,     0,   837,   270,   271,     0,
     272,   273,   274,   838,   839,   840,   275,     0,   841,   842,
       0,   276,   277,     0,   843,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   844,   845,   286,   846,   847,   848,   849,   850,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   851,   297,   298,   299,   300,   301,   302,   303,   852,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   853,   854,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   855,   318,   319,
     856,   320,   321,   857,   322,   858,   324,   325,     0,   859,
     327,     0,   328,   860,   330,   331,   332,   333,   334,   335,
     336,   337,     0,     0,   338,   339,   340,     0,     0,   341,
       0,     0,     0,   342,   343,   344,   345,     0,   346,   347,
     348,     0,     0,     0,     0,     0,     0,   349,   350,     0,
     351,     0,     0,   352,     0,     0,   353,   354,   861,   862,
     355,   356,     0,   357,   863,   359,   864,   865,   866,   360,
     361,   362,   363,   867,   364,   365,     0,   366,   367,     0,
     868,   368,   869,   870,   871,   872,     0,     0,     0,     0,
       0,   373,     0,   374,   873,   874,   875,   376,   377,   378,
       0,   876,   379,   380,   877,     0,   381,     0,     0,   878,
     879,   382,     0,     0,   383,     0,   384,     0,   880,   386,
       0,     0,   881,   882,   883,   884,   885,   387,     0,     0,
     388,   886,     0,   389,   390,   887,     0,     0,     0,     0,
     392,     0,   393,   394,     0,   888,     0,   889,     0,     0,
       0,     0,   890,     0,     0,     0,   891,   892,     0,     0,
       0,     0,   893,     0,   894,     0,     0,   895,   896,     0,
     897,   898,   122,     0,   752,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   753,     0,   754,
     130,   131,   755,   133,     0,   134,   756,   135,     0,   757,
     136,   758,   759,   760,   137,   761,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   762,   145,
       0,   146,   763,   764,   148,     0,   149,   150,   151,   765,
     152,     0,   766,   154,     0,   155,   156,   157,   158,   159,
     767,   768,   160,     0,   161,   162,     0,   769,   164,     0,
     770,   771,   772,   165,     0,     0,   166,   773,   774,     0,
     775,   776,     0,   167,   168,   777,   778,   779,     0,     0,
       0,     0,   780,   171,   781,     0,     0,   782,   783,   172,
       0,   173,     0,     0,     0,   784,   785,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   786,   182,     0,   787,   788,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   789,
       0,   191,   790,   192,   791,   792,   193,   194,     0,   793,
     195,   196,   197,   794,     0,   198,     0,     0,   795,     0,
     199,   200,     0,   796,   201,     0,   202,   797,   798,   799,
     800,     0,   801,   802,   204,   803,   804,   805,   206,     0,
     207,   806,     0,   807,   808,     0,   208,   209,     0,   210,
     809,     0,   211,     0,     0,     0,   810,   213,   214,   215,
     811,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     812,   219,   813,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   814,
     226,     0,     0,   815,   227,     0,   816,   228,     0,     0,
       0,   817,     0,   818,     0,   230,   819,     0,   231,     0,
     232,   820,     0,     0,   821,     0,     0,     0,     0,   822,
     233,   234,   235,   236,   237,   238,   823,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   824,   248,   249,   250,
     825,   251,   252,     0,     0,     0,   253,   254,   255,   826,
     257,     0,     0,   827,   259,   828,   829,   260,     0,   261,
     830,   831,   832,   833,   834,   835,   836,   266,   267,   268,
     269,     0,   837,   270,   271,     0,   272,   273,   274,   838,
       0,   840,   275,     0,   841,   842,     0,   276,   277,     0,
     843,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   844,   845,
     286,   846,   847,   848,   849,   850,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   851,   297,   298,
     299,   300,   301,   302,   303,   852,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   853,   854,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   855,   318,   319,   856,   320,   321,   857,
     322,   858,   324,   325,     0,   859,   327,     0,   328,   860,
     330,   331,   332,   333,   334,   335,   336,   337,     0,     0,
     338,   339,   340,     0,     0,   341,     0,     0,     0,   342,
     343,   344,   345,     0,   346,   347,   348,     0,     0,     0,
       0,     0,     0,   349,   350,     0,   351,     0,     0,   352,
       0,     0,   353,   354,   861,   862,   355,   356,     0,   357,
     863,   359,   864,   865,   866,   360,   361,   362,   363,   867,
     364,   365,     0,   366,   367,     0,   868,   368,   869,   870,
     871,   872,     0,     0,     0,     0,     0,   373,     0,   374,
     873,   874,   875,   376,   377,   378,     0,   876,   379,   380,
     877,     0,   381,     0,     0,   878,   879,   382,     0,     0,
     383,     0,   384,     0,   880,   386,     0,     0,   881,   882,
     883,   884,   885,   387,     0,     0,   388,   886,     0,   389,
     390,   887,     0,     0,     0,     0,   392,     0,   393,   394,
       0,   888,     0,   889,     0,     0,     0,     0,   890,     0,
       0,     0,   891,   892,     0,     0,     0,     0,   893,     0,
     894,     0,     0,   895,   896,     0,   897,   898,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,  1992,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,  1993,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
    1117,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,  1118,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,  2488,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,  1901,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,     0,     0,   338,   339,   340,     0,
       0,   341,     0,     0,     0,   342,   343,   344,   345,     0,
     346,   347,   348,  1994,     0,     0,     0,     0,     0,   349,
     350,     0,   351,     0,     0,   352,     0,     0,   353,   354,
       0,     0,   355,   356,     0,   357,   358,   359,     0,     0,
       0,   360,   361,   362,   363,     0,   364,   365,     0,   366,
     367,     0,     0,   368,   369,   370,   371,   372,     0,     0,
       0,     0,     0,   373,     0,   374,     0,     0,   375,   376,
     377,   378,     0,     0,   379,   380,     0,     0,   381,     0,
       0,     0,     0,   382,     0,     0,   383,     0,   384,     0,
     385,   386,     0,     0,     0,     0,     0,     0,     0,   387,
       0,     0,   388,     0,     0,   389,   390,   391,     0,     0,
       0,     0,   392,     0,   393,   394,     0,     0,     0,   395,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,  2041,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,  1992,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,  1993,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,  1117,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,  1118,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,     0,     0,   338,
     339,   340,     0,     0,   341,     0,     0,     0,   342,   343,
     344,   345,     0,   346,   347,   348,  1994,     0,     0,     0,
       0,     0,   349,   350,     0,   351,     0,     0,   352,     0,
       0,   353,   354,     0,     0,   355,   356,     0,   357,   358,
     359,     0,     0,     0,   360,   361,   362,   363,     0,   364,
     365,     0,   366,   367,     0,     0,   368,   369,   370,   371,
     372,     0,     0,     0,     0,     0,   373,     0,   374,     0,
       0,   375,   376,   377,   378,     0,     0,   379,   380,     0,
       0,   381,     0,     0,     0,     0,   382,     0,     0,   383,
       0,   384,     0,   385,   386,     0,     0,     0,     0,     0,
       0,     0,   387,     0,     0,   388,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   392,     0,   393,   394,     0,
       0,     0,   395,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,  2041,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,  1901,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,     0,   395,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,  2313,     0,   130,   131,   132,   133,   898,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,     0,     0,   338,   339,   340,     0,     0,
     341,     0,     0,     0,   342,   343,   344,   345,     0,   346,
     347,   348,     0,     0,     0,     0,     0,     0,   349,   350,
       0,   351,     0,     0,   352,     0,     0,   353,   354,     0,
       0,   355,   356,     0,   357,   358,   359,     0,     0,     0,
     360,   361,   362,   363,     0,   364,   365,     0,   366,   367,
       0,     0,   368,   369,   370,   371,   372,     0,     0,     0,
       0,     0,   373,     0,   374,     0,     0,   375,   376,   377,
     378,     0,     0,   379,   380,     0,     0,   381,     0,     0,
       0,     0,   382,     0,     0,   383,     0,   384,     0,   385,
     386,     0,     0,     0,     0,     0,     0,     0,   387,     0,
       0,   388,     0,     0,   389,   390,   391,     0,     0,     0,
       0,   392,     0,   393,   394,     0,     0,     0,   395,     0,
       0,     0,     0,     0,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,  3676,   128,     0,     0,
     129,  3677,   898,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,   991,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,     0,   395,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
     431,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,     0,     0,   338,   339,   340,     0,
       0,   341,     0,     0,     0,   342,   343,   344,   345,     0,
     346,   347,   348,     0,     0,     0,     0,     0,     0,   349,
     350,     0,   351,     0,     0,   352,     0,     0,   353,   354,
       0,     0,   355,   356,     0,   357,   358,   359,     0,     0,
       0,   360,   361,   362,   363,     0,   364,   365,     0,   366,
     367,     0,     0,   368,   369,   370,   371,   372,     0,     0,
       0,     0,     0,   373,     0,   374,     0,     0,   375,   376,
     377,   378,     0,     0,   379,   380,     0,     0,   381,     0,
       0,     0,     0,   382,     0,     0,   383,     0,   384,     0,
     385,   386,     0,     0,     0,     0,     0,     0,     0,   387,
       0,     0,   388,     0,     0,   389,   390,   391,     0,     0,
       0,     0,   392,     0,   393,   394,     0,     0,     0,   395,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
    1859,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   431,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,     0,     0,   338,
     339,   340,     0,     0,   341,     0,     0,     0,   342,   343,
     344,   345,     0,   346,   347,   348,     0,     0,     0,     0,
       0,     0,   349,   350,     0,   351,     0,     0,   352,     0,
       0,   353,   354,     0,     0,   355,   356,     0,   357,   358,
     359,     0,     0,     0,   360,   361,   362,   363,     0,   364,
     365,     0,   366,   367,     0,     0,   368,   369,   370,   371,
     372,     0,     0,     0,     0,     0,   373,     0,   374,     0,
       0,   375,   376,   377,   378,     0,     0,   379,   380,     0,
       0,   381,     0,     0,     0,     0,   382,     0,     0,   383,
       0,   384,     0,   385,   386,     0,     0,     0,     0,     0,
       0,     0,   387,     0,     0,   388,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   392,     0,   393,   394,     0,
       0,     0,   395,     0,     0,     0,     0,     0,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,  2040,
       0,   128,     0,     0,   129,     0,  2041,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,   343,   344,   345,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,   353,
     354,     0,     0,   355,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,     0,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,   375,
     376,   377,   378,     0,     0,   379,   380,     0,     0,   381,
       0,     0,     0,     0,   382,     0,     0,   383,     0,   384,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   392,     0,   393,   394,     0,     0,     0,
     395,     0,     0,     0,     0,     0,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,  3677,   898,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,     0,     0,   338,   339,   340,     0,     0,
     341,     0,     0,     0,   342,   343,   344,   345,     0,   346,
     347,   348,     0,     0,     0,     0,     0,     0,   349,   350,
       0,   351,     0,     0,   352,     0,     0,   353,   354,     0,
       0,   355,   356,     0,   357,   358,   359,     0,     0,     0,
     360,   361,   362,   363,     0,   364,   365,     0,   366,   367,
       0,     0,   368,   369,   370,   371,   372,     0,     0,     0,
       0,     0,   373,     0,   374,     0,     0,   375,   376,   377,
     378,     0,     0,   379,   380,     0,     0,   381,     0,     0,
       0,     0,   382,     0,     0,   383,     0,   384,     0,   385,
     386,     0,     0,     0,     0,     0,     0,     0,   387,     0,
       0,   388,     0,     0,   389,   390,   391,     0,     0,     0,
       0,   392,     0,   393,   394,     0,     0,     0,   395,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,   431,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   485,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,   343,   344,
     345,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
     353,   354,     0,     0,   355,   356,     0,   357,   358,   359,
       0,     0,     0,   360,   361,   362,   363,     0,   364,   365,
       0,   366,   367,     0,     0,   368,   369,   370,   371,   372,
       0,     0,     0,     0,     0,   373,     0,   374,     0,     0,
     375,   376,   377,   378,     0,     0,   379,   380,     0,     0,
     381,     0,     0,     0,     0,   382,     0,     0,   383,     0,
     384,     0,   385,   386,     0,     0,     0,     0,     0,     0,
       0,   387,     0,     0,   388,     0,     0,   389,   390,   391,
       0,     0,     0,     0,   392,     0,   393,   394,     0,     0,
       0,   395,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   431,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,     0,
       0,   338,   339,   340,     0,     0,   341,     0,     0,     0,
     342,   343,   344,   345,     0,   346,   347,   348,     0,     0,
       0,     0,     0,     0,   349,   350,     0,   351,     0,     0,
     352,     0,     0,   353,   354,     0,     0,   355,   356,     0,
     357,   358,   359,     0,     0,     0,   360,   361,   362,   363,
       0,   364,   365,     0,   366,   367,     0,     0,   368,   369,
     370,   371,   372,     0,     0,     0,     0,     0,   373,     0,
     374,     0,     0,   375,   376,   377,   378,     0,     0,   379,
     380,     0,     0,   381,     0,     0,     0,     0,   382,     0,
       0,   383,     0,   384,     0,   385,   386,     0,     0,     0,
       0,     0,     0,     0,   387,     0,     0,   388,     0,     0,
     389,   390,   391,     0,     0,     0,     0,   392,     0,   393,
     394,     0,     0,     0,   395,     0,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,   898,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,     0,     0,   338,   339,   340,     0,     0,   341,
       0,     0,     0,   342,   343,   344,   345,     0,   346,   347,
     348,     0,     0,     0,     0,     0,     0,   349,   350,     0,
     351,     0,     0,   352,     0,     0,   353,   354,     0,     0,
     355,   356,     0,   357,   358,   359,     0,     0,     0,   360,
     361,   362,   363,     0,   364,   365,     0,   366,   367,     0,
       0,   368,   369,   370,   371,   372,     0,     0,     0,     0,
       0,   373,     0,   374,     0,     0,   375,   376,   377,   378,
       0,     0,   379,   380,     0,     0,   381,     0,     0,     0,
       0,   382,     0,     0,   383,     0,   384,     0,   385,   386,
       0,     0,     0,     0,     0,     0,     0,   387,     0,     0,
     388,     0,     0,   389,   390,   391,     0,     0,     0,     0,
     392,     0,   393,   394,     0,     0,     0,   395,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,  2041,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   570,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,   343,   344,   345,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,   353,
     354,     0,     0,   355,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,   571,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,   375,
     376,   377,   378,     0,     0,   379,   380,     0,     0,   381,
       0,     0,     0,     0,   382,     0,     0,   383,     0,   384,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   392,     0,   393,   394,     0,     0,   122,
     395,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,  1801,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   570,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,   343,   344,   345,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,   353,
     354,     0,     0,   355,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,   571,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,   375,
     376,   377,   378,     0,     0,   379,   380,     0,     0,   381,
       0,     0,     0,     0,   382,     0,     0,   383,     0,   384,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   392,     0,   393,   394,     0,     0,   122,
     395,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,  2353,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   570,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,   343,   344,   345,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,   353,
     354,     0,     0,   355,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,   571,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,   375,
     376,   377,   378,     0,     0,   379,   380,     0,     0,   381,
       0,     0,     0,     0,   382,     0,     0,   383,     0,   384,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   392,     0,   393,   394,     0,     0,   122,
     395,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,  2947,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,  3519,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,     0,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,  3520,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,  3521,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,  3522,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,  3523,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,  3524,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,  -186,     0,
     312,     0,     0,   314,     0,     0,   316,   317,  3525,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,     0,   344,     0,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,     0,
     354,     0,     0,     0,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,     0,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,     0,
     376,   377,   378,     0,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   382,     0,     0,   383,     0,     0,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,     0,
       0,  -186,     0,   392,     0,   393,     0,     0,     0,     0,
     395,     0,     0,     0,     0,  3526,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,  3728,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,     0,     0,   338,   339,   340,     0,     0,   341,
       0,     0,     0,   342,   343,   344,   345,     0,   346,   347,
     348,     0,     0,     0,     0,     0,     0,   349,   350,     0,
     351,     0,     0,   352,     0,     0,   353,   354,     0,     0,
     355,   356,     0,   357,   358,   359,     0,     0,     0,   360,
     361,   362,   363,     0,   364,   365,     0,   366,   367,     0,
       0,   368,   369,   370,   371,   372,     0,     0,     0,     0,
       0,   373,     0,   374,     0,     0,   375,   376,   377,   378,
       0,     0,   379,   380,     0,     0,   381,     0,     0,     0,
       0,   382,     0,     0,   383,     0,   384,     0,   385,   386,
       0,     0,     0,     0,     0,     0,     0,   387,     0,     0,
     388,     0,     0,   389,   390,   391,     0,     0,     0,     0,
     392,     0,   393,   394,     0,     0,     0,   395,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,  1649,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,     0,     0,   338,   339,   340,     0,
       0,   341,     0,     0,     0,   342,   343,   344,   345,     0,
     346,   347,   348,     0,     0,     0,     0,     0,     0,   349,
     350,     0,   351,     0,     0,   352,     0,     0,   353,   354,
       0,     0,   355,   356,     0,   357,   358,   359,     0,     0,
       0,   360,   361,   362,   363,     0,   364,   365,     0,   366,
     367,     0,     0,   368,   369,   370,   371,   372,     0,     0,
       0,     0,     0,   373,     0,   374,     0,     0,   375,   376,
     377,   378,     0,     0,   379,   380,     0,     0,   381,     0,
       0,     0,     0,   382,     0,     0,   383,     0,   384,     0,
     385,   386,     0,     0,     0,     0,     0,     0,     0,   387,
       0,     0,   388,     0,     0,   389,   390,   391,     0,     0,
       0,     0,   392,     0,   393,   394,     0,     0,     0,   395,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
    2339,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,   343,   344,
     345,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
     353,   354,     0,     0,   355,   356,     0,   357,   358,   359,
       0,     0,     0,   360,   361,   362,   363,     0,   364,   365,
       0,   366,   367,     0,     0,   368,   369,   370,   371,   372,
       0,     0,     0,     0,     0,   373,     0,   374,     0,     0,
     375,   376,   377,   378,     0,     0,   379,   380,     0,     0,
     381,     0,     0,     0,     0,   382,     0,     0,   383,     0,
     384,     0,   385,   386,     0,     0,     0,     0,     0,     0,
       0,   387,     0,     0,   388,     0,     0,   389,   390,   391,
       0,     0,     0,     0,   392,     0,   393,   394,     0,     0,
       0,   395,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,  2628,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,     0,     0,
     338,   339,   340,     0,     0,   341,     0,     0,     0,   342,
     343,   344,   345,     0,   346,   347,   348,     0,     0,     0,
       0,     0,     0,   349,   350,     0,   351,     0,     0,   352,
       0,     0,   353,   354,     0,     0,   355,   356,     0,   357,
     358,   359,     0,     0,     0,   360,   361,   362,   363,     0,
     364,   365,     0,   366,   367,     0,     0,   368,   369,   370,
     371,   372,     0,     0,     0,     0,     0,   373,     0,   374,
       0,     0,   375,   376,   377,   378,     0,     0,   379,   380,
       0,     0,   381,     0,     0,     0,     0,   382,     0,     0,
     383,     0,   384,     0,   385,   386,     0,     0,     0,     0,
       0,     0,     0,   387,     0,     0,   388,     0,     0,   389,
     390,   391,     0,     0,     0,     0,   392,     0,   393,   394,
       0,     0,     0,   395,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  2952,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3519,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,  -201,     0,   182,     0,     0,     0,
    -201,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3520,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3521,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3522,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3523,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3524,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3525,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,     0,   344,     0,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,     0,   354,     0,     0,     0,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,     0,   376,   377,   378,     0,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   382,
       0,     0,   383,     0,     0,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,  -186,     0,   392,     0,
     393,     0,     0,     0,     0,   395,     0,     0,  -201,   122,
    3526,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,  3519,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,  -222,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,  3520,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,  3521,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,  3522,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,  3523,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,  3524,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,  -186,     0,
     312,     0,     0,   314,     0,     0,   316,   317,  3525,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,     0,   344,     0,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,     0,
     354,     0,     0,     0,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,     0,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,     0,
     376,   377,   378,     0,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   382,     0,     0,   383,     0,     0,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,  -222,
       0,  -186,     0,   392,     0,   393,     0,     0,     0,     0,
     395,     0,     0,  -222,   122,  3526,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3519,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    -219,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3520,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3521,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3522,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3523,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3524,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3525,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,     0,   344,     0,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,     0,   354,     0,     0,     0,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,     0,   376,   377,   378,     0,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   382,
       0,     0,   383,     0,     0,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,  -219,     0,  -186,     0,   392,     0,
     393,     0,     0,     0,     0,   395,     0,     0,  -219,   122,
    3526,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,  3519,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,  3606,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,  3520,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,  3521,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,  3522,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,  3523,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,  3524,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,  -186,     0,
     312,     0,     0,   314,     0,     0,   316,   317,  3525,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,     0,   344,     0,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,     0,
     354,     0,     0,     0,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,     0,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,     0,
     376,   377,   378,     0,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   382,     0,     0,   383,     0,     0,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,     0,
       0,  -186,     0,   392,     0,   393,     0,     0,     0,     0,
     395,     0,     0,     0,   122,  3526,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3519,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    -224,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3520,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3521,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3522,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3523,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3524,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3525,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,     0,   344,     0,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,     0,   354,     0,     0,     0,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,     0,   376,   377,   378,     0,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   382,
       0,     0,   383,     0,     0,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,  -186,     0,   392,     0,
     393,     0,     0,     0,     0,   395,     0,     0,     0,   122,
    3526,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,  3519,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,  3653,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,  3520,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,  3521,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,  3522,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,  3523,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,  3524,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,  -186,     0,
     312,     0,     0,   314,     0,     0,   316,   317,  3525,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,     0,   344,     0,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,     0,
     354,     0,     0,     0,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,     0,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,     0,
     376,   377,   378,     0,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   382,     0,     0,   383,     0,     0,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,     0,
       0,  -186,     0,   392,     0,   393,     0,     0,     0,     0,
     395,     0,     0,     0,   122,  3526,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3519,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    3694,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3520,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3521,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3522,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3523,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3524,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3525,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,     0,   344,     0,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,     0,   354,     0,     0,     0,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,     0,   376,   377,   378,     0,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   382,
       0,     0,   383,     0,     0,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,  -186,     0,   392,     0,
     393,     0,     0,     0,     0,   395,     0,     0,     0,   122,
    3526,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,  3519,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,  -205,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,  3520,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,  3521,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,  3522,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,  3523,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,  3524,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,  -186,     0,
     312,     0,     0,   314,     0,     0,   316,   317,  3525,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,     0,   344,     0,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,     0,
     354,     0,     0,     0,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,     0,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,     0,
     376,   377,   378,     0,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   382,     0,     0,   383,     0,     0,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,     0,
       0,  -186,     0,   392,     0,   393,     0,     0,     0,     0,
     395,     0,     0,     0,   122,  3526,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3519,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
       0,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3520,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3521,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3522,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3523,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3524,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3525,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,     0,   344,     0,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,     0,   354,     0,     0,     0,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,     0,   376,   377,   378,     0,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   382,
       0,     0,   383,     0,     0,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,  -186,     0,   392,     0,
     393,     0,     0,     0,     0,   395,     0,     0,     0,   122,
    3526,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,  3519,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,     0,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,  3520,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,  3521,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,  3522,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,  3523,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,  3524,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,  -186,     0,
     312,     0,     0,   314,     0,     0,   316,   317,  3525,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,     0,   344,     0,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,     0,
     354,     0,     0,     0,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,     0,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,     0,
     376,   377,   378,     0,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   382,     0,     0,  3609,     0,     0,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,     0,
       0,  -186,     0,   392,     0,   393,     0,     0,     0,     0,
     395,     0,     0,     0,   122,  3526,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,  1620,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,  1621,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,  1623,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,  1624,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,   723,   724,     0,   275,     0,     0,  1626,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,  3716,  3706,  3717,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,  1637,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,  2345,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
    2346,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,  1979,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     570,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,  1980,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,   571,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,  2355,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
    2356,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     570,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,   571,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,  2345,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
    2346,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     570,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,   571,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
     727,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     570,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,   571,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,   679,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,   680,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,   681,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
    2394,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     570,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,   571,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,  2345,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     570,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,   571,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     570,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,   571,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,  2335,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,   571,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,  3648,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,  3649,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,   746,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
    1113,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
    1926,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,  1927,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,  2047,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,   571,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
    1926,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,  1417,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,  1418,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,   122,   395,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,     0,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
       0,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
       0,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,     0,     0,   312,     0,     0,   314,     0,
       0,   316,   317,     0,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,     0,   344,     0,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,     0,   354,     0,     0,     0,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,     0,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,     0,   376,   377,   378,     0,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   382,
       0,     0,   383,     0,     0,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,     0,     0,     0,     0,   395
};

static const yytype_int16 yycheck[] =
{
       7,   435,   510,   460,   480,   734,   735,   736,   910,   611,
     694,   535,    19,   977,  1184,    22,  1030,   773,   774,   775,
    1220,   660,    29,   757,  1795,   779,  1983,  1311,  1093,   506,
     507,  1877,    39,   636,  1905,  1540,  1936,  1929,  1930,  1931,
    1336,   634,    49,    22,  1646,  1961,  1397,  1343,  1553,  2110,
    1186,  1187,  1188,  1969,  2371,  1971,  2117,   660,  1311,   536,
    1968,  2093,  2729,  1199,  1106,  1212,   467,  1218,   661,   593,
     108,   698,   110,  2320,  1920,  1943,  1944,  1506,  2706,   698,
      87,  1355,  1356,     3,   840,     3,     3,     3,  1998,    32,
    2714,     3,     3,     3,   519,     3,    15,    16,    18,  1099,
     107,   108,  2002,   110,    27,  1252,    16,   587,    87,  1191,
    1192,   867,  1194,    18,   121,   869,  1055,  1253,   872,  1058,
    1256,    49,  2022,  2023,    18,   881,   882,   883,   605,    69,
    1069,  1070,    18,  1453,    15,    16,    66,    15,    16,  1648,
    1520,    28,   121,    16,    95,   135,   156,  1229,   175,  1285,
    1286,  2313,   115,   115,  1290,    56,    63,   891,   892,   893,
      63,  2759,  1244,  1274,  2762,  2984,  2085,  1993,  1994,   903,
      15,    16,   169,   270,  1310,    59,  1312,    34,   702,    61,
    1262,  1263,  1264,  2781,  1992,   179,    15,    16,   147,  2787,
    1998,  1273,    11,  2001,    15,    16,  2004,   598,    58,   111,
     111,   635,  1284,   111,    96,    15,    16,  2015,  2016,  2991,
    2081,  1967,    34,   205,   662,  1179,  2024,   214,    15,    16,
      15,    16,  2820,    89,    58,   145,   111,   179,   705,    15,
      16,    20,   252,  1344,   129,   430,  1347,  1348,  1349,  1350,
     145,  1352,  1353,  1354,  1355,  1356,  1357,  1358,  1359,  1360,
      58,   145,   263,    15,    16,    60,   191,    15,    16,   145,
     223,    75,    77,   236,    20,  3528,    55,    56,   177,    15,
      16,    15,    16,   131,   138,    94,    32,    15,    16,    49,
     221,  2988,    55,    56,   148,  3439,    15,    16,   229,   175,
      46,  1110,   361,   390,   413,   499,   217,   412,   214,    55,
      56,    54,   229,     8,   407,  2933,  2307,  1209,   412,   107,
     170,    50,   156,   111,   113,    15,    16,   238,   324,    58,
      15,    16,    11,   258,  3143,   217,   258,    15,    16,   499,
     175,  2641,  2990,   526,   108,   253,   253,   578,   344,    19,
     390,   499,   474,   455,   156,   493,   203,   495,   558,  2018,
     234,  1953,   172,   403,    15,    16,  2415,    76,   217,   559,
     179,   175,   170,   508,   113,   270,   498,  2036,   166,    37,
      15,    16,   382,    92,  3032,   585,   145,   172,   175,   238,
     374,   203,   269,   332,   333,   589,    49,    97,   583,  2390,
     100,   584,  1294,   443,   902,   214,  1298,  1081,   510,    15,
      16,  2711,   517,   156,   336,   203,   159,  1916,    15,    16,
      15,    16,   516,   130,   421,   585,   357,  3015,    64,   172,
    1590,   145,   374,   112,   431,  1595,  3024,   585,   435,    52,
     499,  1601,   351,   440,  1604,   354,   116,   678,   445,   412,
     585,  1034,   262,    15,    16,   341,   376,  3710,   172,  1042,
     927,   360,   337,   227,    10,   204,   270,  3081,  3612,   164,
     467,   440,  2354,   560,   583,   476,  2423,  3174,  3175,   267,
    2378,   270,  1099,   351,    15,    16,   354,   484,  1071,  1072,
    1099,  1235,   585,   411,   476,   390,   350,   494,  2650,   405,
    1093,   498,  2094,   531,  2386,   533,   534,   504,   356,   506,
     507,   495,  2412,   980,   511,   512,   351,  3135,   390,   354,
     445,  1035,   372,   990,   521,   494,  2426,   404,   525,   258,
    1656,   270,   351,   530,   531,   354,   533,   534,   535,   536,
     351,  1158,  1574,   354,   540,  2040,   556,  1017,   382,  1158,
     338,   351,   539,   495,   354,   454,   299,   981,   321,  3173,
    1304,   446,   418,  3335,   351,   374,   351,   354,   585,   354,
     394,  1500,   569,   493,   372,   351,   381,   968,   354,   476,
     382,   534,   534,   476,  3393,   585,  2081,  2496,   585,   569,
    1960,   521,   512,  2092,  2410,   508,   593,   594,   361,   351,
     991,   598,   354,   351,   553,  1731,   354,  1022,   605,  1735,
     484,   552,  1922,   495,  2412,   351,   585,   351,   354,  1609,
     354,  1430,  1346,   351,   508,   594,   354,   391,  2426,  1067,
    2937,  1905,   351,  2379,  2380,   354,    15,    16,   635,   382,
    1830,  1111,  1832,  1769,   498,   508,    15,    16,   556,   556,
     583,   411,   499,   584,   563,  1796,  1103,   548,   558,    59,
     455,   351,  1905,  1387,   354,   560,   351,   585,   585,   354,
    2719,  2908,   583,   351,   347,   354,   354,   527,  1819,   588,
     557,   591,   335,   591,   591,   591,   495,   499,   447,   591,
     591,   591,   563,   591,  3308,   563,  1970,   694,    32,   585,
     351,    15,    16,   354,   538,   702,    15,    16,   705,   585,
    3367,   708,   709,    15,    16,  3372,   351,   353,   482,   354,
     588,  1112,   335,   430,  1825,   158,  1798,  1970,   563,   527,
      15,    16,   520,   447,  2326,  2327,   538,  1161,  1839,  1840,
     709,    15,    16,   398,   563,   351,   525,   744,   354,   746,
     585,  2025,   563,   411,   351,   289,   351,   354,   411,   354,
     301,  3375,  2644,   563,   540,   584,   585,   425,  3356,  3076,
    3358,    15,    16,   584,   585,   744,   563,   746,   563,   525,
      15,    16,  2025,   585,   584,   585,  2647,   563,   446,   351,
    2696,   253,   354,   446,  2700,   112,   217,   584,  2696,   584,
    2682,   501,  2700,   287,   504,    15,    16,    15,    16,   585,
     344,   563,    15,    16,  1974,   563,  2716,   472,    15,    16,
     351,  1713,  2658,   354,   426,   214,   589,   563,   374,   563,
     453,   349,   584,   585,   234,   563,   584,   585,  3426,   175,
    3428,  1339,   585,  2003,   563,  2005,  3460,    12,   584,   585,
    2010,   585,    15,    16,    15,    16,   584,   585,   430,   289,
    2124,  2125,    20,    15,    16,   584,  2026,  1496,  2028,  2029,
    2030,    15,    16,   563,    32,   175,   583,   325,   563,  1393,
     587,  3538,   214,  3501,   455,   563,    15,    16,    46,  1781,
     352,  3522,  3523,   229,   584,   585,  1525,    55,    56,   896,
     585,   898,  1326,  1496,   337,  1488,   584,   585,  2500,   532,
     236,   228,   563,   325,   344,  1498,  1499,   590,  2716,  1502,
    1503,  1435,  1436,   249,   921,   471,   287,   495,   563,    64,
     927,   331,  1525,   584,   585,     3,   430,  1404,   270,  1943,
    1944,    15,    16,     0,   567,    15,    16,  2808,   430,   584,
     585,  2370,   921,   287,  2812,  2977,   497,   563,    23,  3010,
     125,   370,  1386,  1433,   430,   511,   563,   964,   563,   966,
     145,   968,   351,  1443,  1398,   354,    15,    16,   584,   585,
    3611,   522,   351,   980,   981,   354,  2272,   584,   585,   584,
     585,    12,  1609,   990,   991,  1023,  1024,  1467,   495,    64,
    1609,   563,   325,    68,  1001,  1033,   552,  2039,    15,    16,
     430,   583,  3669,  1041,   149,    67,   405,  1464,  1972,  3256,
     381,   253,   584,   585,   430,  1954,  1023,  1024,  1025,  1026,
     330,   191,   563,   221,  2308,   229,  1033,   351,  1035,  2176,
     354,   229,   351,  2115,  1041,   354,   111,   325,  2120,   351,
     382,   499,   354,   584,   585,   590,  1025,  1026,   252,    15,
      16,  1531,    94,  2135,   526,  2308,   351,  1064,   508,   354,
    2142,  2969,  2970,   473,  2175,   523,   112,   351,   343,  2961,
     354,   514,    15,    16,   484,  2157,  2158,   499,  2429,   583,
     416,    12,  2164,   105,   455,  1064,   361,   530,   258,   476,
    2172,   583,   175,   112,   125,   587,    12,   351,    15,    16,
     354,   523,  1109,  2705,  1838,  1112,   351,   583,   170,   354,
     352,  1591,  1592,  3145,  1594,  2266,  1596,  1597,  1598,  1599,
    1600,   175,  1602,  1603,  2275,   583,  1164,  1165,  3445,  2211,
    1109,   351,  2096,   351,   354,   164,   354,   179,   351,    15,
      16,   354,  3006,   583,   351,  3009,  3207,   354,    38,    15,
      16,   561,   174,   583,  1161,   217,  1163,  1164,  1165,   357,
    1167,   583,   549,   238,    15,    16,   499,   583,    12,  1176,
     253,  1178,   226,  3490,   563,   345,   238,   335,   351,    16,
     351,   354,   228,   354,   563,    15,    16,   209,  1167,   351,
     523,   395,   354,   540,   125,   584,   585,   351,    15,    16,
     354,  2283,  2707,  2708,  2709,  1212,   585,  3078,   353,   125,
      12,   499,   351,    88,   243,   354,    15,    16,    15,    16,
      20,     8,    15,    16,   499,   213,  2128,    15,    16,    20,
     120,  2736,    32,   495,  2136,   523,   540,    28,   585,   563,
      27,   399,    33,  3159,   563,  1252,    46,   430,   476,   435,
     583,   563,    15,    16,   440,    55,    56,   332,   333,   496,
     584,   585,   337,   446,   217,   584,   585,   351,   563,   344,
     354,   351,   584,   585,   354,   445,    15,    16,   267,   563,
     584,   125,    15,    16,   306,   517,    15,    16,   516,   584,
     585,   493,   314,   495,    15,    16,   347,   372,   352,   213,
     584,   585,   351,   555,  1311,   354,   335,   226,   540,   563,
     372,   475,   555,    15,    16,   479,   175,   569,   563,  1326,
      15,    16,  2618,   125,    15,    16,   569,   558,  2528,  2529,
     584,   585,   374,   555,   351,   537,  3409,   354,  3411,   584,
     585,    15,    16,   563,   219,   563,  3210,   569,   548,   338,
     563,   551,    15,    16,   584,    18,   563,   525,   380,    15,
      16,   236,   545,   546,   584,   585,   584,  2651,   572,   444,
     270,   584,   585,   362,   249,   583,   590,   584,   585,  1386,
      55,    56,   590,   551,  1391,   351,  1393,   145,   354,    64,
     563,  1398,   563,    15,    16,   583,   583,  1404,  2651,  1406,
     583,   563,   590,   430,  1411,  1412,   428,  1414,   351,   563,
     471,   354,   585,   405,   585,   583,   570,    15,    16,  1426,
    2704,    11,  1429,   585,   563,   540,    15,    16,  1435,  1436,
    1437,  1438,  1411,  1412,   351,  1414,   152,   354,  1445,  1446,
    1447,   462,   463,  1923,   465,   584,  2730,  1426,   344,   324,
    1429,  2704,   527,   495,    15,    16,  1463,   420,  1437,  1438,
     275,   276,    15,    16,  3310,  1472,  1445,  1446,  1447,   344,
     953,    15,    16,   956,   373,   351,   959,  2730,   354,   563,
      15,    16,  1489,   563,  2549,   351,   584,   585,   354,   349,
      15,    16,   493,  3357,  1501,  3359,  1930,   344,  1932,  1933,
     351,   585,   192,   354,   585,   585,  1513,   214,    15,    16,
     552,    47,  1519,    88,   563,    15,    16,   175,   545,   546,
     263,   351,  1501,    47,   354,   585,  2006,  2007,   344,  2611,
     107,   520,   554,   426,   351,  2269,   585,   354,    55,    56,
    1519,   416,    15,    16,   566,   526,   563,  2027,  1982,  1983,
     263,  2008,   351,  2282,   351,   354,   583,   354,   351,   584,
     585,   354,   577,   351,  3456,   150,   354,   516,   585,    15,
      16,  1578,  3472,     3,    15,    16,     6,   446,  1616,   583,
    1587,   396,   397,    13,  2018,  3542,   584,   585,   351,   166,
     172,   354,  3363,    23,    24,  2708,  2709,   563,    15,    16,
     290,   291,  2036,   253,   294,   295,   481,   584,   585,  1616,
     584,   585,   351,   420,  2814,   354,   287,     3,   351,   585,
     563,   354,   351,    53,   476,   354,   203,    57,    15,    16,
     351,  2748,    18,   354,  2751,  2752,  1643,  1644,    68,   493,
     473,   474,   585,   476,   219,   478,   563,    77,  2932,   351,
     476,  2768,   354,    83,   584,   585,   351,   584,   585,   354,
     351,   236,   476,   354,  1643,  1644,    96,   476,   585,   584,
     585,    15,    16,   142,   249,   263,  2110,   351,   107,  2932,
     354,   111,    78,  2117,   114,  2885,   346,   563,   351,   496,
     267,   354,   584,   123,   124,   351,   585,   563,   354,   129,
      15,    16,    88,   584,   585,   584,   585,   137,   489,   585,
      15,    16,   563,   143,   111,    15,    16,   429,  2320,   585,
     584,   585,  2361,     3,   552,   525,    15,    16,    52,   351,
     537,   399,   354,   563,   585,   584,   585,   166,    18,   169,
     152,    15,    16,    15,    16,   552,   563,   547,   548,   324,
     584,   585,   583,   351,   589,   585,   354,   211,  2361,   145,
     585,   338,   351,   552,   563,   354,   563,   585,   585,   344,
     563,   570,    15,    16,   585,   563,  2369,    15,    16,    15,
      16,  2305,   590,   169,   499,   215,   172,   217,   585,   583,
     351,   583,   585,   354,   224,   590,   584,  1804,  2812,   583,
     563,   107,    15,    16,   584,   585,   583,   351,    88,   195,
     354,    15,    16,    15,    16,   201,   351,   584,   585,   354,
      15,    16,   585,   583,   563,  2259,   351,  2351,   214,   354,
     563,   583,  2914,   219,   563,    15,    16,   583,   267,   583,
     226,   416,   563,   583,   351,   583,   585,   354,    15,    16,
     236,   351,   585,   583,   354,  2335,   585,   584,   585,   583,
     166,   563,   292,   249,   585,   145,   583,   253,   563,   583,
      15,    16,   563,   583,    15,    16,   262,   307,   351,    15,
      16,   354,   312,   585,   583,    15,    16,    15,    16,   563,
     585,   583,   172,   589,   585,   584,   585,   583,  1905,   583,
     563,   584,   585,    15,    16,   351,   481,   563,   354,   338,
     351,   585,   585,   354,   583,   195,  1923,  1924,    15,    16,
      47,   201,   352,  1930,   583,  1932,  1933,   558,   358,   585,
     583,   361,    15,    16,   351,   584,   585,   354,   324,   219,
    2674,   563,   583,   520,  2424,  1412,   226,  1414,   584,   585,
     583,  2431,  1295,  1296,   384,   385,   236,   387,   344,  3180,
    3181,   267,   584,  1970,   351,   563,   352,   354,   583,   249,
     583,   401,   583,   253,   563,  1982,  1983,   583,  1445,  1446,
    1447,   583,   262,  2460,   583,  1992,   583,   585,   374,  2423,
     583,  1998,   583,   423,  2001,   493,   585,  2004,  2660,  2661,
    2964,   585,   563,   583,    15,    16,   287,   351,  2015,  2016,
     354,  2018,   583,    15,    16,    15,    16,  2024,  2025,   563,
     583,    15,    16,   583,   585,  2630,  2631,  2034,   563,  2036,
     416,   583,   338,  2040,  2041,   583,   351,   583,   563,   354,
    1541,   585,   583,  1544,   324,   583,   351,  2922,  2923,   354,
     585,   351,  1553,   583,   354,  2034,   563,    71,    72,   584,
     446,  1562,   351,   563,   344,   354,   258,    15,    16,   583,
    2799,   583,   352,  2080,  2081,   583,   287,   351,   585,   351,
     354,   583,   354,   508,   583,   585,   583,   517,   126,   583,
     563,   520,   583,   583,   374,   481,   526,   111,    15,    16,
     420,  2080,   422,  2110,   424,  3389,   426,   583,   351,   583,
    2117,   354,   585,   351,   585,   351,   354,   563,   354,   133,
     583,   583,   563,  2130,   583,  3295,  3296,  3297,  3298,   585,
     583,   583,   583,   583,   583,  3271,   416,   585,   351,   585,
     526,   354,   508,   583,   585,   583,   563,   351,   583,   351,
     354,   165,   354,   539,   540,   585,   351,    15,    16,   354,
     583,   591,   583,   583,    15,    16,   446,   583,   585,  2176,
     556,   351,   558,   583,   354,   583,   563,   583,   583,    15,
      16,   583,   583,   583,   351,   583,   585,   354,    32,  2918,
      15,    16,    15,    16,   583,   583,   229,   584,   584,   585,
     583,   481,   583,  3285,   583,   591,   351,    15,    16,   354,
     351,   583,    56,   354,   520,   351,  3500,   537,   354,   563,
     583,   351,   583,   351,   354,   583,   354,   583,   583,  2663,
     583,   583,   583,   583,   583,    15,    16,   583,   583,   351,
     584,   583,   354,   583,   583,  2679,   526,    68,   563,    15,
      16,   583,  2259,    97,   351,   583,   100,   354,   563,    80,
     540,    15,    16,   563,   108,   583,   583,   583,   351,   584,
     570,   354,    15,    16,   563,   313,   556,  2284,   558,   584,
     583,  2288,   583,  2290,  2291,  2292,  2293,     7,   583,   563,
      54,   563,    15,    16,  2301,   584,   583,   583,  2305,    19,
     583,  2308,    22,   585,   584,   585,  2908,   583,   583,    29,
     584,   591,   584,   583,  2511,  2322,  2323,  2324,  2515,    39,
     563,   583,  2301,   583,   585,   563,   499,   563,  2335,    49,
     577,   172,    15,    16,  2341,   230,  2343,   491,    15,    16,
     351,   584,    28,   354,  2351,   160,   584,   533,   584,   351,
     563,   351,   354,   172,   354,    15,    16,   351,   585,   563,
     354,   563,   585,    15,    16,   457,   363,    87,   563,   583,
     585,   584,   584,   145,    15,    16,  3660,   145,   145,   393,
     584,   584,   584,   563,    70,    15,    16,   107,   108,   584,
     110,   585,   156,   145,   145,   159,   563,  3681,    15,    16,
     145,   121,   535,   351,   584,  2412,   354,  3660,   172,   145,
    3094,   145,   145,  3697,    15,    16,  2423,   584,   563,  2426,
     241,   145,   563,  3177,  3178,  3179,  3596,   563,   145,    15,
      16,   145,   145,   563,   351,   563,   145,   354,   145,   584,
      45,   179,   344,   584,  3697,  2291,  2292,  2293,   584,    15,
      16,   563,    64,  2460,   584,   141,   584,   175,    12,   585,
    2467,   584,    88,  2470,  3220,   499,   563,  2474,  2475,   584,
     125,  2478,   584,     9,   584,   584,  2322,  2323,  2324,   555,
     563,  2488,   326,  2963,   584,   590,   576,   584,   583,   252,
     311,  2470,   585,   351,   390,   556,   354,   218,    15,    16,
     351,   584,   192,   354,   158,   590,    15,    16,   175,  2488,
     584,  3240,  3241,  2947,   335,   351,   455,  3201,   354,   381,
     446,  3691,   585,    15,    16,   585,   351,   172,   351,   354,
    3214,   354,    45,  3703,   471,   299,    15,    16,   471,   577,
     578,   579,   580,   351,   471,  2742,   354,   471,   471,   429,
    3007,  3031,   563,    15,    16,    15,    16,    67,  3728,    15,
      16,   563,   508,   563,   122,   237,   494,   237,   389,   563,
     122,   351,    16,   584,   354,   494,  3010,    15,    16,  2776,
    2777,    45,   584,    12,   584,   351,   585,  2784,   354,   585,
     584,    15,    16,   219,  2791,   540,  3030,   351,  3354,   590,
     354,   584,    15,    16,   585,   584,    15,    16,   351,   453,
     236,   354,   584,   584,   584,   563,    15,    16,   382,  3004,
    3005,    15,    16,   249,   584,    15,    16,   584,   351,    15,
      16,   354,   584,   577,    15,    16,   584,  3022,   585,  3368,
    3120,   590,   584,  3028,  2651,  2652,   563,  2654,    15,    16,
     471,   175,    16,   584,  3256,   584,  2663,    15,    16,   584,
     504,   583,  2669,   447,   585,   585,  3051,   584,   351,  3054,
     584,   354,  2679,   584,   351,    15,    16,   354,   332,   333,
    2687,   584,   126,   337,   370,   584,    15,    16,   532,   580,
     584,   351,    15,    16,   354,   584,   125,  2704,   324,   351,
     584,   421,   354,   584,   583,   563,   392,   584,   584,  2716,
     351,   431,   563,   354,  3148,   435,  2723,    15,    16,   585,
     440,   351,   583,  2730,   354,   445,   584,   563,   584,  2736,
     584,   417,   584,   584,   351,   583,   262,   354,   563,   584,
     563,   590,   585,  3427,    15,    16,   508,   467,   584,   508,
     351,    15,    16,   354,   585,   563,   590,   499,   508,   584,
     560,   584,   126,   258,   484,   351,   583,  3247,   354,   508,
     349,   175,   175,  3207,   494,   204,   584,   175,   498,  3463,
    3464,   226,  3466,   563,   504,   351,   506,   507,   354,   475,
     416,   511,   512,   175,   590,   590,   233,   563,   558,   338,
     585,   521,   236,  2810,   584,   525,   236,   355,  2654,   563,
     530,   531,  3564,   533,   534,   535,   536,   303,   584,    96,
     563,    96,   238,  3507,  3726,  3509,  3510,   238,   583,   590,
     584,   499,   352,   225,   351,   175,   583,   354,   584,   583,
     563,   584,   351,  3572,   584,   354,   175,   338,   577,   569,
    3602,   338,   175,    94,   338,   481,   584,   128,   584,   351,
     514,   584,   354,   141,   583,   585,   577,   344,   584,   313,
     214,    94,   351,   593,   594,   354,   530,   141,   598,   584,
     563,   584,   590,   584,   590,   605,   563,  3616,  3364,   351,
    3642,   351,   354,   590,   354,   351,   584,   584,   354,   590,
     585,   584,  2909,   563,   584,  3657,   175,   584,   229,   534,
      64,   563,   107,   351,  3666,   635,   354,   250,   275,   236,
     236,   107,   563,   126,   584,  2932,   344,   351,   585,   238,
     354,  3439,   584,   563,   238,   585,    18,   178,   351,   344,
    2947,   354,   351,   584,    18,   354,   563,    12,  3700,   313,
    3702,   584,   351,   253,   584,   354,   179,   351,    18,   583,
     354,   351,   563,   583,   354,   351,   227,   584,   354,   583,
     351,   166,   227,   354,   694,    40,   217,   563,   584,   590,
     166,  2988,   702,   584,   351,   705,   584,   354,   708,   709,
     584,   584,    88,   351,   217,   584,   354,   563,   584,   584,
     584,   584,   584,  3010,   584,   449,   450,   584,   203,   585,
     584,   351,   584,   584,   354,   585,    81,   203,   584,   584,
     584,    86,   351,  3030,   744,   354,   746,   590,   351,   585,
     132,   354,   247,    34,   584,   430,   465,   466,   467,   468,
     469,   470,   585,   195,   145,  3502,   563,   448,  3055,   583,
    3057,   583,   481,   351,   563,   584,   354,   236,   355,   236,
    3067,   583,   585,   111,   111,   583,  3073,   584,   583,   583,
     369,   563,   267,   584,   590,   584,   583,   126,   583,   583,
     351,   267,   338,   354,   563,   449,   450,   351,  3067,   338,
     354,   126,   584,   442,   584,   584,   584,    41,   338,   100,
     381,   563,   584,   563,  3612,   584,   107,   563,  3542,   338,
     313,   584,   558,  3120,   226,   584,   590,   585,    45,   585,
     201,   310,   584,   219,   584,   563,   499,   390,   584,   573,
     574,   575,   576,   577,   578,   579,   580,   499,   236,   563,
     236,  3148,   583,   338,   540,   172,   584,   370,   126,   540,
     563,   374,   338,   249,   563,   583,   583,   158,    34,    32,
     584,  3168,   338,    58,   563,   166,   231,  3174,  3175,   563,
     338,   584,    67,   563,   551,   584,   896,   563,   898,   551,
     229,  3188,   563,   583,    79,   584,   583,   338,   383,   534,
     584,   386,   111,   238,   584,  3703,   563,   238,   584,   337,
    3207,   921,   203,   584,   338,   563,   338,   927,   338,   573,
     574,   575,   576,   577,   578,   579,   580,   584,   338,   460,
    3728,   338,   558,   563,   100,   584,   584,   519,   324,   585,
     583,   107,   584,   584,   563,   300,   584,   310,  3245,   585,
     563,   154,   584,  3677,   964,   584,   966,   585,   968,   499,
     238,  3258,   499,   499,   495,   496,    66,   584,   584,    16,
     980,   981,   236,   334,   313,   563,   267,   540,   540,   584,
     990,   991,   584,   496,   584,   170,   546,   463,   313,   584,
     172,  1001,   158,   178,   585,   338,   527,   338,   511,  1009,
     166,   584,   563,   584,   359,   584,   537,   584,   584,   563,
     145,   146,   585,  1023,  1024,  1025,  1026,   349,   534,   255,
     495,   276,    58,  1033,   537,  1035,   583,   583,   583,   349,
     416,  1041,   217,    58,   325,   520,   584,   203,   374,   552,
     584,   584,   584,   334,   520,   313,   337,   338,    45,   184,
      45,   138,   145,   238,  1064,    45,     5,   349,   584,    88,
     394,   349,   134,   198,   413,   585,    45,    12,    13,    45,
      45,   585,   584,   121,  3371,    16,   424,    12,    13,   280,
     583,   555,   575,   576,   577,   578,   579,   580,   592,   175,
     555,   145,  3389,  3390,   584,   481,   226,   232,   141,  1109,
     591,   267,  1112,   584,   459,   585,   213,   555,   141,   244,
     449,   450,  3409,   109,  3411,   269,  3413,  3414,   591,   214,
     592,  3390,   571,   591,   449,   450,   338,   583,  3425,   141,
     585,   570,   199,   126,   585,   490,   271,   591,   255,   528,
     446,   571,    87,   404,   172,   172,   172,   570,   111,   557,
     546,  1161,    87,  1163,  1164,  1165,   173,  1167,  1851,   325,
    1605,  3590,   700,  3244,  3461,   126,  1176,  3251,  1178,  3728,
     115,   337,   338,  3691,  3699,  3371,  3622,    68,  3581,  3622,
     115,   449,   450,  3077,   129,   415,  1158,   372,  3588,    80,
     219,  2806,   581,   328,   129,  1574,  3172,  2081,  3495,  2736,
    1578,  1540,  1212,  3500,  2043,  1996,   151,   236,   499,  2723,
     501,  2759,  2759,   504,  2993,  2792,   151,  3199,   163,   558,
     249,  3030,  3519,   514,  3039,  3522,  3523,  3524,   163,   520,
     121,  2724,   523,  2679,   573,   574,   575,   576,   577,   578,
     579,   580,  1252,  3424,  3191,  3542,  3415,   192,   573,   574,
     575,   576,   577,   578,   579,   580,  3553,   192,     4,  1171,
     145,  2088,  3340,     9,    10,  3258,  3563,  3564,   229,  3214,
    2039,  3568,   217,    44,  1900,   460,  1078,  1508,   223,   164,
    1437,    27,   217,  1154,   575,   576,    32,  3584,   223,  3586,
      36,   709,  2301,  1882,   693,   324,   479,  1914,  1452,   184,
     623,  1311,  3305,  3120,  2917,  3602,   574,   575,   576,   577,
     578,   579,   580,   198,  3611,   344,  1326,   262,  2118,  2918,
     313,  3618,  1249,   712,  3414,  2694,  2730,   262,  3625,  2276,
    3627,  3628,  3169,   499,  1199,   501,   107,  3616,   504,  3636,
    3148,  1919,   527,   968,  1644,  3642,   991,  1878,   514,  1904,
     241,  2932,   313,  2646,   520,  2645,  2704,   523,   243,   244,
    3657,  3681,  3500,  3660,   469,  3662,  3663,  1176,  1650,  3666,
     116,  3668,  1497,   526,   996,   460,  1386,  3674,  1403,  2636,
    3677,  1391,  3571,  1393,  3681,  3402,   271,   416,  1398,  3697,
    3687,   120,  3032,  3470,  1404,   166,  1406,  3591,  1458,  2651,
    3697,  1411,  1412,  3700,  1414,  3702,  3703,  2687,  1009,   575,
     576,  2353,  2958,  3156,  1429,   999,  1426,  3714,  3715,  1429,
     311,  3718,   452,  3293,   813,  1435,  1436,  1437,  1438,   200,
     375,  3728,   203,   606,   961,  1445,  1446,  1447,  1163,  2288,
     375,   332,   333,  3299,   335,   330,   453,   496,   610,   394,
     839,  3116,   481,  1463,  2079,   400,   449,   450,  1321,   394,
     742,   406,  1472,  2803,  3074,   400,    -1,    -1,    -1,    -1,
      -1,   406,    -1,    -1,    -1,    -1,   205,    -1,    -1,  1489,
      -1,    -1,    -1,    -1,    -1,   430,   371,    -1,   449,   450,
      -1,  1501,    -1,    -1,    -1,   430,   267,    -1,   389,    -1,
      -1,   890,    -1,  1513,    -1,   894,   451,   452,    -1,  1519,
    1530,    -1,    -1,    -1,    -1,    -1,   451,   452,    -1,    -1,
      -1,    -1,  1542,  1543,    -1,  1545,  1546,  1547,    -1,    -1,
    1550,    -1,    -1,    -1,   263,  1555,    -1,    -1,    -1,  1559,
    1560,  1561,    -1,   488,  1564,  1565,  1566,  1567,  1568,  3495,
    1570,  1571,  1572,   488,    -1,    -1,    -1,    -1,   287,    -1,
      -1,    -1,    -1,    -1,   335,    -1,    -1,   338,  1578,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1587,    -1,    -1,
     471,    -1,   575,   576,   577,   578,   579,   580,    -1,   534,
      -1,   536,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   534,
      -1,   536,    -1,    -1,    -1,    -1,  1616,    -1,    -1,    -1,
      -1,    -1,   573,   574,   575,   576,   577,   578,   579,   580,
    1009,    -1,  3568,    -1,    -1,    -1,    -1,    -1,    -1,  1018,
      -1,    -1,    -1,  1643,  1644,    -1,    -1,    -1,  3584,    -1,
    3586,    -1,    -1,    -1,   373,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   381,    -1,   425,    -1,    -1,    -1,    -1,    -1,
     431,    -1,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3625,
     409,   427,  3628,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3636,    -1,    -1,    -1,    -1,    -1,   442,    -1,    -1,    -1,
      -1,    -1,   448,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    23,    24,    -1,    -1,    -1,    -1,  3663,    -1,    -1,
      -1,    -1,   468,    -1,    -1,    -1,   455,    -1,  3674,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3687,    -1,    55,    56,    57,    -1,   476,    -1,   520,
      -1,    -1,    64,    -1,    -1,    -1,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   493,    77,   495,    -1,  3714,  3715,
      -1,    -1,  3718,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,    -1,    -1,
      -1,  1180,  1181,  1182,  1804,    -1,    -1,    -1,    -1,   111,
    1189,  1190,   114,    -1,  1193,    -1,  1195,  1196,  1197,  1198,
      -1,    -1,    -1,  1202,    -1,    -1,  1205,  1206,    -1,  1208,
      -1,  1210,  1211,    -1,  1213,  1214,  1215,  1216,  1217,    -1,
    1219,   143,  1221,  1222,  1223,    -1,  1225,  1226,  1227,  1228,
      -1,  1230,  1231,    -1,  1233,    -1,    -1,  1236,  1237,  1238,
      -1,  1240,  1241,  1242,  1243,    -1,  1245,  1246,  1247,  1248,
      -1,    -1,    -1,    -1,    -1,  1254,  1255,    -1,  1257,  1258,
    1259,  1260,  1261,    -1,    -1,    -1,    -1,  1266,    -1,  1268,
    1269,  1270,  1271,  1272,    -1,    -1,  1275,  1276,  1277,  1278,
    1279,  1280,    -1,  1282,  1283,  1905,    23,    24,  1287,  1288,
    1289,    -1,  1291,    -1,  1293,   217,    -1,    -1,  1297,    -1,
    1299,  1300,   224,  1923,  1924,    -1,  1305,    -1,    -1,    -1,
    1930,    -1,  1932,  1933,  1313,  1314,  1315,    -1,    55,    56,
      57,    -1,    -1,  1322,    -1,    -1,  1325,    64,    -1,    -1,
      -1,    68,    -1,  1332,  1333,  1334,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1970,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      -1,    -1,  1982,  1983,    -1,    -1,    -1,    -1,    -1,    -1,
     292,    -1,  1992,    -1,   111,    -1,    -1,   114,  1998,  2009,
      -1,  2001,    -1,    -1,  2004,   307,    -1,    -1,    -1,  1388,
    2020,    -1,    -1,    -1,    -1,  2015,  2016,    -1,  2018,    -1,
       3,    -1,    -1,    -1,  2024,  2025,   143,    -1,    -1,    -1,
      13,    14,    -1,    -1,  2034,    -1,  2036,    -1,    -1,    -1,
    2040,  2041,    -1,    26,    -1,    28,    -1,    -1,    13,    -1,
      -1,    -1,    -1,  1432,    -1,    -1,   358,    -1,    -1,   361,
      -1,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    -1,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
    2080,  2081,   384,   385,    -1,   387,    -1,    70,    -1,    -1,
      -1,    -1,    -1,    23,    24,    -1,    -1,    -1,    -1,    -1,
     217,    -1,    -1,    -1,    87,    -1,    -1,   224,    -1,    -1,
    2110,    -1,    -1,    -1,    -1,    -1,    -1,  2117,    -1,    -1,
      -1,   423,    87,   106,    -1,    -1,    -1,    57,    -1,    -1,
    2130,    -1,   115,   116,   117,   252,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,    77,    -1,    -1,
     115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   129,    -1,    96,    -1,   151,    -1,
      -1,    -1,    -1,    -1,    -1,   292,  2176,   126,    -1,    -1,
      -1,   111,    -1,    -1,   114,   168,   151,    -1,    -1,   107,
     307,   273,   274,   275,   276,   277,   278,    -1,   163,   281,
     282,   283,   284,   285,   286,    -1,   288,    -1,    -1,   192,
    1589,    -1,    -1,   143,    -1,   517,   199,    -1,    -1,   202,
      -1,    -1,    -1,    -1,   526,    -1,    -1,   192,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     223,   358,    -1,    -1,   361,    -1,    -1,    -1,   166,    -1,
      -1,    -1,   217,    -1,    -1,    -1,   239,    -1,   223,  2259,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   384,   385,    -1,
     387,    -1,    -1,    -1,   257,    -1,    -1,    -1,    -1,   262,
     229,    -1,    -1,   585,  2284,   203,    -1,   217,  2288,    -1,
    2290,  2291,  2292,  2293,   224,    -1,    -1,   262,    -1,    -1,
      -1,  2301,    -1,   252,    -1,  2305,   423,    -1,  2308,    -1,
      -1,    -1,    -1,    -1,   396,   397,    -1,    -1,    -1,    -1,
      -1,    -1,  2322,  2323,  2324,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2335,    -1,    -1,    -1,    -1,
      -1,  2341,    -1,  2343,    -1,    -1,    -1,    -1,    -1,   267,
      -1,  2351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   292,    -1,   313,   348,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   307,    -1,    -1,
      -1,    -1,    -1,   332,   333,    -1,    -1,   370,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,  1776,  1777,  1778,
     517,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   526,
     375,    -1,  2412,    -1,  1793,    -1,   399,   335,   401,   402,
     338,    -1,   405,  2423,    -1,   408,  2426,   410,   358,   394,
      -1,   361,   415,    -1,   417,   400,    -1,    -1,    -1,    -1,
    1819,   406,    -1,   426,    -1,    -1,   395,   430,    -1,    -1,
      -1,    -1,    -1,    -1,   384,   385,    -1,   387,    -1,    -1,
    2460,    -1,  1841,   446,    -1,   430,   583,  2467,   451,    -1,
    2470,    -1,   455,    -1,  2474,  2475,    -1,    -1,  2478,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   451,   452,  2488,    -1,
      -1,    -1,   475,   423,    -1,    -1,   479,    -1,    -1,    -1,
     449,   450,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   458,
      -1,    -1,    -1,   431,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   488,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,    -1,
      -1,   534,    -1,    -1,    -1,    -1,   539,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   534,
      -1,   536,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   562,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   517,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   526,    -1,    -1,    -1,
     583,    -1,   520,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   572,   573,   574,   575,   576,   577,   578,
     579,   580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2651,  2652,    -1,  2654,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2663,    -1,    -1,    -1,    -1,    -1,  2669,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2679,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2687,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2704,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2716,    -1,  2097,    -1,
      -1,  2100,    -1,  2723,  2103,  2104,    -1,    -1,    -1,    -1,
    2730,    -1,    -1,    -1,    -1,    -1,  2736,  2116,    -1,    -1,
    2119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2132,    -1,  2134,    -1,    -1,    -1,  2138,
      -1,  2140,  2141,    -1,    -1,    -1,  2145,    -1,  2147,  2148,
      -1,  2150,    -1,    -1,  2153,    -1,  2155,  2156,    -1,    -1,
      -1,    -1,  2161,  2162,    -1,    -1,  2165,    -1,  2167,    -1,
    2169,    -1,  2171,    -1,  2173,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2184,  2185,    -1,    -1,  2188,
    2810,  2190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2198,
    2199,    -1,  2201,    -1,  2203,    -1,    -1,  2206,  2207,  2208,
      -1,  2210,    -1,    -1,    -1,    -1,    -1,  2216,  2217,  2218,
    2219,    -1,    -1,    -1,    -1,  2224,  2225,  2226,    -1,  2228,
      -1,  2230,    -1,  2232,    -1,  2234,    -1,  2236,    -1,    -1,
      -1,    -1,    -1,    -1,  2243,    -1,  2245,    -1,    -1,  2248,
    2249,    -1,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      -1,  2260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,
      14,    -1,    -1,    -1,    -1,    -1,  2275,    -1,    55,    56,
      -1,    -1,    26,    -1,    -1,    -1,    -1,    -1,    65,  2909,
      67,    -1,    -1,    -1,    -1,    -1,  2295,    -1,    -1,    -1,
      -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    85,    53,
      87,    -1,  2932,    57,    58,    -1,    -1,    -1,    95,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,  2947,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    87,    -1,  2344,    -1,    -1,    -1,    -1,
    2349,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   106,    -1,    -1,   142,   143,    -1,  2988,    -1,
     147,   115,   116,   117,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,    -1,    -1,    -1,    -1,
    3010,    -1,    -1,    -1,  2393,    -1,    -1,    -1,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,   151,  2407,    -1,
    3030,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3055,    -1,  3057,    -1,   216,
     217,    -1,    -1,   220,    -1,    -1,    -1,  3067,   192,    -1,
      -1,    -1,    -1,  3073,    -1,   199,    -1,    -1,   202,    -1,
     237,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     6,    -1,    -1,   223,
      -1,   258,    -1,    13,    -1,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    23,    24,   239,    -1,    -1,    -1,    -1,
    3120,    -1,    -1,    -1,    -1,  2504,    -1,    -1,    -1,    -1,
     287,    -1,    -1,   257,    -1,    -1,    -1,    -1,   262,    -1,
      -1,    -1,    -1,    53,    -1,    -1,    -1,    57,  3148,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,   320,    -1,    -1,    -1,    77,  3168,    -1,
      -1,    -1,   329,    83,  3174,  3175,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,  3188,    -1,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2577,    -1,
      -1,   111,    -1,    -1,   114,    -1,    -1,  3207,  2587,    -1,
    2589,    -1,  2591,   123,    -1,    -1,   373,   374,  2597,   129,
     377,   378,    -1,    -1,   348,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2620,    -1,    -1,    -1,  3245,   370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,    -1,    -1,  3258,   169,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   399,    -1,   401,   402,    -1,
      -1,   405,    -1,   440,   408,    -1,   410,    -1,   445,    -1,
      -1,   415,    -1,   417,    -1,    -1,    -1,    -1,   455,    -1,
      -1,    -1,   426,    -1,    -1,    -1,   430,   217,    -1,  2688,
      -1,    -1,    -1,    -1,   224,    -1,    -1,    -1,    -1,   476,
      -1,    -1,   446,   480,    -1,    -1,    -1,   451,    -1,    -1,
      -1,   455,    -1,    -1,    -1,    -1,    -1,    -1,   495,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   475,    -1,    -1,    -1,   479,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   292,    -1,    -1,    -1,    -1,    -1,    -1,  3389,
    3390,   515,   549,    -1,    -1,    -1,   553,   307,    -1,    -1,
      -1,    -1,   312,    -1,    -1,    -1,    -1,   531,    -1,  3409,
     534,  3411,    -1,  3413,  3414,   539,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3425,    -1,    -1,    -1,    -1,
      -1,   101,   102,   103,   104,   105,    -1,    -1,   562,    -1,
      -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,   358,    -1,
      -1,   361,    -1,    -1,  2833,    -1,    -1,    -1,    -1,   583,
      -1,  3461,    -1,    -1,  2843,    -1,    -1,    -1,    -1,    -1,
    2849,    -1,    -1,    -1,   384,   385,    -1,   387,    -1,  2858,
    2859,    -1,    -1,    -1,    -1,  2864,    -1,    -1,    -1,  2868,
      -1,   401,    -1,    -1,    -1,    31,    32,    -1,    -1,    -1,
    3500,    37,  2881,    39,   174,    41,    42,    -1,  2887,    -1,
      -1,  2890,  2891,   423,  2893,  2894,    -1,    -1,    -1,  3519,
      56,    -1,    -1,    -1,  3524,    -1,    -1,    -1,  2907,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   206,   207,   208,   209,
      -1,    -1,  3542,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3553,    -1,    23,    24,    -1,    -1,    -1,
      -1,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    55,    56,    57,
      -1,   127,    -1,    -1,  2973,  2974,    64,    -1,    -1,    -1,
      68,    -1,    -1,    -1,    -1,  2984,    -1,   517,   144,    77,
      -1,    -1,    -1,    -1,    -1,    -1,   526,    -1,  3618,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3627,    96,   165,
      -1,   167,   302,    -1,   304,   305,   306,    -1,    -1,    -1,
      -1,    -1,    -1,   111,   314,    -1,   114,    -1,    -1,    -1,
     186,   187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3660,    -1,  3662,    -1,    -1,    -1,    -1,    -1,  3668,    -1,
      -1,    -1,    -1,    -1,    -1,   143,    -1,  3677,  3495,    -1,
      -1,  3681,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   227,    -1,    -1,    -1,    -1,    -1,  3697,    -1,    -1,
      -1,    -1,    -1,  3703,    -1,  3522,  3523,    -1,    -1,    -1,
     380,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3728,   265,
     266,    -1,   268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3563,  3564,    -1,   217,
      -1,  3568,    -1,    -1,    -1,    -1,   224,   427,   428,    -1,
     296,   297,   298,    -1,  3143,    -1,    -1,  3584,    -1,  3586,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3156,    -1,    -1,
      -1,   317,   318,   319,    -1,  3602,    -1,   323,    -1,    -1,
     326,    -1,    -1,    -1,  3611,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   339,   340,    -1,    -1,    -1,  3625,    -1,
      -1,  3628,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3636,
      -1,    -1,    -1,    -1,   292,  3642,    -1,    -1,    -1,   365,
      -1,   367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   307,
    3657,    -1,    -1,    -1,    -1,    -1,  3663,    -1,    -1,  3666,
      -1,    -1,    -1,    -1,    -1,   391,    -1,  3674,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3687,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3700,   554,  3702,    -1,    -1,  3267,    -1,
     358,    -1,    -1,   361,  3273,   565,   566,  3714,  3715,    -1,
      -1,  3718,    -1,    -1,    -1,    -1,    -1,    -1,   444,    -1,
     446,    -1,    -1,    -1,    -1,    -1,   384,   385,    -1,   387,
     456,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3309,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3319,    -1,  3321,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   423,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   500,   501,    -1,    -1,   504,   505,
     506,   507,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   547,   548,    -1,  3393,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     566,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   517,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   526,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3450,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3473,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3558,
    3559,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3577,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3587,    -1,
      -1,    -1,    -1,  3592,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3601,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,  3632,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,  3643,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      43,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,  3704,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,   245,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,    -1,   496,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,   509,   510,    -1,   512,
     513,   514,   515,   516,   517,   518,    -1,   520,   521,   522,
     523,    -1,   525,    -1,    -1,   528,   529,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,   541,   542,
     543,   544,   545,   546,    -1,    -1,   549,   550,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,   564,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   575,   576,    -1,    -1,    -1,    -1,   581,    -1,
     583,    -1,    -1,   586,   587,    -1,   589,   590,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,   344,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,   434,   435,   436,
     437,   438,   439,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
     477,   478,   479,   480,    -1,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,    -1,   496,
     497,    -1,   499,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,   513,   514,   515,   516,
     517,   518,    -1,   520,   521,   522,   523,    -1,   525,    -1,
      -1,   528,   529,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,   541,   542,   543,   544,   545,   546,
      -1,    -1,   549,   550,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,   564,    -1,   566,
      -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,   575,   576,
      -1,    -1,    -1,    -1,   581,    -1,   583,    -1,    -1,   586,
     587,    -1,   589,   590,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,    -1,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,   513,   514,   515,   516,   517,   518,    -1,   520,
     521,   522,   523,    -1,   525,    -1,    -1,   528,   529,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
     541,   542,   543,   544,   545,   546,    -1,    -1,   549,   550,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,   564,    -1,   566,    -1,    -1,    -1,    -1,
     571,    -1,    -1,    -1,   575,   576,    -1,    -1,    -1,    -1,
     581,    -1,   583,    -1,    -1,   586,   587,    -1,   589,   590,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
      -1,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
      -1,   496,   497,    -1,   499,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,   513,   514,
     515,   516,   517,   518,    -1,   520,   521,   522,   523,    -1,
     525,    -1,    -1,   528,   529,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,   564,
      -1,   566,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,
     575,   576,    -1,    -1,    -1,    -1,   581,    -1,   583,   584,
      -1,   586,   587,    -1,   589,   590,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,   513,   514,   515,   516,   517,   518,
      -1,   520,   521,   522,   523,    -1,   525,    -1,    -1,   528,
     529,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,   541,   542,   543,   544,   545,   546,    -1,    -1,
     549,   550,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,   564,    -1,   566,    -1,    -1,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,    -1,   583,   584,    -1,   586,   587,    -1,
     589,   590,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,    -1,   496,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
     513,   514,   515,   516,   517,   518,    -1,   520,   521,   522,
     523,    -1,   525,    -1,    -1,   528,   529,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,   541,   542,
     543,   544,   545,   546,    -1,    -1,   549,   550,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,   564,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   575,   576,    -1,    -1,    -1,    -1,   581,    -1,
     583,   584,    -1,   586,   587,    -1,   589,   590,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,   434,   435,   436,
     437,   438,   439,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
     477,   478,   479,   480,    -1,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,    -1,   496,
     497,    -1,   499,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,   513,   514,   515,   516,
     517,   518,    -1,   520,   521,   522,   523,    -1,   525,    -1,
      -1,   528,   529,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,   541,   542,   543,   544,   545,   546,
      -1,    -1,   549,   550,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,   564,    -1,   566,
      -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,   575,   576,
      -1,    -1,    -1,    -1,   581,    -1,   583,   584,    -1,   586,
     587,    -1,   589,   590,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,   175,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,   513,   514,   515,   516,   517,   518,    -1,   520,
     521,   522,   523,    -1,   525,    -1,    -1,   528,   529,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
     541,   542,   543,   544,   545,   546,    -1,    -1,   549,   550,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,   564,    -1,   566,    -1,    -1,    -1,    -1,
     571,    -1,    -1,    -1,   575,   576,    -1,    -1,    -1,    -1,
     581,    -1,   583,    -1,    -1,   586,   587,    -1,   589,   590,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
     175,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
      -1,   496,   497,    -1,   499,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,   513,   514,
     515,   516,   517,   518,    -1,   520,   521,   522,   523,    -1,
     525,    -1,    -1,   528,   529,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,   564,
      -1,   566,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,
     575,   576,    -1,    -1,    -1,    -1,   581,    -1,   583,    -1,
      -1,   586,   587,    -1,   589,   590,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,   175,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,   513,   514,   515,   516,   517,   518,
      -1,   520,   521,   522,   523,    -1,   525,    -1,    -1,   528,
     529,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,   541,   542,   543,   544,   545,   546,    -1,    -1,
     549,   550,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,   564,    -1,   566,    -1,    -1,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,    -1,   583,    -1,    -1,   586,   587,    -1,
     589,   590,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,    -1,   496,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
     513,   514,   515,   516,   517,   518,    -1,   520,   521,   522,
     523,    -1,   525,    -1,    -1,   528,   529,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,   541,   542,
     543,   544,   545,   546,    -1,    -1,   549,   550,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,   564,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   575,   576,    -1,    -1,    -1,    -1,   581,    -1,
     583,    -1,    -1,   586,   587,    -1,   589,   590,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,    -1,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,   434,   435,   436,
     437,   438,   439,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
     477,   478,   479,   480,    -1,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,    -1,   496,
     497,    -1,   499,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,   513,   514,   515,   516,
     517,   518,    -1,   520,   521,   522,   523,    -1,   525,    -1,
      -1,   528,   529,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,   541,   542,   543,   544,   545,   546,
      -1,    -1,   549,   550,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,   564,    -1,   566,
      -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,   575,   576,
      -1,    -1,    -1,    -1,   581,    -1,   583,    -1,    -1,   586,
     587,    -1,   589,   590,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,    -1,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,   513,   514,   515,   516,   517,   518,    -1,   520,
     521,   522,   523,    -1,   525,    -1,    -1,   528,   529,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
     541,   542,   543,   544,   545,   546,    -1,    -1,   549,   550,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,   564,    -1,   566,    -1,    -1,    -1,    -1,
     571,    -1,    -1,    -1,   575,   576,    -1,    -1,    -1,    -1,
     581,    -1,   583,    -1,    -1,   586,   587,    -1,   589,   590,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
      -1,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
      -1,   496,   497,    -1,   499,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,   513,   514,
     515,   516,   517,   518,    -1,   520,   521,   522,   523,    -1,
     525,    -1,    -1,   528,   529,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,   564,
      -1,   566,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,
     575,   576,    -1,    -1,    -1,    -1,   581,    -1,   583,    -1,
      -1,   586,   587,    -1,   589,   590,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,   513,   514,   515,   516,   517,   518,
      -1,   520,   521,   522,   523,    -1,   525,    -1,    -1,   528,
     529,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,   541,   542,   543,   544,   545,   546,    -1,    -1,
     549,   550,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,   564,    -1,   566,    -1,    -1,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,    -1,   583,    -1,    -1,   586,   587,    -1,
     589,   590,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
      -1,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,    -1,   496,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
     513,   514,   515,   516,   517,   518,    -1,   520,   521,   522,
     523,    -1,   525,    -1,    -1,   528,   529,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,   541,   542,
     543,   544,   545,   546,    -1,    -1,   549,   550,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,   564,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   575,   576,    -1,    -1,    -1,    -1,   581,    -1,
     583,    -1,    -1,   586,   587,    -1,   589,   590,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    79,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,   178,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
     217,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,   238,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,   252,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,   430,   431,   432,   433,   434,   435,   436,
     437,   438,   439,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,   460,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
      -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,   496,
     497,    -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,
     517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,
      -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,
      -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   590,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    79,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,   178,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,   217,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,   238,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,   460,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,    -1,   566,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,   590,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,    -1,   566,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,   584,    -1,    23,    24,    25,    26,   590,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,
     448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,
     458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,
      -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,
      -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,   493,   494,    -1,   496,   497,
      -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,
      -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,
     518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,
      -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,
     538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,
      -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,
      -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,    -1,
      -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,   584,    17,    -1,    -1,
      20,   589,   590,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,   226,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,    -1,   566,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     590,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,   434,   435,   436,
     437,   438,   439,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
      -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,   496,
     497,    -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,
     517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,
      -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,
      -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
     577,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   590,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,    -1,   566,    -1,    -1,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,   583,
      -1,    17,    -1,    -1,    20,    -1,   590,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,
     476,    -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,    -1,
     566,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,   589,   590,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,
     448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,
     458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,
      -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,
      -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,   493,   494,    -1,   496,   497,
      -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,
      -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,
     518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,
      -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,
     538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,
      -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,
      -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   590,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,    -1,    -1,   479,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
     515,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
     525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,
      -1,   566,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   590,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,    -1,
      -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,
     452,   453,   454,   455,    -1,   457,   458,   459,    -1,    -1,
      -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,
     472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,    -1,
     482,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,   501,
     502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,
     512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,   521,
     522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,    -1,
      -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,    -1,
     552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,
     562,    -1,    -1,    -1,   566,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,   590,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,    -1,   566,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,   590,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,
     476,    -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,     5,
     566,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,   589,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,
     476,    -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,     5,
     566,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,   589,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,
     476,    -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,     5,
     566,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,   589,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,    -1,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,    -1,
     476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,    -1,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,    -1,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,    -1,
     566,    -1,    -1,    -1,    -1,   571,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,   585,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,    -1,   566,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,   577,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,   434,   435,   436,
     437,   438,   439,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
      -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,   496,
     497,    -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,
     517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,
      -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,
      -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
     577,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,    -1,    -1,   479,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
     515,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
     525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,
      -1,   566,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,   577,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,
     483,   484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,
     493,   494,    -1,   496,   497,    -1,    -1,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
      -1,    -1,   515,   516,   517,   518,    -1,    -1,   521,   522,
      -1,    -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,    -1,    -1,   566,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   577,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,   135,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,   557,    -1,   559,    -1,
     561,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,     5,
     571,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,    -1,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,    -1,
     476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,    -1,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,    -1,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,   555,
      -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,    -1,
     566,    -1,    -1,   569,     5,   571,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,   555,    -1,   557,    -1,   559,    -1,
     561,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,     5,
     571,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,    -1,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,    -1,
     476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,    -1,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,    -1,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,    -1,
     566,    -1,    -1,    -1,     5,   571,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,   557,    -1,   559,    -1,
     561,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,     5,
     571,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,    -1,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,    -1,
     476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,    -1,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,    -1,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,    -1,
     566,    -1,    -1,    -1,     5,   571,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,   557,    -1,   559,    -1,
     561,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,     5,
     571,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,    -1,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,    -1,
     476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,    -1,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,    -1,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,    -1,
     566,    -1,    -1,    -1,     5,   571,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,   557,    -1,   559,    -1,
     561,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,     5,
     571,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,    -1,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,    -1,
     476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,    -1,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,    -1,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,    -1,
     566,    -1,    -1,    -1,     5,   571,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,   166,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,   267,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,   332,   333,    -1,   335,    -1,    -1,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,   462,   463,   464,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,   520,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,   145,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,   447,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      91,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    34,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    18,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    82,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,   153,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,   175,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,   372,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    -1,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      -1,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,    -1,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,    -1,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,    -1,    -1,    -1,    -1,   566
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,     3,    13,    14,    26,    28,    47,    48,    53,    57,
      58,    70,    87,   106,   115,   116,   117,   128,   129,   151,
     168,   192,   199,   202,   223,   239,   257,   262,   348,   370,
     379,   399,   401,   402,   405,   408,   410,   415,   417,   426,
     430,   446,   451,   455,   475,   479,   515,   531,   534,   539,
     562,   583,   594,   595,   596,   597,   598,   599,   601,   606,
     608,   613,   631,   796,   814,   817,   825,   827,   829,   832,
     837,   839,   844,   847,   852,   856,   864,   865,  1002,  1004,
    1012,  1015,  1040,  1048,  1059,  1065,  1079,  1082,  1085,  1091,
    1095,  1099,  1102,  1103,  1149,  1166,  1172,  1174,  1181,  1183,
    1208,  1214,  1215,  1216,  1217,  1255,    11,    94,   179,   214,
     374,   810,  1236,  1237,   258,   336,   846,   493,   495,  1168,
    1209,   217,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      42,    44,    46,    47,    50,    52,    54,    55,    57,    59,
      60,    61,    63,    65,    66,    68,    69,    70,    71,    72,
      75,    77,    78,    80,    81,    86,    89,    96,    97,   100,
     105,   106,   112,   114,   120,   122,   123,   124,   128,   131,
     132,   133,   137,   141,   142,   143,   144,   147,   149,   150,
     151,   154,   156,   159,   160,   163,   164,   165,   168,   173,
     174,   177,   179,   186,   187,   190,   191,   193,   199,   200,
     202,   205,   209,   210,   211,   212,   215,   216,   220,   224,
     228,   230,   231,   233,   234,   241,   243,   247,   250,   256,
     258,   261,   263,   273,   274,   275,   276,   277,   278,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   290,   291,
     292,   294,   295,   299,   300,   301,   302,   303,   306,   307,
     310,   312,   314,   317,   318,   319,   320,   321,   322,   323,
     326,   327,   329,   330,   331,   335,   340,   341,   343,   345,
     346,   347,   358,   359,   360,   361,   363,   365,   367,   370,
     371,   373,   375,   376,   377,   378,   380,   381,   382,   383,
     384,   385,   386,   387,   392,   393,   396,   397,   398,   400,
     402,   403,   406,   408,   409,   410,   412,   413,   417,   418,
     420,   421,   423,   424,   425,   426,   428,   429,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   443,   444,
     445,   448,   452,   453,   454,   455,   457,   458,   459,   466,
     467,   469,   472,   475,   476,   479,   480,   482,   483,   484,
     488,   489,   490,   491,   493,   494,   496,   497,   500,   501,
     502,   503,   504,   510,   512,   515,   516,   517,   518,   521,
     522,   525,   530,   533,   535,   537,   538,   546,   549,   552,
     553,   554,   559,   561,   562,   566,   619,  1139,  1143,  1147,
    1148,   287,  1168,  1168,   559,  1210,    94,   178,   460,   496,
     527,   537,   617,   711,   712,   713,   786,  1049,  1003,    94,
     179,   217,   374,   496,   511,   537,   552,  1011,  1143,   846,
     618,   590,  1137,  1138,  1143,   607,  1013,  1100,    96,   217,
     495,  1168,   846,  1143,  1096,   426,   537,  1168,   846,  1016,
    1092,  1168,   618,  1210,  1143,   867,   869,   870,   349,  1151,
    1066,   475,   479,   455,   510,   455,   495,  1060,  1173,  1041,
    1143,    28,    70,   141,   370,   392,   417,   475,  1257,   430,
     583,   866,     0,     3,   370,   156,  1083,  1137,  1143,   145,
     802,  1143,   619,   619,   495,   112,  1233,  1168,   828,  1210,
     853,   854,  1137,   632,   590,   508,   830,   840,    16,  1211,
     213,   714,   618,   354,  1231,  1233,  1234,  1235,  1236,   495,
     712,   217,   214,   270,   382,  1057,  1058,   919,   920,   213,
    1010,  1010,  1143,  1010,  1010,   618,  1010,  1168,   602,  1086,
      12,    13,    87,   115,   129,   151,   163,   192,   217,   223,
     262,   375,   394,   400,   406,   430,   451,   452,   488,   534,
     536,  1184,  1186,  1188,  1189,  1143,   347,    61,   390,   590,
     251,   499,  1140,  1143,  1145,   113,   204,   270,  1018,    77,
     381,  1101,  1104,   226,  1137,  1167,  1168,   175,    32,   287,
    1071,  1097,  1143,   618,   848,  1168,   113,   270,  1019,  1047,
     287,   381,   455,  1093,  1094,   826,    12,  1182,  1186,   508,
    1211,   868,    12,   125,   204,   465,   466,   467,   468,   469,
     470,   481,   874,   875,   876,  1150,    30,    33,    55,    56,
      65,    67,    85,    87,    95,   143,   147,   177,   179,   191,
     193,   216,   217,   220,   237,   258,   263,   287,   320,   329,
     347,   373,   374,   377,   378,   440,   445,   455,   480,   495,
     553,   759,   785,  1067,  1071,  1072,  1074,  1157,   819,   820,
     819,   819,   558,   818,   819,  1007,  1137,  1168,  1047,    34,
     203,   499,  1125,  1141,  1256,  1256,  1256,  1256,  1256,   869,
     866,   584,  1143,  1081,  1080,   301,   497,   522,   798,   800,
     799,  1137,   145,   471,  1238,   838,  1006,  1007,   229,   585,
     860,   861,   583,   633,  1143,   609,  1006,  1006,    52,   335,
     335,   399,  1212,   332,   333,   891,  1143,    91,  1145,  1146,
    1199,  1200,   405,    10,   374,   511,   726,  1232,  1238,  1239,
    1247,  1249,  1233,  1236,   714,  1143,   175,  1050,  1054,  1055,
    1143,  1057,     7,    20,    22,    25,    29,    32,    34,    35,
      36,    38,    51,    55,    56,    62,    65,    73,    74,    80,
      83,    84,    85,    90,    91,    93,    94,    98,    99,   100,
     105,   107,   110,   111,   118,   119,   136,   139,   140,   152,
     155,   157,   158,   162,   166,   171,   176,   180,   181,   182,
     183,   185,   186,   188,   189,   190,   194,   196,   197,   203,
     209,   213,   223,   225,   242,   246,   249,   254,   256,   259,
     264,   267,   272,   279,   289,   293,   302,   306,   308,   309,
     313,   314,   315,   316,   317,   318,   319,   325,   332,   333,
     334,   337,   338,   343,   361,   362,   364,   365,   366,   367,
     368,   380,   388,   404,   405,   416,   419,   422,   424,   428,
     432,   477,   478,   483,   485,   486,   487,   492,   499,   501,
     502,   503,   504,   513,   514,   515,   520,   523,   528,   529,
     537,   541,   542,   543,   544,   545,   550,   554,   564,   566,
     571,   575,   576,   581,   583,   586,   587,   589,   590,   885,
     886,   887,   888,   892,   895,   896,   898,   905,   909,   921,
    1124,  1126,  1128,  1129,  1133,  1135,  1139,  1143,   152,  1143,
     619,   344,   619,   619,  1146,  1198,  1006,  1010,   540,   603,
     120,   205,   263,   287,   373,   381,   409,   455,   476,   493,
    1087,  1088,  1168,   373,  1187,   420,   420,   496,   537,   552,
     349,  1191,   493,  1193,    60,   455,  1190,    95,   552,  1192,
     344,   585,    18,   145,   962,   963,  1175,  1143,   810,   885,
      75,   175,   270,  1105,  1111,    47,   175,  1137,  1169,  1170,
     845,   589,   600,  1140,   263,   849,  1146,   850,   851,  1137,
     833,   226,  1007,  1020,  1021,    47,   585,  1006,  1187,   344,
     426,  1213,  1212,   526,  1218,  1219,   577,   878,   879,   880,
     876,  1152,  1153,  1154,   263,   150,   446,   252,   556,  1078,
     516,   583,    94,   179,   374,   495,   552,  1078,   721,  1145,
     253,   981,   983,    63,   476,   172,   476,   476,   476,   287,
     493,    63,   476,    12,    40,    81,    86,   231,   300,   359,
     459,   490,  1061,  1062,  1063,   476,   205,   476,   476,   516,
     981,  1078,   175,   229,  1075,   263,   142,    66,   376,   493,
     512,   476,   549,   816,   398,   472,   821,   822,   815,    78,
     810,   585,   346,  1259,   489,  1260,   236,   412,  1258,   584,
    1219,  1221,  1222,  1223,   864,  1084,  1125,  1143,   111,   709,
     710,   719,   720,   768,   626,   626,   797,  1146,   429,   552,
    1006,   508,   585,   111,   855,  1143,   854,   217,   238,   783,
     784,   862,   634,   635,   885,   273,   274,   275,   276,   277,
     278,   281,   282,   283,   284,   285,   286,   288,   396,   397,
     610,   611,   612,   156,   382,   831,    54,   156,   159,   172,
     299,   382,   841,   842,   843,    52,   399,   152,   616,   583,
     884,   589,   211,   585,   880,   880,   880,   552,  1239,  1137,
     517,   540,   787,  1008,  1009,  1137,   585,  1052,   590,  1056,
     583,   583,   583,   583,   583,   896,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     884,   884,   583,   884,   583,   583,   583,   523,   583,  1124,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   885,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     922,   923,   924,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   885,   583,   884,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   884,   583,  1124,   583,   583,   583,  1124,   583,
     583,    34,   203,   499,   583,   583,   583,   884,   884,   884,
     583,   583,   583,   583,   583,   583,   885,   926,   896,   896,
     896,   430,   583,   885,  1226,  1143,   910,  1143,    15,    16,
     351,   354,   563,   889,   890,   145,   146,   184,   198,   232,
     244,   271,   328,   893,   126,   229,   252,   313,   395,   449,
     450,   458,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   891,   896,   101,   102,   103,   104,   105,   174,   206,
     207,   208,   209,   302,   304,   305,   306,   314,   380,   427,
     428,   554,   565,   566,   959,   960,    64,   353,   585,  1141,
     583,   590,  1137,   585,    49,   411,   811,  1006,   589,   604,
     605,    47,   558,   585,  1089,   493,   583,  1201,  1201,  1201,
    1201,   179,   374,   495,  1185,  1189,  1143,   164,   330,  1143,
    1176,  1177,  1020,   287,   258,  1110,   857,   287,   963,   585,
    1006,  1145,    27,   508,  1098,   585,   508,   585,   508,  1006,
    1021,  1017,  1094,   175,   585,   179,   374,  1185,  1143,    12,
     125,  1225,   585,   871,   882,   885,  1131,  1143,   585,   191,
     258,   345,   445,  1155,  1156,  1159,  1160,   229,  1076,  1140,
     885,   577,   714,   619,   619,  1137,  1137,  1068,   267,   338,
     520,   984,   985,  1126,   619,  1078,  1146,   172,  1073,  1075,
     619,  1078,   230,   491,   160,   172,  1064,   585,  1073,  1073,
    1137,  1075,  1073,  1073,  1078,  1078,   533,   823,   585,   823,
     457,   430,   583,   587,   929,   930,   931,   932,   941,   942,
     950,  1125,   363,  1261,   352,   977,   983,  1224,   710,    64,
     759,    68,    80,   241,   311,   335,   389,   471,   628,   630,
       6,    13,    23,    24,    53,    57,    68,    77,    83,    96,
     114,   123,   124,   129,   137,   143,   169,   215,   217,   224,
     292,   307,   312,   352,   358,   361,   384,   385,   387,   401,
     423,   517,   526,   716,   718,   719,   720,   803,   804,   805,
     973,   112,   228,  1137,   841,  1140,  1007,   583,   584,   585,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   585,   535,   842,   708,   709,
     584,  1145,    45,  1200,   619,   619,   179,  1137,   614,    44,
     107,   166,   200,   203,   267,   335,   338,   425,   431,   433,
     434,   435,   436,   437,   438,   439,   440,   520,   788,   789,
     790,   987,   788,   344,   585,  1053,  1051,  1055,   175,   577,
    1143,   963,   885,   885,   885,    12,   125,   915,   964,   987,
     915,   915,   915,   885,   885,   919,   919,   885,   919,   885,
     885,   885,   885,   125,   915,   964,   885,   584,   885,   885,
     885,   885,   885,  1133,  1143,   885,   885,   885,   885,   885,
     583,  1226,   885,   959,   885,   885,   885,   584,   885,   885,
     885,   885,   919,   885,   885,    97,   100,   501,   504,   961,
     885,   125,   912,  1124,   885,   885,   885,   584,   885,   885,
     885,   885,   919,   885,   885,   885,   885,   923,     9,   925,
    1133,   125,   915,   885,   885,   125,   915,   885,   885,   885,
     885,   885,   919,   919,   919,   885,   885,   885,   885,   885,
     885,   919,   888,   885,   584,   885,   885,   885,   885,   885,
     584,   885,   885,   919,   915,   915,   885,   885,   885,   125,
     915,   885,   885,   960,   960,   885,    43,   245,   509,   885,
     885,  1124,   584,   885,   584,   915,  1134,  1135,  1143,   915,
     885,   885,   885,   555,   928,  1229,  1229,   584,   585,   584,
     885,   589,   911,  1145,   590,   885,   885,   885,   887,   158,
     337,   514,   530,   891,    12,    17,   887,   894,   888,   583,
     896,   888,   888,   888,   888,   252,   888,   888,   888,   888,
     895,   888,   895,   888,   888,   888,   888,   229,   252,   395,
     572,   576,  1145,   896,   885,   897,  1143,  1005,  1146,   811,
    1145,   585,   390,  1088,  1006,  1090,  1143,  1202,  1203,   577,
    1137,  1143,  1197,  1197,  1197,   145,   164,   184,   198,   243,
     244,   271,   330,   371,  1178,  1180,   556,   965,  1014,   218,
     858,   859,  1137,   270,   390,   560,  1171,  1170,   841,   885,
    1140,  1146,  1146,   851,  1137,   156,   382,   538,   834,   835,
     836,   430,   446,   545,   546,   583,   704,  1022,  1025,  1140,
     192,  1197,  1197,  1197,  1220,   879,   175,   226,   872,   873,
     976,   977,   998,   881,   590,  1153,   111,   510,  1143,  1162,
     321,   361,   589,   759,  1161,  1140,   175,  1077,   584,  1143,
     263,   476,  1070,   341,   585,   455,  1078,  1143,   381,   981,
    1063,  1078,  1078,  1073,  1137,  1078,  1078,   612,   824,   822,
     949,  1143,    88,   219,   236,   249,   324,   416,   481,   940,
     446,   585,  1137,   949,   585,   172,  1262,    45,   981,   145,
     447,  1031,  1032,  1032,  1140,   471,   471,   471,   471,   471,
     429,    67,    79,   178,   460,   731,   734,   735,   781,   783,
     809,   809,  1032,  1032,   809,  1032,  1032,  1032,   508,   122,
    1032,   237,   494,   170,   372,   783,   809,   237,  1032,   494,
     122,  1032,  1032,  1032,   809,    45,  1032,  1032,  1032,  1032,
    1032,    18,   145,   508,   813,  1032,  1032,  1032,   716,   585,
     583,   590,   730,   736,  1136,  1143,   801,   372,   957,  1143,
     885,   987,  1140,  1140,   107,   166,   267,   338,   520,   988,
    1140,   987,  1140,  1140,  1140,  1140,  1140,   987,  1140,  1140,
     987,   611,   361,   499,  1251,     8,    27,   696,   619,  1240,
     252,   583,   698,   715,   717,   718,   435,   440,   585,  1137,
    1009,  1137,   540,   965,   930,   590,  1056,   585,   584,   584,
     585,   915,   584,   916,   585,   584,   584,   584,    18,   584,
     540,   584,   584,   584,   584,   585,   585,   540,   585,   585,
     906,   584,   577,   584,   585,   585,   584,   584,   585,   584,
     590,   584,   585,   584,   585,   585,   585,   584,   585,   584,
     585,   175,   585,   585,   584,   585,   584,   585,   585,   584,
     585,   584,   584,   585,   584,   585,   585,   585,   908,   585,
     584,   585,   585,   584,   585,   585,   584,   585,   584,   585,
     584,   585,   585,   585,   584,   583,   585,   915,   584,   584,
     584,   915,   584,   584,   585,   585,   584,   584,   585,   584,
     585,   584,   584,   584,   584,   584,   584,   584,   585,   585,
     584,   585,   584,   229,   584,   584,   585,   585,   585,   584,
     585,   585,   584,   584,   584,   584,   585,   175,   585,   585,
     915,   584,   584,   584,   585,   585,   585,   584,   175,   885,
     175,   885,   175,   885,   175,   584,   585,   585,   584,   584,
     584,   584,   584,   585,   584,   585,   584,   885,   555,   569,
     927,   867,  1228,  1226,   919,   588,   191,   258,   445,  1158,
     447,  1143,   158,   337,   514,   530,   583,   885,  1226,   149,
     969,   888,    16,   959,   959,   583,   896,   888,   888,   885,
     900,   901,   902,   583,   590,   605,   262,   584,   585,   590,
     590,   508,   508,   508,  1179,   966,   982,   983,  1022,   499,
    1142,   585,   860,   560,   258,   508,   835,   705,  1023,   583,
    1028,  1033,  1028,   584,   704,  1024,  1130,  1131,  1134,  1143,
    1026,   349,   175,   175,   175,   865,   130,   930,   999,   172,
     262,   877,   998,   982,   873,    18,   883,  1140,  1143,   577,
    1143,   590,   233,   590,  1031,    32,   111,   760,   761,  1031,
    1145,   172,  1031,   589,  1145,    32,   111,   763,   764,  1145,
     988,  1069,   147,   553,   985,   985,   558,   338,   965,  1073,
     585,   944,   949,   929,   236,   236,   355,   951,   236,   249,
     416,   951,   941,   929,  1043,  1044,  1134,   929,   963,   946,
     947,   987,   303,   978,   111,   765,   767,  1145,   761,    96,
      96,   112,   228,   793,  1136,   784,   784,    58,   170,   372,
     527,   733,   782,   732,   733,   793,  1136,   988,   987,  1136,
     987,  1140,  1140,   759,  1032,   987,   238,   238,  1136,  1136,
     721,  1032,   164,   243,   335,   724,   988,   988,  1136,   974,
     975,  1134,   111,   987,  1140,   987,   987,   383,   386,   723,
     987,  1137,    71,    72,   111,   133,   165,   393,   722,   721,
     583,   805,   728,   729,   730,   731,  1143,     8,   164,   812,
     394,   732,   773,   737,   590,   583,  1241,   584,   585,   499,
     583,   115,   223,   534,   697,  1250,  1241,  1137,   252,   699,
     704,   728,   214,   405,   701,  1112,   585,   717,   789,   615,
     930,   976,   965,   963,   225,   885,   885,   584,   885,   885,
      32,    56,    97,   100,   108,   326,   453,   504,   532,   917,
     760,   919,   885,   760,   917,   885,   919,   584,   895,   895,
    1141,  1143,   885,   885,   919,  1141,   885,   885,   885,   919,
     338,   885,   885,   885,   885,   885,   885,   885,   919,   919,
     338,   885,   885,   919,   885,   885,   885,   885,   919,   885,
     888,  1133,   584,   584,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   919,   225,   885,   885,
     885,   885,   584,   885,   885,   885,   885,   175,   885,   175,
     885,   175,   885,   885,   338,   885,   885,   570,   885,   885,
     141,  1230,   584,   584,   590,   590,   590,  1145,   885,  1226,
     584,   585,   584,   896,   887,   885,  1226,   969,    16,   584,
     880,   903,   904,   918,   919,  1143,  1203,   577,   577,  1199,
    1199,  1199,   583,   885,   344,  1038,  1106,   859,   214,   863,
    1146,   874,  1029,  1030,  1134,  1034,   585,   583,  1025,   584,
     584,   585,   590,  1218,   175,  1199,  1199,  1199,   965,   965,
     131,   356,   994,   995,  1000,   534,   229,  1140,  1143,   590,
    1143,   250,  1143,    12,    32,   111,   344,   885,  1165,    64,
     766,   885,  1146,   343,   361,   499,  1164,  1158,  1031,   981,
     275,  1078,   612,  1221,   945,   249,   236,   941,   951,   951,
     236,   344,   344,   540,   585,  1042,  1031,   169,   214,   539,
     953,   874,   885,   979,  1132,   885,   238,   238,   784,   793,
     787,   129,   446,   806,   761,  1140,   793,   811,  1140,   807,
     585,    19,   116,   980,  1006,   584,   585,  1143,  1137,    31,
      32,    37,    39,    41,    42,    56,    97,   100,   108,   127,
     144,   165,   167,   186,   187,   227,   256,   265,   266,   268,
     296,   297,   298,   317,   318,   319,   323,   326,   339,   340,
     365,   367,   391,   444,   446,   456,   500,   501,   504,   505,
     506,   507,   547,   548,   566,   738,   741,   742,   743,   744,
     745,   746,   747,  1143,  1143,  1242,    18,  1143,  1252,   344,
     413,   583,   620,    18,  1137,   584,   584,    18,   707,   717,
     583,   965,   253,   986,   885,   584,   584,   584,   583,   753,
     753,   583,   748,   749,   753,   227,   227,   584,   584,   584,
     584,   584,   584,   585,   907,   959,   959,   584,   584,   584,
     584,   584,   584,   585,   584,   584,   584,   584,   584,   585,
     584,   584,   584,   584,   584,   914,   977,   585,   585,   585,
     584,   584,   584,   584,   585,   584,   584,   584,   585,   229,
     558,   899,   584,   584,   584,   584,   584,   584,   584,   584,
     584,   585,   584,   584,   584,   885,   584,   172,   584,   584,
     585,   585,   584,   585,   585,   584,   885,   584,   885,   584,
     885,   584,   584,   585,   584,   584,   885,   570,  1227,   590,
     794,   584,   919,   584,   585,   584,   887,   885,   585,   584,
     407,  1204,  1204,  1204,   111,   885,  1036,  1037,   132,  1112,
     247,   878,   585,  1031,  1035,  1036,  1033,  1027,  1025,  1130,
    1143,  1199,   982,   195,   970,  1142,  1142,   589,   996,   997,
    1145,   448,   577,   390,   403,   443,  1163,   767,  1031,   583,
     583,  1162,   885,   145,   584,   931,   355,   929,   941,   236,
     236,   929,   941,   934,   933,   935,  1044,   965,  1037,   783,
     954,   954,   954,   878,   585,   980,   793,   787,   583,   111,
     111,   736,   766,   738,   975,   584,   729,   774,   583,   583,
     753,   748,   369,   739,   748,   748,    20,    32,    46,   525,
     759,   769,    56,   547,   742,   744,   769,   769,    56,   548,
     548,   551,   748,   740,   753,   753,   769,   583,   753,    23,
      64,    68,   111,   337,   344,   372,   444,   527,   755,   756,
     757,   772,   891,   551,   583,   769,    32,   583,   770,   583,
     583,   753,   583,   749,   754,   590,   584,   585,  1243,  1244,
     221,   229,   357,   640,   641,   642,   643,   880,   108,   227,
     391,   482,   727,   621,  1243,   584,   700,   715,   583,   704,
     791,   792,  1143,   985,   959,   338,   769,   338,   885,   584,
     584,   584,   885,   885,   442,   913,   338,   885,   885,   885,
     885,    41,   381,   584,   885,   959,   885,   885,   885,   885,
     885,   584,   584,   584,   338,   885,  1218,  1143,   584,   919,
     881,   904,    59,   234,   331,   473,   484,   561,  1195,  1196,
     558,  1205,  1205,  1205,   584,   585,  1039,   226,   706,  1030,
    1037,   584,  1221,    45,   201,   967,  1001,  1145,   585,   310,
      69,   521,   390,  1164,   499,   499,  1031,  1140,   963,   236,
     344,   937,   941,   941,   344,   939,   885,   885,   583,   976,
     172,   952,   948,  1132,   583,   583,   791,   100,   501,   504,
     575,   576,  1127,  1128,   812,   755,   289,   344,   583,   775,
     777,   778,   779,   338,   338,   453,   532,   567,   750,   751,
     752,   583,   750,   750,   770,    20,   525,   759,   771,   770,
     760,   769,   551,   750,   583,   769,   338,   750,   765,  1140,
     334,   758,  1127,   534,   111,   238,   757,   238,   337,   338,
     338,   338,   338,   750,   338,   750,  1143,  1143,   558,  1246,
     430,   583,  1245,   584,   585,   638,  1137,   519,   636,   637,
     639,  1143,  1246,  1221,   701,   704,   702,   584,   585,   980,
     583,   584,   584,   584,   585,   584,   584,   585,   584,  1125,
     584,   585,   584,   585,   584,   584,   310,   154,   584,   584,
     584,   584,   584,   584,   584,   585,  1230,   584,   883,   499,
     499,   499,    16,  1194,   192,   290,   291,   294,   295,  1206,
    1207,  1037,   238,  1107,   725,   873,   982,   971,  1132,   968,
     976,    66,  1113,   997,   584,   584,  1165,    16,   929,   936,
     540,   938,   540,   958,  1143,   986,   236,   955,   725,   980,
     791,   791,   584,  1129,  1129,   808,   177,   360,   454,   115,
     534,   776,  1143,   779,   584,   584,   752,   795,  1125,   760,
     770,   795,   584,   884,   334,   546,   584,   584,   584,   584,
      50,    58,   258,   880,   880,  1253,   642,  1143,   172,  1140,
     584,   585,   638,   584,  1218,   792,   338,   338,   885,   915,
     885,   919,  1195,   349,   987,   987,   987,   987,  1207,   534,
     495,   877,   558,   585,   972,   980,   885,   982,   138,   148,
     350,   498,  1114,  1115,   255,  1116,   276,   344,   885,   583,
     885,   583,   584,   585,   583,   584,   584,   812,    49,   335,
     411,   446,   780,   780,   584,   585,   584,   585,   584,   884,
     769,   770,   769,   770,    58,   349,    58,   867,   866,   627,
     738,   880,   622,   639,   738,   703,   980,   584,   584,   584,
     585,   584,   584,   584,  1045,  1046,  1134,  1137,    89,   418,
    1132,   374,   989,    45,    45,   138,    45,  1115,   474,   498,
    1117,  1118,   145,   943,   958,   958,  1143,   956,   957,   773,
       5,   111,   337,   777,  1143,   769,  1125,   769,   349,   349,
     584,   121,   628,   629,   891,  1254,   134,   413,  1221,   885,
     585,  1031,  1108,   980,  1143,  1125,  1125,    45,  1125,    45,
      45,  1118,   988,   885,   584,   584,   584,  1221,   121,    61,
     161,   213,   235,   248,   347,   414,   571,   660,   661,   664,
     673,   674,   677,   688,  1139,  1144,  1148,   424,   623,   584,
    1046,  1037,   759,   762,   990,  1125,  1125,  1125,    16,   588,
    1143,   175,   330,   666,   663,  1144,  1144,  1143,   662,   675,
     678,   596,    28,   269,   404,   557,   691,   592,  1248,   738,
     761,  1109,   583,   280,   175,  1143,   668,   669,   885,   885,
     555,   680,   684,   692,   645,   660,   645,   693,   689,   660,
     624,  1113,   880,   991,   992,   993,   145,   226,   141,   885,
     676,   685,   569,   684,   687,   646,   141,   660,   591,   533,
     885,   691,   627,  1116,   885,   584,   585,   987,   665,   213,
     570,   555,   679,   681,   885,   645,   141,   109,   644,   647,
     269,   591,   695,   128,   690,  1144,   625,   214,  1119,   993,
     667,  1143,   670,   682,   681,   687,   686,   571,    82,   153,
     652,   658,  1143,   141,   660,   591,   885,   694,   660,   338,
     583,  1120,   585,   645,   885,   141,   570,   199,   585,   648,
      76,    92,   591,   141,   645,   255,   584,   589,  1121,  1122,
    1134,   446,  1123,  1143,   671,   683,   571,   645,   172,  1143,
     738,   172,   172,   404,   141,  1145,   584,   585,  1045,   135,
     569,   672,   570,   649,   111,   659,   463,   655,   987,   650,
     651,   557,  1122,   668,   645,   645,   462,   464,   653,   654,
     655,   657,   891,  1143,   885,   546,   656,   596,   585,   660,
     173,  1141,   654
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1231 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     MYSQL_YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1244 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1304 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[(3) - (3)].lex_str);
        }
    break;

  case 56:
#line 1319 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[(2) - (4)].lex_str);
        }
    break;

  case 57:
#line 1328 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[(1) - (1)].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1335 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[(2) - (2)].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1344 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[(2) - (2)].lex_str);
        }
    break;

  case 60:
#line 1351 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1365 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[(2) - (2)].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 66:
#line 1377 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 67:
#line 1385 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 68:
#line 1395 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1401 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1410 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 73:
#line 1415 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 74:
#line 1420 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 75:
#line 1425 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[(3) - (3)].ulong_num);
       }
    break;

  case 76:
#line 1430 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[(3) - (3)].ulong_num);
       }
    break;

  case 77:
#line 1434 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[(3) - (3)].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1439 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 79:
#line 1443 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 80:
#line 1447 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 81:
#line 1451 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 82:
#line 1455 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[(3) - (3)].lex_str).str;
	 }
    break;

  case 84:
#line 1464 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 85:
#line 1468 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[(3) - (3)].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1484 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 87:
#line 1488 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[(3) - (3)].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1499 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[(5) - (5)].table), NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
#ifdef ENABLE_SENNA
	  lex->senna_clear();
#endif
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[(2) - (5)].num) | (yyvsp[(4) - (5)].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 89:
#line 1519 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1521 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[(7) - (7)].table), NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1533 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
#ifdef ENABLE_SENNA
            Key *key= new Key((yyvsp[(2) - (11)].key_type),(yyvsp[(4) - (11)].lex_str).str, (yyvsp[(5) - (11)].key_alg), 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key((yyvsp[(2) - (11)].key_type), (yyvsp[(4) - (11)].lex_str).str, (yyvsp[(5) - (11)].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1547 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1552 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[(4) - (6)].lex_str).str;
            lex->create_info.options=(yyvsp[(3) - (6)].num);
	  }
    break;

  case 94:
#line 1559 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1565 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1567 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1574 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1589 "sql_yacc.yy"
    {
            if (!(yyvsp[(1) - (3)].lex_str).str || check_db_name((yyvsp[(1) - (3)].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[(1) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name((yyvsp[(3) - (3)].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[(1) - (3)].lex_str), (yyvsp[(3) - (3)].lex_str), true);
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1604 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            LEX_STRING db;
	    if (check_routine_name((yyvsp[(1) - (1)].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            if (lex->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[(1) - (1)].lex_str), false);
            if ((yyval.spname))
	      (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1622 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            if (lex->definer != NULL)
            {
              /*
                 DEFINER is a concept meaningful when interpreting SQL code.
                 UDF functions are compiled.
                 Using DEFINER with UDF has therefore no semantic,
                 and is considered a parsing error.
              */
	      my_error(ER_WRONG_USAGE, MYF(0), "SONAME", "DEFINER");
              MYSQL_YYABORT;
            }
	    lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    lex->udf.name = lex->spname->m_name;
	    lex->udf.returns=(Item_result) (yyvsp[(2) - (4)].num);
	    lex->udf.dl=(yyvsp[(4) - (4)].lex_str).str;
	  }
    break;

  case 101:
#line 1641 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp;

            /* 
              First check if AGGREGATE was used, in that case it's a
              syntax error.
            */
            if (lex->udf.type == UDFTYPE_AGGREGATE)
            {
              my_error(ER_SP_NO_AGGREGATE, MYF(0));
              MYSQL_YYABORT;
            }

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_RECURSIVE_CREATE, MYF(0), "FUNCTION");
	      MYSQL_YYABORT;
	    }
	    /* Order is important here: new - reset - init */
	    sp= new sp_head();
	    sp->reset_thd_mem_root(thd);
	    sp->init(lex);
            sp->init_sp_name(thd, lex->spname);

	    sp->m_type= TYPE_ENUM_FUNCTION;
	    lex->sphead= sp;
	    /*
	     * We have to turn of CLIENT_MULTI_QUERIES while parsing a
	     * stored procedure, otherwise yylex will chop it into pieces
	     * at each ';'.
	     */
	    sp->m_old_cmq= thd->client_capabilities & CLIENT_MULTI_QUERIES;
	    thd->client_capabilities &= ~CLIENT_MULTI_QUERIES;
	    lex->sphead->m_param_begin= lip->tok_start+1;
	  }
    break;

  case 102:
#line 1680 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_param_end= lip->tok_start;
	  }
    break;

  case 103:
#line 1688 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    lex->charset= NULL;
	    lex->length= lex->dec= NULL;
	    lex->interval_list.empty();
	    lex->type= 0;
	  }
    break;

  case 104:
#line 1696 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->fill_field_definition(YYTHD, lex,
                                          (enum enum_field_types) (yyvsp[(8) - (8)].num),
                                          &sp->m_return_field_def))
              MYSQL_YYABORT;

	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
	  }
    break;

  case 105:
#line 1708 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_chistics= &lex->sp_chistics;
	    lex->sphead->m_body_begin= lip->tok_start;
	  }
    break;

  case 106:
#line 1717 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->is_not_allowed_in_function("function"))
              MYSQL_YYABORT;

	    lex->sql_command= SQLCOM_CREATE_SPFUNCTION;
	    sp->init_strings(YYTHD, lex);
            if (!(sp->m_flags & sp_head::HAS_RETURN))
            {
              my_error(ER_SP_NORETURN, MYF(0), sp->m_qname.str);
              MYSQL_YYABORT;
            }
	    /* Restore flag if it was cleared above */
	    if (sp->m_old_cmq)
	      YYTHD->client_capabilities |= CLIENT_MULTI_QUERIES;
	    sp->restore_thd_mem_root(YYTHD);
	  }
    break;

  case 107:
#line 1739 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1740 "sql_yacc.yy"
    {}
    break;

  case 109:
#line 1744 "sql_yacc.yy"
    {}
    break;

  case 110:
#line 1745 "sql_yacc.yy"
    {}
    break;

  case 111:
#line 1751 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[(2) - (2)].lex_str); }
    break;

  case 112:
#line 1753 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 113:
#line 1755 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 114:
#line 1757 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 115:
#line 1759 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 116:
#line 1761 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 117:
#line 1763 "sql_yacc.yy"
    { }
    break;

  case 118:
#line 1768 "sql_yacc.yy"
    { }
    break;

  case 119:
#line 1769 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 120:
#line 1770 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 121:
#line 1775 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 122:
#line 1779 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 123:
#line 1786 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[(2) - (2)].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[(2) - (2)].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 124:
#line 1794 "sql_yacc.yy"
    {}
    break;

  case 129:
#line 1810 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[(3) - (3)].item));
	  }
    break;

  case 130:
#line 1814 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[(1) - (1)].item));
	  }
    break;

  case 135:
#line 1832 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 136:
#line 1852 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(1) - (3)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[(1) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[(1) - (3)].lex_str),
                                                     (enum enum_field_types)(yyvsp[(3) - (3)].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[(3) - (3)].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 141:
#line 1889 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(3) - (4)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[(3) - (4)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[(3) - (4)].lex_str),
                                                     (enum enum_field_types)(yyvsp[(4) - (4)].num),
                                                     (sp_param_mode_t)(yyvsp[(1) - (4)].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[(4) - (4)].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 142:
#line 1914 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 143:
#line 1915 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 144:
#line 1916 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 145:
#line 1917 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 146:
#line 1921 "sql_yacc.yy"
    {}
    break;

  case 148:
#line 1926 "sql_yacc.yy"
    {}
    break;

  case 150:
#line 1932 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 151:
#line 1936 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[(2) - (3)].spblock).vars || (yyvsp[(2) - (3)].spblock).conds) && ((yyvsp[(1) - (3)].spblock).curs || (yyvsp[(1) - (3)].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if ((yyvsp[(2) - (3)].spblock).curs && (yyvsp[(1) - (3)].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[(1) - (3)].spblock).vars + (yyvsp[(2) - (3)].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[(1) - (3)].spblock).conds + (yyvsp[(2) - (3)].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[(1) - (3)].spblock).hndlrs + (yyvsp[(2) - (3)].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[(1) - (3)].spblock).curs + (yyvsp[(2) - (3)].spblock).curs;
	  }
    break;

  case 152:
#line 1962 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            lex->sphead->reset_lex(YYTHD);
            lex->spcont->declare_var_boundary((yyvsp[(2) - (2)].num));
          }
    break;

  case 153:
#line 1970 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[(4) - (5)].num);
            Item *dflt_value_item= (yyvsp[(5) - (5)].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[(2) - (5)].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[(2) - (5)].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 154:
#line 2018 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[(2) - (5)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[(2) - (5)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[(2) - (5)].lex_str), (yyvsp[(5) - (5)].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 155:
#line 2032 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[(2) - (4)].num),
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 156:
#line 2047 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[(2) - (7)].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);

	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[(6) - (7)].num);
	    lex->spcont->add_handlers((yyvsp[(6) - (7)].num));
	  }
    break;

  case 157:
#line 2076 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[(2) - (5)].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[(2) - (5)].lex_str).str);
	      delete (yyvsp[(5) - (5)].lex);
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[(5) - (5)].lex),
                                  ctx->current_cursor_count());
	    sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[(2) - (5)].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 158:
#line 2099 "sql_yacc.yy"
    {
	    Lex->sphead->reset_lex(YYTHD);

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 159:
#line 2108 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 160:
#line 2130 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 161:
#line 2131 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 162:
#line 2137 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 163:
#line 2139 "sql_yacc.yy"
    { (yyval.num)+= 1; }
    break;

  case 164:
#line 2144 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler((yyvsp[(1) - (1)].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[(1) - (1)].spcondtype));
	      ctx->push_handler((yyvsp[(1) - (1)].spcondtype));
	    }
	  }
    break;

  case 165:
#line 2167 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[(1) - (1)].ulong_num);
	  }
    break;

  case 166:
#line 2173 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[(3) - (3)].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[(3) - (3)].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 167:
#line 2187 "sql_yacc.yy"
    {}
    break;

  case 168:
#line 2188 "sql_yacc.yy"
    {}
    break;

  case 169:
#line 2193 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[(1) - (1)].spcondtype);
	  }
    break;

  case 170:
#line 2197 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[(1) - (1)].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 171:
#line 2206 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 172:
#line 2211 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 173:
#line 2216 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 174:
#line 2224 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(1) - (1)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[(1) - (1)].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 175:
#line 2239 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(3) - (3)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[(3) - (3)].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[(1) - (3)].num) + 1;
	  }
    break;

  case 176:
#line 2256 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 177:
#line 2257 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(2) - (2)].item); }
    break;

  case 178:
#line 2261 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->reset_lex(thd);
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 179:
#line 2270 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i=new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);

              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lip->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lip->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(thd->mem_root,
                                           sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(thd);
          }
    break;

  case 180:
#line 2311 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 181:
#line 2313 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[(3) - (3)].item),
                                      sp->m_return_field_def.sql_type, lex);
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 182:
#line 2334 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 183:
#line 2336 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 185:
#line 2339 "sql_yacc.yy"
    {}
    break;

  case 186:
#line 2340 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 187:
#line 2346 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 188:
#line 2352 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(2) - (2)].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx);
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2381 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(2) - (2)].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              sp->add_instr(i);
	    }
	  }
    break;

  case 190:
#line 2409 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(2) - (2)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2424 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(3) - (4)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(3) - (4)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 192:
#line 2439 "sql_yacc.yy"
    { }
    break;

  case 193:
#line 2441 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(2) - (2)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
	    sp->add_instr(i);
	  }
    break;

  case 197:
#line 2465 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[(1) - (1)].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2486 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[(3) - (3)].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 199:
#line 2508 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 200:
#line 2510 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[(2) - (3)].item), lex);

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 201:
#line 2524 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);

	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 202:
#line 2535 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 208:
#line 2555 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2561 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[(3) - (3)].item)))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 210:
#line 2572 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 211:
#line 2580 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 212:
#line 2588 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 217:
#line 2606 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2610 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[(3) - (3)].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 219:
#line 2619 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 220:
#line 2627 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2631 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[(3) - (3)].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 222:
#line 2638 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 223:
#line 2646 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            sp->add_instr(i);
          }
    break;

  case 225:
#line 2659 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(1) - (2)].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[(1) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[(1) - (2)].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 226:
#line 2677 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if ((yyvsp[(5) - (5)].lex_str).str)
	    {
	      sp_label_t *lab= lex->spcont->find_label((yyvsp[(5) - (5)].lex_str).str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, (yyvsp[(5) - (5)].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[(5) - (5)].lex_str).str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 227:
#line 2696 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 228:
#line 2697 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 229:
#line 2702 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 230:
#line 2714 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[(3) - (5)].spblock).hndlrs)
	      sp->add_instr(new sp_instr_hpop(sp->instructions(), ctx,
					      (yyvsp[(3) - (5)].spblock).hndlrs));
	    if ((yyvsp[(3) - (5)].spblock).curs)
	      sp->add_instr(new sp_instr_cpop(sp->instructions(), ctx,
					      (yyvsp[(3) - (5)].spblock).curs));
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 231:
#line 2730 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
	  }
    break;

  case 232:
#line 2739 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 233:
#line 2741 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[(3) - (4)].item), lex);

	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 234:
#line 2755 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 235:
#line 2765 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 236:
#line 2767 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[(5) - (7)].item), lab->ip,
                                                               lex);
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 237:
#line 2783 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 238:
#line 2785 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 239:
#line 2790 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 240:
#line 2792 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 241:
#line 2794 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 242:
#line 2798 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2799 "sql_yacc.yy"
    {}
    break;

  case 244:
#line 2801 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[(2) - (2)].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 245:
#line 2807 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[(3) - (4)].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 246:
#line 2815 "sql_yacc.yy"
    {}
    break;

  case 247:
#line 2816 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 248:
#line 2816 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2820 "sql_yacc.yy"
    {}
    break;

  case 250:
#line 2822 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 251:
#line 2822 "sql_yacc.yy"
    {}
    break;

  case 252:
#line 2824 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 253:
#line 2824 "sql_yacc.yy"
    {}
    break;

  case 254:
#line 2829 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 255:
#line 2845 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 256:
#line 2849 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 257:
#line 2859 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2860 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2863 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2864 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2867 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2868 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2871 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2872 "sql_yacc.yy"
    {}
    break;

  case 265:
#line 2875 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 266:
#line 2876 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[(1) - (1)].num);}
    break;

  case 267:
#line 2879 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[(1) - (1)].num); }
    break;

  case 268:
#line 2880 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[(1) - (2)].num) | (yyvsp[(2) - (2)].num); }
    break;

  case 269:
#line 2883 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 270:
#line 2886 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 271:
#line 2887 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 279:
#line 2903 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[(3) - (3)].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2904 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[(3) - (3)].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 281:
#line 2905 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 282:
#line 2906 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 283:
#line 2907 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[(3) - (3)].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 284:
#line 2908 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[(3) - (3)].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 285:
#line 2909 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[(3) - (3)].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 286:
#line 2910 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 287:
#line 2912 "sql_yacc.yy"
    {
            switch((yyvsp[(3) - (3)].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2927 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 289:
#line 2932 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[(3) - (3)].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 290:
#line 2933 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[(3) - (3)].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 291:
#line 2934 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[(3) - (3)].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 292:
#line 2936 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 293:
#line 2941 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 294:
#line 2946 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 295:
#line 2951 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 298:
#line 2967 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[(3) - (3)].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 299:
#line 2968 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[(4) - (4)].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 300:
#line 2969 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[(4) - (4)].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 301:
#line 2970 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[(3) - (3)].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[(3) - (3)].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 302:
#line 2975 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[(4) - (4)].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[(4) - (4)].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[(4) - (4)].charset)->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[(4) - (4)].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 2992 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[(4) - (4)].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[(4) - (4)].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[(4) - (4)].charset)->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[(4) - (4)].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 304:
#line 3008 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[(1) - (1)].lex_str).str,(yyvsp[(1) - (1)].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 305:
#line 3017 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 306:
#line 3018 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 307:
#line 3019 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 308:
#line 3020 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 309:
#line 3021 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 310:
#line 3022 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 311:
#line 3025 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 312:
#line 3026 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 313:
#line 3027 "sql_yacc.yy"
    { (yyval.ulong_num)=(yyvsp[(1) - (1)].ulong_num);}
    break;

  case 314:
#line 3030 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_DISABLED; }
    break;

  case 315:
#line 3031 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_FIRST; }
    break;

  case 316:
#line 3032 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_LAST; }
    break;

  case 317:
#line 3035 "sql_yacc.yy"
    {}
    break;

  case 319:
#line 3039 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_FUNCTION; }
    break;

  case 320:
#line 3040 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_AGGREGATE; }
    break;

  case 321:
#line 3043 "sql_yacc.yy"
    {(yyval.num) = (int) STRING_RESULT; }
    break;

  case 322:
#line 3044 "sql_yacc.yy"
    {(yyval.num) = (int) REAL_RESULT; }
    break;

  case 323:
#line 3045 "sql_yacc.yy"
    {(yyval.num) = (int) DECIMAL_RESULT; }
    break;

  case 324:
#line 3046 "sql_yacc.yy"
    {(yyval.num) = (int) INT_RESULT; }
    break;

  case 330:
#line 3061 "sql_yacc.yy"
    {
#ifdef ENABLE_SENNA
            Lex->senna_clear();
#endif /* ENABLE_SENNA */
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 3071 "sql_yacc.yy"
    {
            LEX *lex=Lex;
#ifdef ENABLE_SENNA
            Key *key= new Key((yyvsp[(1) - (6)].key_type),(yyvsp[(2) - (6)].simple_string), (yyvsp[(3) - (6)].key_alg), 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key((yyvsp[(1) - (6)].key_type), (yyvsp[(2) - (6)].simple_string), (yyvsp[(3) - (6)].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
            lex->col_list.empty();              /* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 3085 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= (yyvsp[(3) - (7)].simple_string) ? (yyvsp[(3) - (7)].simple_string):(yyvsp[(1) - (7)].simple_string);
#ifdef ENABLE_SENNA
            Key *key= new Key((yyvsp[(2) - (7)].key_type), key_name, (yyvsp[(4) - (7)].key_alg), 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key((yyvsp[(2) - (7)].key_type), key_name, (yyvsp[(4) - (7)].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 333:
#line 3100 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            const char *key_name= (yyvsp[(4) - (8)].simple_string) ? (yyvsp[(4) - (8)].simple_string) : (yyvsp[(1) - (8)].simple_string);
            Key *key= new foreign_key(key_name, lex->col_list,
                                      (yyvsp[(8) - (8)].table),
                                      lex->ref_list,
                                      lex->fk_delete_opt,
                                      lex->fk_update_opt,
                                      lex->fk_match_option);
            lex->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, key_name,
                         HA_KEY_ALG_UNDEF, 1,
                         lex->col_list);
            lex->alter_info.key_list.push_back(key);
#ifdef ENABLE_SENNA
            lex->senna_clear();
#endif /* ENABLE_SENNA */
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 334:
#line 3120 "sql_yacc.yy"
    {
#ifdef ENABLE_SENNA
            Lex->senna_clear();
#endif /* ENABLE_SENNA */
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 335:
#line 3127 "sql_yacc.yy"
    {
#ifdef ENABLE_SENNA
            Lex->senna_clear();
#endif /* ENABLE_SENNA */
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 339:
#line 3145 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 340:
#line 3146 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[(1) - (1)].simple_string); }
    break;

  case 341:
#line 3150 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[(2) - (2)].simple_string); }
    break;

  case 342:
#line 3155 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 343:
#line 3163 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, (yyvsp[(1) - (4)].lex_str).str,
				(enum enum_field_types) (yyvsp[(3) - (4)].num),
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    MYSQL_YYABORT;
	}
    break;

  case 344:
#line 3176 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[(1) - (3)].num); }
    break;

  case 345:
#line 3177 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[(1) - (3)].num); }
    break;

  case 346:
#line 3178 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_FLOAT; }
    brea