/* Copyright (C) 2000-2001, 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/*
  Rename a table
*/

#include "fulltext.h"

int mi_rename(const char *old_name, const char *new_name)
{
  char from[FN_REFLEN],to[FN_REFLEN];
#ifdef USE_RAID
  uint raid_type=0,raid_chunks=0;
#endif
  DBUG_ENTER("mi_rename");

#ifdef EXTRA_DEBUG
  check_table_is_closed(old_name,"rename old_table");
  check_table_is_closed(new_name,"rename new table2");
#endif
#ifdef USE_RAID
  {
    MI_INFO *info;
    if (!(info=mi_open(old_name, O_RDONLY, 0)))
      DBUG_RETURN(my_errno);
    raid_type =      info->s->base.raid_type;
    raid_chunks =    info->s->base.raid_chunks;
    mi_close(info);
  }
#ifdef EXTRA_DEBUG
  check_table_is_closed(old_name,"rename raidcheck");
#endif
#endif /* USE_RAID */

#ifdef ENABLE_SENNA /* nkjm modified 2007/06/04 SFID:10291 */
  {
    int i, j;
    MI_INFO *mi_info;
    int senna_indexes[MAX_INDEXES];
    
    if (!(mi_info = mi_open(old_name, O_RDONLY, 0)))
    {
      SEN_LOG(sen_log_warning, "mi_rename => cannot get MI_INFO");
      DBUG_RETURN(my_errno);
    }
    for (i = 0, j = 0; i < mi_info->s->base.keys; i++)
      if (mi_info->s->keyinfo[i].senna)
	senna_indexes[j++] = i;
    mi_close(mi_info);
    for (i = 0; i < j; i++)
    {
      my_snprintf(from, FN_REFLEN, "%s.%03d", old_name, senna_indexes[i]);
      my_snprintf(to, FN_REFLEN, "%s.%03d", new_name, senna_indexes[i]);
      SEN_LOG(sen_log_notice, "mi_rename => sen_index_rename: from=%s, to=%s", from, to);
      sen_index_rename(from, to);
    }
  }
#endif /* ENABLE_SENNA */
  fn_format(from,old_name,"",MI_NAME_IEXT,4);
  fn_format(to,new_name,"",MI_NAME_IEXT,4);
  if (my_rename_with_symlink(from, to, MYF(MY_WME)))
    DBUG_RETURN(my_errno);
  fn_format(from,old_name,"",MI_NAME_DEXT,4);
  fn_format(to,new_name,"",MI_NAME_DEXT,4);
#ifdef USE_RAID
  if (raid_type)
    DBUG_RETURN(my_raid_rename(from, to, raid_chunks, MYF(MY_WME)) ? my_errno :
		0);
#endif
  DBUG_RETURN(my_rename_with_symlink(from, to,MYF(MY_WME)) ? my_errno : 0);
}
