<?php
/*
 * Ajax Chat for TRPG ver.1.3
 * (c)2007 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';

// HTML出力
print html_header(TITLE, 'index', true, true);

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';
require_once './lib/js/index-js.php';
 ?>
<script type="text/javascript">
<!--

//変数の設定
var noname = '<?php print $noname; ?>';
var writescript = './write.php';
var now_member = '<?php print $now_member; ?>';
var pc_num = '<?php print $pc_num; ?>';
var pc_show = '<?php print $pc_show; ?>';
var pc_hide = '<?php print $pc_hide; ?>';

// 起動時の処理
$(function(){
    //表示系
        // フォームON/OFF
    document.getElementById("name_on").disabled = true;
    document.getElementById("pwd_on").disabled = true;
    document.getElementById("whisper_to").disabled = true;
    $("#online1").hide();
    $("#online2").hide();

    //ログイン
    $("#login").click(function(){

        //入力チェック
        var name = $("#name_off").attr("value");
        if (!name || name == noname) {
            alert("お名前を入力してください。");
            return false;
        }
        //現在の入室者と同じ名前ではログインできない
        if (isMember(name)==true) {
            alert("現在の参加者と同じ名前ではログインできません。");
            return false;
        }

        //データ成形
        var params =
            '?n='+convert(name)//名前
            +'&s='+'0';//状態表示
        if($("#pwd_off").attr("value")) {
            var pwd = $("#pwd_off").attr("value");
            if(pwd) {
                var params =
                params+'&p='+convert(pwd);//PWD
            }
        } else {
            var pwd = "";
        }
        var params =
            params+'&y=in'
            +'&e='+(new Date()).getTime();//cacheの更新

        writeComment(params);

        //フォームチェンジ
        $("#online1").show();
        $("#online2").show();
        $("#offline").hide();
        document.getElementById("name_on").value = name;
        document.getElementById("pc_name_0").value = name;
        document.getElementById("pwd_on").value = pwd;
        document.getElementById("pc_input_0").focus();

        // 更新
        window.mainframe.login();
    });


    //ログアウト
    $("#logout").click(function(){

        //データ成形
        var name = convert($("#name_on").attr("value"));
        var params =
            '?n='+name//名前
            +'&s='+'0'//状態表示
        if($("#pwd_on").attr("value")) {
            var params =
            params
            +'&p='+convert($("#pwd_on").attr("value"));//PWD
        }
        var params =
            params+'&y=out'
            +'&e='+(new Date()).getTime();//cacheの更新

        writeComment(params);

        //フォームチェンジ
        $("#online1").hide();
        $("#online2").hide();
        $("#offline").show();
        $(".status_column").hide();
        $(".add_pc").hide();
        $(".show_status").each(function(){
            this.checked = false;
        });
        document.getElementById("whisper_to").value = "全員";
        document.getElementById("whisper_to_hash").value = "";
        document.getElementById("pwd_on").value = "";
        document.getElementById("my_hash").value = "";
        document.getElementById("name_off").focus();

        // タイマー更新
        window.mainframe.logout();

    });

        // ウィンドウサイズに合わせる
    changeSize();//

});

//-->
</script>
</head>
<body onresize="changeSize()" onunload="return UnLoad()">
<table border="0" cellspacing="3" cellpadding="0" id="online1" class="online">
<tr>
<td class="nodisplay">
<form id="chat_on" name="chat_on" onsubmit="return false;" action="">
<input type="hidden" name="name_on" value="" size="10" id="name_on">
<input type="hidden" name="pwd_on" size="4" id="pwd_on">
<input type="hidden" name="my_hash" value="" id="my_hash">
</td>
<?php
if (DICE_MAX != "0" && $preset_dice[0]) {
    print '<td>';
    print '<select name="dice" id="dice">'."\n";
    foreach ($preset_dice as $v) {
         print '<option value="'.$v.'">'.$v.'</option>'."\n";
    }
    print '</select></td>'."\n";
    print '<td> + </td>'."\n";
    print '<td>';
    print '<input type="text" size="6" value="" name="revision" id="revision" />';

    print '</td>'."\n";
    if (DICE_MAX != '0' && $preset_dice[0]) {
        print '<td>';
        print '<input type="image" id="dice" class="btn" src="'.$dice_icon.'" alt="ダイス" title="ダイスを入力します。" onclick="insertDice(this.form, columnId);">';
        print '</td>'."\n";
    }
}

if ($allow_tag && $tags && $show_tag_icon) {
    foreach ($tags as $v) {
        if ($v['show_icon']) {
            print '<td>';
            print '<input type="image" class="btn" src="./image/word_font_'.$v['tag'].'.gif" alt="'.$v['name'].'" title="'.$v['name'].'タグ" onclick=\'insertTag("'.$v['tag'].'", columnId);\'>'."\n";
            print '</td>'."\n";
        }
    }
    print '<td>';
    print '<input type="image" class="btn" src="'.$word_font_f.'" alt="Ｆ" title="フォントタグ" onclick=\'insertFontTag(columnId);\'>'."\n";
    print '</td>'."\n";
}
?>

<td><span id="whisper_to_msg" style="display:inline;"> <img name="whisper" title="クリックで「ささやき」を解除します。" src="<?php print $whisper; ?>" alt="ささやき解除" align="bottom" hspace="1" vspace="0" border="0" onclick='document.getElementById("whisper_to").value="全員", document.getElementById("whisper_to_hash").value="", document.getElementById("whisper_mark").src="<?php print $whisper_off; ?>"'></td>
<td><img id="whisper_mark" title="「ささやき」状態" src="<?php print $whisper_off; ?>" align="bottom" hspace="1" vspace="0" border="0"></span></td>
<td><input type="text" name="whisper_to" value="全員" size="10" class="inputname" id="whisper_to" style="display:inline;">
<input type="hidden" name="whisper_to_hash" value="" id="whisper_to_hash"></td>
<td><input type="image" id="refresh" class="btn" src="<?php print $reload_icon; ?>" alt="リフレッシュ" title="リフレッシュ" onclick="window.mainframe.clearLog()"></td>

<?php
if ($cookie_expire_time) {
//    print '<td><input type="image" id="reload" class="btn" src="'.$cookie_write_icon.'" alt="CookieON" title="現在の設定をクッキーに保管します。" onclick="cookieWrite('.$cookie_expire_time.', \''.$cooie_name.'\')"></td>'."\n";
//    print '<td><input type="image" id="reload" class="btn" src="'.$cookie_delete_icon.'" alt="CookieDelete" title="現在の設定を保管したクッキーを削除します。" onclick="window.mainframe.location.reload()"></td>'."\n";
}
?>
<td align="right" id="logoutBt"><input type="button" value="退室" name="logout" class="btn logout" id="logout" /></td>
<td class="nodisplay"></form></td>
</tr>
</table>
<table border="0" cellspacing="3" cellpadding="0" id="online2" class="online">
<tr>
<td class="nodisplay"><form onsubmit="return false;"></td>
<td align="left" nowrap><input type="text" name="pc_name" value="" size="8" class="pc_name" id="pc_name_0" style="font-weight: bold;" onblur="selectedColumnId(this, this.form)"></td>
<td><input type="text" name="pc_input" class="input_comment" id="pc_input_0" size="75%" onblur="selectedColumnId(this, this.form)"></td>
<td><input type="submit" value="発言" class="btn" id="submit" style="display:inline" name="submit" onclick="comment(this.form)"></td>
<td><input type="image" class="btn" src="<?php print $pc_status_icon; ?>" alt="状態" title="設定欄をON/OFFします。" onclick="toggleColumn('status_0');"></td>
<?php
if ($pc_num > 1) {
   print '<td><input type="image" id="PC_btn_0" class="btn" src="'.$pc_show.'" alt="PC追加" title="PC欄を追加します。" onclick="toggleColumn(\'pc_1\');"></td><td>&nbsp;</td>';
}
 ?>
</tr>
</table>
<table border="0" cellspacing="3" cellpadding="0" class="status_column" id="status_0" style="display:none;">
<tr>
<td nowrap>名前色</td>
<td id="select_color_0">
<select onChange='changeColor(this, this.form)' style="font-weight: bold;" id="pc_color_select">
<?php colorbox($color_code, "pc_color", ""); ?>
</select>
</td>
<td id="free_color_0" style="display:none;"><input type="text" value="000000" size="12" name="pc_color" id="pc_color_0" style="font-weight: bold;" onkeydown='if(navigator.appName == "Netscape"){key=event.which;}else{key=window.event.keyCode;}' onkeyup='changeColor(this, this.form, key);'></td>
<td><input type="image" class="btn" src="<?php echo $pc_font_icon; ?>" alt="Ｆ" title="クリックで文字色入力方法を変更できます" onclick='toggleColumn("free_color_0");toggleColumn("select_color_0");'></td>
<td nowrap>ステータス:<input type="text" name="status" class="status" value="<?php print $status; ?>" id="pc_status_0" onblur="selectedColumnId(this, this.form)"></td>
<td><input type="checkbox" name="show_status" class="show_status"></td>
<td nowrap> 表示</td>
<td class="nodisplay"></form></td>
</tr>
</table>

<?php
if ($pc_num >= 2) {
    for ($i=1; $i<=$pc_num-1; $i++) {
        print '<table border="0" cellspacing="3" cellpadding="0" id="pc_'.$i.'" class="add_pc" style="display:none;">'."\n";
        print '<tr>'."\n";
        print '<td class="nodisplay"><form onsubmit="return false;"></td>'."\n";
        print '<td align="left" nowrap><input type="text" name="pc_name" value="" size="8" class="pc_name" id="pc_name_'.$i.'" style="font-weight:bold;" onblur="selectedColumnId(this, this.form)"></td>'."\n";
        print '<td><input type="text" name="pc_input" class="input_comment" size="75%" id="pc_input_'.$i.'" onblur="selectedColumnId(this, this.form)">';
        print '</td>'."\n";
        print '<td><input type="submit" value="発言" class="btn" id="submit" style="display:inline" name="submit" onclick="comment(this.form)"></td>'."\n";
        print '<td><input type="image" class="btn" src="'.$pc_status_icon.'" alt="状態" title="ステータス欄をON/OFFします。" onclick="toggleColumn(\'status_';
        print $i;
        print '\');"></td>'."\n";
        print '<td width="20">';
        if ($i != $pc_num-1) {
            print '<input type="image" id="PC_btn_'.$i.'" class="btn" src="'.$pc_show.'" alt="PC欄" title="PC欄を追加します。" onclick="toggleColumn(\'pc_';
            print $i+1;
            print '\');">';
        } else {
            print " ";
        }
        print '</td>'."\n";
        print '<td><input type="image" id="PC_btn_'.$i.'" class="btn" src="'.$pc_hide.'" alt="PC欄" title="PC欄を削除します。" onclick="toggleColumn(\'pc_';
        print $i;
        print '\', \'status_';
        print $i;
        print '\');"></td>'."\n";
        print '</tr>'."\n";
        print '</table>'."\n";
        print '<table border="0" cellspacing="3" cellpadding="0" class="status_column" id="status_'.$i.'" style="display:none;">'."\n";
        print '<tr>'."\n";
        print '<td nowrap>名前色</td>'."\n";
        print '<td id="select_color_'.$i.'">';
        print '<select onChange=\'changeColor(this, this.form)\' style="font-weight: bold;" id="pc_color_select">';
        colorbox($color_code, "pc_color", "");
        print '</select></td>'."\n";
        print '<td id="free_color_'.$i.'" style="display:none;"><input type="text" value="000000" size="12" name="pc_color" id="pc_color_'.$i.'" style="font-weight: bold;" onkeyup="changeColor(this, this.form)"></td>'."\n";
        print '<td><input type="image" class="btn" src="'.$pc_font_icon.'" alt="Ｆ" title="クリックで文字色入力方法を変更できます" onclick=\'toggleColumn("free_color_'.$i.'");toggleColumn("select_color_'.$i.'");\'></td>'."\n";
        print '<td nowrap>ステータス:<input type="text" name="status" class="status" value="'.$status.'" id="pc_status_".$i." onblur="selectedColumnId(this, this.form)"></td>'."\n";
        print '<td><input name="show_status" type="checkbox" class="show_status"></td>'."\n";
        print '<td nowrap> 表示</td>'."\n";
        print '<td class="nodisplay"></form></td>'."\n";
        print '</tr>'."\n";
        print '</table>'."\n";
    }
}
 ?>

<table border="0" cellspacing="3" cellpadding="0" id="offline" style="display:inline;">
<tr>
<td class="nodisplay">
<form id="chat_off" name="chat" onsubmit="return false;" action="">
</td>
<td nowrap>お名前
<input type="text" name="name_off" value="<?php print $noname ?>" size="10" class="inputname" id="name_off">
</td>
<td nowrap>
パスワード<input type="password" name="pwd_off" size="6" class="inputpwd" id="pwd_off">
</td>
<td width="35">
<input type="submit" value="入室" name="login" class="login_btn_area" id="login" />
</td>
<td>
<input type="image" id="reload" class="btn" src="<?php print $reload_icon; ?>" alt="リフレッシュ" title="リフレッシュ" onclick="window.mainframe.location.reload()">
</td>
<td class="nodisplay">
</form>
</td>
<td class="nodisplay">
<form action="<?php print HOME; ?>" target="_self">
</td>
<td>
<input type="image" class="btn" src="<?php print $home_icon; ?>" value="submit" alt="ホーム" title="ホーム">
</td>
<td class="nodisplay">
</form>
</td>
<td class="nodisplay">
<form action="./pastlog_index.php" method="<?php print METHOD; ?>" target="pastlog">

</td>
<td>
<input type="submit" value="過去ログ表示">

</td>
<td class="nodisplay">
</form>
</td>
</tr>
</table>

<iframe src="./main.php" width="100%" frameborder="1" border="1" allowtransparency="true" scrolling="auto" name="mainframe" class="mainframe" style="height:500px;" id="mainframe"></iframe>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">本チャットは、JavaScript が有効な環境でのみ使用可能です</p>
</noscript>

<?php

// フッター
print html_footer();

exit;
 ?>