<?php
/*
 * Ajax Chat for TRPG ver.1.3
 * (c)2007 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：過去ログ用
 *****************/

/*
 * 管理パスワードの照合
 */
function auth() {
    if (!MASTERPASS) {
        error('管理用パスワードが設定されていません。trpgchat-ini.phpの設定を確認してください。');
    }
    @session_name('AjaxChatForTRPG');
    @session_start();
    if($_SESSION['admin_pwd'] != crypt(MASTERPASS, ADMIN_HASH_KEY)) {
         error('パスワードが違います');
    }
}

/*
 * ログの成形
 */
function read_log($logfile, $hash, $d) {
    // ログの読み込み
    $log = array();
    $log = file($logfile);
    if (is_array($log)) {

        // データの成形
        foreach($log as $k => $v) {
            if ($v[0] != 0) {
                $unit = explode("<>", $v);
                $num = $unit[0];
                $name = $unit[1];
                $pc = $unit[2];
                $color = $unit[3];
                $com = $unit[4];
                if ($d) $datetime = date("Y/m/d H:i:s", $unit[5]);
                $host = (MASTERPASS && $hash == MASTERPASS) ? '<!-- '.$unit[6].' -->' : NULL ;
                $whisper_from_pass = $unit[8];
                $whisper_to_name = $unit[9];
                $whisper_to_pass = $unit[10];

                $w = 'n';
                if($unit[9] || $unit[10]) {
                    $w = 'y';
                    if ($hash == MASTERPASS) {
                        $w = 'from';
                    } elseif ($hash == $unit[8]) {
                        $w = 'to';
                    } elseif ($hash == $unit[10]) {
                        $w = 'from';
                    }
                }

                // 行の成形
                if ($num && $w != 'y') {
                    $row[$k] = '<span style="font-weight:bold; color:#'.$color.';" title="'.$name.'">【'.$pc.'】</span>：';
                    if ($w == 'to' || $w == 'from') {
                        $row[$k] .= '<span style="color:#'.COLOR_SYSTEM.'">(';
                        if ($w == 'to') $row[$k] .= $unit[9].'さんへ';
                        if ($w == 'from') $row[$k] .= $unit[2].'さんから';
                        $row[$k] .= 'のささやき) </span>';
                    }
                    if ($d) $row[$k] .= '<span title="'.$datetime.'">';
                    $row[$k] .= $com;
                    if ($d) $row[$k] .= '</span>';
                    $row[$k] .= $host;
                }
            }
        }
    }
    return $row;
}

/*
 * 指定ディレクトリ内のファイル・ディレクトリ一覧
 */
function get_dir_contents_list($dir, $sort = 'DESC') {
    $file_list = array();
    $dir_list = array();

    $dp = opendir($dir);
    while($str = readdir($dp)) {
        if (is_dir($dir.$str) && $str != '.' && $str != '..') {
            $dir_list[] = $str;
        } elseif (is_file($dir.$str) && $str != 'index.html') {
            $file_list[] = $str;
        }
    }
    closedir($dp);

    // ソート
    if($sort == 'ASC') {
        sort($file_list);
        sort($dir_list);
    } else {
        rsort($file_list);
        rsort($dir_list);
    }

    return array('dirs' => $dir_list, 'files' => $file_list);
}

/*
 * ディレクトリ開閉タグの出力
 */
function print_toggle_dir($id, $dir_name, $child = false, $default = 'close', $title = 'クリックで開閉', $form = 'false', $past = '') {
    print '<div>';
    if ($child) { print "├";}
    if ($form) { print '<input type="radio" name="dir" value="'.$id.'">';};
    print '<span onclick="toggleColumn(\''.$id.$past.'\');toggleColumn(\'icon_'.$id.$past.'_s\');toggleColumn(\'icon_'.$id.$past.'_h\');" title="'.$title.'">';
    print '<image src="'.pastlog_dir_close_icon.'" id="icon_'.$id.$past.'_h"';
    if ($default == 'open') {
        print ' style="display:none;"';
    }
    print '>'.
        '<image src="'.pastlog_dir_open_icon.'" id="icon_'.$id.$past.'_s"';
    if ($default != 'open') {
        print ' style="display:none;"';
    }
    print '>'.
        $dir_name.
        "</span></div>\n";
    print '<div id="'.$id.$past.'"';
    if ($default != 'open') {
        print ' style="display:none;"';
    }
    print ">\n";

}

/*
 * 過去ログファイルリスト表示
 */
function print_pastloglist($files, $dir, $child = false, $form = false) {
    foreach($files as $v) {
        if ($child) { print '│'; }
        print '├';
        if ($form) { print '<input type="checkbox" name="file[]" value="'.$dir.$v.'">';}
        print '<a href="'.$dir.$v.'">'.substr($v, 0, strlen($v)-5)."</a><br>\n";
    }
}

/*
 * 指定ディレクトリ内のファイル・ディレクトリ一覧
 */
function print_pastlog_contents_list($dir, $root_name, $sort = 'DESC', $form = '', $path = '', $past = '', $open_root = 'open', $open_child = 'close', $root_name = 'ルートディレクトリ', $title = 'クリックで開閉') {
    $list = get_dir_contents_list($dir, $sort);
    if ($list['dirs'] || $list['files']) {

        if ($form) {
            print '<form action="'.$path.'" method="'.METHOD.'">'."\n";
            print '<input type="hidden" name="type" value="'.$dir.'">'."\n";
        }

        // ルートディレクトリ
        print_toggle_dir($dir, $root_name, false, $open_root, $title, $form);

        // 子ディレクトリ
        if ($list['dirs'][0]) {
            foreach ($list['dirs'] as $k => $v) {
                $child[$k] = get_dir_contents_list($dir.$v."/", $sort);
                print_toggle_dir($v, $v, true, $open_child, $title, $form, $past);
                if ($child[$k]['files']) {
                    print_pastloglist($child[$k]['files'], $dir.$v.'/', true, $form);
                }
                print "</div>\n";
            }
        }

        // ルートファイル一覧表示
        if ($list['files']) {
            print_pastloglist($list['files'], $dir, false, $form);
        }
        print "</div>\n";

        if ($form) {
            print "<p>\n";
            print '<input type="submit" name="mode" value="削除確認">　';
            print '<input type="submit" name="mode" value="移動"></p>';
            print '<p><input type="text" name="new_filename" value="">.html　';
            print '<input type="submit" name="mode" value="ファイル名変更"><br>ファイル名に使える文字は、半角英数字とハイフン(-)、アンダーバー(_)のみです。<br>
</p>';
            print '<input type="reset">';
            print '</form>'."\n";
        }

    } else {
        print 'ログファイルはありません';
    }
}


/*
 * ファイル･ディレクトリ名チェック
 */
function check_name($name) {
    if (preg_match("/[^0-9a-zA-Z\-_]/", $name)) {
        error('使える文字は、半角英数字とハイフン(-)、アンダーバー(_)のみです。');
    }
}


/*
 * 完了画面表示
 */
function display_finish($title, $msg) {
    print html_header($title, 'main', false, true);
    print "<p>".$msg."</p>";
    print '<form action="./pastlog.php" method="'.METHOD.'">'."\n";
    print '<p><input type="submit" value="戻る"></p>'."\n";
    print '</form>'."\n";
    print html_footer('');
    exit;
}


?>