<?php
/*
 * Ajax Chat for TRPG ver.1.3
 * (c)2007 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/pastlog.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません');
}

// パスワードの照合
auth();

// 過去ログ作成
write_log($past_dir, $master_past_dir, $past_log, $request['datetime'], $request['whisper'], $request['filename']);

if ($request['delete']) {
    // ファイルロック
    $lfp = fopen($lockfile,"w");
    stream_set_write_buffer($lfp, 0);
    flock($lfp,LOCK_EX);

    // 直近の過去ログは表示を残す
    // 行番号を書き換えて保管
    $log = file($recent_log);
    $count_log = count($log);
    $fp = @fopen($recent_log, "w") or die("ログファイルを開けません。");
    if ($log[0]) {
        foreach ($log as $k => $v) {
            $num = $count_log - $k;
            fwrite($fp, preg_replace("/^([0-9]{1,})<>.*/U", "$num<>", $v, 1));
        }
    }
    fclose($fp);

    // 以前の過去ログは全消去
    $fp = fopen($past_log, "w");
    fclose($fp);

    fflush($lfp);
    fclose($lfp);
}

// 過去ログ作成完了
display_finish(TITLE.' 過去ログ作成完了', '過去ログを作成しました');

exit;


/* 関数 */
// 過去ログ作成
function  write_log($past_dir, $master_past_dir, $past_log, $datetime, $whisper, $filename) {
    $log_master = read_log($past_log, MASTERPASS, true);
    if (!$log_master) return false;
    if (!$whisper) {
        $log = read_log($past_log, '', $datetime);
    } else {
        $log = read_log($past_log, MASTERPASS, $datetime);
    }
    if (!$log) return false;

    if (file_exists($past_dir.$filename.".html")) {
        $filename = $filename. "_". time();
    }

    $header = html_header('過去ログ '.$filename, 'pastlog', false, false);
    $header2 = html_header('過去ログ [管理用]'.$filename, 'pastlog', false, false);
    $footer = html_footer();

    $fp = fopen($past_dir.$filename.".html", "w");
    stream_set_write_buffer($fp, 0);
    flock($fp,LOCK_EX);
    fwrite($fp, $header);
    if ($log) {
        fwrite($fp, '<div class="com_row">'."\n");
        foreach ($log as $v) {
            fwrite($fp, $v."<br>\n");
        }
        fwrite($fp, '</div>'."\n");
    }
    fwrite($fp, '<hr>');
    fwrite($fp, $footer);
    fflush($fp);
    fclose($fp);

    $fp2 = fopen($master_past_dir.$filename.".html", "w");
    stream_set_write_buffer($fp2, 0);
    flock($fp2,LOCK_EX);
    fwrite($fp2, $header2);
    if ($log_master) {
        fwrite($fp2, '<div class="com_row">'."\n");
        foreach ($log_master as $v) {
            fwrite($fp2, $v."<br>\n");
        }
        fwrite($fp2, '</div>'."\n");
    }
    fwrite($fp2, '<hr>');
    fwrite($fp2, $footer);
    fflush($fp2);
    fclose($fp2);

}
?>