<?php
/*
 * Ajax Chat for TRPG ver.1.3
 * (c)2007 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません');
}

// パスワードの照合
auth();

if ($request['type'] == 'public') {
    $dir = $past_dir;
} elseif ($request['type'] == 'admin') {
    $dir = $master_past_dir;
} else {
    error('データが正しく送信されていません。');
}

$type = $request['type'];

if (!$request['filename'][0]) {
    error('ファイルを指定してください。');
}

print html_header(TITLE.' 過去ログ削除確認', 'main', false, true);

print '<h2>削除確認</h2>'."\n";
print '<p><font color="#FF0000">以下の過去ログを削除します。よろしいですか？</font></p>'."\n";
print '<form action="./pastlog.php" method="'.METHOD.'">'."\n";
print '<input type="hidden" name="mode" value="delete_log">'."\n";
print '<input type="hidden" name="type" value="'.$type.'">'."\n";
print '<ul>'."\n";
foreach ($request['filename'] as $k => $v) {
    print '<li><input type="hidden" name="filename[]" value="'.$v.'"> <a href="'.$dir.$v.'" target="admin_past">'.$v.'</a></li>'."\n";
}
print '</ul>'."\n";
print '<p><input type="submit" value="削除する"></p>'."\n";
print '</form>'."\n";
print html_footer('');
exit;

?>