<?php
/*
 * Ajax Chat for TRPG ver.1.3
 * (c)2007 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：共通
 *****************/

/* リクエストを取得 */
function request() {
    if (!strcasecmp(METHOD, 'GET')) {
        $request = $_GET;
    } elseif (!strcasecmp(METHOD, 'POST')) {
        $request = $_POST;
    }
    return $request;
}

/* 設定ファイル個別読み込み */
function read_config_one($configfile) {
    // ファイルロック
    $lfp = fopen(LOCK,"w");
    stream_set_write_buffer($lfp, 0);
    flock($lfp,LOCK_EX);

    $fp = @fopen($configfile, "r") or error("設定ファイルを開けません。");
    $lines = file($configfile);

    fflush($lfp);
    fclose($lfp);
    return $lines;
}

/* 全設定ファイル読み込み */
function read_config() {
    return array_merge(read_config_one(CONFIG_IMPORTANT), read_config_one(CONFIG_TAG), read_config_one(CONFIG_TRPG), read_config_one(CONFIG_BASE_COLOR), read_config_one(CONFIG_MAIN_COLOR), read_config_one(CONFIG_MAIN), read_config_one(CONFIG_ICON));
}

/* 設定を変数にセット */
// 0設定項目名,1備考,2変数名,3変数(0)/配列(1)/2次元配列(2),4入力形式(0:INPUT,1:TEXTAREA,2:radio[YES/NO]),5プレビュータイプ,6-設定内容
// 編集画面ではセット名を若干変更する
function set_config($lines, $editmode = false){
    if (!$lines) error ("設定データがありません");

    foreach ($lines as $v1) {
        $v1 = rtrim($v1);
        if ($v1) {
            $config = explode("<>", $v1);
            if ($config[2]) {
                if ($editmode) {
                    $name = $config[2]."_EDIT";
                } else {
                    $name = $config[2];
                }
                // 変数の場合：セット
                if ($config[3] == 0) {
                    define($name, $config[6]);
                } else {
                    // 配列の場合
                    // 2次元配列の場合
                    if($config[3] >= 2) {
                        $GLOBALS['AJAX_CHAT_TRPG'][$name] = array();
                        for ($i=0;$i<=count($config)-7;$i++) {
                            $GLOBALS['AJAX_CHAT_TRPG'][$name][] = explode("</>", $config[$i+6]);
                        }
                    // 1次元配列の場合
                    } else {
                        $GLOBALS['AJAX_CHAT_TRPG'][$name] = explode("</>", $config[6]);
                    }
                }
            }
        } else {
           error(設定ファイルが不正です);
        }
    }
}


/* 色選択出力 */
function colorbox($id, $select=''){
    $color_list = array();
    foreach ($GLOBALS['AJAX_CHAT_TRPG']['COLOR_CODE'] as $k1 => $v1) {
        foreach ($GLOBALS['AJAX_CHAT_TRPG']['COLOR_CODE'] as $v2) {
            foreach ($GLOBALS['AJAX_CHAT_TRPG']['COLOR_CODE'] as $v3) {
                $color_list[] = $v1.$v2.$v3;
            }
        }
    }
    array_unique($color_list);
    sort($color_list);
    foreach ($color_list as $k => $v) {
        print'<option value="'.$v.'" style="color: #'.$v.';"';
        if ($select == $v) { print ' selected';}
        print '>#'.$v.'</option>'."\n";
    }
}

/* ヘッター */
function html_header($title, $window = false, $js = true, $no_cache = true) {
    $header = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'."\n";
    $header .= '<html>'."\n";
    $header .= '<head>'."\n";
    $header .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">'."\n";
    $header .= '<meta http-equiv="Content-Style-Type" content="text/css" />'."\n";
    if ($js) {
        $header .= '<meta http-equiv="Content-Script-Type" content="text/javascript" />'."\n";
    }
    if ($no_cache) {
        $header .= '<meta http-equiv="Pragma" content="no-cache">'."\n";
        $header .= '<meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">'."\n";
        $header .= '<meta http-equiv="Expires" content="Thu, 01 Feb 2007 00:00:00 GMT">'."\n";
    }

    // css
    if ($window == 'pastlog') {
        $header .= '<link rel="stylesheet" type="text/css" href="../css/trpgchat.css">'."\n";
    } else {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/trpgchat.css">'."\n";
    }
    if ($window == 'index') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/index.css">'."\n";
    } elseif ($window == 'main' || $window == 'admin') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/main.css">'."\n";
    } elseif ($window == 'pastlog') {
        $header .= '<link rel="stylesheet" type="text/css" href="../css/main.css">'."\n";
    }
    if ($window == 'admin' || $window == 'edit_config') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/admin.css">'."\n";
    }

    // 管理機能からの設定
    $header .= '<style type="text/css">'."\n";
    $header .= '<!--'."\n";
    $header .= 'body {'."\n";
    if ($window == 'main') {
        $header .= '    color: #'.MAIN_TEXTCOLOR.';'."\n";
        if (MAIN_BGCSS) {
            $header .= '    background: '.MAIN_BGCSS."\n";
        } else {
            $header .= '    background-color: #'.MAIN_BGCOLOR.";\n";
            $header .= '    background-image: url('.MAIN_BGIMAGE.');'."\n";
        }
        $header .= '}'."\n";
        $header .= 'a:link {'."\n";
        $header .= '    color: #'.MAIN_LINK.';'."\n";
        if (!MAIN_LINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:visited {'."\n";
        $header .= '    color: #'.MAIN_VLINK.';'."\n";
        if (!MAIN_VLINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:hover {'."\n";
        $header .= '    color: #'.MAIN_HLINK.';'."\n";
        if (!MAIN_HLINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
    } elseif ($window == 'edit_config') {
        $header .= '    color: #'.BASE_TEXTCOLOR_EDIT.';'."\n";
        if (BASE_BGCSS_EDIT) {
            $header .= '    background: '.BASE_BGCSS_EDIT."\n";
        } else {
            $header .= '    background-color: #'.BASE_BGCOLOR_EDIT.";\n";
            $header .= '    background-image: url('.BASE_BGIMAGE_EDIT.');'."\n";
        }
        $header .= '}'."\n";
        $header .= 'a:link {'."\n";
        $header .= '    color: #'.BASE_LINK_EDIT.';'."\n";
        if (!BASE_LINK_UNDERLINE_EDIT) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:visited {'."\n";
        $header .= '    color: #'.BASE_VLINK_EDIT.';'."\n";
        if (!BASE_VLINK_UNDERLINE_EDIT) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:hover {'."\n";
        $header .= '    color: #'.BASE_HLINK_EDIT.';'."\n";
        if (!BASE_HLINK_UNDERLINE_EDIT) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'input, textarea, select {'."\n";
        $header .= '    color: #'.INPUT_TEXTCOLOR_EDIT.';'."\n";
        $header .= '    background-color: #'.INPUT_BGCOLOR_EDIT.";\n";
        if (INPUT_BORDER_CSS_EDIT) {
            $header .= '    border: '.INPUT_BORDER_CSS_EDIT."\n";
        } else {
            $header .= '    border-color: #'.INPUT_BORDER_COLOR_EDIT.";\n";
        }
        $header .= '}'."\n";
        $header .= 'table, td {'."\n";
        if (MAIN_BORDER_EDIT) {
            $header .= '    border: '.MAIN_BORDER_EDIT.";\n";
        } else {
            $header .= '    border-color: #'.MAIN_BORDER_COLOR_EDIT.";\n";
            $header .= "    border-style: solid;\n";
            $header .= "    border-width: 1px;\n";
        }
        $header .= '}'."\n";
    } else {
        $header .= '    color: #'.BASE_TEXTCOLOR.';'."\n";
        if (BASE_BGCSS) {
            $header .= '    background: '.BASE_BGCSS."\n";
        } else {
            $header .= '    background-color: #'.BASE_BGCOLOR.";\n";
            $header .= '    background-image: url('.BASE_BGIMAGE.');'."\n";
        }
        $header .= '}'."\n";
        $header .= 'a:link {'."\n";
        $header .= '    color: #'.BASE_LINK.';'."\n";
        if (!BASE_LINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:visited {'."\n";
        $header .= '    color: #'.BASE_VLINK.';'."\n";
        if (!BASE_VLINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:hover {'."\n";
        $header .= '    color: #'.BASE_HLINK.';'."\n";
        if (!BASE_HLINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'input, textarea, select {'."\n";
        $header .= '    color: #'.INPUT_TEXTCOLOR.';'."\n";
        $header .= '    background-color: #'.INPUT_BGCOLOR.";\n";
        if (INPUT_BORDER_CSS) {
            $header .= '    border: '.INPUT_BORDER_CSS."\n";
        } else {
            $header .= '    border-color: #'.INPUT_BORDER_COLOR.";\n";
        }
        $header .= '}'."\n";
        $header .= '.mainframe {'."\n";
        if (MAIN_BORDER) {
            $header .= '    border: '.MAIN_BORDER.";\n";
        } else {
            $header .= '    border-color: #'.MAIN_BORDER_COLOR.";\n";
        }
        $header .= '}'."\n";
        if($window == 'admin') {
            $header .= 'table {'."\n";
                if (MAIN_BORDER) {
                $header .= '    border: '.MAIN_BORDER.";\n";
            } else {
                $header .= '    border-color: #'.MAIN_BORDER_COLOR.";\n";
                $header .= "    border-style: solid;\n";
                $header .= "    border-width: 1px;\n";
            }
            $header .= '}'."\n";
        }
    }
    $header .= '-->'."\n";
    $header .= '</style>'."\n";
    if ($js) {
        $header .= '<script type="text/javascript" src="./lib/js/jquery.js"></script>'."\n";
    }

    $header .= '<title>'.$title.'</title>'."\n";

    return $header;
}

/* フッター */
function html_footer($copyright = true, $adminlogin = false) {
    $footer = '';
    $footer .= '<table style="width:100%; border-style:none; padding:3px;">
'."\n";
    $footer .= '<tr><td>'."\n";
    if ($adminlogin) {
        $footer .= '<form action="./auth.php" method="'.METHOD.'" target="admin">'."\n";
        $footer .= '管理画面：<input type="password" name="admin_pwd" size="8" class="inputpwd" value=""><input name="action" type="hidden" value="admin.php"> <input type="image" class="btn sub" src="'.ADMIN_ICON.'"></form>'."\n";
    }
    $footer .= '</td><td align="right" nowrap style="width:350px; border-style:none;">'."\n";
    if ($copyright) $footer .= '<p class="copyright">'.COPYRIGHT.'</p>'."\n";
    $footer .= '</td></tr></table>'."\n";
    $footer .= '</body>'."\n";
    $footer .= '</html>'."\n";

    return $footer;
}

/* エラー表示 */
function error($msg) {
    print html_header('エラー', 'admin', false, false);
    print "</head>\n";
    print "<body>\n";
    print '<font color="red">エラー</font><br>'."\n";
    print "<p>".$msg."</p>\n";
    print '<FORM><INPUT TYPE="button" VALUE="戻る" onClick="javascript:history.back()"></FORM>'; 
    print  html_footer();
    exit;
}

/* トリップ生成 */
function create_hash($name,$pwd) {
    //パスワードがなければ中止
    if (!$pwd) {
        return false;
    }
    $key = substr(substr($pwd,1,2)."dummy",0,2);
    $key = strtr($key,':;<=>?@[\]^_`','ABCDEFGabcdef');
    $pwd = substr(crypt($name, $key), -10);

    return $pwd;
}

/* 書き込みブロック */
function write_block() {
    if (!$GLOBALS['AJAX_CHAT_TRPG']['W_BLOCK_IPS']) {
        return false;
    } else {
        foreach ($GLOBALS['AJAX_CHAT_TRPG']['W_BLOCK_IPS'] as $v) {
            if ($v) {
                if (strstr($_SERVER['REMOTE_ADDR'], $v) || strstr(gethostbyaddr($_SERVER['REMOTE_ADDR']), $v) || strstr($_SERVER['REMOTE_HOST'], $v)) error("書きこみできません。");
            }
        }
    }
}

/* アクセスブロック */
function access_block() {
    if (!$GLOBALS['AJAX_CHAT_TRPG']['A_BLOCK_IPS']) {
        return false;
    } else {
        foreach ($GLOBALS['AJAX_CHAT_TRPG']['A_BLOCK_IPS'] as $v) {
            if ($v) {
                if (strstr($_SERVER['REMOTE_ADDR'], $v) || strstr(gethostbyaddr($_SERVER['REMOTE_ADDR']), $v) || strstr($_SERVER['REMOTE_HOST'], $v)) error("接続に失敗しました");
            }
        }
    }
}

?>