<?php
/*
 * Ajax Chat for TRPG ver.2.0
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

/* 発言書込み */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/write.php';
require_once './lib/member_check.php';

// 設定セット
set_config(read_config());

// ユーザの情報
$host = gethostbyaddr($_SERVER['REMOTE_ADDR']);

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// リクエスト受信
if (!$request = request()) {
    error('データを受信できません');
}

// PL名・コメントがなければ書込みはできない(含ロボット対策)
if (!$request['n']) error("書きこみできません");
if (($request['y'] != 'in' && $request['y'] != 'out') && $request['m'] == '') error("書きこみできません。");

// ファイルロック
$lfp = fopen(LOCK,"w");
stream_set_write_buffer($lfp, 0);
flock($lfp,LOCK_EX);

// 既存ファイル内容の格納
$log = array();
$log[] = file(RECENT_LOG);

// 受信データの成形
foreach($request as $k => $v) {
    $data[$k] = htmlspecialchars($v);
}

    // PC名がない場合PL名
if (!$data['c']) $data['c'] = $data['n'];

$ua = getenv("HTTP_USER_AGENT");

    // コメント本文の処理：（予定）ダイス、カード、タグ有効[b,span,i,u]、オートリンク、禁止語句処理など
        // ダイス
if (DICE_MAX != 0) {
    if(preg_match("/(.*)[[]([0-9]{1,})([dD])([0-9]{1,})([-\+\*\/]{0,}[0-9-\+\*\/]{0,})[@]{0,}([c]{0,}[0-9\-]{0,})([f]{0,}[0-9\-]{0,})[\]](.*$)/i", $data['m'], $dice)) {
        $dice_result = dice_convert($dice[2], $dice[4], $dice[5], $dice[6], $dice[7]);
        $data['m'] = $dice[1].$dice_result.$dice[8];
    }
    // SWレーティング表
    if(preg_match("/(.*)[[]([rR])([0-9]{1,2})([-\+\]{0,}[0-9-\+]{0,})[@]([0-9]{1,2})[\]])(.*$)/i", $data['m'], $dice)) {
        $sw_result = sw_1sr($dice[2], $dice[3], $dice[4]);
        $data['m'] = $dice[1].$sw_result.$dice[5];
    }
}
        // オートリンク
if (AUTOLINK) {
    $data['m'] = preg_replace("/((http)|(https)):\/\/[0-9a-zA-Z\+\-\$\;\?\/\.,!#%&=~@*:_]+/i", "<a href=\"$0\" target=\"_blank\">$0</a>", $data['m']);
}

        // HTMLタグ
if(ALLOW_TAG) {
    // fontタグ
    $data['m'] = preg_replace("/&lt;font(\s{1,}size=[1-7\+\-][0-4]{0,}||\s{1,}color=[#]{0,}[0-9a-z]{1,7}||\s{1,}size=[1-7\+\-][0-4]{0,}\s{1,}color=[#]{0,}[0-9a-z]{1,7}||\s{1,}color=[#]{0,}[0-9a-z]{1,7}\s{1,}size=[1-7\+\-][0-4]{0,})&gt;(.*?)&lt;\/font&gt;/i", "<font$1>$2</font>", $data['m']);
    $data['t'] = preg_replace("/&lt;font(\s{1,}size=[1-7\+\-][0-4]{0,}||\s{1,}color=[#]{0,}[0-9a-z]{1,7}||\s{1,}size=[1-7\+\-][0-4]{0,}\s{1,}color=[#]{0,}[0-9a-z]{1,7}||\s{1,}color=[#]{0,}[0-9a-z]{1,7}\s{1,}size=[1-7\+\-][0-4]{0,})&gt;(.*?)&lt;\/font&gt;/i", "<font$1>$2</font>", $data['t']);

    // iniで指定のタグ
    foreach($GLOBALS['AJAX_CHAT_TRPG']['TAGS'] as $t) {
       if ($t[1]) {
           $data['m'] = preg_replace("/&lt;($t[0])&gt;(.*?)&lt;\/$t[0]&gt;/i", "<$1>$2</$1>", $data['m']);
            $data['t'] = preg_replace("/&lt;($t[0])&gt;(.*?)&lt;\/$t[0]&gt;/i", "<$1>$2</$1>", $data['t']);
        }
    }
}

// 既存ログのチェック
if(!is_array($log)){
    $log = array();
} else {
    $stopflag=0;
    foreach ($log[0] as $k => $v){
        $temp[$k] = explode("<>", $v);
    }
}

// 書込み
if($stopflag==0) {

    // 最新ログNO
    if ($temp[0][0]) {
        $last_id = $temp[0][0]+1;
    } else {
        $last_id = 1;
    }

    // 書き込み成形
    $write = "";
        // ログイン
    if ($data['y'] =='in') {
        $pcname = SYSTEM;
        $data['m'] = $data['n'].ONLINE_MSG;
        $data['l'] = COLOR_SYSTEM;
        $data['s'] = 0;
        // ログアウト
    } elseif ($data['y'] == 'out') {
        $pcname = SYSTEM;
        $data['m'] = $data['n'].OFFLINE_MSG;
        $data['l'] = COLOR_SYSTEM;
        $data['s'] = 0;
    } else {
        $pcname = $data['c'];
    }

    if ($data['n'] && $data['p']) {
        $pwd = create_hash($data['n'],$data['p']);
    }

    $write = $last_id."<>".$data['n']."<>".$pcname."<>".$data['l']."<>".$data['m']."<>".time()."<>".$host."<>".$ua."<>".$pwd."<>".$data['w']."<>".$data['h']."<>".$data['s']."<>".$data['t']."<>".$data['a']."\n";

    array_unshift($log[0], $write);

    //最大行数を超えていたら最終行を削除
    if (count($log[0]) >= MAX_NUM) {
        array_pop($log[0]);
    }

    // ログファイル更新
    $fp = @fopen(RECENT_LOG, "w+") or error("ログファイルを開けません。");
    //$bom = "\xef\xbb\xbf";
    //fwrite($fp, $bom);

    foreach($log[0] as $k => $v) {
        fwrite($fp, $v);
    }
    fclose($fp);
}

//直近の過去ログ更新
write_recent_past($write, PAST_LOG);

// ロック解除
fflush($lfp);
fclose($lfp);

//参加者チェッカーに書き込み
member_checker($data['n'], $pwd, $data['y'], NOW_MEMBER, GETDATA_OFF, LOCK2);

exit;

 ?>