<?php
/*
 * Ajax Chat for TRPG ver.2.2
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/member_check.php';

// 設定セット
set_config(read_config());

// アクセスブロック
access_block();

// HTML出力
print html_header(CHAT_TITLE.' ログ表示画面', 'main', true, true);

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';
require_once './lib/js/main-js.php';

// COOKIE読み込み
$cookies = read_cookie();
if (!intval($cookies['fontsize'])) $cookies['fontsize'] = 12;
if (!intval($cookies['linespace'])) $cookies['linespace'] = 0;

 ?>
<script type="text/javascript">
<!--
//変数の設定
var deleteLastPastLog = '<?php print DELETE_LAST_PASTLOG;?>';
var maxNum = '<?php print MAX_NUM;?>';

// 起動時の処理
$(function()
{
    // ウィンドウサイズに合わせる
    changeSize();

    //現在ログの取得
    Timer = setInterval('getLog()', getdata_off);
    if (!publicLastPastlog) {
        clearLog();
    } else {
        clearInterval(Timer);
        $("#main_console").after('<?php (NO_LAST_PASTLOG_MSG);?>');
    }

    showMember();
    // ヘルプの表示
    if (!window.parent.document.getElementById("name_on").value) {
        $("#help").show();
    } else {
        $("#help").hide();
    }

});

//-->
</script>
</head>
<body>
<div class="chatwindow" id="chatwindow">
<table style="border-style:none; width:100%;" id="main_console">
<tr><td>
参加者： <span id="indi"></span>
</td><td style="width:120px; text-align:right; height:20px;" nowrap>
<?php
show_icon(FONT_SIZE_UP, "", "", "", "拡大", "文字を大きくします", "fontSizeChange('2');");
show_icon(FONT_SIZE_DOWN, "", "", "", "縮小", "文字を小さくします", "fontSizeChange('-2');");
show_icon(LINE_SPACE_UP, "", "", "", "広く", "行間隔を広めます", "lineSpaceChange('4');");
show_icon(LINE_SPACE_DOWN, "", "", "", "狭く", "行間隔を狭めます", "lineSpaceChange('-4');");
show_icon(LINE_SPACE_HR, "", "", "", "HR", "発言間に線を引きます", "lineSpaceHrToggle();");
?>
<input type="hidden" value="<?php print $cookies['fontsize']; ?>" id="fontsize">
<input type="hidden" value="<?php print $cookies['linespace']; ?>" id="linespace">
<input id="hr" type="checkbox" style="display:none;" <?php if ($cookies['hr']===true) print " checked"; ?>>
</td></tr></table>

</div>

<?php
if (!(DELETE_LAST_PASTLOG && !PUBLIC_PASTLOG)) print '<div align="right" id="pastlog" class="pastlog"><a href="./pastlog_index.php" target="pastlog">もっと前のログを見る</a></div>';
?>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">本チャットは、JavaScript が有効な環境でのみ使用可能です。</p>
</noscript>

<?php
// フッター
print html_footer('');
 ?>