<?php
/*
 * Ajax Chat for TRPG ver.2.3
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/admin.php';
require_once './lib/config.php';

// パスワードの照合
auth();


// 設定セット
set_config(read_config_one(CONFIG_IMPORTANT));

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// リクエスト受信
if (!$request = request()) {
    error('データを受信できません', true);
}

// 設定読み込み
$lines = config_mode($request['mode']);

if ($request['mode'] =='重要な') {
    $target = CONFIG_IMPORTANT;
} elseif ($request['mode'] == '全般') {
    $target = CONFIG_MAIN;
} elseif ($request['mode'] == 'TRPG機能関連') {
    $target = CONFIG_TRPG;
} elseif ($request['mode'] == 'タグ') {
    $target = CONFIG_TAG;
} elseif ($request['mode'] == '全体の配色') {
    $target = CONFIG_BASE_COLOR;
} elseif ($request['mode'] == 'チャット画面の配色') {
    $target = CONFIG_MAIN_COLOR;
} elseif ($request['mode'] == 'アイコン') {
    foreach ($request as $k => $v) {
        if ($k != 'mode') check_name2($v);
    }
    $target = CONFIG_ICON;
} else {
    error('編集対象が不正です');
}
foreach ($lines as $k1 => $v1) {
    $v1 = rtrim($v1);
    if ($v1) {
        $config = explode("<>", $v1);
        // 更新
        if ($config[2]) {
            $data = "<>";
            // 配列の場合
            if ($config[3] == 1) {
                for ($i=0;$i<count($request[$config[2]]);$i++) {
                     if ($request[$config[2]] && trim($request[$config[2]][$i])) {
                         if ($i!=0) $data .= "</>";
                         $data .= htmlspecialchars($request[$config[2]][$i]);
                      }
                }
            // タグの場合
            } elseif ($config[3] == 2) {
                foreach ($request['tag'] as $k2 => $v2) {
                    if ($k2 != "b") $data .= "<>";
                    $data .= $k2;
                    for ($i=1;$i<count($v2)+1;$i++) {
                         $data .= "</>";
                         $data .= htmlspecialchars($v2[$i]);
                    }
                }
            // 変数設定の場合
            } else {
                if (trim($request[$config[2]])) {
                    // テキストエリアの場合タグ可(<>は変換）、改行コードは<br>に変換
                    if ($config[4] == 1) {
                        $data .= str_replace(array("<>","\n","\r","\l"), array("&lt;&gt;","","",""),  nl2br($request[$config[2]]));
                    } else {
                        $data .= htmlspecialchars(str_replace("\n", "", $request[$config[2]]));
                    }
                } 
            }
            $lines[$k1] = $config[0]."<>".$config[1]."<>".$config[2]."<>".$config[3]."<>".$config[4]."<>".$config[5].$data."\n";
        } else {
            continue;
        }
    } else {
        error('設定ファイルが読みだせません', true);
    }
}

// ファイルロック
$lfp = fopen(LOCK,"w");
stream_set_write_buffer($lfp, 0);
flock($lfp,LOCK_EX);

// ログファイル更新
$fp = @fopen($target, "w") or error("設定ファイルを開けません。", true);

foreach($lines as $v) {
    fwrite($fp, $v);
}
fclose($fp);

// ロック解除
fflush($lfp);
fclose($lfp);

// 管理画面TOPに戻る
$url = str_replace('write_config.php', 'admin.php', 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']).'?msg='.urlencode($request['mode']."設定を変更しました");
header('Location: '. $url);

exit;

?>