<?php
/*
 * Ajax Chat for TRPG ver.2.4
 * (c)2007-2009 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

/* 発言書込み */

// デバッグ用設定
ini_set('log_errors', false);
ini_set('error_log', "./php_error.log");

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/write.php';
require_once './lib/member_check.php';

// 設定セット
set_config(read_config());
if (DICE_MAX != 0) {
    require_once './lib/trpg.php';
}

// ユーザの情報
if (REC_UA) {
    $host = gethostbyaddr($_SERVER['REMOTE_ADDR']);
    $ua = getenv("HTTP_USER_AGENT");
}

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// リクエスト受信
if (!$request = $_GET) {
    error('データを受信できません');
}

// PL名・コメントがなければ書込みはできない(含ロボット対策)
if (!$request['n']) error("書きこみできません");
if (($request['y'] != 'in' && $request['y'] != 'out') && $request['m'] == '') error("書きこみできません。");

// ファイルロック
$lfp = fopen(LOCK,"w");
stream_set_write_buffer($lfp, 0);
flock($lfp,LOCK_EX);

// 既存ファイル内容の格納
$log = array();
$log[] = file(RECENT_LOG);

// 受信データの成形
foreach($request as $k => $v) {
    $data[$k] = htmlspecialchars($v);
}
// PC名がない場合PL名
if (!$data['c']) $data['c'] = $data['n'];

// コメント本文の処理：（予定）ダイス、カード、タグ有効[b,span,i,u]、オートリンク、禁止語句処理など
// ダイス対応
if (DICE_MAX != 0) {
    // コメント欄
    $data['m'] = convert_dice($data['m']);
    // ステータス欄
    if ($data['s'] && $data['t']) {
        $data['t'] = convert_dice($data['t']);
    }
}
// HTMLタグ
$data['m'] = convert_html_tag($data['m']);
if ($data['s'] && $data['t']) {
    $data['t'] = convert_html_tag($data['t']);
}
// オートリンク
$data['m'] = convert_autolink($data['m']);
if ($data['s'] && $data['t']) {
    $data['t'] = convert_autolink($data['t']);
}

// 既存ログのチェック
if(!is_array($log)){
    $log = array();
} else {
    $stopflag=0;
    foreach ($log[0] as $k => $v){
        $temp[$k] = explode("<>", $v);
    }
}

// 書込み
if($stopflag==0) {

    // 最新ログNO
    if ($temp[0][0]) {
        $last_id = $temp[0][0]+1;
    } else {
        $last_id = 1;
    }

    // 書き込み成形
    $write = "";
        // ログイン
    if ($data['y'] =='in') {
        $pcname = SYSTEM;
        $data['m'] = $data['n'].ONLINE_MSG;
        $data['l'] = COLOR_SYSTEM;
        $data['s'] = 0;
        // ログアウト
    } elseif ($data['y'] == 'out') {
        $pcname = SYSTEM;
        $data['m'] = $data['n'].OFFLINE_MSG;
        $data['l'] = COLOR_SYSTEM;
        $data['s'] = 0;
    } else {
        $pcname = $data['c'];
    }

    if ($data['n'] && $data['p']) {
        $pwd = create_hash($data['n'],$data['p']);
    }
    $dm = $data['m'];
    $dn = $data['n'];
    $dw = $data['w'];
    $dh = $data['h'];
    $dt = $data['t'];

    // 難読化
    if (OBFUSCATION) {
        $pcname = obf_xor($pcname);
        $dm = obf_xor($dm);
        $dn = obf_xor($dn);
        if ($dw) $dw = obf_xor($dw);
        if ($dt) $dt = obf_xor($dt);
    }


    $write = $last_id."<>".$dn."<>".$pcname."<>".$data['l']."<>".$dm."<>".time()."<>".$host."<>".$ua."<>".$pwd."<>".$dw."<>".$dh."<>".$data['s']."<>".$dt."<>\n";

    array_unshift($log[0], $write);

    //最大行数を超えていたら最終行を削除
    if (count($log[0]) >= MAX_NUM) {
        array_pop($log[0]);
    }

    // ログファイル更新
    $fp = @fopen(RECENT_LOG, "w+") or error("ログファイルを開けません。", true);
    //$bom = "\xef\xbb\xbf";
    //fwrite($fp, $bom);

    foreach($log[0] as $k => $v) {
        fwrite($fp, $v);
    }
    fclose($fp);
}

//直近の過去ログ更新
write_recent_past($write, PAST_LOG);

// ロック解除
fflush($lfp);
fclose($lfp);

//参加者チェッカーに書き込み
member_checker($dn, $pwd, $request['y'], false);

exit;

?>
