<?php
/*
 * Ajax Chat for TRPG ver.2.4
 * (c)2007-2009 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/pastlog.php';
require_once './lib/member_check.php';

// 設定セット
set_config(read_config());

// アクセスブロック
access_block();

// HTML出力
print html_header(CHAT_TITLE.' 過去ログ', 'main', false);
?>

</head>
<body>
<?php

// 直近の過去ログを「流す」場合
if (DELETE_LAST_PASTLOG) {
    print "現在、直近の過去ログ表示はできません";
    print html_footer('');
    exit;
}

// リクエスト受信
$request = request();

foreach($request as $k => $v) {
    $data[$k] = htmlspecialchars($v);
}

// パスワード照合
$hash = "";
$data['pwd_on'] = isset( $data['pwd_on'] ) ? $data['pwd_on'] : NULL ;
$data['name_on'] = isset( $data['name_on'] ) ? $data['name_on'] : NULL ;
$hash = create_hash($data['name_on'], $data['pwd_on']);
// マスターパスワード
if (MASTERPASS && $data['pwd_on'] == MASTERPASS) {
    $hash = MASTERPASS;
}

// 直近の過去ログを参加者にしか表示しない場合
if (UNPUBLIC_LAST_PASTLOG && $hash != MASTERPASS) {
    $member = get_member_log();
    $flg = false;
    // 参加者が居ない/入力ID:パスワードのハッシュで参加者と一致しない場合、停止
    if (!$member) {
        print "直近の過去ログは、参加者にのみ表示します";
        print html_footer('');
        exit;
    } elseif ($hash) {
        foreach ($member as $v) {
            if ($v[1] == $hash) {
                $flg = true;
            }
        }
    }
    if (!$flg) {
        print "現在のチャット参加者の方は、お名前と参加時のパスワードを入力してください";
        print html_footer('');
        exit;
    }
}

// 「ささやき」は、マスターパスワードと入力ハッシュが合う場合のみ表示
$row = read_log(PAST_LOG, $hash, true, true);

// 発言表示
if ($row) {
    foreach ($row as $v) {
        print $v."\n";
    }
}
 ?>

<?php
// フッター
print html_footer('');
 ?>